/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ripper;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.DefHolder;
import org.jruby.ast.Node;
import org.jruby.ext.ripper.ArgsTailHolder;
import org.jruby.ext.ripper.RubyLexer;
import org.jruby.ext.ripper.StrTerm;
import org.jruby.ext.ripper.SyntaxException;
import org.jruby.lexer.LexerSource;
import org.jruby.lexer.yacc.LexContext;
import org.jruby.lexer.yacc.StackState;
import org.jruby.parser.RubyParserBase;
import org.jruby.parser.ScopedParserState;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CommonByteLists;
import org.jruby.util.RubyStringBuilder;

public class RipperParserBase {
    protected IRubyObject ripper;
    protected ThreadContext context;
    protected RubyLexer lexer;
    protected StaticScope currentScope;
    protected boolean inDefinition;
    protected boolean inClass;
    protected boolean yydebug;
    protected boolean isError;
    protected int inSingleton;
    private ByteList currentArg;
    protected ScopedParserState scopedParserState;
    private Set<ByteList> keyTable;
    private Set<ByteList> variableTable;
    private int maxNumParam = 0;
    private Node numParamCurrent = null;
    private Node numParamInner = null;
    private Node numParamOuter = null;
    public IRubyObject case_labels;
    public static final ByteList NOT = new ByteList(new byte[]{110, 111, 116}, (Encoding)USASCIIEncoding.INSTANCE);

    public RipperParserBase(ThreadContext context, IRubyObject ripper2, LexerSource source2) {
        this.context = context;
        this.ripper = ripper2;
        this.lexer = new RubyLexer(this, source2);
    }

    public void initTopLocalVariables() {
        this.scopedParserState = new ScopedParserState(null);
        this.pushLocalScope();
    }

    public void reset() {
        this.getLexContext().reset();
    }

    public Object yyparse(RubyLexer yyLex) throws IOException {
        return null;
    }

    public Object yyparse(RubyLexer yyLex, Object debugger) throws IOException {
        return null;
    }

    public IRubyObject parse(boolean isDebug) throws IOException {
        this.reset();
        this.lexer.parser_prepare();
        return (IRubyObject)this.yyparse(this.lexer, null);
    }

    public IRubyObject arg_add_optblock(IRubyObject arg1, IRubyObject arg2) {
        if (arg2 == null) {
            return this.dispatch("on_args_add_block", arg1, this.getRuntime().getFalse());
        }
        if (arg2.isNil()) {
            return arg1;
        }
        return this.dispatch("on_args_add_block", arg1, arg2);
    }

    public RubyString arg_var(ByteList byteName) {
        this.numparam_name(byteName);
        this.getCurrentScope().addVariableThisScope(this.symbolID(byteName).idString());
        return this.getRuntime().newString(byteName);
    }

    public IRubyObject assignableConstant(IRubyObject value2) {
        if (this.isInDef()) {
            this.error();
            value2 = this.dispatch("on_assign_error", value2);
        }
        return value2;
    }

    public IRubyObject assignableIdentifier(IRubyObject value2) {
        String ident = this.lexer.getIdent().intern();
        this.getCurrentScope().assign(this.lexer.getRubySourceline(), this.context.runtime.newSymbol(ident, this.lexer.getEncoding()), null);
        return value2;
    }

    public IRubyObject dispatch(String method_name) {
        return Helpers.invoke(this.context, this.ripper, method_name);
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1) {
        return Helpers.invoke(this.context, this.ripper, method_name, this.escape(arg1));
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1, IRubyObject arg2) {
        return Helpers.invoke(this.context, this.ripper, method_name, this.escape(arg1), this.escape(arg2));
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return Helpers.invoke(this.context, this.ripper, method_name, this.escape(arg1), this.escape(arg2), this.escape(arg3));
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4) {
        return Helpers.invoke(this.context, this.ripper, method_name, this.escape(arg1), this.escape(arg2), this.escape(arg3), this.escape(arg4));
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5) {
        return Helpers.invoke(this.context, this.ripper, method_name, this.escape(arg1), this.escape(arg2), this.escape(arg3), this.escape(arg4), this.escape(arg5));
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7) {
        return Helpers.invoke(this.context, this.ripper, method_name, this.escape(arg1), this.escape(arg2), this.escape(arg3), this.escape(arg4), this.escape(arg5), this.escape(arg6), this.escape(arg7));
    }

    public IRubyObject escape(IRubyObject arg2) {
        return arg2 == null ? this.context.nil : arg2;
    }

    IRubyObject new_nil_at() {
        return this.context.nil;
    }

    private IRubyObject param_error(String message2, IRubyObject lhs) {
        this.error();
        return this.dispatch("on_param_error", lhs);
    }

    public IRubyObject formal_argument(ByteList identifier, IRubyObject lhs) {
        RubyParserBase.IDType type2 = RubyParserBase.id_type(identifier);
        switch (type2) {
            case Constant: {
                return this.param_error("formal argument cannot be a constant", lhs);
            }
            case Instance: {
                return this.param_error("formal argument cannot be an instance variable", lhs);
            }
            case Global: {
                return this.param_error("formal argument cannot be a global variable", lhs);
            }
            case Class: {
                return this.param_error("formal argument cannot be a class variable", lhs);
            }
        }
        this.shadowing_lvar(identifier);
        return lhs;
    }

    protected void getterIdentifierError(ByteList identifier) {
        throw new SyntaxException("identifier " + identifier + " is not valid", this.getRuntime().newString(identifier).asJavaString());
    }

    public boolean id_is_var(ByteList value2) {
        if (value2 == null) {
            return false;
        }
        RubyParserBase.IDType type2 = RubyParserBase.id_type(value2);
        switch (type2) {
            case Constant: 
            case Instance: 
            case Global: 
            case Class: {
                return true;
            }
        }
        String id2 = this.getRuntime().newSymbol(value2).idString();
        if (this.currentScope.isBlockScope() && this.isNumParamId(id2)) {
            return true;
        }
        return this.getCurrentScope().isDefined(id2) >= 0;
    }

    public IRubyObject intern(String value2) {
        return this.context.runtime.newSymbol(value2);
    }

    public IRubyObject intern(ByteList value2) {
        return this.context.runtime.newSymbol(value2);
    }

    protected IRubyObject new_defined(long _line, IRubyObject value2) {
        return this.dispatch("on_defined", value2);
    }

    public IRubyObject new_regexp(int line, IRubyObject contents, IRubyObject end2) {
        return this.dispatch("on_regexp_literal", contents, end2);
    }

    protected IRubyObject match_op(IRubyObject left2, IRubyObject right) {
        return this.call_bin_op(left2, CommonByteLists.EQUAL_TILDE, right, 0);
    }

    protected IRubyObject call_bin_op(IRubyObject left2, IRubyObject id2, IRubyObject right, int line) {
        if (id2 instanceof RubyString) {
            id2 = this.intern(((RubyString)id2).getByteList());
        }
        return this.dispatch("on_binary", left2, id2, right);
    }

    protected IRubyObject call_bin_op(IRubyObject left2, ByteList id2, IRubyObject right, int line) {
        return this.dispatch("on_binary", left2, this.intern(id2), right);
    }

    protected IRubyObject call_uni_op(IRubyObject recv2, IRubyObject id2) {
        return this.dispatch("on_unary", id2, recv2);
    }

    protected IRubyObject call_uni_op(IRubyObject recv2, ByteList id2) {
        return this.call_uni_op(recv2, this.intern(id2));
    }

    protected IRubyObject logop(IRubyObject left2, ByteList id2, IRubyObject right) {
        return this.call_bin_op(left2, this.intern(id2), right, -1);
    }

    public Set<ByteList> push_pvtbl() {
        Set<ByteList> currentTable = this.variableTable;
        this.variableTable = new HashSet<ByteList>();
        return currentTable;
    }

    protected void pop_pvtbl(Set<ByteList> table) {
        this.variableTable = table;
    }

    protected Set<ByteList> push_pktbl() {
        Set<ByteList> currentTable = this.keyTable;
        this.keyTable = new HashSet<ByteList>();
        return currentTable;
    }

    protected void pop_pktbl(Set<ByteList> table) {
        this.keyTable = table;
    }

    public Node numparam_push() {
        Node inner = this.numParamInner;
        if (this.numParamOuter == null) {
            this.numParamOuter = this.numParamCurrent;
        }
        this.numParamInner = null;
        this.numParamCurrent = null;
        return inner;
    }

    public void numparam_pop(Node previousInner) {
        if (previousInner != null) {
            this.numParamInner = previousInner;
        } else if (this.numParamCurrent != null) {
            this.numParamInner = this.numParamCurrent;
        }
        if (this.maxNumParam > 0) {
            this.numParamCurrent = this.numParamOuter;
            this.numParamOuter = null;
        } else {
            this.numParamCurrent = null;
        }
    }

    public int resetMaxNumParam() {
        return this.restoreMaxNumParam(0);
    }

    public int restoreMaxNumParam(int maxNum) {
        int temp = this.maxNumParam;
        this.maxNumParam = maxNum;
        return temp;
    }

    public void ordinalMaxNumParam() {
        this.maxNumParam = -1;
    }

    protected int src_line() {
        return this.lexer.getRubySourceline();
    }

    protected IRubyObject value_expr(IRubyObject value2) {
        return value2;
    }

    private String assignableCheckValid(RubySymbol name2) {
        String id2;
        switch (id2 = name2.idString()) {
            case "self": {
                return "Can't change the value of self";
            }
            case "nil": {
                return "Can't assign to nil";
            }
            case "true": {
                return "Can't assign to true";
            }
            case "false": {
                return "Can't assign to false";
            }
            case "__FILE__": {
                return "Can't assign to __FILE__";
            }
            case "__LINE__": {
                return "Can't assign to __LINE__";
            }
            case "__ENCODING__": {
                return "Can't assign to __ENCODING__";
            }
        }
        RubyParserBase.IDType type2 = RubyParserBase.id_type(name2.getBytes());
        switch (type2) {
            case Local: {
                if (!this.currentScope.isBlockScope() || this.maxNumParam <= 0 || !this.isNumParamId(id2)) break;
                return "Can't assign to numbered parameter " + id2;
            }
            case Constant: {
                if (!this.isInDef()) break;
                return "dynamic constant assignment";
            }
        }
        return null;
    }

    protected IRubyObject assignable(ByteList name2, IRubyObject value2) {
        RubySymbol symbol = this.getRuntime().newSymbol(name2);
        String error2 = this.assignableCheckValid(symbol);
        if (error2 != null) {
            return this.assign_error(error2, value2);
        }
        this.currentScope.addVariableThisScope(symbol.idString());
        return value2;
    }

    protected IRubyObject backref_error(IRubyObject ref, IRubyObject expr) {
        RubyString str = this.getRuntime().newString("Can't set variable ");
        str = str.append(ref);
        return this.dispatch("on_assign_error", str, expr);
    }

    protected int getParenNest() {
        return this.lexer.getParenNest();
    }

    public void add_forwarding_args() {
        this.arg_var(CommonByteLists.FWD_REST);
        this.arg_var(CommonByteLists.FWD_KWREST);
        this.arg_var(CommonByteLists.FWD_BLOCK);
    }

    public IRubyObject method_optarg(IRubyObject method2, IRubyObject arg2) {
        if (arg2 == null) {
            return method2;
        }
        return this.dispatch("on_method_add_arg", method2, arg2);
    }

    public IRubyObject keyword_arg(IRubyObject key2, IRubyObject value2) {
        RubyArray array2 = RubyArray.newArray(this.context.runtime, 2);
        array2.append(key2);
        if (value2 != null) {
            array2.append(value2);
        } else {
            array2.append(this.context.nil);
        }
        return array2;
    }

    public IRubyObject new_args(int _line, IRubyObject f, IRubyObject o, IRubyObject r, IRubyObject p2, ArgsTailHolder tail) {
        if (tail != null) {
            return this.dispatch("on_params", f, o, r, p2, tail.getKeywordArgs(), tail.getKeywordRestArg(), tail.getBlockArg());
        }
        return this.dispatch("on_params", f, o, r, p2, null, null, null);
    }

    public ArgsTailHolder new_args_tail(int line, IRubyObject kwarg, IRubyObject kwargRest, ByteList block) {
        return this.new_args_tail(line, kwarg, kwargRest, (IRubyObject)this.symbolID(block));
    }

    public ArgsTailHolder new_args_tail(int _line, IRubyObject kwarg, IRubyObject kwargRest, IRubyObject block) {
        return new ArgsTailHolder(kwarg, kwargRest, block);
    }

    public ArgsTailHolder new_args_tail(int _line, IRubyObject kwarg, ByteList kwargRest, IRubyObject block) {
        RubySymbol keywordRestArg = kwargRest != null ? this.symbolID(kwargRest) : null;
        return new ArgsTailHolder(kwarg, keywordRestArg, block);
    }

    protected ArgsTailHolder new_args_tail(int line, IRubyObject keywordArg, ByteList keywordRestArgName, ByteList block) {
        RubySymbol blockArg = block != null ? this.symbolID(block) : null;
        return this.new_args_tail(line, keywordArg, keywordRestArgName, (IRubyObject)blockArg);
    }

    public IRubyObject method_add_block(IRubyObject method2, IRubyObject block) {
        return this.dispatch("on_method_add_block", method2, block);
    }

    public Encoding getEncoding() {
        return this.lexer.getEncoding();
    }

    public IRubyObject createStr(ByteList data2, int flags2) {
        return this.lexer.createStr(data2, flags2);
    }

    public IRubyObject internalId() {
        return null;
    }

    public IRubyObject new_array(IRubyObject ... args2) {
        return this.context.runtime.newArray(args2);
    }

    public IRubyObject new_assoc(IRubyObject key2, IRubyObject value2) {
        return RubyArray.newArray(this.context.runtime, key2, value2);
    }

    public IRubyObject new_bv(ByteList identifier) {
        if (!this.is_local_id(identifier)) {
            this.getterIdentifierError(identifier);
        }
        this.shadowing_lvar(identifier);
        return this.arg_var(identifier);
    }

    public void popCurrentScope() {
        if (!this.currentScope.isBlockScope()) {
            this.lexer.getCmdArgumentState().pop();
            this.lexer.getConditionState().pop();
        }
        this.currentScope = this.currentScope.getEnclosingScope();
        this.scopedParserState = this.scopedParserState.getEnclosingScope();
    }

    public void pushBlockScope() {
        this.currentScope = this.getRuntime().getStaticScopeFactory().newBlockScope(this.currentScope, this.lexer.getFile());
        this.scopedParserState = new ScopedParserState(this.scopedParserState);
    }

    public void pushLocalScope() {
        this.currentScope = this.getRuntime().getStaticScopeFactory().newLocalScope(this.currentScope, this.lexer.getFile());
        this.scopedParserState = new ScopedParserState(this.scopedParserState, this.lexer.getCmdArgumentState().getStack(), this.lexer.getConditionState().getStack());
        this.lexer.getCmdArgumentState().push0();
        this.lexer.getConditionState().push0();
    }

    public int getHeredocIndent() {
        return this.lexer.getHeredocIndent();
    }

    public void setHeredocIndent(int indent) {
        this.lexer.setHeredocIndent(indent);
    }

    public IRubyObject heredoc_dedent(IRubyObject array2) {
        int indent = this.lexer.getHeredocIndent();
        if (indent <= 0) {
            return array2;
        }
        this.lexer.setHeredocIndent(0);
        this.dispatch("on_heredoc_dedent", array2, this.getRuntime().newFixnum(indent));
        return array2;
    }

    public void setCommandStart(boolean value2) {
        this.lexer.commandStart = value2;
    }

    public ByteList shadowing_lvar(ByteList nameBytes) {
        int slot;
        if (this.is_private_local_id(nameBytes)) {
            return nameBytes;
        }
        RubySymbol name2 = this.symbolID(nameBytes);
        String id2 = name2.idString();
        StaticScope current2 = this.getCurrentScope();
        if (current2.exists(id2) >= 0) {
            this.yyerror("duplicated argument name");
        }
        if ((slot = current2.isDefined(id2)) != -1) {
            this.scopedParserState.addDefinedVariable(name2, this.lexer.getRubySourceline());
            this.scopedParserState.markUsedVariable(name2, slot >> 16);
        }
        return nameBytes;
    }

    public StackState getConditionState() {
        return this.lexer.getConditionState();
    }

    public boolean isInDef() {
        return this.lexer.getLexContext().in_def;
    }

    public boolean isInClass() {
        return this.inClass;
    }

    public void setIsInClass(boolean inClass) {
        this.inClass = inClass;
    }

    public StrTerm getStrTerm() {
        return this.lexer.getStrTerm();
    }

    public void setStrTerm(StrTerm object) {
        this.lexer.setStrTerm(object);
    }

    public StackState getCmdArgumentState() {
        return this.lexer.getCmdArgumentState();
    }

    public IRubyObject compile_error(String message2) {
        return this.dispatch("on_parse_error", this.getRuntime().newString(message2));
    }

    public void yyerror(String message2) {
        this.compile_error(message2);
        this.error();
        throw new SyntaxException(message2, message2);
    }

    public void yyerror(String message2, String[] expected, String found) {
        this.error();
        this.compile_error(message2 + ", unexpected " + found);
    }

    public void error() {
        this.isError = true;
    }

    protected LexContext getLexContext() {
        return this.lexer.getLexContext();
    }

    public Integer getLeftParenBegin() {
        return this.lexer.getLeftParenBegin();
    }

    public void setLeftParenBegin(Integer integer) {
        this.lexer.setLeftParenBegin(integer);
    }

    public void setInDef(boolean inDefinition) {
        this.inDefinition = inDefinition;
    }

    public void setInSingle(int inSingleton) {
        this.inSingleton = inSingleton;
    }

    public int getInSingle() {
        return this.inSingleton;
    }

    public int getBraceNest() {
        return this.lexer.getBraceNest();
    }

    public int getState() {
        return this.lexer.getState();
    }

    public void setBraceNest(int braceNest) {
        this.lexer.setBraceNest(braceNest);
    }

    public void setState(int lexState) {
        this.lexer.setState(lexState);
    }

    public void warning(int _line, String message2) {
        this.warning(message2);
    }

    public void warning(String message2) {
        if (this.lexer.isVerbose()) {
            this.lexer.warning(message2);
        }
    }

    public void warn(int _line, String message2) {
        this.lexer.warn(message2);
    }

    public void warn(String message2) {
        this.lexer.warn(message2);
    }

    protected IRubyObject get_value(IRubyObject value2) {
        return value2;
    }

    protected IRubyObject ripper_new_yylval(IRubyObject id2, IRubyObject b2, IRubyObject c) {
        return b2;
    }

    protected IRubyObject get_value(DefHolder holder) {
        return holder.value;
    }

    protected IRubyObject get_value(RubyArray holder) {
        return holder.eltOk(0L);
    }

    public void endless_method_name(DefHolder holder) {
        ByteList name2 = holder.name.getBytes();
        RubyParserBase.IDType type2 = RubyParserBase.id_type(name2);
        if (type2 == RubyParserBase.IDType.AttrSet) {
            this.compile_error("setter method cannot be defined in an endless method definition");
        }
    }

    public void restore_defun(DefHolder holder) {
        this.lexer.getLexContext().restore(holder);
        this.lexer.setCurrentArg(holder.current_arg);
    }

    public RubySymbol symbolID(ByteList identifierValue) {
        if (RubyString.scanForCodeRange(identifierValue) == 48) {
            Ruby runtime2 = this.getRuntime();
            throw runtime2.newEncodingError(RubyStringBuilder.str(runtime2, "invalid symbol in encoding " + this.lexer.getEncoding() + " :\"", RubyStringBuilder.inspectIdentifierByteList(runtime2, identifierValue), "\""));
        }
        return RubySymbol.newIDSymbol(this.getRuntime(), identifierValue);
    }

    public RubySymbol symbolID(IRubyObject ident) {
        return (RubySymbol)ident;
    }

    public void numparam_name(ByteList name2) {
        String id2 = this.getRuntime().newSymbol(name2).idString();
        if (this.isNumParamId(id2)) {
            this.compile_error(id2 + " is reserved for numbered parameter");
        }
    }

    private boolean isNumParamId(String id2) {
        if (id2.length() != 2 || id2.charAt(0) != '_') {
            return false;
        }
        char one = id2.charAt(1);
        return one != '0' && Character.isDigit(one);
    }

    public IRubyObject new_array_pattern(int _line, IRubyObject constant, IRubyObject preArg, RubyArray arrayPattern) {
        RubyArray preArgs = (RubyArray)arrayPattern.eltOk(0L);
        Object restArg = arrayPattern.eltOk(1L);
        Object postArgs = arrayPattern.eltOk(2L);
        if (preArg != null) {
            if (preArgs != null) {
                preArgs.unshift(preArg);
            } else {
                preArgs = RubyArray.newArray(this.getRuntime());
                preArgs.add(preArg);
            }
        }
        return this.dispatch("on_aryptn", constant, preArgs, (IRubyObject)restArg, (IRubyObject)postArgs);
    }

    public RubyArray new_array_pattern_tail(int _line, IRubyObject preArgs, boolean hasRest, IRubyObject restArg, RubyArray postArgs) {
        restArg = hasRest ? this.dispatch("on_var_field", restArg != null ? restArg : this.getRuntime().getNil()) : this.getRuntime().getNil();
        return RubyArray.newArray(this.getRuntime(), preArgs, restArg, postArgs);
    }

    public IRubyObject new_find_pattern(IRubyObject constant, RubyArray findPattern) {
        Object preArgs = findPattern.eltOk(0L);
        Object restArg = findPattern.eltOk(1L);
        Object postArgs = findPattern.eltOk(2L);
        return this.dispatch("on_fndptn", constant, (IRubyObject)preArgs, (IRubyObject)restArg, (IRubyObject)postArgs);
    }

    public RubyArray new_find_pattern_tail(int _line, IRubyObject preRestArg, IRubyObject args2, IRubyObject postRestArg) {
        preRestArg = this.dispatch("on_var_field", preRestArg != null ? preRestArg : this.context.nil);
        postRestArg = this.dispatch("on_var_field", postRestArg != null ? postRestArg : this.context.nil);
        return RubyArray.newArray(this.getRuntime(), preRestArg, args2, postRestArg);
    }

    protected IRubyObject const_decl(IRubyObject path2) {
        if (this.getLexContext().in_def) {
            path2 = this.assign_error("dynamic constant assignment", path2);
        }
        return path2;
    }

    private IRubyObject assign_error(String message2, IRubyObject value2) {
        value2 = this.dispatch("on_assign_error", this.getRuntime().newString(message2), value2);
        this.error();
        return value2;
    }

    public IRubyObject new_hash_pattern(IRubyObject constant, RubyArray hashPattern) {
        Object keywordArgs = hashPattern.eltOk(0L);
        Object keywordRestArgs = hashPattern.eltOk(1L);
        return this.dispatch("on_hshptn", constant, (IRubyObject)keywordArgs, (IRubyObject)keywordRestArgs);
    }

    public IRubyObject none() {
        return this.nil();
    }

    public RubyArray new_hash_pattern_tail(int _line, IRubyObject keywordArgs, IRubyObject keywordRestValue) {
        if (keywordArgs == null) {
            keywordArgs = this.getRuntime().newEmptyArray();
        }
        IRubyObject restArg = keywordRestValue != null ? this.dispatch("on_var_field", keywordRestValue) : this.context.nil;
        return RubyArray.newArray(this.getRuntime(), keywordArgs, restArg);
    }

    public IRubyObject makeNullNil(IRubyObject value2) {
        return value2 == null ? this.context.nil : value2;
    }

    public boolean local_id(ByteList value2) {
        return this.currentScope.isDefined(this.symbolID(value2).idString()) >= 0;
    }

    public boolean check_forwarding_args() {
        if (this.local_id(CommonByteLists.FWD_REST) && this.local_id(CommonByteLists.FWD_KWREST) && this.local_id(CommonByteLists.FWD_BLOCK)) {
            return true;
        }
        this.compile_error("unexpected ...");
        return false;
    }

    public IRubyObject method_cond(IRubyObject value2) {
        return value2;
    }

    public void error_duplicate_pattern_key(ByteList key2) {
        if (this.keyTable == null) {
            this.keyTable = new HashSet<ByteList>();
        }
        if (this.keyTable.contains(key2)) {
            this.yyerror("duplicated key name");
        }
        this.keyTable.add(key2);
    }

    protected void error_duplicate_pattern_variable(ByteList variable) {
        if (this.is_private_local_id(variable)) {
            return;
        }
        if (this.variableTable.contains(variable)) {
            this.yyerror("duplicated variable name");
        }
        this.variableTable.add(variable);
    }

    public boolean is_private_local_id(ByteList name2) {
        if (name2.realSize() == 1 && name2.charAt(0) == '_') {
            return true;
        }
        if (!this.is_local_id(name2)) {
            return false;
        }
        return name2.charAt(0) == '_';
    }

    public boolean is_local_id(ByteList name2) {
        RubyParserBase.IDType type2 = RubyParserBase.id_type(name2);
        byte last2 = (byte)name2.get(name2.length() - 1);
        return type2 == RubyParserBase.IDType.Local && last2 != 63 && last2 != 61 && last2 != 33;
    }

    protected ByteList extractByteList(Object value2) {
        if (value2 instanceof ByteList) {
            return (ByteList)value2;
        }
        if (value2 instanceof RubyString) {
            return ((RubyString)value2).getByteList();
        }
        if (value2 instanceof RubySymbol) {
            return ((RubySymbol)value2).getBytes();
        }
        if (value2 instanceof RubyArray) {
            return ((RubyString)((RubyArray)value2).eltOk(1L)).getByteList();
        }
        throw new RuntimeException("Got unexpected object: " + value2);
    }

    public Integer incrementParenNest() {
        return this.lexer.incrementParenNest();
    }

    public StaticScope getCurrentScope() {
        return this.currentScope;
    }

    public Ruby getRuntime() {
        return this.context.runtime;
    }

    public long getColumn() {
        return this.lexer.column();
    }

    public long getLineno() {
        return this.lexer.lineno();
    }

    public boolean hasStarted() {
        return this.lexer.hasStarted();
    }

    public Encoding encoding() {
        return this.lexer.getEncoding();
    }

    public ByteList getCurrentArg() {
        return this.currentArg;
    }

    public void setCurrentArg(IRubyObject arg2) {
        this.currentArg = arg2 != null ? this.extractByteList(arg2) : null;
    }

    public boolean getYYDebug() {
        return this.yydebug;
    }

    public void setYYDebug(boolean yydebug2) {
        this.yydebug = yydebug2;
    }

    public boolean isEndSeen() {
        return this.lexer.isEndSeen();
    }

    public boolean isError() {
        return this.isError;
    }

    public IRubyObject nil() {
        return this.context.nil;
    }

    public IRubyObject fals() {
        return this.context.fals;
    }

    public IRubyObject var_field(IRubyObject value2) {
        return this.dispatch("on_var_field", value2);
    }

    public IRubyObject remove_begin(IRubyObject value2) {
        return value2;
    }

    public IRubyObject void_stmts(IRubyObject value2) {
        return value2;
    }

    protected void setHeredocLineIndent(int value2) {
        this.lexer.setHeredocLineIndent(value2);
    }

    public void warn_experimental(int line, String message2) {
        this.lexer.warning(this.lexer.getFile(), message2);
    }

    public ThreadContext getContext() {
        return this.context;
    }

    public RubySymbol get_id(ByteList value2) {
        return this.getRuntime().newSymbol(value2);
    }

    public RubySymbol get_id(IRubyObject _ignored) {
        if (_ignored instanceof RubySymbol) {
            return (RubySymbol)_ignored;
        }
        return this.getRuntime().newSymbol(this.lexer.identValue);
    }
}

