/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.windows;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum ErrnoAddressInfo implements Constant
{
    EAI_AGAIN(11002L),
    EAI_BADFLAGS(10022L),
    EAI_FAIL(11003L),
    EAI_FAMILY(10047L),
    EAI_MEMORY(8L),
    EAI_NODATA(11004L),
    EAI_NONAME(11001L),
    EAI_SERVICE(10109L),
    EAI_SOCKTYPE(10044L);

    private final long value;
    public static final long MIN_VALUE = 8L;
    public static final long MAX_VALUE = 11004L;

    private ErrnoAddressInfo(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<ErrnoAddressInfo, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<ErrnoAddressInfo, String> generateTable() {
            EnumMap<ErrnoAddressInfo, String> map2 = new EnumMap<ErrnoAddressInfo, String>(ErrnoAddressInfo.class);
            map2.put(EAI_AGAIN, "EAI_AGAIN");
            map2.put(EAI_BADFLAGS, "EAI_BADFLAGS");
            map2.put(EAI_FAIL, "EAI_FAIL");
            map2.put(EAI_FAMILY, "EAI_FAMILY");
            map2.put(EAI_MEMORY, "EAI_MEMORY");
            map2.put(EAI_NODATA, "EAI_NODATA");
            map2.put(EAI_NONAME, "EAI_NONAME");
            map2.put(EAI_SERVICE, "EAI_SERVICE");
            map2.put(EAI_SOCKTYPE, "EAI_SOCKTYPE");
            return map2;
        }
    }
}

