RabbitMQ `3.11.17` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25 and supports Erlang versions up to `25.3.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).

### Core Server

#### Bug Fixes

 * Fixed two quorum queue federation issues.

   GitHub issue: [#8282](https://github.com/rabbitmq/rabbitmq-server/pull/8282)

 * Nodes that had a large number of quorum queues could observe accumulation of Erlang processes
   under significant load.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#7389](https://github.com/rabbitmq/rabbitmq-server/issues/7389)

 * Nodes could hang when recovering classic queue indices during boot.

   GitHub issue: [#8343](https://github.com/rabbitmq/rabbitmq-server/pull/8343)

 * As of [#6418](https://github.com/rabbitmq/rabbitmq-server/pull/6418), nodes refuse
   to start if the definitions file cannot be parsed as valid JSON.

   Now this also applies to nodes that were configure to skip definition import if the input file(s) has changed
   using the `definitions.skip_if_unchanged` setting.

   GitHub issue: [#8372](https://github.com/rabbitmq/rabbitmq-server/issues/8372)

#### Enhancements

 * Reduce CPU footprint of quorum queue metric emission in clusters with a lot of quorum queues.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#7389](https://github.com/rabbitmq/rabbitmq-server/issues/7389)


### Management Plugin

#### Bug Fixes

 * The plugin reported the interface [its listener(s)](https://rabbitmq.com/management.html#single-listener-port) were bound to incorrectly.

   GitHub issue: [#8242](https://github.com/rabbitmq/rabbitmq-server/issues/8242)

#### Enhancements

 * It is now possible to change default queue type for a virtual host using the
   `PUT /api/vhosts/{name}` endpoint.

   GitHub issue: [#8342](https://github.com/rabbitmq/rabbitmq-server/pull/8342)


### Web STOMP Plugin

#### Bug Fixes

 * The plugin reported the interface its listener(s) were bound to incorrectly.

   GitHub issue: [#8242](https://github.com/rabbitmq/rabbitmq-server/issues/8242)


### Web MQTT Plugin

#### Bug Fixes

 * The plugin reported the interface its listener(s) were bound to incorrectly.

   GitHub issue: [#8242](https://github.com/rabbitmq/rabbitmq-server/issues/8242)


### Debian Package

#### Bug Fixes

 * Make-based source package builds were failing in an offline environment.

   GitHub issue: [#7869](https://github.com/rabbitmq/rabbitmq-server/issues/7869)


### RPM Package

#### Bug Fixes

 * Make-based source package builds were failing in an offline environment.

   GitHub issue: [#7869](https://github.com/rabbitmq/rabbitmq-server/issues/7869)


## Dependency Upgrades

 * [CSV parser](https://github.com/beatrichartz/csv) used by CLI tools was upgraded to `3.0.5`


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.17.tar.xz`
instead of the source tarball produced by GitHub.
