// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package vpclattice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchUpdateRule = "BatchUpdateRule"

// BatchUpdateRuleRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateRule for more information on using the BatchUpdateRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchUpdateRuleRequest method.
//	req, resp := client.BatchUpdateRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/BatchUpdateRule
func (c *VPCLattice) BatchUpdateRuleRequest(input *BatchUpdateRuleInput) (req *request.Request, output *BatchUpdateRuleOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateRule,
		HTTPMethod: "PATCH",
		HTTPPath:   "/services/{serviceIdentifier}/listeners/{listenerIdentifier}/rules",
	}

	if input == nil {
		input = &BatchUpdateRuleInput{}
	}

	output = &BatchUpdateRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdateRule API operation for Amazon VPC Lattice.
//
// Updates the listener rules in a batch. You can use this operation to change
// the priority of listener rules. This can be useful when bulk updating or
// swapping rule priority.
//
// Required permissions: vpc-lattice:UpdateRule
//
// For more information, see How Amazon VPC Lattice works with IAM (https://docs.aws.amazon.com/vpc-lattice/latest/ug/security_iam_service-with-iam.html)
// in the Amazon VPC Lattice User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation BatchUpdateRule for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/BatchUpdateRule
func (c *VPCLattice) BatchUpdateRule(input *BatchUpdateRuleInput) (*BatchUpdateRuleOutput, error) {
	req, out := c.BatchUpdateRuleRequest(input)
	return out, req.Send()
}

// BatchUpdateRuleWithContext is the same as BatchUpdateRule with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) BatchUpdateRuleWithContext(ctx aws.Context, input *BatchUpdateRuleInput, opts ...request.Option) (*BatchUpdateRuleOutput, error) {
	req, out := c.BatchUpdateRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccessLogSubscription = "CreateAccessLogSubscription"

// CreateAccessLogSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccessLogSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccessLogSubscription for more information on using the CreateAccessLogSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAccessLogSubscriptionRequest method.
//	req, resp := client.CreateAccessLogSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateAccessLogSubscription
func (c *VPCLattice) CreateAccessLogSubscriptionRequest(input *CreateAccessLogSubscriptionInput) (req *request.Request, output *CreateAccessLogSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateAccessLogSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/accesslogsubscriptions",
	}

	if input == nil {
		input = &CreateAccessLogSubscriptionInput{}
	}

	output = &CreateAccessLogSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccessLogSubscription API operation for Amazon VPC Lattice.
//
// Enables access logs to be sent to Amazon CloudWatch, Amazon S3, and Amazon
// Kinesis Data Firehose. The service network owner can use the access logs
// to audit the services in the network. The service network owner can only
// see access logs from clients and services that are associated with their
// service network. Access log entries represent traffic originated from VPCs
// associated with that network. For more information, see Access logs (https://docs.aws.amazon.com/vpc-lattice/latest/ug/monitoring-access-logs.html)
// in the Amazon VPC Lattice User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation CreateAccessLogSubscription for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateAccessLogSubscription
func (c *VPCLattice) CreateAccessLogSubscription(input *CreateAccessLogSubscriptionInput) (*CreateAccessLogSubscriptionOutput, error) {
	req, out := c.CreateAccessLogSubscriptionRequest(input)
	return out, req.Send()
}

// CreateAccessLogSubscriptionWithContext is the same as CreateAccessLogSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccessLogSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) CreateAccessLogSubscriptionWithContext(ctx aws.Context, input *CreateAccessLogSubscriptionInput, opts ...request.Option) (*CreateAccessLogSubscriptionOutput, error) {
	req, out := c.CreateAccessLogSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateListener = "CreateListener"

// CreateListenerRequest generates a "aws/request.Request" representing the
// client's request for the CreateListener operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateListener for more information on using the CreateListener
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateListenerRequest method.
//	req, resp := client.CreateListenerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateListener
func (c *VPCLattice) CreateListenerRequest(input *CreateListenerInput) (req *request.Request, output *CreateListenerOutput) {
	op := &request.Operation{
		Name:       opCreateListener,
		HTTPMethod: "POST",
		HTTPPath:   "/services/{serviceIdentifier}/listeners",
	}

	if input == nil {
		input = &CreateListenerInput{}
	}

	output = &CreateListenerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateListener API operation for Amazon VPC Lattice.
//
// Creates a listener for a service. Before you start using your Amazon VPC
// Lattice service, you must add one or more listeners. A listener is a process
// that checks for connection requests to your services. For more information,
// see Listeners (https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html)
// in the Amazon VPC Lattice User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation CreateListener for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateListener
func (c *VPCLattice) CreateListener(input *CreateListenerInput) (*CreateListenerOutput, error) {
	req, out := c.CreateListenerRequest(input)
	return out, req.Send()
}

// CreateListenerWithContext is the same as CreateListener with the addition of
// the ability to pass a context and additional request options.
//
// See CreateListener for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) CreateListenerWithContext(ctx aws.Context, input *CreateListenerInput, opts ...request.Option) (*CreateListenerOutput, error) {
	req, out := c.CreateListenerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRule = "CreateRule"

// CreateRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRule for more information on using the CreateRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRuleRequest method.
//	req, resp := client.CreateRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateRule
func (c *VPCLattice) CreateRuleRequest(input *CreateRuleInput) (req *request.Request, output *CreateRuleOutput) {
	op := &request.Operation{
		Name:       opCreateRule,
		HTTPMethod: "POST",
		HTTPPath:   "/services/{serviceIdentifier}/listeners/{listenerIdentifier}/rules",
	}

	if input == nil {
		input = &CreateRuleInput{}
	}

	output = &CreateRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRule API operation for Amazon VPC Lattice.
//
// Creates a listener rule. Each listener has a default rule for checking connection
// requests, but you can define additional rules. Each rule consists of a priority,
// one or more actions, and one or more conditions. For more information, see
// Listener rules (https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules)
// in the Amazon VPC Lattice User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation CreateRule for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateRule
func (c *VPCLattice) CreateRule(input *CreateRuleInput) (*CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	return out, req.Send()
}

// CreateRuleWithContext is the same as CreateRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) CreateRuleWithContext(ctx aws.Context, input *CreateRuleInput, opts ...request.Option) (*CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateService = "CreateService"

// CreateServiceRequest generates a "aws/request.Request" representing the
// client's request for the CreateService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateService for more information on using the CreateService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateServiceRequest method.
//	req, resp := client.CreateServiceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateService
func (c *VPCLattice) CreateServiceRequest(input *CreateServiceInput) (req *request.Request, output *CreateServiceOutput) {
	op := &request.Operation{
		Name:       opCreateService,
		HTTPMethod: "POST",
		HTTPPath:   "/services",
	}

	if input == nil {
		input = &CreateServiceInput{}
	}

	output = &CreateServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateService API operation for Amazon VPC Lattice.
//
// Creates a service. A service is any software application that can run on
// instances containers, or serverless functions within an account or virtual
// private cloud (VPC).
//
// For more information, see Services (https://docs.aws.amazon.com/vpc-lattice/latest/ug/services.html)
// in the Amazon VPC Lattice User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation CreateService for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateService
func (c *VPCLattice) CreateService(input *CreateServiceInput) (*CreateServiceOutput, error) {
	req, out := c.CreateServiceRequest(input)
	return out, req.Send()
}

// CreateServiceWithContext is the same as CreateService with the addition of
// the ability to pass a context and additional request options.
//
// See CreateService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) CreateServiceWithContext(ctx aws.Context, input *CreateServiceInput, opts ...request.Option) (*CreateServiceOutput, error) {
	req, out := c.CreateServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateServiceNetwork = "CreateServiceNetwork"

// CreateServiceNetworkRequest generates a "aws/request.Request" representing the
// client's request for the CreateServiceNetwork operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateServiceNetwork for more information on using the CreateServiceNetwork
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateServiceNetworkRequest method.
//	req, resp := client.CreateServiceNetworkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetwork
func (c *VPCLattice) CreateServiceNetworkRequest(input *CreateServiceNetworkInput) (req *request.Request, output *CreateServiceNetworkOutput) {
	op := &request.Operation{
		Name:       opCreateServiceNetwork,
		HTTPMethod: "POST",
		HTTPPath:   "/servicenetworks",
	}

	if input == nil {
		input = &CreateServiceNetworkInput{}
	}

	output = &CreateServiceNetworkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateServiceNetwork API operation for Amazon VPC Lattice.
//
// Creates a service network. A service network is a logical boundary for a
// collection of services. You can associate services and VPCs with a service
// network.
//
// For more information, see Service networks (https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html)
// in the Amazon VPC Lattice User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation CreateServiceNetwork for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetwork
func (c *VPCLattice) CreateServiceNetwork(input *CreateServiceNetworkInput) (*CreateServiceNetworkOutput, error) {
	req, out := c.CreateServiceNetworkRequest(input)
	return out, req.Send()
}

// CreateServiceNetworkWithContext is the same as CreateServiceNetwork with the addition of
// the ability to pass a context and additional request options.
//
// See CreateServiceNetwork for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) CreateServiceNetworkWithContext(ctx aws.Context, input *CreateServiceNetworkInput, opts ...request.Option) (*CreateServiceNetworkOutput, error) {
	req, out := c.CreateServiceNetworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateServiceNetworkServiceAssociation = "CreateServiceNetworkServiceAssociation"

// CreateServiceNetworkServiceAssociationRequest generates a "aws/request.Request" representing the
// client's request for the CreateServiceNetworkServiceAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateServiceNetworkServiceAssociation for more information on using the CreateServiceNetworkServiceAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateServiceNetworkServiceAssociationRequest method.
//	req, resp := client.CreateServiceNetworkServiceAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetworkServiceAssociation
func (c *VPCLattice) CreateServiceNetworkServiceAssociationRequest(input *CreateServiceNetworkServiceAssociationInput) (req *request.Request, output *CreateServiceNetworkServiceAssociationOutput) {
	op := &request.Operation{
		Name:       opCreateServiceNetworkServiceAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/servicenetworkserviceassociations",
	}

	if input == nil {
		input = &CreateServiceNetworkServiceAssociationInput{}
	}

	output = &CreateServiceNetworkServiceAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateServiceNetworkServiceAssociation API operation for Amazon VPC Lattice.
//
// Associates a service with a service network. For more information, see Manage
// service associations (https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-service-associations)
// in the Amazon VPC Lattice User Guide.
//
// You can't use this operation if the service and service network are already
// associated or if there is a disassociation or deletion in progress. If the
// association fails, you can retry the operation by deleting the association
// and recreating it.
//
// You cannot associate a service and service network that are shared with a
// caller. The caller must own either the service or the service network.
//
// As a result of this operation, the association is created in the service
// network account and the association owner account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation CreateServiceNetworkServiceAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetworkServiceAssociation
func (c *VPCLattice) CreateServiceNetworkServiceAssociation(input *CreateServiceNetworkServiceAssociationInput) (*CreateServiceNetworkServiceAssociationOutput, error) {
	req, out := c.CreateServiceNetworkServiceAssociationRequest(input)
	return out, req.Send()
}

// CreateServiceNetworkServiceAssociationWithContext is the same as CreateServiceNetworkServiceAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateServiceNetworkServiceAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) CreateServiceNetworkServiceAssociationWithContext(ctx aws.Context, input *CreateServiceNetworkServiceAssociationInput, opts ...request.Option) (*CreateServiceNetworkServiceAssociationOutput, error) {
	req, out := c.CreateServiceNetworkServiceAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateServiceNetworkVpcAssociation = "CreateServiceNetworkVpcAssociation"

// CreateServiceNetworkVpcAssociationRequest generates a "aws/request.Request" representing the
// client's request for the CreateServiceNetworkVpcAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateServiceNetworkVpcAssociation for more information on using the CreateServiceNetworkVpcAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateServiceNetworkVpcAssociationRequest method.
//	req, resp := client.CreateServiceNetworkVpcAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetworkVpcAssociation
func (c *VPCLattice) CreateServiceNetworkVpcAssociationRequest(input *CreateServiceNetworkVpcAssociationInput) (req *request.Request, output *CreateServiceNetworkVpcAssociationOutput) {
	op := &request.Operation{
		Name:       opCreateServiceNetworkVpcAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/servicenetworkvpcassociations",
	}

	if input == nil {
		input = &CreateServiceNetworkVpcAssociationInput{}
	}

	output = &CreateServiceNetworkVpcAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateServiceNetworkVpcAssociation API operation for Amazon VPC Lattice.
//
// Associates a VPC with a service network. When you associate a VPC with the
// service network, it enables all the resources within that VPC to be clients
// and communicate with other services in the service network. For more information,
// see Manage VPC associations (https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-vpc-associations)
// in the Amazon VPC Lattice User Guide.
//
// You can't use this operation if there is a disassociation in progress. If
// the association fails, retry by deleting the association and recreating it.
//
// As a result of this operation, the association gets created in the service
// network account and the VPC owner account.
//
// If you add a security group to the service network and VPC association, the
// association must continue to always have at least one security group. You
// can add or edit security groups at any time. However, to remove all security
// groups, you must first delete the association and recreate it without security
// groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation CreateServiceNetworkVpcAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetworkVpcAssociation
func (c *VPCLattice) CreateServiceNetworkVpcAssociation(input *CreateServiceNetworkVpcAssociationInput) (*CreateServiceNetworkVpcAssociationOutput, error) {
	req, out := c.CreateServiceNetworkVpcAssociationRequest(input)
	return out, req.Send()
}

// CreateServiceNetworkVpcAssociationWithContext is the same as CreateServiceNetworkVpcAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateServiceNetworkVpcAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) CreateServiceNetworkVpcAssociationWithContext(ctx aws.Context, input *CreateServiceNetworkVpcAssociationInput, opts ...request.Option) (*CreateServiceNetworkVpcAssociationOutput, error) {
	req, out := c.CreateServiceNetworkVpcAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTargetGroup = "CreateTargetGroup"

// CreateTargetGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateTargetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTargetGroup for more information on using the CreateTargetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTargetGroupRequest method.
//	req, resp := client.CreateTargetGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateTargetGroup
func (c *VPCLattice) CreateTargetGroupRequest(input *CreateTargetGroupInput) (req *request.Request, output *CreateTargetGroupOutput) {
	op := &request.Operation{
		Name:       opCreateTargetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/targetgroups",
	}

	if input == nil {
		input = &CreateTargetGroupInput{}
	}

	output = &CreateTargetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTargetGroup API operation for Amazon VPC Lattice.
//
// Creates a target group. A target group is a collection of targets, or compute
// resources, that run your application or service. A target group can only
// be used by a single service.
//
// For more information, see Target groups (https://docs.aws.amazon.com/vpc-lattice/latest/ug/target-groups.html)
// in the Amazon VPC Lattice User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation CreateTargetGroup for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateTargetGroup
func (c *VPCLattice) CreateTargetGroup(input *CreateTargetGroupInput) (*CreateTargetGroupOutput, error) {
	req, out := c.CreateTargetGroupRequest(input)
	return out, req.Send()
}

// CreateTargetGroupWithContext is the same as CreateTargetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTargetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) CreateTargetGroupWithContext(ctx aws.Context, input *CreateTargetGroupInput, opts ...request.Option) (*CreateTargetGroupOutput, error) {
	req, out := c.CreateTargetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccessLogSubscription = "DeleteAccessLogSubscription"

// DeleteAccessLogSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccessLogSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccessLogSubscription for more information on using the DeleteAccessLogSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAccessLogSubscriptionRequest method.
//	req, resp := client.DeleteAccessLogSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteAccessLogSubscription
func (c *VPCLattice) DeleteAccessLogSubscriptionRequest(input *DeleteAccessLogSubscriptionInput) (req *request.Request, output *DeleteAccessLogSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessLogSubscription,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accesslogsubscriptions/{accessLogSubscriptionIdentifier}",
	}

	if input == nil {
		input = &DeleteAccessLogSubscriptionInput{}
	}

	output = &DeleteAccessLogSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAccessLogSubscription API operation for Amazon VPC Lattice.
//
// Deletes the specified access log subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation DeleteAccessLogSubscription for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteAccessLogSubscription
func (c *VPCLattice) DeleteAccessLogSubscription(input *DeleteAccessLogSubscriptionInput) (*DeleteAccessLogSubscriptionOutput, error) {
	req, out := c.DeleteAccessLogSubscriptionRequest(input)
	return out, req.Send()
}

// DeleteAccessLogSubscriptionWithContext is the same as DeleteAccessLogSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccessLogSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) DeleteAccessLogSubscriptionWithContext(ctx aws.Context, input *DeleteAccessLogSubscriptionInput, opts ...request.Option) (*DeleteAccessLogSubscriptionOutput, error) {
	req, out := c.DeleteAccessLogSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAuthPolicy = "DeleteAuthPolicy"

// DeleteAuthPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAuthPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAuthPolicy for more information on using the DeleteAuthPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAuthPolicyRequest method.
//	req, resp := client.DeleteAuthPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteAuthPolicy
func (c *VPCLattice) DeleteAuthPolicyRequest(input *DeleteAuthPolicyInput) (req *request.Request, output *DeleteAuthPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteAuthPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/authpolicy/{resourceIdentifier}",
	}

	if input == nil {
		input = &DeleteAuthPolicyInput{}
	}

	output = &DeleteAuthPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAuthPolicy API operation for Amazon VPC Lattice.
//
// Deletes the specified auth policy. If an auth is set to AWS_IAM and the auth
// policy is deleted, all requests are denied. If you are trying to remove the
// auth policy completely, you must set the auth type to NONE. If auth is enabled
// on the resource, but no auth policy is set, all requests are denied.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation DeleteAuthPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteAuthPolicy
func (c *VPCLattice) DeleteAuthPolicy(input *DeleteAuthPolicyInput) (*DeleteAuthPolicyOutput, error) {
	req, out := c.DeleteAuthPolicyRequest(input)
	return out, req.Send()
}

// DeleteAuthPolicyWithContext is the same as DeleteAuthPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAuthPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) DeleteAuthPolicyWithContext(ctx aws.Context, input *DeleteAuthPolicyInput, opts ...request.Option) (*DeleteAuthPolicyOutput, error) {
	req, out := c.DeleteAuthPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteListener = "DeleteListener"

// DeleteListenerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteListener operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteListener for more information on using the DeleteListener
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteListenerRequest method.
//	req, resp := client.DeleteListenerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteListener
func (c *VPCLattice) DeleteListenerRequest(input *DeleteListenerInput) (req *request.Request, output *DeleteListenerOutput) {
	op := &request.Operation{
		Name:       opDeleteListener,
		HTTPMethod: "DELETE",
		HTTPPath:   "/services/{serviceIdentifier}/listeners/{listenerIdentifier}",
	}

	if input == nil {
		input = &DeleteListenerInput{}
	}

	output = &DeleteListenerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteListener API operation for Amazon VPC Lattice.
//
// Deletes the specified listener.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation DeleteListener for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteListener
func (c *VPCLattice) DeleteListener(input *DeleteListenerInput) (*DeleteListenerOutput, error) {
	req, out := c.DeleteListenerRequest(input)
	return out, req.Send()
}

// DeleteListenerWithContext is the same as DeleteListener with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteListener for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) DeleteListenerWithContext(ctx aws.Context, input *DeleteListenerInput, opts ...request.Option) (*DeleteListenerOutput, error) {
	req, out := c.DeleteListenerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourcePolicy = "DeleteResourcePolicy"

// DeleteResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourcePolicy for more information on using the DeleteResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResourcePolicyRequest method.
//	req, resp := client.DeleteResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteResourcePolicy
func (c *VPCLattice) DeleteResourcePolicyRequest(input *DeleteResourcePolicyInput) (req *request.Request, output *DeleteResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteResourcePolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/resourcepolicy/{resourceArn}",
	}

	if input == nil {
		input = &DeleteResourcePolicyInput{}
	}

	output = &DeleteResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResourcePolicy API operation for Amazon VPC Lattice.
//
// Deletes the specified resource policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation DeleteResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteResourcePolicy
func (c *VPCLattice) DeleteResourcePolicy(input *DeleteResourcePolicyInput) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	return out, req.Send()
}

// DeleteResourcePolicyWithContext is the same as DeleteResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) DeleteResourcePolicyWithContext(ctx aws.Context, input *DeleteResourcePolicyInput, opts ...request.Option) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRule = "DeleteRule"

// DeleteRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRule for more information on using the DeleteRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRuleRequest method.
//	req, resp := client.DeleteRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteRule
func (c *VPCLattice) DeleteRuleRequest(input *DeleteRuleInput) (req *request.Request, output *DeleteRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteRule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/services/{serviceIdentifier}/listeners/{listenerIdentifier}/rules/{ruleIdentifier}",
	}

	if input == nil {
		input = &DeleteRuleInput{}
	}

	output = &DeleteRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRule API operation for Amazon VPC Lattice.
//
// Deletes a listener rule. Each listener has a default rule for checking connection
// requests, but you can define additional rules. Each rule consists of a priority,
// one or more actions, and one or more conditions. You can delete additional
// listener rules, but you cannot delete the default rule.
//
// For more information, see Listener rules (https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules)
// in the Amazon VPC Lattice User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation DeleteRule for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteRule
func (c *VPCLattice) DeleteRule(input *DeleteRuleInput) (*DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	return out, req.Send()
}

// DeleteRuleWithContext is the same as DeleteRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) DeleteRuleWithContext(ctx aws.Context, input *DeleteRuleInput, opts ...request.Option) (*DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteService = "DeleteService"

// DeleteServiceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteService for more information on using the DeleteService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteServiceRequest method.
//	req, resp := client.DeleteServiceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteService
func (c *VPCLattice) DeleteServiceRequest(input *DeleteServiceInput) (req *request.Request, output *DeleteServiceOutput) {
	op := &request.Operation{
		Name:       opDeleteService,
		HTTPMethod: "DELETE",
		HTTPPath:   "/services/{serviceIdentifier}",
	}

	if input == nil {
		input = &DeleteServiceInput{}
	}

	output = &DeleteServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteService API operation for Amazon VPC Lattice.
//
// Deletes a service. A service can't be deleted if it's associated with a service
// network. If you delete a service, all resources related to the service, such
// as the resource policy, auth policy, listeners, listener rules, and access
// log subscriptions, are also deleted. For more information, see Delete a service
// (https://docs.aws.amazon.com/vpc-lattice/latest/ug/services.html#delete-service)
// in the Amazon VPC Lattice User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation DeleteService for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteService
func (c *VPCLattice) DeleteService(input *DeleteServiceInput) (*DeleteServiceOutput, error) {
	req, out := c.DeleteServiceRequest(input)
	return out, req.Send()
}

// DeleteServiceWithContext is the same as DeleteService with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) DeleteServiceWithContext(ctx aws.Context, input *DeleteServiceInput, opts ...request.Option) (*DeleteServiceOutput, error) {
	req, out := c.DeleteServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteServiceNetwork = "DeleteServiceNetwork"

// DeleteServiceNetworkRequest generates a "aws/request.Request" representing the
// client's request for the DeleteServiceNetwork operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteServiceNetwork for more information on using the DeleteServiceNetwork
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteServiceNetworkRequest method.
//	req, resp := client.DeleteServiceNetworkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetwork
func (c *VPCLattice) DeleteServiceNetworkRequest(input *DeleteServiceNetworkInput) (req *request.Request, output *DeleteServiceNetworkOutput) {
	op := &request.Operation{
		Name:       opDeleteServiceNetwork,
		HTTPMethod: "DELETE",
		HTTPPath:   "/servicenetworks/{serviceNetworkIdentifier}",
	}

	if input == nil {
		input = &DeleteServiceNetworkInput{}
	}

	output = &DeleteServiceNetworkOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteServiceNetwork API operation for Amazon VPC Lattice.
//
// Deletes a service network. You can only delete the service network if there
// is no service or VPC associated with it. If you delete a service network,
// all resources related to the service network, such as the resource policy,
// auth policy, and access log subscriptions, are also deleted. For more information,
// see Delete a service network (https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#delete-service-network)
// in the Amazon VPC Lattice User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation DeleteServiceNetwork for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetwork
func (c *VPCLattice) DeleteServiceNetwork(input *DeleteServiceNetworkInput) (*DeleteServiceNetworkOutput, error) {
	req, out := c.DeleteServiceNetworkRequest(input)
	return out, req.Send()
}

// DeleteServiceNetworkWithContext is the same as DeleteServiceNetwork with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteServiceNetwork for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) DeleteServiceNetworkWithContext(ctx aws.Context, input *DeleteServiceNetworkInput, opts ...request.Option) (*DeleteServiceNetworkOutput, error) {
	req, out := c.DeleteServiceNetworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteServiceNetworkServiceAssociation = "DeleteServiceNetworkServiceAssociation"

// DeleteServiceNetworkServiceAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteServiceNetworkServiceAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteServiceNetworkServiceAssociation for more information on using the DeleteServiceNetworkServiceAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteServiceNetworkServiceAssociationRequest method.
//	req, resp := client.DeleteServiceNetworkServiceAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetworkServiceAssociation
func (c *VPCLattice) DeleteServiceNetworkServiceAssociationRequest(input *DeleteServiceNetworkServiceAssociationInput) (req *request.Request, output *DeleteServiceNetworkServiceAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteServiceNetworkServiceAssociation,
		HTTPMethod: "DELETE",
		HTTPPath:   "/servicenetworkserviceassociations/{serviceNetworkServiceAssociationIdentifier}",
	}

	if input == nil {
		input = &DeleteServiceNetworkServiceAssociationInput{}
	}

	output = &DeleteServiceNetworkServiceAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteServiceNetworkServiceAssociation API operation for Amazon VPC Lattice.
//
// Deletes the association between a specified service and the specific service
// network. This operation fails if an association is still in progress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation DeleteServiceNetworkServiceAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetworkServiceAssociation
func (c *VPCLattice) DeleteServiceNetworkServiceAssociation(input *DeleteServiceNetworkServiceAssociationInput) (*DeleteServiceNetworkServiceAssociationOutput, error) {
	req, out := c.DeleteServiceNetworkServiceAssociationRequest(input)
	return out, req.Send()
}

// DeleteServiceNetworkServiceAssociationWithContext is the same as DeleteServiceNetworkServiceAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteServiceNetworkServiceAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) DeleteServiceNetworkServiceAssociationWithContext(ctx aws.Context, input *DeleteServiceNetworkServiceAssociationInput, opts ...request.Option) (*DeleteServiceNetworkServiceAssociationOutput, error) {
	req, out := c.DeleteServiceNetworkServiceAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteServiceNetworkVpcAssociation = "DeleteServiceNetworkVpcAssociation"

// DeleteServiceNetworkVpcAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteServiceNetworkVpcAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteServiceNetworkVpcAssociation for more information on using the DeleteServiceNetworkVpcAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteServiceNetworkVpcAssociationRequest method.
//	req, resp := client.DeleteServiceNetworkVpcAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetworkVpcAssociation
func (c *VPCLattice) DeleteServiceNetworkVpcAssociationRequest(input *DeleteServiceNetworkVpcAssociationInput) (req *request.Request, output *DeleteServiceNetworkVpcAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteServiceNetworkVpcAssociation,
		HTTPMethod: "DELETE",
		HTTPPath:   "/servicenetworkvpcassociations/{serviceNetworkVpcAssociationIdentifier}",
	}

	if input == nil {
		input = &DeleteServiceNetworkVpcAssociationInput{}
	}

	output = &DeleteServiceNetworkVpcAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteServiceNetworkVpcAssociation API operation for Amazon VPC Lattice.
//
// Disassociates the VPC from the service network. You can't disassociate the
// VPC if there is a create or update association in progress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation DeleteServiceNetworkVpcAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetworkVpcAssociation
func (c *VPCLattice) DeleteServiceNetworkVpcAssociation(input *DeleteServiceNetworkVpcAssociationInput) (*DeleteServiceNetworkVpcAssociationOutput, error) {
	req, out := c.DeleteServiceNetworkVpcAssociationRequest(input)
	return out, req.Send()
}

// DeleteServiceNetworkVpcAssociationWithContext is the same as DeleteServiceNetworkVpcAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteServiceNetworkVpcAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) DeleteServiceNetworkVpcAssociationWithContext(ctx aws.Context, input *DeleteServiceNetworkVpcAssociationInput, opts ...request.Option) (*DeleteServiceNetworkVpcAssociationOutput, error) {
	req, out := c.DeleteServiceNetworkVpcAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTargetGroup = "DeleteTargetGroup"

// DeleteTargetGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTargetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTargetGroup for more information on using the DeleteTargetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTargetGroupRequest method.
//	req, resp := client.DeleteTargetGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteTargetGroup
func (c *VPCLattice) DeleteTargetGroupRequest(input *DeleteTargetGroupInput) (req *request.Request, output *DeleteTargetGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteTargetGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/targetgroups/{targetGroupIdentifier}",
	}

	if input == nil {
		input = &DeleteTargetGroupInput{}
	}

	output = &DeleteTargetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTargetGroup API operation for Amazon VPC Lattice.
//
// Deletes a target group. You can't delete a target group if it is used in
// a listener rule or if the target group creation is in progress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation DeleteTargetGroup for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteTargetGroup
func (c *VPCLattice) DeleteTargetGroup(input *DeleteTargetGroupInput) (*DeleteTargetGroupOutput, error) {
	req, out := c.DeleteTargetGroupRequest(input)
	return out, req.Send()
}

// DeleteTargetGroupWithContext is the same as DeleteTargetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTargetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) DeleteTargetGroupWithContext(ctx aws.Context, input *DeleteTargetGroupInput, opts ...request.Option) (*DeleteTargetGroupOutput, error) {
	req, out := c.DeleteTargetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterTargets = "DeregisterTargets"

// DeregisterTargetsRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterTargets for more information on using the DeregisterTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterTargetsRequest method.
//	req, resp := client.DeregisterTargetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeregisterTargets
func (c *VPCLattice) DeregisterTargetsRequest(input *DeregisterTargetsInput) (req *request.Request, output *DeregisterTargetsOutput) {
	op := &request.Operation{
		Name:       opDeregisterTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/targetgroups/{targetGroupIdentifier}/deregistertargets",
	}

	if input == nil {
		input = &DeregisterTargetsInput{}
	}

	output = &DeregisterTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterTargets API operation for Amazon VPC Lattice.
//
// Deregisters the specified targets from the specified target group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation DeregisterTargets for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeregisterTargets
func (c *VPCLattice) DeregisterTargets(input *DeregisterTargetsInput) (*DeregisterTargetsOutput, error) {
	req, out := c.DeregisterTargetsRequest(input)
	return out, req.Send()
}

// DeregisterTargetsWithContext is the same as DeregisterTargets with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) DeregisterTargetsWithContext(ctx aws.Context, input *DeregisterTargetsInput, opts ...request.Option) (*DeregisterTargetsOutput, error) {
	req, out := c.DeregisterTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessLogSubscription = "GetAccessLogSubscription"

// GetAccessLogSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessLogSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessLogSubscription for more information on using the GetAccessLogSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccessLogSubscriptionRequest method.
//	req, resp := client.GetAccessLogSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetAccessLogSubscription
func (c *VPCLattice) GetAccessLogSubscriptionRequest(input *GetAccessLogSubscriptionInput) (req *request.Request, output *GetAccessLogSubscriptionOutput) {
	op := &request.Operation{
		Name:       opGetAccessLogSubscription,
		HTTPMethod: "GET",
		HTTPPath:   "/accesslogsubscriptions/{accessLogSubscriptionIdentifier}",
	}

	if input == nil {
		input = &GetAccessLogSubscriptionInput{}
	}

	output = &GetAccessLogSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccessLogSubscription API operation for Amazon VPC Lattice.
//
// Retrieves information about the specified access log subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation GetAccessLogSubscription for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetAccessLogSubscription
func (c *VPCLattice) GetAccessLogSubscription(input *GetAccessLogSubscriptionInput) (*GetAccessLogSubscriptionOutput, error) {
	req, out := c.GetAccessLogSubscriptionRequest(input)
	return out, req.Send()
}

// GetAccessLogSubscriptionWithContext is the same as GetAccessLogSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessLogSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) GetAccessLogSubscriptionWithContext(ctx aws.Context, input *GetAccessLogSubscriptionInput, opts ...request.Option) (*GetAccessLogSubscriptionOutput, error) {
	req, out := c.GetAccessLogSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAuthPolicy = "GetAuthPolicy"

// GetAuthPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetAuthPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAuthPolicy for more information on using the GetAuthPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAuthPolicyRequest method.
//	req, resp := client.GetAuthPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetAuthPolicy
func (c *VPCLattice) GetAuthPolicyRequest(input *GetAuthPolicyInput) (req *request.Request, output *GetAuthPolicyOutput) {
	op := &request.Operation{
		Name:       opGetAuthPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/authpolicy/{resourceIdentifier}",
	}

	if input == nil {
		input = &GetAuthPolicyInput{}
	}

	output = &GetAuthPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAuthPolicy API operation for Amazon VPC Lattice.
//
// Retrieves information about the auth policy for the specified service or
// service network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation GetAuthPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetAuthPolicy
func (c *VPCLattice) GetAuthPolicy(input *GetAuthPolicyInput) (*GetAuthPolicyOutput, error) {
	req, out := c.GetAuthPolicyRequest(input)
	return out, req.Send()
}

// GetAuthPolicyWithContext is the same as GetAuthPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetAuthPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) GetAuthPolicyWithContext(ctx aws.Context, input *GetAuthPolicyInput, opts ...request.Option) (*GetAuthPolicyOutput, error) {
	req, out := c.GetAuthPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetListener = "GetListener"

// GetListenerRequest generates a "aws/request.Request" representing the
// client's request for the GetListener operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetListener for more information on using the GetListener
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetListenerRequest method.
//	req, resp := client.GetListenerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetListener
func (c *VPCLattice) GetListenerRequest(input *GetListenerInput) (req *request.Request, output *GetListenerOutput) {
	op := &request.Operation{
		Name:       opGetListener,
		HTTPMethod: "GET",
		HTTPPath:   "/services/{serviceIdentifier}/listeners/{listenerIdentifier}",
	}

	if input == nil {
		input = &GetListenerInput{}
	}

	output = &GetListenerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetListener API operation for Amazon VPC Lattice.
//
// Retrieves information about the specified listener for the specified service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation GetListener for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetListener
func (c *VPCLattice) GetListener(input *GetListenerInput) (*GetListenerOutput, error) {
	req, out := c.GetListenerRequest(input)
	return out, req.Send()
}

// GetListenerWithContext is the same as GetListener with the addition of
// the ability to pass a context and additional request options.
//
// See GetListener for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) GetListenerWithContext(ctx aws.Context, input *GetListenerInput, opts ...request.Option) (*GetListenerOutput, error) {
	req, out := c.GetListenerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourcePolicy = "GetResourcePolicy"

// GetResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourcePolicy for more information on using the GetResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResourcePolicyRequest method.
//	req, resp := client.GetResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetResourcePolicy
func (c *VPCLattice) GetResourcePolicyRequest(input *GetResourcePolicyInput) (req *request.Request, output *GetResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opGetResourcePolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/resourcepolicy/{resourceArn}",
	}

	if input == nil {
		input = &GetResourcePolicyInput{}
	}

	output = &GetResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourcePolicy API operation for Amazon VPC Lattice.
//
// Retrieves information about the resource policy. The resource policy is an
// IAM policy created on behalf of the resource owner when they share a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation GetResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetResourcePolicy
func (c *VPCLattice) GetResourcePolicy(input *GetResourcePolicyInput) (*GetResourcePolicyOutput, error) {
	req, out := c.GetResourcePolicyRequest(input)
	return out, req.Send()
}

// GetResourcePolicyWithContext is the same as GetResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) GetResourcePolicyWithContext(ctx aws.Context, input *GetResourcePolicyInput, opts ...request.Option) (*GetResourcePolicyOutput, error) {
	req, out := c.GetResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRule = "GetRule"

// GetRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRule for more information on using the GetRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRuleRequest method.
//	req, resp := client.GetRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetRule
func (c *VPCLattice) GetRuleRequest(input *GetRuleInput) (req *request.Request, output *GetRuleOutput) {
	op := &request.Operation{
		Name:       opGetRule,
		HTTPMethod: "GET",
		HTTPPath:   "/services/{serviceIdentifier}/listeners/{listenerIdentifier}/rules/{ruleIdentifier}",
	}

	if input == nil {
		input = &GetRuleInput{}
	}

	output = &GetRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRule API operation for Amazon VPC Lattice.
//
// Retrieves information about listener rules. You can also retrieve information
// about the default listener rule. For more information, see Listener rules
// (https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules)
// in the Amazon VPC Lattice User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation GetRule for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetRule
func (c *VPCLattice) GetRule(input *GetRuleInput) (*GetRuleOutput, error) {
	req, out := c.GetRuleRequest(input)
	return out, req.Send()
}

// GetRuleWithContext is the same as GetRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) GetRuleWithContext(ctx aws.Context, input *GetRuleInput, opts ...request.Option) (*GetRuleOutput, error) {
	req, out := c.GetRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetService = "GetService"

// GetServiceRequest generates a "aws/request.Request" representing the
// client's request for the GetService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetService for more information on using the GetService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetServiceRequest method.
//	req, resp := client.GetServiceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetService
func (c *VPCLattice) GetServiceRequest(input *GetServiceInput) (req *request.Request, output *GetServiceOutput) {
	op := &request.Operation{
		Name:       opGetService,
		HTTPMethod: "GET",
		HTTPPath:   "/services/{serviceIdentifier}",
	}

	if input == nil {
		input = &GetServiceInput{}
	}

	output = &GetServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetService API operation for Amazon VPC Lattice.
//
// Retrieves information about the specified service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation GetService for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetService
func (c *VPCLattice) GetService(input *GetServiceInput) (*GetServiceOutput, error) {
	req, out := c.GetServiceRequest(input)
	return out, req.Send()
}

// GetServiceWithContext is the same as GetService with the addition of
// the ability to pass a context and additional request options.
//
// See GetService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) GetServiceWithContext(ctx aws.Context, input *GetServiceInput, opts ...request.Option) (*GetServiceOutput, error) {
	req, out := c.GetServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceNetwork = "GetServiceNetwork"

// GetServiceNetworkRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceNetwork operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceNetwork for more information on using the GetServiceNetwork
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetServiceNetworkRequest method.
//	req, resp := client.GetServiceNetworkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetwork
func (c *VPCLattice) GetServiceNetworkRequest(input *GetServiceNetworkInput) (req *request.Request, output *GetServiceNetworkOutput) {
	op := &request.Operation{
		Name:       opGetServiceNetwork,
		HTTPMethod: "GET",
		HTTPPath:   "/servicenetworks/{serviceNetworkIdentifier}",
	}

	if input == nil {
		input = &GetServiceNetworkInput{}
	}

	output = &GetServiceNetworkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceNetwork API operation for Amazon VPC Lattice.
//
// Retrieves information about the specified service network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation GetServiceNetwork for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetwork
func (c *VPCLattice) GetServiceNetwork(input *GetServiceNetworkInput) (*GetServiceNetworkOutput, error) {
	req, out := c.GetServiceNetworkRequest(input)
	return out, req.Send()
}

// GetServiceNetworkWithContext is the same as GetServiceNetwork with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceNetwork for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) GetServiceNetworkWithContext(ctx aws.Context, input *GetServiceNetworkInput, opts ...request.Option) (*GetServiceNetworkOutput, error) {
	req, out := c.GetServiceNetworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceNetworkServiceAssociation = "GetServiceNetworkServiceAssociation"

// GetServiceNetworkServiceAssociationRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceNetworkServiceAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceNetworkServiceAssociation for more information on using the GetServiceNetworkServiceAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetServiceNetworkServiceAssociationRequest method.
//	req, resp := client.GetServiceNetworkServiceAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetworkServiceAssociation
func (c *VPCLattice) GetServiceNetworkServiceAssociationRequest(input *GetServiceNetworkServiceAssociationInput) (req *request.Request, output *GetServiceNetworkServiceAssociationOutput) {
	op := &request.Operation{
		Name:       opGetServiceNetworkServiceAssociation,
		HTTPMethod: "GET",
		HTTPPath:   "/servicenetworkserviceassociations/{serviceNetworkServiceAssociationIdentifier}",
	}

	if input == nil {
		input = &GetServiceNetworkServiceAssociationInput{}
	}

	output = &GetServiceNetworkServiceAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceNetworkServiceAssociation API operation for Amazon VPC Lattice.
//
// Retrieves information about the specified association between a service network
// and a service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation GetServiceNetworkServiceAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetworkServiceAssociation
func (c *VPCLattice) GetServiceNetworkServiceAssociation(input *GetServiceNetworkServiceAssociationInput) (*GetServiceNetworkServiceAssociationOutput, error) {
	req, out := c.GetServiceNetworkServiceAssociationRequest(input)
	return out, req.Send()
}

// GetServiceNetworkServiceAssociationWithContext is the same as GetServiceNetworkServiceAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceNetworkServiceAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) GetServiceNetworkServiceAssociationWithContext(ctx aws.Context, input *GetServiceNetworkServiceAssociationInput, opts ...request.Option) (*GetServiceNetworkServiceAssociationOutput, error) {
	req, out := c.GetServiceNetworkServiceAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceNetworkVpcAssociation = "GetServiceNetworkVpcAssociation"

// GetServiceNetworkVpcAssociationRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceNetworkVpcAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceNetworkVpcAssociation for more information on using the GetServiceNetworkVpcAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetServiceNetworkVpcAssociationRequest method.
//	req, resp := client.GetServiceNetworkVpcAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetworkVpcAssociation
func (c *VPCLattice) GetServiceNetworkVpcAssociationRequest(input *GetServiceNetworkVpcAssociationInput) (req *request.Request, output *GetServiceNetworkVpcAssociationOutput) {
	op := &request.Operation{
		Name:       opGetServiceNetworkVpcAssociation,
		HTTPMethod: "GET",
		HTTPPath:   "/servicenetworkvpcassociations/{serviceNetworkVpcAssociationIdentifier}",
	}

	if input == nil {
		input = &GetServiceNetworkVpcAssociationInput{}
	}

	output = &GetServiceNetworkVpcAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceNetworkVpcAssociation API operation for Amazon VPC Lattice.
//
// Retrieves information about the association between a service network and
// a VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation GetServiceNetworkVpcAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetworkVpcAssociation
func (c *VPCLattice) GetServiceNetworkVpcAssociation(input *GetServiceNetworkVpcAssociationInput) (*GetServiceNetworkVpcAssociationOutput, error) {
	req, out := c.GetServiceNetworkVpcAssociationRequest(input)
	return out, req.Send()
}

// GetServiceNetworkVpcAssociationWithContext is the same as GetServiceNetworkVpcAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceNetworkVpcAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) GetServiceNetworkVpcAssociationWithContext(ctx aws.Context, input *GetServiceNetworkVpcAssociationInput, opts ...request.Option) (*GetServiceNetworkVpcAssociationOutput, error) {
	req, out := c.GetServiceNetworkVpcAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTargetGroup = "GetTargetGroup"

// GetTargetGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetTargetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTargetGroup for more information on using the GetTargetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTargetGroupRequest method.
//	req, resp := client.GetTargetGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetTargetGroup
func (c *VPCLattice) GetTargetGroupRequest(input *GetTargetGroupInput) (req *request.Request, output *GetTargetGroupOutput) {
	op := &request.Operation{
		Name:       opGetTargetGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/targetgroups/{targetGroupIdentifier}",
	}

	if input == nil {
		input = &GetTargetGroupInput{}
	}

	output = &GetTargetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTargetGroup API operation for Amazon VPC Lattice.
//
// Retrieves information about the specified target group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation GetTargetGroup for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetTargetGroup
func (c *VPCLattice) GetTargetGroup(input *GetTargetGroupInput) (*GetTargetGroupOutput, error) {
	req, out := c.GetTargetGroupRequest(input)
	return out, req.Send()
}

// GetTargetGroupWithContext is the same as GetTargetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetTargetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) GetTargetGroupWithContext(ctx aws.Context, input *GetTargetGroupInput, opts ...request.Option) (*GetTargetGroupOutput, error) {
	req, out := c.GetTargetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccessLogSubscriptions = "ListAccessLogSubscriptions"

// ListAccessLogSubscriptionsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccessLogSubscriptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccessLogSubscriptions for more information on using the ListAccessLogSubscriptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAccessLogSubscriptionsRequest method.
//	req, resp := client.ListAccessLogSubscriptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListAccessLogSubscriptions
func (c *VPCLattice) ListAccessLogSubscriptionsRequest(input *ListAccessLogSubscriptionsInput) (req *request.Request, output *ListAccessLogSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opListAccessLogSubscriptions,
		HTTPMethod: "GET",
		HTTPPath:   "/accesslogsubscriptions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccessLogSubscriptionsInput{}
	}

	output = &ListAccessLogSubscriptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccessLogSubscriptions API operation for Amazon VPC Lattice.
//
// Lists all access log subscriptions for the specified service network or service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation ListAccessLogSubscriptions for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListAccessLogSubscriptions
func (c *VPCLattice) ListAccessLogSubscriptions(input *ListAccessLogSubscriptionsInput) (*ListAccessLogSubscriptionsOutput, error) {
	req, out := c.ListAccessLogSubscriptionsRequest(input)
	return out, req.Send()
}

// ListAccessLogSubscriptionsWithContext is the same as ListAccessLogSubscriptions with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccessLogSubscriptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) ListAccessLogSubscriptionsWithContext(ctx aws.Context, input *ListAccessLogSubscriptionsInput, opts ...request.Option) (*ListAccessLogSubscriptionsOutput, error) {
	req, out := c.ListAccessLogSubscriptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccessLogSubscriptionsPages iterates over the pages of a ListAccessLogSubscriptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccessLogSubscriptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAccessLogSubscriptions operation.
//	pageNum := 0
//	err := client.ListAccessLogSubscriptionsPages(params,
//	    func(page *vpclattice.ListAccessLogSubscriptionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *VPCLattice) ListAccessLogSubscriptionsPages(input *ListAccessLogSubscriptionsInput, fn func(*ListAccessLogSubscriptionsOutput, bool) bool) error {
	return c.ListAccessLogSubscriptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccessLogSubscriptionsPagesWithContext same as ListAccessLogSubscriptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) ListAccessLogSubscriptionsPagesWithContext(ctx aws.Context, input *ListAccessLogSubscriptionsInput, fn func(*ListAccessLogSubscriptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccessLogSubscriptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccessLogSubscriptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccessLogSubscriptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListListeners = "ListListeners"

// ListListenersRequest generates a "aws/request.Request" representing the
// client's request for the ListListeners operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListListeners for more information on using the ListListeners
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListListenersRequest method.
//	req, resp := client.ListListenersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListListeners
func (c *VPCLattice) ListListenersRequest(input *ListListenersInput) (req *request.Request, output *ListListenersOutput) {
	op := &request.Operation{
		Name:       opListListeners,
		HTTPMethod: "GET",
		HTTPPath:   "/services/{serviceIdentifier}/listeners",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListListenersInput{}
	}

	output = &ListListenersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListListeners API operation for Amazon VPC Lattice.
//
// Lists the listeners for the specified service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation ListListeners for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListListeners
func (c *VPCLattice) ListListeners(input *ListListenersInput) (*ListListenersOutput, error) {
	req, out := c.ListListenersRequest(input)
	return out, req.Send()
}

// ListListenersWithContext is the same as ListListeners with the addition of
// the ability to pass a context and additional request options.
//
// See ListListeners for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) ListListenersWithContext(ctx aws.Context, input *ListListenersInput, opts ...request.Option) (*ListListenersOutput, error) {
	req, out := c.ListListenersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListListenersPages iterates over the pages of a ListListeners operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListListeners method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListListeners operation.
//	pageNum := 0
//	err := client.ListListenersPages(params,
//	    func(page *vpclattice.ListListenersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *VPCLattice) ListListenersPages(input *ListListenersInput, fn func(*ListListenersOutput, bool) bool) error {
	return c.ListListenersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListListenersPagesWithContext same as ListListenersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) ListListenersPagesWithContext(ctx aws.Context, input *ListListenersInput, fn func(*ListListenersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListListenersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListListenersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListListenersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRules = "ListRules"

// ListRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRules for more information on using the ListRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRulesRequest method.
//	req, resp := client.ListRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListRules
func (c *VPCLattice) ListRulesRequest(input *ListRulesInput) (req *request.Request, output *ListRulesOutput) {
	op := &request.Operation{
		Name:       opListRules,
		HTTPMethod: "GET",
		HTTPPath:   "/services/{serviceIdentifier}/listeners/{listenerIdentifier}/rules",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRulesInput{}
	}

	output = &ListRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRules API operation for Amazon VPC Lattice.
//
// Lists the rules for the listener.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation ListRules for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListRules
func (c *VPCLattice) ListRules(input *ListRulesInput) (*ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	return out, req.Send()
}

// ListRulesWithContext is the same as ListRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) ListRulesWithContext(ctx aws.Context, input *ListRulesInput, opts ...request.Option) (*ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRulesPages iterates over the pages of a ListRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRules operation.
//	pageNum := 0
//	err := client.ListRulesPages(params,
//	    func(page *vpclattice.ListRulesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *VPCLattice) ListRulesPages(input *ListRulesInput, fn func(*ListRulesOutput, bool) bool) error {
	return c.ListRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRulesPagesWithContext same as ListRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) ListRulesPagesWithContext(ctx aws.Context, input *ListRulesInput, fn func(*ListRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServiceNetworkServiceAssociations = "ListServiceNetworkServiceAssociations"

// ListServiceNetworkServiceAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListServiceNetworkServiceAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServiceNetworkServiceAssociations for more information on using the ListServiceNetworkServiceAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServiceNetworkServiceAssociationsRequest method.
//	req, resp := client.ListServiceNetworkServiceAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkServiceAssociations
func (c *VPCLattice) ListServiceNetworkServiceAssociationsRequest(input *ListServiceNetworkServiceAssociationsInput) (req *request.Request, output *ListServiceNetworkServiceAssociationsOutput) {
	op := &request.Operation{
		Name:       opListServiceNetworkServiceAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/servicenetworkserviceassociations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServiceNetworkServiceAssociationsInput{}
	}

	output = &ListServiceNetworkServiceAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServiceNetworkServiceAssociations API operation for Amazon VPC Lattice.
//
// Lists the associations between the service network and the service. You can
// filter the list either by service or service network. You must provide either
// the service network identifier or the service identifier.
//
// Every association in Amazon VPC Lattice is given a unique Amazon Resource
// Name (ARN), such as when a service network is associated with a VPC or when
// a service is associated with a service network. If the association is for
// a resource that is shared with another account, the association includes
// the local account ID as the prefix in the ARN for each account the resource
// is shared with.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation ListServiceNetworkServiceAssociations for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkServiceAssociations
func (c *VPCLattice) ListServiceNetworkServiceAssociations(input *ListServiceNetworkServiceAssociationsInput) (*ListServiceNetworkServiceAssociationsOutput, error) {
	req, out := c.ListServiceNetworkServiceAssociationsRequest(input)
	return out, req.Send()
}

// ListServiceNetworkServiceAssociationsWithContext is the same as ListServiceNetworkServiceAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListServiceNetworkServiceAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) ListServiceNetworkServiceAssociationsWithContext(ctx aws.Context, input *ListServiceNetworkServiceAssociationsInput, opts ...request.Option) (*ListServiceNetworkServiceAssociationsOutput, error) {
	req, out := c.ListServiceNetworkServiceAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServiceNetworkServiceAssociationsPages iterates over the pages of a ListServiceNetworkServiceAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServiceNetworkServiceAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListServiceNetworkServiceAssociations operation.
//	pageNum := 0
//	err := client.ListServiceNetworkServiceAssociationsPages(params,
//	    func(page *vpclattice.ListServiceNetworkServiceAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *VPCLattice) ListServiceNetworkServiceAssociationsPages(input *ListServiceNetworkServiceAssociationsInput, fn func(*ListServiceNetworkServiceAssociationsOutput, bool) bool) error {
	return c.ListServiceNetworkServiceAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServiceNetworkServiceAssociationsPagesWithContext same as ListServiceNetworkServiceAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) ListServiceNetworkServiceAssociationsPagesWithContext(ctx aws.Context, input *ListServiceNetworkServiceAssociationsInput, fn func(*ListServiceNetworkServiceAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServiceNetworkServiceAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServiceNetworkServiceAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServiceNetworkServiceAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServiceNetworkVpcAssociations = "ListServiceNetworkVpcAssociations"

// ListServiceNetworkVpcAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListServiceNetworkVpcAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServiceNetworkVpcAssociations for more information on using the ListServiceNetworkVpcAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServiceNetworkVpcAssociationsRequest method.
//	req, resp := client.ListServiceNetworkVpcAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkVpcAssociations
func (c *VPCLattice) ListServiceNetworkVpcAssociationsRequest(input *ListServiceNetworkVpcAssociationsInput) (req *request.Request, output *ListServiceNetworkVpcAssociationsOutput) {
	op := &request.Operation{
		Name:       opListServiceNetworkVpcAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/servicenetworkvpcassociations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServiceNetworkVpcAssociationsInput{}
	}

	output = &ListServiceNetworkVpcAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServiceNetworkVpcAssociations API operation for Amazon VPC Lattice.
//
// Lists the service network and VPC associations. You can filter the list either
// by VPC or service network. You must provide either the service network identifier
// or the VPC identifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation ListServiceNetworkVpcAssociations for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkVpcAssociations
func (c *VPCLattice) ListServiceNetworkVpcAssociations(input *ListServiceNetworkVpcAssociationsInput) (*ListServiceNetworkVpcAssociationsOutput, error) {
	req, out := c.ListServiceNetworkVpcAssociationsRequest(input)
	return out, req.Send()
}

// ListServiceNetworkVpcAssociationsWithContext is the same as ListServiceNetworkVpcAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListServiceNetworkVpcAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) ListServiceNetworkVpcAssociationsWithContext(ctx aws.Context, input *ListServiceNetworkVpcAssociationsInput, opts ...request.Option) (*ListServiceNetworkVpcAssociationsOutput, error) {
	req, out := c.ListServiceNetworkVpcAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServiceNetworkVpcAssociationsPages iterates over the pages of a ListServiceNetworkVpcAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServiceNetworkVpcAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListServiceNetworkVpcAssociations operation.
//	pageNum := 0
//	err := client.ListServiceNetworkVpcAssociationsPages(params,
//	    func(page *vpclattice.ListServiceNetworkVpcAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *VPCLattice) ListServiceNetworkVpcAssociationsPages(input *ListServiceNetworkVpcAssociationsInput, fn func(*ListServiceNetworkVpcAssociationsOutput, bool) bool) error {
	return c.ListServiceNetworkVpcAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServiceNetworkVpcAssociationsPagesWithContext same as ListServiceNetworkVpcAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) ListServiceNetworkVpcAssociationsPagesWithContext(ctx aws.Context, input *ListServiceNetworkVpcAssociationsInput, fn func(*ListServiceNetworkVpcAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServiceNetworkVpcAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServiceNetworkVpcAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServiceNetworkVpcAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServiceNetworks = "ListServiceNetworks"

// ListServiceNetworksRequest generates a "aws/request.Request" representing the
// client's request for the ListServiceNetworks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServiceNetworks for more information on using the ListServiceNetworks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServiceNetworksRequest method.
//	req, resp := client.ListServiceNetworksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworks
func (c *VPCLattice) ListServiceNetworksRequest(input *ListServiceNetworksInput) (req *request.Request, output *ListServiceNetworksOutput) {
	op := &request.Operation{
		Name:       opListServiceNetworks,
		HTTPMethod: "GET",
		HTTPPath:   "/servicenetworks",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServiceNetworksInput{}
	}

	output = &ListServiceNetworksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServiceNetworks API operation for Amazon VPC Lattice.
//
// Lists the service networks owned by the caller account or shared with the
// caller account. Also includes the account ID in the ARN to show which account
// owns the service network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation ListServiceNetworks for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworks
func (c *VPCLattice) ListServiceNetworks(input *ListServiceNetworksInput) (*ListServiceNetworksOutput, error) {
	req, out := c.ListServiceNetworksRequest(input)
	return out, req.Send()
}

// ListServiceNetworksWithContext is the same as ListServiceNetworks with the addition of
// the ability to pass a context and additional request options.
//
// See ListServiceNetworks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) ListServiceNetworksWithContext(ctx aws.Context, input *ListServiceNetworksInput, opts ...request.Option) (*ListServiceNetworksOutput, error) {
	req, out := c.ListServiceNetworksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServiceNetworksPages iterates over the pages of a ListServiceNetworks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServiceNetworks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListServiceNetworks operation.
//	pageNum := 0
//	err := client.ListServiceNetworksPages(params,
//	    func(page *vpclattice.ListServiceNetworksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *VPCLattice) ListServiceNetworksPages(input *ListServiceNetworksInput, fn func(*ListServiceNetworksOutput, bool) bool) error {
	return c.ListServiceNetworksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServiceNetworksPagesWithContext same as ListServiceNetworksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) ListServiceNetworksPagesWithContext(ctx aws.Context, input *ListServiceNetworksInput, fn func(*ListServiceNetworksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServiceNetworksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServiceNetworksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServiceNetworksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServices = "ListServices"

// ListServicesRequest generates a "aws/request.Request" representing the
// client's request for the ListServices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServices for more information on using the ListServices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServicesRequest method.
//	req, resp := client.ListServicesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServices
func (c *VPCLattice) ListServicesRequest(input *ListServicesInput) (req *request.Request, output *ListServicesOutput) {
	op := &request.Operation{
		Name:       opListServices,
		HTTPMethod: "GET",
		HTTPPath:   "/services",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServicesInput{}
	}

	output = &ListServicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServices API operation for Amazon VPC Lattice.
//
// Lists the services owned by the caller account or shared with the caller
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation ListServices for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServices
func (c *VPCLattice) ListServices(input *ListServicesInput) (*ListServicesOutput, error) {
	req, out := c.ListServicesRequest(input)
	return out, req.Send()
}

// ListServicesWithContext is the same as ListServices with the addition of
// the ability to pass a context and additional request options.
//
// See ListServices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) ListServicesWithContext(ctx aws.Context, input *ListServicesInput, opts ...request.Option) (*ListServicesOutput, error) {
	req, out := c.ListServicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServicesPages iterates over the pages of a ListServices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListServices operation.
//	pageNum := 0
//	err := client.ListServicesPages(params,
//	    func(page *vpclattice.ListServicesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *VPCLattice) ListServicesPages(input *ListServicesInput, fn func(*ListServicesOutput, bool) bool) error {
	return c.ListServicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServicesPagesWithContext same as ListServicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) ListServicesPagesWithContext(ctx aws.Context, input *ListServicesInput, fn func(*ListServicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTagsForResource
func (c *VPCLattice) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon VPC Lattice.
//
// Lists the tags for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTagsForResource
func (c *VPCLattice) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTargetGroups = "ListTargetGroups"

// ListTargetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListTargetGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTargetGroups for more information on using the ListTargetGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTargetGroupsRequest method.
//	req, resp := client.ListTargetGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTargetGroups
func (c *VPCLattice) ListTargetGroupsRequest(input *ListTargetGroupsInput) (req *request.Request, output *ListTargetGroupsOutput) {
	op := &request.Operation{
		Name:       opListTargetGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/targetgroups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTargetGroupsInput{}
	}

	output = &ListTargetGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTargetGroups API operation for Amazon VPC Lattice.
//
// Lists your target groups. You can narrow your search by using the filters
// below in your request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation ListTargetGroups for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTargetGroups
func (c *VPCLattice) ListTargetGroups(input *ListTargetGroupsInput) (*ListTargetGroupsOutput, error) {
	req, out := c.ListTargetGroupsRequest(input)
	return out, req.Send()
}

// ListTargetGroupsWithContext is the same as ListTargetGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListTargetGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) ListTargetGroupsWithContext(ctx aws.Context, input *ListTargetGroupsInput, opts ...request.Option) (*ListTargetGroupsOutput, error) {
	req, out := c.ListTargetGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTargetGroupsPages iterates over the pages of a ListTargetGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTargetGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTargetGroups operation.
//	pageNum := 0
//	err := client.ListTargetGroupsPages(params,
//	    func(page *vpclattice.ListTargetGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *VPCLattice) ListTargetGroupsPages(input *ListTargetGroupsInput, fn func(*ListTargetGroupsOutput, bool) bool) error {
	return c.ListTargetGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTargetGroupsPagesWithContext same as ListTargetGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) ListTargetGroupsPagesWithContext(ctx aws.Context, input *ListTargetGroupsInput, fn func(*ListTargetGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTargetGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTargetGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTargetGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTargets = "ListTargets"

// ListTargetsRequest generates a "aws/request.Request" representing the
// client's request for the ListTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTargets for more information on using the ListTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTargetsRequest method.
//	req, resp := client.ListTargetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTargets
func (c *VPCLattice) ListTargetsRequest(input *ListTargetsInput) (req *request.Request, output *ListTargetsOutput) {
	op := &request.Operation{
		Name:       opListTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/targetgroups/{targetGroupIdentifier}/listtargets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTargetsInput{}
	}

	output = &ListTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTargets API operation for Amazon VPC Lattice.
//
// Lists the targets for the target group. By default, all targets are included.
// You can use this API to check the health status of targets. You can also
// ﬁlter the results by target.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation ListTargets for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTargets
func (c *VPCLattice) ListTargets(input *ListTargetsInput) (*ListTargetsOutput, error) {
	req, out := c.ListTargetsRequest(input)
	return out, req.Send()
}

// ListTargetsWithContext is the same as ListTargets with the addition of
// the ability to pass a context and additional request options.
//
// See ListTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) ListTargetsWithContext(ctx aws.Context, input *ListTargetsInput, opts ...request.Option) (*ListTargetsOutput, error) {
	req, out := c.ListTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTargetsPages iterates over the pages of a ListTargets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTargets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTargets operation.
//	pageNum := 0
//	err := client.ListTargetsPages(params,
//	    func(page *vpclattice.ListTargetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *VPCLattice) ListTargetsPages(input *ListTargetsInput, fn func(*ListTargetsOutput, bool) bool) error {
	return c.ListTargetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTargetsPagesWithContext same as ListTargetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) ListTargetsPagesWithContext(ctx aws.Context, input *ListTargetsInput, fn func(*ListTargetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTargetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTargetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTargetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutAuthPolicy = "PutAuthPolicy"

// PutAuthPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutAuthPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAuthPolicy for more information on using the PutAuthPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutAuthPolicyRequest method.
//	req, resp := client.PutAuthPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/PutAuthPolicy
func (c *VPCLattice) PutAuthPolicyRequest(input *PutAuthPolicyInput) (req *request.Request, output *PutAuthPolicyOutput) {
	op := &request.Operation{
		Name:       opPutAuthPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/authpolicy/{resourceIdentifier}",
	}

	if input == nil {
		input = &PutAuthPolicyInput{}
	}

	output = &PutAuthPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutAuthPolicy API operation for Amazon VPC Lattice.
//
// Creates or updates the auth policy. The policy string in JSON must not contain
// newlines or blank lines.
//
// For more information, see Auth policies (https://docs.aws.amazon.com/vpc-lattice/latest/ug/auth-policies.html)
// in the Amazon VPC Lattice User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation PutAuthPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/PutAuthPolicy
func (c *VPCLattice) PutAuthPolicy(input *PutAuthPolicyInput) (*PutAuthPolicyOutput, error) {
	req, out := c.PutAuthPolicyRequest(input)
	return out, req.Send()
}

// PutAuthPolicyWithContext is the same as PutAuthPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutAuthPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) PutAuthPolicyWithContext(ctx aws.Context, input *PutAuthPolicyInput, opts ...request.Option) (*PutAuthPolicyOutput, error) {
	req, out := c.PutAuthPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutResourcePolicy = "PutResourcePolicy"

// PutResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResourcePolicy for more information on using the PutResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutResourcePolicyRequest method.
//	req, resp := client.PutResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/PutResourcePolicy
func (c *VPCLattice) PutResourcePolicyRequest(input *PutResourcePolicyInput) (req *request.Request, output *PutResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opPutResourcePolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/resourcepolicy/{resourceArn}",
	}

	if input == nil {
		input = &PutResourcePolicyInput{}
	}

	output = &PutResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutResourcePolicy API operation for Amazon VPC Lattice.
//
// Attaches a resource-based permission policy to a service or service network.
// The policy must contain the same actions and condition statements as the
// Amazon Web Services Resource Access Manager permission for sharing services
// and service networks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation PutResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/PutResourcePolicy
func (c *VPCLattice) PutResourcePolicy(input *PutResourcePolicyInput) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	return out, req.Send()
}

// PutResourcePolicyWithContext is the same as PutResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) PutResourcePolicyWithContext(ctx aws.Context, input *PutResourcePolicyInput, opts ...request.Option) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterTargets = "RegisterTargets"

// RegisterTargetsRequest generates a "aws/request.Request" representing the
// client's request for the RegisterTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterTargets for more information on using the RegisterTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterTargetsRequest method.
//	req, resp := client.RegisterTargetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/RegisterTargets
func (c *VPCLattice) RegisterTargetsRequest(input *RegisterTargetsInput) (req *request.Request, output *RegisterTargetsOutput) {
	op := &request.Operation{
		Name:       opRegisterTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/targetgroups/{targetGroupIdentifier}/registertargets",
	}

	if input == nil {
		input = &RegisterTargetsInput{}
	}

	output = &RegisterTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterTargets API operation for Amazon VPC Lattice.
//
// Registers the targets with the target group. If it's a Lambda target, you
// can only have one target in a target group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation RegisterTargets for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/RegisterTargets
func (c *VPCLattice) RegisterTargets(input *RegisterTargetsInput) (*RegisterTargetsOutput, error) {
	req, out := c.RegisterTargetsRequest(input)
	return out, req.Send()
}

// RegisterTargetsWithContext is the same as RegisterTargets with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) RegisterTargetsWithContext(ctx aws.Context, input *RegisterTargetsInput, opts ...request.Option) (*RegisterTargetsOutput, error) {
	req, out := c.RegisterTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/TagResource
func (c *VPCLattice) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon VPC Lattice.
//
// Adds the specified tags to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/TagResource
func (c *VPCLattice) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UntagResource
func (c *VPCLattice) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon VPC Lattice.
//
// Removes the specified tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UntagResource
func (c *VPCLattice) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccessLogSubscription = "UpdateAccessLogSubscription"

// UpdateAccessLogSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccessLogSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccessLogSubscription for more information on using the UpdateAccessLogSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAccessLogSubscriptionRequest method.
//	req, resp := client.UpdateAccessLogSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateAccessLogSubscription
func (c *VPCLattice) UpdateAccessLogSubscriptionRequest(input *UpdateAccessLogSubscriptionInput) (req *request.Request, output *UpdateAccessLogSubscriptionOutput) {
	op := &request.Operation{
		Name:       opUpdateAccessLogSubscription,
		HTTPMethod: "PATCH",
		HTTPPath:   "/accesslogsubscriptions/{accessLogSubscriptionIdentifier}",
	}

	if input == nil {
		input = &UpdateAccessLogSubscriptionInput{}
	}

	output = &UpdateAccessLogSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccessLogSubscription API operation for Amazon VPC Lattice.
//
// Updates the specified access log subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation UpdateAccessLogSubscription for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateAccessLogSubscription
func (c *VPCLattice) UpdateAccessLogSubscription(input *UpdateAccessLogSubscriptionInput) (*UpdateAccessLogSubscriptionOutput, error) {
	req, out := c.UpdateAccessLogSubscriptionRequest(input)
	return out, req.Send()
}

// UpdateAccessLogSubscriptionWithContext is the same as UpdateAccessLogSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccessLogSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) UpdateAccessLogSubscriptionWithContext(ctx aws.Context, input *UpdateAccessLogSubscriptionInput, opts ...request.Option) (*UpdateAccessLogSubscriptionOutput, error) {
	req, out := c.UpdateAccessLogSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateListener = "UpdateListener"

// UpdateListenerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateListener operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateListener for more information on using the UpdateListener
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateListenerRequest method.
//	req, resp := client.UpdateListenerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateListener
func (c *VPCLattice) UpdateListenerRequest(input *UpdateListenerInput) (req *request.Request, output *UpdateListenerOutput) {
	op := &request.Operation{
		Name:       opUpdateListener,
		HTTPMethod: "PATCH",
		HTTPPath:   "/services/{serviceIdentifier}/listeners/{listenerIdentifier}",
	}

	if input == nil {
		input = &UpdateListenerInput{}
	}

	output = &UpdateListenerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateListener API operation for Amazon VPC Lattice.
//
// Updates the specified listener for the specified service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation UpdateListener for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateListener
func (c *VPCLattice) UpdateListener(input *UpdateListenerInput) (*UpdateListenerOutput, error) {
	req, out := c.UpdateListenerRequest(input)
	return out, req.Send()
}

// UpdateListenerWithContext is the same as UpdateListener with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateListener for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) UpdateListenerWithContext(ctx aws.Context, input *UpdateListenerInput, opts ...request.Option) (*UpdateListenerOutput, error) {
	req, out := c.UpdateListenerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRule = "UpdateRule"

// UpdateRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRule for more information on using the UpdateRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRuleRequest method.
//	req, resp := client.UpdateRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateRule
func (c *VPCLattice) UpdateRuleRequest(input *UpdateRuleInput) (req *request.Request, output *UpdateRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateRule,
		HTTPMethod: "PATCH",
		HTTPPath:   "/services/{serviceIdentifier}/listeners/{listenerIdentifier}/rules/{ruleIdentifier}",
	}

	if input == nil {
		input = &UpdateRuleInput{}
	}

	output = &UpdateRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRule API operation for Amazon VPC Lattice.
//
// Updates a rule for the listener. You can't modify a default listener rule.
// To modify a default listener rule, use UpdateListener.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation UpdateRule for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateRule
func (c *VPCLattice) UpdateRule(input *UpdateRuleInput) (*UpdateRuleOutput, error) {
	req, out := c.UpdateRuleRequest(input)
	return out, req.Send()
}

// UpdateRuleWithContext is the same as UpdateRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) UpdateRuleWithContext(ctx aws.Context, input *UpdateRuleInput, opts ...request.Option) (*UpdateRuleOutput, error) {
	req, out := c.UpdateRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateService = "UpdateService"

// UpdateServiceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateService for more information on using the UpdateService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateServiceRequest method.
//	req, resp := client.UpdateServiceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateService
func (c *VPCLattice) UpdateServiceRequest(input *UpdateServiceInput) (req *request.Request, output *UpdateServiceOutput) {
	op := &request.Operation{
		Name:       opUpdateService,
		HTTPMethod: "PATCH",
		HTTPPath:   "/services/{serviceIdentifier}",
	}

	if input == nil {
		input = &UpdateServiceInput{}
	}

	output = &UpdateServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateService API operation for Amazon VPC Lattice.
//
// Updates the specified service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation UpdateService for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateService
func (c *VPCLattice) UpdateService(input *UpdateServiceInput) (*UpdateServiceOutput, error) {
	req, out := c.UpdateServiceRequest(input)
	return out, req.Send()
}

// UpdateServiceWithContext is the same as UpdateService with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) UpdateServiceWithContext(ctx aws.Context, input *UpdateServiceInput, opts ...request.Option) (*UpdateServiceOutput, error) {
	req, out := c.UpdateServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServiceNetwork = "UpdateServiceNetwork"

// UpdateServiceNetworkRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServiceNetwork operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServiceNetwork for more information on using the UpdateServiceNetwork
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateServiceNetworkRequest method.
//	req, resp := client.UpdateServiceNetworkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateServiceNetwork
func (c *VPCLattice) UpdateServiceNetworkRequest(input *UpdateServiceNetworkInput) (req *request.Request, output *UpdateServiceNetworkOutput) {
	op := &request.Operation{
		Name:       opUpdateServiceNetwork,
		HTTPMethod: "PATCH",
		HTTPPath:   "/servicenetworks/{serviceNetworkIdentifier}",
	}

	if input == nil {
		input = &UpdateServiceNetworkInput{}
	}

	output = &UpdateServiceNetworkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateServiceNetwork API operation for Amazon VPC Lattice.
//
// Updates the specified service network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation UpdateServiceNetwork for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateServiceNetwork
func (c *VPCLattice) UpdateServiceNetwork(input *UpdateServiceNetworkInput) (*UpdateServiceNetworkOutput, error) {
	req, out := c.UpdateServiceNetworkRequest(input)
	return out, req.Send()
}

// UpdateServiceNetworkWithContext is the same as UpdateServiceNetwork with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServiceNetwork for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) UpdateServiceNetworkWithContext(ctx aws.Context, input *UpdateServiceNetworkInput, opts ...request.Option) (*UpdateServiceNetworkOutput, error) {
	req, out := c.UpdateServiceNetworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServiceNetworkVpcAssociation = "UpdateServiceNetworkVpcAssociation"

// UpdateServiceNetworkVpcAssociationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServiceNetworkVpcAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServiceNetworkVpcAssociation for more information on using the UpdateServiceNetworkVpcAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateServiceNetworkVpcAssociationRequest method.
//	req, resp := client.UpdateServiceNetworkVpcAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateServiceNetworkVpcAssociation
func (c *VPCLattice) UpdateServiceNetworkVpcAssociationRequest(input *UpdateServiceNetworkVpcAssociationInput) (req *request.Request, output *UpdateServiceNetworkVpcAssociationOutput) {
	op := &request.Operation{
		Name:       opUpdateServiceNetworkVpcAssociation,
		HTTPMethod: "PATCH",
		HTTPPath:   "/servicenetworkvpcassociations/{serviceNetworkVpcAssociationIdentifier}",
	}

	if input == nil {
		input = &UpdateServiceNetworkVpcAssociationInput{}
	}

	output = &UpdateServiceNetworkVpcAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateServiceNetworkVpcAssociation API operation for Amazon VPC Lattice.
//
// Updates the service network and VPC association. If you add a security group
// to the service network and VPC association, the association must continue
// to always have at least one security group. You can add or edit security
// groups at any time. However, to remove all security groups, you must first
// delete the association and recreate it without security groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation UpdateServiceNetworkVpcAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateServiceNetworkVpcAssociation
func (c *VPCLattice) UpdateServiceNetworkVpcAssociation(input *UpdateServiceNetworkVpcAssociationInput) (*UpdateServiceNetworkVpcAssociationOutput, error) {
	req, out := c.UpdateServiceNetworkVpcAssociationRequest(input)
	return out, req.Send()
}

// UpdateServiceNetworkVpcAssociationWithContext is the same as UpdateServiceNetworkVpcAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServiceNetworkVpcAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) UpdateServiceNetworkVpcAssociationWithContext(ctx aws.Context, input *UpdateServiceNetworkVpcAssociationInput, opts ...request.Option) (*UpdateServiceNetworkVpcAssociationOutput, error) {
	req, out := c.UpdateServiceNetworkVpcAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTargetGroup = "UpdateTargetGroup"

// UpdateTargetGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTargetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTargetGroup for more information on using the UpdateTargetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTargetGroupRequest method.
//	req, resp := client.UpdateTargetGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateTargetGroup
func (c *VPCLattice) UpdateTargetGroupRequest(input *UpdateTargetGroupInput) (req *request.Request, output *UpdateTargetGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateTargetGroup,
		HTTPMethod: "PATCH",
		HTTPPath:   "/targetgroups/{targetGroupIdentifier}",
	}

	if input == nil {
		input = &UpdateTargetGroupInput{}
	}

	output = &UpdateTargetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTargetGroup API operation for Amazon VPC Lattice.
//
// Updates the specified target group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon VPC Lattice's
// API operation UpdateTargetGroup for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input does not satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ConflictException
//     The request conflicts with the current state of the resource. Updating or
//     deleting a resource can cause an inconsistent state.
//
//   - InternalServerException
//     An unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateTargetGroup
func (c *VPCLattice) UpdateTargetGroup(input *UpdateTargetGroupInput) (*UpdateTargetGroupOutput, error) {
	req, out := c.UpdateTargetGroupRequest(input)
	return out, req.Send()
}

// UpdateTargetGroupWithContext is the same as UpdateTargetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTargetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPCLattice) UpdateTargetGroupWithContext(ctx aws.Context, input *UpdateTargetGroupInput, opts ...request.Option) (*UpdateTargetGroupOutput, error) {
	req, out := c.UpdateTargetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The user does not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Summary information about an access log subscription.
type AccessLogSubscriptionSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the access log subscription
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The date and time that the access log subscription was created, specified
	// in ISO-8601 format.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the destination.
	//
	// DestinationArn is a required field
	DestinationArn *string `locationName:"destinationArn" min:"20" type:"string" required:"true"`

	// The ID of the access log subscription.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"21" type:"string" required:"true"`

	// The date and time that the access log subscription was last updated, specified
	// in ISO-8601 format.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the service or service network.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The ID of the service or service network.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessLogSubscriptionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessLogSubscriptionSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AccessLogSubscriptionSummary) SetArn(v string) *AccessLogSubscriptionSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AccessLogSubscriptionSummary) SetCreatedAt(v time.Time) *AccessLogSubscriptionSummary {
	s.CreatedAt = &v
	return s
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *AccessLogSubscriptionSummary) SetDestinationArn(v string) *AccessLogSubscriptionSummary {
	s.DestinationArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *AccessLogSubscriptionSummary) SetId(v string) *AccessLogSubscriptionSummary {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *AccessLogSubscriptionSummary) SetLastUpdatedAt(v time.Time) *AccessLogSubscriptionSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AccessLogSubscriptionSummary) SetResourceArn(v string) *AccessLogSubscriptionSummary {
	s.ResourceArn = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *AccessLogSubscriptionSummary) SetResourceId(v string) *AccessLogSubscriptionSummary {
	s.ResourceId = &v
	return s
}

type BatchUpdateRuleInput struct {
	_ struct{} `type:"structure"`

	// The ID or Amazon Resource Name (ARN) of the listener.
	//
	// ListenerIdentifier is a required field
	ListenerIdentifier *string `location:"uri" locationName:"listenerIdentifier" min:"20" type:"string" required:"true"`

	// The rules for the specified listener.
	//
	// Rules is a required field
	Rules []*RuleUpdate `locationName:"rules" min:"1" type:"list" required:"true"`

	// The ID or Amazon Resource Name (ARN) of the service.
	//
	// ServiceIdentifier is a required field
	ServiceIdentifier *string `location:"uri" locationName:"serviceIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdateRuleInput"}
	if s.ListenerIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerIdentifier"))
	}
	if s.ListenerIdentifier != nil && len(*s.ListenerIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ListenerIdentifier", 20))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil && len(s.Rules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rules", 1))
	}
	if s.ServiceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceIdentifier"))
	}
	if s.ServiceIdentifier != nil && len(*s.ServiceIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceIdentifier", 17))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListenerIdentifier sets the ListenerIdentifier field's value.
func (s *BatchUpdateRuleInput) SetListenerIdentifier(v string) *BatchUpdateRuleInput {
	s.ListenerIdentifier = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *BatchUpdateRuleInput) SetRules(v []*RuleUpdate) *BatchUpdateRuleInput {
	s.Rules = v
	return s
}

// SetServiceIdentifier sets the ServiceIdentifier field's value.
func (s *BatchUpdateRuleInput) SetServiceIdentifier(v string) *BatchUpdateRuleInput {
	s.ServiceIdentifier = &v
	return s
}

type BatchUpdateRuleOutput struct {
	_ struct{} `type:"structure"`

	// The rules that were successfully updated.
	Successful []*RuleUpdateSuccess `locationName:"successful" type:"list"`

	// The rules that the operation couldn't update.
	Unsuccessful []*RuleUpdateFailure `locationName:"unsuccessful" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateRuleOutput) GoString() string {
	return s.String()
}

// SetSuccessful sets the Successful field's value.
func (s *BatchUpdateRuleOutput) SetSuccessful(v []*RuleUpdateSuccess) *BatchUpdateRuleOutput {
	s.Successful = v
	return s
}

// SetUnsuccessful sets the Unsuccessful field's value.
func (s *BatchUpdateRuleOutput) SetUnsuccessful(v []*RuleUpdateFailure) *BatchUpdateRuleOutput {
	s.Unsuccessful = v
	return s
}

// The request conflicts with the current state of the resource. Updating or
// deleting a resource can cause an inconsistent state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The resource ID.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The resource type.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAccessLogSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you retry a request that completed successfully using
	// the same client token and parameters, the retry succeeds without performing
	// any actions. If the parameters aren't identical, the retry fails.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the destination. The supported destination
	// types are CloudWatch Log groups, Kinesis Data Firehose delivery streams,
	// and Amazon S3 buckets.
	//
	// DestinationArn is a required field
	DestinationArn *string `locationName:"destinationArn" min:"20" type:"string" required:"true"`

	// The ID or Amazon Resource Name (ARN) of the service network or service.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `locationName:"resourceIdentifier" min:"17" type:"string" required:"true"`

	// The tags for the access log subscription.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessLogSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessLogSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccessLogSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccessLogSubscriptionInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DestinationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationArn"))
	}
	if s.DestinationArn != nil && len(*s.DestinationArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationArn", 20))
	}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}
	if s.ResourceIdentifier != nil && len(*s.ResourceIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAccessLogSubscriptionInput) SetClientToken(v string) *CreateAccessLogSubscriptionInput {
	s.ClientToken = &v
	return s
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *CreateAccessLogSubscriptionInput) SetDestinationArn(v string) *CreateAccessLogSubscriptionInput {
	s.DestinationArn = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *CreateAccessLogSubscriptionInput) SetResourceIdentifier(v string) *CreateAccessLogSubscriptionInput {
	s.ResourceIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAccessLogSubscriptionInput) SetTags(v map[string]*string) *CreateAccessLogSubscriptionInput {
	s.Tags = v
	return s
}

type CreateAccessLogSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the access log subscription.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the log destination.
	//
	// DestinationArn is a required field
	DestinationArn *string `locationName:"destinationArn" min:"20" type:"string" required:"true"`

	// The ID of the access log subscription.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"21" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the service network or service.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The ID of the service network or service.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessLogSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessLogSubscriptionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateAccessLogSubscriptionOutput) SetArn(v string) *CreateAccessLogSubscriptionOutput {
	s.Arn = &v
	return s
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *CreateAccessLogSubscriptionOutput) SetDestinationArn(v string) *CreateAccessLogSubscriptionOutput {
	s.DestinationArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateAccessLogSubscriptionOutput) SetId(v string) *CreateAccessLogSubscriptionOutput {
	s.Id = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *CreateAccessLogSubscriptionOutput) SetResourceArn(v string) *CreateAccessLogSubscriptionOutput {
	s.ResourceArn = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *CreateAccessLogSubscriptionOutput) SetResourceId(v string) *CreateAccessLogSubscriptionOutput {
	s.ResourceId = &v
	return s
}

type CreateListenerInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you retry a request that completed successfully using
	// the same client token and parameters, the retry succeeds without performing
	// any actions. If the parameters aren't identical, the retry fails.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The action for the default rule. Each listener has a default rule. The default
	// rule is used if no other rules match.
	//
	// DefaultAction is a required field
	DefaultAction *RuleAction `locationName:"defaultAction" type:"structure" required:"true"`

	// The name of the listener. A listener name must be unique within a service.
	// The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen
	// as the first or last character, or immediately after another hyphen.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// The listener port. You can specify a value from 1 to 65535. For HTTP, the
	// default is 80. For HTTPS, the default is 443.
	Port *int64 `locationName:"port" min:"1" type:"integer"`

	// The listener protocol.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"ListenerProtocol"`

	// The ID or Amazon Resource Name (ARN) of the service.
	//
	// ServiceIdentifier is a required field
	ServiceIdentifier *string `location:"uri" locationName:"serviceIdentifier" min:"17" type:"string" required:"true"`

	// The tags for the listener.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateListenerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateListenerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateListenerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateListenerInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DefaultAction == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultAction"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.ServiceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceIdentifier"))
	}
	if s.ServiceIdentifier != nil && len(*s.ServiceIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceIdentifier", 17))
	}
	if s.DefaultAction != nil {
		if err := s.DefaultAction.Validate(); err != nil {
			invalidParams.AddNested("DefaultAction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateListenerInput) SetClientToken(v string) *CreateListenerInput {
	s.ClientToken = &v
	return s
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *CreateListenerInput) SetDefaultAction(v *RuleAction) *CreateListenerInput {
	s.DefaultAction = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateListenerInput) SetName(v string) *CreateListenerInput {
	s.Name = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CreateListenerInput) SetPort(v int64) *CreateListenerInput {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *CreateListenerInput) SetProtocol(v string) *CreateListenerInput {
	s.Protocol = &v
	return s
}

// SetServiceIdentifier sets the ServiceIdentifier field's value.
func (s *CreateListenerInput) SetServiceIdentifier(v string) *CreateListenerInput {
	s.ServiceIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateListenerInput) SetTags(v map[string]*string) *CreateListenerInput {
	s.Tags = v
	return s
}

type CreateListenerOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the listener.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The action for the default rule.
	DefaultAction *RuleAction `locationName:"defaultAction" type:"structure"`

	// The ID of the listener.
	Id *string `locationName:"id" min:"26" type:"string"`

	// The name of the listener.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The port number of the listener.
	Port *int64 `locationName:"port" min:"1" type:"integer"`

	// The protocol of the listener.
	Protocol *string `locationName:"protocol" type:"string" enum:"ListenerProtocol"`

	// The Amazon Resource Name (ARN) of the service.
	ServiceArn *string `locationName:"serviceArn" min:"20" type:"string"`

	// The ID of the service.
	ServiceId *string `locationName:"serviceId" min:"21" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateListenerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateListenerOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateListenerOutput) SetArn(v string) *CreateListenerOutput {
	s.Arn = &v
	return s
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *CreateListenerOutput) SetDefaultAction(v *RuleAction) *CreateListenerOutput {
	s.DefaultAction = v
	return s
}

// SetId sets the Id field's value.
func (s *CreateListenerOutput) SetId(v string) *CreateListenerOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateListenerOutput) SetName(v string) *CreateListenerOutput {
	s.Name = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CreateListenerOutput) SetPort(v int64) *CreateListenerOutput {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *CreateListenerOutput) SetProtocol(v string) *CreateListenerOutput {
	s.Protocol = &v
	return s
}

// SetServiceArn sets the ServiceArn field's value.
func (s *CreateListenerOutput) SetServiceArn(v string) *CreateListenerOutput {
	s.ServiceArn = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *CreateListenerOutput) SetServiceId(v string) *CreateListenerOutput {
	s.ServiceId = &v
	return s
}

type CreateRuleInput struct {
	_ struct{} `type:"structure"`

	// The action for the default rule.
	//
	// Action is a required field
	Action *RuleAction `locationName:"action" type:"structure" required:"true"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you retry a request that completed successfully using
	// the same client token and parameters, the retry succeeds without performing
	// any actions. If the parameters aren't identical, the retry fails.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ID or Amazon Resource Name (ARN) of the listener.
	//
	// ListenerIdentifier is a required field
	ListenerIdentifier *string `location:"uri" locationName:"listenerIdentifier" min:"20" type:"string" required:"true"`

	// The rule match.
	//
	// Match is a required field
	Match *RuleMatch `locationName:"match" type:"structure" required:"true"`

	// The name of the rule. The name must be unique within the listener. The valid
	// characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first
	// or last character, or immediately after another hyphen.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// The priority assigned to the rule. Each rule for a specific listener must
	// have a unique priority. The lower the priority number the higher the priority.
	//
	// Priority is a required field
	Priority *int64 `locationName:"priority" min:"1" type:"integer" required:"true"`

	// The ID or Amazon Resource Name (ARN) of the service.
	//
	// ServiceIdentifier is a required field
	ServiceIdentifier *string `location:"uri" locationName:"serviceIdentifier" min:"17" type:"string" required:"true"`

	// The tags for the rule.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRuleInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ListenerIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerIdentifier"))
	}
	if s.ListenerIdentifier != nil && len(*s.ListenerIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ListenerIdentifier", 20))
	}
	if s.Match == nil {
		invalidParams.Add(request.NewErrParamRequired("Match"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}
	if s.Priority != nil && *s.Priority < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Priority", 1))
	}
	if s.ServiceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceIdentifier"))
	}
	if s.ServiceIdentifier != nil && len(*s.ServiceIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceIdentifier", 17))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}
	if s.Match != nil {
		if err := s.Match.Validate(); err != nil {
			invalidParams.AddNested("Match", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *CreateRuleInput) SetAction(v *RuleAction) *CreateRuleInput {
	s.Action = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateRuleInput) SetClientToken(v string) *CreateRuleInput {
	s.ClientToken = &v
	return s
}

// SetListenerIdentifier sets the ListenerIdentifier field's value.
func (s *CreateRuleInput) SetListenerIdentifier(v string) *CreateRuleInput {
	s.ListenerIdentifier = &v
	return s
}

// SetMatch sets the Match field's value.
func (s *CreateRuleInput) SetMatch(v *RuleMatch) *CreateRuleInput {
	s.Match = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRuleInput) SetName(v string) *CreateRuleInput {
	s.Name = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *CreateRuleInput) SetPriority(v int64) *CreateRuleInput {
	s.Priority = &v
	return s
}

// SetServiceIdentifier sets the ServiceIdentifier field's value.
func (s *CreateRuleInput) SetServiceIdentifier(v string) *CreateRuleInput {
	s.ServiceIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRuleInput) SetTags(v map[string]*string) *CreateRuleInput {
	s.Tags = v
	return s
}

type CreateRuleOutput struct {
	_ struct{} `type:"structure"`

	// The rule action.
	Action *RuleAction `locationName:"action" type:"structure"`

	// The Amazon Resource Name (ARN) of the rule.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The ID of the rule.
	Id *string `locationName:"id" min:"5" type:"string"`

	// The rule match. The RuleMatch must be an HttpMatch. This means that the rule
	// should be an exact match on HTTP constraints which are made up of the HTTP
	// method, path, and header.
	Match *RuleMatch `locationName:"match" type:"structure"`

	// The name of the rule.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The priority assigned to the rule. The lower the priority number the higher
	// the priority.
	Priority *int64 `locationName:"priority" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *CreateRuleOutput) SetAction(v *RuleAction) *CreateRuleOutput {
	s.Action = v
	return s
}

// SetArn sets the Arn field's value.
func (s *CreateRuleOutput) SetArn(v string) *CreateRuleOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateRuleOutput) SetId(v string) *CreateRuleOutput {
	s.Id = &v
	return s
}

// SetMatch sets the Match field's value.
func (s *CreateRuleOutput) SetMatch(v *RuleMatch) *CreateRuleOutput {
	s.Match = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRuleOutput) SetName(v string) *CreateRuleOutput {
	s.Name = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *CreateRuleOutput) SetPriority(v int64) *CreateRuleOutput {
	s.Priority = &v
	return s
}

type CreateServiceInput struct {
	_ struct{} `type:"structure"`

	// The type of IAM policy.
	//
	//    * NONE: The resource does not use an IAM policy. This is the default.
	//
	//    * AWS_IAM: The resource uses an IAM policy. When this type is used, auth
	//    is enabled and an auth policy is required.
	AuthType *string `locationName:"authType" type:"string" enum:"AuthType"`

	// The Amazon Resource Name (ARN) of the certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you retry a request that completed successfully using
	// the same client token and parameters, the retry succeeds without performing
	// any actions. If the parameters aren't identical, the retry fails.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The custom domain name of the service.
	CustomDomainName *string `locationName:"customDomainName" min:"3" type:"string"`

	// The name of the service. The name must be unique within the account. The
	// valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as
	// the first or last character, or immediately after another hyphen.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// The tags for the service.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServiceInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.CustomDomainName != nil && len(*s.CustomDomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("CustomDomainName", 3))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthType sets the AuthType field's value.
func (s *CreateServiceInput) SetAuthType(v string) *CreateServiceInput {
	s.AuthType = &v
	return s
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CreateServiceInput) SetCertificateArn(v string) *CreateServiceInput {
	s.CertificateArn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateServiceInput) SetClientToken(v string) *CreateServiceInput {
	s.ClientToken = &v
	return s
}

// SetCustomDomainName sets the CustomDomainName field's value.
func (s *CreateServiceInput) SetCustomDomainName(v string) *CreateServiceInput {
	s.CustomDomainName = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateServiceInput) SetName(v string) *CreateServiceInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateServiceInput) SetTags(v map[string]*string) *CreateServiceInput {
	s.Tags = v
	return s
}

type CreateServiceNetworkInput struct {
	_ struct{} `type:"structure"`

	// The type of IAM policy.
	//
	//    * NONE: The resource does not use an IAM policy. This is the default.
	//
	//    * AWS_IAM: The resource uses an IAM policy. When this type is used, auth
	//    is enabled and an auth policy is required.
	AuthType *string `locationName:"authType" type:"string" enum:"AuthType"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you retry a request that completed successfully using
	// the same client token and parameters, the retry succeeds without performing
	// any actions. If the parameters aren't identical, the retry fails.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The name of the service network. The name must be unique to the account.
	// The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen
	// as the first or last character, or immediately after another hyphen.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// The tags for the service network.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceNetworkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceNetworkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServiceNetworkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServiceNetworkInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthType sets the AuthType field's value.
func (s *CreateServiceNetworkInput) SetAuthType(v string) *CreateServiceNetworkInput {
	s.AuthType = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateServiceNetworkInput) SetClientToken(v string) *CreateServiceNetworkInput {
	s.ClientToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateServiceNetworkInput) SetName(v string) *CreateServiceNetworkInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateServiceNetworkInput) SetTags(v map[string]*string) *CreateServiceNetworkInput {
	s.Tags = v
	return s
}

type CreateServiceNetworkOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the service network.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The type of IAM policy.
	AuthType *string `locationName:"authType" type:"string" enum:"AuthType"`

	// The ID of the service network.
	Id *string `locationName:"id" min:"32" type:"string"`

	// The name of the service network.
	Name *string `locationName:"name" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceNetworkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceNetworkOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateServiceNetworkOutput) SetArn(v string) *CreateServiceNetworkOutput {
	s.Arn = &v
	return s
}

// SetAuthType sets the AuthType field's value.
func (s *CreateServiceNetworkOutput) SetAuthType(v string) *CreateServiceNetworkOutput {
	s.AuthType = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateServiceNetworkOutput) SetId(v string) *CreateServiceNetworkOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateServiceNetworkOutput) SetName(v string) *CreateServiceNetworkOutput {
	s.Name = &v
	return s
}

type CreateServiceNetworkServiceAssociationInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you retry a request that completed successfully using
	// the same client token and parameters, the retry succeeds without performing
	// any actions. If the parameters aren't identical, the retry fails.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ID or Amazon Resource Name (ARN) of the service.
	//
	// ServiceIdentifier is a required field
	ServiceIdentifier *string `locationName:"serviceIdentifier" min:"17" type:"string" required:"true"`

	// The ID or Amazon Resource Name (ARN) of the service network. You must use
	// the ARN if the resources specified in the operation are in different accounts.
	//
	// ServiceNetworkIdentifier is a required field
	ServiceNetworkIdentifier *string `locationName:"serviceNetworkIdentifier" min:"3" type:"string" required:"true"`

	// The tags for the association.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceNetworkServiceAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceNetworkServiceAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServiceNetworkServiceAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServiceNetworkServiceAssociationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ServiceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceIdentifier"))
	}
	if s.ServiceIdentifier != nil && len(*s.ServiceIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceIdentifier", 17))
	}
	if s.ServiceNetworkIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNetworkIdentifier"))
	}
	if s.ServiceNetworkIdentifier != nil && len(*s.ServiceNetworkIdentifier) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceNetworkIdentifier", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateServiceNetworkServiceAssociationInput) SetClientToken(v string) *CreateServiceNetworkServiceAssociationInput {
	s.ClientToken = &v
	return s
}

// SetServiceIdentifier sets the ServiceIdentifier field's value.
func (s *CreateServiceNetworkServiceAssociationInput) SetServiceIdentifier(v string) *CreateServiceNetworkServiceAssociationInput {
	s.ServiceIdentifier = &v
	return s
}

// SetServiceNetworkIdentifier sets the ServiceNetworkIdentifier field's value.
func (s *CreateServiceNetworkServiceAssociationInput) SetServiceNetworkIdentifier(v string) *CreateServiceNetworkServiceAssociationInput {
	s.ServiceNetworkIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateServiceNetworkServiceAssociationInput) SetTags(v map[string]*string) *CreateServiceNetworkServiceAssociationInput {
	s.Tags = v
	return s
}

type CreateServiceNetworkServiceAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the association.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The account that created the association.
	CreatedBy *string `locationName:"createdBy" min:"1" type:"string"`

	// The custom domain name of the service.
	CustomDomainName *string `locationName:"customDomainName" min:"3" type:"string"`

	// The DNS name of the service.
	DnsEntry *DnsEntry `locationName:"dnsEntry" type:"structure"`

	// The ID of the association.
	Id *string `locationName:"id" min:"17" type:"string"`

	// The association status.
	Status *string `locationName:"status" type:"string" enum:"ServiceNetworkServiceAssociationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceNetworkServiceAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceNetworkServiceAssociationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateServiceNetworkServiceAssociationOutput) SetArn(v string) *CreateServiceNetworkServiceAssociationOutput {
	s.Arn = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *CreateServiceNetworkServiceAssociationOutput) SetCreatedBy(v string) *CreateServiceNetworkServiceAssociationOutput {
	s.CreatedBy = &v
	return s
}

// SetCustomDomainName sets the CustomDomainName field's value.
func (s *CreateServiceNetworkServiceAssociationOutput) SetCustomDomainName(v string) *CreateServiceNetworkServiceAssociationOutput {
	s.CustomDomainName = &v
	return s
}

// SetDnsEntry sets the DnsEntry field's value.
func (s *CreateServiceNetworkServiceAssociationOutput) SetDnsEntry(v *DnsEntry) *CreateServiceNetworkServiceAssociationOutput {
	s.DnsEntry = v
	return s
}

// SetId sets the Id field's value.
func (s *CreateServiceNetworkServiceAssociationOutput) SetId(v string) *CreateServiceNetworkServiceAssociationOutput {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateServiceNetworkServiceAssociationOutput) SetStatus(v string) *CreateServiceNetworkServiceAssociationOutput {
	s.Status = &v
	return s
}

type CreateServiceNetworkVpcAssociationInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you retry a request that completed successfully using
	// the same client token and parameters, the retry succeeds without performing
	// any actions. If the parameters aren't identical, the retry fails.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The IDs of the security groups. Security groups aren't added by default.
	// You can add a security group to apply network level controls to control which
	// resources in a VPC are allowed to access the service network and its services.
	// For more information, see Control traffic to resources using security groups
	// (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html)
	// in the Amazon VPC User Guide.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// The ID or Amazon Resource Name (ARN) of the service network. You must use
	// the ARN when the resources specified in the operation are in different accounts.
	//
	// ServiceNetworkIdentifier is a required field
	ServiceNetworkIdentifier *string `locationName:"serviceNetworkIdentifier" min:"3" type:"string" required:"true"`

	// The tags for the association.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The ID of the VPC.
	//
	// VpcIdentifier is a required field
	VpcIdentifier *string `locationName:"vpcIdentifier" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceNetworkVpcAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceNetworkVpcAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServiceNetworkVpcAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServiceNetworkVpcAssociationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ServiceNetworkIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNetworkIdentifier"))
	}
	if s.ServiceNetworkIdentifier != nil && len(*s.ServiceNetworkIdentifier) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceNetworkIdentifier", 3))
	}
	if s.VpcIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcIdentifier"))
	}
	if s.VpcIdentifier != nil && len(*s.VpcIdentifier) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("VpcIdentifier", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateServiceNetworkVpcAssociationInput) SetClientToken(v string) *CreateServiceNetworkVpcAssociationInput {
	s.ClientToken = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateServiceNetworkVpcAssociationInput) SetSecurityGroupIds(v []*string) *CreateServiceNetworkVpcAssociationInput {
	s.SecurityGroupIds = v
	return s
}

// SetServiceNetworkIdentifier sets the ServiceNetworkIdentifier field's value.
func (s *CreateServiceNetworkVpcAssociationInput) SetServiceNetworkIdentifier(v string) *CreateServiceNetworkVpcAssociationInput {
	s.ServiceNetworkIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateServiceNetworkVpcAssociationInput) SetTags(v map[string]*string) *CreateServiceNetworkVpcAssociationInput {
	s.Tags = v
	return s
}

// SetVpcIdentifier sets the VpcIdentifier field's value.
func (s *CreateServiceNetworkVpcAssociationInput) SetVpcIdentifier(v string) *CreateServiceNetworkVpcAssociationInput {
	s.VpcIdentifier = &v
	return s
}

type CreateServiceNetworkVpcAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the association.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The account that created the association.
	CreatedBy *string `locationName:"createdBy" min:"1" type:"string"`

	// The ID of the association.
	Id *string `locationName:"id" min:"22" type:"string"`

	// The IDs of the security groups.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// The association status.
	Status *string `locationName:"status" type:"string" enum:"ServiceNetworkVpcAssociationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceNetworkVpcAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceNetworkVpcAssociationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateServiceNetworkVpcAssociationOutput) SetArn(v string) *CreateServiceNetworkVpcAssociationOutput {
	s.Arn = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *CreateServiceNetworkVpcAssociationOutput) SetCreatedBy(v string) *CreateServiceNetworkVpcAssociationOutput {
	s.CreatedBy = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateServiceNetworkVpcAssociationOutput) SetId(v string) *CreateServiceNetworkVpcAssociationOutput {
	s.Id = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateServiceNetworkVpcAssociationOutput) SetSecurityGroupIds(v []*string) *CreateServiceNetworkVpcAssociationOutput {
	s.SecurityGroupIds = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateServiceNetworkVpcAssociationOutput) SetStatus(v string) *CreateServiceNetworkVpcAssociationOutput {
	s.Status = &v
	return s
}

type CreateServiceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the service.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The type of IAM policy.
	AuthType *string `locationName:"authType" type:"string" enum:"AuthType"`

	// The Amazon Resource Name (ARN) of the certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The custom domain name of the service.
	CustomDomainName *string `locationName:"customDomainName" min:"3" type:"string"`

	// The public DNS name of the service.
	DnsEntry *DnsEntry `locationName:"dnsEntry" type:"structure"`

	// The ID of the service.
	Id *string `locationName:"id" min:"21" type:"string"`

	// The name of the service.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The status. If the status is CREATE_FAILED, you must delete and recreate
	// the service.
	Status *string `locationName:"status" type:"string" enum:"ServiceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateServiceOutput) SetArn(v string) *CreateServiceOutput {
	s.Arn = &v
	return s
}

// SetAuthType sets the AuthType field's value.
func (s *CreateServiceOutput) SetAuthType(v string) *CreateServiceOutput {
	s.AuthType = &v
	return s
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CreateServiceOutput) SetCertificateArn(v string) *CreateServiceOutput {
	s.CertificateArn = &v
	return s
}

// SetCustomDomainName sets the CustomDomainName field's value.
func (s *CreateServiceOutput) SetCustomDomainName(v string) *CreateServiceOutput {
	s.CustomDomainName = &v
	return s
}

// SetDnsEntry sets the DnsEntry field's value.
func (s *CreateServiceOutput) SetDnsEntry(v *DnsEntry) *CreateServiceOutput {
	s.DnsEntry = v
	return s
}

// SetId sets the Id field's value.
func (s *CreateServiceOutput) SetId(v string) *CreateServiceOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateServiceOutput) SetName(v string) *CreateServiceOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateServiceOutput) SetStatus(v string) *CreateServiceOutput {
	s.Status = &v
	return s
}

type CreateTargetGroupInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you retry a request that completed successfully using
	// the same client token and parameters, the retry succeeds without performing
	// any actions. If the parameters aren't identical, the retry fails.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The target group configuration.
	Config *TargetGroupConfig `locationName:"config" type:"structure"`

	// The name of the target group. The name must be unique within the account.
	// The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen
	// as the first or last character, or immediately after another hyphen.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// The tags for the target group.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of target group.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"TargetGroupType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTargetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTargetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTargetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTargetGroupInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Config != nil {
		if err := s.Config.Validate(); err != nil {
			invalidParams.AddNested("Config", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateTargetGroupInput) SetClientToken(v string) *CreateTargetGroupInput {
	s.ClientToken = &v
	return s
}

// SetConfig sets the Config field's value.
func (s *CreateTargetGroupInput) SetConfig(v *TargetGroupConfig) *CreateTargetGroupInput {
	s.Config = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTargetGroupInput) SetName(v string) *CreateTargetGroupInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTargetGroupInput) SetTags(v map[string]*string) *CreateTargetGroupInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateTargetGroupInput) SetType(v string) *CreateTargetGroupInput {
	s.Type = &v
	return s
}

type CreateTargetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target group.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The target group configuration.
	Config *TargetGroupConfig `locationName:"config" type:"structure"`

	// The ID of the target group.
	Id *string `locationName:"id" min:"20" type:"string"`

	// The name of the target group.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The status. You can retry the operation if the status is CREATE_FAILED. However,
	// if you retry it while the status is CREATE_IN_PROGRESS, there is no change
	// in the status.
	Status *string `locationName:"status" type:"string" enum:"TargetGroupStatus"`

	// The type of target group.
	Type *string `locationName:"type" type:"string" enum:"TargetGroupType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTargetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTargetGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateTargetGroupOutput) SetArn(v string) *CreateTargetGroupOutput {
	s.Arn = &v
	return s
}

// SetConfig sets the Config field's value.
func (s *CreateTargetGroupOutput) SetConfig(v *TargetGroupConfig) *CreateTargetGroupOutput {
	s.Config = v
	return s
}

// SetId sets the Id field's value.
func (s *CreateTargetGroupOutput) SetId(v string) *CreateTargetGroupOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTargetGroupOutput) SetName(v string) *CreateTargetGroupOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateTargetGroupOutput) SetStatus(v string) *CreateTargetGroupOutput {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateTargetGroupOutput) SetType(v string) *CreateTargetGroupOutput {
	s.Type = &v
	return s
}

type DeleteAccessLogSubscriptionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID or Amazon Resource Name (ARN) of the access log subscription.
	//
	// AccessLogSubscriptionIdentifier is a required field
	AccessLogSubscriptionIdentifier *string `location:"uri" locationName:"accessLogSubscriptionIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessLogSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessLogSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessLogSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessLogSubscriptionInput"}
	if s.AccessLogSubscriptionIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessLogSubscriptionIdentifier"))
	}
	if s.AccessLogSubscriptionIdentifier != nil && len(*s.AccessLogSubscriptionIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("AccessLogSubscriptionIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessLogSubscriptionIdentifier sets the AccessLogSubscriptionIdentifier field's value.
func (s *DeleteAccessLogSubscriptionInput) SetAccessLogSubscriptionIdentifier(v string) *DeleteAccessLogSubscriptionInput {
	s.AccessLogSubscriptionIdentifier = &v
	return s
}

type DeleteAccessLogSubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessLogSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessLogSubscriptionOutput) GoString() string {
	return s.String()
}

type DeleteAuthPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID or Amazon Resource Name (ARN) of the resource.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `location:"uri" locationName:"resourceIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAuthPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAuthPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAuthPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAuthPolicyInput"}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}
	if s.ResourceIdentifier != nil && len(*s.ResourceIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *DeleteAuthPolicyInput) SetResourceIdentifier(v string) *DeleteAuthPolicyInput {
	s.ResourceIdentifier = &v
	return s
}

type DeleteAuthPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAuthPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAuthPolicyOutput) GoString() string {
	return s.String()
}

type DeleteListenerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID or Amazon Resource Name (ARN) of the listener.
	//
	// ListenerIdentifier is a required field
	ListenerIdentifier *string `location:"uri" locationName:"listenerIdentifier" min:"20" type:"string" required:"true"`

	// The ID or Amazon Resource Name (ARN) of the service.
	//
	// ServiceIdentifier is a required field
	ServiceIdentifier *string `location:"uri" locationName:"serviceIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteListenerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteListenerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteListenerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteListenerInput"}
	if s.ListenerIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerIdentifier"))
	}
	if s.ListenerIdentifier != nil && len(*s.ListenerIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ListenerIdentifier", 20))
	}
	if s.ServiceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceIdentifier"))
	}
	if s.ServiceIdentifier != nil && len(*s.ServiceIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListenerIdentifier sets the ListenerIdentifier field's value.
func (s *DeleteListenerInput) SetListenerIdentifier(v string) *DeleteListenerInput {
	s.ListenerIdentifier = &v
	return s
}

// SetServiceIdentifier sets the ServiceIdentifier field's value.
func (s *DeleteListenerInput) SetServiceIdentifier(v string) *DeleteListenerInput {
	s.ServiceIdentifier = &v
	return s
}

type DeleteListenerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteListenerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteListenerOutput) GoString() string {
	return s.String()
}

type DeleteResourcePolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourcePolicyInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteResourcePolicyInput) SetResourceArn(v string) *DeleteResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type DeleteResourcePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) GoString() string {
	return s.String()
}

type DeleteRuleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID or Amazon Resource Name (ARN) of the listener.
	//
	// ListenerIdentifier is a required field
	ListenerIdentifier *string `location:"uri" locationName:"listenerIdentifier" min:"20" type:"string" required:"true"`

	// The ID or Amazon Resource Name (ARN) of the rule.
	//
	// RuleIdentifier is a required field
	RuleIdentifier *string `location:"uri" locationName:"ruleIdentifier" min:"20" type:"string" required:"true"`

	// The ID or Amazon Resource Name (ARN) of the service.
	//
	// ServiceIdentifier is a required field
	ServiceIdentifier *string `location:"uri" locationName:"serviceIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRuleInput"}
	if s.ListenerIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerIdentifier"))
	}
	if s.ListenerIdentifier != nil && len(*s.ListenerIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ListenerIdentifier", 20))
	}
	if s.RuleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleIdentifier"))
	}
	if s.RuleIdentifier != nil && len(*s.RuleIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RuleIdentifier", 20))
	}
	if s.ServiceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceIdentifier"))
	}
	if s.ServiceIdentifier != nil && len(*s.ServiceIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListenerIdentifier sets the ListenerIdentifier field's value.
func (s *DeleteRuleInput) SetListenerIdentifier(v string) *DeleteRuleInput {
	s.ListenerIdentifier = &v
	return s
}

// SetRuleIdentifier sets the RuleIdentifier field's value.
func (s *DeleteRuleInput) SetRuleIdentifier(v string) *DeleteRuleInput {
	s.RuleIdentifier = &v
	return s
}

// SetServiceIdentifier sets the ServiceIdentifier field's value.
func (s *DeleteRuleInput) SetServiceIdentifier(v string) *DeleteRuleInput {
	s.ServiceIdentifier = &v
	return s
}

type DeleteRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleOutput) GoString() string {
	return s.String()
}

type DeleteServiceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID or Amazon Resource Name (ARN) of the service.
	//
	// ServiceIdentifier is a required field
	ServiceIdentifier *string `location:"uri" locationName:"serviceIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServiceInput"}
	if s.ServiceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceIdentifier"))
	}
	if s.ServiceIdentifier != nil && len(*s.ServiceIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceIdentifier sets the ServiceIdentifier field's value.
func (s *DeleteServiceInput) SetServiceIdentifier(v string) *DeleteServiceInput {
	s.ServiceIdentifier = &v
	return s
}

type DeleteServiceNetworkInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) or ID of the service network.
	//
	// ServiceNetworkIdentifier is a required field
	ServiceNetworkIdentifier *string `location:"uri" locationName:"serviceNetworkIdentifier" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceNetworkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceNetworkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServiceNetworkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServiceNetworkInput"}
	if s.ServiceNetworkIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNetworkIdentifier"))
	}
	if s.ServiceNetworkIdentifier != nil && len(*s.ServiceNetworkIdentifier) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceNetworkIdentifier", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceNetworkIdentifier sets the ServiceNetworkIdentifier field's value.
func (s *DeleteServiceNetworkInput) SetServiceNetworkIdentifier(v string) *DeleteServiceNetworkInput {
	s.ServiceNetworkIdentifier = &v
	return s
}

type DeleteServiceNetworkOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceNetworkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceNetworkOutput) GoString() string {
	return s.String()
}

type DeleteServiceNetworkServiceAssociationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID or Amazon Resource Name (ARN) of the association.
	//
	// ServiceNetworkServiceAssociationIdentifier is a required field
	ServiceNetworkServiceAssociationIdentifier *string `location:"uri" locationName:"serviceNetworkServiceAssociationIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceNetworkServiceAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceNetworkServiceAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServiceNetworkServiceAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServiceNetworkServiceAssociationInput"}
	if s.ServiceNetworkServiceAssociationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNetworkServiceAssociationIdentifier"))
	}
	if s.ServiceNetworkServiceAssociationIdentifier != nil && len(*s.ServiceNetworkServiceAssociationIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceNetworkServiceAssociationIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceNetworkServiceAssociationIdentifier sets the ServiceNetworkServiceAssociationIdentifier field's value.
func (s *DeleteServiceNetworkServiceAssociationInput) SetServiceNetworkServiceAssociationIdentifier(v string) *DeleteServiceNetworkServiceAssociationInput {
	s.ServiceNetworkServiceAssociationIdentifier = &v
	return s
}

type DeleteServiceNetworkServiceAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the association.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The ID of the association.
	Id *string `locationName:"id" min:"17" type:"string"`

	// The status. You can retry the operation if the status is DELETE_FAILED. However,
	// if you retry it when the status is DELETE_IN_PROGRESS, there is no change
	// in the status.
	Status *string `locationName:"status" type:"string" enum:"ServiceNetworkServiceAssociationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceNetworkServiceAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceNetworkServiceAssociationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteServiceNetworkServiceAssociationOutput) SetArn(v string) *DeleteServiceNetworkServiceAssociationOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteServiceNetworkServiceAssociationOutput) SetId(v string) *DeleteServiceNetworkServiceAssociationOutput {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteServiceNetworkServiceAssociationOutput) SetStatus(v string) *DeleteServiceNetworkServiceAssociationOutput {
	s.Status = &v
	return s
}

type DeleteServiceNetworkVpcAssociationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID or Amazon Resource Name (ARN) of the association.
	//
	// ServiceNetworkVpcAssociationIdentifier is a required field
	ServiceNetworkVpcAssociationIdentifier *string `location:"uri" locationName:"serviceNetworkVpcAssociationIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceNetworkVpcAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceNetworkVpcAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServiceNetworkVpcAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServiceNetworkVpcAssociationInput"}
	if s.ServiceNetworkVpcAssociationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNetworkVpcAssociationIdentifier"))
	}
	if s.ServiceNetworkVpcAssociationIdentifier != nil && len(*s.ServiceNetworkVpcAssociationIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceNetworkVpcAssociationIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceNetworkVpcAssociationIdentifier sets the ServiceNetworkVpcAssociationIdentifier field's value.
func (s *DeleteServiceNetworkVpcAssociationInput) SetServiceNetworkVpcAssociationIdentifier(v string) *DeleteServiceNetworkVpcAssociationInput {
	s.ServiceNetworkVpcAssociationIdentifier = &v
	return s
}

type DeleteServiceNetworkVpcAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the association.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The ID of the association.
	Id *string `locationName:"id" min:"22" type:"string"`

	// The status. You can retry the operation if the status is DELETE_FAILED. However,
	// if you retry it while the status is DELETE_IN_PROGRESS, there is no change
	// in the status.
	Status *string `locationName:"status" type:"string" enum:"ServiceNetworkVpcAssociationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceNetworkVpcAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceNetworkVpcAssociationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteServiceNetworkVpcAssociationOutput) SetArn(v string) *DeleteServiceNetworkVpcAssociationOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteServiceNetworkVpcAssociationOutput) SetId(v string) *DeleteServiceNetworkVpcAssociationOutput {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteServiceNetworkVpcAssociationOutput) SetStatus(v string) *DeleteServiceNetworkVpcAssociationOutput {
	s.Status = &v
	return s
}

type DeleteServiceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the service.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The ID of the service.
	Id *string `locationName:"id" min:"21" type:"string"`

	// The name of the service.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The status. You can retry the operation if the status is DELETE_FAILED. However,
	// if you retry it while the status is DELETE_IN_PROGRESS, the status doesn't
	// change.
	Status *string `locationName:"status" type:"string" enum:"ServiceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteServiceOutput) SetArn(v string) *DeleteServiceOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteServiceOutput) SetId(v string) *DeleteServiceOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteServiceOutput) SetName(v string) *DeleteServiceOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteServiceOutput) SetStatus(v string) *DeleteServiceOutput {
	s.Status = &v
	return s
}

type DeleteTargetGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID or Amazon Resource Name (ARN) of the target group.
	//
	// TargetGroupIdentifier is a required field
	TargetGroupIdentifier *string `location:"uri" locationName:"targetGroupIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTargetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTargetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTargetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTargetGroupInput"}
	if s.TargetGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetGroupIdentifier"))
	}
	if s.TargetGroupIdentifier != nil && len(*s.TargetGroupIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("TargetGroupIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetGroupIdentifier sets the TargetGroupIdentifier field's value.
func (s *DeleteTargetGroupInput) SetTargetGroupIdentifier(v string) *DeleteTargetGroupInput {
	s.TargetGroupIdentifier = &v
	return s
}

type DeleteTargetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target group.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The ID of the target group.
	Id *string `locationName:"id" min:"20" type:"string"`

	// The status. You can retry the operation if the status is DELETE_FAILED. However,
	// if you retry it while the status is DELETE_IN_PROGRESS, the status doesn't
	// change.
	Status *string `locationName:"status" type:"string" enum:"TargetGroupStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTargetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTargetGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteTargetGroupOutput) SetArn(v string) *DeleteTargetGroupOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteTargetGroupOutput) SetId(v string) *DeleteTargetGroupOutput {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteTargetGroupOutput) SetStatus(v string) *DeleteTargetGroupOutput {
	s.Status = &v
	return s
}

type DeregisterTargetsInput struct {
	_ struct{} `type:"structure"`

	// The ID or Amazon Resource Name (ARN) of the target group.
	//
	// TargetGroupIdentifier is a required field
	TargetGroupIdentifier *string `location:"uri" locationName:"targetGroupIdentifier" min:"17" type:"string" required:"true"`

	// The targets to deregister.
	//
	// Targets is a required field
	Targets []*Target `locationName:"targets" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterTargetsInput"}
	if s.TargetGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetGroupIdentifier"))
	}
	if s.TargetGroupIdentifier != nil && len(*s.TargetGroupIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("TargetGroupIdentifier", 17))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil && len(s.Targets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Targets", 1))
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetGroupIdentifier sets the TargetGroupIdentifier field's value.
func (s *DeregisterTargetsInput) SetTargetGroupIdentifier(v string) *DeregisterTargetsInput {
	s.TargetGroupIdentifier = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *DeregisterTargetsInput) SetTargets(v []*Target) *DeregisterTargetsInput {
	s.Targets = v
	return s
}

type DeregisterTargetsOutput struct {
	_ struct{} `type:"structure"`

	// The targets that were successfully deregistered.
	Successful []*Target `locationName:"successful" type:"list"`

	// The targets that the operation couldn't deregister.
	Unsuccessful []*TargetFailure `locationName:"unsuccessful" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterTargetsOutput) GoString() string {
	return s.String()
}

// SetSuccessful sets the Successful field's value.
func (s *DeregisterTargetsOutput) SetSuccessful(v []*Target) *DeregisterTargetsOutput {
	s.Successful = v
	return s
}

// SetUnsuccessful sets the Unsuccessful field's value.
func (s *DeregisterTargetsOutput) SetUnsuccessful(v []*TargetFailure) *DeregisterTargetsOutput {
	s.Unsuccessful = v
	return s
}

// Describes the DNS information of a service.
type DnsEntry struct {
	_ struct{} `type:"structure"`

	// The domain name of the service.
	DomainName *string `locationName:"domainName" type:"string"`

	// The ID of the hosted zone.
	HostedZoneId *string `locationName:"hostedZoneId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DnsEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DnsEntry) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *DnsEntry) SetDomainName(v string) *DnsEntry {
	s.DomainName = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *DnsEntry) SetHostedZoneId(v string) *DnsEntry {
	s.HostedZoneId = &v
	return s
}

// Describes an action that returns a custom HTTP response.
type FixedResponseAction struct {
	_ struct{} `type:"structure"`

	// The HTTP response code.
	//
	// StatusCode is a required field
	StatusCode *int64 `locationName:"statusCode" min:"100" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FixedResponseAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FixedResponseAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FixedResponseAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FixedResponseAction"}
	if s.StatusCode == nil {
		invalidParams.Add(request.NewErrParamRequired("StatusCode"))
	}
	if s.StatusCode != nil && *s.StatusCode < 100 {
		invalidParams.Add(request.NewErrParamMinValue("StatusCode", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatusCode sets the StatusCode field's value.
func (s *FixedResponseAction) SetStatusCode(v int64) *FixedResponseAction {
	s.StatusCode = &v
	return s
}

// Describes a forward action. You can use forward actions to route requests
// to one or more target groups.
type ForwardAction struct {
	_ struct{} `type:"structure"`

	// The target groups. Traffic matching the rule is forwarded to the specified
	// target groups. With forward actions, you can assign a weight that controls
	// the prioritization and selection of each target group. This means that requests
	// are distributed to individual target groups based on their weights. For example,
	// if two target groups have the same weight, each target group receives half
	// of the traffic.
	//
	// The default value is 1. This means that if only one target group is provided,
	// there is no need to set the weight; 100% of the traffic goes to that target
	// group.
	//
	// TargetGroups is a required field
	TargetGroups []*WeightedTargetGroup `locationName:"targetGroups" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForwardAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForwardAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ForwardAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ForwardAction"}
	if s.TargetGroups == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetGroups"))
	}
	if s.TargetGroups != nil && len(s.TargetGroups) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetGroups", 1))
	}
	if s.TargetGroups != nil {
		for i, v := range s.TargetGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetGroups sets the TargetGroups field's value.
func (s *ForwardAction) SetTargetGroups(v []*WeightedTargetGroup) *ForwardAction {
	s.TargetGroups = v
	return s
}

type GetAccessLogSubscriptionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID or Amazon Resource Name (ARN) of the access log subscription.
	//
	// AccessLogSubscriptionIdentifier is a required field
	AccessLogSubscriptionIdentifier *string `location:"uri" locationName:"accessLogSubscriptionIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessLogSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessLogSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessLogSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessLogSubscriptionInput"}
	if s.AccessLogSubscriptionIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessLogSubscriptionIdentifier"))
	}
	if s.AccessLogSubscriptionIdentifier != nil && len(*s.AccessLogSubscriptionIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("AccessLogSubscriptionIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessLogSubscriptionIdentifier sets the AccessLogSubscriptionIdentifier field's value.
func (s *GetAccessLogSubscriptionInput) SetAccessLogSubscriptionIdentifier(v string) *GetAccessLogSubscriptionInput {
	s.AccessLogSubscriptionIdentifier = &v
	return s
}

type GetAccessLogSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the access log subscription.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The date and time that the access log subscription was created, specified
	// in ISO-8601 format.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the access log destination.
	//
	// DestinationArn is a required field
	DestinationArn *string `locationName:"destinationArn" min:"20" type:"string" required:"true"`

	// The ID of the access log subscription.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"21" type:"string" required:"true"`

	// The date and time that the access log subscription was last updated, specified
	// in ISO-8601 format.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the service network or service.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The ID of the service network or service.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessLogSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessLogSubscriptionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetAccessLogSubscriptionOutput) SetArn(v string) *GetAccessLogSubscriptionOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetAccessLogSubscriptionOutput) SetCreatedAt(v time.Time) *GetAccessLogSubscriptionOutput {
	s.CreatedAt = &v
	return s
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *GetAccessLogSubscriptionOutput) SetDestinationArn(v string) *GetAccessLogSubscriptionOutput {
	s.DestinationArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetAccessLogSubscriptionOutput) SetId(v string) *GetAccessLogSubscriptionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetAccessLogSubscriptionOutput) SetLastUpdatedAt(v time.Time) *GetAccessLogSubscriptionOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetAccessLogSubscriptionOutput) SetResourceArn(v string) *GetAccessLogSubscriptionOutput {
	s.ResourceArn = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *GetAccessLogSubscriptionOutput) SetResourceId(v string) *GetAccessLogSubscriptionOutput {
	s.ResourceId = &v
	return s
}

type GetAuthPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID or Amazon Resource Name (ARN) of the service network or service.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `location:"uri" locationName:"resourceIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAuthPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAuthPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAuthPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAuthPolicyInput"}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}
	if s.ResourceIdentifier != nil && len(*s.ResourceIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *GetAuthPolicyInput) SetResourceIdentifier(v string) *GetAuthPolicyInput {
	s.ResourceIdentifier = &v
	return s
}

type GetAuthPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the auth policy was created, specified in ISO-8601
	// format.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The date and time that the auth policy was last updated, specified in ISO-8601
	// format.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The auth policy.
	Policy *string `locationName:"policy" type:"string"`

	// The state of the auth policy. The auth policy is only active when the auth
	// type is set to AWS_IAM. If you provide a policy, then authentication and
	// authorization decisions are made based on this policy and the client's IAM
	// policy. If the auth type is NONE, then any auth policy that you provide remains
	// inactive. For more information, see Create a service network (https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#create-service-network)
	// in the Amazon VPC Lattice User Guide.
	State *string `locationName:"state" type:"string" enum:"AuthPolicyState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAuthPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAuthPolicyOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetAuthPolicyOutput) SetCreatedAt(v time.Time) *GetAuthPolicyOutput {
	s.CreatedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetAuthPolicyOutput) SetLastUpdatedAt(v time.Time) *GetAuthPolicyOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *GetAuthPolicyOutput) SetPolicy(v string) *GetAuthPolicyOutput {
	s.Policy = &v
	return s
}

// SetState sets the State field's value.
func (s *GetAuthPolicyOutput) SetState(v string) *GetAuthPolicyOutput {
	s.State = &v
	return s
}

type GetListenerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID or Amazon Resource Name (ARN) of the listener.
	//
	// ListenerIdentifier is a required field
	ListenerIdentifier *string `location:"uri" locationName:"listenerIdentifier" min:"20" type:"string" required:"true"`

	// The ID or Amazon Resource Name (ARN) of the service.
	//
	// ServiceIdentifier is a required field
	ServiceIdentifier *string `location:"uri" locationName:"serviceIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetListenerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetListenerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetListenerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetListenerInput"}
	if s.ListenerIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerIdentifier"))
	}
	if s.ListenerIdentifier != nil && len(*s.ListenerIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ListenerIdentifier", 20))
	}
	if s.ServiceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceIdentifier"))
	}
	if s.ServiceIdentifier != nil && len(*s.ServiceIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListenerIdentifier sets the ListenerIdentifier field's value.
func (s *GetListenerInput) SetListenerIdentifier(v string) *GetListenerInput {
	s.ListenerIdentifier = &v
	return s
}

// SetServiceIdentifier sets the ServiceIdentifier field's value.
func (s *GetListenerInput) SetServiceIdentifier(v string) *GetListenerInput {
	s.ServiceIdentifier = &v
	return s
}

type GetListenerOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the listener.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The date and time that the listener was created, specified in ISO-8601 format.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The actions for the default listener rule.
	DefaultAction *RuleAction `locationName:"defaultAction" type:"structure"`

	// The ID of the listener.
	Id *string `locationName:"id" min:"26" type:"string"`

	// The date and time that the listener was last updated, specified in ISO-8601
	// format.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the listener.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The listener port.
	Port *int64 `locationName:"port" min:"1" type:"integer"`

	// The listener protocol.
	Protocol *string `locationName:"protocol" type:"string" enum:"ListenerProtocol"`

	// The Amazon Resource Name (ARN) of the service.
	ServiceArn *string `locationName:"serviceArn" min:"20" type:"string"`

	// The ID of the service.
	ServiceId *string `locationName:"serviceId" min:"21" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetListenerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetListenerOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetListenerOutput) SetArn(v string) *GetListenerOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetListenerOutput) SetCreatedAt(v time.Time) *GetListenerOutput {
	s.CreatedAt = &v
	return s
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *GetListenerOutput) SetDefaultAction(v *RuleAction) *GetListenerOutput {
	s.DefaultAction = v
	return s
}

// SetId sets the Id field's value.
func (s *GetListenerOutput) SetId(v string) *GetListenerOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetListenerOutput) SetLastUpdatedAt(v time.Time) *GetListenerOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetListenerOutput) SetName(v string) *GetListenerOutput {
	s.Name = &v
	return s
}

// SetPort sets the Port field's value.
func (s *GetListenerOutput) SetPort(v int64) *GetListenerOutput {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *GetListenerOutput) SetProtocol(v string) *GetListenerOutput {
	s.Protocol = &v
	return s
}

// SetServiceArn sets the ServiceArn field's value.
func (s *GetListenerOutput) SetServiceArn(v string) *GetListenerOutput {
	s.ServiceArn = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *GetListenerOutput) SetServiceId(v string) *GetListenerOutput {
	s.ServiceId = &v
	return s
}

type GetResourcePolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the service network or service.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourcePolicyInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetResourcePolicyInput) SetResourceArn(v string) *GetResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type GetResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// An IAM policy.
	Policy *string `locationName:"policy" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetResourcePolicyOutput) SetPolicy(v string) *GetResourcePolicyOutput {
	s.Policy = &v
	return s
}

type GetRuleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID or Amazon Resource Name (ARN) of the listener.
	//
	// ListenerIdentifier is a required field
	ListenerIdentifier *string `location:"uri" locationName:"listenerIdentifier" min:"20" type:"string" required:"true"`

	// The ID or Amazon Resource Name (ARN) of the listener rule.
	//
	// RuleIdentifier is a required field
	RuleIdentifier *string `location:"uri" locationName:"ruleIdentifier" min:"20" type:"string" required:"true"`

	// The ID or Amazon Resource Name (ARN) of the service.
	//
	// ServiceIdentifier is a required field
	ServiceIdentifier *string `location:"uri" locationName:"serviceIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRuleInput"}
	if s.ListenerIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerIdentifier"))
	}
	if s.ListenerIdentifier != nil && len(*s.ListenerIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ListenerIdentifier", 20))
	}
	if s.RuleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleIdentifier"))
	}
	if s.RuleIdentifier != nil && len(*s.RuleIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RuleIdentifier", 20))
	}
	if s.ServiceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceIdentifier"))
	}
	if s.ServiceIdentifier != nil && len(*s.ServiceIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListenerIdentifier sets the ListenerIdentifier field's value.
func (s *GetRuleInput) SetListenerIdentifier(v string) *GetRuleInput {
	s.ListenerIdentifier = &v
	return s
}

// SetRuleIdentifier sets the RuleIdentifier field's value.
func (s *GetRuleInput) SetRuleIdentifier(v string) *GetRuleInput {
	s.RuleIdentifier = &v
	return s
}

// SetServiceIdentifier sets the ServiceIdentifier field's value.
func (s *GetRuleInput) SetServiceIdentifier(v string) *GetRuleInput {
	s.ServiceIdentifier = &v
	return s
}

type GetRuleOutput struct {
	_ struct{} `type:"structure"`

	// The action for the default rule.
	Action *RuleAction `locationName:"action" type:"structure"`

	// The Amazon Resource Name (ARN) of the listener.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The date and time that the listener rule was created, specified in ISO-8601
	// format.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The ID of the listener.
	Id *string `locationName:"id" min:"5" type:"string"`

	// Indicates whether this is the default rule.
	IsDefault *bool `locationName:"isDefault" type:"boolean"`

	// The date and time that the listener rule was last updated, specified in ISO-8601
	// format.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The rule match.
	Match *RuleMatch `locationName:"match" type:"structure"`

	// The name of the listener.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The priority level for the specified rule.
	Priority *int64 `locationName:"priority" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRuleOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *GetRuleOutput) SetAction(v *RuleAction) *GetRuleOutput {
	s.Action = v
	return s
}

// SetArn sets the Arn field's value.
func (s *GetRuleOutput) SetArn(v string) *GetRuleOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetRuleOutput) SetCreatedAt(v time.Time) *GetRuleOutput {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetRuleOutput) SetId(v string) *GetRuleOutput {
	s.Id = &v
	return s
}

// SetIsDefault sets the IsDefault field's value.
func (s *GetRuleOutput) SetIsDefault(v bool) *GetRuleOutput {
	s.IsDefault = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetRuleOutput) SetLastUpdatedAt(v time.Time) *GetRuleOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetMatch sets the Match field's value.
func (s *GetRuleOutput) SetMatch(v *RuleMatch) *GetRuleOutput {
	s.Match = v
	return s
}

// SetName sets the Name field's value.
func (s *GetRuleOutput) SetName(v string) *GetRuleOutput {
	s.Name = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *GetRuleOutput) SetPriority(v int64) *GetRuleOutput {
	s.Priority = &v
	return s
}

type GetServiceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID or Amazon Resource Name (ARN) of the service.
	//
	// ServiceIdentifier is a required field
	ServiceIdentifier *string `location:"uri" locationName:"serviceIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceInput"}
	if s.ServiceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceIdentifier"))
	}
	if s.ServiceIdentifier != nil && len(*s.ServiceIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceIdentifier sets the ServiceIdentifier field's value.
func (s *GetServiceInput) SetServiceIdentifier(v string) *GetServiceInput {
	s.ServiceIdentifier = &v
	return s
}

type GetServiceNetworkInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID or Amazon Resource Name (ARN) of the service network.
	//
	// ServiceNetworkIdentifier is a required field
	ServiceNetworkIdentifier *string `location:"uri" locationName:"serviceNetworkIdentifier" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceNetworkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceNetworkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceNetworkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceNetworkInput"}
	if s.ServiceNetworkIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNetworkIdentifier"))
	}
	if s.ServiceNetworkIdentifier != nil && len(*s.ServiceNetworkIdentifier) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceNetworkIdentifier", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceNetworkIdentifier sets the ServiceNetworkIdentifier field's value.
func (s *GetServiceNetworkInput) SetServiceNetworkIdentifier(v string) *GetServiceNetworkInput {
	s.ServiceNetworkIdentifier = &v
	return s
}

type GetServiceNetworkOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the service network.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The type of IAM policy.
	AuthType *string `locationName:"authType" type:"string" enum:"AuthType"`

	// The date and time that the service network was created, specified in ISO-8601
	// format.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The ID of the service network.
	Id *string `locationName:"id" min:"32" type:"string"`

	// The date and time of the last update, specified in ISO-8601 format.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the service network.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The number of services associated with the service network.
	NumberOfAssociatedServices *int64 `locationName:"numberOfAssociatedServices" type:"long"`

	// The number of VPCs associated with the service network.
	NumberOfAssociatedVPCs *int64 `locationName:"numberOfAssociatedVPCs" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceNetworkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceNetworkOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetServiceNetworkOutput) SetArn(v string) *GetServiceNetworkOutput {
	s.Arn = &v
	return s
}

// SetAuthType sets the AuthType field's value.
func (s *GetServiceNetworkOutput) SetAuthType(v string) *GetServiceNetworkOutput {
	s.AuthType = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetServiceNetworkOutput) SetCreatedAt(v time.Time) *GetServiceNetworkOutput {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetServiceNetworkOutput) SetId(v string) *GetServiceNetworkOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetServiceNetworkOutput) SetLastUpdatedAt(v time.Time) *GetServiceNetworkOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetServiceNetworkOutput) SetName(v string) *GetServiceNetworkOutput {
	s.Name = &v
	return s
}

// SetNumberOfAssociatedServices sets the NumberOfAssociatedServices field's value.
func (s *GetServiceNetworkOutput) SetNumberOfAssociatedServices(v int64) *GetServiceNetworkOutput {
	s.NumberOfAssociatedServices = &v
	return s
}

// SetNumberOfAssociatedVPCs sets the NumberOfAssociatedVPCs field's value.
func (s *GetServiceNetworkOutput) SetNumberOfAssociatedVPCs(v int64) *GetServiceNetworkOutput {
	s.NumberOfAssociatedVPCs = &v
	return s
}

type GetServiceNetworkServiceAssociationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID or Amazon Resource Name (ARN) of the association.
	//
	// ServiceNetworkServiceAssociationIdentifier is a required field
	ServiceNetworkServiceAssociationIdentifier *string `location:"uri" locationName:"serviceNetworkServiceAssociationIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceNetworkServiceAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceNetworkServiceAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceNetworkServiceAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceNetworkServiceAssociationInput"}
	if s.ServiceNetworkServiceAssociationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNetworkServiceAssociationIdentifier"))
	}
	if s.ServiceNetworkServiceAssociationIdentifier != nil && len(*s.ServiceNetworkServiceAssociationIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceNetworkServiceAssociationIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceNetworkServiceAssociationIdentifier sets the ServiceNetworkServiceAssociationIdentifier field's value.
func (s *GetServiceNetworkServiceAssociationInput) SetServiceNetworkServiceAssociationIdentifier(v string) *GetServiceNetworkServiceAssociationInput {
	s.ServiceNetworkServiceAssociationIdentifier = &v
	return s
}

type GetServiceNetworkServiceAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the association.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The date and time that the association was created, specified in ISO-8601
	// format.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The account that created the association.
	CreatedBy *string `locationName:"createdBy" min:"1" type:"string"`

	// The custom domain name of the service.
	CustomDomainName *string `locationName:"customDomainName" min:"3" type:"string"`

	// The DNS name of the service.
	DnsEntry *DnsEntry `locationName:"dnsEntry" type:"structure"`

	// The failure code.
	FailureCode *string `locationName:"failureCode" type:"string"`

	// The failure message.
	FailureMessage *string `locationName:"failureMessage" type:"string"`

	// The ID of the service network and service association.
	Id *string `locationName:"id" min:"17" type:"string"`

	// The Amazon Resource Name (ARN) of the service.
	ServiceArn *string `locationName:"serviceArn" min:"20" type:"string"`

	// The ID of the service.
	ServiceId *string `locationName:"serviceId" min:"21" type:"string"`

	// The name of the service.
	ServiceName *string `locationName:"serviceName" min:"3" type:"string"`

	// The Amazon Resource Name (ARN) of the service network.
	ServiceNetworkArn *string `locationName:"serviceNetworkArn" min:"32" type:"string"`

	// The ID of the service network.
	ServiceNetworkId *string `locationName:"serviceNetworkId" min:"32" type:"string"`

	// The name of the service network.
	ServiceNetworkName *string `locationName:"serviceNetworkName" min:"3" type:"string"`

	// The status of the association.
	Status *string `locationName:"status" type:"string" enum:"ServiceNetworkServiceAssociationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceNetworkServiceAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceNetworkServiceAssociationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetServiceNetworkServiceAssociationOutput) SetArn(v string) *GetServiceNetworkServiceAssociationOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetServiceNetworkServiceAssociationOutput) SetCreatedAt(v time.Time) *GetServiceNetworkServiceAssociationOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *GetServiceNetworkServiceAssociationOutput) SetCreatedBy(v string) *GetServiceNetworkServiceAssociationOutput {
	s.CreatedBy = &v
	return s
}

// SetCustomDomainName sets the CustomDomainName field's value.
func (s *GetServiceNetworkServiceAssociationOutput) SetCustomDomainName(v string) *GetServiceNetworkServiceAssociationOutput {
	s.CustomDomainName = &v
	return s
}

// SetDnsEntry sets the DnsEntry field's value.
func (s *GetServiceNetworkServiceAssociationOutput) SetDnsEntry(v *DnsEntry) *GetServiceNetworkServiceAssociationOutput {
	s.DnsEntry = v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *GetServiceNetworkServiceAssociationOutput) SetFailureCode(v string) *GetServiceNetworkServiceAssociationOutput {
	s.FailureCode = &v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *GetServiceNetworkServiceAssociationOutput) SetFailureMessage(v string) *GetServiceNetworkServiceAssociationOutput {
	s.FailureMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetServiceNetworkServiceAssociationOutput) SetId(v string) *GetServiceNetworkServiceAssociationOutput {
	s.Id = &v
	return s
}

// SetServiceArn sets the ServiceArn field's value.
func (s *GetServiceNetworkServiceAssociationOutput) SetServiceArn(v string) *GetServiceNetworkServiceAssociationOutput {
	s.ServiceArn = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *GetServiceNetworkServiceAssociationOutput) SetServiceId(v string) *GetServiceNetworkServiceAssociationOutput {
	s.ServiceId = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *GetServiceNetworkServiceAssociationOutput) SetServiceName(v string) *GetServiceNetworkServiceAssociationOutput {
	s.ServiceName = &v
	return s
}

// SetServiceNetworkArn sets the ServiceNetworkArn field's value.
func (s *GetServiceNetworkServiceAssociationOutput) SetServiceNetworkArn(v string) *GetServiceNetworkServiceAssociationOutput {
	s.ServiceNetworkArn = &v
	return s
}

// SetServiceNetworkId sets the ServiceNetworkId field's value.
func (s *GetServiceNetworkServiceAssociationOutput) SetServiceNetworkId(v string) *GetServiceNetworkServiceAssociationOutput {
	s.ServiceNetworkId = &v
	return s
}

// SetServiceNetworkName sets the ServiceNetworkName field's value.
func (s *GetServiceNetworkServiceAssociationOutput) SetServiceNetworkName(v string) *GetServiceNetworkServiceAssociationOutput {
	s.ServiceNetworkName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetServiceNetworkServiceAssociationOutput) SetStatus(v string) *GetServiceNetworkServiceAssociationOutput {
	s.Status = &v
	return s
}

type GetServiceNetworkVpcAssociationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID or Amazon Resource Name (ARN) of the association.
	//
	// ServiceNetworkVpcAssociationIdentifier is a required field
	ServiceNetworkVpcAssociationIdentifier *string `location:"uri" locationName:"serviceNetworkVpcAssociationIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceNetworkVpcAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceNetworkVpcAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceNetworkVpcAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceNetworkVpcAssociationInput"}
	if s.ServiceNetworkVpcAssociationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNetworkVpcAssociationIdentifier"))
	}
	if s.ServiceNetworkVpcAssociationIdentifier != nil && len(*s.ServiceNetworkVpcAssociationIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceNetworkVpcAssociationIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceNetworkVpcAssociationIdentifier sets the ServiceNetworkVpcAssociationIdentifier field's value.
func (s *GetServiceNetworkVpcAssociationInput) SetServiceNetworkVpcAssociationIdentifier(v string) *GetServiceNetworkVpcAssociationInput {
	s.ServiceNetworkVpcAssociationIdentifier = &v
	return s
}

type GetServiceNetworkVpcAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the association.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The date and time that the association was created, specified in ISO-8601
	// format.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The account that created the association.
	CreatedBy *string `locationName:"createdBy" min:"1" type:"string"`

	// The failure code.
	FailureCode *string `locationName:"failureCode" type:"string"`

	// The failure message.
	FailureMessage *string `locationName:"failureMessage" type:"string"`

	// The ID of the specified association between the service network and the VPC.
	Id *string `locationName:"id" min:"22" type:"string"`

	// The date and time that the association was last updated, specified in ISO-8601
	// format.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The IDs of the security groups.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// The Amazon Resource Name (ARN) of the service network.
	ServiceNetworkArn *string `locationName:"serviceNetworkArn" min:"32" type:"string"`

	// The ID of the service network.
	ServiceNetworkId *string `locationName:"serviceNetworkId" min:"32" type:"string"`

	// The name of the service network.
	ServiceNetworkName *string `locationName:"serviceNetworkName" min:"3" type:"string"`

	// The status of the association.
	Status *string `locationName:"status" type:"string" enum:"ServiceNetworkVpcAssociationStatus"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceNetworkVpcAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceNetworkVpcAssociationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetServiceNetworkVpcAssociationOutput) SetArn(v string) *GetServiceNetworkVpcAssociationOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetServiceNetworkVpcAssociationOutput) SetCreatedAt(v time.Time) *GetServiceNetworkVpcAssociationOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *GetServiceNetworkVpcAssociationOutput) SetCreatedBy(v string) *GetServiceNetworkVpcAssociationOutput {
	s.CreatedBy = &v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *GetServiceNetworkVpcAssociationOutput) SetFailureCode(v string) *GetServiceNetworkVpcAssociationOutput {
	s.FailureCode = &v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *GetServiceNetworkVpcAssociationOutput) SetFailureMessage(v string) *GetServiceNetworkVpcAssociationOutput {
	s.FailureMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetServiceNetworkVpcAssociationOutput) SetId(v string) *GetServiceNetworkVpcAssociationOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetServiceNetworkVpcAssociationOutput) SetLastUpdatedAt(v time.Time) *GetServiceNetworkVpcAssociationOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *GetServiceNetworkVpcAssociationOutput) SetSecurityGroupIds(v []*string) *GetServiceNetworkVpcAssociationOutput {
	s.SecurityGroupIds = v
	return s
}

// SetServiceNetworkArn sets the ServiceNetworkArn field's value.
func (s *GetServiceNetworkVpcAssociationOutput) SetServiceNetworkArn(v string) *GetServiceNetworkVpcAssociationOutput {
	s.ServiceNetworkArn = &v
	return s
}

// SetServiceNetworkId sets the ServiceNetworkId field's value.
func (s *GetServiceNetworkVpcAssociationOutput) SetServiceNetworkId(v string) *GetServiceNetworkVpcAssociationOutput {
	s.ServiceNetworkId = &v
	return s
}

// SetServiceNetworkName sets the ServiceNetworkName field's value.
func (s *GetServiceNetworkVpcAssociationOutput) SetServiceNetworkName(v string) *GetServiceNetworkVpcAssociationOutput {
	s.ServiceNetworkName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetServiceNetworkVpcAssociationOutput) SetStatus(v string) *GetServiceNetworkVpcAssociationOutput {
	s.Status = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *GetServiceNetworkVpcAssociationOutput) SetVpcId(v string) *GetServiceNetworkVpcAssociationOutput {
	s.VpcId = &v
	return s
}

type GetServiceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the service.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The type of IAM policy.
	AuthType *string `locationName:"authType" type:"string" enum:"AuthType"`

	// The Amazon Resource Name (ARN) of the certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The date and time that the service was created, specified in ISO-8601 format.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The custom domain name of the service.
	CustomDomainName *string `locationName:"customDomainName" min:"3" type:"string"`

	// The DNS name of the service.
	DnsEntry *DnsEntry `locationName:"dnsEntry" type:"structure"`

	// The failure code.
	FailureCode *string `locationName:"failureCode" type:"string"`

	// The failure message.
	FailureMessage *string `locationName:"failureMessage" type:"string"`

	// The ID of the service.
	Id *string `locationName:"id" min:"21" type:"string"`

	// The date and time that the service was last updated, specified in ISO-8601
	// format.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the service.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The status of the service.
	Status *string `locationName:"status" type:"string" enum:"ServiceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetServiceOutput) SetArn(v string) *GetServiceOutput {
	s.Arn = &v
	return s
}

// SetAuthType sets the AuthType field's value.
func (s *GetServiceOutput) SetAuthType(v string) *GetServiceOutput {
	s.AuthType = &v
	return s
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *GetServiceOutput) SetCertificateArn(v string) *GetServiceOutput {
	s.CertificateArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetServiceOutput) SetCreatedAt(v time.Time) *GetServiceOutput {
	s.CreatedAt = &v
	return s
}

// SetCustomDomainName sets the CustomDomainName field's value.
func (s *GetServiceOutput) SetCustomDomainName(v string) *GetServiceOutput {
	s.CustomDomainName = &v
	return s
}

// SetDnsEntry sets the DnsEntry field's value.
func (s *GetServiceOutput) SetDnsEntry(v *DnsEntry) *GetServiceOutput {
	s.DnsEntry = v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *GetServiceOutput) SetFailureCode(v string) *GetServiceOutput {
	s.FailureCode = &v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *GetServiceOutput) SetFailureMessage(v string) *GetServiceOutput {
	s.FailureMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetServiceOutput) SetId(v string) *GetServiceOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetServiceOutput) SetLastUpdatedAt(v time.Time) *GetServiceOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetServiceOutput) SetName(v string) *GetServiceOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetServiceOutput) SetStatus(v string) *GetServiceOutput {
	s.Status = &v
	return s
}

type GetTargetGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID or Amazon Resource Name (ARN) of the target group.
	//
	// TargetGroupIdentifier is a required field
	TargetGroupIdentifier *string `location:"uri" locationName:"targetGroupIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTargetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTargetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTargetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTargetGroupInput"}
	if s.TargetGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetGroupIdentifier"))
	}
	if s.TargetGroupIdentifier != nil && len(*s.TargetGroupIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("TargetGroupIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetGroupIdentifier sets the TargetGroupIdentifier field's value.
func (s *GetTargetGroupInput) SetTargetGroupIdentifier(v string) *GetTargetGroupInput {
	s.TargetGroupIdentifier = &v
	return s
}

type GetTargetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target group.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The target group configuration.
	Config *TargetGroupConfig `locationName:"config" type:"structure"`

	// The date and time that the target group was created, specified in ISO-8601
	// format.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The failure code.
	FailureCode *string `locationName:"failureCode" type:"string"`

	// The failure message.
	FailureMessage *string `locationName:"failureMessage" type:"string"`

	// The ID of the target group.
	Id *string `locationName:"id" min:"20" type:"string"`

	// The date and time that the target group was last updated, specified in ISO-8601
	// format.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the target group.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The Amazon Resource Names (ARNs) of the service.
	ServiceArns []*string `locationName:"serviceArns" type:"list"`

	// The status.
	Status *string `locationName:"status" type:"string" enum:"TargetGroupStatus"`

	// The target group type.
	Type *string `locationName:"type" type:"string" enum:"TargetGroupType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTargetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTargetGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetTargetGroupOutput) SetArn(v string) *GetTargetGroupOutput {
	s.Arn = &v
	return s
}

// SetConfig sets the Config field's value.
func (s *GetTargetGroupOutput) SetConfig(v *TargetGroupConfig) *GetTargetGroupOutput {
	s.Config = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetTargetGroupOutput) SetCreatedAt(v time.Time) *GetTargetGroupOutput {
	s.CreatedAt = &v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *GetTargetGroupOutput) SetFailureCode(v string) *GetTargetGroupOutput {
	s.FailureCode = &v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *GetTargetGroupOutput) SetFailureMessage(v string) *GetTargetGroupOutput {
	s.FailureMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetTargetGroupOutput) SetId(v string) *GetTargetGroupOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetTargetGroupOutput) SetLastUpdatedAt(v time.Time) *GetTargetGroupOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetTargetGroupOutput) SetName(v string) *GetTargetGroupOutput {
	s.Name = &v
	return s
}

// SetServiceArns sets the ServiceArns field's value.
func (s *GetTargetGroupOutput) SetServiceArns(v []*string) *GetTargetGroupOutput {
	s.ServiceArns = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetTargetGroupOutput) SetStatus(v string) *GetTargetGroupOutput {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetTargetGroupOutput) SetType(v string) *GetTargetGroupOutput {
	s.Type = &v
	return s
}

// Describes the constraints for a header match. Matches incoming requests with
// rule based on request header value before applying rule action.
type HeaderMatch struct {
	_ struct{} `type:"structure"`

	// Indicates whether the match is case sensitive.
	CaseSensitive *bool `locationName:"caseSensitive" type:"boolean"`

	// The header match type.
	//
	// Match is a required field
	Match *HeaderMatchType `locationName:"match" type:"structure" required:"true"`

	// The name of the header.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HeaderMatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HeaderMatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HeaderMatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HeaderMatch"}
	if s.Match == nil {
		invalidParams.Add(request.NewErrParamRequired("Match"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Match != nil {
		if err := s.Match.Validate(); err != nil {
			invalidParams.AddNested("Match", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaseSensitive sets the CaseSensitive field's value.
func (s *HeaderMatch) SetCaseSensitive(v bool) *HeaderMatch {
	s.CaseSensitive = &v
	return s
}

// SetMatch sets the Match field's value.
func (s *HeaderMatch) SetMatch(v *HeaderMatchType) *HeaderMatch {
	s.Match = v
	return s
}

// SetName sets the Name field's value.
func (s *HeaderMatch) SetName(v string) *HeaderMatch {
	s.Name = &v
	return s
}

// Describes a header match type.
type HeaderMatchType struct {
	_ struct{} `type:"structure"`

	// A contains type match.
	Contains *string `locationName:"contains" min:"1" type:"string"`

	// An exact type match.
	Exact *string `locationName:"exact" min:"1" type:"string"`

	// A prefix type match. Matches the value with the prefix.
	Prefix *string `locationName:"prefix" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HeaderMatchType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HeaderMatchType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HeaderMatchType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HeaderMatchType"}
	if s.Contains != nil && len(*s.Contains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Contains", 1))
	}
	if s.Exact != nil && len(*s.Exact) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Exact", 1))
	}
	if s.Prefix != nil && len(*s.Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContains sets the Contains field's value.
func (s *HeaderMatchType) SetContains(v string) *HeaderMatchType {
	s.Contains = &v
	return s
}

// SetExact sets the Exact field's value.
func (s *HeaderMatchType) SetExact(v string) *HeaderMatchType {
	s.Exact = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *HeaderMatchType) SetPrefix(v string) *HeaderMatchType {
	s.Prefix = &v
	return s
}

// Describes the health check configuration of a target group. Health check
// configurations aren't used for target groups of type LAMBDA or ALB.
type HealthCheckConfig struct {
	_ struct{} `type:"structure"`

	// Indicates whether health checking is enabled.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The approximate amount of time, in seconds, between health checks of an individual
	// target. The range is 5–300 seconds. The default is 30 seconds.
	HealthCheckIntervalSeconds *int64 `locationName:"healthCheckIntervalSeconds" type:"integer"`

	// The amount of time, in seconds, to wait before reporting a target as unhealthy.
	// The range is 1–120 seconds. The default is 5 seconds.
	HealthCheckTimeoutSeconds *int64 `locationName:"healthCheckTimeoutSeconds" type:"integer"`

	// The number of consecutive successful health checks required before considering
	// an unhealthy target healthy. The range is 2–10. The default is 5.
	HealthyThresholdCount *int64 `locationName:"healthyThresholdCount" type:"integer"`

	// The codes to use when checking for a successful response from a target.
	Matcher *Matcher `locationName:"matcher" type:"structure"`

	// The destination for health checks on the targets. If the protocol version
	// is HTTP/1.1 or HTTP/2, specify a valid URI (for example, /path?query). The
	// default path is /. Health checks are not supported if the protocol version
	// is gRPC, however, you can choose HTTP/1.1 or HTTP/2 and specify a valid URI.
	Path *string `locationName:"path" type:"string"`

	// The port used when performing health checks on targets. The default setting
	// is the port that a target receives traffic on.
	Port *int64 `locationName:"port" type:"integer"`

	// The protocol used when performing health checks on targets. The possible
	// protocols are HTTP and HTTPS. The default is HTTP.
	Protocol *string `locationName:"protocol" type:"string" enum:"TargetGroupProtocol"`

	// The protocol version used when performing health checks on targets. The possible
	// protocol versions are HTTP1 and HTTP2.
	ProtocolVersion *string `locationName:"protocolVersion" type:"string" enum:"HealthCheckProtocolVersion"`

	// The number of consecutive failed health checks required before considering
	// a target unhealthy. The range is 2–10. The default is 2.
	UnhealthyThresholdCount *int64 `locationName:"unhealthyThresholdCount" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HealthCheckConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HealthCheckConfig) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *HealthCheckConfig) SetEnabled(v bool) *HealthCheckConfig {
	s.Enabled = &v
	return s
}

// SetHealthCheckIntervalSeconds sets the HealthCheckIntervalSeconds field's value.
func (s *HealthCheckConfig) SetHealthCheckIntervalSeconds(v int64) *HealthCheckConfig {
	s.HealthCheckIntervalSeconds = &v
	return s
}

// SetHealthCheckTimeoutSeconds sets the HealthCheckTimeoutSeconds field's value.
func (s *HealthCheckConfig) SetHealthCheckTimeoutSeconds(v int64) *HealthCheckConfig {
	s.HealthCheckTimeoutSeconds = &v
	return s
}

// SetHealthyThresholdCount sets the HealthyThresholdCount field's value.
func (s *HealthCheckConfig) SetHealthyThresholdCount(v int64) *HealthCheckConfig {
	s.HealthyThresholdCount = &v
	return s
}

// SetMatcher sets the Matcher field's value.
func (s *HealthCheckConfig) SetMatcher(v *Matcher) *HealthCheckConfig {
	s.Matcher = v
	return s
}

// SetPath sets the Path field's value.
func (s *HealthCheckConfig) SetPath(v string) *HealthCheckConfig {
	s.Path = &v
	return s
}

// SetPort sets the Port field's value.
func (s *HealthCheckConfig) SetPort(v int64) *HealthCheckConfig {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *HealthCheckConfig) SetProtocol(v string) *HealthCheckConfig {
	s.Protocol = &v
	return s
}

// SetProtocolVersion sets the ProtocolVersion field's value.
func (s *HealthCheckConfig) SetProtocolVersion(v string) *HealthCheckConfig {
	s.ProtocolVersion = &v
	return s
}

// SetUnhealthyThresholdCount sets the UnhealthyThresholdCount field's value.
func (s *HealthCheckConfig) SetUnhealthyThresholdCount(v int64) *HealthCheckConfig {
	s.UnhealthyThresholdCount = &v
	return s
}

// Describes criteria that can be applied to incoming requests.
type HttpMatch struct {
	_ struct{} `type:"structure"`

	// The header matches. Matches incoming requests with rule based on request
	// header value before applying rule action.
	HeaderMatches []*HeaderMatch `locationName:"headerMatches" min:"1" type:"list"`

	// The HTTP method type.
	Method *string `locationName:"method" type:"string"`

	// The path match.
	PathMatch *PathMatch `locationName:"pathMatch" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpMatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpMatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpMatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpMatch"}
	if s.HeaderMatches != nil && len(s.HeaderMatches) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HeaderMatches", 1))
	}
	if s.HeaderMatches != nil {
		for i, v := range s.HeaderMatches {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "HeaderMatches", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PathMatch != nil {
		if err := s.PathMatch.Validate(); err != nil {
			invalidParams.AddNested("PathMatch", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHeaderMatches sets the HeaderMatches field's value.
func (s *HttpMatch) SetHeaderMatches(v []*HeaderMatch) *HttpMatch {
	s.HeaderMatches = v
	return s
}

// SetMethod sets the Method field's value.
func (s *HttpMatch) SetMethod(v string) *HttpMatch {
	s.Method = &v
	return s
}

// SetPathMatch sets the PathMatch field's value.
func (s *HttpMatch) SetPathMatch(v *PathMatch) *HttpMatch {
	s.PathMatch = v
	return s
}

// An unexpected error occurred while processing the request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The number of seconds to wait before retrying.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAccessLogSubscriptionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ID or Amazon Resource Name (ARN) of the service network or service.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `location:"querystring" locationName:"resourceIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessLogSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessLogSubscriptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessLogSubscriptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccessLogSubscriptionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}
	if s.ResourceIdentifier != nil && len(*s.ResourceIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccessLogSubscriptionsInput) SetMaxResults(v int64) *ListAccessLogSubscriptionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessLogSubscriptionsInput) SetNextToken(v string) *ListAccessLogSubscriptionsInput {
	s.NextToken = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ListAccessLogSubscriptionsInput) SetResourceIdentifier(v string) *ListAccessLogSubscriptionsInput {
	s.ResourceIdentifier = &v
	return s
}

type ListAccessLogSubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the access log subscriptions.
	//
	// Items is a required field
	Items []*AccessLogSubscriptionSummary `locationName:"items" type:"list" required:"true"`

	// A pagination token for the next page of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessLogSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessLogSubscriptionsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListAccessLogSubscriptionsOutput) SetItems(v []*AccessLogSubscriptionSummary) *ListAccessLogSubscriptionsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessLogSubscriptionsOutput) SetNextToken(v string) *ListAccessLogSubscriptionsOutput {
	s.NextToken = &v
	return s
}

type ListListenersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ID or Amazon Resource Name (ARN) of the service.
	//
	// ServiceIdentifier is a required field
	ServiceIdentifier *string `location:"uri" locationName:"serviceIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListListenersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListListenersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListListenersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListListenersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ServiceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceIdentifier"))
	}
	if s.ServiceIdentifier != nil && len(*s.ServiceIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListListenersInput) SetMaxResults(v int64) *ListListenersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListListenersInput) SetNextToken(v string) *ListListenersInput {
	s.NextToken = &v
	return s
}

// SetServiceIdentifier sets the ServiceIdentifier field's value.
func (s *ListListenersInput) SetServiceIdentifier(v string) *ListListenersInput {
	s.ServiceIdentifier = &v
	return s
}

type ListListenersOutput struct {
	_ struct{} `type:"structure"`

	// Information about the listeners.
	//
	// Items is a required field
	Items []*ListenerSummary `locationName:"items" type:"list" required:"true"`

	// If there are additional results, a pagination token for the next page of
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListListenersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListListenersOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListListenersOutput) SetItems(v []*ListenerSummary) *ListListenersOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListListenersOutput) SetNextToken(v string) *ListListenersOutput {
	s.NextToken = &v
	return s
}

type ListRulesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID or Amazon Resource Name (ARN) of the listener.
	//
	// ListenerIdentifier is a required field
	ListenerIdentifier *string `location:"uri" locationName:"listenerIdentifier" min:"20" type:"string" required:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ID or Amazon Resource Name (ARN) of the service.
	//
	// ServiceIdentifier is a required field
	ServiceIdentifier *string `location:"uri" locationName:"serviceIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRulesInput"}
	if s.ListenerIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerIdentifier"))
	}
	if s.ListenerIdentifier != nil && len(*s.ListenerIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ListenerIdentifier", 20))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ServiceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceIdentifier"))
	}
	if s.ServiceIdentifier != nil && len(*s.ServiceIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListenerIdentifier sets the ListenerIdentifier field's value.
func (s *ListRulesInput) SetListenerIdentifier(v string) *ListRulesInput {
	s.ListenerIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRulesInput) SetMaxResults(v int64) *ListRulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRulesInput) SetNextToken(v string) *ListRulesInput {
	s.NextToken = &v
	return s
}

// SetServiceIdentifier sets the ServiceIdentifier field's value.
func (s *ListRulesInput) SetServiceIdentifier(v string) *ListRulesInput {
	s.ServiceIdentifier = &v
	return s
}

type ListRulesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the rules.
	//
	// Items is a required field
	Items []*RuleSummary `locationName:"items" type:"list" required:"true"`

	// If there are additional results, a pagination token for the next page of
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListRulesOutput) SetItems(v []*RuleSummary) *ListRulesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRulesOutput) SetNextToken(v string) *ListRulesOutput {
	s.NextToken = &v
	return s
}

type ListServiceNetworkServiceAssociationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ID or Amazon Resource Name (ARN) of the service.
	ServiceIdentifier *string `location:"querystring" locationName:"serviceIdentifier" min:"17" type:"string"`

	// The ID or Amazon Resource Name (ARN) of the service network.
	ServiceNetworkIdentifier *string `location:"querystring" locationName:"serviceNetworkIdentifier" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceNetworkServiceAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceNetworkServiceAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServiceNetworkServiceAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServiceNetworkServiceAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ServiceIdentifier != nil && len(*s.ServiceIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceIdentifier", 17))
	}
	if s.ServiceNetworkIdentifier != nil && len(*s.ServiceNetworkIdentifier) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceNetworkIdentifier", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServiceNetworkServiceAssociationsInput) SetMaxResults(v int64) *ListServiceNetworkServiceAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceNetworkServiceAssociationsInput) SetNextToken(v string) *ListServiceNetworkServiceAssociationsInput {
	s.NextToken = &v
	return s
}

// SetServiceIdentifier sets the ServiceIdentifier field's value.
func (s *ListServiceNetworkServiceAssociationsInput) SetServiceIdentifier(v string) *ListServiceNetworkServiceAssociationsInput {
	s.ServiceIdentifier = &v
	return s
}

// SetServiceNetworkIdentifier sets the ServiceNetworkIdentifier field's value.
func (s *ListServiceNetworkServiceAssociationsInput) SetServiceNetworkIdentifier(v string) *ListServiceNetworkServiceAssociationsInput {
	s.ServiceNetworkIdentifier = &v
	return s
}

type ListServiceNetworkServiceAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the associations.
	//
	// Items is a required field
	Items []*ServiceNetworkServiceAssociationSummary `locationName:"items" type:"list" required:"true"`

	// If there are additional results, a pagination token for the next page of
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceNetworkServiceAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceNetworkServiceAssociationsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListServiceNetworkServiceAssociationsOutput) SetItems(v []*ServiceNetworkServiceAssociationSummary) *ListServiceNetworkServiceAssociationsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceNetworkServiceAssociationsOutput) SetNextToken(v string) *ListServiceNetworkServiceAssociationsOutput {
	s.NextToken = &v
	return s
}

type ListServiceNetworkVpcAssociationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ID or Amazon Resource Name (ARN) of the service network.
	ServiceNetworkIdentifier *string `location:"querystring" locationName:"serviceNetworkIdentifier" min:"3" type:"string"`

	// The ID or Amazon Resource Name (ARN) of the VPC.
	VpcIdentifier *string `location:"querystring" locationName:"vpcIdentifier" min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceNetworkVpcAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceNetworkVpcAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServiceNetworkVpcAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServiceNetworkVpcAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ServiceNetworkIdentifier != nil && len(*s.ServiceNetworkIdentifier) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceNetworkIdentifier", 3))
	}
	if s.VpcIdentifier != nil && len(*s.VpcIdentifier) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("VpcIdentifier", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServiceNetworkVpcAssociationsInput) SetMaxResults(v int64) *ListServiceNetworkVpcAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceNetworkVpcAssociationsInput) SetNextToken(v string) *ListServiceNetworkVpcAssociationsInput {
	s.NextToken = &v
	return s
}

// SetServiceNetworkIdentifier sets the ServiceNetworkIdentifier field's value.
func (s *ListServiceNetworkVpcAssociationsInput) SetServiceNetworkIdentifier(v string) *ListServiceNetworkVpcAssociationsInput {
	s.ServiceNetworkIdentifier = &v
	return s
}

// SetVpcIdentifier sets the VpcIdentifier field's value.
func (s *ListServiceNetworkVpcAssociationsInput) SetVpcIdentifier(v string) *ListServiceNetworkVpcAssociationsInput {
	s.VpcIdentifier = &v
	return s
}

type ListServiceNetworkVpcAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the associations.
	//
	// Items is a required field
	Items []*ServiceNetworkVpcAssociationSummary `locationName:"items" type:"list" required:"true"`

	// If there are additional results, a pagination token for the next page of
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceNetworkVpcAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceNetworkVpcAssociationsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListServiceNetworkVpcAssociationsOutput) SetItems(v []*ServiceNetworkVpcAssociationSummary) *ListServiceNetworkVpcAssociationsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceNetworkVpcAssociationsOutput) SetNextToken(v string) *ListServiceNetworkVpcAssociationsOutput {
	s.NextToken = &v
	return s
}

type ListServiceNetworksInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceNetworksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceNetworksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServiceNetworksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServiceNetworksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServiceNetworksInput) SetMaxResults(v int64) *ListServiceNetworksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceNetworksInput) SetNextToken(v string) *ListServiceNetworksInput {
	s.NextToken = &v
	return s
}

type ListServiceNetworksOutput struct {
	_ struct{} `type:"structure"`

	// Information about the service networks.
	//
	// Items is a required field
	Items []*ServiceNetworkSummary `locationName:"items" type:"list" required:"true"`

	// If there are additional results, a pagination token for the next page of
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceNetworksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceNetworksOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListServiceNetworksOutput) SetItems(v []*ServiceNetworkSummary) *ListServiceNetworksOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceNetworksOutput) SetNextToken(v string) *ListServiceNetworksOutput {
	s.NextToken = &v
	return s
}

type ListServicesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServicesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServicesInput) SetMaxResults(v int64) *ListServicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicesInput) SetNextToken(v string) *ListServicesInput {
	s.NextToken = &v
	return s
}

type ListServicesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the services.
	Items []*ServiceSummary `locationName:"items" type:"list"`

	// If there are additional results, a pagination token for the next page of
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListServicesOutput) SetItems(v []*ServiceSummary) *ListServicesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicesOutput) SetNextToken(v string) *ListServicesOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the tags.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTargetGroupsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The target group type.
	TargetGroupType *string `location:"querystring" locationName:"targetGroupType" type:"string" enum:"TargetGroupType"`

	// The ID or Amazon Resource Name (ARN) of the VPC.
	VpcIdentifier *string `location:"querystring" locationName:"vpcIdentifier" min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTargetGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTargetGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.VpcIdentifier != nil && len(*s.VpcIdentifier) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("VpcIdentifier", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTargetGroupsInput) SetMaxResults(v int64) *ListTargetGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetGroupsInput) SetNextToken(v string) *ListTargetGroupsInput {
	s.NextToken = &v
	return s
}

// SetTargetGroupType sets the TargetGroupType field's value.
func (s *ListTargetGroupsInput) SetTargetGroupType(v string) *ListTargetGroupsInput {
	s.TargetGroupType = &v
	return s
}

// SetVpcIdentifier sets the VpcIdentifier field's value.
func (s *ListTargetGroupsInput) SetVpcIdentifier(v string) *ListTargetGroupsInput {
	s.VpcIdentifier = &v
	return s
}

type ListTargetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the target groups.
	Items []*TargetGroupSummary `locationName:"items" type:"list"`

	// If there are additional results, a pagination token for the next page of
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetGroupsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListTargetGroupsOutput) SetItems(v []*TargetGroupSummary) *ListTargetGroupsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetGroupsOutput) SetNextToken(v string) *ListTargetGroupsOutput {
	s.NextToken = &v
	return s
}

type ListTargetsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ID or Amazon Resource Name (ARN) of the target group.
	//
	// TargetGroupIdentifier is a required field
	TargetGroupIdentifier *string `location:"uri" locationName:"targetGroupIdentifier" min:"17" type:"string" required:"true"`

	// The targets.
	Targets []*Target `locationName:"targets" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTargetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.TargetGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetGroupIdentifier"))
	}
	if s.TargetGroupIdentifier != nil && len(*s.TargetGroupIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("TargetGroupIdentifier", 17))
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTargetsInput) SetMaxResults(v int64) *ListTargetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetsInput) SetNextToken(v string) *ListTargetsInput {
	s.NextToken = &v
	return s
}

// SetTargetGroupIdentifier sets the TargetGroupIdentifier field's value.
func (s *ListTargetsInput) SetTargetGroupIdentifier(v string) *ListTargetsInput {
	s.TargetGroupIdentifier = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *ListTargetsInput) SetTargets(v []*Target) *ListTargetsInput {
	s.Targets = v
	return s
}

type ListTargetsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the targets.
	//
	// Items is a required field
	Items []*TargetSummary `locationName:"items" type:"list" required:"true"`

	// If there are additional results, a pagination token for the next page of
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListTargetsOutput) SetItems(v []*TargetSummary) *ListTargetsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetsOutput) SetNextToken(v string) *ListTargetsOutput {
	s.NextToken = &v
	return s
}

// Summary information about a listener.
type ListenerSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the listener.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The date and time that the listener was created, specified in ISO-8601 format.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The ID of the listener.
	Id *string `locationName:"id" min:"26" type:"string"`

	// The date and time that the listener was last updated, specified in ISO-8601
	// format.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the listener.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The listener port.
	Port *int64 `locationName:"port" min:"1" type:"integer"`

	// The listener protocol.
	Protocol *string `locationName:"protocol" type:"string" enum:"ListenerProtocol"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListenerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListenerSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListenerSummary) SetArn(v string) *ListenerSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ListenerSummary) SetCreatedAt(v time.Time) *ListenerSummary {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *ListenerSummary) SetId(v string) *ListenerSummary {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ListenerSummary) SetLastUpdatedAt(v time.Time) *ListenerSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListenerSummary) SetName(v string) *ListenerSummary {
	s.Name = &v
	return s
}

// SetPort sets the Port field's value.
func (s *ListenerSummary) SetPort(v int64) *ListenerSummary {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *ListenerSummary) SetProtocol(v string) *ListenerSummary {
	s.Protocol = &v
	return s
}

// Describes the codes to use when checking for a successful response from a
// target for health checks.
type Matcher struct {
	_ struct{} `type:"structure"`

	// The HTTP code to use when checking for a successful response from a target.
	HttpCode *string `locationName:"httpCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Matcher) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Matcher) GoString() string {
	return s.String()
}

// SetHttpCode sets the HttpCode field's value.
func (s *Matcher) SetHttpCode(v string) *Matcher {
	s.HttpCode = &v
	return s
}

// Describes the conditions that can be applied when matching a path for incoming
// requests.
type PathMatch struct {
	_ struct{} `type:"structure"`

	// Indicates whether the match is case sensitive.
	CaseSensitive *bool `locationName:"caseSensitive" type:"boolean"`

	// The type of path match.
	//
	// Match is a required field
	Match *PathMatchType `locationName:"match" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PathMatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PathMatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PathMatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PathMatch"}
	if s.Match == nil {
		invalidParams.Add(request.NewErrParamRequired("Match"))
	}
	if s.Match != nil {
		if err := s.Match.Validate(); err != nil {
			invalidParams.AddNested("Match", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaseSensitive sets the CaseSensitive field's value.
func (s *PathMatch) SetCaseSensitive(v bool) *PathMatch {
	s.CaseSensitive = &v
	return s
}

// SetMatch sets the Match field's value.
func (s *PathMatch) SetMatch(v *PathMatchType) *PathMatch {
	s.Match = v
	return s
}

// Describes a path match type. Each rule can include only one of the following
// types of paths.
type PathMatchType struct {
	_ struct{} `type:"structure"`

	// An exact match of the path.
	Exact *string `locationName:"exact" min:"1" type:"string"`

	// A prefix match of the path.
	Prefix *string `locationName:"prefix" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PathMatchType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PathMatchType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PathMatchType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PathMatchType"}
	if s.Exact != nil && len(*s.Exact) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Exact", 1))
	}
	if s.Prefix != nil && len(*s.Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExact sets the Exact field's value.
func (s *PathMatchType) SetExact(v string) *PathMatchType {
	s.Exact = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *PathMatchType) SetPrefix(v string) *PathMatchType {
	s.Prefix = &v
	return s
}

type PutAuthPolicyInput struct {
	_ struct{} `type:"structure"`

	// The auth policy. The policy string in JSON must not contain newlines or blank
	// lines.
	//
	// Policy is a required field
	Policy *string `locationName:"policy" type:"string" required:"true"`

	// The ID or Amazon Resource Name (ARN) of the service network or service for
	// which the policy is created.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `location:"uri" locationName:"resourceIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAuthPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAuthPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAuthPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAuthPolicyInput"}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}
	if s.ResourceIdentifier != nil && len(*s.ResourceIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicy sets the Policy field's value.
func (s *PutAuthPolicyInput) SetPolicy(v string) *PutAuthPolicyInput {
	s.Policy = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *PutAuthPolicyInput) SetResourceIdentifier(v string) *PutAuthPolicyInput {
	s.ResourceIdentifier = &v
	return s
}

type PutAuthPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The auth policy. The policy string in JSON must not contain newlines or blank
	// lines.
	Policy *string `locationName:"policy" type:"string"`

	// The state of the auth policy. The auth policy is only active when the auth
	// type is set to AWS_IAM. If you provide a policy, then authentication and
	// authorization decisions are made based on this policy and the client's IAM
	// policy. If the Auth type is NONE, then, any auth policy that you provide
	// remains inactive. For more information, see Create a service network (https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#create-service-network)
	// in the Amazon VPC Lattice User Guide.
	State *string `locationName:"state" type:"string" enum:"AuthPolicyState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAuthPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAuthPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *PutAuthPolicyOutput) SetPolicy(v string) *PutAuthPolicyOutput {
	s.Policy = &v
	return s
}

// SetState sets the State field's value.
func (s *PutAuthPolicyOutput) SetState(v string) *PutAuthPolicyOutput {
	s.State = &v
	return s
}

type PutResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// An IAM policy. The policy string in JSON must not contain newlines or blank
	// lines.
	//
	// Policy is a required field
	Policy *string `locationName:"policy" min:"1" type:"string" required:"true"`

	// The ID or Amazon Resource Name (ARN) of the service network or service for
	// which the policy is created.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutResourcePolicyInput"}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicy sets the Policy field's value.
func (s *PutResourcePolicyInput) SetPolicy(v string) *PutResourcePolicyInput {
	s.Policy = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *PutResourcePolicyInput) SetResourceArn(v string) *PutResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type PutResourcePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) GoString() string {
	return s.String()
}

type RegisterTargetsInput struct {
	_ struct{} `type:"structure"`

	// The ID or Amazon Resource Name (ARN) of the target group.
	//
	// TargetGroupIdentifier is a required field
	TargetGroupIdentifier *string `location:"uri" locationName:"targetGroupIdentifier" min:"17" type:"string" required:"true"`

	// The targets.
	//
	// Targets is a required field
	Targets []*Target `locationName:"targets" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterTargetsInput"}
	if s.TargetGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetGroupIdentifier"))
	}
	if s.TargetGroupIdentifier != nil && len(*s.TargetGroupIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("TargetGroupIdentifier", 17))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil && len(s.Targets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Targets", 1))
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetGroupIdentifier sets the TargetGroupIdentifier field's value.
func (s *RegisterTargetsInput) SetTargetGroupIdentifier(v string) *RegisterTargetsInput {
	s.TargetGroupIdentifier = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *RegisterTargetsInput) SetTargets(v []*Target) *RegisterTargetsInput {
	s.Targets = v
	return s
}

type RegisterTargetsOutput struct {
	_ struct{} `type:"structure"`

	// The targets that were successfully registered.
	Successful []*Target `locationName:"successful" type:"list"`

	// The targets that were not registered.
	Unsuccessful []*TargetFailure `locationName:"unsuccessful" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterTargetsOutput) GoString() string {
	return s.String()
}

// SetSuccessful sets the Successful field's value.
func (s *RegisterTargetsOutput) SetSuccessful(v []*Target) *RegisterTargetsOutput {
	s.Successful = v
	return s
}

// SetUnsuccessful sets the Unsuccessful field's value.
func (s *RegisterTargetsOutput) SetUnsuccessful(v []*TargetFailure) *RegisterTargetsOutput {
	s.Unsuccessful = v
	return s
}

// The request references a resource that does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The resource ID.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The resource type.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes the action for a rule.
type RuleAction struct {
	_ struct{} `type:"structure"`

	// The fixed response action. The rule returns a custom HTTP response.
	FixedResponse *FixedResponseAction `locationName:"fixedResponse" type:"structure"`

	// The forward action. Traffic that matches the rule is forwarded to the specified
	// target groups.
	Forward *ForwardAction `locationName:"forward" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleAction"}
	if s.FixedResponse != nil {
		if err := s.FixedResponse.Validate(); err != nil {
			invalidParams.AddNested("FixedResponse", err.(request.ErrInvalidParams))
		}
	}
	if s.Forward != nil {
		if err := s.Forward.Validate(); err != nil {
			invalidParams.AddNested("Forward", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFixedResponse sets the FixedResponse field's value.
func (s *RuleAction) SetFixedResponse(v *FixedResponseAction) *RuleAction {
	s.FixedResponse = v
	return s
}

// SetForward sets the Forward field's value.
func (s *RuleAction) SetForward(v *ForwardAction) *RuleAction {
	s.Forward = v
	return s
}

// Describes a rule match.
type RuleMatch struct {
	_ struct{} `type:"structure"`

	// The HTTP criteria that a rule must match.
	HttpMatch *HttpMatch `locationName:"httpMatch" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleMatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleMatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleMatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleMatch"}
	if s.HttpMatch != nil {
		if err := s.HttpMatch.Validate(); err != nil {
			invalidParams.AddNested("HttpMatch", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpMatch sets the HttpMatch field's value.
func (s *RuleMatch) SetHttpMatch(v *HttpMatch) *RuleMatch {
	s.HttpMatch = v
	return s
}

// Summary information about the listener rule.
type RuleSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The date and time that the listener rule was created, specified in ISO-8601
	// format.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The ID of the rule.
	Id *string `locationName:"id" min:"5" type:"string"`

	// Indicates whether this is the default listener rule.
	IsDefault *bool `locationName:"isDefault" type:"boolean"`

	// The date and time that the listener rule was last updated, specified in ISO-8601
	// format.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the rule.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The priority of the rule.
	Priority *int64 `locationName:"priority" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RuleSummary) SetArn(v string) *RuleSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *RuleSummary) SetCreatedAt(v time.Time) *RuleSummary {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *RuleSummary) SetId(v string) *RuleSummary {
	s.Id = &v
	return s
}

// SetIsDefault sets the IsDefault field's value.
func (s *RuleSummary) SetIsDefault(v bool) *RuleSummary {
	s.IsDefault = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *RuleSummary) SetLastUpdatedAt(v time.Time) *RuleSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *RuleSummary) SetName(v string) *RuleSummary {
	s.Name = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *RuleSummary) SetPriority(v int64) *RuleSummary {
	s.Priority = &v
	return s
}

// Describes a rule update.
type RuleUpdate struct {
	_ struct{} `type:"structure"`

	// The rule action.
	Action *RuleAction `locationName:"action" type:"structure"`

	// The rule match.
	Match *RuleMatch `locationName:"match" type:"structure"`

	// The rule priority. A listener can't have multiple rules with the same priority.
	Priority *int64 `locationName:"priority" min:"1" type:"integer"`

	// The ID or Amazon Resource Name (ARN) of the rule.
	//
	// RuleIdentifier is a required field
	RuleIdentifier *string `locationName:"ruleIdentifier" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleUpdate"}
	if s.Priority != nil && *s.Priority < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Priority", 1))
	}
	if s.RuleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleIdentifier"))
	}
	if s.RuleIdentifier != nil && len(*s.RuleIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RuleIdentifier", 20))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}
	if s.Match != nil {
		if err := s.Match.Validate(); err != nil {
			invalidParams.AddNested("Match", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *RuleUpdate) SetAction(v *RuleAction) *RuleUpdate {
	s.Action = v
	return s
}

// SetMatch sets the Match field's value.
func (s *RuleUpdate) SetMatch(v *RuleMatch) *RuleUpdate {
	s.Match = v
	return s
}

// SetPriority sets the Priority field's value.
func (s *RuleUpdate) SetPriority(v int64) *RuleUpdate {
	s.Priority = &v
	return s
}

// SetRuleIdentifier sets the RuleIdentifier field's value.
func (s *RuleUpdate) SetRuleIdentifier(v string) *RuleUpdate {
	s.RuleIdentifier = &v
	return s
}

// Describes a rule update that failed.
type RuleUpdateFailure struct {
	_ struct{} `type:"structure"`

	// The failure code.
	FailureCode *string `locationName:"failureCode" type:"string"`

	// The failure message.
	FailureMessage *string `locationName:"failureMessage" type:"string"`

	// The ID or Amazon Resource Name (ARN) of the rule.
	RuleIdentifier *string `locationName:"ruleIdentifier" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleUpdateFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleUpdateFailure) GoString() string {
	return s.String()
}

// SetFailureCode sets the FailureCode field's value.
func (s *RuleUpdateFailure) SetFailureCode(v string) *RuleUpdateFailure {
	s.FailureCode = &v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *RuleUpdateFailure) SetFailureMessage(v string) *RuleUpdateFailure {
	s.FailureMessage = &v
	return s
}

// SetRuleIdentifier sets the RuleIdentifier field's value.
func (s *RuleUpdateFailure) SetRuleIdentifier(v string) *RuleUpdateFailure {
	s.RuleIdentifier = &v
	return s
}

// Describes a successful rule update.
type RuleUpdateSuccess struct {
	_ struct{} `type:"structure"`

	// The action for the rule.
	Action *RuleAction `locationName:"action" type:"structure"`

	// The Amazon Resource Name (ARN) of the listener.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The ID of the listener.
	Id *string `locationName:"id" min:"5" type:"string"`

	// Indicates whether this is the default rule.
	IsDefault *bool `locationName:"isDefault" type:"boolean"`

	// The rule match.
	Match *RuleMatch `locationName:"match" type:"structure"`

	// The name of the listener.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The rule priority.
	Priority *int64 `locationName:"priority" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleUpdateSuccess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleUpdateSuccess) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *RuleUpdateSuccess) SetAction(v *RuleAction) *RuleUpdateSuccess {
	s.Action = v
	return s
}

// SetArn sets the Arn field's value.
func (s *RuleUpdateSuccess) SetArn(v string) *RuleUpdateSuccess {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *RuleUpdateSuccess) SetId(v string) *RuleUpdateSuccess {
	s.Id = &v
	return s
}

// SetIsDefault sets the IsDefault field's value.
func (s *RuleUpdateSuccess) SetIsDefault(v bool) *RuleUpdateSuccess {
	s.IsDefault = &v
	return s
}

// SetMatch sets the Match field's value.
func (s *RuleUpdateSuccess) SetMatch(v *RuleMatch) *RuleUpdateSuccess {
	s.Match = v
	return s
}

// SetName sets the Name field's value.
func (s *RuleUpdateSuccess) SetName(v string) *RuleUpdateSuccess {
	s.Name = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *RuleUpdateSuccess) SetPriority(v int64) *RuleUpdateSuccess {
	s.Priority = &v
	return s
}

// Summary information about the association between a service network and a
// service.
type ServiceNetworkServiceAssociationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the association.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The date and time that the association was created, specified in ISO-8601
	// format.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The account that created the association.
	CreatedBy *string `locationName:"createdBy" min:"1" type:"string"`

	// The custom domain name of the service.
	CustomDomainName *string `locationName:"customDomainName" min:"3" type:"string"`

	// The DNS information.
	DnsEntry *DnsEntry `locationName:"dnsEntry" type:"structure"`

	// The ID of the association.
	Id *string `locationName:"id" min:"17" type:"string"`

	// The Amazon Resource Name (ARN) of the service.
	ServiceArn *string `locationName:"serviceArn" min:"20" type:"string"`

	// The ID of the service.
	ServiceId *string `locationName:"serviceId" min:"21" type:"string"`

	// The name of the service.
	ServiceName *string `locationName:"serviceName" min:"3" type:"string"`

	// The Amazon Resource Name (ARN) of the service network.
	ServiceNetworkArn *string `locationName:"serviceNetworkArn" min:"32" type:"string"`

	// The ID of the service network.
	ServiceNetworkId *string `locationName:"serviceNetworkId" min:"32" type:"string"`

	// The name of the service network.
	ServiceNetworkName *string `locationName:"serviceNetworkName" min:"3" type:"string"`

	// The status. If the deletion fails, try to delete again.
	Status *string `locationName:"status" type:"string" enum:"ServiceNetworkServiceAssociationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceNetworkServiceAssociationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceNetworkServiceAssociationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ServiceNetworkServiceAssociationSummary) SetArn(v string) *ServiceNetworkServiceAssociationSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ServiceNetworkServiceAssociationSummary) SetCreatedAt(v time.Time) *ServiceNetworkServiceAssociationSummary {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *ServiceNetworkServiceAssociationSummary) SetCreatedBy(v string) *ServiceNetworkServiceAssociationSummary {
	s.CreatedBy = &v
	return s
}

// SetCustomDomainName sets the CustomDomainName field's value.
func (s *ServiceNetworkServiceAssociationSummary) SetCustomDomainName(v string) *ServiceNetworkServiceAssociationSummary {
	s.CustomDomainName = &v
	return s
}

// SetDnsEntry sets the DnsEntry field's value.
func (s *ServiceNetworkServiceAssociationSummary) SetDnsEntry(v *DnsEntry) *ServiceNetworkServiceAssociationSummary {
	s.DnsEntry = v
	return s
}

// SetId sets the Id field's value.
func (s *ServiceNetworkServiceAssociationSummary) SetId(v string) *ServiceNetworkServiceAssociationSummary {
	s.Id = &v
	return s
}

// SetServiceArn sets the ServiceArn field's value.
func (s *ServiceNetworkServiceAssociationSummary) SetServiceArn(v string) *ServiceNetworkServiceAssociationSummary {
	s.ServiceArn = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *ServiceNetworkServiceAssociationSummary) SetServiceId(v string) *ServiceNetworkServiceAssociationSummary {
	s.ServiceId = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ServiceNetworkServiceAssociationSummary) SetServiceName(v string) *ServiceNetworkServiceAssociationSummary {
	s.ServiceName = &v
	return s
}

// SetServiceNetworkArn sets the ServiceNetworkArn field's value.
func (s *ServiceNetworkServiceAssociationSummary) SetServiceNetworkArn(v string) *ServiceNetworkServiceAssociationSummary {
	s.ServiceNetworkArn = &v
	return s
}

// SetServiceNetworkId sets the ServiceNetworkId field's value.
func (s *ServiceNetworkServiceAssociationSummary) SetServiceNetworkId(v string) *ServiceNetworkServiceAssociationSummary {
	s.ServiceNetworkId = &v
	return s
}

// SetServiceNetworkName sets the ServiceNetworkName field's value.
func (s *ServiceNetworkServiceAssociationSummary) SetServiceNetworkName(v string) *ServiceNetworkServiceAssociationSummary {
	s.ServiceNetworkName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ServiceNetworkServiceAssociationSummary) SetStatus(v string) *ServiceNetworkServiceAssociationSummary {
	s.Status = &v
	return s
}

// Summary information about a service network.
type ServiceNetworkSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the service network.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The date and time that the service network was created, specified in ISO-8601
	// format.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The ID of the service network.
	Id *string `locationName:"id" min:"32" type:"string"`

	// The date and time that the service network was last updated, specified in
	// ISO-8601 format.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the service network.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The number of services associated with the service network.
	NumberOfAssociatedServices *int64 `locationName:"numberOfAssociatedServices" type:"long"`

	// The number of VPCs associated with the service network.
	NumberOfAssociatedVPCs *int64 `locationName:"numberOfAssociatedVPCs" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceNetworkSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceNetworkSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ServiceNetworkSummary) SetArn(v string) *ServiceNetworkSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ServiceNetworkSummary) SetCreatedAt(v time.Time) *ServiceNetworkSummary {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *ServiceNetworkSummary) SetId(v string) *ServiceNetworkSummary {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ServiceNetworkSummary) SetLastUpdatedAt(v time.Time) *ServiceNetworkSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *ServiceNetworkSummary) SetName(v string) *ServiceNetworkSummary {
	s.Name = &v
	return s
}

// SetNumberOfAssociatedServices sets the NumberOfAssociatedServices field's value.
func (s *ServiceNetworkSummary) SetNumberOfAssociatedServices(v int64) *ServiceNetworkSummary {
	s.NumberOfAssociatedServices = &v
	return s
}

// SetNumberOfAssociatedVPCs sets the NumberOfAssociatedVPCs field's value.
func (s *ServiceNetworkSummary) SetNumberOfAssociatedVPCs(v int64) *ServiceNetworkSummary {
	s.NumberOfAssociatedVPCs = &v
	return s
}

// Summary information about an association between a service network and a
// VPC.
type ServiceNetworkVpcAssociationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the association.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The date and time that the association was created, specified in ISO-8601
	// format.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The account that created the association.
	CreatedBy *string `locationName:"createdBy" min:"1" type:"string"`

	// The ID of the association.
	Id *string `locationName:"id" min:"22" type:"string"`

	// The date and time that the association was last updated, specified in ISO-8601
	// format.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon Resource Name (ARN) of the service network.
	ServiceNetworkArn *string `locationName:"serviceNetworkArn" min:"32" type:"string"`

	// The ID of the service network.
	ServiceNetworkId *string `locationName:"serviceNetworkId" min:"32" type:"string"`

	// The name of the service network.
	ServiceNetworkName *string `locationName:"serviceNetworkName" min:"3" type:"string"`

	// The status.
	Status *string `locationName:"status" type:"string" enum:"ServiceNetworkVpcAssociationStatus"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceNetworkVpcAssociationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceNetworkVpcAssociationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ServiceNetworkVpcAssociationSummary) SetArn(v string) *ServiceNetworkVpcAssociationSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ServiceNetworkVpcAssociationSummary) SetCreatedAt(v time.Time) *ServiceNetworkVpcAssociationSummary {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *ServiceNetworkVpcAssociationSummary) SetCreatedBy(v string) *ServiceNetworkVpcAssociationSummary {
	s.CreatedBy = &v
	return s
}

// SetId sets the Id field's value.
func (s *ServiceNetworkVpcAssociationSummary) SetId(v string) *ServiceNetworkVpcAssociationSummary {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ServiceNetworkVpcAssociationSummary) SetLastUpdatedAt(v time.Time) *ServiceNetworkVpcAssociationSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetServiceNetworkArn sets the ServiceNetworkArn field's value.
func (s *ServiceNetworkVpcAssociationSummary) SetServiceNetworkArn(v string) *ServiceNetworkVpcAssociationSummary {
	s.ServiceNetworkArn = &v
	return s
}

// SetServiceNetworkId sets the ServiceNetworkId field's value.
func (s *ServiceNetworkVpcAssociationSummary) SetServiceNetworkId(v string) *ServiceNetworkVpcAssociationSummary {
	s.ServiceNetworkId = &v
	return s
}

// SetServiceNetworkName sets the ServiceNetworkName field's value.
func (s *ServiceNetworkVpcAssociationSummary) SetServiceNetworkName(v string) *ServiceNetworkVpcAssociationSummary {
	s.ServiceNetworkName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ServiceNetworkVpcAssociationSummary) SetStatus(v string) *ServiceNetworkVpcAssociationSummary {
	s.Status = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *ServiceNetworkVpcAssociationSummary) SetVpcId(v string) *ServiceNetworkVpcAssociationSummary {
	s.VpcId = &v
	return s
}

// The request would cause a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the service quota that was exceeded.
	//
	// QuotaCode is a required field
	QuotaCode *string `locationName:"quotaCode" type:"string" required:"true"`

	// The resource ID.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The resource type.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`

	// The service code.
	//
	// ServiceCode is a required field
	ServiceCode *string `locationName:"serviceCode" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Summary information about a service.
type ServiceSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the service.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The date and time that the service was created, specified in ISO-8601 format.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The custom domain name of the service.
	CustomDomainName *string `locationName:"customDomainName" min:"3" type:"string"`

	// The DNS information.
	DnsEntry *DnsEntry `locationName:"dnsEntry" type:"structure"`

	// The ID of the service.
	Id *string `locationName:"id" min:"21" type:"string"`

	// The date and time that the service was last updated. The format is ISO-8601.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the service.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The status.
	Status *string `locationName:"status" type:"string" enum:"ServiceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ServiceSummary) SetArn(v string) *ServiceSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ServiceSummary) SetCreatedAt(v time.Time) *ServiceSummary {
	s.CreatedAt = &v
	return s
}

// SetCustomDomainName sets the CustomDomainName field's value.
func (s *ServiceSummary) SetCustomDomainName(v string) *ServiceSummary {
	s.CustomDomainName = &v
	return s
}

// SetDnsEntry sets the DnsEntry field's value.
func (s *ServiceSummary) SetDnsEntry(v *DnsEntry) *ServiceSummary {
	s.DnsEntry = v
	return s
}

// SetId sets the Id field's value.
func (s *ServiceSummary) SetId(v string) *ServiceSummary {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ServiceSummary) SetLastUpdatedAt(v time.Time) *ServiceSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *ServiceSummary) SetName(v string) *ServiceSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ServiceSummary) SetStatus(v string) *ServiceSummary {
	s.Status = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tags for the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Describes a target.
type Target struct {
	_ struct{} `type:"structure"`

	// The ID of the target. If the target group type is INSTANCE, this is an instance
	// ID. If the target group type is IP, this is an IP address. If the target
	// group type is LAMBDA, this is the ARN of a Lambda function. If the target
	// group type is ALB, this is the ARN of an Application Load Balancer.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The port on which the target is listening. For HTTP, the default is 80. For
	// HTTPS, the default is 443.
	Port *int64 `locationName:"port" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Target) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Target) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Target) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Target"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *Target) SetId(v string) *Target {
	s.Id = &v
	return s
}

// SetPort sets the Port field's value.
func (s *Target) SetPort(v int64) *Target {
	s.Port = &v
	return s
}

// Describes a target failure.
type TargetFailure struct {
	_ struct{} `type:"structure"`

	// The failure code.
	FailureCode *string `locationName:"failureCode" type:"string"`

	// The failure message.
	FailureMessage *string `locationName:"failureMessage" type:"string"`

	// The ID of the target. If the target group type is INSTANCE, this is an instance
	// ID. If the target group type is IP, this is an IP address. If the target
	// group type is LAMBDA, this is the ARN of a Lambda function. If the target
	// group type is ALB, this is the ARN of an Application Load Balancer.
	Id *string `locationName:"id" type:"string"`

	// The port on which the target is listening. This parameter doesn't apply if
	// the target is a Lambda function.
	Port *int64 `locationName:"port" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetFailure) GoString() string {
	return s.String()
}

// SetFailureCode sets the FailureCode field's value.
func (s *TargetFailure) SetFailureCode(v string) *TargetFailure {
	s.FailureCode = &v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *TargetFailure) SetFailureMessage(v string) *TargetFailure {
	s.FailureMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *TargetFailure) SetId(v string) *TargetFailure {
	s.Id = &v
	return s
}

// SetPort sets the Port field's value.
func (s *TargetFailure) SetPort(v int64) *TargetFailure {
	s.Port = &v
	return s
}

// Describes the configuration of a target group.
//
// For more information, see Target groups (https://docs.aws.amazon.com/vpc-lattice/latest/ug/target-groups.html)
// in the Amazon VPC Lattice User Guide.
type TargetGroupConfig struct {
	_ struct{} `type:"structure"`

	// The health check configuration. Not supported if the target group type is
	// LAMBDA or ALB.
	HealthCheck *HealthCheckConfig `locationName:"healthCheck" type:"structure"`

	// The type of IP address used for the target group. Supported only if the target
	// group type is IP. The default is IPV4.
	IpAddressType *string `locationName:"ipAddressType" type:"string" enum:"IpAddressType"`

	// The version of the event structure that your Lambda function receives. Supported
	// only if the target group type is LAMBDA. The default is V1.
	LambdaEventStructureVersion *string `locationName:"lambdaEventStructureVersion" type:"string" enum:"LambdaEventStructureVersion"`

	// The port on which the targets are listening. For HTTP, the default is 80.
	// For HTTPS, the default is 443. Not supported if the target group type is
	// LAMBDA.
	Port *int64 `locationName:"port" min:"1" type:"integer"`

	// The protocol to use for routing traffic to the targets. The default is the
	// protocol of the target group. Not supported if the target group type is LAMBDA.
	Protocol *string `locationName:"protocol" type:"string" enum:"TargetGroupProtocol"`

	// The protocol version. The default is HTTP1. Not supported if the target group
	// type is LAMBDA.
	ProtocolVersion *string `locationName:"protocolVersion" type:"string" enum:"TargetGroupProtocolVersion"`

	// The ID of the VPC. Not supported if the target group type is LAMBDA.
	VpcIdentifier *string `locationName:"vpcIdentifier" min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetGroupConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetGroupConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetGroupConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetGroupConfig"}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.VpcIdentifier != nil && len(*s.VpcIdentifier) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("VpcIdentifier", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHealthCheck sets the HealthCheck field's value.
func (s *TargetGroupConfig) SetHealthCheck(v *HealthCheckConfig) *TargetGroupConfig {
	s.HealthCheck = v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *TargetGroupConfig) SetIpAddressType(v string) *TargetGroupConfig {
	s.IpAddressType = &v
	return s
}

// SetLambdaEventStructureVersion sets the LambdaEventStructureVersion field's value.
func (s *TargetGroupConfig) SetLambdaEventStructureVersion(v string) *TargetGroupConfig {
	s.LambdaEventStructureVersion = &v
	return s
}

// SetPort sets the Port field's value.
func (s *TargetGroupConfig) SetPort(v int64) *TargetGroupConfig {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *TargetGroupConfig) SetProtocol(v string) *TargetGroupConfig {
	s.Protocol = &v
	return s
}

// SetProtocolVersion sets the ProtocolVersion field's value.
func (s *TargetGroupConfig) SetProtocolVersion(v string) *TargetGroupConfig {
	s.ProtocolVersion = &v
	return s
}

// SetVpcIdentifier sets the VpcIdentifier field's value.
func (s *TargetGroupConfig) SetVpcIdentifier(v string) *TargetGroupConfig {
	s.VpcIdentifier = &v
	return s
}

// Summary information about a target group.
//
// For more information, see Target groups (https://docs.aws.amazon.com/vpc-lattice/latest/ug/target-groups.html)
// in the Amazon VPC Lattice User Guide.
type TargetGroupSummary struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the target group.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The date and time that the target group was created, specified in ISO-8601
	// format.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The ID of the target group.
	Id *string `locationName:"id" min:"20" type:"string"`

	// The type of IP address used for the target group. The possible values are
	// IPV4 and IPV6. This is an optional parameter. If not specified, the default
	// is IPV4.
	IpAddressType *string `locationName:"ipAddressType" type:"string" enum:"IpAddressType"`

	// The version of the event structure that your Lambda function receives. Supported
	// only if the target group type is LAMBDA.
	LambdaEventStructureVersion *string `locationName:"lambdaEventStructureVersion" type:"string" enum:"LambdaEventStructureVersion"`

	// The date and time that the target group was last updated, specified in ISO-8601
	// format.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the target group.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The port of the target group.
	Port *int64 `locationName:"port" min:"1" type:"integer"`

	// The protocol of the target group.
	Protocol *string `locationName:"protocol" type:"string" enum:"TargetGroupProtocol"`

	// The Amazon Resource Names (ARNs) of the service.
	ServiceArns []*string `locationName:"serviceArns" type:"list"`

	// The status.
	Status *string `locationName:"status" type:"string" enum:"TargetGroupStatus"`

	// The target group type.
	Type *string `locationName:"type" type:"string" enum:"TargetGroupType"`

	// The ID of the VPC of the target group.
	VpcIdentifier *string `locationName:"vpcIdentifier" min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetGroupSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *TargetGroupSummary) SetArn(v string) *TargetGroupSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *TargetGroupSummary) SetCreatedAt(v time.Time) *TargetGroupSummary {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *TargetGroupSummary) SetId(v string) *TargetGroupSummary {
	s.Id = &v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *TargetGroupSummary) SetIpAddressType(v string) *TargetGroupSummary {
	s.IpAddressType = &v
	return s
}

// SetLambdaEventStructureVersion sets the LambdaEventStructureVersion field's value.
func (s *TargetGroupSummary) SetLambdaEventStructureVersion(v string) *TargetGroupSummary {
	s.LambdaEventStructureVersion = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *TargetGroupSummary) SetLastUpdatedAt(v time.Time) *TargetGroupSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *TargetGroupSummary) SetName(v string) *TargetGroupSummary {
	s.Name = &v
	return s
}

// SetPort sets the Port field's value.
func (s *TargetGroupSummary) SetPort(v int64) *TargetGroupSummary {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *TargetGroupSummary) SetProtocol(v string) *TargetGroupSummary {
	s.Protocol = &v
	return s
}

// SetServiceArns sets the ServiceArns field's value.
func (s *TargetGroupSummary) SetServiceArns(v []*string) *TargetGroupSummary {
	s.ServiceArns = v
	return s
}

// SetStatus sets the Status field's value.
func (s *TargetGroupSummary) SetStatus(v string) *TargetGroupSummary {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *TargetGroupSummary) SetType(v string) *TargetGroupSummary {
	s.Type = &v
	return s
}

// SetVpcIdentifier sets the VpcIdentifier field's value.
func (s *TargetGroupSummary) SetVpcIdentifier(v string) *TargetGroupSummary {
	s.VpcIdentifier = &v
	return s
}

// Summary information about a target.
type TargetSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the target. If the target group type is INSTANCE, this is an instance
	// ID. If the target group type is IP, this is an IP address. If the target
	// group type is LAMBDA, this is the ARN of a Lambda function. If the target
	// type is ALB, this is the ARN of an Application Load Balancer.
	Id *string `locationName:"id" type:"string"`

	// The port on which the target is listening.
	Port *int64 `locationName:"port" min:"1" type:"integer"`

	// The code for why the target status is what it is.
	ReasonCode *string `locationName:"reasonCode" type:"string"`

	// The status of the target.
	//
	//    * DRAINING: The target is being deregistered. No new connections are sent
	//    to this target while current connections are being drained. The default
	//    draining time is 5 minutes.
	//
	//    * UNAVAILABLE: Health checks are unavailable for the target group.
	//
	//    * HEALTHY: The target is healthy.
	//
	//    * UNHEALTHY: The target is unhealthy.
	//
	//    * INITIAL: Initial health checks on the target are being performed.
	//
	//    * UNUSED: Target group is not used in a service.
	Status *string `locationName:"status" type:"string" enum:"TargetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetSummary) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *TargetSummary) SetId(v string) *TargetSummary {
	s.Id = &v
	return s
}

// SetPort sets the Port field's value.
func (s *TargetSummary) SetPort(v int64) *TargetSummary {
	s.Port = &v
	return s
}

// SetReasonCode sets the ReasonCode field's value.
func (s *TargetSummary) SetReasonCode(v string) *TargetSummary {
	s.ReasonCode = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TargetSummary) SetStatus(v string) *TargetSummary {
	s.Status = &v
	return s
}

// The limit on the number of requests per second was exceeded.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the service quota that was exceeded.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// The number of seconds to wait before retrying.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// The service code.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tag keys of the tags to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAccessLogSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The ID or Amazon Resource Name (ARN) of the access log subscription.
	//
	// AccessLogSubscriptionIdentifier is a required field
	AccessLogSubscriptionIdentifier *string `location:"uri" locationName:"accessLogSubscriptionIdentifier" min:"17" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the access log destination.
	//
	// DestinationArn is a required field
	DestinationArn *string `locationName:"destinationArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessLogSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessLogSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAccessLogSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAccessLogSubscriptionInput"}
	if s.AccessLogSubscriptionIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessLogSubscriptionIdentifier"))
	}
	if s.AccessLogSubscriptionIdentifier != nil && len(*s.AccessLogSubscriptionIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("AccessLogSubscriptionIdentifier", 17))
	}
	if s.DestinationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationArn"))
	}
	if s.DestinationArn != nil && len(*s.DestinationArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessLogSubscriptionIdentifier sets the AccessLogSubscriptionIdentifier field's value.
func (s *UpdateAccessLogSubscriptionInput) SetAccessLogSubscriptionIdentifier(v string) *UpdateAccessLogSubscriptionInput {
	s.AccessLogSubscriptionIdentifier = &v
	return s
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *UpdateAccessLogSubscriptionInput) SetDestinationArn(v string) *UpdateAccessLogSubscriptionInput {
	s.DestinationArn = &v
	return s
}

type UpdateAccessLogSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the access log subscription.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the access log destination.
	//
	// DestinationArn is a required field
	DestinationArn *string `locationName:"destinationArn" min:"20" type:"string" required:"true"`

	// The ID of the access log subscription.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"21" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the access log subscription.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessLogSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessLogSubscriptionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateAccessLogSubscriptionOutput) SetArn(v string) *UpdateAccessLogSubscriptionOutput {
	s.Arn = &v
	return s
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *UpdateAccessLogSubscriptionOutput) SetDestinationArn(v string) *UpdateAccessLogSubscriptionOutput {
	s.DestinationArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateAccessLogSubscriptionOutput) SetId(v string) *UpdateAccessLogSubscriptionOutput {
	s.Id = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UpdateAccessLogSubscriptionOutput) SetResourceArn(v string) *UpdateAccessLogSubscriptionOutput {
	s.ResourceArn = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *UpdateAccessLogSubscriptionOutput) SetResourceId(v string) *UpdateAccessLogSubscriptionOutput {
	s.ResourceId = &v
	return s
}

type UpdateListenerInput struct {
	_ struct{} `type:"structure"`

	// The action for the default rule.
	//
	// DefaultAction is a required field
	DefaultAction *RuleAction `locationName:"defaultAction" type:"structure" required:"true"`

	// The ID or Amazon Resource Name (ARN) of the listener.
	//
	// ListenerIdentifier is a required field
	ListenerIdentifier *string `location:"uri" locationName:"listenerIdentifier" min:"20" type:"string" required:"true"`

	// The ID or Amazon Resource Name (ARN) of the service.
	//
	// ServiceIdentifier is a required field
	ServiceIdentifier *string `location:"uri" locationName:"serviceIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateListenerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateListenerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateListenerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateListenerInput"}
	if s.DefaultAction == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultAction"))
	}
	if s.ListenerIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerIdentifier"))
	}
	if s.ListenerIdentifier != nil && len(*s.ListenerIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ListenerIdentifier", 20))
	}
	if s.ServiceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceIdentifier"))
	}
	if s.ServiceIdentifier != nil && len(*s.ServiceIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceIdentifier", 17))
	}
	if s.DefaultAction != nil {
		if err := s.DefaultAction.Validate(); err != nil {
			invalidParams.AddNested("DefaultAction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *UpdateListenerInput) SetDefaultAction(v *RuleAction) *UpdateListenerInput {
	s.DefaultAction = v
	return s
}

// SetListenerIdentifier sets the ListenerIdentifier field's value.
func (s *UpdateListenerInput) SetListenerIdentifier(v string) *UpdateListenerInput {
	s.ListenerIdentifier = &v
	return s
}

// SetServiceIdentifier sets the ServiceIdentifier field's value.
func (s *UpdateListenerInput) SetServiceIdentifier(v string) *UpdateListenerInput {
	s.ServiceIdentifier = &v
	return s
}

type UpdateListenerOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the listener.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The action for the default rule.
	DefaultAction *RuleAction `locationName:"defaultAction" type:"structure"`

	// The ID of the listener.
	Id *string `locationName:"id" min:"26" type:"string"`

	// The name of the listener.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The listener port.
	Port *int64 `locationName:"port" min:"1" type:"integer"`

	// The protocol of the listener.
	Protocol *string `locationName:"protocol" type:"string" enum:"ListenerProtocol"`

	// The Amazon Resource Name (ARN) of the service.
	ServiceArn *string `locationName:"serviceArn" min:"20" type:"string"`

	// The ID of the service.
	ServiceId *string `locationName:"serviceId" min:"21" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateListenerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateListenerOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateListenerOutput) SetArn(v string) *UpdateListenerOutput {
	s.Arn = &v
	return s
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *UpdateListenerOutput) SetDefaultAction(v *RuleAction) *UpdateListenerOutput {
	s.DefaultAction = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateListenerOutput) SetId(v string) *UpdateListenerOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateListenerOutput) SetName(v string) *UpdateListenerOutput {
	s.Name = &v
	return s
}

// SetPort sets the Port field's value.
func (s *UpdateListenerOutput) SetPort(v int64) *UpdateListenerOutput {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *UpdateListenerOutput) SetProtocol(v string) *UpdateListenerOutput {
	s.Protocol = &v
	return s
}

// SetServiceArn sets the ServiceArn field's value.
func (s *UpdateListenerOutput) SetServiceArn(v string) *UpdateListenerOutput {
	s.ServiceArn = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *UpdateListenerOutput) SetServiceId(v string) *UpdateListenerOutput {
	s.ServiceId = &v
	return s
}

type UpdateRuleInput struct {
	_ struct{} `type:"structure"`

	// Information about the action for the specified listener rule.
	Action *RuleAction `locationName:"action" type:"structure"`

	// The ID or Amazon Resource Name (ARN) of the listener.
	//
	// ListenerIdentifier is a required field
	ListenerIdentifier *string `location:"uri" locationName:"listenerIdentifier" min:"20" type:"string" required:"true"`

	// The rule match.
	Match *RuleMatch `locationName:"match" type:"structure"`

	// The rule priority. A listener can't have multiple rules with the same priority.
	Priority *int64 `locationName:"priority" min:"1" type:"integer"`

	// The ID or Amazon Resource Name (ARN) of the rule.
	//
	// RuleIdentifier is a required field
	RuleIdentifier *string `location:"uri" locationName:"ruleIdentifier" min:"20" type:"string" required:"true"`

	// The ID or Amazon Resource Name (ARN) of the service.
	//
	// ServiceIdentifier is a required field
	ServiceIdentifier *string `location:"uri" locationName:"serviceIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRuleInput"}
	if s.ListenerIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerIdentifier"))
	}
	if s.ListenerIdentifier != nil && len(*s.ListenerIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ListenerIdentifier", 20))
	}
	if s.Priority != nil && *s.Priority < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Priority", 1))
	}
	if s.RuleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleIdentifier"))
	}
	if s.RuleIdentifier != nil && len(*s.RuleIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RuleIdentifier", 20))
	}
	if s.ServiceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceIdentifier"))
	}
	if s.ServiceIdentifier != nil && len(*s.ServiceIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceIdentifier", 17))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}
	if s.Match != nil {
		if err := s.Match.Validate(); err != nil {
			invalidParams.AddNested("Match", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *UpdateRuleInput) SetAction(v *RuleAction) *UpdateRuleInput {
	s.Action = v
	return s
}

// SetListenerIdentifier sets the ListenerIdentifier field's value.
func (s *UpdateRuleInput) SetListenerIdentifier(v string) *UpdateRuleInput {
	s.ListenerIdentifier = &v
	return s
}

// SetMatch sets the Match field's value.
func (s *UpdateRuleInput) SetMatch(v *RuleMatch) *UpdateRuleInput {
	s.Match = v
	return s
}

// SetPriority sets the Priority field's value.
func (s *UpdateRuleInput) SetPriority(v int64) *UpdateRuleInput {
	s.Priority = &v
	return s
}

// SetRuleIdentifier sets the RuleIdentifier field's value.
func (s *UpdateRuleInput) SetRuleIdentifier(v string) *UpdateRuleInput {
	s.RuleIdentifier = &v
	return s
}

// SetServiceIdentifier sets the ServiceIdentifier field's value.
func (s *UpdateRuleInput) SetServiceIdentifier(v string) *UpdateRuleInput {
	s.ServiceIdentifier = &v
	return s
}

type UpdateRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the action for the specified listener rule.
	Action *RuleAction `locationName:"action" type:"structure"`

	// The Amazon Resource Name (ARN) of the listener.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The ID of the listener.
	Id *string `locationName:"id" min:"5" type:"string"`

	// Indicates whether this is the default rule.
	IsDefault *bool `locationName:"isDefault" type:"boolean"`

	// The rule match.
	Match *RuleMatch `locationName:"match" type:"structure"`

	// The name of the listener.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The rule priority.
	Priority *int64 `locationName:"priority" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *UpdateRuleOutput) SetAction(v *RuleAction) *UpdateRuleOutput {
	s.Action = v
	return s
}

// SetArn sets the Arn field's value.
func (s *UpdateRuleOutput) SetArn(v string) *UpdateRuleOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateRuleOutput) SetId(v string) *UpdateRuleOutput {
	s.Id = &v
	return s
}

// SetIsDefault sets the IsDefault field's value.
func (s *UpdateRuleOutput) SetIsDefault(v bool) *UpdateRuleOutput {
	s.IsDefault = &v
	return s
}

// SetMatch sets the Match field's value.
func (s *UpdateRuleOutput) SetMatch(v *RuleMatch) *UpdateRuleOutput {
	s.Match = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateRuleOutput) SetName(v string) *UpdateRuleOutput {
	s.Name = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *UpdateRuleOutput) SetPriority(v int64) *UpdateRuleOutput {
	s.Priority = &v
	return s
}

type UpdateServiceInput struct {
	_ struct{} `type:"structure"`

	// The type of IAM policy.
	//
	//    * NONE: The resource does not use an IAM policy. This is the default.
	//
	//    * AWS_IAM: The resource uses an IAM policy. When this type is used, auth
	//    is enabled and an auth policy is required.
	AuthType *string `locationName:"authType" type:"string" enum:"AuthType"`

	// The Amazon Resource Name (ARN) of the certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID or Amazon Resource Name (ARN) of the service.
	//
	// ServiceIdentifier is a required field
	ServiceIdentifier *string `location:"uri" locationName:"serviceIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServiceInput"}
	if s.ServiceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceIdentifier"))
	}
	if s.ServiceIdentifier != nil && len(*s.ServiceIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthType sets the AuthType field's value.
func (s *UpdateServiceInput) SetAuthType(v string) *UpdateServiceInput {
	s.AuthType = &v
	return s
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *UpdateServiceInput) SetCertificateArn(v string) *UpdateServiceInput {
	s.CertificateArn = &v
	return s
}

// SetServiceIdentifier sets the ServiceIdentifier field's value.
func (s *UpdateServiceInput) SetServiceIdentifier(v string) *UpdateServiceInput {
	s.ServiceIdentifier = &v
	return s
}

type UpdateServiceNetworkInput struct {
	_ struct{} `type:"structure"`

	// The type of IAM policy.
	//
	//    * NONE: The resource does not use an IAM policy. This is the default.
	//
	//    * AWS_IAM: The resource uses an IAM policy. When this type is used, auth
	//    is enabled and an auth policy is required.
	//
	// AuthType is a required field
	AuthType *string `locationName:"authType" type:"string" required:"true" enum:"AuthType"`

	// The ID or Amazon Resource Name (ARN) of the service network.
	//
	// ServiceNetworkIdentifier is a required field
	ServiceNetworkIdentifier *string `location:"uri" locationName:"serviceNetworkIdentifier" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceNetworkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceNetworkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceNetworkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServiceNetworkInput"}
	if s.AuthType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthType"))
	}
	if s.ServiceNetworkIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNetworkIdentifier"))
	}
	if s.ServiceNetworkIdentifier != nil && len(*s.ServiceNetworkIdentifier) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceNetworkIdentifier", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthType sets the AuthType field's value.
func (s *UpdateServiceNetworkInput) SetAuthType(v string) *UpdateServiceNetworkInput {
	s.AuthType = &v
	return s
}

// SetServiceNetworkIdentifier sets the ServiceNetworkIdentifier field's value.
func (s *UpdateServiceNetworkInput) SetServiceNetworkIdentifier(v string) *UpdateServiceNetworkInput {
	s.ServiceNetworkIdentifier = &v
	return s
}

type UpdateServiceNetworkOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the service network.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The type of IAM policy.
	AuthType *string `locationName:"authType" type:"string" enum:"AuthType"`

	// The ID of the service network.
	Id *string `locationName:"id" min:"32" type:"string"`

	// The name of the service network.
	Name *string `locationName:"name" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceNetworkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceNetworkOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateServiceNetworkOutput) SetArn(v string) *UpdateServiceNetworkOutput {
	s.Arn = &v
	return s
}

// SetAuthType sets the AuthType field's value.
func (s *UpdateServiceNetworkOutput) SetAuthType(v string) *UpdateServiceNetworkOutput {
	s.AuthType = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateServiceNetworkOutput) SetId(v string) *UpdateServiceNetworkOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateServiceNetworkOutput) SetName(v string) *UpdateServiceNetworkOutput {
	s.Name = &v
	return s
}

type UpdateServiceNetworkVpcAssociationInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the security groups.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `locationName:"securityGroupIds" min:"1" type:"list" required:"true"`

	// The ID or Amazon Resource Name (ARN) of the association.
	//
	// ServiceNetworkVpcAssociationIdentifier is a required field
	ServiceNetworkVpcAssociationIdentifier *string `location:"uri" locationName:"serviceNetworkVpcAssociationIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceNetworkVpcAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceNetworkVpcAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceNetworkVpcAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServiceNetworkVpcAssociationInput"}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIds", 1))
	}
	if s.ServiceNetworkVpcAssociationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNetworkVpcAssociationIdentifier"))
	}
	if s.ServiceNetworkVpcAssociationIdentifier != nil && len(*s.ServiceNetworkVpcAssociationIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceNetworkVpcAssociationIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *UpdateServiceNetworkVpcAssociationInput) SetSecurityGroupIds(v []*string) *UpdateServiceNetworkVpcAssociationInput {
	s.SecurityGroupIds = v
	return s
}

// SetServiceNetworkVpcAssociationIdentifier sets the ServiceNetworkVpcAssociationIdentifier field's value.
func (s *UpdateServiceNetworkVpcAssociationInput) SetServiceNetworkVpcAssociationIdentifier(v string) *UpdateServiceNetworkVpcAssociationInput {
	s.ServiceNetworkVpcAssociationIdentifier = &v
	return s
}

type UpdateServiceNetworkVpcAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the association.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The account that created the association.
	CreatedBy *string `locationName:"createdBy" min:"1" type:"string"`

	// The ID of the association.
	Id *string `locationName:"id" min:"22" type:"string"`

	// The IDs of the security groups.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// The status. You can retry the operation if the status is DELETE_FAILED. However,
	// if you retry it while the status is DELETE_IN_PROGRESS, there is no change
	// in the status.
	Status *string `locationName:"status" type:"string" enum:"ServiceNetworkVpcAssociationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceNetworkVpcAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceNetworkVpcAssociationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateServiceNetworkVpcAssociationOutput) SetArn(v string) *UpdateServiceNetworkVpcAssociationOutput {
	s.Arn = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *UpdateServiceNetworkVpcAssociationOutput) SetCreatedBy(v string) *UpdateServiceNetworkVpcAssociationOutput {
	s.CreatedBy = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateServiceNetworkVpcAssociationOutput) SetId(v string) *UpdateServiceNetworkVpcAssociationOutput {
	s.Id = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *UpdateServiceNetworkVpcAssociationOutput) SetSecurityGroupIds(v []*string) *UpdateServiceNetworkVpcAssociationOutput {
	s.SecurityGroupIds = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateServiceNetworkVpcAssociationOutput) SetStatus(v string) *UpdateServiceNetworkVpcAssociationOutput {
	s.Status = &v
	return s
}

type UpdateServiceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the service.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The type of IAM policy.
	AuthType *string `locationName:"authType" type:"string" enum:"AuthType"`

	// The Amazon Resource Name (ARN) of the certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The custom domain name of the service.
	CustomDomainName *string `locationName:"customDomainName" min:"3" type:"string"`

	// The ID of the service.
	Id *string `locationName:"id" min:"21" type:"string"`

	// The name of the service.
	Name *string `locationName:"name" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateServiceOutput) SetArn(v string) *UpdateServiceOutput {
	s.Arn = &v
	return s
}

// SetAuthType sets the AuthType field's value.
func (s *UpdateServiceOutput) SetAuthType(v string) *UpdateServiceOutput {
	s.AuthType = &v
	return s
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *UpdateServiceOutput) SetCertificateArn(v string) *UpdateServiceOutput {
	s.CertificateArn = &v
	return s
}

// SetCustomDomainName sets the CustomDomainName field's value.
func (s *UpdateServiceOutput) SetCustomDomainName(v string) *UpdateServiceOutput {
	s.CustomDomainName = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateServiceOutput) SetId(v string) *UpdateServiceOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateServiceOutput) SetName(v string) *UpdateServiceOutput {
	s.Name = &v
	return s
}

type UpdateTargetGroupInput struct {
	_ struct{} `type:"structure"`

	// The health check configuration.
	//
	// HealthCheck is a required field
	HealthCheck *HealthCheckConfig `locationName:"healthCheck" type:"structure" required:"true"`

	// The ID or Amazon Resource Name (ARN) of the target group.
	//
	// TargetGroupIdentifier is a required field
	TargetGroupIdentifier *string `location:"uri" locationName:"targetGroupIdentifier" min:"17" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTargetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTargetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTargetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTargetGroupInput"}
	if s.HealthCheck == nil {
		invalidParams.Add(request.NewErrParamRequired("HealthCheck"))
	}
	if s.TargetGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetGroupIdentifier"))
	}
	if s.TargetGroupIdentifier != nil && len(*s.TargetGroupIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("TargetGroupIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHealthCheck sets the HealthCheck field's value.
func (s *UpdateTargetGroupInput) SetHealthCheck(v *HealthCheckConfig) *UpdateTargetGroupInput {
	s.HealthCheck = v
	return s
}

// SetTargetGroupIdentifier sets the TargetGroupIdentifier field's value.
func (s *UpdateTargetGroupInput) SetTargetGroupIdentifier(v string) *UpdateTargetGroupInput {
	s.TargetGroupIdentifier = &v
	return s
}

type UpdateTargetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target group.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The target group configuration.
	Config *TargetGroupConfig `locationName:"config" type:"structure"`

	// The ID of the target group.
	Id *string `locationName:"id" min:"20" type:"string"`

	// The name of the target group.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The status.
	Status *string `locationName:"status" type:"string" enum:"TargetGroupStatus"`

	// The target group type.
	Type *string `locationName:"type" type:"string" enum:"TargetGroupType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTargetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTargetGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateTargetGroupOutput) SetArn(v string) *UpdateTargetGroupOutput {
	s.Arn = &v
	return s
}

// SetConfig sets the Config field's value.
func (s *UpdateTargetGroupOutput) SetConfig(v *TargetGroupConfig) *UpdateTargetGroupOutput {
	s.Config = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateTargetGroupOutput) SetId(v string) *UpdateTargetGroupOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateTargetGroupOutput) SetName(v string) *UpdateTargetGroupOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateTargetGroupOutput) SetStatus(v string) *UpdateTargetGroupOutput {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateTargetGroupOutput) SetType(v string) *UpdateTargetGroupOutput {
	s.Type = &v
	return s
}

// The input does not satisfy the constraints specified by an Amazon Web Services
// service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The fields that failed validation.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// The reason.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a validation failure.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// Additional information about why the validation failed.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the validation exception.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// Describes the weight of a target group.
type WeightedTargetGroup struct {
	_ struct{} `type:"structure"`

	// The ID or Amazon Resource Name (ARN) of the target group.
	//
	// TargetGroupIdentifier is a required field
	TargetGroupIdentifier *string `locationName:"targetGroupIdentifier" min:"17" type:"string" required:"true"`

	// Only required if you specify multiple target groups for a forward action.
	// The weight determines how requests are distributed to the target group. For
	// example, if you specify two target groups, each with a weight of 10, each
	// target group receives half the requests. If you specify two target groups,
	// one with a weight of 10 and the other with a weight of 20, the target group
	// with a weight of 20 receives twice as many requests as the other target group.
	// If there's only one target group specified, then the default value is 100.
	Weight *int64 `locationName:"weight" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WeightedTargetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WeightedTargetGroup) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WeightedTargetGroup) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WeightedTargetGroup"}
	if s.TargetGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetGroupIdentifier"))
	}
	if s.TargetGroupIdentifier != nil && len(*s.TargetGroupIdentifier) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("TargetGroupIdentifier", 17))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetGroupIdentifier sets the TargetGroupIdentifier field's value.
func (s *WeightedTargetGroup) SetTargetGroupIdentifier(v string) *WeightedTargetGroup {
	s.TargetGroupIdentifier = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *WeightedTargetGroup) SetWeight(v int64) *WeightedTargetGroup {
	s.Weight = &v
	return s
}

const (
	// AuthPolicyStateActive is a AuthPolicyState enum value
	AuthPolicyStateActive = "Active"

	// AuthPolicyStateInactive is a AuthPolicyState enum value
	AuthPolicyStateInactive = "Inactive"
)

// AuthPolicyState_Values returns all elements of the AuthPolicyState enum
func AuthPolicyState_Values() []string {
	return []string{
		AuthPolicyStateActive,
		AuthPolicyStateInactive,
	}
}

const (
	// AuthTypeNone is a AuthType enum value
	AuthTypeNone = "NONE"

	// AuthTypeAwsIam is a AuthType enum value
	AuthTypeAwsIam = "AWS_IAM"
)

// AuthType_Values returns all elements of the AuthType enum
func AuthType_Values() []string {
	return []string{
		AuthTypeNone,
		AuthTypeAwsIam,
	}
}

const (
	// HealthCheckProtocolVersionHttp1 is a HealthCheckProtocolVersion enum value
	HealthCheckProtocolVersionHttp1 = "HTTP1"

	// HealthCheckProtocolVersionHttp2 is a HealthCheckProtocolVersion enum value
	HealthCheckProtocolVersionHttp2 = "HTTP2"
)

// HealthCheckProtocolVersion_Values returns all elements of the HealthCheckProtocolVersion enum
func HealthCheckProtocolVersion_Values() []string {
	return []string{
		HealthCheckProtocolVersionHttp1,
		HealthCheckProtocolVersionHttp2,
	}
}

const (
	// IpAddressTypeIpv4 is a IpAddressType enum value
	IpAddressTypeIpv4 = "IPV4"

	// IpAddressTypeIpv6 is a IpAddressType enum value
	IpAddressTypeIpv6 = "IPV6"
)

// IpAddressType_Values returns all elements of the IpAddressType enum
func IpAddressType_Values() []string {
	return []string{
		IpAddressTypeIpv4,
		IpAddressTypeIpv6,
	}
}

const (
	// LambdaEventStructureVersionV1 is a LambdaEventStructureVersion enum value
	LambdaEventStructureVersionV1 = "V1"

	// LambdaEventStructureVersionV2 is a LambdaEventStructureVersion enum value
	LambdaEventStructureVersionV2 = "V2"
)

// LambdaEventStructureVersion_Values returns all elements of the LambdaEventStructureVersion enum
func LambdaEventStructureVersion_Values() []string {
	return []string{
		LambdaEventStructureVersionV1,
		LambdaEventStructureVersionV2,
	}
}

const (
	// ListenerProtocolHttp is a ListenerProtocol enum value
	ListenerProtocolHttp = "HTTP"

	// ListenerProtocolHttps is a ListenerProtocol enum value
	ListenerProtocolHttps = "HTTPS"

	// ListenerProtocolTlsPassthrough is a ListenerProtocol enum value
	ListenerProtocolTlsPassthrough = "TLS_PASSTHROUGH"
)

// ListenerProtocol_Values returns all elements of the ListenerProtocol enum
func ListenerProtocol_Values() []string {
	return []string{
		ListenerProtocolHttp,
		ListenerProtocolHttps,
		ListenerProtocolTlsPassthrough,
	}
}

const (
	// ServiceNetworkServiceAssociationStatusCreateInProgress is a ServiceNetworkServiceAssociationStatus enum value
	ServiceNetworkServiceAssociationStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// ServiceNetworkServiceAssociationStatusActive is a ServiceNetworkServiceAssociationStatus enum value
	ServiceNetworkServiceAssociationStatusActive = "ACTIVE"

	// ServiceNetworkServiceAssociationStatusDeleteInProgress is a ServiceNetworkServiceAssociationStatus enum value
	ServiceNetworkServiceAssociationStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// ServiceNetworkServiceAssociationStatusCreateFailed is a ServiceNetworkServiceAssociationStatus enum value
	ServiceNetworkServiceAssociationStatusCreateFailed = "CREATE_FAILED"

	// ServiceNetworkServiceAssociationStatusDeleteFailed is a ServiceNetworkServiceAssociationStatus enum value
	ServiceNetworkServiceAssociationStatusDeleteFailed = "DELETE_FAILED"
)

// ServiceNetworkServiceAssociationStatus_Values returns all elements of the ServiceNetworkServiceAssociationStatus enum
func ServiceNetworkServiceAssociationStatus_Values() []string {
	return []string{
		ServiceNetworkServiceAssociationStatusCreateInProgress,
		ServiceNetworkServiceAssociationStatusActive,
		ServiceNetworkServiceAssociationStatusDeleteInProgress,
		ServiceNetworkServiceAssociationStatusCreateFailed,
		ServiceNetworkServiceAssociationStatusDeleteFailed,
	}
}

const (
	// ServiceNetworkVpcAssociationStatusCreateInProgress is a ServiceNetworkVpcAssociationStatus enum value
	ServiceNetworkVpcAssociationStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// ServiceNetworkVpcAssociationStatusActive is a ServiceNetworkVpcAssociationStatus enum value
	ServiceNetworkVpcAssociationStatusActive = "ACTIVE"

	// ServiceNetworkVpcAssociationStatusUpdateInProgress is a ServiceNetworkVpcAssociationStatus enum value
	ServiceNetworkVpcAssociationStatusUpdateInProgress = "UPDATE_IN_PROGRESS"

	// ServiceNetworkVpcAssociationStatusDeleteInProgress is a ServiceNetworkVpcAssociationStatus enum value
	ServiceNetworkVpcAssociationStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// ServiceNetworkVpcAssociationStatusCreateFailed is a ServiceNetworkVpcAssociationStatus enum value
	ServiceNetworkVpcAssociationStatusCreateFailed = "CREATE_FAILED"

	// ServiceNetworkVpcAssociationStatusDeleteFailed is a ServiceNetworkVpcAssociationStatus enum value
	ServiceNetworkVpcAssociationStatusDeleteFailed = "DELETE_FAILED"

	// ServiceNetworkVpcAssociationStatusUpdateFailed is a ServiceNetworkVpcAssociationStatus enum value
	ServiceNetworkVpcAssociationStatusUpdateFailed = "UPDATE_FAILED"
)

// ServiceNetworkVpcAssociationStatus_Values returns all elements of the ServiceNetworkVpcAssociationStatus enum
func ServiceNetworkVpcAssociationStatus_Values() []string {
	return []string{
		ServiceNetworkVpcAssociationStatusCreateInProgress,
		ServiceNetworkVpcAssociationStatusActive,
		ServiceNetworkVpcAssociationStatusUpdateInProgress,
		ServiceNetworkVpcAssociationStatusDeleteInProgress,
		ServiceNetworkVpcAssociationStatusCreateFailed,
		ServiceNetworkVpcAssociationStatusDeleteFailed,
		ServiceNetworkVpcAssociationStatusUpdateFailed,
	}
}

const (
	// ServiceStatusActive is a ServiceStatus enum value
	ServiceStatusActive = "ACTIVE"

	// ServiceStatusCreateInProgress is a ServiceStatus enum value
	ServiceStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// ServiceStatusDeleteInProgress is a ServiceStatus enum value
	ServiceStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// ServiceStatusCreateFailed is a ServiceStatus enum value
	ServiceStatusCreateFailed = "CREATE_FAILED"

	// ServiceStatusDeleteFailed is a ServiceStatus enum value
	ServiceStatusDeleteFailed = "DELETE_FAILED"
)

// ServiceStatus_Values returns all elements of the ServiceStatus enum
func ServiceStatus_Values() []string {
	return []string{
		ServiceStatusActive,
		ServiceStatusCreateInProgress,
		ServiceStatusDeleteInProgress,
		ServiceStatusCreateFailed,
		ServiceStatusDeleteFailed,
	}
}

const (
	// TargetGroupProtocolHttp is a TargetGroupProtocol enum value
	TargetGroupProtocolHttp = "HTTP"

	// TargetGroupProtocolHttps is a TargetGroupProtocol enum value
	TargetGroupProtocolHttps = "HTTPS"

	// TargetGroupProtocolTcp is a TargetGroupProtocol enum value
	TargetGroupProtocolTcp = "TCP"
)

// TargetGroupProtocol_Values returns all elements of the TargetGroupProtocol enum
func TargetGroupProtocol_Values() []string {
	return []string{
		TargetGroupProtocolHttp,
		TargetGroupProtocolHttps,
		TargetGroupProtocolTcp,
	}
}

const (
	// TargetGroupProtocolVersionHttp1 is a TargetGroupProtocolVersion enum value
	TargetGroupProtocolVersionHttp1 = "HTTP1"

	// TargetGroupProtocolVersionHttp2 is a TargetGroupProtocolVersion enum value
	TargetGroupProtocolVersionHttp2 = "HTTP2"

	// TargetGroupProtocolVersionGrpc is a TargetGroupProtocolVersion enum value
	TargetGroupProtocolVersionGrpc = "GRPC"
)

// TargetGroupProtocolVersion_Values returns all elements of the TargetGroupProtocolVersion enum
func TargetGroupProtocolVersion_Values() []string {
	return []string{
		TargetGroupProtocolVersionHttp1,
		TargetGroupProtocolVersionHttp2,
		TargetGroupProtocolVersionGrpc,
	}
}

const (
	// TargetGroupStatusCreateInProgress is a TargetGroupStatus enum value
	TargetGroupStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// TargetGroupStatusActive is a TargetGroupStatus enum value
	TargetGroupStatusActive = "ACTIVE"

	// TargetGroupStatusDeleteInProgress is a TargetGroupStatus enum value
	TargetGroupStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// TargetGroupStatusCreateFailed is a TargetGroupStatus enum value
	TargetGroupStatusCreateFailed = "CREATE_FAILED"

	// TargetGroupStatusDeleteFailed is a TargetGroupStatus enum value
	TargetGroupStatusDeleteFailed = "DELETE_FAILED"
)

// TargetGroupStatus_Values returns all elements of the TargetGroupStatus enum
func TargetGroupStatus_Values() []string {
	return []string{
		TargetGroupStatusCreateInProgress,
		TargetGroupStatusActive,
		TargetGroupStatusDeleteInProgress,
		TargetGroupStatusCreateFailed,
		TargetGroupStatusDeleteFailed,
	}
}

const (
	// TargetGroupTypeIp is a TargetGroupType enum value
	TargetGroupTypeIp = "IP"

	// TargetGroupTypeLambda is a TargetGroupType enum value
	TargetGroupTypeLambda = "LAMBDA"

	// TargetGroupTypeInstance is a TargetGroupType enum value
	TargetGroupTypeInstance = "INSTANCE"

	// TargetGroupTypeAlb is a TargetGroupType enum value
	TargetGroupTypeAlb = "ALB"
)

// TargetGroupType_Values returns all elements of the TargetGroupType enum
func TargetGroupType_Values() []string {
	return []string{
		TargetGroupTypeIp,
		TargetGroupTypeLambda,
		TargetGroupTypeInstance,
		TargetGroupTypeAlb,
	}
}

const (
	// TargetStatusDraining is a TargetStatus enum value
	TargetStatusDraining = "DRAINING"

	// TargetStatusUnavailable is a TargetStatus enum value
	TargetStatusUnavailable = "UNAVAILABLE"

	// TargetStatusHealthy is a TargetStatus enum value
	TargetStatusHealthy = "HEALTHY"

	// TargetStatusUnhealthy is a TargetStatus enum value
	TargetStatusUnhealthy = "UNHEALTHY"

	// TargetStatusInitial is a TargetStatus enum value
	TargetStatusInitial = "INITIAL"

	// TargetStatusUnused is a TargetStatus enum value
	TargetStatusUnused = "UNUSED"
)

// TargetStatus_Values returns all elements of the TargetStatus enum
func TargetStatus_Values() []string {
	return []string{
		TargetStatusDraining,
		TargetStatusUnavailable,
		TargetStatusHealthy,
		TargetStatusUnhealthy,
		TargetStatusInitial,
		TargetStatusUnused,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
