use crate::any::{Any, AnyTypeInfo};
use crate::column::Column;
use crate::ext::ustr::UStr;

#[derive(Debug, Clone)]
pub struct AnyColumn {
    // NOTE: these fields are semver-exempt. See crate root docs for details.
    #[doc(hidden)]
    pub ordinal: usize,

    #[doc(hidden)]
    pub name: UStr,

    #[doc(hidden)]
    pub type_info: AnyTypeInfo,
}
impl Column for AnyColumn {
    type Database = Any;

    fn ordinal(&self) -> usize {
        self.ordinal
    }

    fn name(&self) -> &str {
        &self.name
    }

    fn type_info(&self) -> &AnyTypeInfo {
        &self.type_info
    }
}
