/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;

public class BendpointConnectionRouter
extends AbstractRouter {
    private final Map<Connection, List<Bendpoint>> constraints = new HashMap<Connection, List<Bendpoint>>(11);
    private static final PrecisionPoint A_POINT = new PrecisionPoint();

    @Override
    public List<Bendpoint> getConstraint(Connection connection) {
        return this.constraints.get(connection);
    }

    @Override
    public void remove(Connection connection) {
        this.constraints.remove(connection);
    }

    @Override
    public void route(Connection conn) {
        Point ref2;
        Point ref1;
        PointList points = conn.getPoints();
        points.removeAllPoints();
        List<Bendpoint> bendpoints = this.getConstraint(conn);
        if (bendpoints == null) {
            bendpoints = Collections.emptyList();
        }
        if (bendpoints.isEmpty()) {
            ref1 = conn.getTargetAnchor().getReferencePoint();
            ref2 = conn.getSourceAnchor().getReferencePoint();
        } else {
            ref1 = new Point(((Bendpoint)bendpoints.get(0)).getLocation());
            conn.translateToAbsolute(ref1);
            ref2 = new Point(((Bendpoint)bendpoints.get(bendpoints.size() - 1)).getLocation());
            conn.translateToAbsolute(ref2);
        }
        A_POINT.setLocation(conn.getSourceAnchor().getLocation(ref1));
        conn.translateToRelative(A_POINT);
        points.addPoint(A_POINT);
        bendpoints.forEach(bp -> points.addPoint(bp.getLocation()));
        A_POINT.setLocation(conn.getTargetAnchor().getLocation(ref2));
        conn.translateToRelative(A_POINT);
        points.addPoint(A_POINT);
        conn.setPoints(points);
    }

    @Override
    public void setConstraint(Connection connection, Object constraint) {
        this.constraints.put(connection, (List)constraint);
    }
}

