-passes_previously_accepted =
    this was previously accepted by the compiler but is being phased out; it will become a hard error in a future release!

-passes_see_issue =
    see issue #{$issue} <https://github.com/rust-lang/rust/issues/{$issue}> for more information

passes_abi_invalid_attribute =
    `#[rustc_abi]` can only be applied to function items, type aliases, and associated functions
passes_abi_ne =
    ABIs are not compatible
    left ABI = {$left}
    right ABI = {$right}
passes_abi_of =
    fn_abi_of({$fn_name}) = {$fn_abi}

passes_attr_application_enum =
    attribute should be applied to an enum
    .label = not an enum

passes_attr_application_struct =
    attribute should be applied to a struct
    .label = not a struct

passes_attr_application_struct_enum_union =
    attribute should be applied to a struct, enum, or union
    .label = not a struct, enum, or union

passes_attr_application_struct_union =
    attribute should be applied to a struct or union
    .label = not a struct or union

passes_autodiff_attr =
    `#[autodiff]` should be applied to a function
    .label = not a function

passes_both_ffi_const_and_pure =
    `#[ffi_const]` function cannot be `#[ffi_pure]`

passes_cannot_stabilize_deprecated =
    an API can't be stabilized after it is deprecated
    .label = invalid version
    .item = the stability attribute annotates this item

passes_change_fields_to_be_of_unit_type =
    consider changing the { $num ->
      [one] field
     *[other] fields
    } to be of unit type to suppress this warning while preserving the field numbering, or remove the { $num ->
      [one] field
     *[other] fields
    }

passes_const_continue_attr =
    `#[const_continue]` should be applied to a break expression
    .label = not a break expression

passes_const_stable_not_stable =
    attribute `#[rustc_const_stable]` can only be applied to functions that are declared `#[stable]`
    .label = attribute specified here

passes_custom_mir_incompatible_dialect_and_phase =
    the {$dialect} dialect is not compatible with the {$phase} phase
    .dialect_span = this dialect...
    .phase_span = ... is not compatible with this phase

passes_custom_mir_phase_requires_dialect =
    `dialect` key required
    .phase_span = `phase` argument requires a `dialect` argument


passes_dead_codes =
    { $multiple ->
      *[true] multiple {$descr}s are
       [false] { $num ->
         [one] {$descr} {$name_list} is
        *[other] {$descr}s {$name_list} are
       }
    } never {$participle}

passes_debug_visualizer_unreadable =
    couldn't read {$file}: {$error}

passes_deprecated_annotation_has_no_effect =
    this `#[deprecated]` annotation has no effect
    .suggestion = remove the unnecessary deprecation attribute

passes_deprecated_attribute =
    deprecated attribute must be paired with either stable or unstable attribute

passes_diagnostic_diagnostic_on_const_only_for_trait_impls =
    `#[diagnostic::on_const]` can only be applied to trait impls
    .label = not a trait impl

passes_diagnostic_diagnostic_on_unimplemented_only_for_traits =
    `#[diagnostic::on_unimplemented]` can only be applied to trait definitions

passes_diagnostic_item_first_defined =
    the diagnostic item is first defined here

passes_doc_alias_bad_location =
    `#[doc(alias = "...")]` isn't allowed on {$location}

passes_doc_alias_not_an_alias =
    `#[doc(alias = "{$attr_str}"]` is the same as the item's name

passes_doc_fake_variadic_not_valid =
    `#[doc(fake_variadic)]` must be used on the first of a set of tuple or fn pointer trait impls with varying arity

passes_doc_inline_conflict =
    conflicting doc inlining attributes
    .help = remove one of the conflicting attributes

passes_doc_inline_conflict_first =
    this attribute...

passes_doc_inline_conflict_second =
    {"."}..conflicts with this attribute

passes_doc_inline_only_use =
    this attribute can only be applied to a `use` item
    .label = only applicable on `use` items
    .not_a_use_item_label = not a `use` item
    .note = read <https://doc.rust-lang.org/nightly/rustdoc/the-doc-attribute.html#inline-and-no_inline> for more information

passes_doc_keyword_attribute_empty_mod =
    `#[doc({$attr_name} = "...")]` should be used on empty modules

passes_doc_keyword_attribute_not_mod =
    `#[doc({$attr_name} = "...")]` should be used on modules

passes_doc_keyword_only_impl =
    `#[doc(keyword = "...")]` should be used on impl blocks

passes_doc_masked_not_extern_crate_self =
    this attribute cannot be applied to an `extern crate self` item
    .label = not applicable on `extern crate self` items
    .extern_crate_self_label = `extern crate self` defined here

passes_doc_masked_only_extern_crate =
    this attribute can only be applied to an `extern crate` item
    .label = only applicable on `extern crate` items
    .not_an_extern_crate_label = not an `extern crate` item
    .note = read <https://doc.rust-lang.org/unstable-book/language-features/doc-masked.html> for more information

passes_doc_rust_logo =
    the `#[doc(rust_logo)]` attribute is used for Rust branding

passes_doc_search_unbox_invalid =
    `#[doc(search_unbox)]` should be used on generic structs and enums

passes_duplicate_diagnostic_item_in_crate =
    duplicate diagnostic item in crate `{$crate_name}`: `{$name}`
    .note = the diagnostic item is first defined in crate `{$orig_crate_name}`

passes_duplicate_eii_impls =
    multiple implementations of `#[{$name}]`
    .first = first implemented here in crate `{$first_crate}`
    .second = also implemented here in crate `{$second_crate}`
    .note = in addition to these two, { $num_additional_crates ->
         [one] another implementation was found in crate {$additional_crate_names}
         *[other] more implementations were also found in the following crates: {$additional_crate_names}
    }

    .help = an "externally implementable item" can only have a single implementation in the final artifact. When multiple implementations are found, also in different crates, they conflict

passes_duplicate_feature_err =
    the feature `{$feature}` has already been enabled

passes_duplicate_lang_item =
    found duplicate lang item `{$lang_item_name}`
    .first_defined_span = the lang item is first defined here
    .first_defined_crate_depends = the lang item is first defined in crate `{$orig_crate_name}` (which `{$orig_dependency_of}` depends on)
    .first_defined_crate = the lang item is first defined in crate `{$orig_crate_name}`
    .first_definition_local = first definition in the local crate (`{$orig_crate_name}`)
    .second_definition_local = second definition in the local crate (`{$crate_name}`)
    .first_definition_path = first definition in `{$orig_crate_name}` loaded from {$orig_path}
    .second_definition_path = second definition in `{$crate_name}` loaded from {$path}

passes_duplicate_lang_item_crate =
    duplicate lang item in crate `{$crate_name}`: `{$lang_item_name}`
    .first_defined_span = the lang item is first defined here
    .first_defined_crate_depends = the lang item is first defined in crate `{$orig_crate_name}` (which `{$orig_dependency_of}` depends on)
    .first_defined_crate = the lang item is first defined in crate `{$orig_crate_name}`
    .first_definition_local = first definition in the local crate (`{$orig_crate_name}`)
    .second_definition_local = second definition in the local crate (`{$crate_name}`)
    .first_definition_path = first definition in `{$orig_crate_name}` loaded from {$orig_path}
    .second_definition_path = second definition in `{$crate_name}` loaded from {$path}

passes_duplicate_lang_item_crate_depends =
    duplicate lang item in crate `{$crate_name}` (which `{$dependency_of}` depends on): `{$lang_item_name}`
    .first_defined_span = the lang item is first defined here
    .first_defined_crate_depends = the lang item is first defined in crate `{$orig_crate_name}` (which `{$orig_dependency_of}` depends on)
    .first_defined_crate = the lang item is first defined in crate `{$orig_crate_name}`
    .first_definition_local = first definition in the local crate (`{$orig_crate_name}`)
    .second_definition_local = second definition in the local crate (`{$crate_name}`)
    .first_definition_path = first definition in `{$orig_crate_name}` loaded from {$orig_path}
    .second_definition_path = second definition in `{$crate_name}` loaded from {$path}

passes_eii_fn_with_track_caller =
    `#[{$name}]` is not allowed to have `#[track_caller]`
    .label = `#[{$name}]` is not allowed to have `#[track_caller]`

passes_eii_impl_not_function =
    `eii_macro_for` is only valid on functions

passes_eii_impl_requires_unsafe =
    `#[{$name}]` is unsafe to implement
passes_eii_impl_requires_unsafe_suggestion = wrap the attribute in `unsafe(...)`

passes_eii_without_impl =
    `#[{$name}]` required, but not found
    .label = expected because `#[{$name}]` was declared here in crate `{$decl_crate_name}`
    .help = expected at least one implementation in crate `{$current_crate_name}` or any of its dependencies

passes_enum_variant_same_name =
    it is impossible to refer to the {$dead_descr} `{$dead_name}` because it is shadowed by this enum variant with the same name

passes_extern_main =
    the `main` function cannot be declared in an `extern` block

passes_feature_previously_declared =
    feature `{$feature}` is declared {$declared}, but was previously declared {$prev_declared}

passes_feature_stable_twice =
    feature `{$feature}` is declared stable since {$since}, but was previously declared stable since {$prev_since}

passes_function_not_found_in_trait = function not found in this trait

passes_function_not_have_default_implementation = function doesn't have a default implementation
    .note = required by this annotation

passes_functions_names_duplicated = functions names are duplicated
    .note = all `#[rustc_must_implement_one_of]` arguments must be unique

passes_ignored_derived_impls =
    `{$name}` has {$trait_list_len ->
      [one] a derived impl
     *[other] derived impls
    } for the {$trait_list_len ->
      [one] trait {$trait_list}, but this is
     *[other] traits {$trait_list}, but these are
    } intentionally ignored during dead code analysis

passes_implied_feature_not_exist =
    feature `{$implied_by}` implying `{$feature}` does not exist

passes_incorrect_crate_type = lang items are not allowed in stable dylibs

passes_incorrect_do_not_recommend_location =
    `#[diagnostic::do_not_recommend]` can only be placed on trait implementations

passes_incorrect_target =
    `{$name}` lang item must be applied to a {$kind} with {$at_least ->
        [true] at least {$num}
        *[false] {$num}
    } generic {$num ->
        [one] argument
        *[other] arguments
    }
    .label = this {$kind} has {$actual_num} generic {$actual_num ->
        [one] argument
        *[other] arguments
    }

passes_ineffective_unstable_impl = an `#[unstable]` annotation here has no effect
    .note = see issue #55436 <https://github.com/rust-lang/rust/issues/55436> for more information

passes_inline_ignored_for_exported =
    `#[inline]` is ignored on externally exported functions
    .help = externally exported functions are functions with `#[no_mangle]`, `#[export_name]`, or `#[linkage]`

passes_inner_crate_level_attr =
    crate-level attribute should be in the root module

passes_invalid_attr_at_crate_level =
    `{$name}` attribute cannot be used at crate level
    .suggestion = perhaps you meant to use an outer attribute

passes_invalid_attr_at_crate_level_item =
    the inner attribute doesn't annotate this {$kind}

passes_lang_item_fn = {$name ->
    [panic_impl] `#[panic_handler]`
    *[other] `{$name}` lang item
} function

passes_lang_item_fn_with_target_feature =
    {passes_lang_item_fn} is not allowed to have `#[target_feature]`
    .label = {passes_lang_item_fn} is not allowed to have `#[target_feature]`

passes_lang_item_fn_with_track_caller =
    {passes_lang_item_fn} is not allowed to have `#[track_caller]`
    .label = {passes_lang_item_fn} is not allowed to have `#[track_caller]`

passes_lang_item_on_incorrect_target =
    `{$name}` lang item must be applied to a {$expected_target}
    .label = attribute should be applied to a {$expected_target}, not a {$actual_target}

passes_layout_abi =
    abi: {$abi}
passes_layout_align =
    align: {$align}
passes_layout_homogeneous_aggregate =
    homogeneous_aggregate: {$homogeneous_aggregate}
passes_layout_invalid_attribute =
    `#[rustc_layout]` can only be applied to `struct`/`enum`/`union` declarations and type aliases
passes_layout_of =
    layout_of({$normalized_ty}) = {$ty_layout}
passes_layout_size =
    size: {$size}

passes_link =
    attribute should be applied to an `extern` block with non-Rust ABI
    .warn = {-passes_previously_accepted}
    .label = not an `extern` block

passes_loop_match_attr =
    `#[loop_match]` should be applied to a loop
    .label = not a loop

passes_macro_export_on_decl_macro =
    `#[macro_export]` has no effect on declarative macro definitions
    .note = declarative macros follow the same exporting rules as regular items

passes_macro_only_attribute =
    attribute should be applied to a macro
    .label = not a macro

passes_may_dangle =
    `#[may_dangle]` must be applied to a lifetime or type generic parameter in `Drop` impl

passes_missing_const_err =
    attributes `#[rustc_const_unstable]`, `#[rustc_const_stable]` and `#[rustc_const_stable_indirect]` require the function or method to be `const`
    .help = make the function or method const

passes_missing_const_stab_attr =
    {$descr} has missing const stability attribute

passes_missing_lang_item =
    lang item required, but not found: `{$name}`
    .note = this can occur when a binary crate with `#![no_std]` is compiled for a target where `{$name}` is defined in the standard library
    .help = you may be able to compile for a target that doesn't need `{$name}`, specify a target with `--target` or in `.cargo/config`

passes_missing_panic_handler =
    `#[panic_handler]` function required, but not found

passes_missing_stability_attr =
    {$descr} has missing stability attribute

passes_misspelled_feature = there is a feature with a similar name: `{$actual_name}`

passes_mixed_export_name_and_no_mangle = `{$no_mangle_attr}` attribute may not be used in combination with `{$export_name_attr}`
    .label = `{$no_mangle_attr}` is ignored
    .note = `{$export_name_attr}` takes precedence
    .suggestion = remove the `{$no_mangle_attr}` attribute

passes_multiple_rustc_main =
    multiple functions with a `#[rustc_main]` attribute
    .first = first `#[rustc_main]` function
    .additional = additional `#[rustc_main]` function

passes_must_implement_not_function = not a function

passes_must_implement_not_function_note = all `#[rustc_must_implement_one_of]` arguments must be associated function names

passes_must_implement_not_function_span_note = required by this annotation

passes_no_main_function =
    `main` function not found in crate `{$crate_name}`
    .here_is_main = here is a function named `main`
    .one_or_more_possible_main = you have one or more functions named `main` not defined at the crate level
    .consider_moving_main = consider moving the `main` function definitions
    .main_must_be_defined_at_crate = the main function must be defined at the crate level{$has_filename ->
        [true] {" "}(in `{$filename}`)
        *[false] {""}
    }
    .consider_adding_main_to_file = consider adding a `main` function to `{$filename}`
    .consider_adding_main_at_crate = consider adding a `main` function at the crate level
    .teach_note = if you don't know the basics of Rust, you can go look to the Rust Book to get started: https://doc.rust-lang.org/book/
    .non_function_main = non-function item at `crate::main` is found

passes_non_exhaustive_with_default_field_values =
    `#[non_exhaustive]` can't be used to annotate items with default field values
    .label = this struct has default field values

passes_non_exported_macro_invalid_attrs =
    attribute should be applied to function or closure
    .label = not a function or closure

passes_object_lifetime_err =
    {$repr}

passes_outer_crate_level_attr =
    crate-level attribute should be an inner attribute

passes_outer_crate_level_attr_suggestion =
    add a `!`

passes_panic_unwind_without_std =
    unwinding panics are not supported without std
    .note = since the core library is usually precompiled with panic="unwind", rebuilding your crate with panic="abort" may not be enough to fix the problem
    .help = using nightly cargo, use -Zbuild-std with panic="abort" to avoid unwinding

passes_parent_info =
    {$num ->
      [one] {$descr}
     *[other] {$descr}s
    } in this {$parent_descr}

passes_proc_macro_bad_sig = {$kind} has incorrect signature

passes_remove_fields =
    consider removing { $num ->
      [one] this
     *[other] these
    } { $num ->
      [one] field
     *[other] fields
    }

passes_repr_align_greater_than_target_max =
    alignment must not be greater than `isize::MAX` bytes
    .note = `isize::MAX` is {$size} for the current target

passes_repr_align_should_be_align =
    `#[repr(align(...))]` is not supported on {$item}
    .help = use `#[rustc_align(...)]` instead

passes_repr_align_should_be_align_static =
    `#[repr(align(...))]` is not supported on {$item}
    .help = use `#[rustc_align_static(...)]` instead

passes_repr_conflicting =
    conflicting representation hints

passes_rustc_allow_const_fn_unstable =
    attribute should be applied to `const fn`
    .label = not a `const fn`

passes_rustc_const_stable_indirect_pairing =
    `const_stable_indirect` attribute does not make sense on `rustc_const_stable` function, its behavior is already implied
passes_rustc_dirty_clean =
    attribute requires -Z query-dep-graph to be enabled

passes_rustc_force_inline_coro =
    attribute cannot be applied to a `async`, `gen` or `async gen` function
    .label = `async`, `gen` or `async gen` function

passes_rustc_legacy_const_generics_index =
    #[rustc_legacy_const_generics] must have one index for each generic parameter
    .label = generic parameters

passes_rustc_legacy_const_generics_index_exceed =
    index exceeds number of arguments
    .label = there {$arg_count ->
        [one] is
        *[other] are
    } only {$arg_count} {$arg_count ->
        [one] argument
        *[other] arguments
    }

passes_rustc_legacy_const_generics_only =
    #[rustc_legacy_const_generics] functions must only have const generics
    .label = non-const generic parameter


passes_rustc_pub_transparent =
    attribute should be applied to `#[repr(transparent)]` types
    .label = not a `#[repr(transparent)]` type

passes_sanitize_attribute_not_allowed =
    sanitize attribute not allowed here
    .not_fn_impl_mod = not a function, impl block, or module
    .no_body = function has no body
    .help = sanitize attribute can be applied to a function (with body), impl block, or module

passes_trait_impl_const_stability_mismatch = const stability on the impl does not match the const stability on the trait
passes_trait_impl_const_stability_mismatch_impl_stable = this impl is (implicitly) stable...
passes_trait_impl_const_stability_mismatch_impl_unstable = this impl is unstable...
passes_trait_impl_const_stability_mismatch_trait_stable = ...but the trait is stable
passes_trait_impl_const_stability_mismatch_trait_unstable = ...but the trait is unstable

passes_trait_impl_const_stable =
    trait implementations cannot be const stable yet
    .note = see issue #143874 <https://github.com/rust-lang/rust/issues/143874> for more information

passes_transparent_incompatible =
    transparent {$target} cannot have other repr hints

passes_unexportable_adt_with_private_fields = ADT types with private fields are not exportable
    .note = `{$field_name}` is private

passes_unexportable_fn_abi = only functions with "C" ABI are exportable

passes_unexportable_generic_fn = generic functions are not exportable

passes_unexportable_item = {$descr}'s are not exportable

passes_unexportable_priv_item = private items are not exportable
    .note = is only usable at visibility `{$vis_descr}`

passes_unexportable_type_in_interface = {$desc} with `#[export_stable]` attribute uses type `{$ty}`, which is not exportable
    .label = not exportable

passes_unexportable_type_repr = types with unstable layout are not exportable

passes_unknown_external_lang_item =
    unknown external lang item: `{$lang_item}`

passes_unknown_feature =
    unknown feature `{$feature}`

passes_unknown_feature_alias =
    feature `{$alias}` has been renamed to `{$feature}`

passes_unknown_lang_item =
    definition of an unknown lang item: `{$name}`
    .label = definition of unknown lang item `{$name}`

passes_unnecessary_partial_stable_feature = the feature `{$feature}` has been partially stabilized since {$since} and is succeeded by the feature `{$implies}`
    .suggestion = if you are using features which are still unstable, change to using `{$implies}`
    .suggestion_remove = if you are using features which are now stable, remove this line

passes_unnecessary_stable_feature = the feature `{$feature}` has been stable since {$since} and no longer requires an attribute to enable

passes_unrecognized_argument =
    unrecognized argument

passes_unstable_attr_for_already_stable_feature =
    can't mark as unstable using an already stable feature
    .label = this feature is already stable
    .item = the stability attribute annotates this item
    .help = consider removing the attribute

passes_unsupported_attributes_in_where =
    most attributes are not supported in `where` clauses
    .help = only `#[cfg]` and `#[cfg_attr]` are supported

passes_unused =
    unused attribute
    .suggestion = remove this attribute

passes_unused_default_method_body_const_note =
    `default_method_body_is_const` has been replaced with `const` on traits

passes_unused_duplicate =
    unused attribute
    .suggestion = remove this attribute
    .note = attribute also specified here
    .warn = {-passes_previously_accepted}

passes_unused_empty_lints_note =
    attribute `{$name}` with an empty list has no effect

passes_unused_linker_messages_note =
    the `linker_messages` lint can only be controlled at the root of a crate that needs to be linked

passes_unused_multiple =
    multiple `{$name}` attributes
    .suggestion = remove this attribute
    .note = attribute also specified here

passes_unused_no_lints_note =
    attribute `{$name}` without any lints has no effect

passes_useless_assignment =
    useless assignment of {$is_field_assign ->
        [true] field
        *[false] variable
    } of type `{$ty}` to itself

passes_useless_stability =
    this stability annotation is useless
    .label = useless stability annotation
    .item = the stability attribute annotates this item
