// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Package dataplane provides a service on Consul servers for the Consul Dataplane

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: pbdataplane/dataplane.proto

package pbdataplane

import (
	_ "github.com/hashicorp/consul/proto-public/annotations/ratelimit"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type DataplaneFeatures int32

const (
	DataplaneFeatures_DATAPLANE_FEATURES_UNSPECIFIED                   DataplaneFeatures = 0
	DataplaneFeatures_DATAPLANE_FEATURES_WATCH_SERVERS                 DataplaneFeatures = 1
	DataplaneFeatures_DATAPLANE_FEATURES_EDGE_CERTIFICATE_MANAGEMENT   DataplaneFeatures = 2
	DataplaneFeatures_DATAPLANE_FEATURES_ENVOY_BOOTSTRAP_CONFIGURATION DataplaneFeatures = 3
	DataplaneFeatures_DATAPLANE_FEATURES_FIPS                          DataplaneFeatures = 4
)

// Enum value maps for DataplaneFeatures.
var (
	DataplaneFeatures_name = map[int32]string{
		0: "DATAPLANE_FEATURES_UNSPECIFIED",
		1: "DATAPLANE_FEATURES_WATCH_SERVERS",
		2: "DATAPLANE_FEATURES_EDGE_CERTIFICATE_MANAGEMENT",
		3: "DATAPLANE_FEATURES_ENVOY_BOOTSTRAP_CONFIGURATION",
		4: "DATAPLANE_FEATURES_FIPS",
	}
	DataplaneFeatures_value = map[string]int32{
		"DATAPLANE_FEATURES_UNSPECIFIED":                   0,
		"DATAPLANE_FEATURES_WATCH_SERVERS":                 1,
		"DATAPLANE_FEATURES_EDGE_CERTIFICATE_MANAGEMENT":   2,
		"DATAPLANE_FEATURES_ENVOY_BOOTSTRAP_CONFIGURATION": 3,
		"DATAPLANE_FEATURES_FIPS":                          4,
	}
)

func (x DataplaneFeatures) Enum() *DataplaneFeatures {
	p := new(DataplaneFeatures)
	*p = x
	return p
}

func (x DataplaneFeatures) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataplaneFeatures) Descriptor() protoreflect.EnumDescriptor {
	return file_pbdataplane_dataplane_proto_enumTypes[0].Descriptor()
}

func (DataplaneFeatures) Type() protoreflect.EnumType {
	return &file_pbdataplane_dataplane_proto_enumTypes[0]
}

func (x DataplaneFeatures) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataplaneFeatures.Descriptor instead.
func (DataplaneFeatures) EnumDescriptor() ([]byte, []int) {
	return file_pbdataplane_dataplane_proto_rawDescGZIP(), []int{0}
}

type ServiceKind int32

const (
	// ServiceKind UNSPECIFIED is a sentinel value for when a request
	// did not specify a service kind. This will be treated the same
	// as if TYPICAL was explicitly used.
	ServiceKind_SERVICE_KIND_UNSPECIFIED ServiceKind = 0
	// ServiceKind Typical is a typical, classic Consul service. This is
	// represented by the absence of a value. This was chosen for ease of
	// backwards compatibility: existing services in the catalog would
	// default to the typical service.
	ServiceKind_SERVICE_KIND_TYPICAL ServiceKind = 1
	// ServiceKind Connect Proxy is a proxy for the Connect feature. This
	// service proxies another service within Consul and speaks the connect
	// protocol.
	ServiceKind_SERVICE_KIND_CONNECT_PROXY ServiceKind = 2
	// ServiceKind Mesh Gateway is a Mesh Gateway for the Connect feature. This
	// service will proxy connections based off the SNI header set by other
	// connect proxies.
	ServiceKind_SERVICE_KIND_MESH_GATEWAY ServiceKind = 3
	// ServiceKind Terminating Gateway is a Terminating Gateway for the Connect
	// feature. This service will proxy connections to services outside the mesh.
	ServiceKind_SERVICE_KIND_TERMINATING_GATEWAY ServiceKind = 4
	// ServiceKind Ingress Gateway is an Ingress Gateway for the Connect feature.
	// This service will ingress connections into the service mesh.
	ServiceKind_SERVICE_KIND_INGRESS_GATEWAY ServiceKind = 5
	// ServiceKind API Gateway is an API Gateway for the Connect feature.
	// This service will ingress connections in to the service mesh.
	ServiceKind_SERVICE_KIND_API_GATEWAY ServiceKind = 6
)

// Enum value maps for ServiceKind.
var (
	ServiceKind_name = map[int32]string{
		0: "SERVICE_KIND_UNSPECIFIED",
		1: "SERVICE_KIND_TYPICAL",
		2: "SERVICE_KIND_CONNECT_PROXY",
		3: "SERVICE_KIND_MESH_GATEWAY",
		4: "SERVICE_KIND_TERMINATING_GATEWAY",
		5: "SERVICE_KIND_INGRESS_GATEWAY",
		6: "SERVICE_KIND_API_GATEWAY",
	}
	ServiceKind_value = map[string]int32{
		"SERVICE_KIND_UNSPECIFIED":         0,
		"SERVICE_KIND_TYPICAL":             1,
		"SERVICE_KIND_CONNECT_PROXY":       2,
		"SERVICE_KIND_MESH_GATEWAY":        3,
		"SERVICE_KIND_TERMINATING_GATEWAY": 4,
		"SERVICE_KIND_INGRESS_GATEWAY":     5,
		"SERVICE_KIND_API_GATEWAY":         6,
	}
)

func (x ServiceKind) Enum() *ServiceKind {
	p := new(ServiceKind)
	*p = x
	return p
}

func (x ServiceKind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceKind) Descriptor() protoreflect.EnumDescriptor {
	return file_pbdataplane_dataplane_proto_enumTypes[1].Descriptor()
}

func (ServiceKind) Type() protoreflect.EnumType {
	return &file_pbdataplane_dataplane_proto_enumTypes[1]
}

func (x ServiceKind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceKind.Descriptor instead.
func (ServiceKind) EnumDescriptor() ([]byte, []int) {
	return file_pbdataplane_dataplane_proto_rawDescGZIP(), []int{1}
}

type GetSupportedDataplaneFeaturesRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetSupportedDataplaneFeaturesRequest) Reset() {
	*x = GetSupportedDataplaneFeaturesRequest{}
	mi := &file_pbdataplane_dataplane_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSupportedDataplaneFeaturesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSupportedDataplaneFeaturesRequest) ProtoMessage() {}

func (x *GetSupportedDataplaneFeaturesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pbdataplane_dataplane_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSupportedDataplaneFeaturesRequest.ProtoReflect.Descriptor instead.
func (*GetSupportedDataplaneFeaturesRequest) Descriptor() ([]byte, []int) {
	return file_pbdataplane_dataplane_proto_rawDescGZIP(), []int{0}
}

type DataplaneFeatureSupport struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	FeatureName   DataplaneFeatures      `protobuf:"varint,1,opt,name=feature_name,json=featureName,proto3,enum=hashicorp.consul.dataplane.DataplaneFeatures" json:"feature_name,omitempty"`
	Supported     bool                   `protobuf:"varint,2,opt,name=supported,proto3" json:"supported,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DataplaneFeatureSupport) Reset() {
	*x = DataplaneFeatureSupport{}
	mi := &file_pbdataplane_dataplane_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataplaneFeatureSupport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataplaneFeatureSupport) ProtoMessage() {}

func (x *DataplaneFeatureSupport) ProtoReflect() protoreflect.Message {
	mi := &file_pbdataplane_dataplane_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataplaneFeatureSupport.ProtoReflect.Descriptor instead.
func (*DataplaneFeatureSupport) Descriptor() ([]byte, []int) {
	return file_pbdataplane_dataplane_proto_rawDescGZIP(), []int{1}
}

func (x *DataplaneFeatureSupport) GetFeatureName() DataplaneFeatures {
	if x != nil {
		return x.FeatureName
	}
	return DataplaneFeatures_DATAPLANE_FEATURES_UNSPECIFIED
}

func (x *DataplaneFeatureSupport) GetSupported() bool {
	if x != nil {
		return x.Supported
	}
	return false
}

type GetSupportedDataplaneFeaturesResponse struct {
	state                      protoimpl.MessageState     `protogen:"open.v1"`
	SupportedDataplaneFeatures []*DataplaneFeatureSupport `protobuf:"bytes,1,rep,name=supported_dataplane_features,json=supportedDataplaneFeatures,proto3" json:"supported_dataplane_features,omitempty"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *GetSupportedDataplaneFeaturesResponse) Reset() {
	*x = GetSupportedDataplaneFeaturesResponse{}
	mi := &file_pbdataplane_dataplane_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSupportedDataplaneFeaturesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSupportedDataplaneFeaturesResponse) ProtoMessage() {}

func (x *GetSupportedDataplaneFeaturesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pbdataplane_dataplane_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSupportedDataplaneFeaturesResponse.ProtoReflect.Descriptor instead.
func (*GetSupportedDataplaneFeaturesResponse) Descriptor() ([]byte, []int) {
	return file_pbdataplane_dataplane_proto_rawDescGZIP(), []int{2}
}

func (x *GetSupportedDataplaneFeaturesResponse) GetSupportedDataplaneFeatures() []*DataplaneFeatureSupport {
	if x != nil {
		return x.SupportedDataplaneFeatures
	}
	return nil
}

type GetEnvoyBootstrapParamsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to NodeSpec:
	//
	//	*GetEnvoyBootstrapParamsRequest_NodeId
	//	*GetEnvoyBootstrapParamsRequest_NodeName
	NodeSpec isGetEnvoyBootstrapParamsRequest_NodeSpec `protobuf_oneof:"node_spec"`
	// The proxy service ID
	//
	// Deprecated: Marked as deprecated in pbdataplane/dataplane.proto.
	ServiceId     string `protobuf:"bytes,3,opt,name=service_id,json=serviceId,proto3" json:"service_id,omitempty"`
	ProxyId       string `protobuf:"bytes,6,opt,name=proxy_id,json=proxyId,proto3" json:"proxy_id,omitempty"`
	Partition     string `protobuf:"bytes,4,opt,name=partition,proto3" json:"partition,omitempty"`
	Namespace     string `protobuf:"bytes,5,opt,name=namespace,proto3" json:"namespace,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetEnvoyBootstrapParamsRequest) Reset() {
	*x = GetEnvoyBootstrapParamsRequest{}
	mi := &file_pbdataplane_dataplane_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetEnvoyBootstrapParamsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEnvoyBootstrapParamsRequest) ProtoMessage() {}

func (x *GetEnvoyBootstrapParamsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pbdataplane_dataplane_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEnvoyBootstrapParamsRequest.ProtoReflect.Descriptor instead.
func (*GetEnvoyBootstrapParamsRequest) Descriptor() ([]byte, []int) {
	return file_pbdataplane_dataplane_proto_rawDescGZIP(), []int{3}
}

func (x *GetEnvoyBootstrapParamsRequest) GetNodeSpec() isGetEnvoyBootstrapParamsRequest_NodeSpec {
	if x != nil {
		return x.NodeSpec
	}
	return nil
}

func (x *GetEnvoyBootstrapParamsRequest) GetNodeId() string {
	if x != nil {
		if x, ok := x.NodeSpec.(*GetEnvoyBootstrapParamsRequest_NodeId); ok {
			return x.NodeId
		}
	}
	return ""
}

func (x *GetEnvoyBootstrapParamsRequest) GetNodeName() string {
	if x != nil {
		if x, ok := x.NodeSpec.(*GetEnvoyBootstrapParamsRequest_NodeName); ok {
			return x.NodeName
		}
	}
	return ""
}

// Deprecated: Marked as deprecated in pbdataplane/dataplane.proto.
func (x *GetEnvoyBootstrapParamsRequest) GetServiceId() string {
	if x != nil {
		return x.ServiceId
	}
	return ""
}

func (x *GetEnvoyBootstrapParamsRequest) GetProxyId() string {
	if x != nil {
		return x.ProxyId
	}
	return ""
}

func (x *GetEnvoyBootstrapParamsRequest) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

func (x *GetEnvoyBootstrapParamsRequest) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

type isGetEnvoyBootstrapParamsRequest_NodeSpec interface {
	isGetEnvoyBootstrapParamsRequest_NodeSpec()
}

type GetEnvoyBootstrapParamsRequest_NodeId struct {
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3,oneof"`
}

type GetEnvoyBootstrapParamsRequest_NodeName struct {
	NodeName string `protobuf:"bytes,2,opt,name=node_name,json=nodeName,proto3,oneof"`
}

func (*GetEnvoyBootstrapParamsRequest_NodeId) isGetEnvoyBootstrapParamsRequest_NodeSpec() {}

func (*GetEnvoyBootstrapParamsRequest_NodeName) isGetEnvoyBootstrapParamsRequest_NodeSpec() {}

type GetEnvoyBootstrapParamsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// deprecated: use identity instead.
	// service is used to identify the service (as the local cluster name and
	// in metric tags). If the service is a connect proxy it will be the name of
	// the proxy's destination service, for gateways it will be the gateway
	// service's name.
	//
	// Deprecated: Marked as deprecated in pbdataplane/dataplane.proto.
	Service string `protobuf:"bytes,2,opt,name=service,proto3" json:"service,omitempty"`
	// identity is used to identify this proxy (as the local cluster name and
	// in metric tags). For v1, this should be the service name.
	// If the service is a connect proxy it will be the name of
	// the proxy's destination service, for gateways it will be the gateway
	// service's name.
	Identity      string           `protobuf:"bytes,10,opt,name=identity,proto3" json:"identity,omitempty"`
	Namespace     string           `protobuf:"bytes,3,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Partition     string           `protobuf:"bytes,4,opt,name=partition,proto3" json:"partition,omitempty"`
	Datacenter    string           `protobuf:"bytes,5,opt,name=datacenter,proto3" json:"datacenter,omitempty"`
	Config        *structpb.Struct `protobuf:"bytes,6,opt,name=config,proto3" json:"config,omitempty"`
	NodeName      string           `protobuf:"bytes,8,opt,name=node_name,json=nodeName,proto3" json:"node_name,omitempty"`
	AccessLogs    []string         `protobuf:"bytes,9,rep,name=access_logs,json=accessLogs,proto3" json:"access_logs,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetEnvoyBootstrapParamsResponse) Reset() {
	*x = GetEnvoyBootstrapParamsResponse{}
	mi := &file_pbdataplane_dataplane_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetEnvoyBootstrapParamsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEnvoyBootstrapParamsResponse) ProtoMessage() {}

func (x *GetEnvoyBootstrapParamsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pbdataplane_dataplane_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEnvoyBootstrapParamsResponse.ProtoReflect.Descriptor instead.
func (*GetEnvoyBootstrapParamsResponse) Descriptor() ([]byte, []int) {
	return file_pbdataplane_dataplane_proto_rawDescGZIP(), []int{4}
}

// Deprecated: Marked as deprecated in pbdataplane/dataplane.proto.
func (x *GetEnvoyBootstrapParamsResponse) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *GetEnvoyBootstrapParamsResponse) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

func (x *GetEnvoyBootstrapParamsResponse) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *GetEnvoyBootstrapParamsResponse) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

func (x *GetEnvoyBootstrapParamsResponse) GetDatacenter() string {
	if x != nil {
		return x.Datacenter
	}
	return ""
}

func (x *GetEnvoyBootstrapParamsResponse) GetConfig() *structpb.Struct {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *GetEnvoyBootstrapParamsResponse) GetNodeName() string {
	if x != nil {
		return x.NodeName
	}
	return ""
}

func (x *GetEnvoyBootstrapParamsResponse) GetAccessLogs() []string {
	if x != nil {
		return x.AccessLogs
	}
	return nil
}

var File_pbdataplane_dataplane_proto protoreflect.FileDescriptor

const file_pbdataplane_dataplane_proto_rawDesc = "" +
	"\n" +
	"\x1bpbdataplane/dataplane.proto\x12\x1ahashicorp.consul.dataplane\x1a%annotations/ratelimit/ratelimit.proto\x1a\x1cgoogle/protobuf/struct.proto\"&\n" +
	"$GetSupportedDataplaneFeaturesRequest\"\x89\x01\n" +
	"\x17DataplaneFeatureSupport\x12P\n" +
	"\ffeature_name\x18\x01 \x01(\x0e2-.hashicorp.consul.dataplane.DataplaneFeaturesR\vfeatureName\x12\x1c\n" +
	"\tsupported\x18\x02 \x01(\bR\tsupported\"\x9e\x01\n" +
	"%GetSupportedDataplaneFeaturesResponse\x12u\n" +
	"\x1csupported_dataplane_features\x18\x01 \x03(\v23.hashicorp.consul.dataplane.DataplaneFeatureSupportR\x1asupportedDataplaneFeatures\"\xe1\x01\n" +
	"\x1eGetEnvoyBootstrapParamsRequest\x12\x19\n" +
	"\anode_id\x18\x01 \x01(\tH\x00R\x06nodeId\x12\x1d\n" +
	"\tnode_name\x18\x02 \x01(\tH\x00R\bnodeName\x12!\n" +
	"\n" +
	"service_id\x18\x03 \x01(\tB\x02\x18\x01R\tserviceId\x12\x19\n" +
	"\bproxy_id\x18\x06 \x01(\tR\aproxyId\x12\x1c\n" +
	"\tpartition\x18\x04 \x01(\tR\tpartition\x12\x1c\n" +
	"\tnamespace\x18\x05 \x01(\tR\tnamespaceB\v\n" +
	"\tnode_spec\"\xb8\x02\n" +
	"\x1fGetEnvoyBootstrapParamsResponse\x12\x1c\n" +
	"\aservice\x18\x02 \x01(\tB\x02\x18\x01R\aservice\x12\x1a\n" +
	"\bidentity\x18\n" +
	" \x01(\tR\bidentity\x12\x1c\n" +
	"\tnamespace\x18\x03 \x01(\tR\tnamespace\x12\x1c\n" +
	"\tpartition\x18\x04 \x01(\tR\tpartition\x12\x1e\n" +
	"\n" +
	"datacenter\x18\x05 \x01(\tR\n" +
	"datacenter\x12/\n" +
	"\x06config\x18\x06 \x01(\v2\x17.google.protobuf.StructR\x06config\x12\x1b\n" +
	"\tnode_name\x18\b \x01(\tR\bnodeName\x12\x1f\n" +
	"\vaccess_logs\x18\t \x03(\tR\n" +
	"accessLogsJ\x04\b\x01\x10\x02J\x04\b\v\x10\fJ\x04\b\a\x10\b*\xe4\x01\n" +
	"\x11DataplaneFeatures\x12\"\n" +
	"\x1eDATAPLANE_FEATURES_UNSPECIFIED\x10\x00\x12$\n" +
	" DATAPLANE_FEATURES_WATCH_SERVERS\x10\x01\x122\n" +
	".DATAPLANE_FEATURES_EDGE_CERTIFICATE_MANAGEMENT\x10\x02\x124\n" +
	"0DATAPLANE_FEATURES_ENVOY_BOOTSTRAP_CONFIGURATION\x10\x03\x12\x1b\n" +
	"\x17DATAPLANE_FEATURES_FIPS\x10\x04*\xea\x01\n" +
	"\vServiceKind\x12\x1c\n" +
	"\x18SERVICE_KIND_UNSPECIFIED\x10\x00\x12\x18\n" +
	"\x14SERVICE_KIND_TYPICAL\x10\x01\x12\x1e\n" +
	"\x1aSERVICE_KIND_CONNECT_PROXY\x10\x02\x12\x1d\n" +
	"\x19SERVICE_KIND_MESH_GATEWAY\x10\x03\x12$\n" +
	" SERVICE_KIND_TERMINATING_GATEWAY\x10\x04\x12 \n" +
	"\x1cSERVICE_KIND_INGRESS_GATEWAY\x10\x05\x12\x1c\n" +
	"\x18SERVICE_KIND_API_GATEWAY\x10\x062\xe2\x02\n" +
	"\x10DataplaneService\x12\xae\x01\n" +
	"\x1dGetSupportedDataplaneFeatures\x12@.hashicorp.consul.dataplane.GetSupportedDataplaneFeaturesRequest\x1aA.hashicorp.consul.dataplane.GetSupportedDataplaneFeaturesResponse\"\b\xe2\x86\x04\x04\b\x02\x10\a\x12\x9c\x01\n" +
	"\x17GetEnvoyBootstrapParams\x12:.hashicorp.consul.dataplane.GetEnvoyBootstrapParamsRequest\x1a;.hashicorp.consul.dataplane.GetEnvoyBootstrapParamsResponse\"\b\xe2\x86\x04\x04\b\x02\x10\aB\xf0\x01\n" +
	"\x1ecom.hashicorp.consul.dataplaneB\x0eDataplaneProtoP\x01Z4github.com/hashicorp/consul/proto-public/pbdataplane\xa2\x02\x03HCD\xaa\x02\x1aHashicorp.Consul.Dataplane\xca\x02\x1aHashicorp\\Consul\\Dataplane\xe2\x02&Hashicorp\\Consul\\Dataplane\\GPBMetadata\xea\x02\x1cHashicorp::Consul::Dataplaneb\x06proto3"

var (
	file_pbdataplane_dataplane_proto_rawDescOnce sync.Once
	file_pbdataplane_dataplane_proto_rawDescData []byte
)

func file_pbdataplane_dataplane_proto_rawDescGZIP() []byte {
	file_pbdataplane_dataplane_proto_rawDescOnce.Do(func() {
		file_pbdataplane_dataplane_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_pbdataplane_dataplane_proto_rawDesc), len(file_pbdataplane_dataplane_proto_rawDesc)))
	})
	return file_pbdataplane_dataplane_proto_rawDescData
}

var file_pbdataplane_dataplane_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_pbdataplane_dataplane_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_pbdataplane_dataplane_proto_goTypes = []any{
	(DataplaneFeatures)(0),                        // 0: hashicorp.consul.dataplane.DataplaneFeatures
	(ServiceKind)(0),                              // 1: hashicorp.consul.dataplane.ServiceKind
	(*GetSupportedDataplaneFeaturesRequest)(nil),  // 2: hashicorp.consul.dataplane.GetSupportedDataplaneFeaturesRequest
	(*DataplaneFeatureSupport)(nil),               // 3: hashicorp.consul.dataplane.DataplaneFeatureSupport
	(*GetSupportedDataplaneFeaturesResponse)(nil), // 4: hashicorp.consul.dataplane.GetSupportedDataplaneFeaturesResponse
	(*GetEnvoyBootstrapParamsRequest)(nil),        // 5: hashicorp.consul.dataplane.GetEnvoyBootstrapParamsRequest
	(*GetEnvoyBootstrapParamsResponse)(nil),       // 6: hashicorp.consul.dataplane.GetEnvoyBootstrapParamsResponse
	(*structpb.Struct)(nil),                       // 7: google.protobuf.Struct
}
var file_pbdataplane_dataplane_proto_depIdxs = []int32{
	0, // 0: hashicorp.consul.dataplane.DataplaneFeatureSupport.feature_name:type_name -> hashicorp.consul.dataplane.DataplaneFeatures
	3, // 1: hashicorp.consul.dataplane.GetSupportedDataplaneFeaturesResponse.supported_dataplane_features:type_name -> hashicorp.consul.dataplane.DataplaneFeatureSupport
	7, // 2: hashicorp.consul.dataplane.GetEnvoyBootstrapParamsResponse.config:type_name -> google.protobuf.Struct
	2, // 3: hashicorp.consul.dataplane.DataplaneService.GetSupportedDataplaneFeatures:input_type -> hashicorp.consul.dataplane.GetSupportedDataplaneFeaturesRequest
	5, // 4: hashicorp.consul.dataplane.DataplaneService.GetEnvoyBootstrapParams:input_type -> hashicorp.consul.dataplane.GetEnvoyBootstrapParamsRequest
	4, // 5: hashicorp.consul.dataplane.DataplaneService.GetSupportedDataplaneFeatures:output_type -> hashicorp.consul.dataplane.GetSupportedDataplaneFeaturesResponse
	6, // 6: hashicorp.consul.dataplane.DataplaneService.GetEnvoyBootstrapParams:output_type -> hashicorp.consul.dataplane.GetEnvoyBootstrapParamsResponse
	5, // [5:7] is the sub-list for method output_type
	3, // [3:5] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_pbdataplane_dataplane_proto_init() }
func file_pbdataplane_dataplane_proto_init() {
	if File_pbdataplane_dataplane_proto != nil {
		return
	}
	file_pbdataplane_dataplane_proto_msgTypes[3].OneofWrappers = []any{
		(*GetEnvoyBootstrapParamsRequest_NodeId)(nil),
		(*GetEnvoyBootstrapParamsRequest_NodeName)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_pbdataplane_dataplane_proto_rawDesc), len(file_pbdataplane_dataplane_proto_rawDesc)),
			NumEnums:      2,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_pbdataplane_dataplane_proto_goTypes,
		DependencyIndexes: file_pbdataplane_dataplane_proto_depIdxs,
		EnumInfos:         file_pbdataplane_dataplane_proto_enumTypes,
		MessageInfos:      file_pbdataplane_dataplane_proto_msgTypes,
	}.Build()
	File_pbdataplane_dataplane_proto = out.File
	file_pbdataplane_dataplane_proto_goTypes = nil
	file_pbdataplane_dataplane_proto_depIdxs = nil
}
