---
title: pixi upload s3
---
<!--- This file is autogenerated. Do not edit manually! -->
# [pixi](../../pixi.md) [upload](../upload.md) s3

Options for uploading to S3

--8<-- "docs/reference/cli/pixi/upload/s3_extender:description"

## Usage
```
pixi upload s3 [OPTIONS] --channel <CHANNEL>
```

## Options
- <a id="arg---channel" href="#arg---channel">`--channel (-c) <CHANNEL>`</a>
:  The channel URL in the S3 bucket to upload the package to, e.g., `s3://my-bucket/my-channel`
<br>**required**: `true`
<br>**env**: `S3_CHANNEL`
- <a id="arg---force" href="#arg---force">`--force`</a>
:  Replace files if it already exists

## S3 Credentials
- <a id="arg---endpoint-url" href="#arg---endpoint-url">`--endpoint-url <ENDPOINT_URL>`</a>
:  The endpoint URL of the S3 backend
<br>**env**: `S3_ENDPOINT_URL`
- <a id="arg---region" href="#arg---region">`--region <REGION>`</a>
:  The region of the S3 backend
<br>**env**: `S3_REGION`
- <a id="arg---access-key-id" href="#arg---access-key-id">`--access-key-id <ACCESS_KEY_ID>`</a>
:  The access key ID for the S3 bucket
<br>**env**: `S3_ACCESS_KEY_ID`
- <a id="arg---secret-access-key" href="#arg---secret-access-key">`--secret-access-key <SECRET_ACCESS_KEY>`</a>
:  The secret access key for the S3 bucket
<br>**env**: `S3_SECRET_ACCESS_KEY`
- <a id="arg---session-token" href="#arg---session-token">`--session-token <SESSION_TOKEN>`</a>
:  The session token for the S3 bucket
<br>**env**: `S3_SESSION_TOKEN`
- <a id="arg---addressing-style" href="#arg---addressing-style">`--addressing-style <ADDRESSING_STYLE>`</a>
:  How to address the bucket
<br>**env**: `S3_ADDRESSING_STYLE`
<br>**default**: `virtual-host`
<br>**options**: `virtual-host`, `path`

--8<-- "docs/reference/cli/pixi/upload/s3_extender:example"
