// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --include-generated-funcs --replace-value-regex "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _ --version 5
// expected-no-diagnostics

// Check code generation
// RUN: %clang_cc1 -verify -triple x86_64-pc-linux-gnu -std=c++20 -fclang-abi-compat=latest -fopenmp -fopenmp-version=60 -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK1

// Check same results after serialization round-trip
// RUN: %clang_cc1 -verify -triple x86_64-pc-linux-gnu -std=c++20 -fclang-abi-compat=latest -fopenmp -fopenmp-version=60 -emit-pch -o %t %s
// RUN: %clang_cc1 -verify -triple x86_64-pc-linux-gnu -std=c++20 -fclang-abi-compat=latest -fopenmp -fopenmp-version=60 -include-pch %t -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK2

#ifndef HEADER
#define HEADER

//placeholder for loop body code.
extern "C" void body(...) {}

extern "C" void foo1(int start1, int end1, int step1, int start2, int end2, int step2) {
    int i,j;
    #pragma omp fuse
    {
        for(i = start1; i < end1; i += step1) body(i);
        for(j = start2; j < end2; j += step2) body(j);
    }

}

template <typename T>
void foo2(T start, T end, T step){
    T i,j,k;
    #pragma omp fuse
    {
        for(i = start; i < end; i += step) body(i);
        for(j = end; j > start; j -= step) body(j);
        for(k = start+step; k < end+step; k += step) body(k);
    }
}

extern "C" void tfoo2() {
    foo2<int>(0, 64, 4);
}

extern "C" void foo3() {
    double arr[256];
    #pragma omp fuse
    {
        #pragma omp fuse
        {
            for(int i = 0; i < 128; ++i) body(i);
            for(int j = 0; j < 256; j+=2) body(j);
        }
        for(int c = 42; auto &&v: arr) body(c,v);
        for(int cc = 37; auto &&vv: arr) body(cc, vv);
    }
}

extern "C" void foo4() {
    double arr[256];

    #pragma omp fuse looprange(2,2)
    {
        for(int i = 0; i < 128; ++i) body(i);
        for(int j = 0; j < 256; j+=2) body(j);
        for(int k = 0; k < 64; ++k) body(k);
        for(int c = 42; auto &&v: arr) body(c,v);
    }
}

// This exemplifies the usage of loop transformations that generate
// more than top level canonical loop nests (e.g split, loopranged fuse...)
extern "C" void foo5() {
    double arr[256];
    #pragma omp fuse looprange(2,2)
    {
        #pragma omp fuse looprange(2,2)
        {
            for(int i = 0; i < 128; ++i) body(i);
            for(int j = 0; j < 256; j+=2) body(j);
            for(int k = 0; k < 512; ++k) body(k);
        }
        for(int c = 42; auto &&v: arr) body(c,v);
        for(int cc = 37; auto &&vv: arr) body(cc, vv);
    }
}


#endif
// CHECK1-LABEL: define dso_local void @body(
// CHECK1-SAME: ...) #[[ATTR0:[0-9]+]] {
// CHECK1-NEXT:  [[ENTRY:.*:]]
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define dso_local void @foo1(
// CHECK1-SAME: i32 noundef [[START1:%.*]], i32 noundef [[END1:%.*]], i32 noundef [[STEP1:%.*]], i32 noundef [[START2:%.*]], i32 noundef [[END2:%.*]], i32 noundef [[STEP2:%.*]]) #[[ATTR0]] {
// CHECK1-NEXT:  [[ENTRY:.*:]]
// CHECK1-NEXT:    [[START1_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[END1_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[STEP1_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[START2_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[END2_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[STEP2_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[J:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTNEW_STEP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB0:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_ST0:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_NI0:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IV0:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_6:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_7:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTNEW_STEP8:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_9:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_ST1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_NI1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IV1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_TEMP_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_FUSE_MAX:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_FUSE_INDEX:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32 [[START1]], ptr [[START1_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[END1]], ptr [[END1_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[STEP1]], ptr [[STEP1_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[START2]], ptr [[START2_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[END2]], ptr [[END2_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[STEP2]], ptr [[STEP2_ADDR]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[START1_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP0]], ptr [[I]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[START1_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP1]], ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[END1_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP2]], ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, ptr [[STEP1_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP3]], ptr [[DOTNEW_STEP]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub i32 [[TMP4]], [[TMP5]]
// CHECK1-NEXT:    [[SUB3:%.*]] = sub i32 [[SUB]], 1
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTNEW_STEP]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add i32 [[SUB3]], [[TMP6]]
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTNEW_STEP]], align 4
// CHECK1-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], [[TMP7]]
// CHECK1-NEXT:    [[SUB4:%.*]] = sub i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_LB0]], align 4
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_ST0]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    [[ADD5:%.*]] = add i32 [[TMP8]], 1
// CHECK1-NEXT:    store i32 [[ADD5]], ptr [[DOTOMP_NI0]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, ptr [[START2_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP9]], ptr [[J]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, ptr [[START2_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP10]], ptr [[DOTCAPTURE_EXPR_6]], align 4
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, ptr [[END2_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP11]], ptr [[DOTCAPTURE_EXPR_7]], align 4
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, ptr [[STEP2_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP12]], ptr [[DOTNEW_STEP8]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_7]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_6]], align 4
// CHECK1-NEXT:    [[SUB10:%.*]] = sub i32 [[TMP13]], [[TMP14]]
// CHECK1-NEXT:    [[SUB11:%.*]] = sub i32 [[SUB10]], 1
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTNEW_STEP8]], align 4
// CHECK1-NEXT:    [[ADD12:%.*]] = add i32 [[SUB11]], [[TMP15]]
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTNEW_STEP8]], align 4
// CHECK1-NEXT:    [[DIV13:%.*]] = udiv i32 [[ADD12]], [[TMP16]]
// CHECK1-NEXT:    [[SUB14:%.*]] = sub i32 [[DIV13]], 1
// CHECK1-NEXT:    store i32 [[SUB14]], ptr [[DOTCAPTURE_EXPR_9]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_LB1]], align 4
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_ST1]], align 4
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_9]], align 4
// CHECK1-NEXT:    [[ADD15:%.*]] = add i32 [[TMP17]], 1
// CHECK1-NEXT:    store i32 [[ADD15]], ptr [[DOTOMP_NI1]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_NI0]], align 4
// CHECK1-NEXT:    store i32 [[TMP18]], ptr [[DOTOMP_TEMP_1]], align 4
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_TEMP_1]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[TMP19]], [[TMP20]]
// CHECK1-NEXT:    br i1 [[CMP]], label %[[COND_TRUE:.*]], label %[[COND_FALSE:.*]]
// CHECK1:       [[COND_TRUE]]:
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, ptr [[DOTOMP_TEMP_1]], align 4
// CHECK1-NEXT:    br label %[[COND_END:.*]]
// CHECK1:       [[COND_FALSE]]:
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK1-NEXT:    br label %[[COND_END]]
// CHECK1:       [[COND_END]]:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP21]], %[[COND_TRUE]] ], [ [[TMP22]], %[[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], ptr [[DOTOMP_FUSE_MAX]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    br label %[[FOR_COND:.*]]
// CHECK1:       [[FOR_COND]]:
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, ptr [[DOTOMP_FUSE_MAX]], align 4
// CHECK1-NEXT:    [[CMP16:%.*]] = icmp ult i32 [[TMP23]], [[TMP24]]
// CHECK1-NEXT:    br i1 [[CMP16]], label %[[FOR_BODY:.*]], label %[[FOR_END:.*]]
// CHECK1:       [[FOR_BODY]]:
// CHECK1-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTOMP_NI0]], align 4
// CHECK1-NEXT:    [[CMP17:%.*]] = icmp ult i32 [[TMP25]], [[TMP26]]
// CHECK1-NEXT:    br i1 [[CMP17]], label %[[IF_THEN:.*]], label %[[IF_END:.*]]
// CHECK1:       [[IF_THEN]]:
// CHECK1-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_LB0]], align 4
// CHECK1-NEXT:    [[TMP28:%.*]] = load i32, ptr [[DOTOMP_ST0]], align 4
// CHECK1-NEXT:    [[TMP29:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul i32 [[TMP28]], [[TMP29]]
// CHECK1-NEXT:    [[ADD18:%.*]] = add i32 [[TMP27]], [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD18]], ptr [[DOTOMP_IV0]], align 4
// CHECK1-NEXT:    [[TMP30:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP31:%.*]] = load i32, ptr [[DOTOMP_IV0]], align 4
// CHECK1-NEXT:    [[TMP32:%.*]] = load i32, ptr [[DOTNEW_STEP]], align 4
// CHECK1-NEXT:    [[MUL19:%.*]] = mul i32 [[TMP31]], [[TMP32]]
// CHECK1-NEXT:    [[ADD20:%.*]] = add i32 [[TMP30]], [[MUL19]]
// CHECK1-NEXT:    store i32 [[ADD20]], ptr [[I]], align 4
// CHECK1-NEXT:    [[TMP33:%.*]] = load i32, ptr [[I]], align 4
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP33]])
// CHECK1-NEXT:    br label %[[IF_END]]
// CHECK1:       [[IF_END]]:
// CHECK1-NEXT:    [[TMP34:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[TMP35:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK1-NEXT:    [[CMP21:%.*]] = icmp ult i32 [[TMP34]], [[TMP35]]
// CHECK1-NEXT:    br i1 [[CMP21]], label %[[IF_THEN22:.*]], label %[[IF_END27:.*]]
// CHECK1:       [[IF_THEN22]]:
// CHECK1-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_LB1]], align 4
// CHECK1-NEXT:    [[TMP37:%.*]] = load i32, ptr [[DOTOMP_ST1]], align 4
// CHECK1-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[MUL23:%.*]] = mul i32 [[TMP37]], [[TMP38]]
// CHECK1-NEXT:    [[ADD24:%.*]] = add i32 [[TMP36]], [[MUL23]]
// CHECK1-NEXT:    store i32 [[ADD24]], ptr [[DOTOMP_IV1]], align 4
// CHECK1-NEXT:    [[TMP39:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_6]], align 4
// CHECK1-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_IV1]], align 4
// CHECK1-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTNEW_STEP8]], align 4
// CHECK1-NEXT:    [[MUL25:%.*]] = mul i32 [[TMP40]], [[TMP41]]
// CHECK1-NEXT:    [[ADD26:%.*]] = add i32 [[TMP39]], [[MUL25]]
// CHECK1-NEXT:    store i32 [[ADD26]], ptr [[J]], align 4
// CHECK1-NEXT:    [[TMP42:%.*]] = load i32, ptr [[J]], align 4
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP42]])
// CHECK1-NEXT:    br label %[[IF_END27]]
// CHECK1:       [[IF_END27]]:
// CHECK1-NEXT:    br label %[[FOR_INC:.*]]
// CHECK1:       [[FOR_INC]]:
// CHECK1-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[INC:%.*]] = add i32 [[TMP43]], 1
// CHECK1-NEXT:    store i32 [[INC]], ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    br label %[[FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK1:       [[FOR_END]]:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define dso_local void @tfoo2(
// CHECK1-SAME: ) #[[ATTR0]] {
// CHECK1-NEXT:  [[ENTRY:.*:]]
// CHECK1-NEXT:    call void @_Z4foo2IiEvT_S0_S0_(i32 noundef 0, i32 noundef 64, i32 noundef 4)
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define linkonce_odr void @_Z4foo2IiEvT_S0_S0_(
// CHECK1-SAME: i32 noundef [[START:%.*]], i32 noundef [[END:%.*]], i32 noundef [[STEP:%.*]]) #[[ATTR0]] comdat {
// CHECK1-NEXT:  [[ENTRY:.*:]]
// CHECK1-NEXT:    [[START_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[END_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[STEP_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[J:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[K:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTNEW_STEP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB0:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_ST0:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_NI0:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IV0:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_6:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_7:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTNEW_STEP8:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_9:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_ST1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_NI1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IV1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_17:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_19:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTNEW_STEP21:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_22:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_ST2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_NI2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IV2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_TEMP_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_TEMP_2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_FUSE_MAX:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_FUSE_INDEX:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32 [[START]], ptr [[START_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[END]], ptr [[END_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[STEP]], ptr [[STEP_ADDR]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[START_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP0]], ptr [[I]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[START_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP1]], ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[END_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP2]], ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, ptr [[STEP_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP3]], ptr [[DOTNEW_STEP]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub i32 [[TMP4]], [[TMP5]]
// CHECK1-NEXT:    [[SUB3:%.*]] = sub i32 [[SUB]], 1
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTNEW_STEP]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add i32 [[SUB3]], [[TMP6]]
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTNEW_STEP]], align 4
// CHECK1-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], [[TMP7]]
// CHECK1-NEXT:    [[SUB4:%.*]] = sub i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_LB0]], align 4
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_ST0]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    [[ADD5:%.*]] = add i32 [[TMP8]], 1
// CHECK1-NEXT:    store i32 [[ADD5]], ptr [[DOTOMP_NI0]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, ptr [[END_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP9]], ptr [[J]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, ptr [[END_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP10]], ptr [[DOTCAPTURE_EXPR_6]], align 4
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, ptr [[START_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP11]], ptr [[DOTCAPTURE_EXPR_7]], align 4
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, ptr [[STEP_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP12]], ptr [[DOTNEW_STEP8]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_6]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_7]], align 4
// CHECK1-NEXT:    [[SUB10:%.*]] = sub i32 [[TMP13]], [[TMP14]]
// CHECK1-NEXT:    [[SUB11:%.*]] = sub i32 [[SUB10]], 1
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTNEW_STEP8]], align 4
// CHECK1-NEXT:    [[ADD12:%.*]] = add i32 [[SUB11]], [[TMP15]]
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTNEW_STEP8]], align 4
// CHECK1-NEXT:    [[DIV13:%.*]] = udiv i32 [[ADD12]], [[TMP16]]
// CHECK1-NEXT:    [[SUB14:%.*]] = sub i32 [[DIV13]], 1
// CHECK1-NEXT:    store i32 [[SUB14]], ptr [[DOTCAPTURE_EXPR_9]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_LB1]], align 4
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_ST1]], align 4
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_9]], align 4
// CHECK1-NEXT:    [[ADD15:%.*]] = add i32 [[TMP17]], 1
// CHECK1-NEXT:    store i32 [[ADD15]], ptr [[DOTOMP_NI1]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, ptr [[START_ADDR]], align 4
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, ptr [[STEP_ADDR]], align 4
// CHECK1-NEXT:    [[ADD16:%.*]] = add nsw i32 [[TMP18]], [[TMP19]]
// CHECK1-NEXT:    store i32 [[ADD16]], ptr [[K]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, ptr [[START_ADDR]], align 4
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, ptr [[STEP_ADDR]], align 4
// CHECK1-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP20]], [[TMP21]]
// CHECK1-NEXT:    store i32 [[ADD18]], ptr [[DOTCAPTURE_EXPR_17]], align 4
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, ptr [[END_ADDR]], align 4
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32, ptr [[STEP_ADDR]], align 4
// CHECK1-NEXT:    [[ADD20:%.*]] = add nsw i32 [[TMP22]], [[TMP23]]
// CHECK1-NEXT:    store i32 [[ADD20]], ptr [[DOTCAPTURE_EXPR_19]], align 4
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, ptr [[STEP_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP24]], ptr [[DOTNEW_STEP21]], align 4
// CHECK1-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_19]], align 4
// CHECK1-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_17]], align 4
// CHECK1-NEXT:    [[SUB23:%.*]] = sub i32 [[TMP25]], [[TMP26]]
// CHECK1-NEXT:    [[SUB24:%.*]] = sub i32 [[SUB23]], 1
// CHECK1-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTNEW_STEP21]], align 4
// CHECK1-NEXT:    [[ADD25:%.*]] = add i32 [[SUB24]], [[TMP27]]
// CHECK1-NEXT:    [[TMP28:%.*]] = load i32, ptr [[DOTNEW_STEP21]], align 4
// CHECK1-NEXT:    [[DIV26:%.*]] = udiv i32 [[ADD25]], [[TMP28]]
// CHECK1-NEXT:    [[SUB27:%.*]] = sub i32 [[DIV26]], 1
// CHECK1-NEXT:    store i32 [[SUB27]], ptr [[DOTCAPTURE_EXPR_22]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_LB2]], align 4
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_ST2]], align 4
// CHECK1-NEXT:    [[TMP29:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_22]], align 4
// CHECK1-NEXT:    [[ADD28:%.*]] = add i32 [[TMP29]], 1
// CHECK1-NEXT:    store i32 [[ADD28]], ptr [[DOTOMP_NI2]], align 4
// CHECK1-NEXT:    [[TMP30:%.*]] = load i32, ptr [[DOTOMP_NI0]], align 4
// CHECK1-NEXT:    store i32 [[TMP30]], ptr [[DOTOMP_TEMP_1]], align 4
// CHECK1-NEXT:    [[TMP31:%.*]] = load i32, ptr [[DOTOMP_TEMP_1]], align 4
// CHECK1-NEXT:    [[TMP32:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[TMP31]], [[TMP32]]
// CHECK1-NEXT:    br i1 [[CMP]], label %[[COND_TRUE:.*]], label %[[COND_FALSE:.*]]
// CHECK1:       [[COND_TRUE]]:
// CHECK1-NEXT:    [[TMP33:%.*]] = load i32, ptr [[DOTOMP_TEMP_1]], align 4
// CHECK1-NEXT:    br label %[[COND_END:.*]]
// CHECK1:       [[COND_FALSE]]:
// CHECK1-NEXT:    [[TMP34:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK1-NEXT:    br label %[[COND_END]]
// CHECK1:       [[COND_END]]:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP33]], %[[COND_TRUE]] ], [ [[TMP34]], %[[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], ptr [[DOTOMP_TEMP_2]], align 4
// CHECK1-NEXT:    [[TMP35:%.*]] = load i32, ptr [[DOTOMP_TEMP_2]], align 4
// CHECK1-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_NI2]], align 4
// CHECK1-NEXT:    [[CMP29:%.*]] = icmp ugt i32 [[TMP35]], [[TMP36]]
// CHECK1-NEXT:    br i1 [[CMP29]], label %[[COND_TRUE30:.*]], label %[[COND_FALSE31:.*]]
// CHECK1:       [[COND_TRUE30]]:
// CHECK1-NEXT:    [[TMP37:%.*]] = load i32, ptr [[DOTOMP_TEMP_2]], align 4
// CHECK1-NEXT:    br label %[[COND_END32:.*]]
// CHECK1:       [[COND_FALSE31]]:
// CHECK1-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_NI2]], align 4
// CHECK1-NEXT:    br label %[[COND_END32]]
// CHECK1:       [[COND_END32]]:
// CHECK1-NEXT:    [[COND33:%.*]] = phi i32 [ [[TMP37]], %[[COND_TRUE30]] ], [ [[TMP38]], %[[COND_FALSE31]] ]
// CHECK1-NEXT:    store i32 [[COND33]], ptr [[DOTOMP_FUSE_MAX]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    br label %[[FOR_COND:.*]]
// CHECK1:       [[FOR_COND]]:
// CHECK1-NEXT:    [[TMP39:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_FUSE_MAX]], align 4
// CHECK1-NEXT:    [[CMP34:%.*]] = icmp ult i32 [[TMP39]], [[TMP40]]
// CHECK1-NEXT:    br i1 [[CMP34]], label %[[FOR_BODY:.*]], label %[[FOR_END:.*]]
// CHECK1:       [[FOR_BODY]]:
// CHECK1-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_NI0]], align 4
// CHECK1-NEXT:    [[CMP35:%.*]] = icmp ult i32 [[TMP41]], [[TMP42]]
// CHECK1-NEXT:    br i1 [[CMP35]], label %[[IF_THEN:.*]], label %[[IF_END:.*]]
// CHECK1:       [[IF_THEN]]:
// CHECK1-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_LB0]], align 4
// CHECK1-NEXT:    [[TMP44:%.*]] = load i32, ptr [[DOTOMP_ST0]], align 4
// CHECK1-NEXT:    [[TMP45:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul i32 [[TMP44]], [[TMP45]]
// CHECK1-NEXT:    [[ADD36:%.*]] = add i32 [[TMP43]], [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD36]], ptr [[DOTOMP_IV0]], align 4
// CHECK1-NEXT:    [[TMP46:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV0]], align 4
// CHECK1-NEXT:    [[TMP48:%.*]] = load i32, ptr [[DOTNEW_STEP]], align 4
// CHECK1-NEXT:    [[MUL37:%.*]] = mul i32 [[TMP47]], [[TMP48]]
// CHECK1-NEXT:    [[ADD38:%.*]] = add i32 [[TMP46]], [[MUL37]]
// CHECK1-NEXT:    store i32 [[ADD38]], ptr [[I]], align 4
// CHECK1-NEXT:    [[TMP49:%.*]] = load i32, ptr [[I]], align 4
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP49]])
// CHECK1-NEXT:    br label %[[IF_END]]
// CHECK1:       [[IF_END]]:
// CHECK1-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[TMP51:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK1-NEXT:    [[CMP39:%.*]] = icmp ult i32 [[TMP50]], [[TMP51]]
// CHECK1-NEXT:    br i1 [[CMP39]], label %[[IF_THEN40:.*]], label %[[IF_END45:.*]]
// CHECK1:       [[IF_THEN40]]:
// CHECK1-NEXT:    [[TMP52:%.*]] = load i32, ptr [[DOTOMP_LB1]], align 4
// CHECK1-NEXT:    [[TMP53:%.*]] = load i32, ptr [[DOTOMP_ST1]], align 4
// CHECK1-NEXT:    [[TMP54:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[MUL41:%.*]] = mul i32 [[TMP53]], [[TMP54]]
// CHECK1-NEXT:    [[ADD42:%.*]] = add i32 [[TMP52]], [[MUL41]]
// CHECK1-NEXT:    store i32 [[ADD42]], ptr [[DOTOMP_IV1]], align 4
// CHECK1-NEXT:    [[TMP55:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_6]], align 4
// CHECK1-NEXT:    [[TMP56:%.*]] = load i32, ptr [[DOTOMP_IV1]], align 4
// CHECK1-NEXT:    [[TMP57:%.*]] = load i32, ptr [[DOTNEW_STEP8]], align 4
// CHECK1-NEXT:    [[MUL43:%.*]] = mul i32 [[TMP56]], [[TMP57]]
// CHECK1-NEXT:    [[SUB44:%.*]] = sub i32 [[TMP55]], [[MUL43]]
// CHECK1-NEXT:    store i32 [[SUB44]], ptr [[J]], align 4
// CHECK1-NEXT:    [[TMP58:%.*]] = load i32, ptr [[J]], align 4
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP58]])
// CHECK1-NEXT:    br label %[[IF_END45]]
// CHECK1:       [[IF_END45]]:
// CHECK1-NEXT:    [[TMP59:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[TMP60:%.*]] = load i32, ptr [[DOTOMP_NI2]], align 4
// CHECK1-NEXT:    [[CMP46:%.*]] = icmp ult i32 [[TMP59]], [[TMP60]]
// CHECK1-NEXT:    br i1 [[CMP46]], label %[[IF_THEN47:.*]], label %[[IF_END52:.*]]
// CHECK1:       [[IF_THEN47]]:
// CHECK1-NEXT:    [[TMP61:%.*]] = load i32, ptr [[DOTOMP_LB2]], align 4
// CHECK1-NEXT:    [[TMP62:%.*]] = load i32, ptr [[DOTOMP_ST2]], align 4
// CHECK1-NEXT:    [[TMP63:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[MUL48:%.*]] = mul i32 [[TMP62]], [[TMP63]]
// CHECK1-NEXT:    [[ADD49:%.*]] = add i32 [[TMP61]], [[MUL48]]
// CHECK1-NEXT:    store i32 [[ADD49]], ptr [[DOTOMP_IV2]], align 4
// CHECK1-NEXT:    [[TMP64:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_17]], align 4
// CHECK1-NEXT:    [[TMP65:%.*]] = load i32, ptr [[DOTOMP_IV2]], align 4
// CHECK1-NEXT:    [[TMP66:%.*]] = load i32, ptr [[DOTNEW_STEP21]], align 4
// CHECK1-NEXT:    [[MUL50:%.*]] = mul i32 [[TMP65]], [[TMP66]]
// CHECK1-NEXT:    [[ADD51:%.*]] = add i32 [[TMP64]], [[MUL50]]
// CHECK1-NEXT:    store i32 [[ADD51]], ptr [[K]], align 4
// CHECK1-NEXT:    [[TMP67:%.*]] = load i32, ptr [[K]], align 4
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP67]])
// CHECK1-NEXT:    br label %[[IF_END52]]
// CHECK1:       [[IF_END52]]:
// CHECK1-NEXT:    br label %[[FOR_INC:.*]]
// CHECK1:       [[FOR_INC]]:
// CHECK1-NEXT:    [[TMP68:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[INC:%.*]] = add i32 [[TMP68]], 1
// CHECK1-NEXT:    store i32 [[INC]], ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    br label %[[FOR_COND]], !llvm.loop [[LOOP5:![0-9]+]]
// CHECK1:       [[FOR_END]]:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define dso_local void @foo3(
// CHECK1-SAME: ) #[[ATTR0]] {
// CHECK1-NEXT:  [[ENTRY:.*:]]
// CHECK1-NEXT:    [[ARR:%.*]] = alloca [256 x double], align 16
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB0:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_ST0:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_NI0:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IV0:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[J:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_ST1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_NI1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IV1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_TEMP_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_FUSE_MAX:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_FUSE_INDEX:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB03:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_ST04:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_NI05:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_IV06:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[C:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[__RANGE2:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[__END2:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[__BEGIN2:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_8:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_10:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_11:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_LB116:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_ST117:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_NI118:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_IV120:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[CC:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[__RANGE221:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[__END222:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[__BEGIN225:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_27:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_29:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_30:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_LB2:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_ST2:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_NI2:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_IV2:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_TEMP_140:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_TEMP_2:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_FUSE_MAX46:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_FUSE_INDEX52:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[V:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[VV:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store i32 0, ptr [[I]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_LB0]], align 4
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_ST0]], align 4
// CHECK1-NEXT:    store i32 128, ptr [[DOTOMP_NI0]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[J]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_LB1]], align 4
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_ST1]], align 4
// CHECK1-NEXT:    store i32 128, ptr [[DOTOMP_NI1]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[DOTOMP_NI0]], align 4
// CHECK1-NEXT:    store i32 [[TMP0]], ptr [[DOTOMP_TEMP_1]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[DOTOMP_TEMP_1]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP1]], [[TMP2]]
// CHECK1-NEXT:    br i1 [[CMP]], label %[[COND_TRUE:.*]], label %[[COND_FALSE:.*]]
// CHECK1:       [[COND_TRUE]]:
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTOMP_TEMP_1]], align 4
// CHECK1-NEXT:    br label %[[COND_END:.*]]
// CHECK1:       [[COND_FALSE]]:
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK1-NEXT:    br label %[[COND_END]]
// CHECK1:       [[COND_END]]:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP3]], %[[COND_TRUE]] ], [ [[TMP4]], %[[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], ptr [[DOTOMP_FUSE_MAX]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_FUSE_MAX]], align 4
// CHECK1-NEXT:    store i32 [[TMP5]], ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP6]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB2]], ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_LB03]], align 4
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_ST04]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP7]], 1
// CHECK1-NEXT:    [[CONV:%.*]] = sext i32 [[ADD]] to i64
// CHECK1-NEXT:    store i64 [[CONV]], ptr [[DOTOMP_NI05]], align 8
// CHECK1-NEXT:    store i32 42, ptr [[C]], align 4
// CHECK1-NEXT:    store ptr [[ARR]], ptr [[__RANGE2]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK1-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP8]], i64 0, i64 0
// CHECK1-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds double, ptr [[ARRAYDECAY]], i64 256
// CHECK1-NEXT:    store ptr [[ADD_PTR]], ptr [[__END2]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK1-NEXT:    [[ARRAYDECAY7:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP9]], i64 0, i64 0
// CHECK1-NEXT:    store ptr [[ARRAYDECAY7]], ptr [[__BEGIN2]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK1-NEXT:    [[ARRAYDECAY9:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP10]], i64 0, i64 0
// CHECK1-NEXT:    store ptr [[ARRAYDECAY9]], ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[__END2]], align 8
// CHECK1-NEXT:    store ptr [[TMP11]], ptr [[DOTCAPTURE_EXPR_10]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_10]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK1-NEXT:    [[SUB_PTR_LHS_CAST:%.*]] = ptrtoint ptr [[TMP12]] to i64
// CHECK1-NEXT:    [[SUB_PTR_RHS_CAST:%.*]] = ptrtoint ptr [[TMP13]] to i64
// CHECK1-NEXT:    [[SUB_PTR_SUB:%.*]] = sub i64 [[SUB_PTR_LHS_CAST]], [[SUB_PTR_RHS_CAST]]
// CHECK1-NEXT:    [[SUB_PTR_DIV:%.*]] = sdiv exact i64 [[SUB_PTR_SUB]], 8
// CHECK1-NEXT:    [[SUB12:%.*]] = sub nsw i64 [[SUB_PTR_DIV]], 1
// CHECK1-NEXT:    [[ADD13:%.*]] = add nsw i64 [[SUB12]], 1
// CHECK1-NEXT:    [[DIV14:%.*]] = sdiv i64 [[ADD13]], 1
// CHECK1-NEXT:    [[SUB15:%.*]] = sub nsw i64 [[DIV14]], 1
// CHECK1-NEXT:    store i64 [[SUB15]], ptr [[DOTCAPTURE_EXPR_11]], align 8
// CHECK1-NEXT:    store i64 0, ptr [[DOTOMP_LB116]], align 8
// CHECK1-NEXT:    store i64 1, ptr [[DOTOMP_ST117]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_11]], align 8
// CHECK1-NEXT:    [[ADD19:%.*]] = add nsw i64 [[TMP14]], 1
// CHECK1-NEXT:    store i64 [[ADD19]], ptr [[DOTOMP_NI118]], align 8
// CHECK1-NEXT:    store i32 37, ptr [[CC]], align 4
// CHECK1-NEXT:    store ptr [[ARR]], ptr [[__RANGE221]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[__RANGE221]], align 8
// CHECK1-NEXT:    [[ARRAYDECAY23:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP15]], i64 0, i64 0
// CHECK1-NEXT:    [[ADD_PTR24:%.*]] = getelementptr inbounds double, ptr [[ARRAYDECAY23]], i64 256
// CHECK1-NEXT:    store ptr [[ADD_PTR24]], ptr [[__END222]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[__RANGE221]], align 8
// CHECK1-NEXT:    [[ARRAYDECAY26:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP16]], i64 0, i64 0
// CHECK1-NEXT:    store ptr [[ARRAYDECAY26]], ptr [[__BEGIN225]], align 8
// CHECK1-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[__RANGE221]], align 8
// CHECK1-NEXT:    [[ARRAYDECAY28:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP17]], i64 0, i64 0
// CHECK1-NEXT:    store ptr [[ARRAYDECAY28]], ptr [[DOTCAPTURE_EXPR_27]], align 8
// CHECK1-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[__END222]], align 8
// CHECK1-NEXT:    store ptr [[TMP18]], ptr [[DOTCAPTURE_EXPR_29]], align 8
// CHECK1-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_29]], align 8
// CHECK1-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_27]], align 8
// CHECK1-NEXT:    [[SUB_PTR_LHS_CAST31:%.*]] = ptrtoint ptr [[TMP19]] to i64
// CHECK1-NEXT:    [[SUB_PTR_RHS_CAST32:%.*]] = ptrtoint ptr [[TMP20]] to i64
// CHECK1-NEXT:    [[SUB_PTR_SUB33:%.*]] = sub i64 [[SUB_PTR_LHS_CAST31]], [[SUB_PTR_RHS_CAST32]]
// CHECK1-NEXT:    [[SUB_PTR_DIV34:%.*]] = sdiv exact i64 [[SUB_PTR_SUB33]], 8
// CHECK1-NEXT:    [[SUB35:%.*]] = sub nsw i64 [[SUB_PTR_DIV34]], 1
// CHECK1-NEXT:    [[ADD36:%.*]] = add nsw i64 [[SUB35]], 1
// CHECK1-NEXT:    [[DIV37:%.*]] = sdiv i64 [[ADD36]], 1
// CHECK1-NEXT:    [[SUB38:%.*]] = sub nsw i64 [[DIV37]], 1
// CHECK1-NEXT:    store i64 [[SUB38]], ptr [[DOTCAPTURE_EXPR_30]], align 8
// CHECK1-NEXT:    store i64 0, ptr [[DOTOMP_LB2]], align 8
// CHECK1-NEXT:    store i64 1, ptr [[DOTOMP_ST2]], align 8
// CHECK1-NEXT:    [[TMP21:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_30]], align 8
// CHECK1-NEXT:    [[ADD39:%.*]] = add nsw i64 [[TMP21]], 1
// CHECK1-NEXT:    store i64 [[ADD39]], ptr [[DOTOMP_NI2]], align 8
// CHECK1-NEXT:    [[TMP22:%.*]] = load i64, ptr [[DOTOMP_NI05]], align 8
// CHECK1-NEXT:    store i64 [[TMP22]], ptr [[DOTOMP_TEMP_140]], align 8
// CHECK1-NEXT:    [[TMP23:%.*]] = load i64, ptr [[DOTOMP_TEMP_140]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = load i64, ptr [[DOTOMP_NI118]], align 8
// CHECK1-NEXT:    [[CMP41:%.*]] = icmp sgt i64 [[TMP23]], [[TMP24]]
// CHECK1-NEXT:    br i1 [[CMP41]], label %[[COND_TRUE42:.*]], label %[[COND_FALSE43:.*]]
// CHECK1:       [[COND_TRUE42]]:
// CHECK1-NEXT:    [[TMP25:%.*]] = load i64, ptr [[DOTOMP_TEMP_140]], align 8
// CHECK1-NEXT:    br label %[[COND_END44:.*]]
// CHECK1:       [[COND_FALSE43]]:
// CHECK1-NEXT:    [[TMP26:%.*]] = load i64, ptr [[DOTOMP_NI118]], align 8
// CHECK1-NEXT:    br label %[[COND_END44]]
// CHECK1:       [[COND_END44]]:
// CHECK1-NEXT:    [[COND45:%.*]] = phi i64 [ [[TMP25]], %[[COND_TRUE42]] ], [ [[TMP26]], %[[COND_FALSE43]] ]
// CHECK1-NEXT:    store i64 [[COND45]], ptr [[DOTOMP_TEMP_2]], align 8
// CHECK1-NEXT:    [[TMP27:%.*]] = load i64, ptr [[DOTOMP_TEMP_2]], align 8
// CHECK1-NEXT:    [[TMP28:%.*]] = load i64, ptr [[DOTOMP_NI2]], align 8
// CHECK1-NEXT:    [[CMP47:%.*]] = icmp sgt i64 [[TMP27]], [[TMP28]]
// CHECK1-NEXT:    br i1 [[CMP47]], label %[[COND_TRUE48:.*]], label %[[COND_FALSE49:.*]]
// CHECK1:       [[COND_TRUE48]]:
// CHECK1-NEXT:    [[TMP29:%.*]] = load i64, ptr [[DOTOMP_TEMP_2]], align 8
// CHECK1-NEXT:    br label %[[COND_END50:.*]]
// CHECK1:       [[COND_FALSE49]]:
// CHECK1-NEXT:    [[TMP30:%.*]] = load i64, ptr [[DOTOMP_NI2]], align 8
// CHECK1-NEXT:    br label %[[COND_END50]]
// CHECK1:       [[COND_END50]]:
// CHECK1-NEXT:    [[COND51:%.*]] = phi i64 [ [[TMP29]], %[[COND_TRUE48]] ], [ [[TMP30]], %[[COND_FALSE49]] ]
// CHECK1-NEXT:    store i64 [[COND51]], ptr [[DOTOMP_FUSE_MAX46]], align 8
// CHECK1-NEXT:    store i64 0, ptr [[DOTOMP_FUSE_INDEX52]], align 8
// CHECK1-NEXT:    br label %[[FOR_COND:.*]]
// CHECK1:       [[FOR_COND]]:
// CHECK1-NEXT:    [[TMP31:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX52]], align 8
// CHECK1-NEXT:    [[TMP32:%.*]] = load i64, ptr [[DOTOMP_FUSE_MAX46]], align 8
// CHECK1-NEXT:    [[CMP53:%.*]] = icmp slt i64 [[TMP31]], [[TMP32]]
// CHECK1-NEXT:    br i1 [[CMP53]], label %[[FOR_BODY:.*]], label %[[FOR_END:.*]]
// CHECK1:       [[FOR_BODY]]:
// CHECK1-NEXT:    [[TMP33:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX52]], align 8
// CHECK1-NEXT:    [[TMP34:%.*]] = load i64, ptr [[DOTOMP_NI05]], align 8
// CHECK1-NEXT:    [[CMP54:%.*]] = icmp slt i64 [[TMP33]], [[TMP34]]
// CHECK1-NEXT:    br i1 [[CMP54]], label %[[IF_THEN:.*]], label %[[IF_END74:.*]]
// CHECK1:       [[IF_THEN]]:
// CHECK1-NEXT:    [[TMP35:%.*]] = load i32, ptr [[DOTOMP_LB03]], align 4
// CHECK1-NEXT:    [[CONV55:%.*]] = sext i32 [[TMP35]] to i64
// CHECK1-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_ST04]], align 4
// CHECK1-NEXT:    [[CONV56:%.*]] = sext i32 [[TMP36]] to i64
// CHECK1-NEXT:    [[TMP37:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX52]], align 8
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i64 [[CONV56]], [[TMP37]]
// CHECK1-NEXT:    [[ADD57:%.*]] = add nsw i64 [[CONV55]], [[MUL]]
// CHECK1-NEXT:    [[CONV58:%.*]] = trunc i64 [[ADD57]] to i32
// CHECK1-NEXT:    store i32 [[CONV58]], ptr [[DOTOMP_IV06]], align 4
// CHECK1-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_IV06]], align 4
// CHECK1-NEXT:    [[MUL59:%.*]] = mul nsw i32 [[TMP38]], 1
// CHECK1-NEXT:    [[ADD60:%.*]] = add nsw i32 0, [[MUL59]]
// CHECK1-NEXT:    store i32 [[ADD60]], ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[TMP39:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_NI0]], align 4
// CHECK1-NEXT:    [[CMP61:%.*]] = icmp slt i32 [[TMP39]], [[TMP40]]
// CHECK1-NEXT:    br i1 [[CMP61]], label %[[IF_THEN62:.*]], label %[[IF_END:.*]]
// CHECK1:       [[IF_THEN62]]:
// CHECK1-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTOMP_LB0]], align 4
// CHECK1-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_ST0]], align 4
// CHECK1-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[MUL63:%.*]] = mul nsw i32 [[TMP42]], [[TMP43]]
// CHECK1-NEXT:    [[ADD64:%.*]] = add nsw i32 [[TMP41]], [[MUL63]]
// CHECK1-NEXT:    store i32 [[ADD64]], ptr [[DOTOMP_IV0]], align 4
// CHECK1-NEXT:    [[TMP44:%.*]] = load i32, ptr [[DOTOMP_IV0]], align 4
// CHECK1-NEXT:    [[MUL65:%.*]] = mul nsw i32 [[TMP44]], 1
// CHECK1-NEXT:    [[ADD66:%.*]] = add nsw i32 0, [[MUL65]]
// CHECK1-NEXT:    store i32 [[ADD66]], ptr [[I]], align 4
// CHECK1-NEXT:    [[TMP45:%.*]] = load i32, ptr [[I]], align 4
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP45]])
// CHECK1-NEXT:    br label %[[IF_END]]
// CHECK1:       [[IF_END]]:
// CHECK1-NEXT:    [[TMP46:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK1-NEXT:    [[CMP67:%.*]] = icmp slt i32 [[TMP46]], [[TMP47]]
// CHECK1-NEXT:    br i1 [[CMP67]], label %[[IF_THEN68:.*]], label %[[IF_END73:.*]]
// CHECK1:       [[IF_THEN68]]:
// CHECK1-NEXT:    [[TMP48:%.*]] = load i32, ptr [[DOTOMP_LB1]], align 4
// CHECK1-NEXT:    [[TMP49:%.*]] = load i32, ptr [[DOTOMP_ST1]], align 4
// CHECK1-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[MUL69:%.*]] = mul nsw i32 [[TMP49]], [[TMP50]]
// CHECK1-NEXT:    [[ADD70:%.*]] = add nsw i32 [[TMP48]], [[MUL69]]
// CHECK1-NEXT:    store i32 [[ADD70]], ptr [[DOTOMP_IV1]], align 4
// CHECK1-NEXT:    [[TMP51:%.*]] = load i32, ptr [[DOTOMP_IV1]], align 4
// CHECK1-NEXT:    [[MUL71:%.*]] = mul nsw i32 [[TMP51]], 2
// CHECK1-NEXT:    [[ADD72:%.*]] = add nsw i32 0, [[MUL71]]
// CHECK1-NEXT:    store i32 [[ADD72]], ptr [[J]], align 4
// CHECK1-NEXT:    [[TMP52:%.*]] = load i32, ptr [[J]], align 4
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP52]])
// CHECK1-NEXT:    br label %[[IF_END73]]
// CHECK1:       [[IF_END73]]:
// CHECK1-NEXT:    br label %[[IF_END74]]
// CHECK1:       [[IF_END74]]:
// CHECK1-NEXT:    [[TMP53:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX52]], align 8
// CHECK1-NEXT:    [[TMP54:%.*]] = load i64, ptr [[DOTOMP_NI118]], align 8
// CHECK1-NEXT:    [[CMP75:%.*]] = icmp slt i64 [[TMP53]], [[TMP54]]
// CHECK1-NEXT:    br i1 [[CMP75]], label %[[IF_THEN76:.*]], label %[[IF_END81:.*]]
// CHECK1:       [[IF_THEN76]]:
// CHECK1-NEXT:    [[TMP55:%.*]] = load i64, ptr [[DOTOMP_LB116]], align 8
// CHECK1-NEXT:    [[TMP56:%.*]] = load i64, ptr [[DOTOMP_ST117]], align 8
// CHECK1-NEXT:    [[TMP57:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX52]], align 8
// CHECK1-NEXT:    [[MUL77:%.*]] = mul nsw i64 [[TMP56]], [[TMP57]]
// CHECK1-NEXT:    [[ADD78:%.*]] = add nsw i64 [[TMP55]], [[MUL77]]
// CHECK1-NEXT:    store i64 [[ADD78]], ptr [[DOTOMP_IV120]], align 8
// CHECK1-NEXT:    [[TMP58:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK1-NEXT:    [[TMP59:%.*]] = load i64, ptr [[DOTOMP_IV120]], align 8
// CHECK1-NEXT:    [[MUL79:%.*]] = mul nsw i64 [[TMP59]], 1
// CHECK1-NEXT:    [[ADD_PTR80:%.*]] = getelementptr inbounds double, ptr [[TMP58]], i64 [[MUL79]]
// CHECK1-NEXT:    store ptr [[ADD_PTR80]], ptr [[__BEGIN2]], align 8
// CHECK1-NEXT:    [[TMP60:%.*]] = load ptr, ptr [[__BEGIN2]], align 8
// CHECK1-NEXT:    store ptr [[TMP60]], ptr [[V]], align 8
// CHECK1-NEXT:    [[TMP61:%.*]] = load i32, ptr [[C]], align 4
// CHECK1-NEXT:    [[TMP62:%.*]] = load ptr, ptr [[V]], align 8
// CHECK1-NEXT:    [[TMP63:%.*]] = load double, ptr [[TMP62]], align 8
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP61]], double noundef [[TMP63]])
// CHECK1-NEXT:    br label %[[IF_END81]]
// CHECK1:       [[IF_END81]]:
// CHECK1-NEXT:    [[TMP64:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX52]], align 8
// CHECK1-NEXT:    [[TMP65:%.*]] = load i64, ptr [[DOTOMP_NI2]], align 8
// CHECK1-NEXT:    [[CMP82:%.*]] = icmp slt i64 [[TMP64]], [[TMP65]]
// CHECK1-NEXT:    br i1 [[CMP82]], label %[[IF_THEN83:.*]], label %[[IF_END88:.*]]
// CHECK1:       [[IF_THEN83]]:
// CHECK1-NEXT:    [[TMP66:%.*]] = load i64, ptr [[DOTOMP_LB2]], align 8
// CHECK1-NEXT:    [[TMP67:%.*]] = load i64, ptr [[DOTOMP_ST2]], align 8
// CHECK1-NEXT:    [[TMP68:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX52]], align 8
// CHECK1-NEXT:    [[MUL84:%.*]] = mul nsw i64 [[TMP67]], [[TMP68]]
// CHECK1-NEXT:    [[ADD85:%.*]] = add nsw i64 [[TMP66]], [[MUL84]]
// CHECK1-NEXT:    store i64 [[ADD85]], ptr [[DOTOMP_IV2]], align 8
// CHECK1-NEXT:    [[TMP69:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_27]], align 8
// CHECK1-NEXT:    [[TMP70:%.*]] = load i64, ptr [[DOTOMP_IV2]], align 8
// CHECK1-NEXT:    [[MUL86:%.*]] = mul nsw i64 [[TMP70]], 1
// CHECK1-NEXT:    [[ADD_PTR87:%.*]] = getelementptr inbounds double, ptr [[TMP69]], i64 [[MUL86]]
// CHECK1-NEXT:    store ptr [[ADD_PTR87]], ptr [[__BEGIN225]], align 8
// CHECK1-NEXT:    [[TMP71:%.*]] = load ptr, ptr [[__BEGIN225]], align 8
// CHECK1-NEXT:    store ptr [[TMP71]], ptr [[VV]], align 8
// CHECK1-NEXT:    [[TMP72:%.*]] = load i32, ptr [[CC]], align 4
// CHECK1-NEXT:    [[TMP73:%.*]] = load ptr, ptr [[VV]], align 8
// CHECK1-NEXT:    [[TMP74:%.*]] = load double, ptr [[TMP73]], align 8
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP72]], double noundef [[TMP74]])
// CHECK1-NEXT:    br label %[[IF_END88]]
// CHECK1:       [[IF_END88]]:
// CHECK1-NEXT:    br label %[[FOR_INC:.*]]
// CHECK1:       [[FOR_INC]]:
// CHECK1-NEXT:    [[TMP75:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX52]], align 8
// CHECK1-NEXT:    [[INC:%.*]] = add nsw i64 [[TMP75]], 1
// CHECK1-NEXT:    store i64 [[INC]], ptr [[DOTOMP_FUSE_INDEX52]], align 8
// CHECK1-NEXT:    br label %[[FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK1:       [[FOR_END]]:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define dso_local void @foo4(
// CHECK1-SAME: ) #[[ATTR0]] {
// CHECK1-NEXT:  [[ENTRY:.*:]]
// CHECK1-NEXT:    [[ARR:%.*]] = alloca [256 x double], align 16
// CHECK1-NEXT:    [[J:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB0:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_ST0:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_NI0:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IV0:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[K:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_ST1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_NI1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IV1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_TEMP_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_FUSE_MAX:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_FUSE_INDEX:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[C:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[__RANGE2:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[__BEGIN2:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[__END2:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[V:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store i32 0, ptr [[J]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_LB0]], align 4
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_ST0]], align 4
// CHECK1-NEXT:    store i32 128, ptr [[DOTOMP_NI0]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[K]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_LB1]], align 4
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_ST1]], align 4
// CHECK1-NEXT:    store i32 64, ptr [[DOTOMP_NI1]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[DOTOMP_NI0]], align 4
// CHECK1-NEXT:    store i32 [[TMP0]], ptr [[DOTOMP_TEMP_1]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[DOTOMP_TEMP_1]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP1]], [[TMP2]]
// CHECK1-NEXT:    br i1 [[CMP]], label %[[COND_TRUE:.*]], label %[[COND_FALSE:.*]]
// CHECK1:       [[COND_TRUE]]:
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTOMP_TEMP_1]], align 4
// CHECK1-NEXT:    br label %[[COND_END:.*]]
// CHECK1:       [[COND_FALSE]]:
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK1-NEXT:    br label %[[COND_END]]
// CHECK1:       [[COND_END]]:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP3]], %[[COND_TRUE]] ], [ [[TMP4]], %[[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], ptr [[DOTOMP_FUSE_MAX]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[I]], align 4
// CHECK1-NEXT:    br label %[[FOR_COND:.*]]
// CHECK1:       [[FOR_COND]]:
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, ptr [[I]], align 4
// CHECK1-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[TMP5]], 128
// CHECK1-NEXT:    br i1 [[CMP1]], label %[[FOR_BODY:.*]], label %[[FOR_END:.*]]
// CHECK1:       [[FOR_BODY]]:
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, ptr [[I]], align 4
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP6]])
// CHECK1-NEXT:    br label %[[FOR_INC:.*]]
// CHECK1:       [[FOR_INC]]:
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, ptr [[I]], align 4
// CHECK1-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP7]], 1
// CHECK1-NEXT:    store i32 [[INC]], ptr [[I]], align 4
// CHECK1-NEXT:    br label %[[FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK1:       [[FOR_END]]:
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    br label %[[FOR_COND2:.*]]
// CHECK1:       [[FOR_COND2]]:
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_FUSE_MAX]], align 4
// CHECK1-NEXT:    [[CMP3:%.*]] = icmp slt i32 [[TMP8]], [[TMP9]]
// CHECK1-NEXT:    br i1 [[CMP3]], label %[[FOR_BODY4:.*]], label %[[FOR_END17:.*]]
// CHECK1:       [[FOR_BODY4]]:
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_NI0]], align 4
// CHECK1-NEXT:    [[CMP5:%.*]] = icmp slt i32 [[TMP10]], [[TMP11]]
// CHECK1-NEXT:    br i1 [[CMP5]], label %[[IF_THEN:.*]], label %[[IF_END:.*]]
// CHECK1:       [[IF_THEN]]:
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_LB0]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_ST0]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP13]], [[TMP14]]
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP12]], [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], ptr [[DOTOMP_IV0]], align 4
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV0]], align 4
// CHECK1-NEXT:    [[MUL6:%.*]] = mul nsw i32 [[TMP15]], 2
// CHECK1-NEXT:    [[ADD7:%.*]] = add nsw i32 0, [[MUL6]]
// CHECK1-NEXT:    store i32 [[ADD7]], ptr [[J]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, ptr [[J]], align 4
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP16]])
// CHECK1-NEXT:    br label %[[IF_END]]
// CHECK1:       [[IF_END]]:
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK1-NEXT:    [[CMP8:%.*]] = icmp slt i32 [[TMP17]], [[TMP18]]
// CHECK1-NEXT:    br i1 [[CMP8]], label %[[IF_THEN9:.*]], label %[[IF_END14:.*]]
// CHECK1:       [[IF_THEN9]]:
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_LB1]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, ptr [[DOTOMP_ST1]], align 4
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[MUL10:%.*]] = mul nsw i32 [[TMP20]], [[TMP21]]
// CHECK1-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP19]], [[MUL10]]
// CHECK1-NEXT:    store i32 [[ADD11]], ptr [[DOTOMP_IV1]], align 4
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTOMP_IV1]], align 4
// CHECK1-NEXT:    [[MUL12:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK1-NEXT:    [[ADD13:%.*]] = add nsw i32 0, [[MUL12]]
// CHECK1-NEXT:    store i32 [[ADD13]], ptr [[K]], align 4
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32, ptr [[K]], align 4
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP23]])
// CHECK1-NEXT:    br label %[[IF_END14]]
// CHECK1:       [[IF_END14]]:
// CHECK1-NEXT:    br label %[[FOR_INC15:.*]]
// CHECK1:       [[FOR_INC15]]:
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[INC16:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK1-NEXT:    store i32 [[INC16]], ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    br label %[[FOR_COND2]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK1:       [[FOR_END17]]:
// CHECK1-NEXT:    store i32 42, ptr [[C]], align 4
// CHECK1-NEXT:    store ptr [[ARR]], ptr [[__RANGE2]], align 8
// CHECK1-NEXT:    [[TMP25:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK1-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP25]], i64 0, i64 0
// CHECK1-NEXT:    store ptr [[ARRAYDECAY]], ptr [[__BEGIN2]], align 8
// CHECK1-NEXT:    [[TMP26:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK1-NEXT:    [[ARRAYDECAY18:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP26]], i64 0, i64 0
// CHECK1-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds double, ptr [[ARRAYDECAY18]], i64 256
// CHECK1-NEXT:    store ptr [[ADD_PTR]], ptr [[__END2]], align 8
// CHECK1-NEXT:    br label %[[FOR_COND19:.*]]
// CHECK1:       [[FOR_COND19]]:
// CHECK1-NEXT:    [[TMP27:%.*]] = load ptr, ptr [[__BEGIN2]], align 8
// CHECK1-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[__END2]], align 8
// CHECK1-NEXT:    [[CMP20:%.*]] = icmp ne ptr [[TMP27]], [[TMP28]]
// CHECK1-NEXT:    br i1 [[CMP20]], label %[[FOR_BODY21:.*]], label %[[FOR_END23:.*]]
// CHECK1:       [[FOR_BODY21]]:
// CHECK1-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[__BEGIN2]], align 8
// CHECK1-NEXT:    store ptr [[TMP29]], ptr [[V]], align 8
// CHECK1-NEXT:    [[TMP30:%.*]] = load i32, ptr [[C]], align 4
// CHECK1-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[V]], align 8
// CHECK1-NEXT:    [[TMP32:%.*]] = load double, ptr [[TMP31]], align 8
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP30]], double noundef [[TMP32]])
// CHECK1-NEXT:    br label %[[FOR_INC22:.*]]
// CHECK1:       [[FOR_INC22]]:
// CHECK1-NEXT:    [[TMP33:%.*]] = load ptr, ptr [[__BEGIN2]], align 8
// CHECK1-NEXT:    [[INCDEC_PTR:%.*]] = getelementptr inbounds nuw double, ptr [[TMP33]], i32 1
// CHECK1-NEXT:    store ptr [[INCDEC_PTR]], ptr [[__BEGIN2]], align 8
// CHECK1-NEXT:    br label %[[FOR_COND19]]
// CHECK1:       [[FOR_END23]]:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define dso_local void @foo5(
// CHECK1-SAME: ) #[[ATTR0]] {
// CHECK1-NEXT:  [[ENTRY:.*:]]
// CHECK1-NEXT:    [[ARR:%.*]] = alloca [256 x double], align 16
// CHECK1-NEXT:    [[J:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB0:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_ST0:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_NI0:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IV0:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[K:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_ST1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_NI1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IV1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_TEMP_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_FUSE_MAX:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_FUSE_INDEX:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB03:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_ST04:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_NI05:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_IV06:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[C:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[__RANGE2:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[__END2:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[__BEGIN2:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_8:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_10:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_11:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_LB116:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_ST117:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_NI118:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_IV120:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_TEMP_121:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_FUSE_MAX22:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_FUSE_INDEX29:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[V:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[CC:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[__RANGE264:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[__BEGIN265:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[__END267:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[VV:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store i32 0, ptr [[J]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_LB0]], align 4
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_ST0]], align 4
// CHECK1-NEXT:    store i32 128, ptr [[DOTOMP_NI0]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[K]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_LB1]], align 4
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_ST1]], align 4
// CHECK1-NEXT:    store i32 512, ptr [[DOTOMP_NI1]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[DOTOMP_NI0]], align 4
// CHECK1-NEXT:    store i32 [[TMP0]], ptr [[DOTOMP_TEMP_1]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[DOTOMP_TEMP_1]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP1]], [[TMP2]]
// CHECK1-NEXT:    br i1 [[CMP]], label %[[COND_TRUE:.*]], label %[[COND_FALSE:.*]]
// CHECK1:       [[COND_TRUE]]:
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTOMP_TEMP_1]], align 4
// CHECK1-NEXT:    br label %[[COND_END:.*]]
// CHECK1:       [[COND_FALSE]]:
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK1-NEXT:    br label %[[COND_END]]
// CHECK1:       [[COND_END]]:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP3]], %[[COND_TRUE]] ], [ [[TMP4]], %[[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], ptr [[DOTOMP_FUSE_MAX]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_FUSE_MAX]], align 4
// CHECK1-NEXT:    store i32 [[TMP5]], ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP6]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB2]], ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_LB03]], align 4
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_ST04]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP7]], 1
// CHECK1-NEXT:    [[CONV:%.*]] = sext i32 [[ADD]] to i64
// CHECK1-NEXT:    store i64 [[CONV]], ptr [[DOTOMP_NI05]], align 8
// CHECK1-NEXT:    store i32 42, ptr [[C]], align 4
// CHECK1-NEXT:    store ptr [[ARR]], ptr [[__RANGE2]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK1-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP8]], i64 0, i64 0
// CHECK1-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds double, ptr [[ARRAYDECAY]], i64 256
// CHECK1-NEXT:    store ptr [[ADD_PTR]], ptr [[__END2]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK1-NEXT:    [[ARRAYDECAY7:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP9]], i64 0, i64 0
// CHECK1-NEXT:    store ptr [[ARRAYDECAY7]], ptr [[__BEGIN2]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK1-NEXT:    [[ARRAYDECAY9:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP10]], i64 0, i64 0
// CHECK1-NEXT:    store ptr [[ARRAYDECAY9]], ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[__END2]], align 8
// CHECK1-NEXT:    store ptr [[TMP11]], ptr [[DOTCAPTURE_EXPR_10]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_10]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK1-NEXT:    [[SUB_PTR_LHS_CAST:%.*]] = ptrtoint ptr [[TMP12]] to i64
// CHECK1-NEXT:    [[SUB_PTR_RHS_CAST:%.*]] = ptrtoint ptr [[TMP13]] to i64
// CHECK1-NEXT:    [[SUB_PTR_SUB:%.*]] = sub i64 [[SUB_PTR_LHS_CAST]], [[SUB_PTR_RHS_CAST]]
// CHECK1-NEXT:    [[SUB_PTR_DIV:%.*]] = sdiv exact i64 [[SUB_PTR_SUB]], 8
// CHECK1-NEXT:    [[SUB12:%.*]] = sub nsw i64 [[SUB_PTR_DIV]], 1
// CHECK1-NEXT:    [[ADD13:%.*]] = add nsw i64 [[SUB12]], 1
// CHECK1-NEXT:    [[DIV14:%.*]] = sdiv i64 [[ADD13]], 1
// CHECK1-NEXT:    [[SUB15:%.*]] = sub nsw i64 [[DIV14]], 1
// CHECK1-NEXT:    store i64 [[SUB15]], ptr [[DOTCAPTURE_EXPR_11]], align 8
// CHECK1-NEXT:    store i64 0, ptr [[DOTOMP_LB116]], align 8
// CHECK1-NEXT:    store i64 1, ptr [[DOTOMP_ST117]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_11]], align 8
// CHECK1-NEXT:    [[ADD19:%.*]] = add nsw i64 [[TMP14]], 1
// CHECK1-NEXT:    store i64 [[ADD19]], ptr [[DOTOMP_NI118]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = load i64, ptr [[DOTOMP_NI05]], align 8
// CHECK1-NEXT:    store i64 [[TMP15]], ptr [[DOTOMP_TEMP_121]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = load i64, ptr [[DOTOMP_TEMP_121]], align 8
// CHECK1-NEXT:    [[TMP17:%.*]] = load i64, ptr [[DOTOMP_NI118]], align 8
// CHECK1-NEXT:    [[CMP23:%.*]] = icmp sgt i64 [[TMP16]], [[TMP17]]
// CHECK1-NEXT:    br i1 [[CMP23]], label %[[COND_TRUE24:.*]], label %[[COND_FALSE25:.*]]
// CHECK1:       [[COND_TRUE24]]:
// CHECK1-NEXT:    [[TMP18:%.*]] = load i64, ptr [[DOTOMP_TEMP_121]], align 8
// CHECK1-NEXT:    br label %[[COND_END26:.*]]
// CHECK1:       [[COND_FALSE25]]:
// CHECK1-NEXT:    [[TMP19:%.*]] = load i64, ptr [[DOTOMP_NI118]], align 8
// CHECK1-NEXT:    br label %[[COND_END26]]
// CHECK1:       [[COND_END26]]:
// CHECK1-NEXT:    [[COND27:%.*]] = phi i64 [ [[TMP18]], %[[COND_TRUE24]] ], [ [[TMP19]], %[[COND_FALSE25]] ]
// CHECK1-NEXT:    store i64 [[COND27]], ptr [[DOTOMP_FUSE_MAX22]], align 8
// CHECK1-NEXT:    store i32 0, ptr [[I]], align 4
// CHECK1-NEXT:    br label %[[FOR_COND:.*]]
// CHECK1:       [[FOR_COND]]:
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, ptr [[I]], align 4
// CHECK1-NEXT:    [[CMP28:%.*]] = icmp slt i32 [[TMP20]], 128
// CHECK1-NEXT:    br i1 [[CMP28]], label %[[FOR_BODY:.*]], label %[[FOR_END:.*]]
// CHECK1:       [[FOR_BODY]]:
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, ptr [[I]], align 4
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP21]])
// CHECK1-NEXT:    br label %[[FOR_INC:.*]]
// CHECK1:       [[FOR_INC]]:
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, ptr [[I]], align 4
// CHECK1-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP22]], 1
// CHECK1-NEXT:    store i32 [[INC]], ptr [[I]], align 4
// CHECK1-NEXT:    br label %[[FOR_COND]], !llvm.loop [[LOOP9:![0-9]+]]
// CHECK1:       [[FOR_END]]:
// CHECK1-NEXT:    store i64 0, ptr [[DOTOMP_FUSE_INDEX29]], align 8
// CHECK1-NEXT:    br label %[[FOR_COND30:.*]]
// CHECK1:       [[FOR_COND30]]:
// CHECK1-NEXT:    [[TMP23:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX29]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = load i64, ptr [[DOTOMP_FUSE_MAX22]], align 8
// CHECK1-NEXT:    [[CMP31:%.*]] = icmp slt i64 [[TMP23]], [[TMP24]]
// CHECK1-NEXT:    br i1 [[CMP31]], label %[[FOR_BODY32:.*]], label %[[FOR_END63:.*]]
// CHECK1:       [[FOR_BODY32]]:
// CHECK1-NEXT:    [[TMP25:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX29]], align 8
// CHECK1-NEXT:    [[TMP26:%.*]] = load i64, ptr [[DOTOMP_NI05]], align 8
// CHECK1-NEXT:    [[CMP33:%.*]] = icmp slt i64 [[TMP25]], [[TMP26]]
// CHECK1-NEXT:    br i1 [[CMP33]], label %[[IF_THEN:.*]], label %[[IF_END53:.*]]
// CHECK1:       [[IF_THEN]]:
// CHECK1-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_LB03]], align 4
// CHECK1-NEXT:    [[CONV34:%.*]] = sext i32 [[TMP27]] to i64
// CHECK1-NEXT:    [[TMP28:%.*]] = load i32, ptr [[DOTOMP_ST04]], align 4
// CHECK1-NEXT:    [[CONV35:%.*]] = sext i32 [[TMP28]] to i64
// CHECK1-NEXT:    [[TMP29:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX29]], align 8
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i64 [[CONV35]], [[TMP29]]
// CHECK1-NEXT:    [[ADD36:%.*]] = add nsw i64 [[CONV34]], [[MUL]]
// CHECK1-NEXT:    [[CONV37:%.*]] = trunc i64 [[ADD36]] to i32
// CHECK1-NEXT:    store i32 [[CONV37]], ptr [[DOTOMP_IV06]], align 4
// CHECK1-NEXT:    [[TMP30:%.*]] = load i32, ptr [[DOTOMP_IV06]], align 4
// CHECK1-NEXT:    [[MUL38:%.*]] = mul nsw i32 [[TMP30]], 1
// CHECK1-NEXT:    [[ADD39:%.*]] = add nsw i32 0, [[MUL38]]
// CHECK1-NEXT:    store i32 [[ADD39]], ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[TMP31:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[TMP32:%.*]] = load i32, ptr [[DOTOMP_NI0]], align 4
// CHECK1-NEXT:    [[CMP40:%.*]] = icmp slt i32 [[TMP31]], [[TMP32]]
// CHECK1-NEXT:    br i1 [[CMP40]], label %[[IF_THEN41:.*]], label %[[IF_END:.*]]
// CHECK1:       [[IF_THEN41]]:
// CHECK1-NEXT:    [[TMP33:%.*]] = load i32, ptr [[DOTOMP_LB0]], align 4
// CHECK1-NEXT:    [[TMP34:%.*]] = load i32, ptr [[DOTOMP_ST0]], align 4
// CHECK1-NEXT:    [[TMP35:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[MUL42:%.*]] = mul nsw i32 [[TMP34]], [[TMP35]]
// CHECK1-NEXT:    [[ADD43:%.*]] = add nsw i32 [[TMP33]], [[MUL42]]
// CHECK1-NEXT:    store i32 [[ADD43]], ptr [[DOTOMP_IV0]], align 4
// CHECK1-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV0]], align 4
// CHECK1-NEXT:    [[MUL44:%.*]] = mul nsw i32 [[TMP36]], 2
// CHECK1-NEXT:    [[ADD45:%.*]] = add nsw i32 0, [[MUL44]]
// CHECK1-NEXT:    store i32 [[ADD45]], ptr [[J]], align 4
// CHECK1-NEXT:    [[TMP37:%.*]] = load i32, ptr [[J]], align 4
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP37]])
// CHECK1-NEXT:    br label %[[IF_END]]
// CHECK1:       [[IF_END]]:
// CHECK1-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[TMP39:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK1-NEXT:    [[CMP46:%.*]] = icmp slt i32 [[TMP38]], [[TMP39]]
// CHECK1-NEXT:    br i1 [[CMP46]], label %[[IF_THEN47:.*]], label %[[IF_END52:.*]]
// CHECK1:       [[IF_THEN47]]:
// CHECK1-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_LB1]], align 4
// CHECK1-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTOMP_ST1]], align 4
// CHECK1-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK1-NEXT:    [[MUL48:%.*]] = mul nsw i32 [[TMP41]], [[TMP42]]
// CHECK1-NEXT:    [[ADD49:%.*]] = add nsw i32 [[TMP40]], [[MUL48]]
// CHECK1-NEXT:    store i32 [[ADD49]], ptr [[DOTOMP_IV1]], align 4
// CHECK1-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_IV1]], align 4
// CHECK1-NEXT:    [[MUL50:%.*]] = mul nsw i32 [[TMP43]], 1
// CHECK1-NEXT:    [[ADD51:%.*]] = add nsw i32 0, [[MUL50]]
// CHECK1-NEXT:    store i32 [[ADD51]], ptr [[K]], align 4
// CHECK1-NEXT:    [[TMP44:%.*]] = load i32, ptr [[K]], align 4
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP44]])
// CHECK1-NEXT:    br label %[[IF_END52]]
// CHECK1:       [[IF_END52]]:
// CHECK1-NEXT:    br label %[[IF_END53]]
// CHECK1:       [[IF_END53]]:
// CHECK1-NEXT:    [[TMP45:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX29]], align 8
// CHECK1-NEXT:    [[TMP46:%.*]] = load i64, ptr [[DOTOMP_NI118]], align 8
// CHECK1-NEXT:    [[CMP54:%.*]] = icmp slt i64 [[TMP45]], [[TMP46]]
// CHECK1-NEXT:    br i1 [[CMP54]], label %[[IF_THEN55:.*]], label %[[IF_END60:.*]]
// CHECK1:       [[IF_THEN55]]:
// CHECK1-NEXT:    [[TMP47:%.*]] = load i64, ptr [[DOTOMP_LB116]], align 8
// CHECK1-NEXT:    [[TMP48:%.*]] = load i64, ptr [[DOTOMP_ST117]], align 8
// CHECK1-NEXT:    [[TMP49:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX29]], align 8
// CHECK1-NEXT:    [[MUL56:%.*]] = mul nsw i64 [[TMP48]], [[TMP49]]
// CHECK1-NEXT:    [[ADD57:%.*]] = add nsw i64 [[TMP47]], [[MUL56]]
// CHECK1-NEXT:    store i64 [[ADD57]], ptr [[DOTOMP_IV120]], align 8
// CHECK1-NEXT:    [[TMP50:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK1-NEXT:    [[TMP51:%.*]] = load i64, ptr [[DOTOMP_IV120]], align 8
// CHECK1-NEXT:    [[MUL58:%.*]] = mul nsw i64 [[TMP51]], 1
// CHECK1-NEXT:    [[ADD_PTR59:%.*]] = getelementptr inbounds double, ptr [[TMP50]], i64 [[MUL58]]
// CHECK1-NEXT:    store ptr [[ADD_PTR59]], ptr [[__BEGIN2]], align 8
// CHECK1-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[__BEGIN2]], align 8
// CHECK1-NEXT:    store ptr [[TMP52]], ptr [[V]], align 8
// CHECK1-NEXT:    [[TMP53:%.*]] = load i32, ptr [[C]], align 4
// CHECK1-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[V]], align 8
// CHECK1-NEXT:    [[TMP55:%.*]] = load double, ptr [[TMP54]], align 8
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP53]], double noundef [[TMP55]])
// CHECK1-NEXT:    br label %[[IF_END60]]
// CHECK1:       [[IF_END60]]:
// CHECK1-NEXT:    br label %[[FOR_INC61:.*]]
// CHECK1:       [[FOR_INC61]]:
// CHECK1-NEXT:    [[TMP56:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX29]], align 8
// CHECK1-NEXT:    [[INC62:%.*]] = add nsw i64 [[TMP56]], 1
// CHECK1-NEXT:    store i64 [[INC62]], ptr [[DOTOMP_FUSE_INDEX29]], align 8
// CHECK1-NEXT:    br label %[[FOR_COND30]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK1:       [[FOR_END63]]:
// CHECK1-NEXT:    store i32 37, ptr [[CC]], align 4
// CHECK1-NEXT:    store ptr [[ARR]], ptr [[__RANGE264]], align 8
// CHECK1-NEXT:    [[TMP57:%.*]] = load ptr, ptr [[__RANGE264]], align 8
// CHECK1-NEXT:    [[ARRAYDECAY66:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP57]], i64 0, i64 0
// CHECK1-NEXT:    store ptr [[ARRAYDECAY66]], ptr [[__BEGIN265]], align 8
// CHECK1-NEXT:    [[TMP58:%.*]] = load ptr, ptr [[__RANGE264]], align 8
// CHECK1-NEXT:    [[ARRAYDECAY68:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP58]], i64 0, i64 0
// CHECK1-NEXT:    [[ADD_PTR69:%.*]] = getelementptr inbounds double, ptr [[ARRAYDECAY68]], i64 256
// CHECK1-NEXT:    store ptr [[ADD_PTR69]], ptr [[__END267]], align 8
// CHECK1-NEXT:    br label %[[FOR_COND70:.*]]
// CHECK1:       [[FOR_COND70]]:
// CHECK1-NEXT:    [[TMP59:%.*]] = load ptr, ptr [[__BEGIN265]], align 8
// CHECK1-NEXT:    [[TMP60:%.*]] = load ptr, ptr [[__END267]], align 8
// CHECK1-NEXT:    [[CMP71:%.*]] = icmp ne ptr [[TMP59]], [[TMP60]]
// CHECK1-NEXT:    br i1 [[CMP71]], label %[[FOR_BODY72:.*]], label %[[FOR_END74:.*]]
// CHECK1:       [[FOR_BODY72]]:
// CHECK1-NEXT:    [[TMP61:%.*]] = load ptr, ptr [[__BEGIN265]], align 8
// CHECK1-NEXT:    store ptr [[TMP61]], ptr [[VV]], align 8
// CHECK1-NEXT:    [[TMP62:%.*]] = load i32, ptr [[CC]], align 4
// CHECK1-NEXT:    [[TMP63:%.*]] = load ptr, ptr [[VV]], align 8
// CHECK1-NEXT:    [[TMP64:%.*]] = load double, ptr [[TMP63]], align 8
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP62]], double noundef [[TMP64]])
// CHECK1-NEXT:    br label %[[FOR_INC73:.*]]
// CHECK1:       [[FOR_INC73]]:
// CHECK1-NEXT:    [[TMP65:%.*]] = load ptr, ptr [[__BEGIN265]], align 8
// CHECK1-NEXT:    [[INCDEC_PTR:%.*]] = getelementptr inbounds nuw double, ptr [[TMP65]], i32 1
// CHECK1-NEXT:    store ptr [[INCDEC_PTR]], ptr [[__BEGIN265]], align 8
// CHECK1-NEXT:    br label %[[FOR_COND70]]
// CHECK1:       [[FOR_END74]]:
// CHECK1-NEXT:    ret void
//
//
// CHECK2-LABEL: define dso_local void @body(
// CHECK2-SAME: ...) #[[ATTR0:[0-9]+]] {
// CHECK2-NEXT:  [[ENTRY:.*:]]
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define dso_local void @foo1(
// CHECK2-SAME: i32 noundef [[START1:%.*]], i32 noundef [[END1:%.*]], i32 noundef [[STEP1:%.*]], i32 noundef [[START2:%.*]], i32 noundef [[END2:%.*]], i32 noundef [[STEP2:%.*]]) #[[ATTR0]] {
// CHECK2-NEXT:  [[ENTRY:.*:]]
// CHECK2-NEXT:    [[START1_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[END1_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[STEP1_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[START2_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[END2_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[STEP2_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[J:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTNEW_STEP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB0:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_ST0:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_NI0:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IV0:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_6:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_7:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTNEW_STEP8:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_9:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_ST1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_NI1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IV1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_TEMP_1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_FUSE_MAX:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_FUSE_INDEX:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store i32 [[START1]], ptr [[START1_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[END1]], ptr [[END1_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[STEP1]], ptr [[STEP1_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[START2]], ptr [[START2_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[END2]], ptr [[END2_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[STEP2]], ptr [[STEP2_ADDR]], align 4
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[START1_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP0]], ptr [[I]], align 4
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32, ptr [[START1_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP1]], ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, ptr [[END1_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP2]], ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, ptr [[STEP1_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP3]], ptr [[DOTNEW_STEP]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[SUB:%.*]] = sub i32 [[TMP4]], [[TMP5]]
// CHECK2-NEXT:    [[SUB3:%.*]] = sub i32 [[SUB]], 1
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTNEW_STEP]], align 4
// CHECK2-NEXT:    [[ADD:%.*]] = add i32 [[SUB3]], [[TMP6]]
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTNEW_STEP]], align 4
// CHECK2-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], [[TMP7]]
// CHECK2-NEXT:    [[SUB4:%.*]] = sub i32 [[DIV]], 1
// CHECK2-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_LB0]], align 4
// CHECK2-NEXT:    store i32 1, ptr [[DOTOMP_ST0]], align 4
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK2-NEXT:    [[ADD5:%.*]] = add i32 [[TMP8]], 1
// CHECK2-NEXT:    store i32 [[ADD5]], ptr [[DOTOMP_NI0]], align 4
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, ptr [[START2_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP9]], ptr [[J]], align 4
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, ptr [[START2_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP10]], ptr [[DOTCAPTURE_EXPR_6]], align 4
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, ptr [[END2_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP11]], ptr [[DOTCAPTURE_EXPR_7]], align 4
// CHECK2-NEXT:    [[TMP12:%.*]] = load i32, ptr [[STEP2_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP12]], ptr [[DOTNEW_STEP8]], align 4
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_7]], align 4
// CHECK2-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_6]], align 4
// CHECK2-NEXT:    [[SUB10:%.*]] = sub i32 [[TMP13]], [[TMP14]]
// CHECK2-NEXT:    [[SUB11:%.*]] = sub i32 [[SUB10]], 1
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTNEW_STEP8]], align 4
// CHECK2-NEXT:    [[ADD12:%.*]] = add i32 [[SUB11]], [[TMP15]]
// CHECK2-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTNEW_STEP8]], align 4
// CHECK2-NEXT:    [[DIV13:%.*]] = udiv i32 [[ADD12]], [[TMP16]]
// CHECK2-NEXT:    [[SUB14:%.*]] = sub i32 [[DIV13]], 1
// CHECK2-NEXT:    store i32 [[SUB14]], ptr [[DOTCAPTURE_EXPR_9]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_LB1]], align 4
// CHECK2-NEXT:    store i32 1, ptr [[DOTOMP_ST1]], align 4
// CHECK2-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_9]], align 4
// CHECK2-NEXT:    [[ADD15:%.*]] = add i32 [[TMP17]], 1
// CHECK2-NEXT:    store i32 [[ADD15]], ptr [[DOTOMP_NI1]], align 4
// CHECK2-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_NI0]], align 4
// CHECK2-NEXT:    store i32 [[TMP18]], ptr [[DOTOMP_TEMP_1]], align 4
// CHECK2-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_TEMP_1]], align 4
// CHECK2-NEXT:    [[TMP20:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[TMP19]], [[TMP20]]
// CHECK2-NEXT:    br i1 [[CMP]], label %[[COND_TRUE:.*]], label %[[COND_FALSE:.*]]
// CHECK2:       [[COND_TRUE]]:
// CHECK2-NEXT:    [[TMP21:%.*]] = load i32, ptr [[DOTOMP_TEMP_1]], align 4
// CHECK2-NEXT:    br label %[[COND_END:.*]]
// CHECK2:       [[COND_FALSE]]:
// CHECK2-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK2-NEXT:    br label %[[COND_END]]
// CHECK2:       [[COND_END]]:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP21]], %[[COND_TRUE]] ], [ [[TMP22]], %[[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], ptr [[DOTOMP_FUSE_MAX]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    br label %[[FOR_COND:.*]]
// CHECK2:       [[FOR_COND]]:
// CHECK2-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[TMP24:%.*]] = load i32, ptr [[DOTOMP_FUSE_MAX]], align 4
// CHECK2-NEXT:    [[CMP16:%.*]] = icmp ult i32 [[TMP23]], [[TMP24]]
// CHECK2-NEXT:    br i1 [[CMP16]], label %[[FOR_BODY:.*]], label %[[FOR_END:.*]]
// CHECK2:       [[FOR_BODY]]:
// CHECK2-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTOMP_NI0]], align 4
// CHECK2-NEXT:    [[CMP17:%.*]] = icmp ult i32 [[TMP25]], [[TMP26]]
// CHECK2-NEXT:    br i1 [[CMP17]], label %[[IF_THEN:.*]], label %[[IF_END:.*]]
// CHECK2:       [[IF_THEN]]:
// CHECK2-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_LB0]], align 4
// CHECK2-NEXT:    [[TMP28:%.*]] = load i32, ptr [[DOTOMP_ST0]], align 4
// CHECK2-NEXT:    [[TMP29:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[MUL:%.*]] = mul i32 [[TMP28]], [[TMP29]]
// CHECK2-NEXT:    [[ADD18:%.*]] = add i32 [[TMP27]], [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD18]], ptr [[DOTOMP_IV0]], align 4
// CHECK2-NEXT:    [[TMP30:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[TMP31:%.*]] = load i32, ptr [[DOTOMP_IV0]], align 4
// CHECK2-NEXT:    [[TMP32:%.*]] = load i32, ptr [[DOTNEW_STEP]], align 4
// CHECK2-NEXT:    [[MUL19:%.*]] = mul i32 [[TMP31]], [[TMP32]]
// CHECK2-NEXT:    [[ADD20:%.*]] = add i32 [[TMP30]], [[MUL19]]
// CHECK2-NEXT:    store i32 [[ADD20]], ptr [[I]], align 4
// CHECK2-NEXT:    [[TMP33:%.*]] = load i32, ptr [[I]], align 4
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP33]])
// CHECK2-NEXT:    br label %[[IF_END]]
// CHECK2:       [[IF_END]]:
// CHECK2-NEXT:    [[TMP34:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[TMP35:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK2-NEXT:    [[CMP21:%.*]] = icmp ult i32 [[TMP34]], [[TMP35]]
// CHECK2-NEXT:    br i1 [[CMP21]], label %[[IF_THEN22:.*]], label %[[IF_END27:.*]]
// CHECK2:       [[IF_THEN22]]:
// CHECK2-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_LB1]], align 4
// CHECK2-NEXT:    [[TMP37:%.*]] = load i32, ptr [[DOTOMP_ST1]], align 4
// CHECK2-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[MUL23:%.*]] = mul i32 [[TMP37]], [[TMP38]]
// CHECK2-NEXT:    [[ADD24:%.*]] = add i32 [[TMP36]], [[MUL23]]
// CHECK2-NEXT:    store i32 [[ADD24]], ptr [[DOTOMP_IV1]], align 4
// CHECK2-NEXT:    [[TMP39:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_6]], align 4
// CHECK2-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_IV1]], align 4
// CHECK2-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTNEW_STEP8]], align 4
// CHECK2-NEXT:    [[MUL25:%.*]] = mul i32 [[TMP40]], [[TMP41]]
// CHECK2-NEXT:    [[ADD26:%.*]] = add i32 [[TMP39]], [[MUL25]]
// CHECK2-NEXT:    store i32 [[ADD26]], ptr [[J]], align 4
// CHECK2-NEXT:    [[TMP42:%.*]] = load i32, ptr [[J]], align 4
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP42]])
// CHECK2-NEXT:    br label %[[IF_END27]]
// CHECK2:       [[IF_END27]]:
// CHECK2-NEXT:    br label %[[FOR_INC:.*]]
// CHECK2:       [[FOR_INC]]:
// CHECK2-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[INC:%.*]] = add i32 [[TMP43]], 1
// CHECK2-NEXT:    store i32 [[INC]], ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    br label %[[FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK2:       [[FOR_END]]:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define dso_local void @foo3(
// CHECK2-SAME: ) #[[ATTR0]] {
// CHECK2-NEXT:  [[ENTRY:.*:]]
// CHECK2-NEXT:    [[ARR:%.*]] = alloca [256 x double], align 16
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB0:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_ST0:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_NI0:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IV0:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[J:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_ST1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_NI1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IV1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_TEMP_1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_FUSE_MAX:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_FUSE_INDEX:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB03:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_ST04:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_NI05:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_IV06:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[C:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[__RANGE2:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[__END2:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[__BEGIN2:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_8:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_10:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_11:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_LB116:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_ST117:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_NI118:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_IV120:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[CC:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[__RANGE221:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[__END222:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[__BEGIN225:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_27:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_29:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_30:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_LB2:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_ST2:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_NI2:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_IV2:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_TEMP_140:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_TEMP_2:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_FUSE_MAX46:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_FUSE_INDEX52:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[V:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[VV:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store i32 0, ptr [[I]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_LB0]], align 4
// CHECK2-NEXT:    store i32 1, ptr [[DOTOMP_ST0]], align 4
// CHECK2-NEXT:    store i32 128, ptr [[DOTOMP_NI0]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[J]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_LB1]], align 4
// CHECK2-NEXT:    store i32 1, ptr [[DOTOMP_ST1]], align 4
// CHECK2-NEXT:    store i32 128, ptr [[DOTOMP_NI1]], align 4
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[DOTOMP_NI0]], align 4
// CHECK2-NEXT:    store i32 [[TMP0]], ptr [[DOTOMP_TEMP_1]], align 4
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32, ptr [[DOTOMP_TEMP_1]], align 4
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP1]], [[TMP2]]
// CHECK2-NEXT:    br i1 [[CMP]], label %[[COND_TRUE:.*]], label %[[COND_FALSE:.*]]
// CHECK2:       [[COND_TRUE]]:
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTOMP_TEMP_1]], align 4
// CHECK2-NEXT:    br label %[[COND_END:.*]]
// CHECK2:       [[COND_FALSE]]:
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK2-NEXT:    br label %[[COND_END]]
// CHECK2:       [[COND_END]]:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP3]], %[[COND_TRUE]] ], [ [[TMP4]], %[[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], ptr [[DOTOMP_FUSE_MAX]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_FUSE_MAX]], align 4
// CHECK2-NEXT:    store i32 [[TMP5]], ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP6]], 0
// CHECK2-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK2-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK2-NEXT:    store i32 [[SUB2]], ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_LB03]], align 4
// CHECK2-NEXT:    store i32 1, ptr [[DOTOMP_ST04]], align 4
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP7]], 1
// CHECK2-NEXT:    [[CONV:%.*]] = sext i32 [[ADD]] to i64
// CHECK2-NEXT:    store i64 [[CONV]], ptr [[DOTOMP_NI05]], align 8
// CHECK2-NEXT:    store i32 42, ptr [[C]], align 4
// CHECK2-NEXT:    store ptr [[ARR]], ptr [[__RANGE2]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK2-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP8]], i64 0, i64 0
// CHECK2-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds double, ptr [[ARRAYDECAY]], i64 256
// CHECK2-NEXT:    store ptr [[ADD_PTR]], ptr [[__END2]], align 8
// CHECK2-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK2-NEXT:    [[ARRAYDECAY7:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP9]], i64 0, i64 0
// CHECK2-NEXT:    store ptr [[ARRAYDECAY7]], ptr [[__BEGIN2]], align 8
// CHECK2-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK2-NEXT:    [[ARRAYDECAY9:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP10]], i64 0, i64 0
// CHECK2-NEXT:    store ptr [[ARRAYDECAY9]], ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK2-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[__END2]], align 8
// CHECK2-NEXT:    store ptr [[TMP11]], ptr [[DOTCAPTURE_EXPR_10]], align 8
// CHECK2-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_10]], align 8
// CHECK2-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK2-NEXT:    [[SUB_PTR_LHS_CAST:%.*]] = ptrtoint ptr [[TMP12]] to i64
// CHECK2-NEXT:    [[SUB_PTR_RHS_CAST:%.*]] = ptrtoint ptr [[TMP13]] to i64
// CHECK2-NEXT:    [[SUB_PTR_SUB:%.*]] = sub i64 [[SUB_PTR_LHS_CAST]], [[SUB_PTR_RHS_CAST]]
// CHECK2-NEXT:    [[SUB_PTR_DIV:%.*]] = sdiv exact i64 [[SUB_PTR_SUB]], 8
// CHECK2-NEXT:    [[SUB12:%.*]] = sub nsw i64 [[SUB_PTR_DIV]], 1
// CHECK2-NEXT:    [[ADD13:%.*]] = add nsw i64 [[SUB12]], 1
// CHECK2-NEXT:    [[DIV14:%.*]] = sdiv i64 [[ADD13]], 1
// CHECK2-NEXT:    [[SUB15:%.*]] = sub nsw i64 [[DIV14]], 1
// CHECK2-NEXT:    store i64 [[SUB15]], ptr [[DOTCAPTURE_EXPR_11]], align 8
// CHECK2-NEXT:    store i64 0, ptr [[DOTOMP_LB116]], align 8
// CHECK2-NEXT:    store i64 1, ptr [[DOTOMP_ST117]], align 8
// CHECK2-NEXT:    [[TMP14:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_11]], align 8
// CHECK2-NEXT:    [[ADD19:%.*]] = add nsw i64 [[TMP14]], 1
// CHECK2-NEXT:    store i64 [[ADD19]], ptr [[DOTOMP_NI118]], align 8
// CHECK2-NEXT:    store i32 37, ptr [[CC]], align 4
// CHECK2-NEXT:    store ptr [[ARR]], ptr [[__RANGE221]], align 8
// CHECK2-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[__RANGE221]], align 8
// CHECK2-NEXT:    [[ARRAYDECAY23:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP15]], i64 0, i64 0
// CHECK2-NEXT:    [[ADD_PTR24:%.*]] = getelementptr inbounds double, ptr [[ARRAYDECAY23]], i64 256
// CHECK2-NEXT:    store ptr [[ADD_PTR24]], ptr [[__END222]], align 8
// CHECK2-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[__RANGE221]], align 8
// CHECK2-NEXT:    [[ARRAYDECAY26:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP16]], i64 0, i64 0
// CHECK2-NEXT:    store ptr [[ARRAYDECAY26]], ptr [[__BEGIN225]], align 8
// CHECK2-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[__RANGE221]], align 8
// CHECK2-NEXT:    [[ARRAYDECAY28:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP17]], i64 0, i64 0
// CHECK2-NEXT:    store ptr [[ARRAYDECAY28]], ptr [[DOTCAPTURE_EXPR_27]], align 8
// CHECK2-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[__END222]], align 8
// CHECK2-NEXT:    store ptr [[TMP18]], ptr [[DOTCAPTURE_EXPR_29]], align 8
// CHECK2-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_29]], align 8
// CHECK2-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_27]], align 8
// CHECK2-NEXT:    [[SUB_PTR_LHS_CAST31:%.*]] = ptrtoint ptr [[TMP19]] to i64
// CHECK2-NEXT:    [[SUB_PTR_RHS_CAST32:%.*]] = ptrtoint ptr [[TMP20]] to i64
// CHECK2-NEXT:    [[SUB_PTR_SUB33:%.*]] = sub i64 [[SUB_PTR_LHS_CAST31]], [[SUB_PTR_RHS_CAST32]]
// CHECK2-NEXT:    [[SUB_PTR_DIV34:%.*]] = sdiv exact i64 [[SUB_PTR_SUB33]], 8
// CHECK2-NEXT:    [[SUB35:%.*]] = sub nsw i64 [[SUB_PTR_DIV34]], 1
// CHECK2-NEXT:    [[ADD36:%.*]] = add nsw i64 [[SUB35]], 1
// CHECK2-NEXT:    [[DIV37:%.*]] = sdiv i64 [[ADD36]], 1
// CHECK2-NEXT:    [[SUB38:%.*]] = sub nsw i64 [[DIV37]], 1
// CHECK2-NEXT:    store i64 [[SUB38]], ptr [[DOTCAPTURE_EXPR_30]], align 8
// CHECK2-NEXT:    store i64 0, ptr [[DOTOMP_LB2]], align 8
// CHECK2-NEXT:    store i64 1, ptr [[DOTOMP_ST2]], align 8
// CHECK2-NEXT:    [[TMP21:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_30]], align 8
// CHECK2-NEXT:    [[ADD39:%.*]] = add nsw i64 [[TMP21]], 1
// CHECK2-NEXT:    store i64 [[ADD39]], ptr [[DOTOMP_NI2]], align 8
// CHECK2-NEXT:    [[TMP22:%.*]] = load i64, ptr [[DOTOMP_NI05]], align 8
// CHECK2-NEXT:    store i64 [[TMP22]], ptr [[DOTOMP_TEMP_140]], align 8
// CHECK2-NEXT:    [[TMP23:%.*]] = load i64, ptr [[DOTOMP_TEMP_140]], align 8
// CHECK2-NEXT:    [[TMP24:%.*]] = load i64, ptr [[DOTOMP_NI118]], align 8
// CHECK2-NEXT:    [[CMP41:%.*]] = icmp sgt i64 [[TMP23]], [[TMP24]]
// CHECK2-NEXT:    br i1 [[CMP41]], label %[[COND_TRUE42:.*]], label %[[COND_FALSE43:.*]]
// CHECK2:       [[COND_TRUE42]]:
// CHECK2-NEXT:    [[TMP25:%.*]] = load i64, ptr [[DOTOMP_TEMP_140]], align 8
// CHECK2-NEXT:    br label %[[COND_END44:.*]]
// CHECK2:       [[COND_FALSE43]]:
// CHECK2-NEXT:    [[TMP26:%.*]] = load i64, ptr [[DOTOMP_NI118]], align 8
// CHECK2-NEXT:    br label %[[COND_END44]]
// CHECK2:       [[COND_END44]]:
// CHECK2-NEXT:    [[COND45:%.*]] = phi i64 [ [[TMP25]], %[[COND_TRUE42]] ], [ [[TMP26]], %[[COND_FALSE43]] ]
// CHECK2-NEXT:    store i64 [[COND45]], ptr [[DOTOMP_TEMP_2]], align 8
// CHECK2-NEXT:    [[TMP27:%.*]] = load i64, ptr [[DOTOMP_TEMP_2]], align 8
// CHECK2-NEXT:    [[TMP28:%.*]] = load i64, ptr [[DOTOMP_NI2]], align 8
// CHECK2-NEXT:    [[CMP47:%.*]] = icmp sgt i64 [[TMP27]], [[TMP28]]
// CHECK2-NEXT:    br i1 [[CMP47]], label %[[COND_TRUE48:.*]], label %[[COND_FALSE49:.*]]
// CHECK2:       [[COND_TRUE48]]:
// CHECK2-NEXT:    [[TMP29:%.*]] = load i64, ptr [[DOTOMP_TEMP_2]], align 8
// CHECK2-NEXT:    br label %[[COND_END50:.*]]
// CHECK2:       [[COND_FALSE49]]:
// CHECK2-NEXT:    [[TMP30:%.*]] = load i64, ptr [[DOTOMP_NI2]], align 8
// CHECK2-NEXT:    br label %[[COND_END50]]
// CHECK2:       [[COND_END50]]:
// CHECK2-NEXT:    [[COND51:%.*]] = phi i64 [ [[TMP29]], %[[COND_TRUE48]] ], [ [[TMP30]], %[[COND_FALSE49]] ]
// CHECK2-NEXT:    store i64 [[COND51]], ptr [[DOTOMP_FUSE_MAX46]], align 8
// CHECK2-NEXT:    store i64 0, ptr [[DOTOMP_FUSE_INDEX52]], align 8
// CHECK2-NEXT:    br label %[[FOR_COND:.*]]
// CHECK2:       [[FOR_COND]]:
// CHECK2-NEXT:    [[TMP31:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX52]], align 8
// CHECK2-NEXT:    [[TMP32:%.*]] = load i64, ptr [[DOTOMP_FUSE_MAX46]], align 8
// CHECK2-NEXT:    [[CMP53:%.*]] = icmp slt i64 [[TMP31]], [[TMP32]]
// CHECK2-NEXT:    br i1 [[CMP53]], label %[[FOR_BODY:.*]], label %[[FOR_END:.*]]
// CHECK2:       [[FOR_BODY]]:
// CHECK2-NEXT:    [[TMP33:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX52]], align 8
// CHECK2-NEXT:    [[TMP34:%.*]] = load i64, ptr [[DOTOMP_NI05]], align 8
// CHECK2-NEXT:    [[CMP54:%.*]] = icmp slt i64 [[TMP33]], [[TMP34]]
// CHECK2-NEXT:    br i1 [[CMP54]], label %[[IF_THEN:.*]], label %[[IF_END74:.*]]
// CHECK2:       [[IF_THEN]]:
// CHECK2-NEXT:    [[TMP35:%.*]] = load i32, ptr [[DOTOMP_LB03]], align 4
// CHECK2-NEXT:    [[CONV55:%.*]] = sext i32 [[TMP35]] to i64
// CHECK2-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_ST04]], align 4
// CHECK2-NEXT:    [[CONV56:%.*]] = sext i32 [[TMP36]] to i64
// CHECK2-NEXT:    [[TMP37:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX52]], align 8
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i64 [[CONV56]], [[TMP37]]
// CHECK2-NEXT:    [[ADD57:%.*]] = add nsw i64 [[CONV55]], [[MUL]]
// CHECK2-NEXT:    [[CONV58:%.*]] = trunc i64 [[ADD57]] to i32
// CHECK2-NEXT:    store i32 [[CONV58]], ptr [[DOTOMP_IV06]], align 4
// CHECK2-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_IV06]], align 4
// CHECK2-NEXT:    [[MUL59:%.*]] = mul nsw i32 [[TMP38]], 1
// CHECK2-NEXT:    [[ADD60:%.*]] = add nsw i32 0, [[MUL59]]
// CHECK2-NEXT:    store i32 [[ADD60]], ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[TMP39:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_NI0]], align 4
// CHECK2-NEXT:    [[CMP61:%.*]] = icmp slt i32 [[TMP39]], [[TMP40]]
// CHECK2-NEXT:    br i1 [[CMP61]], label %[[IF_THEN62:.*]], label %[[IF_END:.*]]
// CHECK2:       [[IF_THEN62]]:
// CHECK2-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTOMP_LB0]], align 4
// CHECK2-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_ST0]], align 4
// CHECK2-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[MUL63:%.*]] = mul nsw i32 [[TMP42]], [[TMP43]]
// CHECK2-NEXT:    [[ADD64:%.*]] = add nsw i32 [[TMP41]], [[MUL63]]
// CHECK2-NEXT:    store i32 [[ADD64]], ptr [[DOTOMP_IV0]], align 4
// CHECK2-NEXT:    [[TMP44:%.*]] = load i32, ptr [[DOTOMP_IV0]], align 4
// CHECK2-NEXT:    [[MUL65:%.*]] = mul nsw i32 [[TMP44]], 1
// CHECK2-NEXT:    [[ADD66:%.*]] = add nsw i32 0, [[MUL65]]
// CHECK2-NEXT:    store i32 [[ADD66]], ptr [[I]], align 4
// CHECK2-NEXT:    [[TMP45:%.*]] = load i32, ptr [[I]], align 4
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP45]])
// CHECK2-NEXT:    br label %[[IF_END]]
// CHECK2:       [[IF_END]]:
// CHECK2-NEXT:    [[TMP46:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK2-NEXT:    [[CMP67:%.*]] = icmp slt i32 [[TMP46]], [[TMP47]]
// CHECK2-NEXT:    br i1 [[CMP67]], label %[[IF_THEN68:.*]], label %[[IF_END73:.*]]
// CHECK2:       [[IF_THEN68]]:
// CHECK2-NEXT:    [[TMP48:%.*]] = load i32, ptr [[DOTOMP_LB1]], align 4
// CHECK2-NEXT:    [[TMP49:%.*]] = load i32, ptr [[DOTOMP_ST1]], align 4
// CHECK2-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[MUL69:%.*]] = mul nsw i32 [[TMP49]], [[TMP50]]
// CHECK2-NEXT:    [[ADD70:%.*]] = add nsw i32 [[TMP48]], [[MUL69]]
// CHECK2-NEXT:    store i32 [[ADD70]], ptr [[DOTOMP_IV1]], align 4
// CHECK2-NEXT:    [[TMP51:%.*]] = load i32, ptr [[DOTOMP_IV1]], align 4
// CHECK2-NEXT:    [[MUL71:%.*]] = mul nsw i32 [[TMP51]], 2
// CHECK2-NEXT:    [[ADD72:%.*]] = add nsw i32 0, [[MUL71]]
// CHECK2-NEXT:    store i32 [[ADD72]], ptr [[J]], align 4
// CHECK2-NEXT:    [[TMP52:%.*]] = load i32, ptr [[J]], align 4
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP52]])
// CHECK2-NEXT:    br label %[[IF_END73]]
// CHECK2:       [[IF_END73]]:
// CHECK2-NEXT:    br label %[[IF_END74]]
// CHECK2:       [[IF_END74]]:
// CHECK2-NEXT:    [[TMP53:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX52]], align 8
// CHECK2-NEXT:    [[TMP54:%.*]] = load i64, ptr [[DOTOMP_NI118]], align 8
// CHECK2-NEXT:    [[CMP75:%.*]] = icmp slt i64 [[TMP53]], [[TMP54]]
// CHECK2-NEXT:    br i1 [[CMP75]], label %[[IF_THEN76:.*]], label %[[IF_END81:.*]]
// CHECK2:       [[IF_THEN76]]:
// CHECK2-NEXT:    [[TMP55:%.*]] = load i64, ptr [[DOTOMP_LB116]], align 8
// CHECK2-NEXT:    [[TMP56:%.*]] = load i64, ptr [[DOTOMP_ST117]], align 8
// CHECK2-NEXT:    [[TMP57:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX52]], align 8
// CHECK2-NEXT:    [[MUL77:%.*]] = mul nsw i64 [[TMP56]], [[TMP57]]
// CHECK2-NEXT:    [[ADD78:%.*]] = add nsw i64 [[TMP55]], [[MUL77]]
// CHECK2-NEXT:    store i64 [[ADD78]], ptr [[DOTOMP_IV120]], align 8
// CHECK2-NEXT:    [[TMP58:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK2-NEXT:    [[TMP59:%.*]] = load i64, ptr [[DOTOMP_IV120]], align 8
// CHECK2-NEXT:    [[MUL79:%.*]] = mul nsw i64 [[TMP59]], 1
// CHECK2-NEXT:    [[ADD_PTR80:%.*]] = getelementptr inbounds double, ptr [[TMP58]], i64 [[MUL79]]
// CHECK2-NEXT:    store ptr [[ADD_PTR80]], ptr [[__BEGIN2]], align 8
// CHECK2-NEXT:    [[TMP60:%.*]] = load ptr, ptr [[__BEGIN2]], align 8
// CHECK2-NEXT:    store ptr [[TMP60]], ptr [[V]], align 8
// CHECK2-NEXT:    [[TMP61:%.*]] = load i32, ptr [[C]], align 4
// CHECK2-NEXT:    [[TMP62:%.*]] = load ptr, ptr [[V]], align 8
// CHECK2-NEXT:    [[TMP63:%.*]] = load double, ptr [[TMP62]], align 8
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP61]], double noundef [[TMP63]])
// CHECK2-NEXT:    br label %[[IF_END81]]
// CHECK2:       [[IF_END81]]:
// CHECK2-NEXT:    [[TMP64:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX52]], align 8
// CHECK2-NEXT:    [[TMP65:%.*]] = load i64, ptr [[DOTOMP_NI2]], align 8
// CHECK2-NEXT:    [[CMP82:%.*]] = icmp slt i64 [[TMP64]], [[TMP65]]
// CHECK2-NEXT:    br i1 [[CMP82]], label %[[IF_THEN83:.*]], label %[[IF_END88:.*]]
// CHECK2:       [[IF_THEN83]]:
// CHECK2-NEXT:    [[TMP66:%.*]] = load i64, ptr [[DOTOMP_LB2]], align 8
// CHECK2-NEXT:    [[TMP67:%.*]] = load i64, ptr [[DOTOMP_ST2]], align 8
// CHECK2-NEXT:    [[TMP68:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX52]], align 8
// CHECK2-NEXT:    [[MUL84:%.*]] = mul nsw i64 [[TMP67]], [[TMP68]]
// CHECK2-NEXT:    [[ADD85:%.*]] = add nsw i64 [[TMP66]], [[MUL84]]
// CHECK2-NEXT:    store i64 [[ADD85]], ptr [[DOTOMP_IV2]], align 8
// CHECK2-NEXT:    [[TMP69:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_27]], align 8
// CHECK2-NEXT:    [[TMP70:%.*]] = load i64, ptr [[DOTOMP_IV2]], align 8
// CHECK2-NEXT:    [[MUL86:%.*]] = mul nsw i64 [[TMP70]], 1
// CHECK2-NEXT:    [[ADD_PTR87:%.*]] = getelementptr inbounds double, ptr [[TMP69]], i64 [[MUL86]]
// CHECK2-NEXT:    store ptr [[ADD_PTR87]], ptr [[__BEGIN225]], align 8
// CHECK2-NEXT:    [[TMP71:%.*]] = load ptr, ptr [[__BEGIN225]], align 8
// CHECK2-NEXT:    store ptr [[TMP71]], ptr [[VV]], align 8
// CHECK2-NEXT:    [[TMP72:%.*]] = load i32, ptr [[CC]], align 4
// CHECK2-NEXT:    [[TMP73:%.*]] = load ptr, ptr [[VV]], align 8
// CHECK2-NEXT:    [[TMP74:%.*]] = load double, ptr [[TMP73]], align 8
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP72]], double noundef [[TMP74]])
// CHECK2-NEXT:    br label %[[IF_END88]]
// CHECK2:       [[IF_END88]]:
// CHECK2-NEXT:    br label %[[FOR_INC:.*]]
// CHECK2:       [[FOR_INC]]:
// CHECK2-NEXT:    [[TMP75:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX52]], align 8
// CHECK2-NEXT:    [[INC:%.*]] = add nsw i64 [[TMP75]], 1
// CHECK2-NEXT:    store i64 [[INC]], ptr [[DOTOMP_FUSE_INDEX52]], align 8
// CHECK2-NEXT:    br label %[[FOR_COND]], !llvm.loop [[LOOP5:![0-9]+]]
// CHECK2:       [[FOR_END]]:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define dso_local void @foo4(
// CHECK2-SAME: ) #[[ATTR0]] {
// CHECK2-NEXT:  [[ENTRY:.*:]]
// CHECK2-NEXT:    [[ARR:%.*]] = alloca [256 x double], align 16
// CHECK2-NEXT:    [[J:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB0:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_ST0:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_NI0:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IV0:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[K:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_ST1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_NI1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IV1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_TEMP_1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_FUSE_MAX:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_FUSE_INDEX:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[C:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[__RANGE2:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[__BEGIN2:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[__END2:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[V:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store i32 0, ptr [[J]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_LB0]], align 4
// CHECK2-NEXT:    store i32 1, ptr [[DOTOMP_ST0]], align 4
// CHECK2-NEXT:    store i32 128, ptr [[DOTOMP_NI0]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[K]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_LB1]], align 4
// CHECK2-NEXT:    store i32 1, ptr [[DOTOMP_ST1]], align 4
// CHECK2-NEXT:    store i32 64, ptr [[DOTOMP_NI1]], align 4
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[DOTOMP_NI0]], align 4
// CHECK2-NEXT:    store i32 [[TMP0]], ptr [[DOTOMP_TEMP_1]], align 4
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32, ptr [[DOTOMP_TEMP_1]], align 4
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP1]], [[TMP2]]
// CHECK2-NEXT:    br i1 [[CMP]], label %[[COND_TRUE:.*]], label %[[COND_FALSE:.*]]
// CHECK2:       [[COND_TRUE]]:
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTOMP_TEMP_1]], align 4
// CHECK2-NEXT:    br label %[[COND_END:.*]]
// CHECK2:       [[COND_FALSE]]:
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK2-NEXT:    br label %[[COND_END]]
// CHECK2:       [[COND_END]]:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP3]], %[[COND_TRUE]] ], [ [[TMP4]], %[[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], ptr [[DOTOMP_FUSE_MAX]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[I]], align 4
// CHECK2-NEXT:    br label %[[FOR_COND:.*]]
// CHECK2:       [[FOR_COND]]:
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, ptr [[I]], align 4
// CHECK2-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[TMP5]], 128
// CHECK2-NEXT:    br i1 [[CMP1]], label %[[FOR_BODY:.*]], label %[[FOR_END:.*]]
// CHECK2:       [[FOR_BODY]]:
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, ptr [[I]], align 4
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP6]])
// CHECK2-NEXT:    br label %[[FOR_INC:.*]]
// CHECK2:       [[FOR_INC]]:
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, ptr [[I]], align 4
// CHECK2-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP7]], 1
// CHECK2-NEXT:    store i32 [[INC]], ptr [[I]], align 4
// CHECK2-NEXT:    br label %[[FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK2:       [[FOR_END]]:
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    br label %[[FOR_COND2:.*]]
// CHECK2:       [[FOR_COND2]]:
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_FUSE_MAX]], align 4
// CHECK2-NEXT:    [[CMP3:%.*]] = icmp slt i32 [[TMP8]], [[TMP9]]
// CHECK2-NEXT:    br i1 [[CMP3]], label %[[FOR_BODY4:.*]], label %[[FOR_END17:.*]]
// CHECK2:       [[FOR_BODY4]]:
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_NI0]], align 4
// CHECK2-NEXT:    [[CMP5:%.*]] = icmp slt i32 [[TMP10]], [[TMP11]]
// CHECK2-NEXT:    br i1 [[CMP5]], label %[[IF_THEN:.*]], label %[[IF_END:.*]]
// CHECK2:       [[IF_THEN]]:
// CHECK2-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_LB0]], align 4
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_ST0]], align 4
// CHECK2-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP13]], [[TMP14]]
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP12]], [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD]], ptr [[DOTOMP_IV0]], align 4
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV0]], align 4
// CHECK2-NEXT:    [[MUL6:%.*]] = mul nsw i32 [[TMP15]], 2
// CHECK2-NEXT:    [[ADD7:%.*]] = add nsw i32 0, [[MUL6]]
// CHECK2-NEXT:    store i32 [[ADD7]], ptr [[J]], align 4
// CHECK2-NEXT:    [[TMP16:%.*]] = load i32, ptr [[J]], align 4
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP16]])
// CHECK2-NEXT:    br label %[[IF_END]]
// CHECK2:       [[IF_END]]:
// CHECK2-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK2-NEXT:    [[CMP8:%.*]] = icmp slt i32 [[TMP17]], [[TMP18]]
// CHECK2-NEXT:    br i1 [[CMP8]], label %[[IF_THEN9:.*]], label %[[IF_END14:.*]]
// CHECK2:       [[IF_THEN9]]:
// CHECK2-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_LB1]], align 4
// CHECK2-NEXT:    [[TMP20:%.*]] = load i32, ptr [[DOTOMP_ST1]], align 4
// CHECK2-NEXT:    [[TMP21:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[MUL10:%.*]] = mul nsw i32 [[TMP20]], [[TMP21]]
// CHECK2-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP19]], [[MUL10]]
// CHECK2-NEXT:    store i32 [[ADD11]], ptr [[DOTOMP_IV1]], align 4
// CHECK2-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTOMP_IV1]], align 4
// CHECK2-NEXT:    [[MUL12:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK2-NEXT:    [[ADD13:%.*]] = add nsw i32 0, [[MUL12]]
// CHECK2-NEXT:    store i32 [[ADD13]], ptr [[K]], align 4
// CHECK2-NEXT:    [[TMP23:%.*]] = load i32, ptr [[K]], align 4
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP23]])
// CHECK2-NEXT:    br label %[[IF_END14]]
// CHECK2:       [[IF_END14]]:
// CHECK2-NEXT:    br label %[[FOR_INC15:.*]]
// CHECK2:       [[FOR_INC15]]:
// CHECK2-NEXT:    [[TMP24:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[INC16:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK2-NEXT:    store i32 [[INC16]], ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    br label %[[FOR_COND2]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK2:       [[FOR_END17]]:
// CHECK2-NEXT:    store i32 42, ptr [[C]], align 4
// CHECK2-NEXT:    store ptr [[ARR]], ptr [[__RANGE2]], align 8
// CHECK2-NEXT:    [[TMP25:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK2-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP25]], i64 0, i64 0
// CHECK2-NEXT:    store ptr [[ARRAYDECAY]], ptr [[__BEGIN2]], align 8
// CHECK2-NEXT:    [[TMP26:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK2-NEXT:    [[ARRAYDECAY18:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP26]], i64 0, i64 0
// CHECK2-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds double, ptr [[ARRAYDECAY18]], i64 256
// CHECK2-NEXT:    store ptr [[ADD_PTR]], ptr [[__END2]], align 8
// CHECK2-NEXT:    br label %[[FOR_COND19:.*]]
// CHECK2:       [[FOR_COND19]]:
// CHECK2-NEXT:    [[TMP27:%.*]] = load ptr, ptr [[__BEGIN2]], align 8
// CHECK2-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[__END2]], align 8
// CHECK2-NEXT:    [[CMP20:%.*]] = icmp ne ptr [[TMP27]], [[TMP28]]
// CHECK2-NEXT:    br i1 [[CMP20]], label %[[FOR_BODY21:.*]], label %[[FOR_END23:.*]]
// CHECK2:       [[FOR_BODY21]]:
// CHECK2-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[__BEGIN2]], align 8
// CHECK2-NEXT:    store ptr [[TMP29]], ptr [[V]], align 8
// CHECK2-NEXT:    [[TMP30:%.*]] = load i32, ptr [[C]], align 4
// CHECK2-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[V]], align 8
// CHECK2-NEXT:    [[TMP32:%.*]] = load double, ptr [[TMP31]], align 8
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP30]], double noundef [[TMP32]])
// CHECK2-NEXT:    br label %[[FOR_INC22:.*]]
// CHECK2:       [[FOR_INC22]]:
// CHECK2-NEXT:    [[TMP33:%.*]] = load ptr, ptr [[__BEGIN2]], align 8
// CHECK2-NEXT:    [[INCDEC_PTR:%.*]] = getelementptr inbounds nuw double, ptr [[TMP33]], i32 1
// CHECK2-NEXT:    store ptr [[INCDEC_PTR]], ptr [[__BEGIN2]], align 8
// CHECK2-NEXT:    br label %[[FOR_COND19]]
// CHECK2:       [[FOR_END23]]:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define dso_local void @foo5(
// CHECK2-SAME: ) #[[ATTR0]] {
// CHECK2-NEXT:  [[ENTRY:.*:]]
// CHECK2-NEXT:    [[ARR:%.*]] = alloca [256 x double], align 16
// CHECK2-NEXT:    [[J:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB0:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_ST0:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_NI0:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IV0:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[K:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_ST1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_NI1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IV1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_TEMP_1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_FUSE_MAX:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_FUSE_INDEX:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB03:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_ST04:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_NI05:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_IV06:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[C:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[__RANGE2:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[__END2:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[__BEGIN2:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_8:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_10:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_11:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_LB116:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_ST117:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_NI118:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_IV120:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_TEMP_121:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_FUSE_MAX22:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_FUSE_INDEX29:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[V:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[CC:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[__RANGE264:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[__BEGIN265:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[__END267:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[VV:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store i32 0, ptr [[J]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_LB0]], align 4
// CHECK2-NEXT:    store i32 1, ptr [[DOTOMP_ST0]], align 4
// CHECK2-NEXT:    store i32 128, ptr [[DOTOMP_NI0]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[K]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_LB1]], align 4
// CHECK2-NEXT:    store i32 1, ptr [[DOTOMP_ST1]], align 4
// CHECK2-NEXT:    store i32 512, ptr [[DOTOMP_NI1]], align 4
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[DOTOMP_NI0]], align 4
// CHECK2-NEXT:    store i32 [[TMP0]], ptr [[DOTOMP_TEMP_1]], align 4
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32, ptr [[DOTOMP_TEMP_1]], align 4
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP1]], [[TMP2]]
// CHECK2-NEXT:    br i1 [[CMP]], label %[[COND_TRUE:.*]], label %[[COND_FALSE:.*]]
// CHECK2:       [[COND_TRUE]]:
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTOMP_TEMP_1]], align 4
// CHECK2-NEXT:    br label %[[COND_END:.*]]
// CHECK2:       [[COND_FALSE]]:
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK2-NEXT:    br label %[[COND_END]]
// CHECK2:       [[COND_END]]:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP3]], %[[COND_TRUE]] ], [ [[TMP4]], %[[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], ptr [[DOTOMP_FUSE_MAX]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_FUSE_MAX]], align 4
// CHECK2-NEXT:    store i32 [[TMP5]], ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP6]], 0
// CHECK2-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK2-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK2-NEXT:    store i32 [[SUB2]], ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_LB03]], align 4
// CHECK2-NEXT:    store i32 1, ptr [[DOTOMP_ST04]], align 4
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP7]], 1
// CHECK2-NEXT:    [[CONV:%.*]] = sext i32 [[ADD]] to i64
// CHECK2-NEXT:    store i64 [[CONV]], ptr [[DOTOMP_NI05]], align 8
// CHECK2-NEXT:    store i32 42, ptr [[C]], align 4
// CHECK2-NEXT:    store ptr [[ARR]], ptr [[__RANGE2]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK2-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP8]], i64 0, i64 0
// CHECK2-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds double, ptr [[ARRAYDECAY]], i64 256
// CHECK2-NEXT:    store ptr [[ADD_PTR]], ptr [[__END2]], align 8
// CHECK2-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK2-NEXT:    [[ARRAYDECAY7:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP9]], i64 0, i64 0
// CHECK2-NEXT:    store ptr [[ARRAYDECAY7]], ptr [[__BEGIN2]], align 8
// CHECK2-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK2-NEXT:    [[ARRAYDECAY9:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP10]], i64 0, i64 0
// CHECK2-NEXT:    store ptr [[ARRAYDECAY9]], ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK2-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[__END2]], align 8
// CHECK2-NEXT:    store ptr [[TMP11]], ptr [[DOTCAPTURE_EXPR_10]], align 8
// CHECK2-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_10]], align 8
// CHECK2-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK2-NEXT:    [[SUB_PTR_LHS_CAST:%.*]] = ptrtoint ptr [[TMP12]] to i64
// CHECK2-NEXT:    [[SUB_PTR_RHS_CAST:%.*]] = ptrtoint ptr [[TMP13]] to i64
// CHECK2-NEXT:    [[SUB_PTR_SUB:%.*]] = sub i64 [[SUB_PTR_LHS_CAST]], [[SUB_PTR_RHS_CAST]]
// CHECK2-NEXT:    [[SUB_PTR_DIV:%.*]] = sdiv exact i64 [[SUB_PTR_SUB]], 8
// CHECK2-NEXT:    [[SUB12:%.*]] = sub nsw i64 [[SUB_PTR_DIV]], 1
// CHECK2-NEXT:    [[ADD13:%.*]] = add nsw i64 [[SUB12]], 1
// CHECK2-NEXT:    [[DIV14:%.*]] = sdiv i64 [[ADD13]], 1
// CHECK2-NEXT:    [[SUB15:%.*]] = sub nsw i64 [[DIV14]], 1
// CHECK2-NEXT:    store i64 [[SUB15]], ptr [[DOTCAPTURE_EXPR_11]], align 8
// CHECK2-NEXT:    store i64 0, ptr [[DOTOMP_LB116]], align 8
// CHECK2-NEXT:    store i64 1, ptr [[DOTOMP_ST117]], align 8
// CHECK2-NEXT:    [[TMP14:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_11]], align 8
// CHECK2-NEXT:    [[ADD19:%.*]] = add nsw i64 [[TMP14]], 1
// CHECK2-NEXT:    store i64 [[ADD19]], ptr [[DOTOMP_NI118]], align 8
// CHECK2-NEXT:    [[TMP15:%.*]] = load i64, ptr [[DOTOMP_NI05]], align 8
// CHECK2-NEXT:    store i64 [[TMP15]], ptr [[DOTOMP_TEMP_121]], align 8
// CHECK2-NEXT:    [[TMP16:%.*]] = load i64, ptr [[DOTOMP_TEMP_121]], align 8
// CHECK2-NEXT:    [[TMP17:%.*]] = load i64, ptr [[DOTOMP_NI118]], align 8
// CHECK2-NEXT:    [[CMP23:%.*]] = icmp sgt i64 [[TMP16]], [[TMP17]]
// CHECK2-NEXT:    br i1 [[CMP23]], label %[[COND_TRUE24:.*]], label %[[COND_FALSE25:.*]]
// CHECK2:       [[COND_TRUE24]]:
// CHECK2-NEXT:    [[TMP18:%.*]] = load i64, ptr [[DOTOMP_TEMP_121]], align 8
// CHECK2-NEXT:    br label %[[COND_END26:.*]]
// CHECK2:       [[COND_FALSE25]]:
// CHECK2-NEXT:    [[TMP19:%.*]] = load i64, ptr [[DOTOMP_NI118]], align 8
// CHECK2-NEXT:    br label %[[COND_END26]]
// CHECK2:       [[COND_END26]]:
// CHECK2-NEXT:    [[COND27:%.*]] = phi i64 [ [[TMP18]], %[[COND_TRUE24]] ], [ [[TMP19]], %[[COND_FALSE25]] ]
// CHECK2-NEXT:    store i64 [[COND27]], ptr [[DOTOMP_FUSE_MAX22]], align 8
// CHECK2-NEXT:    store i32 0, ptr [[I]], align 4
// CHECK2-NEXT:    br label %[[FOR_COND:.*]]
// CHECK2:       [[FOR_COND]]:
// CHECK2-NEXT:    [[TMP20:%.*]] = load i32, ptr [[I]], align 4
// CHECK2-NEXT:    [[CMP28:%.*]] = icmp slt i32 [[TMP20]], 128
// CHECK2-NEXT:    br i1 [[CMP28]], label %[[FOR_BODY:.*]], label %[[FOR_END:.*]]
// CHECK2:       [[FOR_BODY]]:
// CHECK2-NEXT:    [[TMP21:%.*]] = load i32, ptr [[I]], align 4
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP21]])
// CHECK2-NEXT:    br label %[[FOR_INC:.*]]
// CHECK2:       [[FOR_INC]]:
// CHECK2-NEXT:    [[TMP22:%.*]] = load i32, ptr [[I]], align 4
// CHECK2-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP22]], 1
// CHECK2-NEXT:    store i32 [[INC]], ptr [[I]], align 4
// CHECK2-NEXT:    br label %[[FOR_COND]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK2:       [[FOR_END]]:
// CHECK2-NEXT:    store i64 0, ptr [[DOTOMP_FUSE_INDEX29]], align 8
// CHECK2-NEXT:    br label %[[FOR_COND30:.*]]
// CHECK2:       [[FOR_COND30]]:
// CHECK2-NEXT:    [[TMP23:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX29]], align 8
// CHECK2-NEXT:    [[TMP24:%.*]] = load i64, ptr [[DOTOMP_FUSE_MAX22]], align 8
// CHECK2-NEXT:    [[CMP31:%.*]] = icmp slt i64 [[TMP23]], [[TMP24]]
// CHECK2-NEXT:    br i1 [[CMP31]], label %[[FOR_BODY32:.*]], label %[[FOR_END63:.*]]
// CHECK2:       [[FOR_BODY32]]:
// CHECK2-NEXT:    [[TMP25:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX29]], align 8
// CHECK2-NEXT:    [[TMP26:%.*]] = load i64, ptr [[DOTOMP_NI05]], align 8
// CHECK2-NEXT:    [[CMP33:%.*]] = icmp slt i64 [[TMP25]], [[TMP26]]
// CHECK2-NEXT:    br i1 [[CMP33]], label %[[IF_THEN:.*]], label %[[IF_END53:.*]]
// CHECK2:       [[IF_THEN]]:
// CHECK2-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_LB03]], align 4
// CHECK2-NEXT:    [[CONV34:%.*]] = sext i32 [[TMP27]] to i64
// CHECK2-NEXT:    [[TMP28:%.*]] = load i32, ptr [[DOTOMP_ST04]], align 4
// CHECK2-NEXT:    [[CONV35:%.*]] = sext i32 [[TMP28]] to i64
// CHECK2-NEXT:    [[TMP29:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX29]], align 8
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i64 [[CONV35]], [[TMP29]]
// CHECK2-NEXT:    [[ADD36:%.*]] = add nsw i64 [[CONV34]], [[MUL]]
// CHECK2-NEXT:    [[CONV37:%.*]] = trunc i64 [[ADD36]] to i32
// CHECK2-NEXT:    store i32 [[CONV37]], ptr [[DOTOMP_IV06]], align 4
// CHECK2-NEXT:    [[TMP30:%.*]] = load i32, ptr [[DOTOMP_IV06]], align 4
// CHECK2-NEXT:    [[MUL38:%.*]] = mul nsw i32 [[TMP30]], 1
// CHECK2-NEXT:    [[ADD39:%.*]] = add nsw i32 0, [[MUL38]]
// CHECK2-NEXT:    store i32 [[ADD39]], ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[TMP31:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[TMP32:%.*]] = load i32, ptr [[DOTOMP_NI0]], align 4
// CHECK2-NEXT:    [[CMP40:%.*]] = icmp slt i32 [[TMP31]], [[TMP32]]
// CHECK2-NEXT:    br i1 [[CMP40]], label %[[IF_THEN41:.*]], label %[[IF_END:.*]]
// CHECK2:       [[IF_THEN41]]:
// CHECK2-NEXT:    [[TMP33:%.*]] = load i32, ptr [[DOTOMP_LB0]], align 4
// CHECK2-NEXT:    [[TMP34:%.*]] = load i32, ptr [[DOTOMP_ST0]], align 4
// CHECK2-NEXT:    [[TMP35:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[MUL42:%.*]] = mul nsw i32 [[TMP34]], [[TMP35]]
// CHECK2-NEXT:    [[ADD43:%.*]] = add nsw i32 [[TMP33]], [[MUL42]]
// CHECK2-NEXT:    store i32 [[ADD43]], ptr [[DOTOMP_IV0]], align 4
// CHECK2-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV0]], align 4
// CHECK2-NEXT:    [[MUL44:%.*]] = mul nsw i32 [[TMP36]], 2
// CHECK2-NEXT:    [[ADD45:%.*]] = add nsw i32 0, [[MUL44]]
// CHECK2-NEXT:    store i32 [[ADD45]], ptr [[J]], align 4
// CHECK2-NEXT:    [[TMP37:%.*]] = load i32, ptr [[J]], align 4
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP37]])
// CHECK2-NEXT:    br label %[[IF_END]]
// CHECK2:       [[IF_END]]:
// CHECK2-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[TMP39:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK2-NEXT:    [[CMP46:%.*]] = icmp slt i32 [[TMP38]], [[TMP39]]
// CHECK2-NEXT:    br i1 [[CMP46]], label %[[IF_THEN47:.*]], label %[[IF_END52:.*]]
// CHECK2:       [[IF_THEN47]]:
// CHECK2-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_LB1]], align 4
// CHECK2-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTOMP_ST1]], align 4
// CHECK2-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[MUL48:%.*]] = mul nsw i32 [[TMP41]], [[TMP42]]
// CHECK2-NEXT:    [[ADD49:%.*]] = add nsw i32 [[TMP40]], [[MUL48]]
// CHECK2-NEXT:    store i32 [[ADD49]], ptr [[DOTOMP_IV1]], align 4
// CHECK2-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_IV1]], align 4
// CHECK2-NEXT:    [[MUL50:%.*]] = mul nsw i32 [[TMP43]], 1
// CHECK2-NEXT:    [[ADD51:%.*]] = add nsw i32 0, [[MUL50]]
// CHECK2-NEXT:    store i32 [[ADD51]], ptr [[K]], align 4
// CHECK2-NEXT:    [[TMP44:%.*]] = load i32, ptr [[K]], align 4
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP44]])
// CHECK2-NEXT:    br label %[[IF_END52]]
// CHECK2:       [[IF_END52]]:
// CHECK2-NEXT:    br label %[[IF_END53]]
// CHECK2:       [[IF_END53]]:
// CHECK2-NEXT:    [[TMP45:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX29]], align 8
// CHECK2-NEXT:    [[TMP46:%.*]] = load i64, ptr [[DOTOMP_NI118]], align 8
// CHECK2-NEXT:    [[CMP54:%.*]] = icmp slt i64 [[TMP45]], [[TMP46]]
// CHECK2-NEXT:    br i1 [[CMP54]], label %[[IF_THEN55:.*]], label %[[IF_END60:.*]]
// CHECK2:       [[IF_THEN55]]:
// CHECK2-NEXT:    [[TMP47:%.*]] = load i64, ptr [[DOTOMP_LB116]], align 8
// CHECK2-NEXT:    [[TMP48:%.*]] = load i64, ptr [[DOTOMP_ST117]], align 8
// CHECK2-NEXT:    [[TMP49:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX29]], align 8
// CHECK2-NEXT:    [[MUL56:%.*]] = mul nsw i64 [[TMP48]], [[TMP49]]
// CHECK2-NEXT:    [[ADD57:%.*]] = add nsw i64 [[TMP47]], [[MUL56]]
// CHECK2-NEXT:    store i64 [[ADD57]], ptr [[DOTOMP_IV120]], align 8
// CHECK2-NEXT:    [[TMP50:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK2-NEXT:    [[TMP51:%.*]] = load i64, ptr [[DOTOMP_IV120]], align 8
// CHECK2-NEXT:    [[MUL58:%.*]] = mul nsw i64 [[TMP51]], 1
// CHECK2-NEXT:    [[ADD_PTR59:%.*]] = getelementptr inbounds double, ptr [[TMP50]], i64 [[MUL58]]
// CHECK2-NEXT:    store ptr [[ADD_PTR59]], ptr [[__BEGIN2]], align 8
// CHECK2-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[__BEGIN2]], align 8
// CHECK2-NEXT:    store ptr [[TMP52]], ptr [[V]], align 8
// CHECK2-NEXT:    [[TMP53:%.*]] = load i32, ptr [[C]], align 4
// CHECK2-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[V]], align 8
// CHECK2-NEXT:    [[TMP55:%.*]] = load double, ptr [[TMP54]], align 8
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP53]], double noundef [[TMP55]])
// CHECK2-NEXT:    br label %[[IF_END60]]
// CHECK2:       [[IF_END60]]:
// CHECK2-NEXT:    br label %[[FOR_INC61:.*]]
// CHECK2:       [[FOR_INC61]]:
// CHECK2-NEXT:    [[TMP56:%.*]] = load i64, ptr [[DOTOMP_FUSE_INDEX29]], align 8
// CHECK2-NEXT:    [[INC62:%.*]] = add nsw i64 [[TMP56]], 1
// CHECK2-NEXT:    store i64 [[INC62]], ptr [[DOTOMP_FUSE_INDEX29]], align 8
// CHECK2-NEXT:    br label %[[FOR_COND30]], !llvm.loop [[LOOP9:![0-9]+]]
// CHECK2:       [[FOR_END63]]:
// CHECK2-NEXT:    store i32 37, ptr [[CC]], align 4
// CHECK2-NEXT:    store ptr [[ARR]], ptr [[__RANGE264]], align 8
// CHECK2-NEXT:    [[TMP57:%.*]] = load ptr, ptr [[__RANGE264]], align 8
// CHECK2-NEXT:    [[ARRAYDECAY66:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP57]], i64 0, i64 0
// CHECK2-NEXT:    store ptr [[ARRAYDECAY66]], ptr [[__BEGIN265]], align 8
// CHECK2-NEXT:    [[TMP58:%.*]] = load ptr, ptr [[__RANGE264]], align 8
// CHECK2-NEXT:    [[ARRAYDECAY68:%.*]] = getelementptr inbounds [256 x double], ptr [[TMP58]], i64 0, i64 0
// CHECK2-NEXT:    [[ADD_PTR69:%.*]] = getelementptr inbounds double, ptr [[ARRAYDECAY68]], i64 256
// CHECK2-NEXT:    store ptr [[ADD_PTR69]], ptr [[__END267]], align 8
// CHECK2-NEXT:    br label %[[FOR_COND70:.*]]
// CHECK2:       [[FOR_COND70]]:
// CHECK2-NEXT:    [[TMP59:%.*]] = load ptr, ptr [[__BEGIN265]], align 8
// CHECK2-NEXT:    [[TMP60:%.*]] = load ptr, ptr [[__END267]], align 8
// CHECK2-NEXT:    [[CMP71:%.*]] = icmp ne ptr [[TMP59]], [[TMP60]]
// CHECK2-NEXT:    br i1 [[CMP71]], label %[[FOR_BODY72:.*]], label %[[FOR_END74:.*]]
// CHECK2:       [[FOR_BODY72]]:
// CHECK2-NEXT:    [[TMP61:%.*]] = load ptr, ptr [[__BEGIN265]], align 8
// CHECK2-NEXT:    store ptr [[TMP61]], ptr [[VV]], align 8
// CHECK2-NEXT:    [[TMP62:%.*]] = load i32, ptr [[CC]], align 4
// CHECK2-NEXT:    [[TMP63:%.*]] = load ptr, ptr [[VV]], align 8
// CHECK2-NEXT:    [[TMP64:%.*]] = load double, ptr [[TMP63]], align 8
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP62]], double noundef [[TMP64]])
// CHECK2-NEXT:    br label %[[FOR_INC73:.*]]
// CHECK2:       [[FOR_INC73]]:
// CHECK2-NEXT:    [[TMP65:%.*]] = load ptr, ptr [[__BEGIN265]], align 8
// CHECK2-NEXT:    [[INCDEC_PTR:%.*]] = getelementptr inbounds nuw double, ptr [[TMP65]], i32 1
// CHECK2-NEXT:    store ptr [[INCDEC_PTR]], ptr [[__BEGIN265]], align 8
// CHECK2-NEXT:    br label %[[FOR_COND70]]
// CHECK2:       [[FOR_END74]]:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define dso_local void @tfoo2(
// CHECK2-SAME: ) #[[ATTR0]] {
// CHECK2-NEXT:  [[ENTRY:.*:]]
// CHECK2-NEXT:    call void @_Z4foo2IiEvT_S0_S0_(i32 noundef 0, i32 noundef 64, i32 noundef 4)
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define linkonce_odr void @_Z4foo2IiEvT_S0_S0_(
// CHECK2-SAME: i32 noundef [[START:%.*]], i32 noundef [[END:%.*]], i32 noundef [[STEP:%.*]]) #[[ATTR0]] comdat {
// CHECK2-NEXT:  [[ENTRY:.*:]]
// CHECK2-NEXT:    [[START_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[END_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[STEP_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[J:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[K:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTNEW_STEP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB0:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_ST0:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_NI0:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IV0:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_6:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_7:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTNEW_STEP8:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_9:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_ST1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_NI1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IV1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_17:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_19:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTNEW_STEP21:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_22:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB2:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_ST2:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_NI2:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IV2:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_TEMP_1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_TEMP_2:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_FUSE_MAX:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_FUSE_INDEX:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store i32 [[START]], ptr [[START_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[END]], ptr [[END_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[STEP]], ptr [[STEP_ADDR]], align 4
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[START_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP0]], ptr [[I]], align 4
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32, ptr [[START_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP1]], ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, ptr [[END_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP2]], ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, ptr [[STEP_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP3]], ptr [[DOTNEW_STEP]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[SUB:%.*]] = sub i32 [[TMP4]], [[TMP5]]
// CHECK2-NEXT:    [[SUB3:%.*]] = sub i32 [[SUB]], 1
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTNEW_STEP]], align 4
// CHECK2-NEXT:    [[ADD:%.*]] = add i32 [[SUB3]], [[TMP6]]
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTNEW_STEP]], align 4
// CHECK2-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], [[TMP7]]
// CHECK2-NEXT:    [[SUB4:%.*]] = sub i32 [[DIV]], 1
// CHECK2-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_LB0]], align 4
// CHECK2-NEXT:    store i32 1, ptr [[DOTOMP_ST0]], align 4
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK2-NEXT:    [[ADD5:%.*]] = add i32 [[TMP8]], 1
// CHECK2-NEXT:    store i32 [[ADD5]], ptr [[DOTOMP_NI0]], align 4
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, ptr [[END_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP9]], ptr [[J]], align 4
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, ptr [[END_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP10]], ptr [[DOTCAPTURE_EXPR_6]], align 4
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, ptr [[START_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP11]], ptr [[DOTCAPTURE_EXPR_7]], align 4
// CHECK2-NEXT:    [[TMP12:%.*]] = load i32, ptr [[STEP_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP12]], ptr [[DOTNEW_STEP8]], align 4
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_6]], align 4
// CHECK2-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_7]], align 4
// CHECK2-NEXT:    [[SUB10:%.*]] = sub i32 [[TMP13]], [[TMP14]]
// CHECK2-NEXT:    [[SUB11:%.*]] = sub i32 [[SUB10]], 1
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTNEW_STEP8]], align 4
// CHECK2-NEXT:    [[ADD12:%.*]] = add i32 [[SUB11]], [[TMP15]]
// CHECK2-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTNEW_STEP8]], align 4
// CHECK2-NEXT:    [[DIV13:%.*]] = udiv i32 [[ADD12]], [[TMP16]]
// CHECK2-NEXT:    [[SUB14:%.*]] = sub i32 [[DIV13]], 1
// CHECK2-NEXT:    store i32 [[SUB14]], ptr [[DOTCAPTURE_EXPR_9]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_LB1]], align 4
// CHECK2-NEXT:    store i32 1, ptr [[DOTOMP_ST1]], align 4
// CHECK2-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_9]], align 4
// CHECK2-NEXT:    [[ADD15:%.*]] = add i32 [[TMP17]], 1
// CHECK2-NEXT:    store i32 [[ADD15]], ptr [[DOTOMP_NI1]], align 4
// CHECK2-NEXT:    [[TMP18:%.*]] = load i32, ptr [[START_ADDR]], align 4
// CHECK2-NEXT:    [[TMP19:%.*]] = load i32, ptr [[STEP_ADDR]], align 4
// CHECK2-NEXT:    [[ADD16:%.*]] = add nsw i32 [[TMP18]], [[TMP19]]
// CHECK2-NEXT:    store i32 [[ADD16]], ptr [[K]], align 4
// CHECK2-NEXT:    [[TMP20:%.*]] = load i32, ptr [[START_ADDR]], align 4
// CHECK2-NEXT:    [[TMP21:%.*]] = load i32, ptr [[STEP_ADDR]], align 4
// CHECK2-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP20]], [[TMP21]]
// CHECK2-NEXT:    store i32 [[ADD18]], ptr [[DOTCAPTURE_EXPR_17]], align 4
// CHECK2-NEXT:    [[TMP22:%.*]] = load i32, ptr [[END_ADDR]], align 4
// CHECK2-NEXT:    [[TMP23:%.*]] = load i32, ptr [[STEP_ADDR]], align 4
// CHECK2-NEXT:    [[ADD20:%.*]] = add nsw i32 [[TMP22]], [[TMP23]]
// CHECK2-NEXT:    store i32 [[ADD20]], ptr [[DOTCAPTURE_EXPR_19]], align 4
// CHECK2-NEXT:    [[TMP24:%.*]] = load i32, ptr [[STEP_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP24]], ptr [[DOTNEW_STEP21]], align 4
// CHECK2-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_19]], align 4
// CHECK2-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_17]], align 4
// CHECK2-NEXT:    [[SUB23:%.*]] = sub i32 [[TMP25]], [[TMP26]]
// CHECK2-NEXT:    [[SUB24:%.*]] = sub i32 [[SUB23]], 1
// CHECK2-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTNEW_STEP21]], align 4
// CHECK2-NEXT:    [[ADD25:%.*]] = add i32 [[SUB24]], [[TMP27]]
// CHECK2-NEXT:    [[TMP28:%.*]] = load i32, ptr [[DOTNEW_STEP21]], align 4
// CHECK2-NEXT:    [[DIV26:%.*]] = udiv i32 [[ADD25]], [[TMP28]]
// CHECK2-NEXT:    [[SUB27:%.*]] = sub i32 [[DIV26]], 1
// CHECK2-NEXT:    store i32 [[SUB27]], ptr [[DOTCAPTURE_EXPR_22]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_LB2]], align 4
// CHECK2-NEXT:    store i32 1, ptr [[DOTOMP_ST2]], align 4
// CHECK2-NEXT:    [[TMP29:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_22]], align 4
// CHECK2-NEXT:    [[ADD28:%.*]] = add i32 [[TMP29]], 1
// CHECK2-NEXT:    store i32 [[ADD28]], ptr [[DOTOMP_NI2]], align 4
// CHECK2-NEXT:    [[TMP30:%.*]] = load i32, ptr [[DOTOMP_NI0]], align 4
// CHECK2-NEXT:    store i32 [[TMP30]], ptr [[DOTOMP_TEMP_1]], align 4
// CHECK2-NEXT:    [[TMP31:%.*]] = load i32, ptr [[DOTOMP_TEMP_1]], align 4
// CHECK2-NEXT:    [[TMP32:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[TMP31]], [[TMP32]]
// CHECK2-NEXT:    br i1 [[CMP]], label %[[COND_TRUE:.*]], label %[[COND_FALSE:.*]]
// CHECK2:       [[COND_TRUE]]:
// CHECK2-NEXT:    [[TMP33:%.*]] = load i32, ptr [[DOTOMP_TEMP_1]], align 4
// CHECK2-NEXT:    br label %[[COND_END:.*]]
// CHECK2:       [[COND_FALSE]]:
// CHECK2-NEXT:    [[TMP34:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK2-NEXT:    br label %[[COND_END]]
// CHECK2:       [[COND_END]]:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP33]], %[[COND_TRUE]] ], [ [[TMP34]], %[[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], ptr [[DOTOMP_TEMP_2]], align 4
// CHECK2-NEXT:    [[TMP35:%.*]] = load i32, ptr [[DOTOMP_TEMP_2]], align 4
// CHECK2-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_NI2]], align 4
// CHECK2-NEXT:    [[CMP29:%.*]] = icmp ugt i32 [[TMP35]], [[TMP36]]
// CHECK2-NEXT:    br i1 [[CMP29]], label %[[COND_TRUE30:.*]], label %[[COND_FALSE31:.*]]
// CHECK2:       [[COND_TRUE30]]:
// CHECK2-NEXT:    [[TMP37:%.*]] = load i32, ptr [[DOTOMP_TEMP_2]], align 4
// CHECK2-NEXT:    br label %[[COND_END32:.*]]
// CHECK2:       [[COND_FALSE31]]:
// CHECK2-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_NI2]], align 4
// CHECK2-NEXT:    br label %[[COND_END32]]
// CHECK2:       [[COND_END32]]:
// CHECK2-NEXT:    [[COND33:%.*]] = phi i32 [ [[TMP37]], %[[COND_TRUE30]] ], [ [[TMP38]], %[[COND_FALSE31]] ]
// CHECK2-NEXT:    store i32 [[COND33]], ptr [[DOTOMP_FUSE_MAX]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    br label %[[FOR_COND:.*]]
// CHECK2:       [[FOR_COND]]:
// CHECK2-NEXT:    [[TMP39:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_FUSE_MAX]], align 4
// CHECK2-NEXT:    [[CMP34:%.*]] = icmp ult i32 [[TMP39]], [[TMP40]]
// CHECK2-NEXT:    br i1 [[CMP34]], label %[[FOR_BODY:.*]], label %[[FOR_END:.*]]
// CHECK2:       [[FOR_BODY]]:
// CHECK2-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_NI0]], align 4
// CHECK2-NEXT:    [[CMP35:%.*]] = icmp ult i32 [[TMP41]], [[TMP42]]
// CHECK2-NEXT:    br i1 [[CMP35]], label %[[IF_THEN:.*]], label %[[IF_END:.*]]
// CHECK2:       [[IF_THEN]]:
// CHECK2-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_LB0]], align 4
// CHECK2-NEXT:    [[TMP44:%.*]] = load i32, ptr [[DOTOMP_ST0]], align 4
// CHECK2-NEXT:    [[TMP45:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[MUL:%.*]] = mul i32 [[TMP44]], [[TMP45]]
// CHECK2-NEXT:    [[ADD36:%.*]] = add i32 [[TMP43]], [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD36]], ptr [[DOTOMP_IV0]], align 4
// CHECK2-NEXT:    [[TMP46:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV0]], align 4
// CHECK2-NEXT:    [[TMP48:%.*]] = load i32, ptr [[DOTNEW_STEP]], align 4
// CHECK2-NEXT:    [[MUL37:%.*]] = mul i32 [[TMP47]], [[TMP48]]
// CHECK2-NEXT:    [[ADD38:%.*]] = add i32 [[TMP46]], [[MUL37]]
// CHECK2-NEXT:    store i32 [[ADD38]], ptr [[I]], align 4
// CHECK2-NEXT:    [[TMP49:%.*]] = load i32, ptr [[I]], align 4
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP49]])
// CHECK2-NEXT:    br label %[[IF_END]]
// CHECK2:       [[IF_END]]:
// CHECK2-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[TMP51:%.*]] = load i32, ptr [[DOTOMP_NI1]], align 4
// CHECK2-NEXT:    [[CMP39:%.*]] = icmp ult i32 [[TMP50]], [[TMP51]]
// CHECK2-NEXT:    br i1 [[CMP39]], label %[[IF_THEN40:.*]], label %[[IF_END45:.*]]
// CHECK2:       [[IF_THEN40]]:
// CHECK2-NEXT:    [[TMP52:%.*]] = load i32, ptr [[DOTOMP_LB1]], align 4
// CHECK2-NEXT:    [[TMP53:%.*]] = load i32, ptr [[DOTOMP_ST1]], align 4
// CHECK2-NEXT:    [[TMP54:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[MUL41:%.*]] = mul i32 [[TMP53]], [[TMP54]]
// CHECK2-NEXT:    [[ADD42:%.*]] = add i32 [[TMP52]], [[MUL41]]
// CHECK2-NEXT:    store i32 [[ADD42]], ptr [[DOTOMP_IV1]], align 4
// CHECK2-NEXT:    [[TMP55:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_6]], align 4
// CHECK2-NEXT:    [[TMP56:%.*]] = load i32, ptr [[DOTOMP_IV1]], align 4
// CHECK2-NEXT:    [[TMP57:%.*]] = load i32, ptr [[DOTNEW_STEP8]], align 4
// CHECK2-NEXT:    [[MUL43:%.*]] = mul i32 [[TMP56]], [[TMP57]]
// CHECK2-NEXT:    [[SUB44:%.*]] = sub i32 [[TMP55]], [[MUL43]]
// CHECK2-NEXT:    store i32 [[SUB44]], ptr [[J]], align 4
// CHECK2-NEXT:    [[TMP58:%.*]] = load i32, ptr [[J]], align 4
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP58]])
// CHECK2-NEXT:    br label %[[IF_END45]]
// CHECK2:       [[IF_END45]]:
// CHECK2-NEXT:    [[TMP59:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[TMP60:%.*]] = load i32, ptr [[DOTOMP_NI2]], align 4
// CHECK2-NEXT:    [[CMP46:%.*]] = icmp ult i32 [[TMP59]], [[TMP60]]
// CHECK2-NEXT:    br i1 [[CMP46]], label %[[IF_THEN47:.*]], label %[[IF_END52:.*]]
// CHECK2:       [[IF_THEN47]]:
// CHECK2-NEXT:    [[TMP61:%.*]] = load i32, ptr [[DOTOMP_LB2]], align 4
// CHECK2-NEXT:    [[TMP62:%.*]] = load i32, ptr [[DOTOMP_ST2]], align 4
// CHECK2-NEXT:    [[TMP63:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[MUL48:%.*]] = mul i32 [[TMP62]], [[TMP63]]
// CHECK2-NEXT:    [[ADD49:%.*]] = add i32 [[TMP61]], [[MUL48]]
// CHECK2-NEXT:    store i32 [[ADD49]], ptr [[DOTOMP_IV2]], align 4
// CHECK2-NEXT:    [[TMP64:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_17]], align 4
// CHECK2-NEXT:    [[TMP65:%.*]] = load i32, ptr [[DOTOMP_IV2]], align 4
// CHECK2-NEXT:    [[TMP66:%.*]] = load i32, ptr [[DOTNEW_STEP21]], align 4
// CHECK2-NEXT:    [[MUL50:%.*]] = mul i32 [[TMP65]], [[TMP66]]
// CHECK2-NEXT:    [[ADD51:%.*]] = add i32 [[TMP64]], [[MUL50]]
// CHECK2-NEXT:    store i32 [[ADD51]], ptr [[K]], align 4
// CHECK2-NEXT:    [[TMP67:%.*]] = load i32, ptr [[K]], align 4
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP67]])
// CHECK2-NEXT:    br label %[[IF_END52]]
// CHECK2:       [[IF_END52]]:
// CHECK2-NEXT:    br label %[[FOR_INC:.*]]
// CHECK2:       [[FOR_INC]]:
// CHECK2-NEXT:    [[TMP68:%.*]] = load i32, ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    [[INC:%.*]] = add i32 [[TMP68]], 1
// CHECK2-NEXT:    store i32 [[INC]], ptr [[DOTOMP_FUSE_INDEX]], align 4
// CHECK2-NEXT:    br label %[[FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK2:       [[FOR_END]]:
// CHECK2-NEXT:    ret void
//
//.
// CHECK1: [[LOOP3]] = distinct !{[[LOOP3]], [[META4:![0-9]+]]}
// CHECK1: [[META4]] = !{!"llvm.loop.mustprogress"}
// CHECK1: [[LOOP5]] = distinct !{[[LOOP5]], [[META4]]}
// CHECK1: [[LOOP6]] = distinct !{[[LOOP6]], [[META4]]}
// CHECK1: [[LOOP7]] = distinct !{[[LOOP7]], [[META4]]}
// CHECK1: [[LOOP8]] = distinct !{[[LOOP8]], [[META4]]}
// CHECK1: [[LOOP9]] = distinct !{[[LOOP9]], [[META4]]}
// CHECK1: [[LOOP10]] = distinct !{[[LOOP10]], [[META4]]}
//.
// CHECK2: [[LOOP3]] = distinct !{[[LOOP3]], [[META4:![0-9]+]]}
// CHECK2: [[META4]] = !{!"llvm.loop.mustprogress"}
// CHECK2: [[LOOP5]] = distinct !{[[LOOP5]], [[META4]]}
// CHECK2: [[LOOP6]] = distinct !{[[LOOP6]], [[META4]]}
// CHECK2: [[LOOP7]] = distinct !{[[LOOP7]], [[META4]]}
// CHECK2: [[LOOP8]] = distinct !{[[LOOP8]], [[META4]]}
// CHECK2: [[LOOP9]] = distinct !{[[LOOP9]], [[META4]]}
// CHECK2: [[LOOP10]] = distinct !{[[LOOP10]], [[META4]]}
//.
