/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	resourcev1beta1 "k8s.io/api/resource/v1beta1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// ResourceClaimLister helps list ResourceClaims.
// All objects returned here must be treated as read-only.
type ResourceClaimLister interface {
	// List lists all ResourceClaims in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*resourcev1beta1.ResourceClaim, err error)
	// ResourceClaims returns an object that can list and get ResourceClaims.
	ResourceClaims(namespace string) ResourceClaimNamespaceLister
	ResourceClaimListerExpansion
}

// resourceClaimLister implements the ResourceClaimLister interface.
type resourceClaimLister struct {
	listers.ResourceIndexer[*resourcev1beta1.ResourceClaim]
}

// NewResourceClaimLister returns a new ResourceClaimLister.
func NewResourceClaimLister(indexer cache.Indexer) ResourceClaimLister {
	return &resourceClaimLister{listers.New[*resourcev1beta1.ResourceClaim](indexer, resourcev1beta1.Resource("resourceclaim"))}
}

// ResourceClaims returns an object that can list and get ResourceClaims.
func (s *resourceClaimLister) ResourceClaims(namespace string) ResourceClaimNamespaceLister {
	return resourceClaimNamespaceLister{listers.NewNamespaced[*resourcev1beta1.ResourceClaim](s.ResourceIndexer, namespace)}
}

// ResourceClaimNamespaceLister helps list and get ResourceClaims.
// All objects returned here must be treated as read-only.
type ResourceClaimNamespaceLister interface {
	// List lists all ResourceClaims in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*resourcev1beta1.ResourceClaim, err error)
	// Get retrieves the ResourceClaim from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*resourcev1beta1.ResourceClaim, error)
	ResourceClaimNamespaceListerExpansion
}

// resourceClaimNamespaceLister implements the ResourceClaimNamespaceLister
// interface.
type resourceClaimNamespaceLister struct {
	listers.ResourceIndexer[*resourcev1beta1.ResourceClaim]
}
