//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// A set of categories for an email.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimailconversationentrykind?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIMailConversationEntryKind(pub NSInteger);
impl UIMailConversationEntryKind {
    /// The email does not fit in a specific category.
    #[doc(alias = "UIMailConversationEntryKindNone")]
    pub const None: Self = Self(0);
    /// The email is personal correspondence.
    #[doc(alias = "UIMailConversationEntryKindPersonal")]
    pub const Personal: Self = Self(1);
    /// The email contains a promotional offer.
    #[doc(alias = "UIMailConversationEntryKindPromotion")]
    pub const Promotion: Self = Self(2);
    /// The email is related to social media.
    #[doc(alias = "UIMailConversationEntryKindSocial")]
    pub const Social: Self = Self(3);
    /// The email is related to a purchase or transaction.
    #[doc(alias = "UIMailConversationEntryKindTransaction")]
    pub const Transaction: Self = Self(4);
    /// The email is related to news or current events.
    #[doc(alias = "UIMailConversationEntryKindNews")]
    pub const News: Self = Self(5);
}

unsafe impl Encode for UIMailConversationEntryKind {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIMailConversationEntryKind {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// A class that represents a specific email in an email thread.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimailconversationentry?language=objc)
    #[unsafe(super(UIConversationEntry, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "UIConversationEntry")]
    pub struct UIMailConversationEntry;
);

#[cfg(feature = "UIConversationEntry")]
extern_conformance!(
    unsafe impl NSObjectProtocol for UIMailConversationEntry {}
);

#[cfg(feature = "UIConversationEntry")]
impl UIMailConversationEntry {
    extern_methods!(
        /// An item that reflects the category that describes an email.
        #[unsafe(method(kind))]
        #[unsafe(method_family = none)]
        pub fn kind(&self) -> UIMailConversationEntryKind;

        /// Setter for [`kind`][Self::kind].
        #[unsafe(method(setKind:))]
        #[unsafe(method_family = none)]
        pub fn setKind(&self, kind: UIMailConversationEntryKind);

        /// A set of strings that identifies the secondary recipients of the message, such as those in CC or BCC messages.
        #[unsafe(method(responseSecondaryRecipientIdentifiers))]
        #[unsafe(method_family = none)]
        pub fn responseSecondaryRecipientIdentifiers(&self) -> Retained<NSSet<NSString>>;

        /// Setter for [`responseSecondaryRecipientIdentifiers`][Self::responseSecondaryRecipientIdentifiers].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setResponseSecondaryRecipientIdentifiers:))]
        #[unsafe(method_family = none)]
        pub fn setResponseSecondaryRecipientIdentifiers(
            &self,
            response_secondary_recipient_identifiers: &NSSet<NSString>,
        );
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "UIConversationEntry")]
impl UIMailConversationEntry {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

#[cfg(feature = "UIConversationEntry")]
impl DefaultRetained for UIMailConversationEntry {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}
