/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities.soql;

import java.util.HashMap;
import java.util.Map;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.utilities.soql.JSJavaClass;
import sun.jvm.hotspot.utilities.soql.JSJavaFactory;
import sun.jvm.hotspot.utilities.soql.ScriptObject;

public abstract class JSJavaKlass {
    private static final int FIELD_SUPER_CLASS = 0;
    private static final int FIELD_NAME = 1;
    private static final int FIELD_IS_ARRAY_CLASS = 2;
    private static final int FIELD_UNDEFINED = -1;
    private static Map fields = new HashMap();
    protected final JSJavaFactory factory;
    private final Klass klass;

    public JSJavaKlass(Klass klass, JSJavaFactory factory) {
        this.factory = factory;
        this.klass = klass;
    }

    public final Klass getKlass() {
        return this.klass;
    }

    public JSJavaClass getJSJavaClass() {
        return (JSJavaClass)this.factory.newJSJavaObject(this.getKlass().getJavaMirror());
    }

    public Object getMetaClassFieldValue(String name) {
        int fieldID = JSJavaKlass.getFieldID(name);
        switch (fieldID) {
            case 0: {
                JSJavaKlass jk = this.factory.newJSJavaKlass(this.getKlass().getSuper());
                return jk != null ? jk.getJSJavaClass() : null;
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.isArray();
            }
        }
        return ScriptObject.UNDEFINED;
    }

    public boolean hasMetaClassField(String name) {
        return JSJavaKlass.getFieldID(name) != -1;
    }

    public String[] getMetaClassFieldNames() {
        String[] res = new String[]{"name", "superClass", "isArrayClass"};
        return res;
    }

    public abstract String getName();

    public abstract boolean isArray();

    private static void addField(String name, int fieldId) {
        fields.put(name, new Integer(fieldId));
    }

    private static int getFieldID(String name) {
        Integer res = (Integer)fields.get(name);
        return res != null ? res : -1;
    }

    static {
        JSJavaKlass.addField("base", 0);
        JSJavaKlass.addField("baseClass", 0);
        JSJavaKlass.addField("superClass", 0);
        JSJavaKlass.addField("name", 1);
        JSJavaKlass.addField("isArrayClass", 2);
    }
}

