/*
 * Copyright 2024 The Error Prone Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.errorprone.bugpatterns;

import com.google.errorprone.CompilationTestHelper;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(JUnit4.class)
public final class SetUnrecognizedTest {
  private final CompilationTestHelper compilationHelper =
      CompilationTestHelper.newInstance(SetUnrecognized.class, getClass());

  @Test
  public void positive() {
    compilationHelper
        .addSourceLines(
            "Test.java",
            """
            import com.google.errorprone.bugpatterns.proto.Proto3Test.TestProto3Enum;
            import com.google.errorprone.bugpatterns.proto.Proto3Test.TestProto3Message;

            class Test {
              void test() {
                // BUG: Diagnostic contains:
                TestProto3Message.newBuilder().setMyEnum(TestProto3Enum.UNRECOGNIZED);
              }
            }
            """)
        .doTest();
  }

  @Test
  public void negative() {
    compilationHelper
        .addSourceLines(
            "Test.java",
            """
            import com.google.errorprone.bugpatterns.proto.Proto3Test.TestProto3Enum;
            import com.google.errorprone.bugpatterns.proto.Proto3Test.TestProto3Message;

            class Test {
              void test() {
                TestProto3Message.newBuilder().setMyEnum(TestProto3Enum.VALUE_1);
              }
            }
            """)
        .doTest();
  }

  @Test
  public void negativeNotEnum() {
    compilationHelper
        .addSourceLines(
            "Test.java",
            """
            import com.google.errorprone.bugpatterns.proto.Proto3Test.TestProto3Enum;
            import com.google.errorprone.bugpatterns.proto.Proto3Test.TestProto3Message;

            class Test {
              void test() {
                TestProto3Message.newBuilder().setMyString("");
              }
            }
            """)
        .doTest();
  }
}
