/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.code.plugin;

import com.anthropic.code.plugin.ClaudeCodeLog;
import com.anthropic.code.plugin.settings.PluginSettings;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005\u001a\u001a\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005\u001a\u0006\u0010\u0013\u001a\u00020\u0005\u001a\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0006\u0010\u0017\u001a\u00020\u0015\u001a\u0006\u0010\u0018\u001a\u00020\u0019\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOGGER", "()Lcom/intellij/openapi/diagnostic/Logger;", "pathToFileUri", "", "path", "normalizeUriToPath", "openVirtualFileFromPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectDir", "Ljava/nio/file/Path;", "convertFromOSFilePath", "osPath", "convertToOSFilePath", "project", "Lcom/intellij/openapi/project/Project;", "normalizeFromOSLineEndings", "s", "getPluginVersion", "detectMaybeRemoteDev", "", "PERSIST_KEY_IS_FIRST_RUN_COMPLETE", "isFirstRun", "markFirstRunComplete", "", "claude-code-jetbrains-plugin"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/anthropic/code/plugin/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,152:1\n1#2:153\n13#3:154\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/anthropic/code/plugin/UtilsKt\n*L\n17#1:154\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final String PERSIST_KEY_IS_FIRST_RUN_COMPLETE = "com.anthropic.code.plugin.isFirstRunComplete";

    @NotNull
    public static final Logger getLOGGER() {
        return LOGGER;
    }

    @NotNull
    public static final String pathToFileUri(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.startsWith$default((String)path, (String)"file://", (boolean)false, (int)2, null)) {
            return path;
        }
        return "file://" + path;
    }

    @NotNull
    public static final String normalizeUriToPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)path, (String)"file://", (String)"", (boolean)false, (int)4, null), (String)"_claude_fs_right:", (String)"", (boolean)false, (int)4, null);
    }

    @Nullable
    public static final VirtualFile openVirtualFileFromPath(@NotNull String path, @NotNull Path projectDir) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem fs = localFileSystem;
        return (VirtualFile)ActionsKt.runReadAction(() -> UtilsKt.openVirtualFileFromPath$lambda$0(fs, path, projectDir));
    }

    @NotNull
    public static final String convertFromOSFilePath(@NotNull String osPath) {
        Regex wslPattern;
        MatchResult wslMatch;
        Regex windowsPattern;
        MatchResult windowsMatch;
        Intrinsics.checkNotNullParameter((Object)osPath, (String)"osPath");
        if (!SystemInfo.isWindows) {
            return osPath;
        }
        String normalizedPath = StringsKt.replace$default((String)osPath, (char)'\\', (char)'/', (boolean)false, (int)4, null);
        PluginSettings settings = PluginSettings.Companion.getInstance();
        if (settings.getEnableWindowsDriveMapping() && (windowsMatch = (windowsPattern = new Regex("^([A-Za-z]):/(.*)$")).matchEntire((CharSequence)normalizedPath)) != null) {
            String string = ((String)windowsMatch.getGroupValues().get(1)).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String driveLetter = string;
            String remainingPath = (String)windowsMatch.getGroupValues().get(2);
            return "/mnt/" + driveLetter + "/" + remainingPath;
        }
        if (settings.getEnableWslLocalhostMapping() && (wslMatch = (wslPattern = new Regex("^//wsl[^/]*/[^/]+/(.*)$")).matchEntire((CharSequence)normalizedPath)) != null) {
            String remainingPath = (String)wslMatch.getGroupValues().get(1);
            return "/" + remainingPath;
        }
        return normalizedPath;
    }

    @NotNull
    public static final String convertToOSFilePath(@NotNull String path, @Nullable Project project) {
        Regex wslPattern;
        MatchResult wslMatch;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!SystemInfo.isWindows) {
            return path;
        }
        String normalizedPath = StringsKt.replace$default((String)path, (char)'\\', (char)'/', (boolean)false, (int)4, null);
        PluginSettings settings = PluginSettings.Companion.getInstance();
        Regex windowsPattern = new Regex("^[A-Za-z]:/.*$");
        if (windowsPattern.matches((CharSequence)normalizedPath)) {
            return normalizedPath;
        }
        if (settings.getEnableWindowsDriveMapping() && (wslMatch = (wslPattern = new Regex("^/mnt/([a-zA-Z])/(.*)$")).matchEntire((CharSequence)normalizedPath)) != null) {
            String string = ((String)wslMatch.getGroupValues().get(1)).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            String driveLetter = string;
            String remainingPath = (String)wslMatch.getGroupValues().get(2);
            return driveLetter + ":/" + remainingPath;
        }
        if (settings.getEnableWslLocalhostMapping()) {
            String effectivePathPrefix = StringsKt.replace$default((String)settings.getWslLocalhostMappingPathPrefix(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
            if (((CharSequence)effectivePathPrefix).length() == 0 && project != null) {
                Regex wslPattern2;
                MatchResult match;
                String basePath;
                String string = project.getBasePath();
                String string2 = basePath = string != null ? StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null) : null;
                if (basePath != null && (match = (wslPattern2 = new Regex("^(//wsl[^/]*/[^/]+)/.*$")).matchEntire((CharSequence)basePath)) != null) {
                    effectivePathPrefix = (String)match.getGroupValues().get(1);
                }
            }
            if (((CharSequence)effectivePathPrefix).length() > 0) {
                if (StringsKt.startsWith$default((String)normalizedPath, (String)effectivePathPrefix, (boolean)false, (int)2, null)) {
                    return normalizedPath;
                }
                String pathWithPrefix = StringsKt.removeSuffix((String)effectivePathPrefix, (CharSequence)"/") + "/" + StringsKt.removePrefix((String)normalizedPath, (CharSequence)"/");
                return pathWithPrefix;
            }
        }
        return normalizedPath;
    }

    public static /* synthetic */ String convertToOSFilePath$default(String string, Project project, int n, Object object) {
        if ((n & 2) != 0) {
            project = null;
        }
        return UtilsKt.convertToOSFilePath(string, project);
    }

    @NotNull
    public static final String normalizeFromOSLineEndings(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return StringsKt.replace$default((String)s, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String getPluginVersion() {
        IdeaPluginDescriptor plugin;
        Object object;
        IdeaPluginDescriptor ideaPluginDescriptor;
        PluginId pluginId;
        PluginId pluginId2 = pluginId = PluginId.findId((String)"com.anthropic.code.plugin");
        if (pluginId2 != null) {
            PluginId it = pluginId2;
            boolean bl = false;
            ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)it);
        } else {
            ideaPluginDescriptor = null;
        }
        if ((object = (plugin = ideaPluginDescriptor)) == null || (object = object.getVersion()) == null) {
            object = "0.0.1-unknown";
        }
        return object;
    }

    public static final boolean detectMaybeRemoteDev(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return false;
    }

    public static final boolean isFirstRun() {
        return !PropertiesComponent.getInstance().getBoolean(PERSIST_KEY_IS_FIRST_RUN_COMPLETE, false);
    }

    public static final void markFirstRunComplete() {
        PropertiesComponent.getInstance().setValue(PERSIST_KEY_IS_FIRST_RUN_COMPLETE, true);
    }

    private static final VirtualFile openVirtualFileFromPath$lambda$0(LocalFileSystem $fs, String $path, Path $projectDir) {
        VirtualFile virtualFile = $fs.findFileByPath($path);
        if (virtualFile == null) {
            virtualFile = $fs.refreshAndFindFileByNioFile($projectDir.resolve($path));
        }
        return virtualFile;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ClaudeCodeLog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
    }
}

