/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.eclipse.ui.internal.progress.AbstractProgressViewer;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressContentProvider;
import org.eclipse.ui.internal.progress.ProgressViewUpdater;

public class ProgressViewerContentProvider
extends ProgressContentProvider {
    protected AbstractProgressViewer progressViewer;
    private boolean showFinished;
    private boolean refreshNeeded;

    public ProgressViewerContentProvider(AbstractProgressViewer structured, boolean debug, boolean showFinished) {
        super(debug);
        this.progressViewer = structured;
        this.showFinished = showFinished;
        this.startListening();
    }

    public void stopListening() {
        ProgressViewUpdater.getSingleton().removeCollector(this);
        this.refreshNeeded = true;
    }

    public void startListening() {
        ProgressViewUpdater.getSingleton().addCollector(this, this.showFinished);
        if (this.refreshNeeded) {
            this.refreshNeeded = false;
            this.refresh();
        }
    }

    @Override
    public void refresh() {
        this.progressViewer.refresh(true);
    }

    @Override
    public void refresh(JobTreeElement ... elements) {
        JobTreeElement[] jobTreeElementArray = this.getRoots(elements, true);
        int n = jobTreeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            JobTreeElement refresh = jobTreeElementArray[n2];
            this.progressViewer.refresh(refresh, true);
            ++n2;
        }
    }

    @Override
    public Object[] getElements(Object inputElement) {
        Object[] elements = super.getElements(inputElement);
        if (!this.showFinished) {
            return elements;
        }
        JobTreeElement[] kept = FinishedJobs.getInstance().getKeptElements();
        if (kept.length == 0) {
            return elements;
        }
        LinkedHashSet<Object> all = new LinkedHashSet<Object>();
        all.addAll(Arrays.asList(elements));
        JobTreeElement[] jobTreeElementArray = kept;
        int n = kept.length;
        int n2 = 0;
        while (n2 < n) {
            JobTreeElement next = jobTreeElementArray[n2];
            if (next.getParent() == null || !all.contains(next.getParent())) {
                all.add(next);
            }
            ++n2;
        }
        return all.toArray();
    }

    private JobTreeElement[] getRoots(JobTreeElement[] elements, boolean subWithParent) {
        if (elements.length == 0) {
            return elements;
        }
        LinkedHashSet<JobTreeElement> roots = new LinkedHashSet<JobTreeElement>();
        JobTreeElement[] jobTreeElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            JobTreeElement jobTreeElement = jobTreeElementArray[n2];
            if (jobTreeElement.isJobInfo()) {
                GroupInfo group = ((JobInfo)jobTreeElement).getGroupInfo();
                if (group == null) {
                    roots.add(jobTreeElement);
                } else if (subWithParent) {
                    roots.add(group);
                }
            } else {
                roots.add(jobTreeElement);
            }
            ++n2;
        }
        return roots.toArray(new JobTreeElement[0]);
    }

    @Override
    public void add(JobTreeElement ... elements) {
        this.progressViewer.add(elements);
    }

    @Override
    public void remove(JobTreeElement ... elements) {
        this.progressViewer.remove(elements);
    }

    public void dispose() {
        this.stopListening();
        super.dispose();
    }
}

