/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class RootDSE
extends ReadOnlyEntry {
    @NotNull
    public static final String ATTR_ALT_SERVER = "altServer";
    @NotNull
    public static final String ATTR_CHANGELOG_DN = "changelog";
    @NotNull
    public static final String ATTR_FIRST_CHANGE_NUMBER = "firstChangeNumber";
    @NotNull
    public static final String ATTR_LAST_CHANGE_NUMBER = "lastChangeNumber";
    @NotNull
    public static final String ATTR_LAST_PURGED_CHANGE_NUMBER = "lastPurgedChangeNumber";
    @NotNull
    public static final String ATTR_NAMING_CONTEXT = "namingContexts";
    @NotNull
    public static final String ATTR_SUBSCHEMA_SUBENTRY = "subschemaSubentry";
    @NotNull
    public static final String ATTR_SUPPORTED_AUTH_PASSWORD_STORAGE_SCHEME = "supportedAuthPasswordSchemes";
    @NotNull
    public static final String ATTR_SUPPORTED_CONTROL = "supportedControl";
    @NotNull
    public static final String ATTR_SUPPORTED_EXTENDED_OPERATION = "supportedExtension";
    @NotNull
    public static final String ATTR_SUPPORTED_FEATURE = "supportedFeatures";
    @NotNull
    public static final String ATTR_SUPPORTED_LDAP_VERSION = "supportedLDAPVersion";
    @NotNull
    public static final String ATTR_SUPPORTED_SASL_MECHANISM = "supportedSASLMechanisms";
    @NotNull
    public static final String ATTR_VENDOR_NAME = "vendorName";
    @NotNull
    public static final String ATTR_VENDOR_VERSION = "vendorVersion";
    @NotNull
    protected static final String[] REQUEST_ATTRS = new String[]{"*", "+", "altServer", "changelog", "firstChangeNumber", "lastChangeNumber", "lastPurgedChangeNumber", "namingContexts", "subschemaSubentry", "supportedAuthPasswordSchemes", "supportedControl", "supportedExtension", "supportedFeatures", "supportedLDAPVersion", "supportedSASLMechanisms", "vendorName", "vendorVersion"};
    private static final long serialVersionUID = -1678182563511570981L;

    public RootDSE(@NotNull Entry rootDSEEntry) {
        super(rootDSEEntry);
    }

    @Nullable
    public static RootDSE getRootDSE(@NotNull LDAPInterface connection) throws LDAPException {
        SearchResultEntry rootDSEEntry = connection.getEntry("", REQUEST_ATTRS);
        if (rootDSEEntry == null) {
            return null;
        }
        return new RootDSE(rootDSEEntry);
    }

    @Nullable
    public final String[] getAltServerURIs() {
        return this.getAttributeValues(ATTR_ALT_SERVER);
    }

    @Nullable
    public final String getChangelogDN() {
        return this.getAttributeValue(ATTR_CHANGELOG_DN);
    }

    @Nullable
    public final Long getFirstChangeNumber() {
        return this.getAttributeValueAsLong(ATTR_FIRST_CHANGE_NUMBER);
    }

    @Nullable
    public final Long getLastChangeNumber() {
        return this.getAttributeValueAsLong(ATTR_LAST_CHANGE_NUMBER);
    }

    @Nullable
    public final Long getLastPurgedChangeNumber() {
        return this.getAttributeValueAsLong(ATTR_LAST_PURGED_CHANGE_NUMBER);
    }

    @Nullable
    public final String[] getNamingContextDNs() {
        return this.getAttributeValues(ATTR_NAMING_CONTEXT);
    }

    @Nullable
    public final String getSubschemaSubentryDN() {
        return this.getAttributeValue(ATTR_SUBSCHEMA_SUBENTRY);
    }

    @Nullable
    public final String[] getSupportedAuthPasswordSchemeNames() {
        return this.getAttributeValues(ATTR_SUPPORTED_AUTH_PASSWORD_STORAGE_SCHEME);
    }

    public final boolean supportsAuthPasswordScheme(@NotNull String scheme) {
        return this.hasAttributeValue(ATTR_SUPPORTED_AUTH_PASSWORD_STORAGE_SCHEME, scheme);
    }

    @Nullable
    public final String[] getSupportedControlOIDs() {
        return this.getAttributeValues(ATTR_SUPPORTED_CONTROL);
    }

    public final boolean supportsControl(@NotNull String controlOID) {
        return this.hasAttributeValue(ATTR_SUPPORTED_CONTROL, controlOID);
    }

    @Nullable
    public final String[] getSupportedExtendedOperationOIDs() {
        return this.getAttributeValues(ATTR_SUPPORTED_EXTENDED_OPERATION);
    }

    public final boolean supportsExtendedOperation(@NotNull String extendedOperationOID) {
        return this.hasAttributeValue(ATTR_SUPPORTED_EXTENDED_OPERATION, extendedOperationOID);
    }

    @Nullable
    public final String[] getSupportedFeatureOIDs() {
        return this.getAttributeValues(ATTR_SUPPORTED_FEATURE);
    }

    public final boolean supportsFeature(@NotNull String featureOID) {
        return this.hasAttributeValue(ATTR_SUPPORTED_FEATURE, featureOID);
    }

    @Nullable
    public final int[] getSupportedLDAPVersions() {
        String[] versionStrs = this.getAttributeValues(ATTR_SUPPORTED_LDAP_VERSION);
        if (versionStrs == null) {
            return null;
        }
        int[] versions = new int[versionStrs.length];
        for (int i = 0; i < versionStrs.length; ++i) {
            try {
                versions[i] = Integer.parseInt(versionStrs[i]);
                continue;
            }
            catch (Exception e) {
                Debug.debugException(e);
                return null;
            }
        }
        return versions;
    }

    public final boolean supportsLDAPVersion(int ldapVersion) {
        return this.hasAttributeValue(ATTR_SUPPORTED_LDAP_VERSION, String.valueOf(ldapVersion));
    }

    @Nullable
    public final String[] getSupportedSASLMechanismNames() {
        return this.getAttributeValues(ATTR_SUPPORTED_SASL_MECHANISM);
    }

    public final boolean supportsSASLMechanism(@NotNull String mechanismName) {
        return this.hasAttributeValue(ATTR_SUPPORTED_SASL_MECHANISM, mechanismName);
    }

    @Nullable
    public final String getVendorName() {
        return this.getAttributeValue(ATTR_VENDOR_NAME);
    }

    @Nullable
    public final String getVendorVersion() {
        return this.getAttributeValue(ATTR_VENDOR_VERSION);
    }
}

