/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.rulesupport.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.module.script.ScriptExtensionProvider;
import org.openhab.core.automation.module.script.rulesupport.shared.ValueCache;
import org.openhab.core.common.ThreadPoolManager;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@NonNullByDefault
public class CacheScriptExtension
implements ScriptExtensionProvider {
    static final String PRESET_NAME = "cache";
    static final String SHARED_CACHE_NAME = "sharedCache";
    static final String PRIVATE_CACHE_NAME = "privateCache";
    private final Logger logger = LoggerFactory.getLogger(CacheScriptExtension.class);
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"common");
    private final Lock cacheLock = new ReentrantLock();
    private final Map<String, Object> sharedCache = new HashMap<String, Object>();
    private final Map<String, Set<String>> sharedCacheKeyAccessors = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, ValueCacheImpl> privateCaches = new ConcurrentHashMap<String, ValueCacheImpl>();

    public Collection<String> getDefaultPresets() {
        return Set.of();
    }

    public Collection<String> getPresets() {
        return Set.of(PRESET_NAME);
    }

    public Collection<String> getTypes() {
        return Set.of(PRIVATE_CACHE_NAME, SHARED_CACHE_NAME);
    }

    public @Nullable Object get(String scriptIdentifier, String type) throws IllegalArgumentException {
        if (SHARED_CACHE_NAME.equals(type)) {
            return new TrackingValueCacheImpl(scriptIdentifier);
        }
        if (PRIVATE_CACHE_NAME.equals(type)) {
            return this.privateCaches.computeIfAbsent(scriptIdentifier, ValueCacheImpl::new);
        }
        return null;
    }

    public Map<String, Object> importPreset(String scriptIdentifier, String preset) {
        if (PRESET_NAME.equals(preset)) {
            ValueCacheImpl privateCache = Objects.requireNonNull(this.privateCaches.computeIfAbsent(scriptIdentifier, ValueCacheImpl::new));
            return Map.of(SHARED_CACHE_NAME, new TrackingValueCacheImpl(scriptIdentifier), PRIVATE_CACHE_NAME, privateCache);
        }
        return Map.of();
    }

    public void unload(String scriptIdentifier) {
        this.cacheLock.lock();
        try {
            this.sharedCacheKeyAccessors.values().forEach(cacheKey -> {
                boolean bl = cacheKey.remove(scriptIdentifier);
            });
            Iterator<Map.Entry<String, Set<String>>> it = this.sharedCacheKeyAccessors.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Set<String>> element = it.next();
                if (!element.getValue().isEmpty()) continue;
                it.remove();
                this.asyncCancelJob(this.sharedCache.remove(element.getKey()));
            }
        }
        finally {
            this.cacheLock.unlock();
        }
        ValueCacheImpl privateCache = this.privateCaches.remove(scriptIdentifier);
        if (privateCache != null) {
            privateCache.values().forEach(this::asyncCancelJob);
        }
    }

    private void asyncCancelJob(@Nullable Object o) {
        Runnable cancelJob = null;
        if (o instanceof ScheduledFuture) {
            ScheduledFuture future = (ScheduledFuture)o;
            cancelJob = () -> {
                boolean bl = future.cancel(true);
            };
        } else if (o instanceof Timer) {
            Timer timer = (Timer)o;
            cancelJob = () -> timer.cancel();
        } else if (o instanceof org.openhab.core.automation.module.script.action.Timer) {
            org.openhab.core.automation.module.script.action.Timer timer = (org.openhab.core.automation.module.script.action.Timer)o;
            cancelJob = () -> {
                boolean bl = timer.cancel();
            };
        }
        if (cancelJob != null) {
            this.scheduler.schedule(cancelJob, 0L, TimeUnit.SECONDS);
        }
    }

    private class TrackingValueCacheImpl
    implements ValueCache {
        private final String scriptIdentifier;

        public TrackingValueCacheImpl(String scriptIdentifier) {
            this.scriptIdentifier = scriptIdentifier;
        }

        @Override
        public @Nullable Object put(String key, Object value) {
            CacheScriptExtension.this.cacheLock.lock();
            try {
                this.rememberAccessToKey(key);
                Object oldValue = CacheScriptExtension.this.sharedCache.put(key, value);
                CacheScriptExtension.this.logger.trace("PUT to cache from '{}': '{}' -> '{}' (was: '{}')", new Object[]{this.scriptIdentifier, key, value, oldValue});
                Object object = oldValue;
                return object;
            }
            finally {
                CacheScriptExtension.this.cacheLock.unlock();
            }
        }

        @Override
        public @Nullable Object remove(String key) {
            CacheScriptExtension.this.cacheLock.lock();
            try {
                CacheScriptExtension.this.sharedCacheKeyAccessors.remove(key);
                Object oldValue = CacheScriptExtension.this.sharedCache.remove(key);
                CacheScriptExtension.this.logger.trace("REMOVE from cache from '{}': '{}' -> '{}'", new Object[]{this.scriptIdentifier, key, oldValue});
                Object object = oldValue;
                return object;
            }
            finally {
                CacheScriptExtension.this.cacheLock.unlock();
            }
        }

        @Override
        public @Nullable Object get(String key) {
            CacheScriptExtension.this.cacheLock.lock();
            try {
                this.rememberAccessToKey(key);
                Object value = CacheScriptExtension.this.sharedCache.get(key);
                CacheScriptExtension.this.logger.trace("GET to cache from '{}': '{}' -> '{}'", new Object[]{this.scriptIdentifier, key, value});
                Object object = value;
                return object;
            }
            finally {
                CacheScriptExtension.this.cacheLock.unlock();
            }
        }

        @Override
        public Object get(String key, Supplier<Object> supplier) {
            CacheScriptExtension.this.cacheLock.lock();
            try {
                this.rememberAccessToKey(key);
                Object value = Objects.requireNonNull(CacheScriptExtension.this.sharedCache.computeIfAbsent(key, k -> supplier.get()));
                CacheScriptExtension.this.logger.trace("GET with supplier to cache from '{}': '{}' -> '{}'", new Object[]{this.scriptIdentifier, key, value});
                Object object = value;
                return object;
            }
            finally {
                CacheScriptExtension.this.cacheLock.unlock();
            }
        }

        @Override
        public @Nullable Object compute(String key, BiFunction<String, @Nullable Object, @Nullable Object> remappingFunction) {
            CacheScriptExtension.this.cacheLock.lock();
            try {
                Object value = CacheScriptExtension.this.sharedCache.compute(key, (? super K k, ? super V v) -> remappingFunction.apply((String)k, v));
                if (value == null) {
                    CacheScriptExtension.this.sharedCacheKeyAccessors.remove(key);
                } else {
                    this.rememberAccessToKey(key);
                }
                CacheScriptExtension.this.logger.trace("COMPUTE to cache from '{}': '{}' -> '{}'", new Object[]{this.scriptIdentifier, key, value});
                Object object = value;
                return object;
            }
            finally {
                CacheScriptExtension.this.cacheLock.unlock();
            }
        }

        private void rememberAccessToKey(String key) {
            Objects.requireNonNull(CacheScriptExtension.this.sharedCacheKeyAccessors.computeIfAbsent(key, k -> new HashSet())).add(this.scriptIdentifier);
        }
    }

    private static class ValueCacheImpl
    implements ValueCache {
        private final Map<String, Object> cache = new HashMap<String, Object>();

        public ValueCacheImpl(String scriptIdentifier) {
        }

        @Override
        public @Nullable Object put(String key, Object value) {
            return this.cache.put(key, value);
        }

        @Override
        public @Nullable Object remove(String key) {
            return this.cache.remove(key);
        }

        @Override
        public @Nullable Object get(String key) {
            return this.cache.get(key);
        }

        @Override
        public Object get(String key, Supplier<Object> supplier) {
            return Objects.requireNonNull(this.cache.computeIfAbsent(key, k -> supplier.get()));
        }

        @Override
        public @Nullable Object compute(String key, BiFunction<String, @Nullable Object, @Nullable Object> remappingFunction) {
            return this.cache.compute(key, (? super K k, ? super V v) -> remappingFunction.apply((String)k, v));
        }

        private Collection<Object> values() {
            return this.cache.values();
        }
    }
}

