/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.internal.resources.beans;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.measure.Unit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.i18n.UnitProvider;
import org.openhab.core.types.util.UnitUtils;

@NonNullByDefault
public class UoMInfoBean {
    public final UoMInfo uomInfo;

    public UoMInfoBean(UnitProvider unitProvider) {
        this.uomInfo = new UoMInfo(unitProvider);
    }

    public static class UoMInfo {
        public final List<DimensionInfo> dimensions;

        public UoMInfo(UnitProvider unitProvider) {
            this.dimensions = unitProvider.getAllDimensions().stream().map(dimension -> {
                Unit unit = unitProvider.getUnit(dimension);
                String dimensionName = Objects.requireNonNull(UnitUtils.getDimensionName((Unit)unit));
                return new DimensionInfo(dimensionName, unit.toString());
            }).sorted(Comparator.comparing(a -> a.dimension)).toList();
        }

        public static class DimensionInfo {
            public final String dimension;
            public final String systemUnit;

            public DimensionInfo(String dimension, String systemUnit) {
                this.dimension = dimension;
                this.systemUnit = systemUnit;
            }
        }
    }
}

