/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.library.unit;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Map;
import java.util.Objects;
import javax.measure.UnitConverter;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.function.Calculus;

@NonNullByDefault
public class CurrencyConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    private final BigDecimal factor;

    static {
        Map unused = Calculus.getNormalFormOrder();
        try {
            Field field = Calculus.class.getDeclaredField("normalFormOrder");
            field.setAccessible(true);
            Map original = (Map)field.get(null);
            Objects.requireNonNull(original).put(CurrencyConverter.class, 1000);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Could not add currency converter", e);
        }
    }

    public CurrencyConverter(BigDecimal factor) {
        this.factor = factor;
    }

    public boolean equals(@Nullable Object cvtr) {
        if (cvtr instanceof CurrencyConverter) {
            CurrencyConverter currencyConverter = (CurrencyConverter)((Object)cvtr);
            if (this.factor.equals(currencyConverter.factor)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.factor);
    }

    protected @Nullable String transformationLiteral() {
        return null;
    }

    protected AbstractConverter inverseWhenNotIdentity() {
        return new CurrencyConverter(BigDecimal.ONE.divide(this.factor, MathContext.DECIMAL128));
    }

    protected boolean canReduceWith(@Nullable AbstractConverter that) {
        return false;
    }

    protected Number convertWhenNotIdentity(@NonNullByDefault(value={}) Number value) {
        return new BigDecimal(value.toString()).multiply(this.factor, MathContext.DECIMAL128);
    }

    public int compareTo(@Nullable UnitConverter o) {
        int n;
        if (o instanceof CurrencyConverter) {
            CurrencyConverter currencyConverter = (CurrencyConverter)o;
            n = this.factor.compareTo(currencyConverter.factor);
        } else {
            n = -1;
        }
        return n;
    }

    public boolean isIdentity() {
        return false;
    }

    public boolean isLinear() {
        return true;
    }
}

