/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.format.SimpleQuantityFormat;
import tech.units.indriya.function.MixedRadix;
import tech.units.indriya.quantity.MixedQuantity;
import tech.units.indriya.quantity.NumberQuantity;

public final class Quantities {
    private Quantities() {
    }

    public static Quantity<?> getQuantity(CharSequence csq) {
        return SimpleQuantityFormat.getInstance("n u~ ").parse(csq);
    }

    public static <Q extends Quantity<Q>> ComparableQuantity<Q> getQuantity(Number value, Unit<Q> unit, Quantity.Scale scale) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(unit);
        Objects.requireNonNull(scale);
        return new NumberQuantity<Q>(value, unit, scale);
    }

    public static <Q extends Quantity<Q>> ComparableQuantity<Q> getQuantity(Number value, Unit<Q> unit) {
        return Quantities.getQuantity(value, unit, Quantity.Scale.ABSOLUTE);
    }

    public static <Q extends Quantity<Q>> Quantity<Q> getQuantity(Number[] values, Unit<Q>[] units, Quantity.Scale scale) {
        Objects.requireNonNull(values);
        Objects.requireNonNull(units);
        if (values.length == units.length) {
            return MixedRadix.of(units).createQuantity(values, scale);
        }
        throw new IllegalArgumentException(String.format("%s values don't match %s units", values.length, units.length));
    }

    @SafeVarargs
    public static <Q extends Quantity<Q>> Quantity<Q> getQuantity(Number[] values, Unit<Q> ... units) {
        return Quantities.getQuantity(values, units, Quantity.Scale.ABSOLUTE);
    }

    public static <Q extends Quantity<Q>> MixedQuantity<Q> getMixedQuantity(Number[] values, Unit<Q>[] units, Quantity.Scale scale) {
        Objects.requireNonNull(values);
        Objects.requireNonNull(units);
        if (values.length == units.length) {
            return MixedRadix.of(units).createMixedQuantity(values, scale);
        }
        throw new IllegalArgumentException(String.format("%s values don't match %s units", values.length, units.length));
    }

    public static <Q extends Quantity<Q>> MixedQuantity<Q> getMixedQuantity(Number[] values, Unit<Q>[] units) {
        return Quantities.getMixedQuantity(values, units, Quantity.Scale.ABSOLUTE);
    }
}

