/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.state.impl;

import java.util.HashMap;
import java.util.Map;
import org.signal.libsignal.protocol.InvalidKeyIdException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.state.PreKeyRecord;
import org.signal.libsignal.protocol.state.PreKeyStore;

public class InMemoryPreKeyStore
implements PreKeyStore {
    private final Map<Integer, byte[]> store = new HashMap<Integer, byte[]>();

    @Override
    public PreKeyRecord loadPreKey(int preKeyId) throws InvalidKeyIdException {
        try {
            if (!this.store.containsKey(preKeyId)) {
                throw new InvalidKeyIdException("No such prekeyrecord!");
            }
            return new PreKeyRecord(this.store.get(preKeyId));
        }
        catch (InvalidMessageException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void storePreKey(int preKeyId, PreKeyRecord record) {
        this.store.put(preKeyId, record.serialize());
    }

    @Override
    public boolean containsPreKey(int preKeyId) {
        return this.store.containsKey(preKeyId);
    }

    @Override
    public void removePreKey(int preKeyId) {
        this.store.remove(preKeyId);
    }
}

