"""Starlark representation of locked requirements.

@generated by rules_python pip_parse repository rule.
"""

load("@rules_python//python:pip.bzl", "pip_utils")
load("@rules_python//python/pip_install:pip_repository.bzl", "group_library", "whl_library")

all_requirements = [
    "@my_project_pip_deps_vendored_certifi//:pkg",
    "@my_project_pip_deps_vendored_charset_normalizer//:pkg",
    "@my_project_pip_deps_vendored_idna//:pkg",
    "@my_project_pip_deps_vendored_requests//:pkg",
    "@my_project_pip_deps_vendored_urllib3//:pkg",
]

all_whl_requirements_by_package = {
    "certifi": "@my_project_pip_deps_vendored_certifi//:whl",
    "charset_normalizer": "@my_project_pip_deps_vendored_charset_normalizer//:whl",
    "idna": "@my_project_pip_deps_vendored_idna//:whl",
    "requests": "@my_project_pip_deps_vendored_requests//:whl",
    "urllib3": "@my_project_pip_deps_vendored_urllib3//:whl",
}

all_whl_requirements = all_whl_requirements_by_package.values()

all_data_requirements = [
    "@my_project_pip_deps_vendored_certifi//:data",
    "@my_project_pip_deps_vendored_charset_normalizer//:data",
    "@my_project_pip_deps_vendored_idna//:data",
    "@my_project_pip_deps_vendored_requests//:data",
    "@my_project_pip_deps_vendored_urllib3//:data",
]

_packages = [
    ("my_project_pip_deps_vendored_certifi", "certifi==2023.7.22 --hash=sha256:539cc1d13202e33ca466e88b2807e29f4c13049d6d87031a3c110744495cb082 --hash=sha256:92d6037539857d8206b8f6ae472e8b77db8058fec5937a1ef3f54304089edbb9"),
    ("my_project_pip_deps_vendored_charset_normalizer", "charset-normalizer==2.1.1 --hash=sha256:5a3d016c7c547f69d6f81fb0db9449ce888b418b5b9952cc5e6e66843e9dd845 --hash=sha256:83e9a75d1911279afd89352c68b45348559d1fc0506b054b346651b5e7fee29f"),
    ("my_project_pip_deps_vendored_idna", "idna==3.4 --hash=sha256:814f528e8dead7d329833b91c5faa87d60bf71824cd12a7530b5526063d02cb4 --hash=sha256:90b77e79eaa3eba6de819a0c442c0b4ceefc341a7a2ab77d7562bf49f425c5c2"),
    ("my_project_pip_deps_vendored_requests", "requests==2.28.1 --hash=sha256:7c5599b102feddaa661c826c56ab4fee28bfd17f5abca1ebbe3e7f19d7c97983 --hash=sha256:8fefa2a1a1365bf5520aac41836fbee479da67864514bdb821f31ce07ce65349"),
    ("my_project_pip_deps_vendored_urllib3", "urllib3==1.26.13 --hash=sha256:47cc05d99aaa09c9e72ed5809b60e7ba354e64b59c9c173ac3018642d8bb41fc --hash=sha256:c083dd0dce68dbfbe1129d5271cb90f9447dea7d52097c6e0126120c521ddea8"),
]
_config = {
    "download_only": False,
    "enable_implicit_namespace_pkgs": False,
    "environment": {},
    "envsubst": ["PIP_RETRIES"],
    "extra_pip_args": ["--retries=${PIP_RETRIES:-5}"],
    "isolated": True,
    "pip_data_exclude": [],
    "python_interpreter": "python3",
    "python_interpreter_target": "@python39_host//:python",
    "quiet": True,
    "repo": "my_project_pip_deps_vendored",
    "repo_prefix": "my_project_pip_deps_vendored_",
    "timeout": 600,
}
_annotations = {}

def requirement(name):
    return "@my_project_pip_deps_vendored_{}//:{}".format(pip_utils.normalize_name(name), "pkg")

def whl_requirement(name):
    return "@my_project_pip_deps_vendored_{}//:{}".format(pip_utils.normalize_name(name), "whl")

def data_requirement(name):
    return "@my_project_pip_deps_vendored_{}//:{}".format(pip_utils.normalize_name(name), "data")

def dist_info_requirement(name):
    return "@my_project_pip_deps_vendored_{}//:{}".format(pip_utils.normalize_name(name), "dist_info")

def _get_annotation(requirement):
    # This expects to parse `setuptools==58.2.0     --hash=sha256:2551203ae6955b9876741a26ab3e767bb3242dafe86a32a749ea0d78b6792f11`
    # down to `setuptools`.
    name = requirement.split(" ")[0].split("=")[0].split("[")[0]
    return _annotations.get(name)

def install_deps(**whl_library_kwargs):
    """Repository rule macro. Install dependencies from `pip_parse`.

    Args:
       **whl_library_kwargs: Additional arguments which will flow to underlying
         `whl_library` calls. See pip_repository.bzl for details.
    """

    # Set up the requirement groups
    all_requirement_groups = {}

    requirement_group_mapping = {
        requirement: group_name
        for group_name, group_requirements in all_requirement_groups.items()
        for requirement in group_requirements
    }

    group_repo = "my_project_pip_deps_vendored__groups"
    group_library(
        name = group_repo,
        repo_prefix = "my_project_pip_deps_vendored_",
        groups = all_requirement_groups,
    )

    # Install wheels which may be participants in a group
    whl_config = dict(_config)
    whl_config.update(whl_library_kwargs)

    for name, requirement in _packages:
        group_name = requirement_group_mapping.get(name.replace("my_project_pip_deps_vendored_", ""))
        group_deps = all_requirement_groups.get(group_name, [])

        whl_library(
            name = name,
            requirement = requirement,
            group_name = group_name,
            group_deps = group_deps,
            annotation = _get_annotation(requirement),
            **whl_config
        )
