/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __lr10_dev_tstate_ip_h__
#define __lr10_dev_tstate_ip_h__
/* This file is autogenerated.  Do not edit */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_ADDRESS         0x00003488      /* R--4R */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_ADDRESS_ERROR_ADDRESS 9:0       /* R-DVF */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_ADDRESS_ERROR_ADDRESS_INIT 0x00000000 /* R-D-V */

#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_ADDRESS_VALID   0x0000348c      /* R--4R */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_ADDRESS_VALID_VALID 0:0         /* R-DVF */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_ADDRESS_VALID_VALID_INVALID 0x00000000 /* R-D-V */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_ADDRESS_VALID_VALID_VALID 0x00000001 /* R---V */

#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_ADDRESS            0x00003498      /* R--4R */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_ADDRESS_ERROR_ADDRESS 9:0          /* R-DVF */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_ADDRESS_ERROR_ADDRESS_INIT 0x00000000 /* R-D-V */

#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_ADDRESS_VALID      0x0000349c      /* R--4R */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_ADDRESS_VALID_VALID 0:0            /* R-DVF */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_ADDRESS_VALID_VALID_INVALID 0x00000000 /* R-D-V */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_ADDRESS_VALID_VALID_VALID 0x00000001 /* R---V */

#define NV_TSTATE_ERR_TD_TID_RAM_ECC_ERROR_COUNTER_LIMIT   0x000034a4      /* RW-4R */
#define NV_TSTATE_ERR_TD_TID_RAM_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT 23:0  /* RWDVF */
#define NV_TSTATE_ERR_TD_TID_RAM_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT_INIT 0x00ffffff /* RWD-V */
#define NV_TSTATE_ERR_TD_TID_RAM_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT__PROD 0x007fffff /* RW--V */

#define NV_TSTATE_ERR_LOG_EN_0                             0x00003404      /* RW-4R */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOLBUFERR               0:0             /* RWEVF */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOLBUFERR__PROD         0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOLBUFERR_DISABLE       0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOLBUFERR_ENABLE        0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOL_ECC_LIMIT_ERR       1:1             /* RWEVF */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOL_ECC_LIMIT_ERR__PROD 0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOL_ECC_LIMIT_ERR_DISABLE 0x00000000    /* RWE-V */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOL_ECC_LIMIT_ERR_ENABLE 0x00000001     /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOL_ECC_DBE_ERR         2:2             /* RWEVF */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOL_ECC_DBE_ERR__PROD   0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOL_ECC_DBE_ERR_DISABLE 0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_LOG_EN_0_TAGPOOL_ECC_DBE_ERR_ENABLE  0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTOREBUFERR            3:3             /* RWEVF */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTOREBUFERR__PROD      0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTOREBUFERR_DISABLE    0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTOREBUFERR_ENABLE     0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTORE_ECC_LIMIT_ERR    4:4             /* RWEVF */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTORE_ECC_LIMIT_ERR__PROD 0x00000001   /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTORE_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTORE_ECC_LIMIT_ERR_ENABLE 0x00000001  /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTORE_ECC_DBE_ERR      5:5             /* RWEVF */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTORE_ECC_DBE_ERR__PROD 0x00000001     /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTORE_ECC_DBE_ERR_DISABLE 0x00000000   /* RWE-V */
#define NV_TSTATE_ERR_LOG_EN_0_CRUMBSTORE_ECC_DBE_ERR_ENABLE 0x00000001    /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_TD_TID_RAMBUFERR            6:6             /* RWEVF */
#define NV_TSTATE_ERR_LOG_EN_0_TD_TID_RAMBUFERR__PROD      0x00000000      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_TD_TID_RAMBUFERR_DISABLE    0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_LOG_EN_0_TD_TID_RAMBUFERR_ENABLE     0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_TD_TID_RAM_ECC_LIMIT_ERR    7:7             /* RWEVF */
#define NV_TSTATE_ERR_LOG_EN_0_TD_TID_RAM_ECC_LIMIT_ERR__PROD 0x00000000   /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_TD_TID_RAM_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_LOG_EN_0_TD_TID_RAM_ECC_LIMIT_ERR_ENABLE 0x00000001  /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_TD_TID_RAM_ECC_DBE_ERR      8:8             /* RWEVF */
#define NV_TSTATE_ERR_LOG_EN_0_TD_TID_RAM_ECC_DBE_ERR__PROD 0x00000000     /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_TD_TID_RAM_ECC_DBE_ERR_DISABLE 0x00000000   /* RWE-V */
#define NV_TSTATE_ERR_LOG_EN_0_TD_TID_RAM_ECC_DBE_ERR_ENABLE 0x00000001    /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_ATO_ERR                     9:9             /* RWEVF */
#define NV_TSTATE_ERR_LOG_EN_0_ATO_ERR__PROD               0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_ATO_ERR_DISABLE             0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_LOG_EN_0_ATO_ERR_ENABLE              0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_CAMRSP_ERR                  10:10           /* RWEVF */
#define NV_TSTATE_ERR_LOG_EN_0_CAMRSP_ERR__PROD            0x00000001      /* RW--V */
#define NV_TSTATE_ERR_LOG_EN_0_CAMRSP_ERR_DISABLE          0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_LOG_EN_0_CAMRSP_ERR_ENABLE           0x00000001      /* RW--V */

#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0              0x00003410      /* RW-4R */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TAGPOOLBUFERR 0:0            /* RWEVF */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TAGPOOLBUFERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TAGPOOLBUFERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TAGPOOLBUFERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TAGPOOL_ECC_LIMIT_ERR 1:1    /* RWEVF */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TAGPOOL_ECC_LIMIT_ERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TAGPOOL_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TAGPOOL_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TAGPOOL_ECC_DBE_ERR 2:2      /* RWEVF */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TAGPOOL_ECC_DBE_ERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TAGPOOL_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TAGPOOL_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_CRUMBSTOREBUFERR 3:3         /* RWEVF */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_CRUMBSTOREBUFERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_CRUMBSTOREBUFERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_CRUMBSTOREBUFERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_CRUMBSTORE_ECC_LIMIT_ERR 4:4 /* RWEVF */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_CRUMBSTORE_ECC_LIMIT_ERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_CRUMBSTORE_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_CRUMBSTORE_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_CRUMBSTORE_ECC_DBE_ERR 5:5   /* RWEVF */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_CRUMBSTORE_ECC_DBE_ERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_CRUMBSTORE_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_CRUMBSTORE_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TD_TID_RAMBUFERR 6:6         /* RWEVF */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TD_TID_RAMBUFERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TD_TID_RAMBUFERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TD_TID_RAMBUFERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TD_TID_RAM_ECC_LIMIT_ERR 7:7 /* RWEVF */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TD_TID_RAM_ECC_LIMIT_ERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TD_TID_RAM_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TD_TID_RAM_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TD_TID_RAM_ECC_DBE_ERR 8:8   /* RWEVF */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TD_TID_RAM_ECC_DBE_ERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TD_TID_RAM_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_TD_TID_RAM_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_ATO_ERR      9:9             /* RWEVF */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_ATO_ERR__PROD 0x00000000     /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_ATO_ERR_DISABLE 0x00000000   /* RWE-V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_ATO_ERR_ENABLE 0x00000001    /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_CAMRSP_ERR   10:10           /* RWEVF */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_CAMRSP_ERR__PROD 0x00000000  /* RW--V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_CAMRSP_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_CORRECTABLE_REPORT_EN_0_CAMRSP_ERR_ENABLE 0x00000001 /* RW--V */

#define NV_TSTATE_ERR_MISC_LOG_0                           0x00003454      /* R--4R */
#define NV_TSTATE_ERR_MISC_LOG_0_SPORT                     5:0             /* R-IVF */
#define NV_TSTATE_ERR_MISC_LOG_0_SPORT_INIT                0x00000000      /* R-I-V */
#define NV_TSTATE_ERR_MISC_LOG_0_ENCODEDVC                 10:8            /* R-IVF */
#define NV_TSTATE_ERR_MISC_LOG_0_ENCODEDVC_CREQ            0x00000000      /* R-I-V */
#define NV_TSTATE_ERR_MISC_LOG_0_ENCODEDVC_DGD             0x00000001      /* R---V */
#define NV_TSTATE_ERR_MISC_LOG_0_ENCODEDVC_ATR             0x00000002      /* R---V */
#define NV_TSTATE_ERR_MISC_LOG_0_ENCODEDVC_ATSD            0x00000003      /* R---V */
#define NV_TSTATE_ERR_MISC_LOG_0_ENCODEDVC_PROBE           0x00000004      /* R---V */
#define NV_TSTATE_ERR_MISC_LOG_0_ENCODEDVC_CREQ_TD         0x00000005      /* R---V */
#define NV_TSTATE_ERR_MISC_LOG_0_ENCODEDVC_DGD_TD          0x00000006      /* R---V */

#define NV_TSTATE_ERR_CONTAIN_EN_0                         0x00003414      /* RW-4R */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOLBUFERR           0:0             /* RWEVF */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOLBUFERR__PROD     0x00000001      /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOLBUFERR_DISABLE   0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOLBUFERR_ENABLE    0x00000001      /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOL_ECC_LIMIT_ERR   1:1             /* RWEVF */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOL_ECC_LIMIT_ERR__PROD 0x00000000  /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOL_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOL_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOL_ECC_DBE_ERR     2:2             /* RWEVF */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOL_ECC_DBE_ERR__PROD 0x00000001    /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOL_ECC_DBE_ERR_DISABLE 0x00000000  /* RWE-V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TAGPOOL_ECC_DBE_ERR_ENABLE 0x00000001   /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTOREBUFERR        3:3             /* RWEVF */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTOREBUFERR__PROD  0x00000001      /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTOREBUFERR_DISABLE 0x00000000     /* RWE-V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTOREBUFERR_ENABLE 0x00000001      /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTORE_ECC_LIMIT_ERR 4:4            /* RWEVF */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTORE_ECC_LIMIT_ERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTORE_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTORE_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTORE_ECC_DBE_ERR  5:5             /* RWEVF */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTORE_ECC_DBE_ERR__PROD 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTORE_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CRUMBSTORE_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TD_TID_RAMBUFERR        6:6             /* RWEVF */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TD_TID_RAMBUFERR__PROD  0x00000000      /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TD_TID_RAMBUFERR_DISABLE 0x00000000     /* RWE-V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TD_TID_RAMBUFERR_ENABLE 0x00000001      /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TD_TID_RAM_ECC_LIMIT_ERR 7:7            /* RWEVF */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TD_TID_RAM_ECC_LIMIT_ERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TD_TID_RAM_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TD_TID_RAM_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TD_TID_RAM_ECC_DBE_ERR  8:8             /* RWEVF */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TD_TID_RAM_ECC_DBE_ERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TD_TID_RAM_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_TD_TID_RAM_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_ATO_ERR                 9:9             /* RWEVF */
#define NV_TSTATE_ERR_CONTAIN_EN_0_ATO_ERR__PROD           0x00000001      /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_ATO_ERR_DISABLE         0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_ATO_ERR_ENABLE          0x00000001      /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CAMRSP_ERR              10:10           /* RWEVF */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CAMRSP_ERR__PROD        0x00000001      /* RW--V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CAMRSP_ERR_DISABLE      0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_CONTAIN_EN_0_CAMRSP_ERR_ENABLE       0x00000001      /* RW--V */

#define NV_TSTATE_ERR_STATUS_0                             0x00003400      /* RW-4R */
#define NV_TSTATE_ERR_STATUS_0_TAGPOOLBUFERR               0:0             /* RWDVF */
#define NV_TSTATE_ERR_STATUS_0_TAGPOOLBUFERR_NONE          0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_STATUS_0_TAGPOOLBUFERR_CLEAR         0x00000001      /* RW--V */
#define NV_TSTATE_ERR_STATUS_0_TAGPOOL_ECC_LIMIT_ERR       1:1             /* RWDVF */
#define NV_TSTATE_ERR_STATUS_0_TAGPOOL_ECC_LIMIT_ERR_NONE  0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_STATUS_0_TAGPOOL_ECC_LIMIT_ERR_CLEAR 0x00000001      /* RW--V */
#define NV_TSTATE_ERR_STATUS_0_TAGPOOL_ECC_DBE_ERR         2:2             /* RWDVF */
#define NV_TSTATE_ERR_STATUS_0_TAGPOOL_ECC_DBE_ERR_NONE    0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_STATUS_0_TAGPOOL_ECC_DBE_ERR_CLEAR   0x00000001      /* RW--V */
#define NV_TSTATE_ERR_STATUS_0_CRUMBSTOREBUFERR            3:3             /* RWDVF */
#define NV_TSTATE_ERR_STATUS_0_CRUMBSTOREBUFERR_NONE       0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_STATUS_0_CRUMBSTOREBUFERR_CLEAR      0x00000001      /* RW--V */
#define NV_TSTATE_ERR_STATUS_0_CRUMBSTORE_ECC_LIMIT_ERR    4:4             /* RWDVF */
#define NV_TSTATE_ERR_STATUS_0_CRUMBSTORE_ECC_LIMIT_ERR_NONE 0x00000000    /* RWD-V */
#define NV_TSTATE_ERR_STATUS_0_CRUMBSTORE_ECC_LIMIT_ERR_CLEAR 0x00000001   /* RW--V */
#define NV_TSTATE_ERR_STATUS_0_CRUMBSTORE_ECC_DBE_ERR      5:5             /* RWDVF */
#define NV_TSTATE_ERR_STATUS_0_CRUMBSTORE_ECC_DBE_ERR_NONE 0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_STATUS_0_CRUMBSTORE_ECC_DBE_ERR_CLEAR 0x00000001     /* RW--V */
#define NV_TSTATE_ERR_STATUS_0_TD_TID_RAMBUFERR            6:6             /* RWDVF */
#define NV_TSTATE_ERR_STATUS_0_TD_TID_RAMBUFERR_NONE       0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_STATUS_0_TD_TID_RAMBUFERR_CLEAR      0x00000001      /* RW--V */
#define NV_TSTATE_ERR_STATUS_0_TD_TID_RAM_ECC_LIMIT_ERR    7:7             /* RWDVF */
#define NV_TSTATE_ERR_STATUS_0_TD_TID_RAM_ECC_LIMIT_ERR_NONE 0x00000000    /* RWD-V */
#define NV_TSTATE_ERR_STATUS_0_TD_TID_RAM_ECC_LIMIT_ERR_CLEAR 0x00000001   /* RW--V */
#define NV_TSTATE_ERR_STATUS_0_TD_TID_RAM_ECC_DBE_ERR      8:8             /* RWDVF */
#define NV_TSTATE_ERR_STATUS_0_TD_TID_RAM_ECC_DBE_ERR_NONE 0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_STATUS_0_TD_TID_RAM_ECC_DBE_ERR_CLEAR 0x00000001     /* RW--V */
#define NV_TSTATE_ERR_STATUS_0_ATO_ERR                     9:9             /* RWDVF */
#define NV_TSTATE_ERR_STATUS_0_ATO_ERR_NONE                0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_STATUS_0_ATO_ERR_CLEAR               0x00000001      /* RW--V */
#define NV_TSTATE_ERR_STATUS_0_CAMRSP_ERR                  10:10           /* RWDVF */
#define NV_TSTATE_ERR_STATUS_0_CAMRSP_ERR_NONE             0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_STATUS_0_CAMRSP_ERR_CLEAR            0x00000001      /* RW--V */

#define NV_TSTATE_ERR_DEBUG                                0x00003420      /* R--4R */
#define NV_TSTATE_ERR_DEBUG_ATO_SOURCE                     7:0             /* R-DVF */
#define NV_TSTATE_ERR_DEBUG_ATO_SOURCE_INIT                0x00000000      /* R-D-V */

#define NV_TSTATE_ERR_FIRST_0                              0x0000341c      /* RW-4R */
#define NV_TSTATE_ERR_FIRST_0_TAGPOOLBUFERR                0:0             /* RWDVF */
#define NV_TSTATE_ERR_FIRST_0_TAGPOOLBUFERR_NONE           0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_FIRST_0_TAGPOOLBUFERR_CLEAR          0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FIRST_0_TAGPOOL_ECC_LIMIT_ERR        1:1             /* RWDVF */
#define NV_TSTATE_ERR_FIRST_0_TAGPOOL_ECC_LIMIT_ERR_NONE   0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_FIRST_0_TAGPOOL_ECC_LIMIT_ERR_CLEAR  0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FIRST_0_TAGPOOL_ECC_DBE_ERR          2:2             /* RWDVF */
#define NV_TSTATE_ERR_FIRST_0_TAGPOOL_ECC_DBE_ERR_NONE     0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_FIRST_0_TAGPOOL_ECC_DBE_ERR_CLEAR    0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FIRST_0_CRUMBSTOREBUFERR             3:3             /* RWDVF */
#define NV_TSTATE_ERR_FIRST_0_CRUMBSTOREBUFERR_NONE        0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_FIRST_0_CRUMBSTOREBUFERR_CLEAR       0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FIRST_0_CRUMBSTORE_ECC_LIMIT_ERR     4:4             /* RWDVF */
#define NV_TSTATE_ERR_FIRST_0_CRUMBSTORE_ECC_LIMIT_ERR_NONE 0x00000000     /* RWD-V */
#define NV_TSTATE_ERR_FIRST_0_CRUMBSTORE_ECC_LIMIT_ERR_CLEAR 0x00000001    /* RW--V */
#define NV_TSTATE_ERR_FIRST_0_CRUMBSTORE_ECC_DBE_ERR       5:5             /* RWDVF */
#define NV_TSTATE_ERR_FIRST_0_CRUMBSTORE_ECC_DBE_ERR_NONE  0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_FIRST_0_CRUMBSTORE_ECC_DBE_ERR_CLEAR 0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FIRST_0_TD_TID_RAMBUFERR             6:6             /* RWDVF */
#define NV_TSTATE_ERR_FIRST_0_TD_TID_RAMBUFERR_NONE        0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_FIRST_0_TD_TID_RAMBUFERR_CLEAR       0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FIRST_0_TD_TID_RAM_ECC_LIMIT_ERR     7:7             /* RWDVF */
#define NV_TSTATE_ERR_FIRST_0_TD_TID_RAM_ECC_LIMIT_ERR_NONE 0x00000000     /* RWD-V */
#define NV_TSTATE_ERR_FIRST_0_TD_TID_RAM_ECC_LIMIT_ERR_CLEAR 0x00000001    /* RW--V */
#define NV_TSTATE_ERR_FIRST_0_TD_TID_RAM_ECC_DBE_ERR       8:8             /* RWDVF */
#define NV_TSTATE_ERR_FIRST_0_TD_TID_RAM_ECC_DBE_ERR_NONE  0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_FIRST_0_TD_TID_RAM_ECC_DBE_ERR_CLEAR 0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FIRST_0_ATO_ERR                      9:9             /* RWDVF */
#define NV_TSTATE_ERR_FIRST_0_ATO_ERR_NONE                 0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_FIRST_0_ATO_ERR_CLEAR                0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FIRST_0_CAMRSP_ERR                   10:10           /* RWDVF */
#define NV_TSTATE_ERR_FIRST_0_CAMRSP_ERR_NONE              0x00000000      /* RWD-V */
#define NV_TSTATE_ERR_FIRST_0_CAMRSP_ERR_CLEAR             0x00000001      /* RW--V */

#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_COUNTER         0x00003480      /* RW-4R */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_COUNTER_ERROR_COUNT 23:0        /* RWDVF */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_COUNTER_ERROR_COUNT_INIT 0x00000000 /* RWD-V */

#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_COUNTER_LIMIT   0x00003484      /* RW-4R */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT 23:0  /* RWDVF */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT_INIT 0x00ffffff /* RWD-V */
#define NV_TSTATE_ERR_CRUMBSTORE_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT__PROD 0x007fffff /* RW--V */

#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_COUNTER            0x00003490      /* RW-4R */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_COUNTER_ERROR_COUNT 23:0           /* RWDVF */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_COUNTER_ERROR_COUNT_INIT 0x00000000 /* RWD-V */

#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_COUNTER_LIMIT      0x00003494      /* RW-4R */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT 23:0     /* RWDVF */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT_INIT 0x00ffffff /* RWD-V */
#define NV_TSTATE_ERR_TAGPOOL_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT__PROD 0x007fffff /* RW--V */

#define NV_TSTATE_ERR_ECC_CTRL                             0x00003470      /* RW-4R */
#define NV_TSTATE_ERR_ECC_CTRL_CRUMBSTORE_ECC_ENABLE       0:0             /* RWEVF */
#define NV_TSTATE_ERR_ECC_CTRL_CRUMBSTORE_ECC_ENABLE_ENABLE 0x00000001     /* RW--V */
#define NV_TSTATE_ERR_ECC_CTRL_CRUMBSTORE_ECC_ENABLE_DISABLE 0x00000000    /* RWE-V */
#define NV_TSTATE_ERR_ECC_CTRL_CRUMBSTORE_ECC_ENABLE__PROD 0x00000001      /* RW--V */
#define NV_TSTATE_ERR_ECC_CTRL_TAGPOOL_ECC_ENABLE          1:1             /* RWEVF */
#define NV_TSTATE_ERR_ECC_CTRL_TAGPOOL_ECC_ENABLE_ENABLE   0x00000001      /* RW--V */
#define NV_TSTATE_ERR_ECC_CTRL_TAGPOOL_ECC_ENABLE_DISABLE  0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_ECC_CTRL_TAGPOOL_ECC_ENABLE__PROD    0x00000001      /* RW--V */
#define NV_TSTATE_ERR_ECC_CTRL_TD_TID_ECC_ENABLE           2:2             /* RWEVF */
#define NV_TSTATE_ERR_ECC_CTRL_TD_TID_ECC_ENABLE_ENABLE    0x00000001      /* RW--V */
#define NV_TSTATE_ERR_ECC_CTRL_TD_TID_ECC_ENABLE_DISABLE   0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_ECC_CTRL_TD_TID_ECC_ENABLE__PROD     0x00000001      /* RW--V */

#define NV_TSTATE_TAGSTATECONTROL                          0x00003040      /* RW-4R */
#define NV_TSTATE_TAGSTATECONTROL_SWECCENB                 1:1             /* RWEVF */
#define NV_TSTATE_TAGSTATECONTROL_SWECCENB_ON              0x00000001      /* RW--V */
#define NV_TSTATE_TAGSTATECONTROL_SWECCENB_OFF             0x00000000      /* RWE-V */
#define NV_TSTATE_TAGSTATECONTROL_ATO_ENB                  9:9             /* RWEVF */
#define NV_TSTATE_TAGSTATECONTROL_ATO_ENB_ON               0x00000001      /* RWE-V */
#define NV_TSTATE_TAGSTATECONTROL_ATO_ENB_OFF              0x00000000      /* RW--V */

#define NV_TSTATE_ATO_TIMER_LIMIT                          0x00003048      /* RW-4R */
#define NV_TSTATE_ATO_TIMER_LIMIT_LIMIT                    19:0            /* RWEVF */
#define NV_TSTATE_ATO_TIMER_LIMIT_LIMIT_INIT               0x000fffff      /* RWE-V */
#define NV_TSTATE_ATO_TIMER_LIMIT_LIMIT__PROD              0x00005555      /* RW--V */

#define NV_TSTATE_CREQ_CAM_LOCK                            0x00003050      /* RW-4R */
#define NV_TSTATE_CREQ_CAM_LOCK_ON                         31:0            /* RWEVF */
#define NV_TSTATE_CREQ_CAM_LOCK_ON_INIT                    0x00000000      /* RWE-V */

#define NV_TSTATE_ERR_FATAL_REPORT_EN_0                    0x00003408      /* RW-4R */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOLBUFERR      0:0             /* RWEVF */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOLBUFERR__PROD 0x00000001     /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOLBUFERR_DISABLE 0x00000000   /* RWE-V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOLBUFERR_ENABLE 0x00000001    /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOL_ECC_LIMIT_ERR 1:1          /* RWEVF */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOL_ECC_LIMIT_ERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOL_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOL_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOL_ECC_DBE_ERR 2:2            /* RWEVF */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOL_ECC_DBE_ERR__PROD 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOL_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TAGPOOL_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTOREBUFERR   3:3             /* RWEVF */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTOREBUFERR__PROD 0x00000001  /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTOREBUFERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTOREBUFERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_LIMIT_ERR 4:4       /* RWEVF */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_LIMIT_ERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_DBE_ERR 5:5         /* RWEVF */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_DBE_ERR__PROD 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TD_TID_RAMBUFERR   6:6             /* RWEVF */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TD_TID_RAMBUFERR__PROD 0x00000000  /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TD_TID_RAMBUFERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TD_TID_RAMBUFERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TD_TID_RAM_ECC_LIMIT_ERR 7:7       /* RWEVF */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TD_TID_RAM_ECC_LIMIT_ERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TD_TID_RAM_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TD_TID_RAM_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TD_TID_RAM_ECC_DBE_ERR 8:8         /* RWEVF */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TD_TID_RAM_ECC_DBE_ERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TD_TID_RAM_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_TD_TID_RAM_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_ATO_ERR            9:9             /* RWEVF */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_ATO_ERR__PROD      0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_ATO_ERR_DISABLE    0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_ATO_ERR_ENABLE     0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CAMRSP_ERR         10:10           /* RWEVF */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CAMRSP_ERR__PROD   0x00000001      /* RW--V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CAMRSP_ERR_DISABLE 0x00000000      /* RWE-V */
#define NV_TSTATE_ERR_FATAL_REPORT_EN_0_CAMRSP_ERR_ENABLE  0x00000001      /* RW--V */

#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0                0x0000340c      /* RW-4R */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOLBUFERR  0:0             /* RWEVF */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOLBUFERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOLBUFERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOLBUFERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOL_ECC_LIMIT_ERR 1:1      /* RWEVF */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOL_ECC_LIMIT_ERR__PROD 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOL_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOL_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOL_ECC_DBE_ERR 2:2        /* RWEVF */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOL_ECC_DBE_ERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOL_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TAGPOOL_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTOREBUFERR 3:3           /* RWEVF */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTOREBUFERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTOREBUFERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTOREBUFERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_LIMIT_ERR 4:4   /* RWEVF */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_LIMIT_ERR__PROD 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_DBE_ERR 5:5     /* RWEVF */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_DBE_ERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CRUMBSTORE_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TD_TID_RAMBUFERR 6:6           /* RWEVF */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TD_TID_RAMBUFERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TD_TID_RAMBUFERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TD_TID_RAMBUFERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TD_TID_RAM_ECC_LIMIT_ERR 7:7   /* RWEVF */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TD_TID_RAM_ECC_LIMIT_ERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TD_TID_RAM_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TD_TID_RAM_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TD_TID_RAM_ECC_DBE_ERR 8:8     /* RWEVF */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TD_TID_RAM_ECC_DBE_ERR__PROD 0x00000000 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TD_TID_RAM_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_TD_TID_RAM_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_ATO_ERR        9:9             /* RWEVF */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_ATO_ERR__PROD  0x00000000      /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_ATO_ERR_DISABLE 0x00000000     /* RWE-V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_ATO_ERR_ENABLE 0x00000001      /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CAMRSP_ERR     10:10           /* RWEVF */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CAMRSP_ERR__PROD 0x00000000    /* RW--V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CAMRSP_ERR_DISABLE 0x00000000  /* RWE-V */
#define NV_TSTATE_ERR_NON_FATAL_REPORT_EN_0_CAMRSP_ERR_ENABLE 0x00000001   /* RW--V */

#define NV_TSTATE_RAM_ADDRESS                              0x00003080      /* RW-4R */
#define NV_TSTATE_RAM_ADDRESS_ADDR                         9:0             /* RWEVF */
#define NV_TSTATE_RAM_ADDRESS_ADDR_INIT                    0x00000000      /* RWE-V */
#define NV_TSTATE_RAM_ADDRESS_ADDR_TAGPOOL_CRUMBSTORE_TDTID_DEPTH 0x000003ff /* RW--V */
#define NV_TSTATE_RAM_ADDRESS_ADDR_CREQ_CAM_DEPTH          0x0000001f      /* RW--V */
#define NV_TSTATE_RAM_ADDRESS_VC                           14:12           /* RWEVF */
#define NV_TSTATE_RAM_ADDRESS_VC_VC0_CREQ                  0x00000000      /* RWE-V */
#define NV_TSTATE_RAM_ADDRESS_VC_VC5_TRANSDONE             0x00000005      /* RW--V */
#define NV_TSTATE_RAM_ADDRESS_SELECT                       17:16           /* RWEVF */
#define NV_TSTATE_RAM_ADDRESS_SELECT_TAGPOOL_RAM           0x00000000      /* RWE-V */
#define NV_TSTATE_RAM_ADDRESS_SELECT_CRUMBSTORE_RAM        0x00000001      /* RW--V */
#define NV_TSTATE_RAM_ADDRESS_SELECT_TD_TID_RAM            0x00000002      /* RW--V */
#define NV_TSTATE_RAM_ADDRESS_SELECT_CREQ_CAM              0x00000003      /* RW--V */
#define NV_TSTATE_RAM_ADDRESS_AUTO_INCR                    31:31           /* RWEVF */
#define NV_TSTATE_RAM_ADDRESS_AUTO_INCR_ENABLE             0x00000001      /* RWE-V */
#define NV_TSTATE_RAM_ADDRESS_AUTO_INCR_DISABLE            0x00000000      /* RW--V */

#define NV_TSTATE_RAM_DATA1                                0x00003094      /* RW-4R */
#define NV_TSTATE_RAM_DATA1_EST                            0:0             /* RWEVF */
#define NV_TSTATE_RAM_DATA1_EST_INIT                       0x00000000      /* RWE-V */
#define NV_TSTATE_RAM_DATA1_IRL                            2:1             /* RWEVF */
#define NV_TSTATE_RAM_DATA1_IRL_INIT                       0x00000000      /* RWE-V */
#define NV_TSTATE_RAM_DATA1_BECN                           3:3             /* RWEVF */
#define NV_TSTATE_RAM_DATA1_BECN_INIT                      0x00000000      /* RWE-V */
#define NV_TSTATE_RAM_DATA1_RLAN                           7:4             /* RWEVF */
#define NV_TSTATE_RAM_DATA1_RLAN_INIT                      0x00000000      /* RWE-V */
#define NV_TSTATE_RAM_DATA1_RID                            18:8            /* RWEVF */
#define NV_TSTATE_RAM_DATA1_RID_INIT                       0x00000000      /* RWE-V */
#define NV_TSTATE_RAM_DATA1_TCEN                           19:19           /* RWEVF */
#define NV_TSTATE_RAM_DATA1_TCEN_INIT                      0x00000000      /* RWE-V */
#define NV_TSTATE_RAM_DATA1_AGE                            21:20           /* RWEVF */
#define NV_TSTATE_RAM_DATA1_AGE_INIT                       0x00000000      /* RWE-V */
#define NV_TSTATE_RAM_DATA1_VALID                          31:31           /* RWEVF */
#define NV_TSTATE_RAM_DATA1_VALID_INIT                     0x00000000      /* RWE-V */

#define NV_TSTATE_RAM_DATA0                                0x00003090      /* RW-4R */
#define NV_TSTATE_RAM_DATA0_TAG                            9:0             /* RWEVF */
#define NV_TSTATE_RAM_DATA0_TAG_INIT                       0x00000000      /* RWE-V */
#define NV_TSTATE_RAM_DATA0_ECC                            30:24           /* RWEVF */
#define NV_TSTATE_RAM_DATA0_ECC_INIT                       0x00000000      /* RWE-V */

#define NV_TSTATE_RAM_DATA2                                0x00003098      /* RW-4R */
#define NV_TSTATE_RAM_DATA2_CLOSED                         0:0             /* RWEVF */
#define NV_TSTATE_RAM_DATA2_CLOSED_INIT                    0x00000000      /* RWE-V */
#define NV_TSTATE_RAM_DATA2_COLLAP_TAG_CNT                 14:1            /* RWEVF */
#define NV_TSTATE_RAM_DATA2_COLLAP_TAG_CNT_INIT            0x00000000      /* RWE-V */
#define NV_TSTATE_RAM_DATA2_DNE                            17:17           /* RWEVF */
#define NV_TSTATE_RAM_DATA2_DNE_INIT                       0x00000000      /* RWE-V */
#endif // __lr10_dev_tstate_ip_h__
