/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	schedulingv1alpha1 "k8s.io/api/scheduling/v1alpha1"
)

// PodGroupPolicyApplyConfiguration represents a declarative configuration of the PodGroupPolicy type for use
// with apply.
//
// PodGroupPolicy defines the scheduling configuration for a PodGroup.
type PodGroupPolicyApplyConfiguration struct {
	// Basic specifies that the pods in this group should be scheduled using
	// standard Kubernetes scheduling behavior.
	Basic *schedulingv1alpha1.BasicSchedulingPolicy `json:"basic,omitempty"`
	// Gang specifies that the pods in this group should be scheduled using
	// all-or-nothing semantics.
	Gang *GangSchedulingPolicyApplyConfiguration `json:"gang,omitempty"`
}

// PodGroupPolicyApplyConfiguration constructs a declarative configuration of the PodGroupPolicy type for use with
// apply.
func PodGroupPolicy() *PodGroupPolicyApplyConfiguration {
	return &PodGroupPolicyApplyConfiguration{}
}

// WithBasic sets the Basic field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Basic field is set to the value of the last call.
func (b *PodGroupPolicyApplyConfiguration) WithBasic(value schedulingv1alpha1.BasicSchedulingPolicy) *PodGroupPolicyApplyConfiguration {
	b.Basic = &value
	return b
}

// WithGang sets the Gang field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Gang field is set to the value of the last call.
func (b *PodGroupPolicyApplyConfiguration) WithGang(value *GangSchedulingPolicyApplyConfiguration) *PodGroupPolicyApplyConfiguration {
	b.Gang = value
	return b
}
