--TEST--
bcmul() function with large numbers
--EXTENSIONS--
bcmath
--INI--
bcmath.scale=0
--FILE--
<?php
require(__DIR__ . "/run_bcmath_tests_function.inc");

$firstFactors = [
    "15151324141414.412312232141241",
    "-132132245132134.1515123765412",
    "141241241241241248267654747412",
    "-149143276547656984948124912",
    "0.1322135476547459213732911312",
    "-0.123912932193769965476541321",
];
$secondFactors = array_merge($firstFactors, [
    "0",
    "0.00",
    "-0",
    "-0.00",
    "15",
    "-15",
    "1",
    "-9",
    "14.14",
    "-16.60",
    "0.15",
    "-0.01",
]);

run_bcmath_tests($firstFactors, $secondFactors, "*", bcmul(...));

?>
--EXPECT--
Number "15151324141414.412312232141241" (scale 0)
15151324141414.412312232141241 * 15151324141414.412312232141241 = 229562623238207178422472679
15151324141414.412312232141241 * -132132245132134.1515123765412 = -2001978475529791133885654151
15151324141414.412312232141241 * 141241241241241248267654747412 = 2139991828181755439048012256383179795538025
15151324141414.412312232141241 * -149143276547656984948124912   = -2259718126486161223119790826488981524974
15151324141414.412312232141241 * 0.1322135476547459213732911312 = 2003210316403
15151324141414.412312232141241 * -0.123912932193769965476541321 = -1877445000980
15151324141414.412312232141241 * 0                              = 0
15151324141414.412312232141241 * 0.00                           = 0
15151324141414.412312232141241 * -0                             = 0
15151324141414.412312232141241 * -0.00                          = 0
15151324141414.412312232141241 * 15                             = 227269862121216
15151324141414.412312232141241 * -15                            = -227269862121216
15151324141414.412312232141241 * 1                              = 15151324141414
15151324141414.412312232141241 * -9                             = -136361917272729
15151324141414.412312232141241 * 14.14                          = 214239723359599
15151324141414.412312232141241 * -16.60                         = -251511980747479
15151324141414.412312232141241 * 0.15                           = 2272698621212
15151324141414.412312232141241 * -0.01                          = -151513241414

Number "-132132245132134.1515123765412" (scale 0)
-132132245132134.1515123765412 * 15151324141414.412312232141241 = -2001978475529791133885654151
-132132245132134.1515123765412 * -132132245132134.1515123765412 = 17458930203658389178460349344
-132132245132134.1515123765412 * 141241241241241248267654747412 = -18662522310454584290173879848464266332555498
-132132245132134.1515123765412 * -149143276547656984948124912   = 19706635976604687211527336089051267200810
-132132245132134.1515123765412 * 0.1322135476547459213732911312 = -17469672888505
-132132245132134.1515123765412 * -0.123912932193769965476541321 = 16372893931668
-132132245132134.1515123765412 * 0                              = 0
-132132245132134.1515123765412 * 0.00                           = 0
-132132245132134.1515123765412 * -0                             = 0
-132132245132134.1515123765412 * -0.00                          = 0
-132132245132134.1515123765412 * 15                             = -1981983676982012
-132132245132134.1515123765412 * -15                            = 1981983676982012
-132132245132134.1515123765412 * 1                              = -132132245132134
-132132245132134.1515123765412 * -9                             = 1189190206189207
-132132245132134.1515123765412 * 14.14                          = -1868349946168376
-132132245132134.1515123765412 * -16.60                         = 2193395269193426
-132132245132134.1515123765412 * 0.15                           = -19819836769820
-132132245132134.1515123765412 * -0.01                          = 1321322451321

Number "141241241241241248267654747412" (scale 0)
141241241241241248267654747412 * 15151324141414.412312232141241 = 2139991828181755439048012256383179795538025
141241241241241248267654747412 * -132132245132134.1515123765412 = -18662522310454584290173879848464266332555498
141241241241241248267654747412 * 141241241241241248267654747412 = 19949088227366507629622653233761071253230364164181520697744
141241241241241248267654747412 * -149143276547656984948124912   = -21065181502376778401476291731259854717478035244384727744
141241241241241248267654747412 * 0.1322135476547459213732911312 = 18674005579664314748578026521
141241241241241248267654747412 * -0.123912932193769965476541321 = -17501616348889832831364181429
141241241241241248267654747412 * 0                              = 0
141241241241241248267654747412 * 0.00                           = 0
141241241241241248267654747412 * -0                             = 0
141241241241241248267654747412 * -0.00                          = 0
141241241241241248267654747412 * 15                             = 2118618618618618724014821211180
141241241241241248267654747412 * -15                            = -2118618618618618724014821211180
141241241241241248267654747412 * 1                              = 141241241241241248267654747412
141241241241241248267654747412 * -9                             = -1271171171171171234408892726708
141241241241241248267654747412 * 14.14                          = 1997151151151151250504638128405
141241241241241248267654747412 * -16.60                         = -2344604604604604721243068807039
141241241241241248267654747412 * 0.15                           = 21186186186186187240148212111
141241241241241248267654747412 * -0.01                          = -1412412412412412482676547474

Number "-149143276547656984948124912" (scale 0)
-149143276547656984948124912 * 15151324141414.412312232141241 = -2259718126486161223119790826488981524974
-149143276547656984948124912 * -132132245132134.1515123765412 = 19706635976604687211527336089051267200810
-149143276547656984948124912 * 141241241241241248267654747412 = -21065181502376778401476291731259854717478035244384727744
-149143276547656984948124912 * -149143276547656984948124912   = 22243716939370890018820252028254140421311664755007744
-149143276547656984948124912 * 0.1322135476547459213732911312 = -19718761701218596539144441
-149143276547656984948124912 * -0.123912932193769965476541321 = 18480780714006502282899774
-149143276547656984948124912 * 0                              = 0
-149143276547656984948124912 * 0.00                           = 0
-149143276547656984948124912 * -0                             = 0
-149143276547656984948124912 * -0.00                          = 0
-149143276547656984948124912 * 15                             = -2237149148214854774221873680
-149143276547656984948124912 * -15                            = 2237149148214854774221873680
-149143276547656984948124912 * 1                              = -149143276547656984948124912
-149143276547656984948124912 * -9                             = 1342289488928912864533124208
-149143276547656984948124912 * 14.14                          = -2108885930383869767166486255
-149143276547656984948124912 * -16.60                         = 2475778390691105950138873539
-149143276547656984948124912 * 0.15                           = -22371491482148547742218736
-149143276547656984948124912 * -0.01                          = 1491432765476569849481249

Number "0.1322135476547459213732911312" (scale 0)
0.1322135476547459213732911312 * 15151324141414.412312232141241 = 2003210316403
0.1322135476547459213732911312 * -132132245132134.1515123765412 = -17469672888505
0.1322135476547459213732911312 * 141241241241241248267654747412 = 18674005579664314748578026521
0.1322135476547459213732911312 * -149143276547656984948124912   = -19718761701218596539144441
0.1322135476547459213732911312 * 0.1322135476547459213732911312 = 0
0.1322135476547459213732911312 * -0.123912932193769965476541321 = 0
0.1322135476547459213732911312 * 0                              = 0
0.1322135476547459213732911312 * 0.00                           = 0
0.1322135476547459213732911312 * -0                             = 0
0.1322135476547459213732911312 * -0.00                          = 0
0.1322135476547459213732911312 * 15                             = 1
0.1322135476547459213732911312 * -15                            = -1
0.1322135476547459213732911312 * 1                              = 0
0.1322135476547459213732911312 * -9                             = -1
0.1322135476547459213732911312 * 14.14                          = 1
0.1322135476547459213732911312 * -16.60                         = -2
0.1322135476547459213732911312 * 0.15                           = 0
0.1322135476547459213732911312 * -0.01                          = 0

Number "-0.123912932193769965476541321" (scale 0)
-0.123912932193769965476541321 * 15151324141414.412312232141241 = -1877445000980
-0.123912932193769965476541321 * -132132245132134.1515123765412 = 16372893931668
-0.123912932193769965476541321 * 141241241241241248267654747412 = -17501616348889832831364181429
-0.123912932193769965476541321 * -149143276547656984948124912   = 18480780714006502282899774
-0.123912932193769965476541321 * 0.1322135476547459213732911312 = 0
-0.123912932193769965476541321 * -0.123912932193769965476541321 = 0
-0.123912932193769965476541321 * 0                              = 0
-0.123912932193769965476541321 * 0.00                           = 0
-0.123912932193769965476541321 * -0                             = 0
-0.123912932193769965476541321 * -0.00                          = 0
-0.123912932193769965476541321 * 15                             = -1
-0.123912932193769965476541321 * -15                            = 1
-0.123912932193769965476541321 * 1                              = 0
-0.123912932193769965476541321 * -9                             = 1
-0.123912932193769965476541321 * 14.14                          = -1
-0.123912932193769965476541321 * -16.60                         = 2
-0.123912932193769965476541321 * 0.15                           = 0
-0.123912932193769965476541321 * -0.01                          = 0

Number "15151324141414.412312232141241" (scale 10)
15151324141414.412312232141241 * 15151324141414.412312232141241 = 229562623238207178422472679.9262995876
15151324141414.412312232141241 * -132132245132134.1515123765412 = -2001978475529791133885654151.5491331991
15151324141414.412312232141241 * 141241241241241248267654747412 = 2139991828181755439048012256383179795538025.4097677632
15151324141414.412312232141241 * -149143276547656984948124912   = -2259718126486161223119790826488981524974.8925816946
15151324141414.412312232141241 * 0.1322135476547459213732911312 = 2003210316403.3967337164
15151324141414.412312232141241 * -0.123912932193769965476541321 = -1877445000980.9140124713
15151324141414.412312232141241 * 0                              = 0.0000000000
15151324141414.412312232141241 * 0.00                           = 0.0000000000
15151324141414.412312232141241 * -0                             = 0.0000000000
15151324141414.412312232141241 * -0.00                          = 0.0000000000
15151324141414.412312232141241 * 15                             = 227269862121216.1846834821
15151324141414.412312232141241 * -15                            = -227269862121216.1846834821
15151324141414.412312232141241 * 1                              = 15151324141414.4123122321
15151324141414.412312232141241 * -9                             = -136361917272729.7108100892
15151324141414.412312232141241 * 14.14                          = 214239723359599.7900949624
15151324141414.412312232141241 * -16.60                         = -251511980747479.2443830535
15151324141414.412312232141241 * 0.15                           = 2272698621212.1618468348
15151324141414.412312232141241 * -0.01                          = -151513241414.1441231223

Number "-132132245132134.1515123765412" (scale 10)
-132132245132134.1515123765412 * 15151324141414.412312232141241 = -2001978475529791133885654151.5491331991
-132132245132134.1515123765412 * -132132245132134.1515123765412 = 17458930203658389178460349344.0776677900
-132132245132134.1515123765412 * 141241241241241248267654747412 = -18662522310454584290173879848464266332555498.5267202113
-132132245132134.1515123765412 * -149143276547656984948124912   = 19706635976604687211527336089051267200810.4158361143
-132132245132134.1515123765412 * 0.1322135476547459213732911312 = -17469672888505.9884334474
-132132245132134.1515123765412 * -0.123912932193769965476541321 = 16372893931668.7307088223
-132132245132134.1515123765412 * 0                              = 0.0000000000
-132132245132134.1515123765412 * 0.00                           = 0.0000000000
-132132245132134.1515123765412 * -0                             = 0.0000000000
-132132245132134.1515123765412 * -0.00                          = 0.0000000000
-132132245132134.1515123765412 * 15                             = -1981983676982012.2726856481
-132132245132134.1515123765412 * -15                            = 1981983676982012.2726856481
-132132245132134.1515123765412 * 1                              = -132132245132134.1515123765
-132132245132134.1515123765412 * -9                             = 1189190206189207.3636113888
-132132245132134.1515123765412 * 14.14                          = -1868349946168376.9023850042
-132132245132134.1515123765412 * -16.60                         = 2193395269193426.9151054505
-132132245132134.1515123765412 * 0.15                           = -19819836769820.1227268564
-132132245132134.1515123765412 * -0.01                          = 1321322451321.3415151237

Number "141241241241241248267654747412" (scale 10)
141241241241241248267654747412 * 15151324141414.412312232141241 = 2139991828181755439048012256383179795538025.4097677632
141241241241241248267654747412 * -132132245132134.1515123765412 = -18662522310454584290173879848464266332555498.5267202113
141241241241241248267654747412 * 141241241241241248267654747412 = 19949088227366507629622653233761071253230364164181520697744.0000000000
141241241241241248267654747412 * -149143276547656984948124912   = -21065181502376778401476291731259854717478035244384727744.0000000000
141241241241241248267654747412 * 0.1322135476547459213732911312 = 18674005579664314748578026521.9598901262
141241241241241248267654747412 * -0.123912932193769965476541321 = -17501616348889832831364181429.7008871512
141241241241241248267654747412 * 0                              = 0.0000000000
141241241241241248267654747412 * 0.00                           = 0.0000000000
141241241241241248267654747412 * -0                             = 0.0000000000
141241241241241248267654747412 * -0.00                          = 0.0000000000
141241241241241248267654747412 * 15                             = 2118618618618618724014821211180.0000000000
141241241241241248267654747412 * -15                            = -2118618618618618724014821211180.0000000000
141241241241241248267654747412 * 1                              = 141241241241241248267654747412.0000000000
141241241241241248267654747412 * -9                             = -1271171171171171234408892726708.0000000000
141241241241241248267654747412 * 14.14                          = 1997151151151151250504638128405.6800000000
141241241241241248267654747412 * -16.60                         = -2344604604604604721243068807039.2000000000
141241241241241248267654747412 * 0.15                           = 21186186186186187240148212111.8000000000
141241241241241248267654747412 * -0.01                          = -1412412412412412482676547474.1200000000

Number "-149143276547656984948124912" (scale 10)
-149143276547656984948124912 * 15151324141414.412312232141241 = -2259718126486161223119790826488981524974.8925816946
-149143276547656984948124912 * -132132245132134.1515123765412 = 19706635976604687211527336089051267200810.4158361143
-149143276547656984948124912 * 141241241241241248267654747412 = -21065181502376778401476291731259854717478035244384727744.0000000000
-149143276547656984948124912 * -149143276547656984948124912   = 22243716939370890018820252028254140421311664755007744.0000000000
-149143276547656984948124912 * 0.1322135476547459213732911312 = -19718761701218596539144441.0298753533
-149143276547656984948124912 * -0.123912932193769965476541321 = 18480780714006502282899774.5778544540
-149143276547656984948124912 * 0                              = 0.0000000000
-149143276547656984948124912 * 0.00                           = 0.0000000000
-149143276547656984948124912 * -0                             = 0.0000000000
-149143276547656984948124912 * -0.00                          = 0.0000000000
-149143276547656984948124912 * 15                             = -2237149148214854774221873680.0000000000
-149143276547656984948124912 * -15                            = 2237149148214854774221873680.0000000000
-149143276547656984948124912 * 1                              = -149143276547656984948124912.0000000000
-149143276547656984948124912 * -9                             = 1342289488928912864533124208.0000000000
-149143276547656984948124912 * 14.14                          = -2108885930383869767166486255.6800000000
-149143276547656984948124912 * -16.60                         = 2475778390691105950138873539.2000000000
-149143276547656984948124912 * 0.15                           = -22371491482148547742218736.8000000000
-149143276547656984948124912 * -0.01                          = 1491432765476569849481249.1200000000

Number "0.1322135476547459213732911312" (scale 10)
0.1322135476547459213732911312 * 15151324141414.412312232141241 = 2003210316403.3967337164
0.1322135476547459213732911312 * -132132245132134.1515123765412 = -17469672888505.9884334474
0.1322135476547459213732911312 * 141241241241241248267654747412 = 18674005579664314748578026521.9598901262
0.1322135476547459213732911312 * -149143276547656984948124912   = -19718761701218596539144441.0298753533
0.1322135476547459213732911312 * 0.1322135476547459213732911312 = 0.0174804221
0.1322135476547459213732911312 * -0.123912932193769965476541321 = -0.0163829683
0.1322135476547459213732911312 * 0                              = 0.0000000000
0.1322135476547459213732911312 * 0.00                           = 0.0000000000
0.1322135476547459213732911312 * -0                             = 0.0000000000
0.1322135476547459213732911312 * -0.00                          = 0.0000000000
0.1322135476547459213732911312 * 15                             = 1.9832032148
0.1322135476547459213732911312 * -15                            = -1.9832032148
0.1322135476547459213732911312 * 1                              = 0.1322135476
0.1322135476547459213732911312 * -9                             = -1.1899219288
0.1322135476547459213732911312 * 14.14                          = 1.8694995638
0.1322135476547459213732911312 * -16.60                         = -2.1947448910
0.1322135476547459213732911312 * 0.15                           = 0.0198320321
0.1322135476547459213732911312 * -0.01                          = -0.0013221354

Number "-0.123912932193769965476541321" (scale 10)
-0.123912932193769965476541321 * 15151324141414.412312232141241 = -1877445000980.9140124713
-0.123912932193769965476541321 * -132132245132134.1515123765412 = 16372893931668.7307088223
-0.123912932193769965476541321 * 141241241241241248267654747412 = -17501616348889832831364181429.7008871512
-0.123912932193769965476541321 * -149143276547656984948124912   = 18480780714006502282899774.5778544540
-0.123912932193769965476541321 * 0.1322135476547459213732911312 = -0.0163829683
-0.123912932193769965476541321 * -0.123912932193769965476541321 = 0.0153544147
-0.123912932193769965476541321 * 0                              = 0.0000000000
-0.123912932193769965476541321 * 0.00                           = 0.0000000000
-0.123912932193769965476541321 * -0                             = 0.0000000000
-0.123912932193769965476541321 * -0.00                          = 0.0000000000
-0.123912932193769965476541321 * 15                             = -1.8586939829
-0.123912932193769965476541321 * -15                            = 1.8586939829
-0.123912932193769965476541321 * 1                              = -0.1239129321
-0.123912932193769965476541321 * -9                             = 1.1152163897
-0.123912932193769965476541321 * 14.14                          = -1.7521288612
-0.123912932193769965476541321 * -16.60                         = 2.0569546744
-0.123912932193769965476541321 * 0.15                           = -0.0185869398
-0.123912932193769965476541321 * -0.01                          = 0.0012391293
