//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;

use crate::*;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceallocsize?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfaceAllocSize: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfacewidth?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfaceWidth: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceheight?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfaceHeight: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfacebytesperrow?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfaceBytesPerRow: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfacebytesperelement?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfaceBytesPerElement: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceelementwidth?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfaceElementWidth: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceelementheight?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfaceElementHeight: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceoffset?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfaceOffset: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceplaneinfo?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfacePlaneInfo: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceplanewidth?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfacePlaneWidth: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceplaneheight?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfacePlaneHeight: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceplanebytesperrow?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfacePlaneBytesPerRow: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceplaneoffset?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfacePlaneOffset: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceplanesize?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfacePlaneSize: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceplanebase?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfacePlaneBase: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceplanebitsperelement?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfacePlaneBitsPerElement: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceplanebytesperelement?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfacePlaneBytesPerElement: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceplaneelementwidth?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfacePlaneElementWidth: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceplaneelementheight?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfacePlaneElementHeight: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfacecachemode?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfaceCacheMode: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceisglobal?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    #[deprecated = "Global surfaces are insecure"]
    pub static kIOSurfaceIsGlobal: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfacepixelformat?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfacePixelFormat: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfacepixelsizecastingallowed?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfacePixelSizeCastingAllowed: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceplanecomponentbitdepths?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfacePlaneComponentBitDepths: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceplanecomponentbitoffsets?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfacePlaneComponentBitOffsets: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfacename?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfaceName: &'static CFString;
}

/// [Apple's documentation](https://developer.apple.com/documentation/iosurface/iosurfacecomponentname?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct IOSurfaceComponentName(pub i32);
impl IOSurfaceComponentName {
    #[doc(alias = "kIOSurfaceComponentNameUnknown")]
    pub const Unknown: Self = Self(0);
    #[doc(alias = "kIOSurfaceComponentNameAlpha")]
    pub const Alpha: Self = Self(1);
    #[doc(alias = "kIOSurfaceComponentNameRed")]
    pub const Red: Self = Self(2);
    #[doc(alias = "kIOSurfaceComponentNameGreen")]
    pub const Green: Self = Self(3);
    #[doc(alias = "kIOSurfaceComponentNameBlue")]
    pub const Blue: Self = Self(4);
    #[doc(alias = "kIOSurfaceComponentNameLuma")]
    pub const Luma: Self = Self(5);
    #[doc(alias = "kIOSurfaceComponentNameChromaRed")]
    pub const ChromaRed: Self = Self(6);
    #[doc(alias = "kIOSurfaceComponentNameChromaBlue")]
    pub const ChromaBlue: Self = Self(7);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOSurfaceComponentName {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOSurfaceComponentName {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl Send for IOSurfaceComponentName {}

unsafe impl Sync for IOSurfaceComponentName {}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceplanecomponentnames?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfacePlaneComponentNames: &'static CFString;
}

/// [Apple's documentation](https://developer.apple.com/documentation/iosurface/iosurfacecomponenttype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct IOSurfaceComponentType(pub i32);
impl IOSurfaceComponentType {
    #[doc(alias = "kIOSurfaceComponentTypeUnknown")]
    pub const Unknown: Self = Self(0);
    #[doc(alias = "kIOSurfaceComponentTypeUnsignedInteger")]
    pub const UnsignedInteger: Self = Self(1);
    #[doc(alias = "kIOSurfaceComponentTypeSignedInteger")]
    pub const SignedInteger: Self = Self(2);
    #[doc(alias = "kIOSurfaceComponentTypeFloat")]
    pub const Float: Self = Self(3);
    #[doc(alias = "kIOSurfaceComponentTypeSignedNormalized")]
    pub const SignedNormalized: Self = Self(4);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOSurfaceComponentType {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOSurfaceComponentType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl Send for IOSurfaceComponentType {}

unsafe impl Sync for IOSurfaceComponentType {}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceplanecomponenttypes?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfacePlaneComponentTypes: &'static CFString;
}

/// [Apple's documentation](https://developer.apple.com/documentation/iosurface/iosurfacecomponentrange?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct IOSurfaceComponentRange(pub i32);
impl IOSurfaceComponentRange {
    #[doc(alias = "kIOSurfaceComponentRangeUnknown")]
    pub const Unknown: Self = Self(0);
    #[doc(alias = "kIOSurfaceComponentRangeFullRange")]
    pub const FullRange: Self = Self(1);
    #[doc(alias = "kIOSurfaceComponentRangeVideoRange")]
    pub const VideoRange: Self = Self(2);
    #[doc(alias = "kIOSurfaceComponentRangeWideRange")]
    pub const WideRange: Self = Self(3);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOSurfaceComponentRange {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOSurfaceComponentRange {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl Send for IOSurfaceComponentRange {}

unsafe impl Sync for IOSurfaceComponentRange {}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceplanecomponentranges?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfacePlaneComponentRanges: &'static CFString;
}

/// [Apple's documentation](https://developer.apple.com/documentation/iosurface/iosurfacesubsampling?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct IOSurfaceSubsampling(pub i32);
impl IOSurfaceSubsampling {
    #[doc(alias = "kIOSurfaceSubsamplingUnknown")]
    pub const SubsamplingUnknown: Self = Self(0);
    #[doc(alias = "kIOSurfaceSubsamplingNone")]
    pub const SubsamplingNone: Self = Self(1);
    #[doc(alias = "kIOSurfaceSubsampling422")]
    pub const Subsampling422: Self = Self(2);
    #[doc(alias = "kIOSurfaceSubsampling420")]
    pub const Subsampling420: Self = Self(3);
    #[doc(alias = "kIOSurfaceSubsampling411")]
    pub const Subsampling411: Self = Self(4);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOSurfaceSubsampling {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOSurfaceSubsampling {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl Send for IOSurfaceSubsampling {}

unsafe impl Sync for IOSurfaceSubsampling {}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfacesubsampling?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfaceSubsampling: &'static CFString;
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl ConcreteType for IOSurfaceRef {
    #[doc(alias = "IOSurfaceGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn IOSurfaceGetTypeID() -> CFTypeID;
        }
        unsafe { IOSurfaceGetTypeID() }
    }
}

impl IOSurfaceRef {
    /// # Safety
    ///
    /// `properties` generics must be of the correct type.
    #[doc(alias = "IOSurfaceCreate")]
    #[cfg(feature = "objc2-core-foundation")]
    #[inline]
    pub unsafe fn new(properties: &CFDictionary) -> Option<CFRetained<IOSurfaceRef>> {
        extern "C-unwind" {
            fn IOSurfaceCreate(properties: &CFDictionary) -> Option<NonNull<IOSurfaceRef>>;
        }
        let ret = unsafe { IOSurfaceCreate(properties) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "IOSurfaceLookup")]
    #[cfg(all(feature = "IOSurfaceTypes", feature = "objc2-core-foundation"))]
    #[inline]
    pub fn lookup(csid: IOSurfaceID) -> Option<CFRetained<IOSurfaceRef>> {
        extern "C-unwind" {
            fn IOSurfaceLookup(csid: IOSurfaceID) -> Option<NonNull<IOSurfaceRef>>;
        }
        let ret = unsafe { IOSurfaceLookup(csid) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "IOSurfaceGetID")]
    #[cfg(feature = "IOSurfaceTypes")]
    #[inline]
    pub fn id(&self) -> IOSurfaceID {
        extern "C-unwind" {
            fn IOSurfaceGetID(buffer: &IOSurfaceRef) -> IOSurfaceID;
        }
        unsafe { IOSurfaceGetID(self) }
    }

    /// # Safety
    ///
    /// `seed` must be a valid pointer or null.
    #[doc(alias = "IOSurfaceLock")]
    #[cfg(all(feature = "IOSurfaceTypes", feature = "libc"))]
    #[inline]
    pub unsafe fn lock(
        &self,
        options: IOSurfaceLockOptions,
        seed: *mut u32,
    ) -> libc::kern_return_t {
        extern "C-unwind" {
            fn IOSurfaceLock(
                buffer: &IOSurfaceRef,
                options: IOSurfaceLockOptions,
                seed: *mut u32,
            ) -> libc::kern_return_t;
        }
        unsafe { IOSurfaceLock(self, options, seed) }
    }

    /// # Safety
    ///
    /// `seed` must be a valid pointer or null.
    #[doc(alias = "IOSurfaceUnlock")]
    #[cfg(all(feature = "IOSurfaceTypes", feature = "libc"))]
    #[inline]
    pub unsafe fn unlock(
        &self,
        options: IOSurfaceLockOptions,
        seed: *mut u32,
    ) -> libc::kern_return_t {
        extern "C-unwind" {
            fn IOSurfaceUnlock(
                buffer: &IOSurfaceRef,
                options: IOSurfaceLockOptions,
                seed: *mut u32,
            ) -> libc::kern_return_t;
        }
        unsafe { IOSurfaceUnlock(self, options, seed) }
    }

    #[doc(alias = "IOSurfaceGetAllocSize")]
    #[inline]
    pub fn alloc_size(&self) -> usize {
        extern "C-unwind" {
            fn IOSurfaceGetAllocSize(buffer: &IOSurfaceRef) -> usize;
        }
        unsafe { IOSurfaceGetAllocSize(self) }
    }

    #[doc(alias = "IOSurfaceGetWidth")]
    #[inline]
    pub fn width(&self) -> usize {
        extern "C-unwind" {
            fn IOSurfaceGetWidth(buffer: &IOSurfaceRef) -> usize;
        }
        unsafe { IOSurfaceGetWidth(self) }
    }

    #[doc(alias = "IOSurfaceGetHeight")]
    #[inline]
    pub fn height(&self) -> usize {
        extern "C-unwind" {
            fn IOSurfaceGetHeight(buffer: &IOSurfaceRef) -> usize;
        }
        unsafe { IOSurfaceGetHeight(self) }
    }

    #[doc(alias = "IOSurfaceGetBytesPerElement")]
    #[inline]
    pub fn bytes_per_element(&self) -> usize {
        extern "C-unwind" {
            fn IOSurfaceGetBytesPerElement(buffer: &IOSurfaceRef) -> usize;
        }
        unsafe { IOSurfaceGetBytesPerElement(self) }
    }

    #[doc(alias = "IOSurfaceGetBytesPerRow")]
    #[inline]
    pub fn bytes_per_row(&self) -> usize {
        extern "C-unwind" {
            fn IOSurfaceGetBytesPerRow(buffer: &IOSurfaceRef) -> usize;
        }
        unsafe { IOSurfaceGetBytesPerRow(self) }
    }

    #[doc(alias = "IOSurfaceGetBaseAddress")]
    #[inline]
    pub fn base_address(&self) -> NonNull<c_void> {
        extern "C-unwind" {
            fn IOSurfaceGetBaseAddress(buffer: &IOSurfaceRef) -> Option<NonNull<c_void>>;
        }
        let ret = unsafe { IOSurfaceGetBaseAddress(self) };
        ret.expect("function was marked as returning non-null, but actually returned NULL")
    }

    #[doc(alias = "IOSurfaceGetElementWidth")]
    #[inline]
    pub fn element_width(&self) -> usize {
        extern "C-unwind" {
            fn IOSurfaceGetElementWidth(buffer: &IOSurfaceRef) -> usize;
        }
        unsafe { IOSurfaceGetElementWidth(self) }
    }

    #[doc(alias = "IOSurfaceGetElementHeight")]
    #[inline]
    pub fn element_height(&self) -> usize {
        extern "C-unwind" {
            fn IOSurfaceGetElementHeight(buffer: &IOSurfaceRef) -> usize;
        }
        unsafe { IOSurfaceGetElementHeight(self) }
    }

    #[doc(alias = "IOSurfaceGetPixelFormat")]
    #[inline]
    pub fn pixel_format(&self) -> OSType {
        extern "C-unwind" {
            fn IOSurfaceGetPixelFormat(buffer: &IOSurfaceRef) -> OSType;
        }
        unsafe { IOSurfaceGetPixelFormat(self) }
    }

    #[doc(alias = "IOSurfaceGetSeed")]
    #[inline]
    pub fn seed(&self) -> u32 {
        extern "C-unwind" {
            fn IOSurfaceGetSeed(buffer: &IOSurfaceRef) -> u32;
        }
        unsafe { IOSurfaceGetSeed(self) }
    }

    #[doc(alias = "IOSurfaceGetPlaneCount")]
    #[inline]
    pub fn plane_count(&self) -> usize {
        extern "C-unwind" {
            fn IOSurfaceGetPlaneCount(buffer: &IOSurfaceRef) -> usize;
        }
        unsafe { IOSurfaceGetPlaneCount(self) }
    }

    #[doc(alias = "IOSurfaceGetWidthOfPlane")]
    #[inline]
    pub fn width_of_plane(&self, plane_index: usize) -> usize {
        extern "C-unwind" {
            fn IOSurfaceGetWidthOfPlane(buffer: &IOSurfaceRef, plane_index: usize) -> usize;
        }
        unsafe { IOSurfaceGetWidthOfPlane(self, plane_index) }
    }

    #[doc(alias = "IOSurfaceGetHeightOfPlane")]
    #[inline]
    pub fn height_of_plane(&self, plane_index: usize) -> usize {
        extern "C-unwind" {
            fn IOSurfaceGetHeightOfPlane(buffer: &IOSurfaceRef, plane_index: usize) -> usize;
        }
        unsafe { IOSurfaceGetHeightOfPlane(self, plane_index) }
    }

    #[doc(alias = "IOSurfaceGetBytesPerElementOfPlane")]
    #[inline]
    pub fn bytes_per_element_of_plane(&self, plane_index: usize) -> usize {
        extern "C-unwind" {
            fn IOSurfaceGetBytesPerElementOfPlane(
                buffer: &IOSurfaceRef,
                plane_index: usize,
            ) -> usize;
        }
        unsafe { IOSurfaceGetBytesPerElementOfPlane(self, plane_index) }
    }

    #[doc(alias = "IOSurfaceGetBytesPerRowOfPlane")]
    #[inline]
    pub fn bytes_per_row_of_plane(&self, plane_index: usize) -> usize {
        extern "C-unwind" {
            fn IOSurfaceGetBytesPerRowOfPlane(buffer: &IOSurfaceRef, plane_index: usize) -> usize;
        }
        unsafe { IOSurfaceGetBytesPerRowOfPlane(self, plane_index) }
    }

    #[doc(alias = "IOSurfaceGetBaseAddressOfPlane")]
    #[inline]
    pub fn base_address_of_plane(&self, plane_index: usize) -> NonNull<c_void> {
        extern "C-unwind" {
            fn IOSurfaceGetBaseAddressOfPlane(
                buffer: &IOSurfaceRef,
                plane_index: usize,
            ) -> Option<NonNull<c_void>>;
        }
        let ret = unsafe { IOSurfaceGetBaseAddressOfPlane(self, plane_index) };
        ret.expect("function was marked as returning non-null, but actually returned NULL")
    }

    #[doc(alias = "IOSurfaceGetElementWidthOfPlane")]
    #[inline]
    pub fn element_width_of_plane(&self, plane_index: usize) -> usize {
        extern "C-unwind" {
            fn IOSurfaceGetElementWidthOfPlane(buffer: &IOSurfaceRef, plane_index: usize) -> usize;
        }
        unsafe { IOSurfaceGetElementWidthOfPlane(self, plane_index) }
    }

    #[doc(alias = "IOSurfaceGetElementHeightOfPlane")]
    #[inline]
    pub fn element_height_of_plane(&self, plane_index: usize) -> usize {
        extern "C-unwind" {
            fn IOSurfaceGetElementHeightOfPlane(buffer: &IOSurfaceRef, plane_index: usize)
                -> usize;
        }
        unsafe { IOSurfaceGetElementHeightOfPlane(self, plane_index) }
    }

    #[doc(alias = "IOSurfaceGetNumberOfComponentsOfPlane")]
    #[inline]
    pub fn number_of_components_of_plane(&self, plane_index: usize) -> usize {
        extern "C-unwind" {
            fn IOSurfaceGetNumberOfComponentsOfPlane(
                buffer: &IOSurfaceRef,
                plane_index: usize,
            ) -> usize;
        }
        unsafe { IOSurfaceGetNumberOfComponentsOfPlane(self, plane_index) }
    }

    #[doc(alias = "IOSurfaceGetNameOfComponentOfPlane")]
    #[inline]
    pub fn name_of_component_of_plane(
        &self,
        plane_index: usize,
        component_index: usize,
    ) -> IOSurfaceComponentName {
        extern "C-unwind" {
            fn IOSurfaceGetNameOfComponentOfPlane(
                buffer: &IOSurfaceRef,
                plane_index: usize,
                component_index: usize,
            ) -> IOSurfaceComponentName;
        }
        unsafe { IOSurfaceGetNameOfComponentOfPlane(self, plane_index, component_index) }
    }

    #[doc(alias = "IOSurfaceGetTypeOfComponentOfPlane")]
    #[inline]
    pub fn type_of_component_of_plane(
        &self,
        plane_index: usize,
        component_index: usize,
    ) -> IOSurfaceComponentType {
        extern "C-unwind" {
            fn IOSurfaceGetTypeOfComponentOfPlane(
                buffer: &IOSurfaceRef,
                plane_index: usize,
                component_index: usize,
            ) -> IOSurfaceComponentType;
        }
        unsafe { IOSurfaceGetTypeOfComponentOfPlane(self, plane_index, component_index) }
    }

    #[doc(alias = "IOSurfaceGetRangeOfComponentOfPlane")]
    #[inline]
    pub fn range_of_component_of_plane(
        &self,
        plane_index: usize,
        component_index: usize,
    ) -> IOSurfaceComponentRange {
        extern "C-unwind" {
            fn IOSurfaceGetRangeOfComponentOfPlane(
                buffer: &IOSurfaceRef,
                plane_index: usize,
                component_index: usize,
            ) -> IOSurfaceComponentRange;
        }
        unsafe { IOSurfaceGetRangeOfComponentOfPlane(self, plane_index, component_index) }
    }

    #[doc(alias = "IOSurfaceGetBitDepthOfComponentOfPlane")]
    #[inline]
    pub fn bit_depth_of_component_of_plane(
        &self,
        plane_index: usize,
        component_index: usize,
    ) -> usize {
        extern "C-unwind" {
            fn IOSurfaceGetBitDepthOfComponentOfPlane(
                buffer: &IOSurfaceRef,
                plane_index: usize,
                component_index: usize,
            ) -> usize;
        }
        unsafe { IOSurfaceGetBitDepthOfComponentOfPlane(self, plane_index, component_index) }
    }

    #[doc(alias = "IOSurfaceGetBitOffsetOfComponentOfPlane")]
    #[inline]
    pub fn bit_offset_of_component_of_plane(
        &self,
        plane_index: usize,
        component_index: usize,
    ) -> usize {
        extern "C-unwind" {
            fn IOSurfaceGetBitOffsetOfComponentOfPlane(
                buffer: &IOSurfaceRef,
                plane_index: usize,
                component_index: usize,
            ) -> usize;
        }
        unsafe { IOSurfaceGetBitOffsetOfComponentOfPlane(self, plane_index, component_index) }
    }

    #[doc(alias = "IOSurfaceGetSubsampling")]
    #[inline]
    pub fn subsampling(&self) -> IOSurfaceSubsampling {
        extern "C-unwind" {
            fn IOSurfaceGetSubsampling(buffer: &IOSurfaceRef) -> IOSurfaceSubsampling;
        }
        unsafe { IOSurfaceGetSubsampling(self) }
    }
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfacecolorspace?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfaceColorSpace: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfaceiccprofile?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfaceICCProfile: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/iosurface/kiosurfacecontentheadroom?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static kIOSurfaceContentHeadroom: &'static CFString;
}

impl IOSurfaceRef {
    /// # Safety
    ///
    /// `value` should be of the correct type.
    #[doc(alias = "IOSurfaceSetValue")]
    #[cfg(feature = "objc2-core-foundation")]
    #[inline]
    pub unsafe fn set_value(&self, key: &CFString, value: &CFType) {
        extern "C-unwind" {
            fn IOSurfaceSetValue(buffer: &IOSurfaceRef, key: &CFString, value: &CFType);
        }
        unsafe { IOSurfaceSetValue(self, key, value) }
    }

    #[doc(alias = "IOSurfaceCopyValue")]
    #[cfg(feature = "objc2-core-foundation")]
    #[inline]
    pub fn value(&self, key: &CFString) -> Option<CFRetained<CFType>> {
        extern "C-unwind" {
            fn IOSurfaceCopyValue(buffer: &IOSurfaceRef, key: &CFString)
                -> Option<NonNull<CFType>>;
        }
        let ret = unsafe { IOSurfaceCopyValue(self, key) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "IOSurfaceRemoveValue")]
    #[cfg(feature = "objc2-core-foundation")]
    #[inline]
    pub fn remove_value(&self, key: &CFString) {
        extern "C-unwind" {
            fn IOSurfaceRemoveValue(buffer: &IOSurfaceRef, key: &CFString);
        }
        unsafe { IOSurfaceRemoveValue(self, key) }
    }

    /// # Safety
    ///
    /// `keys_and_values` generics must be of the correct type.
    #[doc(alias = "IOSurfaceSetValues")]
    #[cfg(feature = "objc2-core-foundation")]
    #[inline]
    pub unsafe fn set_values(&self, keys_and_values: &CFDictionary) {
        extern "C-unwind" {
            fn IOSurfaceSetValues(buffer: &IOSurfaceRef, keys_and_values: &CFDictionary);
        }
        unsafe { IOSurfaceSetValues(self, keys_and_values) }
    }

    #[doc(alias = "IOSurfaceCopyAllValues")]
    #[cfg(feature = "objc2-core-foundation")]
    #[inline]
    pub fn all_values(&self) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn IOSurfaceCopyAllValues(buffer: &IOSurfaceRef) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { IOSurfaceCopyAllValues(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "IOSurfaceRemoveAllValues")]
    #[inline]
    pub fn remove_all_values(&self) {
        extern "C-unwind" {
            fn IOSurfaceRemoveAllValues(buffer: &IOSurfaceRef);
        }
        unsafe { IOSurfaceRemoveAllValues(self) }
    }

    #[doc(alias = "IOSurfaceCreateMachPort")]
    #[cfg(feature = "libc")]
    #[inline]
    pub fn create_mach_port(&self) -> libc::mach_port_t {
        extern "C-unwind" {
            fn IOSurfaceCreateMachPort(buffer: &IOSurfaceRef) -> libc::mach_port_t;
        }
        unsafe { IOSurfaceCreateMachPort(self) }
    }

    #[doc(alias = "IOSurfaceLookupFromMachPort")]
    #[cfg(all(feature = "libc", feature = "objc2-core-foundation"))]
    #[inline]
    pub fn lookup_from_mach_port(port: libc::mach_port_t) -> Option<CFRetained<IOSurfaceRef>> {
        extern "C-unwind" {
            fn IOSurfaceLookupFromMachPort(
                port: libc::mach_port_t,
            ) -> Option<NonNull<IOSurfaceRef>>;
        }
        let ret = unsafe { IOSurfaceLookupFromMachPort(port) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "IOSurfaceGetPropertyMaximum")]
    #[cfg(feature = "objc2-core-foundation")]
    #[inline]
    pub fn property_maximum(property: &CFString) -> usize {
        extern "C-unwind" {
            fn IOSurfaceGetPropertyMaximum(property: &CFString) -> usize;
        }
        unsafe { IOSurfaceGetPropertyMaximum(property) }
    }

    #[doc(alias = "IOSurfaceGetPropertyAlignment")]
    #[cfg(feature = "objc2-core-foundation")]
    #[inline]
    pub fn property_alignment(property: &CFString) -> usize {
        extern "C-unwind" {
            fn IOSurfaceGetPropertyAlignment(property: &CFString) -> usize;
        }
        unsafe { IOSurfaceGetPropertyAlignment(property) }
    }

    #[doc(alias = "IOSurfaceAlignProperty")]
    #[cfg(feature = "objc2-core-foundation")]
    #[inline]
    pub fn align_property(property: &CFString, value: usize) -> usize {
        extern "C-unwind" {
            fn IOSurfaceAlignProperty(property: &CFString, value: usize) -> usize;
        }
        unsafe { IOSurfaceAlignProperty(property, value) }
    }

    #[doc(alias = "IOSurfaceIncrementUseCount")]
    #[inline]
    pub fn increment_use_count(&self) {
        extern "C-unwind" {
            fn IOSurfaceIncrementUseCount(buffer: &IOSurfaceRef);
        }
        unsafe { IOSurfaceIncrementUseCount(self) }
    }

    #[doc(alias = "IOSurfaceDecrementUseCount")]
    #[inline]
    pub fn decrement_use_count(&self) {
        extern "C-unwind" {
            fn IOSurfaceDecrementUseCount(buffer: &IOSurfaceRef);
        }
        unsafe { IOSurfaceDecrementUseCount(self) }
    }

    #[doc(alias = "IOSurfaceGetUseCount")]
    #[inline]
    pub fn use_count(&self) -> i32 {
        extern "C-unwind" {
            fn IOSurfaceGetUseCount(buffer: &IOSurfaceRef) -> i32;
        }
        unsafe { IOSurfaceGetUseCount(self) }
    }

    #[doc(alias = "IOSurfaceIsInUse")]
    #[inline]
    pub fn is_in_use(&self) -> bool {
        extern "C-unwind" {
            fn IOSurfaceIsInUse(buffer: &IOSurfaceRef) -> Boolean;
        }
        let ret = unsafe { IOSurfaceIsInUse(self) };
        ret != 0
    }

    #[doc(alias = "IOSurfaceAllowsPixelSizeCasting")]
    #[inline]
    pub fn allows_pixel_size_casting(&self) -> bool {
        extern "C-unwind" {
            fn IOSurfaceAllowsPixelSizeCasting(buffer: &IOSurfaceRef) -> Boolean;
        }
        let ret = unsafe { IOSurfaceAllowsPixelSizeCasting(self) };
        ret != 0
    }

    /// # Safety
    ///
    /// `old_state` must be a valid pointer or null.
    #[doc(alias = "IOSurfaceSetPurgeable")]
    #[cfg(feature = "libc")]
    #[inline]
    pub unsafe fn set_purgeable(&self, new_state: u32, old_state: *mut u32) -> libc::kern_return_t {
        extern "C-unwind" {
            fn IOSurfaceSetPurgeable(
                buffer: &IOSurfaceRef,
                new_state: u32,
                old_state: *mut u32,
            ) -> libc::kern_return_t;
        }
        unsafe { IOSurfaceSetPurgeable(self, new_state, old_state) }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/iosurface/iosurfacememoryledgertags?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct IOSurfaceMemoryLedgerTags(pub c_int);
impl IOSurfaceMemoryLedgerTags {
    #[doc(alias = "kIOSurfaceMemoryLedgerTagDefault")]
    pub const Default: Self = Self(0x00000001);
    #[doc(alias = "kIOSurfaceMemoryLedgerTagNetwork")]
    pub const Network: Self = Self(0x00000002);
    #[doc(alias = "kIOSurfaceMemoryLedgerTagMedia")]
    pub const Media: Self = Self(0x00000003);
    #[doc(alias = "kIOSurfaceMemoryLedgerTagGraphics")]
    pub const Graphics: Self = Self(0x00000004);
    #[doc(alias = "kIOSurfaceMemoryLedgerTagNeural")]
    pub const Neural: Self = Self(0x00000005);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOSurfaceMemoryLedgerTags {
    const ENCODING: Encoding = c_int::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOSurfaceMemoryLedgerTags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl Send for IOSurfaceMemoryLedgerTags {}

unsafe impl Sync for IOSurfaceMemoryLedgerTags {}

/// [Apple's documentation](https://developer.apple.com/documentation/iosurface/iosurfacememoryledgerflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct IOSurfaceMemoryLedgerFlags(pub u32);
bitflags::bitflags! {
    impl IOSurfaceMemoryLedgerFlags: u32 {
        #[doc(alias = "kIOSurfaceMemoryLedgerFlagNoFootprint")]
        const NoFootprint = 1<<0;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOSurfaceMemoryLedgerFlags {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOSurfaceMemoryLedgerFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl Send for IOSurfaceMemoryLedgerFlags {}

unsafe impl Sync for IOSurfaceMemoryLedgerFlags {}

#[cfg(feature = "objc2-core-foundation")]
#[deprecated = "renamed to `IOSurfaceRef::new`"]
#[inline]
pub unsafe extern "C-unwind" fn IOSurfaceCreate(
    properties: &CFDictionary,
) -> Option<CFRetained<IOSurfaceRef>> {
    extern "C-unwind" {
        fn IOSurfaceCreate(properties: &CFDictionary) -> Option<NonNull<IOSurfaceRef>>;
    }
    let ret = unsafe { IOSurfaceCreate(properties) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "IOSurfaceTypes", feature = "objc2-core-foundation"))]
#[deprecated = "renamed to `IOSurfaceRef::lookup`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceLookup(csid: IOSurfaceID) -> Option<CFRetained<IOSurfaceRef>> {
    extern "C-unwind" {
        fn IOSurfaceLookup(csid: IOSurfaceID) -> Option<NonNull<IOSurfaceRef>>;
    }
    let ret = unsafe { IOSurfaceLookup(csid) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "IOSurfaceTypes")]
#[deprecated = "renamed to `IOSurfaceRef::id`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetID(buffer: &IOSurfaceRef) -> IOSurfaceID {
    extern "C-unwind" {
        fn IOSurfaceGetID(buffer: &IOSurfaceRef) -> IOSurfaceID;
    }
    unsafe { IOSurfaceGetID(buffer) }
}

extern "C-unwind" {
    #[cfg(all(feature = "IOSurfaceTypes", feature = "libc"))]
    #[deprecated = "renamed to `IOSurfaceRef::lock`"]
    pub fn IOSurfaceLock(
        buffer: &IOSurfaceRef,
        options: IOSurfaceLockOptions,
        seed: *mut u32,
    ) -> libc::kern_return_t;
}

extern "C-unwind" {
    #[cfg(all(feature = "IOSurfaceTypes", feature = "libc"))]
    #[deprecated = "renamed to `IOSurfaceRef::unlock`"]
    pub fn IOSurfaceUnlock(
        buffer: &IOSurfaceRef,
        options: IOSurfaceLockOptions,
        seed: *mut u32,
    ) -> libc::kern_return_t;
}

#[deprecated = "renamed to `IOSurfaceRef::alloc_size`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetAllocSize(buffer: &IOSurfaceRef) -> usize {
    extern "C-unwind" {
        fn IOSurfaceGetAllocSize(buffer: &IOSurfaceRef) -> usize;
    }
    unsafe { IOSurfaceGetAllocSize(buffer) }
}

#[deprecated = "renamed to `IOSurfaceRef::width`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetWidth(buffer: &IOSurfaceRef) -> usize {
    extern "C-unwind" {
        fn IOSurfaceGetWidth(buffer: &IOSurfaceRef) -> usize;
    }
    unsafe { IOSurfaceGetWidth(buffer) }
}

#[deprecated = "renamed to `IOSurfaceRef::height`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetHeight(buffer: &IOSurfaceRef) -> usize {
    extern "C-unwind" {
        fn IOSurfaceGetHeight(buffer: &IOSurfaceRef) -> usize;
    }
    unsafe { IOSurfaceGetHeight(buffer) }
}

#[deprecated = "renamed to `IOSurfaceRef::bytes_per_element`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetBytesPerElement(buffer: &IOSurfaceRef) -> usize {
    extern "C-unwind" {
        fn IOSurfaceGetBytesPerElement(buffer: &IOSurfaceRef) -> usize;
    }
    unsafe { IOSurfaceGetBytesPerElement(buffer) }
}

#[deprecated = "renamed to `IOSurfaceRef::bytes_per_row`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetBytesPerRow(buffer: &IOSurfaceRef) -> usize {
    extern "C-unwind" {
        fn IOSurfaceGetBytesPerRow(buffer: &IOSurfaceRef) -> usize;
    }
    unsafe { IOSurfaceGetBytesPerRow(buffer) }
}

#[deprecated = "renamed to `IOSurfaceRef::base_address`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetBaseAddress(buffer: &IOSurfaceRef) -> NonNull<c_void> {
    extern "C-unwind" {
        fn IOSurfaceGetBaseAddress(buffer: &IOSurfaceRef) -> Option<NonNull<c_void>>;
    }
    let ret = unsafe { IOSurfaceGetBaseAddress(buffer) };
    ret.expect("function was marked as returning non-null, but actually returned NULL")
}

#[deprecated = "renamed to `IOSurfaceRef::element_width`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetElementWidth(buffer: &IOSurfaceRef) -> usize {
    extern "C-unwind" {
        fn IOSurfaceGetElementWidth(buffer: &IOSurfaceRef) -> usize;
    }
    unsafe { IOSurfaceGetElementWidth(buffer) }
}

#[deprecated = "renamed to `IOSurfaceRef::element_height`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetElementHeight(buffer: &IOSurfaceRef) -> usize {
    extern "C-unwind" {
        fn IOSurfaceGetElementHeight(buffer: &IOSurfaceRef) -> usize;
    }
    unsafe { IOSurfaceGetElementHeight(buffer) }
}

#[deprecated = "renamed to `IOSurfaceRef::pixel_format`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetPixelFormat(buffer: &IOSurfaceRef) -> OSType {
    extern "C-unwind" {
        fn IOSurfaceGetPixelFormat(buffer: &IOSurfaceRef) -> OSType;
    }
    unsafe { IOSurfaceGetPixelFormat(buffer) }
}

#[deprecated = "renamed to `IOSurfaceRef::seed`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetSeed(buffer: &IOSurfaceRef) -> u32 {
    extern "C-unwind" {
        fn IOSurfaceGetSeed(buffer: &IOSurfaceRef) -> u32;
    }
    unsafe { IOSurfaceGetSeed(buffer) }
}

#[deprecated = "renamed to `IOSurfaceRef::plane_count`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetPlaneCount(buffer: &IOSurfaceRef) -> usize {
    extern "C-unwind" {
        fn IOSurfaceGetPlaneCount(buffer: &IOSurfaceRef) -> usize;
    }
    unsafe { IOSurfaceGetPlaneCount(buffer) }
}

#[deprecated = "renamed to `IOSurfaceRef::width_of_plane`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetWidthOfPlane(
    buffer: &IOSurfaceRef,
    plane_index: usize,
) -> usize {
    extern "C-unwind" {
        fn IOSurfaceGetWidthOfPlane(buffer: &IOSurfaceRef, plane_index: usize) -> usize;
    }
    unsafe { IOSurfaceGetWidthOfPlane(buffer, plane_index) }
}

#[deprecated = "renamed to `IOSurfaceRef::height_of_plane`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetHeightOfPlane(
    buffer: &IOSurfaceRef,
    plane_index: usize,
) -> usize {
    extern "C-unwind" {
        fn IOSurfaceGetHeightOfPlane(buffer: &IOSurfaceRef, plane_index: usize) -> usize;
    }
    unsafe { IOSurfaceGetHeightOfPlane(buffer, plane_index) }
}

#[deprecated = "renamed to `IOSurfaceRef::bytes_per_element_of_plane`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetBytesPerElementOfPlane(
    buffer: &IOSurfaceRef,
    plane_index: usize,
) -> usize {
    extern "C-unwind" {
        fn IOSurfaceGetBytesPerElementOfPlane(buffer: &IOSurfaceRef, plane_index: usize) -> usize;
    }
    unsafe { IOSurfaceGetBytesPerElementOfPlane(buffer, plane_index) }
}

#[deprecated = "renamed to `IOSurfaceRef::bytes_per_row_of_plane`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetBytesPerRowOfPlane(
    buffer: &IOSurfaceRef,
    plane_index: usize,
) -> usize {
    extern "C-unwind" {
        fn IOSurfaceGetBytesPerRowOfPlane(buffer: &IOSurfaceRef, plane_index: usize) -> usize;
    }
    unsafe { IOSurfaceGetBytesPerRowOfPlane(buffer, plane_index) }
}

#[deprecated = "renamed to `IOSurfaceRef::base_address_of_plane`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetBaseAddressOfPlane(
    buffer: &IOSurfaceRef,
    plane_index: usize,
) -> NonNull<c_void> {
    extern "C-unwind" {
        fn IOSurfaceGetBaseAddressOfPlane(
            buffer: &IOSurfaceRef,
            plane_index: usize,
        ) -> Option<NonNull<c_void>>;
    }
    let ret = unsafe { IOSurfaceGetBaseAddressOfPlane(buffer, plane_index) };
    ret.expect("function was marked as returning non-null, but actually returned NULL")
}

#[deprecated = "renamed to `IOSurfaceRef::element_width_of_plane`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetElementWidthOfPlane(
    buffer: &IOSurfaceRef,
    plane_index: usize,
) -> usize {
    extern "C-unwind" {
        fn IOSurfaceGetElementWidthOfPlane(buffer: &IOSurfaceRef, plane_index: usize) -> usize;
    }
    unsafe { IOSurfaceGetElementWidthOfPlane(buffer, plane_index) }
}

#[deprecated = "renamed to `IOSurfaceRef::element_height_of_plane`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetElementHeightOfPlane(
    buffer: &IOSurfaceRef,
    plane_index: usize,
) -> usize {
    extern "C-unwind" {
        fn IOSurfaceGetElementHeightOfPlane(buffer: &IOSurfaceRef, plane_index: usize) -> usize;
    }
    unsafe { IOSurfaceGetElementHeightOfPlane(buffer, plane_index) }
}

#[deprecated = "renamed to `IOSurfaceRef::number_of_components_of_plane`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetNumberOfComponentsOfPlane(
    buffer: &IOSurfaceRef,
    plane_index: usize,
) -> usize {
    extern "C-unwind" {
        fn IOSurfaceGetNumberOfComponentsOfPlane(
            buffer: &IOSurfaceRef,
            plane_index: usize,
        ) -> usize;
    }
    unsafe { IOSurfaceGetNumberOfComponentsOfPlane(buffer, plane_index) }
}

#[deprecated = "renamed to `IOSurfaceRef::name_of_component_of_plane`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetNameOfComponentOfPlane(
    buffer: &IOSurfaceRef,
    plane_index: usize,
    component_index: usize,
) -> IOSurfaceComponentName {
    extern "C-unwind" {
        fn IOSurfaceGetNameOfComponentOfPlane(
            buffer: &IOSurfaceRef,
            plane_index: usize,
            component_index: usize,
        ) -> IOSurfaceComponentName;
    }
    unsafe { IOSurfaceGetNameOfComponentOfPlane(buffer, plane_index, component_index) }
}

#[deprecated = "renamed to `IOSurfaceRef::type_of_component_of_plane`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetTypeOfComponentOfPlane(
    buffer: &IOSurfaceRef,
    plane_index: usize,
    component_index: usize,
) -> IOSurfaceComponentType {
    extern "C-unwind" {
        fn IOSurfaceGetTypeOfComponentOfPlane(
            buffer: &IOSurfaceRef,
            plane_index: usize,
            component_index: usize,
        ) -> IOSurfaceComponentType;
    }
    unsafe { IOSurfaceGetTypeOfComponentOfPlane(buffer, plane_index, component_index) }
}

#[deprecated = "renamed to `IOSurfaceRef::range_of_component_of_plane`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetRangeOfComponentOfPlane(
    buffer: &IOSurfaceRef,
    plane_index: usize,
    component_index: usize,
) -> IOSurfaceComponentRange {
    extern "C-unwind" {
        fn IOSurfaceGetRangeOfComponentOfPlane(
            buffer: &IOSurfaceRef,
            plane_index: usize,
            component_index: usize,
        ) -> IOSurfaceComponentRange;
    }
    unsafe { IOSurfaceGetRangeOfComponentOfPlane(buffer, plane_index, component_index) }
}

#[deprecated = "renamed to `IOSurfaceRef::bit_depth_of_component_of_plane`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetBitDepthOfComponentOfPlane(
    buffer: &IOSurfaceRef,
    plane_index: usize,
    component_index: usize,
) -> usize {
    extern "C-unwind" {
        fn IOSurfaceGetBitDepthOfComponentOfPlane(
            buffer: &IOSurfaceRef,
            plane_index: usize,
            component_index: usize,
        ) -> usize;
    }
    unsafe { IOSurfaceGetBitDepthOfComponentOfPlane(buffer, plane_index, component_index) }
}

#[deprecated = "renamed to `IOSurfaceRef::bit_offset_of_component_of_plane`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetBitOffsetOfComponentOfPlane(
    buffer: &IOSurfaceRef,
    plane_index: usize,
    component_index: usize,
) -> usize {
    extern "C-unwind" {
        fn IOSurfaceGetBitOffsetOfComponentOfPlane(
            buffer: &IOSurfaceRef,
            plane_index: usize,
            component_index: usize,
        ) -> usize;
    }
    unsafe { IOSurfaceGetBitOffsetOfComponentOfPlane(buffer, plane_index, component_index) }
}

#[deprecated = "renamed to `IOSurfaceRef::subsampling`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetSubsampling(buffer: &IOSurfaceRef) -> IOSurfaceSubsampling {
    extern "C-unwind" {
        fn IOSurfaceGetSubsampling(buffer: &IOSurfaceRef) -> IOSurfaceSubsampling;
    }
    unsafe { IOSurfaceGetSubsampling(buffer) }
}

extern "C-unwind" {
    #[cfg(feature = "objc2-core-foundation")]
    #[deprecated = "renamed to `IOSurfaceRef::set_value`"]
    pub fn IOSurfaceSetValue(buffer: &IOSurfaceRef, key: &CFString, value: &CFType);
}

#[cfg(feature = "objc2-core-foundation")]
#[deprecated = "renamed to `IOSurfaceRef::value`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceCopyValue(
    buffer: &IOSurfaceRef,
    key: &CFString,
) -> Option<CFRetained<CFType>> {
    extern "C-unwind" {
        fn IOSurfaceCopyValue(buffer: &IOSurfaceRef, key: &CFString) -> Option<NonNull<CFType>>;
    }
    let ret = unsafe { IOSurfaceCopyValue(buffer, key) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "objc2-core-foundation")]
#[deprecated = "renamed to `IOSurfaceRef::remove_value`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceRemoveValue(buffer: &IOSurfaceRef, key: &CFString) {
    extern "C-unwind" {
        fn IOSurfaceRemoveValue(buffer: &IOSurfaceRef, key: &CFString);
    }
    unsafe { IOSurfaceRemoveValue(buffer, key) }
}

extern "C-unwind" {
    #[cfg(feature = "objc2-core-foundation")]
    #[deprecated = "renamed to `IOSurfaceRef::set_values`"]
    pub fn IOSurfaceSetValues(buffer: &IOSurfaceRef, keys_and_values: &CFDictionary);
}

#[cfg(feature = "objc2-core-foundation")]
#[deprecated = "renamed to `IOSurfaceRef::all_values`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceCopyAllValues(
    buffer: &IOSurfaceRef,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn IOSurfaceCopyAllValues(buffer: &IOSurfaceRef) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { IOSurfaceCopyAllValues(buffer) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `IOSurfaceRef::remove_all_values`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceRemoveAllValues(buffer: &IOSurfaceRef) {
    extern "C-unwind" {
        fn IOSurfaceRemoveAllValues(buffer: &IOSurfaceRef);
    }
    unsafe { IOSurfaceRemoveAllValues(buffer) }
}

#[cfg(feature = "libc")]
#[deprecated = "renamed to `IOSurfaceRef::create_mach_port`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceCreateMachPort(buffer: &IOSurfaceRef) -> libc::mach_port_t {
    extern "C-unwind" {
        fn IOSurfaceCreateMachPort(buffer: &IOSurfaceRef) -> libc::mach_port_t;
    }
    unsafe { IOSurfaceCreateMachPort(buffer) }
}

#[cfg(all(feature = "libc", feature = "objc2-core-foundation"))]
#[deprecated = "renamed to `IOSurfaceRef::lookup_from_mach_port`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceLookupFromMachPort(
    port: libc::mach_port_t,
) -> Option<CFRetained<IOSurfaceRef>> {
    extern "C-unwind" {
        fn IOSurfaceLookupFromMachPort(port: libc::mach_port_t) -> Option<NonNull<IOSurfaceRef>>;
    }
    let ret = unsafe { IOSurfaceLookupFromMachPort(port) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "objc2-core-foundation")]
#[deprecated = "renamed to `IOSurfaceRef::property_maximum`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetPropertyMaximum(property: &CFString) -> usize {
    extern "C-unwind" {
        fn IOSurfaceGetPropertyMaximum(property: &CFString) -> usize;
    }
    unsafe { IOSurfaceGetPropertyMaximum(property) }
}

#[cfg(feature = "objc2-core-foundation")]
#[deprecated = "renamed to `IOSurfaceRef::property_alignment`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetPropertyAlignment(property: &CFString) -> usize {
    extern "C-unwind" {
        fn IOSurfaceGetPropertyAlignment(property: &CFString) -> usize;
    }
    unsafe { IOSurfaceGetPropertyAlignment(property) }
}

#[cfg(feature = "objc2-core-foundation")]
#[deprecated = "renamed to `IOSurfaceRef::align_property`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceAlignProperty(property: &CFString, value: usize) -> usize {
    extern "C-unwind" {
        fn IOSurfaceAlignProperty(property: &CFString, value: usize) -> usize;
    }
    unsafe { IOSurfaceAlignProperty(property, value) }
}

#[deprecated = "renamed to `IOSurfaceRef::increment_use_count`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceIncrementUseCount(buffer: &IOSurfaceRef) {
    extern "C-unwind" {
        fn IOSurfaceIncrementUseCount(buffer: &IOSurfaceRef);
    }
    unsafe { IOSurfaceIncrementUseCount(buffer) }
}

#[deprecated = "renamed to `IOSurfaceRef::decrement_use_count`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceDecrementUseCount(buffer: &IOSurfaceRef) {
    extern "C-unwind" {
        fn IOSurfaceDecrementUseCount(buffer: &IOSurfaceRef);
    }
    unsafe { IOSurfaceDecrementUseCount(buffer) }
}

#[deprecated = "renamed to `IOSurfaceRef::use_count`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceGetUseCount(buffer: &IOSurfaceRef) -> i32 {
    extern "C-unwind" {
        fn IOSurfaceGetUseCount(buffer: &IOSurfaceRef) -> i32;
    }
    unsafe { IOSurfaceGetUseCount(buffer) }
}

#[deprecated = "renamed to `IOSurfaceRef::is_in_use`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceIsInUse(buffer: &IOSurfaceRef) -> bool {
    extern "C-unwind" {
        fn IOSurfaceIsInUse(buffer: &IOSurfaceRef) -> Boolean;
    }
    let ret = unsafe { IOSurfaceIsInUse(buffer) };
    ret != 0
}

#[deprecated = "renamed to `IOSurfaceRef::allows_pixel_size_casting`"]
#[inline]
pub extern "C-unwind" fn IOSurfaceAllowsPixelSizeCasting(buffer: &IOSurfaceRef) -> bool {
    extern "C-unwind" {
        fn IOSurfaceAllowsPixelSizeCasting(buffer: &IOSurfaceRef) -> Boolean;
    }
    let ret = unsafe { IOSurfaceAllowsPixelSizeCasting(buffer) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(feature = "libc")]
    #[deprecated = "renamed to `IOSurfaceRef::set_purgeable`"]
    pub fn IOSurfaceSetPurgeable(
        buffer: &IOSurfaceRef,
        new_state: u32,
        old_state: *mut u32,
    ) -> libc::kern_return_t;
}
