//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgnulldirectdisplay?language=objc)
pub const kCGNullDirectDisplay: CGDirectDisplayID = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdirectdisplayid?language=objc)
pub type CGDirectDisplayID = u32;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgopengldisplaymask?language=objc)
pub type CGOpenGLDisplayMask = u32;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgrefreshrate?language=objc)
pub type CGRefreshRate = c_double;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdisplaymode?language=objc)
#[doc(alias = "CGDisplayModeRef")]
#[repr(C)]
pub struct CGDisplayMode {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CGDisplayMode {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"CGDisplayMode"> for CGDisplayMode {}
);

#[inline]
pub extern "C-unwind" fn CGMainDisplayID() -> CGDirectDisplayID {
    extern "C-unwind" {
        fn CGMainDisplayID() -> CGDirectDisplayID;
    }
    unsafe { CGMainDisplayID() }
}

extern "C-unwind" {
    /// # Safety
    ///
    /// - `displays` must be a valid pointer or null.
    /// - `matching_display_count` must be a valid pointer or null.
    #[cfg(feature = "CGError")]
    pub fn CGGetDisplaysWithPoint(
        point: CGPoint,
        max_displays: u32,
        displays: *mut CGDirectDisplayID,
        matching_display_count: *mut u32,
    ) -> CGError;
}

extern "C-unwind" {
    /// # Safety
    ///
    /// - `displays` must be a valid pointer or null.
    /// - `matching_display_count` must be a valid pointer or null.
    #[cfg(feature = "CGError")]
    pub fn CGGetDisplaysWithRect(
        rect: CGRect,
        max_displays: u32,
        displays: *mut CGDirectDisplayID,
        matching_display_count: *mut u32,
    ) -> CGError;
}

extern "C-unwind" {
    /// # Safety
    ///
    /// - `displays` must be a valid pointer or null.
    /// - `matching_display_count` must be a valid pointer or null.
    #[cfg(feature = "CGError")]
    pub fn CGGetDisplaysWithOpenGLDisplayMask(
        mask: CGOpenGLDisplayMask,
        max_displays: u32,
        displays: *mut CGDirectDisplayID,
        matching_display_count: *mut u32,
    ) -> CGError;
}

extern "C-unwind" {
    /// # Safety
    ///
    /// - `active_displays` must be a valid pointer or null.
    /// - `display_count` must be a valid pointer or null.
    #[cfg(feature = "CGError")]
    pub fn CGGetActiveDisplayList(
        max_displays: u32,
        active_displays: *mut CGDirectDisplayID,
        display_count: *mut u32,
    ) -> CGError;
}

extern "C-unwind" {
    /// # Safety
    ///
    /// - `online_displays` must be a valid pointer or null.
    /// - `display_count` must be a valid pointer or null.
    #[cfg(feature = "CGError")]
    pub fn CGGetOnlineDisplayList(
        max_displays: u32,
        online_displays: *mut CGDirectDisplayID,
        display_count: *mut u32,
    ) -> CGError;
}

#[inline]
pub extern "C-unwind" fn CGDisplayIDToOpenGLDisplayMask(
    display: CGDirectDisplayID,
) -> CGOpenGLDisplayMask {
    extern "C-unwind" {
        fn CGDisplayIDToOpenGLDisplayMask(display: CGDirectDisplayID) -> CGOpenGLDisplayMask;
    }
    unsafe { CGDisplayIDToOpenGLDisplayMask(display) }
}

#[inline]
pub extern "C-unwind" fn CGOpenGLDisplayMaskToDisplayID(
    mask: CGOpenGLDisplayMask,
) -> CGDirectDisplayID {
    extern "C-unwind" {
        fn CGOpenGLDisplayMaskToDisplayID(mask: CGOpenGLDisplayMask) -> CGDirectDisplayID;
    }
    unsafe { CGOpenGLDisplayMaskToDisplayID(mask) }
}

#[inline]
pub extern "C-unwind" fn CGDisplayBounds(display: CGDirectDisplayID) -> CGRect {
    extern "C-unwind" {
        fn CGDisplayBounds(display: CGDirectDisplayID) -> CGRect;
    }
    unsafe { CGDisplayBounds(display) }
}

#[inline]
pub extern "C-unwind" fn CGDisplayPixelsWide(display: CGDirectDisplayID) -> usize {
    extern "C-unwind" {
        fn CGDisplayPixelsWide(display: CGDirectDisplayID) -> usize;
    }
    unsafe { CGDisplayPixelsWide(display) }
}

#[inline]
pub extern "C-unwind" fn CGDisplayPixelsHigh(display: CGDirectDisplayID) -> usize {
    extern "C-unwind" {
        fn CGDisplayPixelsHigh(display: CGDirectDisplayID) -> usize;
    }
    unsafe { CGDisplayPixelsHigh(display) }
}

/// # Safety
///
/// `options` generics must be of the correct type.
#[inline]
pub unsafe extern "C-unwind" fn CGDisplayCopyAllDisplayModes(
    display: CGDirectDisplayID,
    options: Option<&CFDictionary>,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CGDisplayCopyAllDisplayModes(
            display: CGDirectDisplayID,
            options: Option<&CFDictionary>,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CGDisplayCopyAllDisplayModes(display, options) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgdisplayshowduplicatelowresolutionmodes?language=objc)
    pub static kCGDisplayShowDuplicateLowResolutionModes: &'static CFString;
}

#[inline]
pub extern "C-unwind" fn CGDisplayCopyDisplayMode(
    display: CGDirectDisplayID,
) -> Option<CFRetained<CGDisplayMode>> {
    extern "C-unwind" {
        fn CGDisplayCopyDisplayMode(display: CGDirectDisplayID) -> Option<NonNull<CGDisplayMode>>;
    }
    let ret = unsafe { CGDisplayCopyDisplayMode(display) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    /// # Safety
    ///
    /// `options` generics must be of the correct type.
    #[cfg(feature = "CGError")]
    pub fn CGDisplaySetDisplayMode(
        display: CGDirectDisplayID,
        mode: Option<&CGDisplayMode>,
        options: Option<&CFDictionary>,
    ) -> CGError;
}

impl CGDisplayMode {
    #[doc(alias = "CGDisplayModeGetWidth")]
    #[inline]
    pub fn width(mode: Option<&CGDisplayMode>) -> usize {
        extern "C-unwind" {
            fn CGDisplayModeGetWidth(mode: Option<&CGDisplayMode>) -> usize;
        }
        unsafe { CGDisplayModeGetWidth(mode) }
    }

    #[doc(alias = "CGDisplayModeGetHeight")]
    #[inline]
    pub fn height(mode: Option<&CGDisplayMode>) -> usize {
        extern "C-unwind" {
            fn CGDisplayModeGetHeight(mode: Option<&CGDisplayMode>) -> usize;
        }
        unsafe { CGDisplayModeGetHeight(mode) }
    }

    #[doc(alias = "CGDisplayModeCopyPixelEncoding")]
    #[deprecated = "No longer supported"]
    #[inline]
    pub fn pixel_encoding(mode: Option<&CGDisplayMode>) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CGDisplayModeCopyPixelEncoding(
                mode: Option<&CGDisplayMode>,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CGDisplayModeCopyPixelEncoding(mode) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGDisplayModeGetRefreshRate")]
    #[inline]
    pub fn refresh_rate(mode: Option<&CGDisplayMode>) -> c_double {
        extern "C-unwind" {
            fn CGDisplayModeGetRefreshRate(mode: Option<&CGDisplayMode>) -> c_double;
        }
        unsafe { CGDisplayModeGetRefreshRate(mode) }
    }

    #[doc(alias = "CGDisplayModeGetIOFlags")]
    #[inline]
    pub fn io_flags(mode: Option<&CGDisplayMode>) -> u32 {
        extern "C-unwind" {
            fn CGDisplayModeGetIOFlags(mode: Option<&CGDisplayMode>) -> u32;
        }
        unsafe { CGDisplayModeGetIOFlags(mode) }
    }

    #[doc(alias = "CGDisplayModeGetIODisplayModeID")]
    #[inline]
    pub fn io_display_mode_id(mode: Option<&CGDisplayMode>) -> i32 {
        extern "C-unwind" {
            fn CGDisplayModeGetIODisplayModeID(mode: Option<&CGDisplayMode>) -> i32;
        }
        unsafe { CGDisplayModeGetIODisplayModeID(mode) }
    }

    #[doc(alias = "CGDisplayModeIsUsableForDesktopGUI")]
    #[inline]
    pub fn is_usable_for_desktop_gui(mode: Option<&CGDisplayMode>) -> bool {
        extern "C-unwind" {
            fn CGDisplayModeIsUsableForDesktopGUI(mode: Option<&CGDisplayMode>) -> bool;
        }
        unsafe { CGDisplayModeIsUsableForDesktopGUI(mode) }
    }
}

unsafe impl ConcreteType for CGDisplayMode {
    #[doc(alias = "CGDisplayModeGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CGDisplayModeGetTypeID() -> CFTypeID;
        }
        unsafe { CGDisplayModeGetTypeID() }
    }
}

impl CGDisplayMode {
    #[doc(alias = "CGDisplayModeGetPixelWidth")]
    #[inline]
    pub fn pixel_width(mode: Option<&CGDisplayMode>) -> usize {
        extern "C-unwind" {
            fn CGDisplayModeGetPixelWidth(mode: Option<&CGDisplayMode>) -> usize;
        }
        unsafe { CGDisplayModeGetPixelWidth(mode) }
    }

    #[doc(alias = "CGDisplayModeGetPixelHeight")]
    #[inline]
    pub fn pixel_height(mode: Option<&CGDisplayMode>) -> usize {
        extern "C-unwind" {
            fn CGDisplayModeGetPixelHeight(mode: Option<&CGDisplayMode>) -> usize;
        }
        unsafe { CGDisplayModeGetPixelHeight(mode) }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cggammavalue?language=objc)
pub type CGGammaValue = c_float;

#[cfg(feature = "CGError")]
#[inline]
pub extern "C-unwind" fn CGSetDisplayTransferByFormula(
    display: CGDirectDisplayID,
    red_min: CGGammaValue,
    red_max: CGGammaValue,
    red_gamma: CGGammaValue,
    green_min: CGGammaValue,
    green_max: CGGammaValue,
    green_gamma: CGGammaValue,
    blue_min: CGGammaValue,
    blue_max: CGGammaValue,
    blue_gamma: CGGammaValue,
) -> CGError {
    extern "C-unwind" {
        fn CGSetDisplayTransferByFormula(
            display: CGDirectDisplayID,
            red_min: CGGammaValue,
            red_max: CGGammaValue,
            red_gamma: CGGammaValue,
            green_min: CGGammaValue,
            green_max: CGGammaValue,
            green_gamma: CGGammaValue,
            blue_min: CGGammaValue,
            blue_max: CGGammaValue,
            blue_gamma: CGGammaValue,
        ) -> CGError;
    }
    unsafe {
        CGSetDisplayTransferByFormula(
            display,
            red_min,
            red_max,
            red_gamma,
            green_min,
            green_max,
            green_gamma,
            blue_min,
            blue_max,
            blue_gamma,
        )
    }
}

extern "C-unwind" {
    /// # Safety
    ///
    /// - `red_min` must be a valid pointer or null.
    /// - `red_max` must be a valid pointer or null.
    /// - `red_gamma` must be a valid pointer or null.
    /// - `green_min` must be a valid pointer or null.
    /// - `green_max` must be a valid pointer or null.
    /// - `green_gamma` must be a valid pointer or null.
    /// - `blue_min` must be a valid pointer or null.
    /// - `blue_max` must be a valid pointer or null.
    /// - `blue_gamma` must be a valid pointer or null.
    #[cfg(feature = "CGError")]
    pub fn CGGetDisplayTransferByFormula(
        display: CGDirectDisplayID,
        red_min: *mut CGGammaValue,
        red_max: *mut CGGammaValue,
        red_gamma: *mut CGGammaValue,
        green_min: *mut CGGammaValue,
        green_max: *mut CGGammaValue,
        green_gamma: *mut CGGammaValue,
        blue_min: *mut CGGammaValue,
        blue_max: *mut CGGammaValue,
        blue_gamma: *mut CGGammaValue,
    ) -> CGError;
}

#[inline]
pub extern "C-unwind" fn CGDisplayGammaTableCapacity(display: CGDirectDisplayID) -> u32 {
    extern "C-unwind" {
        fn CGDisplayGammaTableCapacity(display: CGDirectDisplayID) -> u32;
    }
    unsafe { CGDisplayGammaTableCapacity(display) }
}

extern "C-unwind" {
    /// # Safety
    ///
    /// - `red_table` must be a valid pointer or null.
    /// - `green_table` must be a valid pointer or null.
    /// - `blue_table` must be a valid pointer or null.
    #[cfg(feature = "CGError")]
    pub fn CGSetDisplayTransferByTable(
        display: CGDirectDisplayID,
        table_size: u32,
        red_table: *const CGGammaValue,
        green_table: *const CGGammaValue,
        blue_table: *const CGGammaValue,
    ) -> CGError;
}

extern "C-unwind" {
    /// # Safety
    ///
    /// - `red_table` must be a valid pointer or null.
    /// - `green_table` must be a valid pointer or null.
    /// - `blue_table` must be a valid pointer or null.
    /// - `sample_count` must be a valid pointer or null.
    #[cfg(feature = "CGError")]
    pub fn CGGetDisplayTransferByTable(
        display: CGDirectDisplayID,
        capacity: u32,
        red_table: *mut CGGammaValue,
        green_table: *mut CGGammaValue,
        blue_table: *mut CGGammaValue,
        sample_count: *mut u32,
    ) -> CGError;
}

extern "C-unwind" {
    /// # Safety
    ///
    /// - `red_table` must be a valid pointer.
    /// - `green_table` must be a valid pointer.
    /// - `blue_table` must be a valid pointer.
    #[cfg(feature = "CGError")]
    pub fn CGSetDisplayTransferByByteTable(
        display: CGDirectDisplayID,
        table_size: u32,
        red_table: NonNull<u8>,
        green_table: NonNull<u8>,
        blue_table: NonNull<u8>,
    ) -> CGError;
}

#[inline]
pub extern "C-unwind" fn CGDisplayRestoreColorSyncSettings() {
    extern "C-unwind" {
        fn CGDisplayRestoreColorSyncSettings();
    }
    unsafe { CGDisplayRestoreColorSyncSettings() }
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgcaptureoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGCaptureOptions(pub u32);
bitflags::bitflags! {
    impl CGCaptureOptions: u32 {
        #[doc(alias = "kCGCaptureNoOptions")]
        const NoOptions = 0;
        #[doc(alias = "kCGCaptureNoFill")]
#[deprecated]
        const NoFill = 1<<0;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGCaptureOptions {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGCaptureOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[cfg(feature = "libc")]
#[deprecated = "No longer supported"]
#[inline]
pub extern "C-unwind" fn CGDisplayIsCaptured(display: CGDirectDisplayID) -> bool {
    extern "C-unwind" {
        fn CGDisplayIsCaptured(display: CGDirectDisplayID) -> libc::boolean_t;
    }
    let ret = unsafe { CGDisplayIsCaptured(display) };
    ret != 0
}

#[cfg(feature = "CGError")]
#[inline]
pub extern "C-unwind" fn CGDisplayCapture(display: CGDirectDisplayID) -> CGError {
    extern "C-unwind" {
        fn CGDisplayCapture(display: CGDirectDisplayID) -> CGError;
    }
    unsafe { CGDisplayCapture(display) }
}

#[cfg(feature = "CGError")]
#[inline]
pub extern "C-unwind" fn CGDisplayCaptureWithOptions(
    display: CGDirectDisplayID,
    options: CGCaptureOptions,
) -> CGError {
    extern "C-unwind" {
        fn CGDisplayCaptureWithOptions(
            display: CGDirectDisplayID,
            options: CGCaptureOptions,
        ) -> CGError;
    }
    unsafe { CGDisplayCaptureWithOptions(display, options) }
}

#[cfg(feature = "CGError")]
#[inline]
pub extern "C-unwind" fn CGDisplayRelease(display: CGDirectDisplayID) -> CGError {
    extern "C-unwind" {
        fn CGDisplayRelease(display: CGDirectDisplayID) -> CGError;
    }
    unsafe { CGDisplayRelease(display) }
}

#[cfg(feature = "CGError")]
#[inline]
pub extern "C-unwind" fn CGCaptureAllDisplays() -> CGError {
    extern "C-unwind" {
        fn CGCaptureAllDisplays() -> CGError;
    }
    unsafe { CGCaptureAllDisplays() }
}

#[cfg(feature = "CGError")]
#[inline]
pub extern "C-unwind" fn CGCaptureAllDisplaysWithOptions(options: CGCaptureOptions) -> CGError {
    extern "C-unwind" {
        fn CGCaptureAllDisplaysWithOptions(options: CGCaptureOptions) -> CGError;
    }
    unsafe { CGCaptureAllDisplaysWithOptions(options) }
}

#[cfg(feature = "CGError")]
#[inline]
pub extern "C-unwind" fn CGReleaseAllDisplays() -> CGError {
    extern "C-unwind" {
        fn CGReleaseAllDisplays() -> CGError;
    }
    unsafe { CGReleaseAllDisplays() }
}

#[cfg(feature = "CGWindow")]
#[inline]
pub extern "C-unwind" fn CGShieldingWindowID(display: CGDirectDisplayID) -> CGWindowID {
    extern "C-unwind" {
        fn CGShieldingWindowID(display: CGDirectDisplayID) -> CGWindowID;
    }
    unsafe { CGShieldingWindowID(display) }
}

#[cfg(feature = "CGWindowLevel")]
#[inline]
pub extern "C-unwind" fn CGShieldingWindowLevel() -> CGWindowLevel {
    extern "C-unwind" {
        fn CGShieldingWindowLevel() -> CGWindowLevel;
    }
    unsafe { CGShieldingWindowLevel() }
}

#[cfg(feature = "CGImage")]
#[deprecated = "Please use ScreenCaptureKit instead."]
#[inline]
pub extern "C-unwind" fn CGDisplayCreateImage(
    display_id: CGDirectDisplayID,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGDisplayCreateImage(display_id: CGDirectDisplayID) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe { CGDisplayCreateImage(display_id) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CGImage")]
#[deprecated = "Please use ScreenCaptureKit instead."]
#[inline]
pub extern "C-unwind" fn CGDisplayCreateImageForRect(
    display: CGDirectDisplayID,
    rect: CGRect,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGDisplayCreateImageForRect(
            display: CGDirectDisplayID,
            rect: CGRect,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe { CGDisplayCreateImageForRect(display, rect) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CGError")]
#[inline]
pub extern "C-unwind" fn CGDisplayHideCursor(display: CGDirectDisplayID) -> CGError {
    extern "C-unwind" {
        fn CGDisplayHideCursor(display: CGDirectDisplayID) -> CGError;
    }
    unsafe { CGDisplayHideCursor(display) }
}

#[cfg(feature = "CGError")]
#[inline]
pub extern "C-unwind" fn CGDisplayShowCursor(display: CGDirectDisplayID) -> CGError {
    extern "C-unwind" {
        fn CGDisplayShowCursor(display: CGDirectDisplayID) -> CGError;
    }
    unsafe { CGDisplayShowCursor(display) }
}

#[cfg(feature = "CGError")]
#[inline]
pub extern "C-unwind" fn CGDisplayMoveCursorToPoint(
    display: CGDirectDisplayID,
    point: CGPoint,
) -> CGError {
    extern "C-unwind" {
        fn CGDisplayMoveCursorToPoint(display: CGDirectDisplayID, point: CGPoint) -> CGError;
    }
    unsafe { CGDisplayMoveCursorToPoint(display, point) }
}

extern "C-unwind" {
    /// # Safety
    ///
    /// - `delta_x` must be a valid pointer or null.
    /// - `delta_y` must be a valid pointer or null.
    pub fn CGGetLastMouseDelta(delta_x: *mut i32, delta_y: *mut i32);
}

#[cfg(feature = "CGContext")]
#[inline]
pub extern "C-unwind" fn CGDisplayGetDrawingContext(
    display: CGDirectDisplayID,
) -> Option<CFRetained<CGContext>> {
    extern "C-unwind" {
        fn CGDisplayGetDrawingContext(display: CGDirectDisplayID) -> Option<NonNull<CGContext>>;
    }
    let ret = unsafe { CGDisplayGetDrawingContext(display) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdisplaycount?language=objc)
pub type CGDisplayCount = u32;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdisplayerr?language=objc)
#[cfg(feature = "CGError")]
pub type CGDisplayErr = CGError;

#[deprecated = "No longer supported"]
#[inline]
pub unsafe extern "C-unwind" fn CGDisplayAvailableModes(
    dsp: CGDirectDisplayID,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CGDisplayAvailableModes(dsp: CGDirectDisplayID) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CGDisplayAvailableModes(dsp) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

/// # Safety
///
/// `exact_match` must be a valid pointer or null.
#[cfg(feature = "libc")]
#[deprecated = "No longer supported"]
#[inline]
pub unsafe extern "C-unwind" fn CGDisplayBestModeForParameters(
    display: CGDirectDisplayID,
    bits_per_pixel: usize,
    width: usize,
    height: usize,
    exact_match: *mut libc::boolean_t,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CGDisplayBestModeForParameters(
            display: CGDirectDisplayID,
            bits_per_pixel: usize,
            width: usize,
            height: usize,
            exact_match: *mut libc::boolean_t,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe {
        CGDisplayBestModeForParameters(display, bits_per_pixel, width, height, exact_match)
    };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

/// # Safety
///
/// `exact_match` must be a valid pointer or null.
#[cfg(feature = "libc")]
#[deprecated = "No longer supported"]
#[inline]
pub unsafe extern "C-unwind" fn CGDisplayBestModeForParametersAndRefreshRate(
    display: CGDirectDisplayID,
    bits_per_pixel: usize,
    width: usize,
    height: usize,
    refresh_rate: CGRefreshRate,
    exact_match: *mut libc::boolean_t,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CGDisplayBestModeForParametersAndRefreshRate(
            display: CGDirectDisplayID,
            bits_per_pixel: usize,
            width: usize,
            height: usize,
            refresh_rate: CGRefreshRate,
            exact_match: *mut libc::boolean_t,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe {
        CGDisplayBestModeForParametersAndRefreshRate(
            display,
            bits_per_pixel,
            width,
            height,
            refresh_rate,
            exact_match,
        )
    };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "No longer supported"]
#[inline]
pub unsafe extern "C-unwind" fn CGDisplayCurrentMode(
    display: CGDirectDisplayID,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CGDisplayCurrentMode(display: CGDirectDisplayID) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CGDisplayCurrentMode(display) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    /// # Safety
    ///
    /// `mode` generics must be of the correct type.
    #[cfg(feature = "CGError")]
    #[deprecated = "No longer supported"]
    pub fn CGDisplaySwitchToMode(
        display: CGDirectDisplayID,
        mode: Option<&CFDictionary>,
    ) -> CGError;
}

#[deprecated = "renamed to `CGDisplayMode::width`"]
#[inline]
pub extern "C-unwind" fn CGDisplayModeGetWidth(mode: Option<&CGDisplayMode>) -> usize {
    extern "C-unwind" {
        fn CGDisplayModeGetWidth(mode: Option<&CGDisplayMode>) -> usize;
    }
    unsafe { CGDisplayModeGetWidth(mode) }
}

#[deprecated = "renamed to `CGDisplayMode::height`"]
#[inline]
pub extern "C-unwind" fn CGDisplayModeGetHeight(mode: Option<&CGDisplayMode>) -> usize {
    extern "C-unwind" {
        fn CGDisplayModeGetHeight(mode: Option<&CGDisplayMode>) -> usize;
    }
    unsafe { CGDisplayModeGetHeight(mode) }
}

#[deprecated = "renamed to `CGDisplayMode::pixel_encoding`"]
#[inline]
pub extern "C-unwind" fn CGDisplayModeCopyPixelEncoding(
    mode: Option<&CGDisplayMode>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CGDisplayModeCopyPixelEncoding(
            mode: Option<&CGDisplayMode>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CGDisplayModeCopyPixelEncoding(mode) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGDisplayMode::refresh_rate`"]
#[inline]
pub extern "C-unwind" fn CGDisplayModeGetRefreshRate(mode: Option<&CGDisplayMode>) -> c_double {
    extern "C-unwind" {
        fn CGDisplayModeGetRefreshRate(mode: Option<&CGDisplayMode>) -> c_double;
    }
    unsafe { CGDisplayModeGetRefreshRate(mode) }
}

#[deprecated = "renamed to `CGDisplayMode::io_flags`"]
#[inline]
pub extern "C-unwind" fn CGDisplayModeGetIOFlags(mode: Option<&CGDisplayMode>) -> u32 {
    extern "C-unwind" {
        fn CGDisplayModeGetIOFlags(mode: Option<&CGDisplayMode>) -> u32;
    }
    unsafe { CGDisplayModeGetIOFlags(mode) }
}

#[deprecated = "renamed to `CGDisplayMode::io_display_mode_id`"]
#[inline]
pub extern "C-unwind" fn CGDisplayModeGetIODisplayModeID(mode: Option<&CGDisplayMode>) -> i32 {
    extern "C-unwind" {
        fn CGDisplayModeGetIODisplayModeID(mode: Option<&CGDisplayMode>) -> i32;
    }
    unsafe { CGDisplayModeGetIODisplayModeID(mode) }
}

#[deprecated = "renamed to `CGDisplayMode::is_usable_for_desktop_gui`"]
#[inline]
pub extern "C-unwind" fn CGDisplayModeIsUsableForDesktopGUI(mode: Option<&CGDisplayMode>) -> bool {
    extern "C-unwind" {
        fn CGDisplayModeIsUsableForDesktopGUI(mode: Option<&CGDisplayMode>) -> bool;
    }
    unsafe { CGDisplayModeIsUsableForDesktopGUI(mode) }
}

#[deprecated = "renamed to `CGDisplayMode::pixel_width`"]
#[inline]
pub extern "C-unwind" fn CGDisplayModeGetPixelWidth(mode: Option<&CGDisplayMode>) -> usize {
    extern "C-unwind" {
        fn CGDisplayModeGetPixelWidth(mode: Option<&CGDisplayMode>) -> usize;
    }
    unsafe { CGDisplayModeGetPixelWidth(mode) }
}

#[deprecated = "renamed to `CGDisplayMode::pixel_height`"]
#[inline]
pub extern "C-unwind" fn CGDisplayModeGetPixelHeight(mode: Option<&CGDisplayMode>) -> usize {
    extern "C-unwind" {
        fn CGDisplayModeGetPixelHeight(mode: Option<&CGDisplayMode>) -> usize;
    }
    unsafe { CGDisplayModeGetPixelHeight(mode) }
}
