//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstypesetter?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSTypesetter;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSTypesetter {}
);

impl NSTypesetter {
    extern_methods!(
        #[unsafe(method(usesFontLeading))]
        #[unsafe(method_family = none)]
        pub fn usesFontLeading(&self) -> bool;

        /// Setter for [`usesFontLeading`][Self::usesFontLeading].
        #[unsafe(method(setUsesFontLeading:))]
        #[unsafe(method_family = none)]
        pub fn setUsesFontLeading(&self, uses_font_leading: bool);

        #[cfg(feature = "NSLayoutManager")]
        #[unsafe(method(typesetterBehavior))]
        #[unsafe(method_family = none)]
        pub fn typesetterBehavior(&self) -> NSTypesetterBehavior;

        #[cfg(feature = "NSLayoutManager")]
        /// Setter for [`typesetterBehavior`][Self::typesetterBehavior].
        #[unsafe(method(setTypesetterBehavior:))]
        #[unsafe(method_family = none)]
        pub fn setTypesetterBehavior(&self, typesetter_behavior: NSTypesetterBehavior);

        #[unsafe(method(hyphenationFactor))]
        #[unsafe(method_family = none)]
        pub fn hyphenationFactor(&self) -> c_float;

        /// Setter for [`hyphenationFactor`][Self::hyphenationFactor].
        #[unsafe(method(setHyphenationFactor:))]
        #[unsafe(method_family = none)]
        pub fn setHyphenationFactor(&self, hyphenation_factor: c_float);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(lineFragmentPadding))]
        #[unsafe(method_family = none)]
        pub fn lineFragmentPadding(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`lineFragmentPadding`][Self::lineFragmentPadding].
        #[unsafe(method(setLineFragmentPadding:))]
        #[unsafe(method_family = none)]
        pub fn setLineFragmentPadding(&self, line_fragment_padding: CGFloat);

        #[cfg(feature = "NSFont")]
        #[unsafe(method(substituteFontForFont:))]
        #[unsafe(method_family = none)]
        pub fn substituteFontForFont(&self, original_font: &NSFont) -> Retained<NSFont>;

        #[cfg(all(
            feature = "NSParagraphStyle",
            feature = "NSText",
            feature = "objc2-core-foundation"
        ))]
        #[unsafe(method(textTabForGlyphLocation:writingDirection:maxLocation:))]
        #[unsafe(method_family = none)]
        pub fn textTabForGlyphLocation_writingDirection_maxLocation(
            &self,
            glyph_location: CGFloat,
            direction: NSWritingDirection,
            max_location: CGFloat,
        ) -> Option<Retained<NSTextTab>>;

        #[unsafe(method(bidiProcessingEnabled))]
        #[unsafe(method_family = none)]
        pub fn bidiProcessingEnabled(&self) -> bool;

        /// Setter for [`bidiProcessingEnabled`][Self::bidiProcessingEnabled].
        #[unsafe(method(setBidiProcessingEnabled:))]
        #[unsafe(method_family = none)]
        pub fn setBidiProcessingEnabled(&self, bidi_processing_enabled: bool);

        /// # Safety
        ///
        /// This is not retained internally, you must ensure the object is still alive.
        #[unsafe(method(attributedString))]
        #[unsafe(method_family = none)]
        pub unsafe fn attributedString(&self) -> Option<Retained<NSAttributedString>>;

        /// Setter for [`attributedString`][Self::attributedString].
        ///
        /// # Safety
        ///
        /// This is unretained, you must ensure the object is kept alive while in use.
        #[unsafe(method(setAttributedString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAttributedString(&self, attributed_string: Option<&NSAttributedString>);

        #[unsafe(method(setParagraphGlyphRange:separatorGlyphRange:))]
        #[unsafe(method_family = none)]
        pub fn setParagraphGlyphRange_separatorGlyphRange(
            &self,
            paragraph_range: NSRange,
            paragraph_separator_range: NSRange,
        );

        #[unsafe(method(paragraphGlyphRange))]
        #[unsafe(method_family = none)]
        pub fn paragraphGlyphRange(&self) -> NSRange;

        #[unsafe(method(paragraphSeparatorGlyphRange))]
        #[unsafe(method_family = none)]
        pub fn paragraphSeparatorGlyphRange(&self) -> NSRange;

        #[unsafe(method(paragraphCharacterRange))]
        #[unsafe(method_family = none)]
        pub fn paragraphCharacterRange(&self) -> NSRange;

        #[unsafe(method(paragraphSeparatorCharacterRange))]
        #[unsafe(method_family = none)]
        pub fn paragraphSeparatorCharacterRange(&self) -> NSRange;

        /// # Safety
        ///
        /// `line_fragment_origin` must be a valid pointer.
        #[unsafe(method(layoutParagraphAtPoint:))]
        #[unsafe(method_family = none)]
        pub unsafe fn layoutParagraphAtPoint(
            &self,
            line_fragment_origin: NSPointPointer,
        ) -> NSUInteger;

        #[unsafe(method(beginParagraph))]
        #[unsafe(method_family = none)]
        pub fn beginParagraph(&self);

        #[unsafe(method(endParagraph))]
        #[unsafe(method_family = none)]
        pub fn endParagraph(&self);

        #[unsafe(method(beginLineWithGlyphAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn beginLineWithGlyphAtIndex(&self, glyph_index: NSUInteger);

        #[unsafe(method(endLineWithGlyphRange:))]
        #[unsafe(method_family = none)]
        pub fn endLineWithGlyphRange(&self, line_glyph_range: NSRange);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(lineSpacingAfterGlyphAtIndex:withProposedLineFragmentRect:))]
        #[unsafe(method_family = none)]
        pub fn lineSpacingAfterGlyphAtIndex_withProposedLineFragmentRect(
            &self,
            glyph_index: NSUInteger,
            rect: NSRect,
        ) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(paragraphSpacingBeforeGlyphAtIndex:withProposedLineFragmentRect:))]
        #[unsafe(method_family = none)]
        pub fn paragraphSpacingBeforeGlyphAtIndex_withProposedLineFragmentRect(
            &self,
            glyph_index: NSUInteger,
            rect: NSRect,
        ) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(paragraphSpacingAfterGlyphAtIndex:withProposedLineFragmentRect:))]
        #[unsafe(method_family = none)]
        pub fn paragraphSpacingAfterGlyphAtIndex_withProposedLineFragmentRect(
            &self,
            glyph_index: NSUInteger,
            rect: NSRect,
        ) -> CGFloat;

        /// # Safety
        ///
        /// - `line_fragment_rect` must be a valid pointer.
        /// - `line_fragment_used_rect` must be a valid pointer.
        #[unsafe(method(getLineFragmentRect:usedRect:forParagraphSeparatorGlyphRange:atProposedOrigin:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getLineFragmentRect_usedRect_forParagraphSeparatorGlyphRange_atProposedOrigin(
            &self,
            line_fragment_rect: NSRectPointer,
            line_fragment_used_rect: NSRectPointer,
            paragraph_separator_glyph_range: NSRange,
            line_origin: NSPoint,
        );

        #[unsafe(method(attributesForExtraLineFragment))]
        #[unsafe(method_family = none)]
        pub fn attributesForExtraLineFragment(
            &self,
        ) -> Retained<NSDictionary<NSAttributedStringKey, AnyObject>>;

        #[cfg(feature = "NSLayoutManager")]
        /// # Safety
        ///
        /// This is not retained internally, you must ensure the object is still alive.
        #[unsafe(method(layoutManager))]
        #[unsafe(method_family = none)]
        pub unsafe fn layoutManager(&self) -> Option<Retained<NSLayoutManager>>;

        #[cfg(feature = "NSTextContainer")]
        /// # Safety
        ///
        /// This is not retained internally, you must ensure the object is still alive.
        #[unsafe(method(textContainers))]
        #[unsafe(method_family = none)]
        pub unsafe fn textContainers(&self) -> Option<Retained<NSArray<NSTextContainer>>>;

        #[cfg(feature = "NSTextContainer")]
        /// # Safety
        ///
        /// This is not retained internally, you must ensure the object is still alive.
        #[unsafe(method(currentTextContainer))]
        #[unsafe(method_family = none)]
        pub unsafe fn currentTextContainer(&self) -> Option<Retained<NSTextContainer>>;

        #[cfg(feature = "NSParagraphStyle")]
        #[unsafe(method(currentParagraphStyle))]
        #[unsafe(method_family = none)]
        pub fn currentParagraphStyle(&self) -> Option<Retained<NSParagraphStyle>>;

        #[unsafe(method(setHardInvalidation:forGlyphRange:))]
        #[unsafe(method_family = none)]
        pub fn setHardInvalidation_forGlyphRange(&self, flag: bool, glyph_range: NSRange);

        #[cfg(feature = "NSLayoutManager")]
        /// # Safety
        ///
        /// `next_glyph` must be a valid pointer.
        #[unsafe(method(layoutGlyphsInLayoutManager:startingAtGlyphIndex:maxNumberOfLineFragments:nextGlyphIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn layoutGlyphsInLayoutManager_startingAtGlyphIndex_maxNumberOfLineFragments_nextGlyphIndex(
            &self,
            layout_manager: &NSLayoutManager,
            start_glyph_index: NSUInteger,
            max_num_lines: NSUInteger,
            next_glyph: NonNull<NSUInteger>,
        );

        #[cfg(feature = "NSLayoutManager")]
        #[unsafe(method(layoutCharactersInRange:forLayoutManager:maximumNumberOfLineFragments:))]
        #[unsafe(method_family = none)]
        pub fn layoutCharactersInRange_forLayoutManager_maximumNumberOfLineFragments(
            &self,
            character_range: NSRange,
            layout_manager: &NSLayoutManager,
            max_num_lines: NSUInteger,
        ) -> NSRange;

        #[cfg(feature = "NSLayoutManager")]
        /// # Safety
        ///
        /// `packed_glyphs` must be a valid pointer.
        #[unsafe(method(printingAdjustmentInLayoutManager:forNominallySpacedGlyphRange:packedGlyphs:count:))]
        #[unsafe(method_family = none)]
        pub unsafe fn printingAdjustmentInLayoutManager_forNominallySpacedGlyphRange_packedGlyphs_count(
            layout_mgr: &NSLayoutManager,
            nominally_spaced_glyphs_range: NSRange,
            packed_glyphs: NonNull<c_uchar>,
            packed_glyphs_count: NSUInteger,
        ) -> NSSize;

        #[cfg(all(feature = "NSLayoutManager", feature = "objc2-core-foundation"))]
        #[unsafe(method(baselineOffsetInLayoutManager:glyphIndex:))]
        #[unsafe(method_family = none)]
        pub fn baselineOffsetInLayoutManager_glyphIndex(
            &self,
            layout_mgr: &NSLayoutManager,
            glyph_index: NSUInteger,
        ) -> CGFloat;

        #[unsafe(method(sharedSystemTypesetter))]
        #[unsafe(method_family = none)]
        pub fn sharedSystemTypesetter() -> Retained<NSTypesetter>;

        #[cfg(feature = "NSLayoutManager")]
        #[unsafe(method(sharedSystemTypesetterForBehavior:))]
        #[unsafe(method_family = none)]
        pub fn sharedSystemTypesetterForBehavior(
            behavior: NSTypesetterBehavior,
        ) -> Retained<AnyObject>;

        #[cfg(feature = "NSLayoutManager")]
        #[unsafe(method(defaultTypesetterBehavior))]
        #[unsafe(method_family = none)]
        pub fn defaultTypesetterBehavior() -> NSTypesetterBehavior;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSTypesetter {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSTypesetter {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

/// NSLayoutPhaseInterface.
impl NSTypesetter {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        /// # Safety
        ///
        /// - `line_rect` must be a valid pointer.
        /// - `used_rect` must be a valid pointer.
        /// - `baseline_offset` must be a valid pointer.
        #[unsafe(method(willSetLineFragmentRect:forGlyphRange:usedRect:baselineOffset:))]
        #[unsafe(method_family = none)]
        pub unsafe fn willSetLineFragmentRect_forGlyphRange_usedRect_baselineOffset(
            &self,
            line_rect: NSRectPointer,
            glyph_range: NSRange,
            used_rect: NSRectPointer,
            baseline_offset: NonNull<CGFloat>,
        );

        #[unsafe(method(shouldBreakLineByWordBeforeCharacterAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn shouldBreakLineByWordBeforeCharacterAtIndex(&self, char_index: NSUInteger) -> bool;

        #[unsafe(method(shouldBreakLineByHyphenatingBeforeCharacterAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn shouldBreakLineByHyphenatingBeforeCharacterAtIndex(
            &self,
            char_index: NSUInteger,
        ) -> bool;

        #[unsafe(method(hyphenationFactorForGlyphAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn hyphenationFactorForGlyphAtIndex(&self, glyph_index: NSUInteger) -> c_float;

        #[unsafe(method(hyphenCharacterForGlyphAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn hyphenCharacterForGlyphAtIndex(&self, glyph_index: NSUInteger) -> UTF32Char;

        #[cfg(feature = "NSTextContainer")]
        #[unsafe(method(boundingBoxForControlGlyphAtIndex:forTextContainer:proposedLineFragment:glyphPosition:characterIndex:))]
        #[unsafe(method_family = none)]
        pub fn boundingBoxForControlGlyphAtIndex_forTextContainer_proposedLineFragment_glyphPosition_characterIndex(
            &self,
            glyph_index: NSUInteger,
            text_container: &NSTextContainer,
            proposed_rect: NSRect,
            glyph_position: NSPoint,
            char_index: NSUInteger,
        ) -> NSRect;
    );
}

/// NSGlyphStorageInterface.
impl NSTypesetter {
    extern_methods!(
        /// # Safety
        ///
        /// `actual_glyph_range` must be a valid pointer or null.
        #[unsafe(method(characterRangeForGlyphRange:actualGlyphRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn characterRangeForGlyphRange_actualGlyphRange(
            &self,
            glyph_range: NSRange,
            actual_glyph_range: NSRangePointer,
        ) -> NSRange;

        /// # Safety
        ///
        /// `actual_char_range` must be a valid pointer or null.
        #[unsafe(method(glyphRangeForCharacterRange:actualCharacterRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn glyphRangeForCharacterRange_actualCharacterRange(
            &self,
            char_range: NSRange,
            actual_char_range: NSRangePointer,
        ) -> NSRange;

        #[cfg(feature = "objc2-core-foundation")]
        /// # Safety
        ///
        /// - `line_fragment_rect` must be a valid pointer.
        /// - `line_fragment_used_rect` must be a valid pointer.
        /// - `remaining_rect` must be a valid pointer.
        #[unsafe(method(getLineFragmentRect:usedRect:remainingRect:forStartingGlyphAtIndex:proposedRect:lineSpacing:paragraphSpacingBefore:paragraphSpacingAfter:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getLineFragmentRect_usedRect_remainingRect_forStartingGlyphAtIndex_proposedRect_lineSpacing_paragraphSpacingBefore_paragraphSpacingAfter(
            &self,
            line_fragment_rect: NSRectPointer,
            line_fragment_used_rect: NSRectPointer,
            remaining_rect: NSRectPointer,
            starting_glyph_index: NSUInteger,
            proposed_rect: NSRect,
            line_spacing: CGFloat,
            paragraph_spacing_before: CGFloat,
            paragraph_spacing_after: CGFloat,
        );

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(setLineFragmentRect:forGlyphRange:usedRect:baselineOffset:))]
        #[unsafe(method_family = none)]
        pub fn setLineFragmentRect_forGlyphRange_usedRect_baselineOffset(
            &self,
            fragment_rect: NSRect,
            glyph_range: NSRange,
            used_rect: NSRect,
            baseline_offset: CGFloat,
        );

        #[unsafe(method(setNotShownAttribute:forGlyphRange:))]
        #[unsafe(method_family = none)]
        pub fn setNotShownAttribute_forGlyphRange(&self, flag: bool, glyph_range: NSRange);

        #[unsafe(method(setDrawsOutsideLineFragment:forGlyphRange:))]
        #[unsafe(method_family = none)]
        pub fn setDrawsOutsideLineFragment_forGlyphRange(&self, flag: bool, glyph_range: NSRange);

        #[cfg(feature = "objc2-core-foundation")]
        /// # Safety
        ///
        /// `advancements` must be a valid pointer.
        #[unsafe(method(setLocation:withAdvancements:forStartOfGlyphRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setLocation_withAdvancements_forStartOfGlyphRange(
            &self,
            location: NSPoint,
            advancements: *const CGFloat,
            glyph_range: NSRange,
        );

        #[unsafe(method(setAttachmentSize:forGlyphRange:))]
        #[unsafe(method_family = none)]
        pub fn setAttachmentSize_forGlyphRange(
            &self,
            attachment_size: NSSize,
            glyph_range: NSRange,
        );

        /// # Safety
        ///
        /// `levels` must be a valid pointer.
        #[unsafe(method(setBidiLevels:forGlyphRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBidiLevels_forGlyphRange(&self, levels: *const u8, glyph_range: NSRange);
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstypesettercontrolcharacteraction?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTypesetterControlCharacterAction(pub NSUInteger);
bitflags::bitflags! {
    impl NSTypesetterControlCharacterAction: NSUInteger {
        #[doc(alias = "NSTypesetterZeroAdvancementAction")]
        const ZeroAdvancementAction = 1<<0;
        #[doc(alias = "NSTypesetterWhitespaceAction")]
        const WhitespaceAction = 1<<1;
        #[doc(alias = "NSTypesetterHorizontalTabAction")]
        const HorizontalTabAction = 1<<2;
        #[doc(alias = "NSTypesetterLineBreakAction")]
        const LineBreakAction = 1<<3;
        #[doc(alias = "NSTypesetterParagraphBreakAction")]
        const ParagraphBreakAction = 1<<4;
        #[doc(alias = "NSTypesetterContainerBreakAction")]
        const ContainerBreakAction = 1<<5;
    }
}

unsafe impl Encode for NSTypesetterControlCharacterAction {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSTypesetterControlCharacterAction {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// NSTypesetter_Deprecated.
impl NSTypesetter {
    extern_methods!(
        #[unsafe(method(actionForControlCharacterAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn actionForControlCharacterAtIndex(
            &self,
            char_index: NSUInteger,
        ) -> NSTypesetterControlCharacterAction;

        #[cfg(all(feature = "NSFont", feature = "NSLayoutManager"))]
        /// # Safety
        ///
        /// - `glyph_buffer` must be a valid pointer.
        /// - `char_index_buffer` must be a valid pointer.
        /// - `inscribe_buffer` must be a valid pointer.
        /// - `elastic_buffer` must be a valid pointer.
        /// - `bidi_level_buffer` must be a valid pointer.
        #[deprecated]
        #[unsafe(method(getGlyphsInRange:glyphs:characterIndexes:glyphInscriptions:elasticBits:bidiLevels:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getGlyphsInRange_glyphs_characterIndexes_glyphInscriptions_elasticBits_bidiLevels(
            &self,
            glyphs_range: NSRange,
            glyph_buffer: *mut NSGlyph,
            char_index_buffer: *mut NSUInteger,
            inscribe_buffer: *mut NSGlyphInscription,
            elastic_buffer: *mut Bool,
            bidi_level_buffer: *mut c_uchar,
        ) -> NSUInteger;

        #[cfg(feature = "NSFont")]
        /// # Safety
        ///
        /// `glyphs` must be a valid pointer.
        #[deprecated]
        #[unsafe(method(substituteGlyphsInRange:withGlyphs:))]
        #[unsafe(method_family = none)]
        pub unsafe fn substituteGlyphsInRange_withGlyphs(
            &self,
            glyph_range: NSRange,
            glyphs: *mut NSGlyph,
        );

        #[cfg(feature = "NSFont")]
        #[deprecated]
        #[unsafe(method(insertGlyph:atGlyphIndex:characterIndex:))]
        #[unsafe(method_family = none)]
        pub fn insertGlyph_atGlyphIndex_characterIndex(
            &self,
            glyph: NSGlyph,
            glyph_index: NSUInteger,
            character_index: NSUInteger,
        );

        #[deprecated]
        #[unsafe(method(deleteGlyphsInRange:))]
        #[unsafe(method_family = none)]
        pub fn deleteGlyphsInRange(&self, glyph_range: NSRange);
    );
}
