use crate::string::UTF16Const;
use crate::winapi_local::um::winioctl::CTL_CODE;
use winapi::shared::basetsd::ULONG_PTR;
use winapi::shared::guiddef::GUID;
use winapi::shared::minwindef::DWORD;
use winapi::shared::ntdef::{
    BOOLEAN, CCHAR, CHAR, HANDLE, LARGE_INTEGER, LONG, LONGLONG, NTSTATUS, PBOOLEAN, PHANDLE,
    PLARGE_INTEGER, POBJECT_ATTRIBUTES, PUCHAR, PULONG, PUNICODE_STRING, PVOID, UCHAR, ULONG,
    ULONGLONG, USHORT, WCHAR,
};
use winapi::um::winioctl::{
    FILE_ANY_ACCESS, FILE_DEVICE_MAILSLOT, FILE_DEVICE_NAMED_PIPE, METHOD_BUFFERED, METHOD_NEITHER,
};
use winapi::um::winnt::{
    ACCESS_MASK, FILE_ID_128, FILE_READ_DATA, FILE_WRITE_DATA, PFILE_SEGMENT_ELEMENT, PSID, SID,
};
pub const FILE_SUPERSEDE: ULONG = 0x00000000;
pub const FILE_OPEN: ULONG = 0x00000001;
pub const FILE_CREATE: ULONG = 0x00000002;
pub const FILE_OPEN_IF: ULONG = 0x00000003;
pub const FILE_OVERWRITE: ULONG = 0x00000004;
pub const FILE_OVERWRITE_IF: ULONG = 0x00000005;
pub const FILE_MAXIMUM_DISPOSITION: ULONG = 0x00000005;
pub const FILE_DIRECTORY_FILE: ULONG = 0x00000001;
pub const FILE_WRITE_THROUGH: ULONG = 0x00000002;
pub const FILE_SEQUENTIAL_ONLY: ULONG = 0x00000004;
pub const FILE_NO_INTERMEDIATE_BUFFERING: ULONG = 0x00000008;
pub const FILE_SYNCHRONOUS_IO_ALERT: ULONG = 0x00000010;
pub const FILE_SYNCHRONOUS_IO_NONALERT: ULONG = 0x00000020;
pub const FILE_NON_DIRECTORY_FILE: ULONG = 0x00000040;
pub const FILE_CREATE_TREE_CONNECTION: ULONG = 0x00000080;
pub const FILE_COMPLETE_IF_OPLOCKED: ULONG = 0x00000100;
pub const FILE_NO_EA_KNOWLEDGE: ULONG = 0x00000200;
pub const FILE_OPEN_FOR_RECOVERY: ULONG = 0x00000400;
pub const FILE_RANDOM_ACCESS: ULONG = 0x00000800;
pub const FILE_DELETE_ON_CLOSE: ULONG = 0x00001000;
pub const FILE_OPEN_BY_FILE_ID: ULONG = 0x00002000;
pub const FILE_OPEN_FOR_BACKUP_INTENT: ULONG = 0x00004000;
pub const FILE_NO_COMPRESSION: ULONG = 0x00008000;
pub const FILE_OPEN_REQUIRING_OPLOCK: ULONG = 0x00010000;
pub const FILE_DISALLOW_EXCLUSIVE: ULONG = 0x00020000;
pub const FILE_SESSION_AWARE: ULONG = 0x00040000;
pub const FILE_RESERVE_OPFILTER: ULONG = 0x00100000;
pub const FILE_OPEN_REPARSE_POINT: ULONG = 0x00200000;
pub const FILE_OPEN_NO_RECALL: ULONG = 0x00400000;
pub const FILE_OPEN_FOR_FREE_SPACE_QUERY: ULONG = 0x00800000;
pub const FILE_COPY_STRUCTURED_STORAGE: ULONG = 0x00000041;
pub const FILE_STRUCTURED_STORAGE: ULONG = 0x00000441;
pub const FILE_SUPERSEDED: ULONG = 0x00000000;
pub const FILE_OPENED: ULONG = 0x00000001;
pub const FILE_CREATED: ULONG = 0x00000002;
pub const FILE_OVERWRITTEN: ULONG = 0x00000003;
pub const FILE_EXISTS: ULONG = 0x00000004;
pub const FILE_DOES_NOT_EXIST: ULONG = 0x00000005;
pub const FILE_WRITE_TO_END_OF_FILE: ULONG = 0xffffffff;
pub const FILE_USE_FILE_POINTER_POSITION: ULONG = 0xfffffffe;
pub const FILE_BYTE_ALIGNMENT: ULONG = 0x00000000;
pub const FILE_WORD_ALIGNMENT: ULONG = 0x00000001;
pub const FILE_LONG_ALIGNMENT: ULONG = 0x00000003;
pub const FILE_QUAD_ALIGNMENT: ULONG = 0x00000007;
pub const FILE_OCTA_ALIGNMENT: ULONG = 0x0000000f;
pub const FILE_32_BYTE_ALIGNMENT: ULONG = 0x0000001f;
pub const FILE_64_BYTE_ALIGNMENT: ULONG = 0x0000003f;
pub const FILE_128_BYTE_ALIGNMENT: ULONG = 0x0000007f;
pub const FILE_256_BYTE_ALIGNMENT: ULONG = 0x000000ff;
pub const FILE_512_BYTE_ALIGNMENT: ULONG = 0x000001ff;
pub const MAXIMUM_FILENAME_LENGTH: u32 = 256;
pub const FILE_NEED_EA: ULONG = 0x00000080;
pub const FILE_EA_TYPE_BINARY: ULONG = 0xfffe;
pub const FILE_EA_TYPE_ASCII: ULONG = 0xfffd;
pub const FILE_EA_TYPE_BITMAP: ULONG = 0xfffb;
pub const FILE_EA_TYPE_METAFILE: ULONG = 0xfffa;
pub const FILE_EA_TYPE_ICON: ULONG = 0xfff9;
pub const FILE_EA_TYPE_EA: ULONG = 0xffee;
pub const FILE_EA_TYPE_MVMT: ULONG = 0xffdf;
pub const FILE_EA_TYPE_MVST: ULONG = 0xffde;
pub const FILE_EA_TYPE_ASN1: ULONG = 0xffdd;
pub const FILE_EA_TYPE_FAMILY_IDS: ULONG = 0xff01;
pub const FILE_REMOVABLE_MEDIA: ULONG = 0x00000001;
pub const FILE_READ_ONLY_DEVICE: ULONG = 0x00000002;
pub const FILE_FLOPPY_DISKETTE: ULONG = 0x00000004;
pub const FILE_WRITE_ONCE_MEDIA: ULONG = 0x00000008;
pub const FILE_REMOTE_DEVICE: ULONG = 0x00000010;
pub const FILE_DEVICE_IS_MOUNTED: ULONG = 0x00000020;
pub const FILE_VIRTUAL_VOLUME: ULONG = 0x00000040;
pub const FILE_AUTOGENERATED_DEVICE_NAME: ULONG = 0x00000080;
pub const FILE_DEVICE_SECURE_OPEN: ULONG = 0x00000100;
pub const FILE_CHARACTERISTIC_PNP_DEVICE: ULONG = 0x00000800;
pub const FILE_CHARACTERISTIC_TS_DEVICE: ULONG = 0x00001000;
pub const FILE_CHARACTERISTIC_WEBDAV_DEVICE: ULONG = 0x00002000;
pub const FILE_CHARACTERISTIC_CSV: ULONG = 0x00010000;
pub const FILE_DEVICE_ALLOW_APPCONTAINER_TRAVERSAL: ULONG = 0x00020000;
pub const FILE_PORTABLE_DEVICE: ULONG = 0x00040000;
pub const FILE_PIPE_BYTE_STREAM_TYPE: ULONG = 0x00000000;
pub const FILE_PIPE_MESSAGE_TYPE: ULONG = 0x00000001;
pub const FILE_PIPE_ACCEPT_REMOTE_CLIENTS: ULONG = 0x00000000;
pub const FILE_PIPE_REJECT_REMOTE_CLIENTS: ULONG = 0x00000002;
pub const FILE_PIPE_TYPE_VALID_MASK: ULONG = 0x00000003;
pub const FILE_PIPE_QUEUE_OPERATION: ULONG = 0x00000000;
pub const FILE_PIPE_COMPLETE_OPERATION: ULONG = 0x00000001;
pub const FILE_PIPE_BYTE_STREAM_MODE: ULONG = 0x00000000;
pub const FILE_PIPE_MESSAGE_MODE: ULONG = 0x00000001;
pub const FILE_PIPE_INBOUND: ULONG = 0x00000000;
pub const FILE_PIPE_OUTBOUND: ULONG = 0x00000001;
pub const FILE_PIPE_FULL_DUPLEX: ULONG = 0x00000002;
pub const FILE_PIPE_DISCONNECTED_STATE: ULONG = 0x00000001;
pub const FILE_PIPE_LISTENING_STATE: ULONG = 0x00000002;
pub const FILE_PIPE_CONNECTED_STATE: ULONG = 0x00000003;
pub const FILE_PIPE_CLOSING_STATE: ULONG = 0x00000004;
pub const FILE_PIPE_CLIENT_END: ULONG = 0x00000000;
pub const FILE_PIPE_SERVER_END: ULONG = 0x00000001;
pub const MAILSLOT_SIZE_AUTO: u32 = 0;
UNION!{union IO_STATUS_BLOCK_u {
    Status: NTSTATUS,
    Pointer: PVOID,
}}
STRUCT!{struct IO_STATUS_BLOCK {
    u: IO_STATUS_BLOCK_u,
    Information: ULONG_PTR,
}}
pub type PIO_STATUS_BLOCK = *mut IO_STATUS_BLOCK;
FN!{stdcall PIO_APC_ROUTINE(
    ApcContext: PVOID,
    IoStatusBlock: PIO_STATUS_BLOCK,
    Reserved: ULONG,
) -> ()}
STRUCT!{struct FILE_IO_COMPLETION_INFORMATION {
    KeyContext: PVOID,
    ApcContext: PVOID,
    IoStatusBlock: IO_STATUS_BLOCK,
}}
pub type PFILE_IO_COMPLETION_INFORMATION = *mut FILE_IO_COMPLETION_INFORMATION;
ENUM!{enum FILE_INFORMATION_CLASS {
    FileDirectoryInformation = 1,
    FileFullDirectoryInformation = 2,
    FileBothDirectoryInformation = 3,
    FileBasicInformation = 4,
    FileStandardInformation = 5,
    FileInternalInformation = 6,
    FileEaInformation = 7,
    FileAccessInformation = 8,
    FileNameInformation = 9,
    FileRenameInformation = 10,
    FileLinkInformation = 11,
    FileNamesInformation = 12,
    FileDispositionInformation = 13,
    FilePositionInformation = 14,
    FileFullEaInformation = 15,
    FileModeInformation = 16,
    FileAlignmentInformation = 17,
    FileAllInformation = 18,
    FileAllocationInformation = 19,
    FileEndOfFileInformation = 20,
    FileAlternateNameInformation = 21,
    FileStreamInformation = 22,
    FilePipeInformation = 23,
    FilePipeLocalInformation = 24,
    FilePipeRemoteInformation = 25,
    FileMailslotQueryInformation = 26,
    FileMailslotSetInformation = 27,
    FileCompressionInformation = 28,
    FileObjectIdInformation = 29,
    FileCompletionInformation = 30,
    FileMoveClusterInformation = 31,
    FileQuotaInformation = 32,
    FileReparsePointInformation = 33,
    FileNetworkOpenInformation = 34,
    FileAttributeTagInformation = 35,
    FileTrackingInformation = 36,
    FileIdBothDirectoryInformation = 37,
    FileIdFullDirectoryInformation = 38,
    FileValidDataLengthInformation = 39,
    FileShortNameInformation = 40,
    FileIoCompletionNotificationInformation = 41,
    FileIoStatusBlockRangeInformation = 42,
    FileIoPriorityHintInformation = 43,
    FileSfioReserveInformation = 44,
    FileSfioVolumeInformation = 45,
    FileHardLinkInformation = 46,
    FileProcessIdsUsingFileInformation = 47,
    FileNormalizedNameInformation = 48,
    FileNetworkPhysicalNameInformation = 49,
    FileIdGlobalTxDirectoryInformation = 50,
    FileIsRemoteDeviceInformation = 51,
    FileUnusedInformation = 52,
    FileNumaNodeInformation = 53,
    FileStandardLinkInformation = 54,
    FileRemoteProtocolInformation = 55,
    FileRenameInformationBypassAccessCheck = 56,
    FileLinkInformationBypassAccessCheck = 57,
    FileVolumeNameInformation = 58,
    FileIdInformation = 59,
    FileIdExtdDirectoryInformation = 60,
    FileReplaceCompletionInformation = 61,
    FileHardLinkFullIdInformation = 62,
    FileIdExtdBothDirectoryInformation = 63,
    FileDispositionInformationEx = 64,
    FileRenameInformationEx = 65,
    FileRenameInformationExBypassAccessCheck = 66,
    FileDesiredStorageClassInformation = 67,
    FileStatInformation = 68,
    FileMemoryPartitionInformation = 69,
    FileStatLxInformation = 70,
    FileCaseSensitiveInformation = 71,
    FileLinkInformationEx = 72,
    FileLinkInformationExBypassAccessCheck = 73,
    FileStorageReserveIdInformation = 74,
    FileCaseSensitiveInformationForceAccessCheck = 75,
    FileMaximumInformation = 76,
}}
pub type PFILE_INFORMATION_CLASS = *mut FILE_INFORMATION_CLASS;
STRUCT!{struct FILE_BASIC_INFORMATION {
    CreationTime: LARGE_INTEGER,
    LastAccessTime: LARGE_INTEGER,
    LastWriteTime: LARGE_INTEGER,
    ChangeTime: LARGE_INTEGER,
    FileAttributes: ULONG,
}}
pub type PFILE_BASIC_INFORMATION = *mut FILE_BASIC_INFORMATION;
STRUCT!{struct FILE_STANDARD_INFORMATION {
    AllocationSize: LARGE_INTEGER,
    EndOfFile: LARGE_INTEGER,
    NumberOfLinks: ULONG,
    DeletePending: BOOLEAN,
    Directory: BOOLEAN,
}}
pub type PFILE_STANDARD_INFORMATION = *mut FILE_STANDARD_INFORMATION;
STRUCT!{struct FILE_STANDARD_INFORMATION_EX {
    AllocationSize: LARGE_INTEGER,
    EndOfFile: LARGE_INTEGER,
    NumberOfLinks: ULONG,
    DeletePending: BOOLEAN,
    Directory: BOOLEAN,
    AlternateStream: BOOLEAN,
    MetadataAttribute: BOOLEAN,
}}
pub type PFILE_STANDARD_INFORMATION_EX = *mut FILE_STANDARD_INFORMATION_EX;
STRUCT!{struct FILE_INTERNAL_INFORMATION {
    IndexNumber: LARGE_INTEGER,
}}
pub type PFILE_INTERNAL_INFORMATION = *mut FILE_INTERNAL_INFORMATION;
STRUCT!{struct FILE_EA_INFORMATION {
    EaSize: ULONG,
}}
pub type PFILE_EA_INFORMATION = *mut FILE_EA_INFORMATION;
STRUCT!{struct FILE_ACCESS_INFORMATION {
    AccessFlags: ACCESS_MASK,
}}
pub type PFILE_ACCESS_INFORMATION = *mut FILE_ACCESS_INFORMATION;
STRUCT!{struct FILE_POSITION_INFORMATION {
    CurrentByteOffset: LARGE_INTEGER,
}}
pub type PFILE_POSITION_INFORMATION = *mut FILE_POSITION_INFORMATION;
STRUCT!{struct FILE_MODE_INFORMATION {
    Mode: ULONG,
}}
pub type PFILE_MODE_INFORMATION = *mut FILE_MODE_INFORMATION;
STRUCT!{struct FILE_ALIGNMENT_INFORMATION {
    AlignmentRequirement: ULONG,
}}
pub type PFILE_ALIGNMENT_INFORMATION = *mut FILE_ALIGNMENT_INFORMATION;
STRUCT!{struct FILE_NAME_INFORMATION {
    FileNameLength: ULONG,
    FileName: [WCHAR; 1],
}}
pub type PFILE_NAME_INFORMATION = *mut FILE_NAME_INFORMATION;
STRUCT!{struct FILE_ALL_INFORMATION {
    BasicInformation: FILE_BASIC_INFORMATION,
    StandardInformation: FILE_STANDARD_INFORMATION,
    InternalInformation: FILE_INTERNAL_INFORMATION,
    EaInformation: FILE_EA_INFORMATION,
    AccessInformation: FILE_ACCESS_INFORMATION,
    PositionInformation: FILE_POSITION_INFORMATION,
    ModeInformation: FILE_MODE_INFORMATION,
    AlignmentInformation: FILE_ALIGNMENT_INFORMATION,
    NameInformation: FILE_NAME_INFORMATION,
}}
pub type PFILE_ALL_INFORMATION = *mut FILE_ALL_INFORMATION;
STRUCT!{struct FILE_NETWORK_OPEN_INFORMATION {
    CreationTime: LARGE_INTEGER,
    LastAccessTime: LARGE_INTEGER,
    LastWriteTime: LARGE_INTEGER,
    ChangeTime: LARGE_INTEGER,
    AllocationSize: LARGE_INTEGER,
    EndOfFile: LARGE_INTEGER,
    FileAttributes: ULONG,
}}
pub type PFILE_NETWORK_OPEN_INFORMATION = *mut FILE_NETWORK_OPEN_INFORMATION;
STRUCT!{struct FILE_ATTRIBUTE_TAG_INFORMATION {
    FileAttributes: ULONG,
    ReparseTag: ULONG,
}}
pub type PFILE_ATTRIBUTE_TAG_INFORMATION = *mut FILE_ATTRIBUTE_TAG_INFORMATION;
STRUCT!{struct FILE_ALLOCATION_INFORMATION {
    AllocationSize: LARGE_INTEGER,
}}
pub type PFILE_ALLOCATION_INFORMATION = *mut FILE_ALLOCATION_INFORMATION;
STRUCT!{struct FILE_COMPRESSION_INFORMATION {
    CompressedFileSize: LARGE_INTEGER,
    CompressionFormat: USHORT,
    CompressionUnitShift: UCHAR,
    ChunkShift: UCHAR,
    ClusterShift: UCHAR,
    Reserved: [UCHAR; 3],
}}
pub type PFILE_COMPRESSION_INFORMATION = *mut FILE_COMPRESSION_INFORMATION;
STRUCT!{struct FILE_DISPOSITION_INFORMATION {
    DeleteFileA: BOOLEAN,
}}
pub type PFILE_DISPOSITION_INFORMATION = *mut FILE_DISPOSITION_INFORMATION;
STRUCT!{struct FILE_END_OF_FILE_INFORMATION {
    EndOfFile: LARGE_INTEGER,
}}
pub type PFILE_END_OF_FILE_INFORMATION = *mut FILE_END_OF_FILE_INFORMATION;
STRUCT!{struct FILE_VALID_DATA_LENGTH_INFORMATION {
    ValidDataLength: LARGE_INTEGER,
}}
pub type PFILE_VALID_DATA_LENGTH_INFORMATION = *mut FILE_VALID_DATA_LENGTH_INFORMATION;
STRUCT!{struct FILE_LINK_INFORMATION {
    ReplaceIfExists: BOOLEAN,
    RootDirectory: HANDLE,
    FileNameLength: ULONG,
    FileName: [WCHAR; 1],
}}
pub type PFILE_LINK_INFORMATION = *mut FILE_LINK_INFORMATION;
STRUCT!{struct FILE_MOVE_CLUSTER_INFORMATION {
    ClusterCount: ULONG,
    RootDirectory: HANDLE,
    FileNameLength: ULONG,
    FileName: [WCHAR; 1],
}}
pub type PFILE_MOVE_CLUSTER_INFORMATION = *mut FILE_MOVE_CLUSTER_INFORMATION;
STRUCT!{struct FILE_RENAME_INFORMATION {
    ReplaceIfExists: BOOLEAN,
    RootDirectory: HANDLE,
    FileNameLength: ULONG,
    FileName: [WCHAR; 1],
}}
pub type PFILE_RENAME_INFORMATION = *mut FILE_RENAME_INFORMATION;
STRUCT!{struct FILE_STREAM_INFORMATION {
    NextEntryOffset: ULONG,
    StreamNameLength: ULONG,
    StreamSize: LARGE_INTEGER,
    StreamAllocationSize: LARGE_INTEGER,
    StreamName: [WCHAR; 1],
}}
pub type PFILE_STREAM_INFORMATION = *mut FILE_STREAM_INFORMATION;
STRUCT!{struct FILE_TRACKING_INFORMATION {
    DestinationFile: HANDLE,
    ObjectInformationLength: ULONG,
    ObjectInformation: [CHAR; 1],
}}
pub type PFILE_TRACKING_INFORMATION = *mut FILE_TRACKING_INFORMATION;
STRUCT!{struct FILE_COMPLETION_INFORMATION {
    Port: HANDLE,
    Key: PVOID,
}}
pub type PFILE_COMPLETION_INFORMATION = *mut FILE_COMPLETION_INFORMATION;
STRUCT!{struct FILE_PIPE_INFORMATION {
    ReadMode: ULONG,
    CompletionMode: ULONG,
}}
pub type PFILE_PIPE_INFORMATION = *mut FILE_PIPE_INFORMATION;
STRUCT!{struct FILE_PIPE_LOCAL_INFORMATION {
    NamedPipeType: ULONG,
    NamedPipeConfiguration: ULONG,
    MaximumInstances: ULONG,
    CurrentInstances: ULONG,
    InboundQuota: ULONG,
    ReadDataAvailable: ULONG,
    OutboundQuota: ULONG,
    WriteQuotaAvailable: ULONG,
    NamedPipeState: ULONG,
    NamedPipeEnd: ULONG,
}}
pub type PFILE_PIPE_LOCAL_INFORMATION = *mut FILE_PIPE_LOCAL_INFORMATION;
STRUCT!{struct FILE_PIPE_REMOTE_INFORMATION {
    CollectDataTime: LARGE_INTEGER,
    MaximumCollectionCount: ULONG,
}}
pub type PFILE_PIPE_REMOTE_INFORMATION = *mut FILE_PIPE_REMOTE_INFORMATION;
STRUCT!{struct FILE_MAILSLOT_QUERY_INFORMATION {
    MaximumMessageSize: ULONG,
    MailslotQuota: ULONG,
    NextMessageSize: ULONG,
    MessagesAvailable: ULONG,
    ReadTimeout: LARGE_INTEGER,
}}
pub type PFILE_MAILSLOT_QUERY_INFORMATION = *mut FILE_MAILSLOT_QUERY_INFORMATION;
STRUCT!{struct FILE_MAILSLOT_SET_INFORMATION {
    ReadTimeout: PLARGE_INTEGER,
}}
pub type PFILE_MAILSLOT_SET_INFORMATION = *mut FILE_MAILSLOT_SET_INFORMATION;
STRUCT!{struct FILE_REPARSE_POINT_INFORMATION {
    FileReference: LONGLONG,
    Tag: ULONG,
}}
pub type PFILE_REPARSE_POINT_INFORMATION = *mut FILE_REPARSE_POINT_INFORMATION;
STRUCT!{struct FILE_LINK_ENTRY_INFORMATION {
    NextEntryOffset: ULONG,
    ParentFileId: LONGLONG,
    FileNameLength: ULONG,
    FileName: [WCHAR; 1],
}}
pub type PFILE_LINK_ENTRY_INFORMATION = *mut FILE_LINK_ENTRY_INFORMATION;
STRUCT!{struct FILE_LINKS_INFORMATION {
    BytesNeeded: ULONG,
    EntriesReturned: ULONG,
    Entry: FILE_LINK_ENTRY_INFORMATION,
}}
pub type PFILE_LINKS_INFORMATION = *mut FILE_LINKS_INFORMATION;
STRUCT!{struct FILE_NETWORK_PHYSICAL_NAME_INFORMATION {
    FileNameLength: ULONG,
    FileName: [WCHAR; 1],
}}
pub type PFILE_NETWORK_PHYSICAL_NAME_INFORMATION = *mut FILE_NETWORK_PHYSICAL_NAME_INFORMATION;
STRUCT!{struct FILE_STANDARD_LINK_INFORMATION {
    NumberOfAccessibleLinks: ULONG,
    TotalNumberOfLinks: ULONG,
    DeletePending: BOOLEAN,
    Directory: BOOLEAN,
}}
pub type PFILE_STANDARD_LINK_INFORMATION = *mut FILE_STANDARD_LINK_INFORMATION;
STRUCT!{struct FILE_SFIO_RESERVE_INFORMATION {
    RequestsPerPeriod: ULONG,
    Period: ULONG,
    RetryFailures: BOOLEAN,
    Discardable: BOOLEAN,
    RequestSize: ULONG,
    NumOutstandingRequests: ULONG,
}}
pub type PFILE_SFIO_RESERVE_INFORMATION = *mut FILE_SFIO_RESERVE_INFORMATION;
STRUCT!{struct FILE_SFIO_VOLUME_INFORMATION {
    MaximumRequestsPerPeriod: ULONG,
    MinimumPeriod: ULONG,
    MinimumTransferSize: ULONG,
}}
pub type PFILE_SFIO_VOLUME_INFORMATION = *mut FILE_SFIO_VOLUME_INFORMATION;
ENUM!{enum IO_PRIORITY_HINT {
    IoPriorityVeryLow = 0,
    IoPriorityLow = 1,
    IoPriorityNormal = 2,
    IoPriorityHigh = 3,
    IoPriorityCritical = 4,
    MaxIoPriorityTypes = 5,
}}
STRUCT!{struct FILE_IO_PRIORITY_HINT_INFORMATION {
    PriorityHint: IO_PRIORITY_HINT,
}}
pub type PFILE_IO_PRIORITY_HINT_INFORMATION = *mut FILE_IO_PRIORITY_HINT_INFORMATION;
STRUCT!{struct FILE_IO_PRIORITY_HINT_INFORMATION_EX {
    PriorityHint: IO_PRIORITY_HINT,
    BoostOutstanding: BOOLEAN,
}}
pub type PFILE_IO_PRIORITY_HINT_INFORMATION_EX = *mut FILE_IO_PRIORITY_HINT_INFORMATION_EX;
pub const FILE_SKIP_COMPLETION_PORT_ON_SUCCESS: u32 = 0x1;
pub const FILE_SKIP_SET_EVENT_ON_HANDLE: u32 = 0x2;
pub const FILE_SKIP_SET_USER_EVENT_ON_FAST_IO: u32 = 0x4;
STRUCT!{struct FILE_IO_COMPLETION_NOTIFICATION_INFORMATION {
    Flags: ULONG,
}}
pub type PFILE_IO_COMPLETION_NOTIFICATION_INFORMATION =
    *mut FILE_IO_COMPLETION_NOTIFICATION_INFORMATION;
STRUCT!{struct FILE_PROCESS_IDS_USING_FILE_INFORMATION {
    NumberOfProcessIdsInList: ULONG,
    ProcessIdList: [ULONG_PTR; 1],
}}
pub type PFILE_PROCESS_IDS_USING_FILE_INFORMATION = *mut FILE_PROCESS_IDS_USING_FILE_INFORMATION;
STRUCT!{struct FILE_IS_REMOTE_DEVICE_INFORMATION {
    IsRemote: BOOLEAN,
}}
pub type PFILE_IS_REMOTE_DEVICE_INFORMATION = *mut FILE_IS_REMOTE_DEVICE_INFORMATION;
STRUCT!{struct FILE_NUMA_NODE_INFORMATION {
    NodeNumber: USHORT,
}}
pub type PFILE_NUMA_NODE_INFORMATION = *mut FILE_NUMA_NODE_INFORMATION;
STRUCT!{struct FILE_IOSTATUSBLOCK_RANGE_INFORMATION {
    IoStatusBlockRange: PUCHAR,
    Length: ULONG,
}}
pub type PFILE_IOSTATUSBLOCK_RANGE_INFORMATION = *mut FILE_IOSTATUSBLOCK_RANGE_INFORMATION;
STRUCT!{struct FILE_REMOTE_PROTOCOL_INFORMATION_GenericReserved {
    Reserved: [ULONG; 8],
}}
STRUCT!{struct FILE_REMOTE_PROTOCOL_INFORMATION_ProtocolSpecific_Smb2_Server {
    Capabilities: ULONG,
}}
STRUCT!{struct FILE_REMOTE_PROTOCOL_INFORMATION_ProtocolSpecific_Smb2_Share {
    Capabilities: ULONG,
    CachingFlags: ULONG,
}}
STRUCT!{struct FILE_REMOTE_PROTOCOL_INFORMATION_ProtocolSpecific_Smb2 {
    Server: FILE_REMOTE_PROTOCOL_INFORMATION_ProtocolSpecific_Smb2_Server,
    Share: FILE_REMOTE_PROTOCOL_INFORMATION_ProtocolSpecific_Smb2_Share,
}}
UNION!{union FILE_REMOTE_PROTOCOL_INFORMATION_ProtocolSpecific {
    Smb2: FILE_REMOTE_PROTOCOL_INFORMATION_ProtocolSpecific_Smb2,
    Reserved: [ULONG; 16],
}}
STRUCT!{struct FILE_REMOTE_PROTOCOL_INFORMATION {
    StructureVersion: USHORT,
    StructureSize: USHORT,
    Protocol: ULONG,
    ProtocolMajorVersion: USHORT,
    ProtocolMinorVersion: USHORT,
    ProtocolRevision: USHORT,
    Reserved: USHORT,
    Flags: ULONG,
    GenericReserved: FILE_REMOTE_PROTOCOL_INFORMATION_GenericReserved,
    ProtocolSpecific: FILE_REMOTE_PROTOCOL_INFORMATION_ProtocolSpecific,
}}
pub type PFILE_REMOTE_PROTOCOL_INFORMATION = *mut FILE_REMOTE_PROTOCOL_INFORMATION;
pub const CHECKSUM_ENFORCEMENT_OFF: u32 = 0x00000001;
STRUCT!{struct FILE_INTEGRITY_STREAM_INFORMATION {
    ChecksumAlgorithm: USHORT,
    ChecksumChunkShift: UCHAR,
    ClusterShift: UCHAR,
    Flags: ULONG,
}}
pub type PFILE_INTEGRITY_STREAM_INFORMATION = *mut FILE_INTEGRITY_STREAM_INFORMATION;
STRUCT!{struct FILE_VOLUME_NAME_INFORMATION {
    DeviceNameLength: ULONG,
    DeviceName: [WCHAR; 1],
}}
pub type PFILE_VOLUME_NAME_INFORMATION = *mut FILE_VOLUME_NAME_INFORMATION;
STRUCT!{struct FILE_ID_INFORMATION {
    VolumeSerialNumber: ULONGLONG,
    FileId: FILE_ID_128,
}}
pub type PFILE_ID_INFORMATION = *mut FILE_ID_INFORMATION;
STRUCT!{struct FILE_ID_EXTD_DIR_INFORMATION {
    NextEntryOffset: ULONG,
    FileIndex: ULONG,
    CreationTime: LARGE_INTEGER,
    LastAccessTime: LARGE_INTEGER,
    LastWriteTime: LARGE_INTEGER,
    ChangeTime: LARGE_INTEGER,
    EndOfFile: LARGE_INTEGER,
    AllocationSize: LARGE_INTEGER,
    FileAttributes: ULONG,
    FileNameLength: ULONG,
    EaSize: ULONG,
    ReparsePointTag: ULONG,
    FileId: FILE_ID_128,
    FileName: [WCHAR; 1],
}}
pub type PFILE_ID_EXTD_DIR_INFORMATION = *mut FILE_ID_EXTD_DIR_INFORMATION;
STRUCT!{struct FILE_LINK_ENTRY_FULL_ID_INFORMATION {
    NextEntryOffset: ULONG,
    ParentFileId: FILE_ID_128,
    FileNameLength: ULONG,
    FileName: [WCHAR; 1],
}}
pub type PFILE_LINK_ENTRY_FULL_ID_INFORMATION = *mut FILE_LINK_ENTRY_FULL_ID_INFORMATION;
STRUCT!{struct FILE_ID_EXTD_BOTH_DIR_INFORMATION {
    NextEntryOffset: ULONG,
    FileIndex: ULONG,
    CreationTime: LARGE_INTEGER,
    LastAccessTime: LARGE_INTEGER,
    LastWriteTime: LARGE_INTEGER,
    ChangeTime: LARGE_INTEGER,
    EndOfFile: LARGE_INTEGER,
    AllocationSize: LARGE_INTEGER,
    FileAttributes: ULONG,
    FileNameLength: ULONG,
    EaSize: ULONG,
    ReparsePointTag: ULONG,
    FileId: FILE_ID_128,
    ShortNameLength: CCHAR,
    ShortName: [WCHAR; 12],
    FileName: [WCHAR; 1],
}}
pub type PFILE_ID_EXTD_BOTH_DIR_INFORMATION = *mut FILE_ID_EXTD_BOTH_DIR_INFORMATION;
STRUCT!{struct FILE_STAT_INFORMATION {
    FileId: LARGE_INTEGER,
    CreationTime: LARGE_INTEGER,
    LastAccessTime: LARGE_INTEGER,
    LastWriteTime: LARGE_INTEGER,
    ChangeTime: LARGE_INTEGER,
    AllocationSize: LARGE_INTEGER,
    EndOfFile: LARGE_INTEGER,
    FileAttributes: ULONG,
    ReparseTag: ULONG,
    NumberOfLinks: ULONG,
    EffectiveAccess: ULONG,
}}
pub type PFILE_STAT_INFORMATION = *mut FILE_STAT_INFORMATION;
STRUCT!{struct FILE_MEMORY_PARTITION_INFORMATION_Flags_s {
    NoCrossPartitionAccess: UCHAR,
    Spare: [UCHAR; 3],
}}
UNION!{union FILE_MEMORY_PARTITION_INFORMATION_Flags {
    s: FILE_MEMORY_PARTITION_INFORMATION_Flags_s,
    AllFlags: ULONG,
}}
STRUCT!{struct FILE_MEMORY_PARTITION_INFORMATION {
    OwnerPartitionHandle: HANDLE,
    Flags: FILE_MEMORY_PARTITION_INFORMATION_Flags,
}}
pub type PFILE_MEMORY_PARTITION_INFORMATION = *mut FILE_MEMORY_PARTITION_INFORMATION;
STRUCT!{struct FILE_STAT_LX_INFORMATION {
    FileId: LARGE_INTEGER,
    CreationTime: LARGE_INTEGER,
    LastAccessTime: LARGE_INTEGER,
    LastWriteTime: LARGE_INTEGER,
    ChangeTime: LARGE_INTEGER,
    AllocationSize: LARGE_INTEGER,
    EndOfFile: LARGE_INTEGER,
    FileAttributes: ULONG,
    ReparseTag: ULONG,
    NumberOfLinks: ULONG,
    EffectiveAccess: ULONG,
    LxFlags: ULONG,
    LxUid: ULONG,
    LxGid: ULONG,
    LxMode: ULONG,
    LxDeviceIdMajor: ULONG,
    LxDeviceIdMinor: ULONG,
}}
pub type PFILE_STAT_LX_INFORMATION = *mut FILE_STAT_LX_INFORMATION;
STRUCT!{struct FILE_CASE_SENSITIVE_INFORMATION {
    Flags: ULONG,
}}
pub type PFILE_CASE_SENSITIVE_INFORMATION = *mut FILE_CASE_SENSITIVE_INFORMATION;
STRUCT!{struct FILE_DIRECTORY_INFORMATION {
    NextEntryOffset: ULONG,
    FileIndex: ULONG,
    CreationTime: LARGE_INTEGER,
    LastAccessTime: LARGE_INTEGER,
    LastWriteTime: LARGE_INTEGER,
    ChangeTime: LARGE_INTEGER,
    EndOfFile: LARGE_INTEGER,
    AllocationSize: LARGE_INTEGER,
    FileAttributes: ULONG,
    FileNameLength: ULONG,
    FileName: [WCHAR; 1],
}}
pub type PFILE_DIRECTORY_INFORMATION = *mut FILE_DIRECTORY_INFORMATION;
STRUCT!{struct FILE_FULL_DIR_INFORMATION {
    NextEntryOffset: ULONG,
    FileIndex: ULONG,
    CreationTime: LARGE_INTEGER,
    LastAccessTime: LARGE_INTEGER,
    LastWriteTime: LARGE_INTEGER,
    ChangeTime: LARGE_INTEGER,
    EndOfFile: LARGE_INTEGER,
    AllocationSize: LARGE_INTEGER,
    FileAttributes: ULONG,
    FileNameLength: ULONG,
    EaSize: ULONG,
    FileName: [WCHAR; 1],
}}
pub type PFILE_FULL_DIR_INFORMATION = *mut FILE_FULL_DIR_INFORMATION;
STRUCT!{struct FILE_ID_FULL_DIR_INFORMATION {
    NextEntryOffset: ULONG,
    FileIndex: ULONG,
    CreationTime: LARGE_INTEGER,
    LastAccessTime: LARGE_INTEGER,
    LastWriteTime: LARGE_INTEGER,
    ChangeTime: LARGE_INTEGER,
    EndOfFile: LARGE_INTEGER,
    AllocationSize: LARGE_INTEGER,
    FileAttributes: ULONG,
    FileNameLength: ULONG,
    EaSize: ULONG,
    FileId: LARGE_INTEGER,
    FileName: [WCHAR; 1],
}}
pub type PFILE_ID_FULL_DIR_INFORMATION = *mut FILE_ID_FULL_DIR_INFORMATION;
STRUCT!{struct FILE_BOTH_DIR_INFORMATION {
    NextEntryOffset: ULONG,
    FileIndex: ULONG,
    CreationTime: LARGE_INTEGER,
    LastAccessTime: LARGE_INTEGER,
    LastWriteTime: LARGE_INTEGER,
    ChangeTime: LARGE_INTEGER,
    EndOfFile: LARGE_INTEGER,
    AllocationSize: LARGE_INTEGER,
    FileAttributes: ULONG,
    FileNameLength: ULONG,
    EaSize: ULONG,
    ShortNameLength: CCHAR,
    ShortName: [WCHAR; 12],
    FileName: [WCHAR; 1],
}}
pub type PFILE_BOTH_DIR_INFORMATION = *mut FILE_BOTH_DIR_INFORMATION;
STRUCT!{struct FILE_ID_BOTH_DIR_INFORMATION {
    NextEntryOffset: ULONG,
    FileIndex: ULONG,
    CreationTime: LARGE_INTEGER,
    LastAccessTime: LARGE_INTEGER,
    LastWriteTime: LARGE_INTEGER,
    ChangeTime: LARGE_INTEGER,
    EndOfFile: LARGE_INTEGER,
    AllocationSize: LARGE_INTEGER,
    FileAttributes: ULONG,
    FileNameLength: ULONG,
    EaSize: ULONG,
    ShortNameLength: CCHAR,
    ShortName: [WCHAR; 12],
    FileId: LARGE_INTEGER,
    FileName: [WCHAR; 1],
}}
pub type PFILE_ID_BOTH_DIR_INFORMATION = *mut FILE_ID_BOTH_DIR_INFORMATION;
STRUCT!{struct FILE_NAMES_INFORMATION {
    NextEntryOffset: ULONG,
    FileIndex: ULONG,
    FileNameLength: ULONG,
    FileName: [WCHAR; 1],
}}
pub type PFILE_NAMES_INFORMATION = *mut FILE_NAMES_INFORMATION;
STRUCT!{struct FILE_ID_GLOBAL_TX_DIR_INFORMATION {
    NextEntryOffset: ULONG,
    FileIndex: ULONG,
    CreationTime: LARGE_INTEGER,
    LastAccessTime: LARGE_INTEGER,
    LastWriteTime: LARGE_INTEGER,
    ChangeTime: LARGE_INTEGER,
    EndOfFile: LARGE_INTEGER,
    AllocationSize: LARGE_INTEGER,
    FileAttributes: ULONG,
    FileNameLength: ULONG,
    FileId: LARGE_INTEGER,
    LockingTransactionId: GUID,
    TxInfoFlags: ULONG,
    FileName: [WCHAR; 1],
}}
pub type PFILE_ID_GLOBAL_TX_DIR_INFORMATION = *mut FILE_ID_GLOBAL_TX_DIR_INFORMATION;
pub const FILE_ID_GLOBAL_TX_DIR_INFO_FLAG_WRITELOCKED: u32 = 0x00000001;
pub const FILE_ID_GLOBAL_TX_DIR_INFO_FLAG_VISIBLE_TO_TX: u32 = 0x00000002;
pub const FILE_ID_GLOBAL_TX_DIR_INFO_FLAG_VISIBLE_OUTSIDE_TX: u32 = 0x00000004;
STRUCT!{struct FILE_OBJECTID_INFORMATION_u_s {
    BirthVolumeId: [UCHAR; 16],
    BirthObjectId: [UCHAR; 16],
    DomainId: [UCHAR; 16],
}}
UNION!{union FILE_OBJECTID_INFORMATION_u {
    s: FILE_OBJECTID_INFORMATION_u_s,
    ExtendedInfo: [UCHAR; 48],
}}
STRUCT!{struct FILE_OBJECTID_INFORMATION {
    FileReference: LONGLONG,
    ObjectId: [UCHAR; 16],
    u: FILE_OBJECTID_INFORMATION_u,
}}
pub type PFILE_OBJECTID_INFORMATION = *mut FILE_OBJECTID_INFORMATION;
STRUCT!{struct FILE_FULL_EA_INFORMATION {
    NextEntryOffset: ULONG,
    Flags: UCHAR,
    EaNameLength: UCHAR,
    EaValueLength: USHORT,
    EaName: [CHAR; 1],
}}
pub type PFILE_FULL_EA_INFORMATION = *mut FILE_FULL_EA_INFORMATION;
STRUCT!{struct FILE_GET_EA_INFORMATION {
    NextEntryOffset: ULONG,
    EaNameLength: UCHAR,
    EaName: [CHAR; 1],
}}
pub type PFILE_GET_EA_INFORMATION = *mut FILE_GET_EA_INFORMATION;
STRUCT!{struct FILE_GET_QUOTA_INFORMATION {
    NextEntryOffset: ULONG,
    SidLength: ULONG,
    Sid: SID,
}}
pub type PFILE_GET_QUOTA_INFORMATION = *mut FILE_GET_QUOTA_INFORMATION;
STRUCT!{struct FILE_QUOTA_INFORMATION {
    NextEntryOffset: ULONG,
    SidLength: ULONG,
    ChangeTime: LARGE_INTEGER,
    QuotaUsed: LARGE_INTEGER,
    QuotaThreshold: LARGE_INTEGER,
    QuotaLimit: LARGE_INTEGER,
    Sid: SID,
}}
pub type PFILE_QUOTA_INFORMATION = *mut FILE_QUOTA_INFORMATION;
ENUM!{enum FS_INFORMATION_CLASS {
    FileFsVolumeInformation = 1,
    FileFsLabelInformation = 2,
    FileFsSizeInformation = 3,
    FileFsDeviceInformation = 4,
    FileFsAttributeInformation = 5,
    FileFsControlInformation = 6,
    FileFsFullSizeInformation = 7,
    FileFsObjectIdInformation = 8,
    FileFsDriverPathInformation = 9,
    FileFsVolumeFlagsInformation = 10,
    FileFsSectorSizeInformation = 11,
    FileFsDataCopyInformation = 12,
    FileFsMetadataSizeInformation = 13,
    FileFsFullSizeInformationEx = 14,
    FileFsMaximumInformation = 15,
}}
pub type PFS_INFORMATION_CLASS = *mut FS_INFORMATION_CLASS;
STRUCT!{struct FILE_FS_LABEL_INFORMATION {
    VolumeLabelLength: ULONG,
    VolumeLabel: [WCHAR; 1],
}}
pub type PFILE_FS_LABEL_INFORMATION = *mut FILE_FS_LABEL_INFORMATION;
STRUCT!{struct FILE_FS_VOLUME_INFORMATION {
    VolumeCreationTime: LARGE_INTEGER,
    VolumeSerialNumber: ULONG,
    VolumeLabelLength: ULONG,
    SupportsObjects: BOOLEAN,
    VolumeLabel: [WCHAR; 1],
}}
pub type PFILE_FS_VOLUME_INFORMATION = *mut FILE_FS_VOLUME_INFORMATION;
STRUCT!{struct FILE_FS_SIZE_INFORMATION {
    TotalAllocationUnits: LARGE_INTEGER,
    AvailableAllocationUnits: LARGE_INTEGER,
    SectorsPerAllocationUnit: ULONG,
    BytesPerSector: ULONG,
}}
pub type PFILE_FS_SIZE_INFORMATION = *mut FILE_FS_SIZE_INFORMATION;
STRUCT!{struct FILE_FS_CONTROL_INFORMATION {
    FreeSpaceStartFiltering: LARGE_INTEGER,
    FreeSpaceThreshold: LARGE_INTEGER,
    FreeSpaceStopFiltering: LARGE_INTEGER,
    DefaultQuotaThreshold: LARGE_INTEGER,
    DefaultQuotaLimit: LARGE_INTEGER,
    FileSystemControlFlags: ULONG,
}}
pub type PFILE_FS_CONTROL_INFORMATION = *mut FILE_FS_CONTROL_INFORMATION;
STRUCT!{struct FILE_FS_FULL_SIZE_INFORMATION {
    TotalAllocationUnits: LARGE_INTEGER,
    CallerAvailableAllocationUnits: LARGE_INTEGER,
    ActualAvailableAllocationUnits: LARGE_INTEGER,
    SectorsPerAllocationUnit: ULONG,
    BytesPerSector: ULONG,
}}
pub type PFILE_FS_FULL_SIZE_INFORMATION = *mut FILE_FS_FULL_SIZE_INFORMATION;
STRUCT!{struct FILE_FS_OBJECTID_INFORMATION {
    ObjectId: [UCHAR; 16],
    ExtendedInfo: [UCHAR; 48],
}}
pub type PFILE_FS_OBJECTID_INFORMATION = *mut FILE_FS_OBJECTID_INFORMATION;
STRUCT!{struct FILE_FS_DEVICE_INFORMATION {
    DeviceType: DWORD,
    Characteristics: ULONG,
}}
pub type PFILE_FS_DEVICE_INFORMATION = *mut FILE_FS_DEVICE_INFORMATION;
STRUCT!{struct FILE_FS_ATTRIBUTE_INFORMATION {
    FileSystemAttributes: ULONG,
    MaximumComponentNameLength: LONG,
    FileSystemNameLength: ULONG,
    FileSystemName: [WCHAR; 1],
}}
pub type PFILE_FS_ATTRIBUTE_INFORMATION = *mut FILE_FS_ATTRIBUTE_INFORMATION;
STRUCT!{struct FILE_FS_DRIVER_PATH_INFORMATION {
    DriverInPath: BOOLEAN,
    DriverNameLength: ULONG,
    DriverName: [WCHAR; 1],
}}
pub type PFILE_FS_DRIVER_PATH_INFORMATION = *mut FILE_FS_DRIVER_PATH_INFORMATION;
STRUCT!{struct FILE_FS_VOLUME_FLAGS_INFORMATION {
    Flags: ULONG,
}}
pub type PFILE_FS_VOLUME_FLAGS_INFORMATION = *mut FILE_FS_VOLUME_FLAGS_INFORMATION;
pub const SSINFO_FLAGS_ALIGNED_DEVICE: u32 = 0x00000001;
pub const SSINFO_FLAGS_PARTITION_ALIGNED_ON_DEVICE: u32 = 0x00000002;
pub const SSINFO_OFFSET_UNKNOWN: u32 = 0xffffffff;
STRUCT!{struct FILE_FS_SECTOR_SIZE_INFORMATION {
    LogicalBytesPerSector: ULONG,
    PhysicalBytesPerSectorForAtomicity: ULONG,
    PhysicalBytesPerSectorForPerformance: ULONG,
    FileSystemEffectivePhysicalBytesPerSectorForAtomicity: ULONG,
    Flags: ULONG,
    ByteOffsetForSectorAlignment: ULONG,
    ByteOffsetForPartitionAlignment: ULONG,
}}
pub type PFILE_FS_SECTOR_SIZE_INFORMATION = *mut FILE_FS_SECTOR_SIZE_INFORMATION;
STRUCT!{struct FILE_FS_DATA_COPY_INFORMATION {
    NumberOfCopies: ULONG,
}}
pub type PFILE_FS_DATA_COPY_INFORMATION = *mut FILE_FS_DATA_COPY_INFORMATION;
STRUCT!{struct FILE_FS_METADATA_SIZE_INFORMATION {
    TotalMetadataAllocationUnits: LARGE_INTEGER,
    SectorsPerAllocationUnit: ULONG,
    BytesPerSector: ULONG,
}}
pub type PFILE_FS_METADATA_SIZE_INFORMATION = *mut FILE_FS_METADATA_SIZE_INFORMATION;
STRUCT!{struct FILE_FS_FULL_SIZE_INFORMATION_EX {
    ActualTotalAllocationUnits: ULONGLONG,
    ActualAvailableAllocationUnits: ULONGLONG,
    ActualPoolUnavailableAllocationUnits: ULONGLONG,
    CallerTotalAllocationUnits: ULONGLONG,
    CallerAvailableAllocationUnits: ULONGLONG,
    CallerPoolUnavailableAllocationUnits: ULONGLONG,
    UsedAllocationUnits: ULONGLONG,
    TotalReservedAllocationUnits: ULONGLONG,
    VolumeStorageReserveAllocationUnits: ULONGLONG,
    AvailableCommittedAllocationUnits: ULONGLONG,
    PoolAvailableAllocationUnits: ULONGLONG,
    SectorsPerAllocationUnit: ULONG,
    BytesPerSector: ULONG,
}}
pub type PFILE_FS_FULL_SIZE_INFORMATION_EX = *mut FILE_FS_FULL_SIZE_INFORMATION_EX;
EXTERN!{extern "system" {
    fn NtCreateFile(
        FileHandle: PHANDLE,
        DesiredAccess: ACCESS_MASK,
        ObjectAttributes: POBJECT_ATTRIBUTES,
        IoStatusBlock: PIO_STATUS_BLOCK,
        AllocationSize: PLARGE_INTEGER,
        FileAttributes: ULONG,
        ShareAccess: ULONG,
        CreateDisposition: ULONG,
        CreateOptions: ULONG,
        EaBuffer: PVOID,
        EaLength: ULONG,
    ) -> NTSTATUS;
    fn NtCreateNamedPipeFile(
        FileHandle: PHANDLE,
        DesiredAccess: ULONG,
        ObjectAttributes: POBJECT_ATTRIBUTES,
        IoStatusBlock: PIO_STATUS_BLOCK,
        ShareAccess: ULONG,
        CreateDisposition: ULONG,
        CreateOptions: ULONG,
        NamedPipeType: ULONG,
        ReadMode: ULONG,
        CompletionMode: ULONG,
        MaximumInstances: ULONG,
        InboundQuota: ULONG,
        OutboundQuota: ULONG,
        DefaultTimeout: PLARGE_INTEGER,
    ) -> NTSTATUS;
    fn NtCreateMailslotFile(
        FileHandle: PHANDLE,
        DesiredAccess: ULONG,
        ObjectAttributes: POBJECT_ATTRIBUTES,
        IoStatusBlock: PIO_STATUS_BLOCK,
        CreateOptions: ULONG,
        MailslotQuota: ULONG,
        MaximumMessageSize: ULONG,
        ReadTimeout: PLARGE_INTEGER,
    ) -> NTSTATUS;
    fn NtOpenFile(
        FileHandle: PHANDLE,
        DesiredAccess: ACCESS_MASK,
        ObjectAttributes: POBJECT_ATTRIBUTES,
        IoStatusBlock: PIO_STATUS_BLOCK,
        ShareAccess: ULONG,
        OpenOptions: ULONG,
    ) -> NTSTATUS;
    fn NtDeleteFile(
        ObjectAttributes: POBJECT_ATTRIBUTES,
    ) -> NTSTATUS;
    fn NtFlushBuffersFile(
        FileHandle: HANDLE,
        IoStatusBlock: PIO_STATUS_BLOCK,
    ) -> NTSTATUS;
    fn NtFlushBuffersFileEx(
        FileHandle: HANDLE,
        Flags: ULONG,
        Parameters: PVOID,
        ParametersSize: ULONG,
        IoStatusBlock: PIO_STATUS_BLOCK,
    ) -> NTSTATUS;
    fn NtQueryInformationFile(
        FileHandle: HANDLE,
        IoStatusBlock: PIO_STATUS_BLOCK,
        FileInformation: PVOID,
        Length: ULONG,
        FileInformationClass: FILE_INFORMATION_CLASS,
    ) -> NTSTATUS;
    fn NtQueryInformationByName(
        ObjectAttributes: POBJECT_ATTRIBUTES,
        IoStatusBlock: PIO_STATUS_BLOCK,
        FileInformation: PVOID,
        Length: ULONG,
        FileInformationClass: FILE_INFORMATION_CLASS,
    ) -> NTSTATUS;
    fn NtSetInformationFile(
        FileHandle: HANDLE,
        IoStatusBlock: PIO_STATUS_BLOCK,
        FileInformation: PVOID,
        Length: ULONG,
        FileInformationClass: FILE_INFORMATION_CLASS,
    ) -> NTSTATUS;
    fn NtQueryDirectoryFile(
        FileHandle: HANDLE,
        Event: HANDLE,
        ApcRoutine: PIO_APC_ROUTINE,
        ApcContext: PVOID,
        IoStatusBlock: PIO_STATUS_BLOCK,
        FileInformation: PVOID,
        Length: ULONG,
        FileInformationClass: FILE_INFORMATION_CLASS,
        ReturnSingleEntry: BOOLEAN,
        FileName: PUNICODE_STRING,
        RestartScan: BOOLEAN,
    ) -> NTSTATUS;
    fn NtQueryEaFile(
        FileHandle: HANDLE,
        IoStatusBlock: PIO_STATUS_BLOCK,
        Buffer: PVOID,
        Length: ULONG,
        ReturnSingleEntry: BOOLEAN,
        EaList: PVOID,
        EaListLength: ULONG,
        EaIndex: PULONG,
        RestartScan: BOOLEAN,
    ) -> NTSTATUS;
    fn NtSetEaFile(
        FileHandle: HANDLE,
        IoStatusBlock: PIO_STATUS_BLOCK,
        Buffer: PVOID,
        Length: ULONG,
    ) -> NTSTATUS;
    fn NtQueryQuotaInformationFile(
        FileHandle: HANDLE,
        IoStatusBlock: PIO_STATUS_BLOCK,
        Buffer: PVOID,
        Length: ULONG,
        ReturnSingleEntry: BOOLEAN,
        SidList: PVOID,
        SidListLength: ULONG,
        StartSid: PSID,
        RestartScan: BOOLEAN,
    ) -> NTSTATUS;
    fn NtSetQuotaInformationFile(
        FileHandle: HANDLE,
        IoStatusBlock: PIO_STATUS_BLOCK,
        Buffer: PVOID,
        Length: ULONG,
    ) -> NTSTATUS;
    fn NtQueryVolumeInformationFile(
        FileHandle: HANDLE,
        IoStatusBlock: PIO_STATUS_BLOCK,
        FsInformation: PVOID,
        Length: ULONG,
        FsInformationClass: FS_INFORMATION_CLASS,
    ) -> NTSTATUS;
    fn NtSetVolumeInformationFile(
        FileHandle: HANDLE,
        IoStatusBlock: PIO_STATUS_BLOCK,
        FsInformation: PVOID,
        Length: ULONG,
        FsInformationClass: FS_INFORMATION_CLASS,
    ) -> NTSTATUS;
    fn NtCancelIoFile(
        FileHandle: HANDLE,
        IoStatusBlock: PIO_STATUS_BLOCK,
    ) -> NTSTATUS;
    fn NtCancelIoFileEx(
        FileHandle: HANDLE,
        IoRequestToCancel: PIO_STATUS_BLOCK,
        IoStatusBlock: PIO_STATUS_BLOCK,
    ) -> NTSTATUS;
    fn NtCancelSynchronousIoFile(
        ThreadHandle: HANDLE,
        IoRequestToCancel: PIO_STATUS_BLOCK,
        IoStatusBlock: PIO_STATUS_BLOCK,
    ) -> NTSTATUS;
    fn NtDeviceIoControlFile(
        FileHandle: HANDLE,
        Event: HANDLE,
        ApcRoutine: PIO_APC_ROUTINE,
        ApcContext: PVOID,
        IoStatusBlock: PIO_STATUS_BLOCK,
        IoControlCode: ULONG,
        InputBuffer: PVOID,
        InputBufferLength: ULONG,
        OutputBuffer: PVOID,
        OutputBufferLength: ULONG,
    ) -> NTSTATUS;
    fn NtFsControlFile(
        FileHandle: HANDLE,
        Event: HANDLE,
        ApcRoutine: PIO_APC_ROUTINE,
        ApcContext: PVOID,
        IoStatusBlock: PIO_STATUS_BLOCK,
        FsControlCode: ULONG,
        InputBuffer: PVOID,
        InputBufferLength: ULONG,
        OutputBuffer: PVOID,
        OutputBufferLength: ULONG,
    ) -> NTSTATUS;
    fn NtReadFile(
        FileHandle: HANDLE,
        Event: HANDLE,
        ApcRoutine: PIO_APC_ROUTINE,
        ApcContext: PVOID,
        IoStatusBlock: PIO_STATUS_BLOCK,
        Buffer: PVOID,
        Length: ULONG,
        ByteOffset: PLARGE_INTEGER,
        Key: PULONG,
    ) -> NTSTATUS;
    fn NtWriteFile(
        FileHandle: HANDLE,
        Event: HANDLE,
        ApcRoutine: PIO_APC_ROUTINE,
        ApcContext: PVOID,
        IoStatusBlock: PIO_STATUS_BLOCK,
        Buffer: PVOID,
        Length: ULONG,
        ByteOffset: PLARGE_INTEGER,
        Key: PULONG,
    ) -> NTSTATUS;
    fn NtReadFileScatter(
        FileHandle: HANDLE,
        Event: HANDLE,
        ApcRoutine: PIO_APC_ROUTINE,
        ApcContext: PVOID,
        IoStatusBlock: PIO_STATUS_BLOCK,
        SegmentArray: PFILE_SEGMENT_ELEMENT,
        Length: ULONG,
        ByteOffset: PLARGE_INTEGER,
        Key: PULONG,
    ) -> NTSTATUS;
    fn NtWriteFileGather(
        FileHandle: HANDLE,
        Event: HANDLE,
        ApcRoutine: PIO_APC_ROUTINE,
        ApcContext: PVOID,
        IoStatusBlock: PIO_STATUS_BLOCK,
        SegmentArray: PFILE_SEGMENT_ELEMENT,
        Length: ULONG,
        ByteOffset: PLARGE_INTEGER,
        Key: PULONG,
    ) -> NTSTATUS;
    fn NtLockFile(
        FileHandle: HANDLE,
        Event: HANDLE,
        ApcRoutine: PIO_APC_ROUTINE,
        ApcContext: PVOID,
        IoStatusBlock: PIO_STATUS_BLOCK,
        ByteOffset: PLARGE_INTEGER,
        Length: PLARGE_INTEGER,
        Key: ULONG,
        FailImmediately: BOOLEAN,
        ExclusiveLock: BOOLEAN,
    ) -> NTSTATUS;
    fn NtUnlockFile(
        FileHandle: HANDLE,
        IoStatusBlock: PIO_STATUS_BLOCK,
        ByteOffset: PLARGE_INTEGER,
        Length: PLARGE_INTEGER,
        Key: ULONG,
    ) -> NTSTATUS;
    fn NtQueryAttributesFile(
        ObjectAttributes: POBJECT_ATTRIBUTES,
        FileInformation: PFILE_BASIC_INFORMATION,
    ) -> NTSTATUS;
    fn NtQueryFullAttributesFile(
        ObjectAttributes: POBJECT_ATTRIBUTES,
        FileInformation: PFILE_NETWORK_OPEN_INFORMATION,
    ) -> NTSTATUS;
    fn NtNotifyChangeDirectoryFile(
        FileHandle: HANDLE,
        Event: HANDLE,
        ApcRoutine: PIO_APC_ROUTINE,
        ApcContext: PVOID,
        IoStatusBlock: PIO_STATUS_BLOCK,
        Buffer: PVOID,
        Length: ULONG,
        CompletionFilter: ULONG,
        WatchTree: BOOLEAN,
    ) -> NTSTATUS;
    fn NtLoadDriver(
        DriverServiceName: PUNICODE_STRING,
    ) -> NTSTATUS;
    fn NtUnloadDriver(
        DriverServiceName: PUNICODE_STRING,
    ) -> NTSTATUS;
}}
pub const IO_COMPLETION_QUERY_STATE: u32 = 0x0001;
ENUM!{enum IO_COMPLETION_INFORMATION_CLASS {
    IoCompletionBasicInformation = 0,
}}
STRUCT!{struct IO_COMPLETION_BASIC_INFORMATION {
    Depth: LONG,
}}
pub type PIO_COMPLETION_BASIC_INFORMATION = *mut IO_COMPLETION_BASIC_INFORMATION;
EXTERN!{extern "system" {
    fn NtCreateIoCompletion(
        IoCompletionHandle: PHANDLE,
        DesiredAccess: ACCESS_MASK,
        ObjectAttributes: POBJECT_ATTRIBUTES,
        Count: ULONG,
    ) -> NTSTATUS;
    fn NtOpenIoCompletion(
        IoCompletionHandle: PHANDLE,
        DesiredAccess: ACCESS_MASK,
        ObjectAttributes: POBJECT_ATTRIBUTES,
    ) -> NTSTATUS;
    fn NtQueryIoCompletion(
        IoCompletionHandle: HANDLE,
        IoCompletionInformationClass: IO_COMPLETION_INFORMATION_CLASS,
        IoCompletionInformation: PVOID,
        IoCompletionInformationLength: ULONG,
        ReturnLength: PULONG,
    ) -> NTSTATUS;
    fn NtSetIoCompletion(
        IoCompletionHandle: HANDLE,
        KeyContext: PVOID,
        ApcContext: PVOID,
        IoStatus: NTSTATUS,
        IoStatusInformation: ULONG_PTR,
    ) -> NTSTATUS;
    fn NtSetIoCompletionEx(
        IoCompletionHandle: HANDLE,
        IoCompletionPacketHandle: HANDLE,
        KeyContext: PVOID,
        ApcContext: PVOID,
        IoStatus: NTSTATUS,
        IoStatusInformation: ULONG_PTR,
    ) -> NTSTATUS;
    fn NtRemoveIoCompletion(
        IoCompletionHandle: HANDLE,
        KeyContext: *mut PVOID,
        ApcContext: *mut PVOID,
        IoStatusBlock: PIO_STATUS_BLOCK,
        Timeout: PLARGE_INTEGER,
    ) -> NTSTATUS;
    fn NtRemoveIoCompletionEx(
        IoCompletionHandle: HANDLE,
        IoCompletionInformation: PFILE_IO_COMPLETION_INFORMATION,
        Count: ULONG,
        NumEntriesRemoved: PULONG,
        Timeout: PLARGE_INTEGER,
        Alertable: BOOLEAN,
    ) -> NTSTATUS;
    fn NtCreateWaitCompletionPacket(
        WaitCompletionPacketHandle: PHANDLE,
        DesiredAccess: ACCESS_MASK,
        ObjectAttributes: POBJECT_ATTRIBUTES,
    ) -> NTSTATUS;
    fn NtAssociateWaitCompletionPacket(
        WaitCompletionPacketHandle: HANDLE,
        IoCompletionHandle: HANDLE,
        TargetObjectHandle: HANDLE,
        KeyContext: PVOID,
        ApcContext: PVOID,
        IoStatus: NTSTATUS,
        IoStatusInformation: ULONG_PTR,
        AlreadySignaled: PBOOLEAN,
    ) -> NTSTATUS;
    fn NtCancelWaitCompletionPacket(
        WaitCompletionPacketHandle: HANDLE,
        RemoveSignaledPacket: BOOLEAN,
    ) -> NTSTATUS;
}}
ENUM!{enum IO_SESSION_EVENT {
    IoSessionEventIgnore = 0,
    IoSessionEventCreated = 1,
    IoSessionEventTerminated = 2,
    IoSessionEventConnected = 3,
    IoSessionEventDisconnected = 4,
    IoSessionEventLogon = 5,
    IoSessionEventLogoff = 6,
    IoSessionEventMax = 7,
}}
ENUM!{enum IO_SESSION_STATE {
    IoSessionStateCreated = 0,
    IoSessionStateInitialized = 1,
    IoSessionStateConnected = 2,
    IoSessionStateDisconnected = 3,
    IoSessionStateDisconnectedLoggedOn = 4,
    IoSessionStateLoggedOn = 5,
    IoSessionStateLoggedOff = 6,
    IoSessionStateTerminated = 7,
    IoSessionStateMax = 8,
}}
EXTERN!{extern "system" {
    fn NtNotifyChangeSession(
        SessionHandle: HANDLE,
        ChangeSequenceNumber: ULONG,
        ChangeTimeStamp: PLARGE_INTEGER,
        Event: IO_SESSION_EVENT,
        NewState: IO_SESSION_STATE,
        PreviousState: IO_SESSION_STATE,
        Payload: PVOID,
        PayloadSize: ULONG,
    ) -> NTSTATUS;
}}
ENUM!{enum INTERFACE_TYPE {
    InterfaceTypeUndefined = -1i32 as u32,
    Internal = 0,
    Isa = 1,
    Eisa = 2,
    MicroChannel = 3,
    TurboChannel = 4,
    PCIBus = 5,
    VMEBus = 6,
    NuBus = 7,
    PCMCIABus = 8,
    CBus = 9,
    MPIBus = 10,
    MPSABus = 11,
    ProcessorInternal = 12,
    InternalPowerBus = 13,
    PNPISABus = 14,
    PNPBus = 15,
    Vmcs = 16,
    MaximumInterfaceType = 17,
}}
pub type PINTERFACE_TYPE = *mut INTERFACE_TYPE;
ENUM!{enum DMA_WIDTH {
    Width8Bits = 0,
    Width16Bits = 1,
    Width32Bits = 2,
    MaximumDmaWidth = 3,
}}
pub type PDMA_WIDTH = *mut DMA_WIDTH;
ENUM!{enum DMA_SPEED {
    Compatible = 0,
    TypeA = 1,
    TypeB = 2,
    TypeC = 3,
    TypeF = 4,
    MaximumDmaSpeed = 5,
}}
pub type PDMA_SPEED = *mut DMA_SPEED;
ENUM!{enum BUS_DATA_TYPE {
    ConfigurationSpaceUndefined = -1i32 as u32,
    Cmos = 0,
    EisaConfiguration = 1,
    Pos = 2,
    CbusConfiguration = 3,
    PCIConfiguration = 4,
    VMEConfiguration = 5,
    NuBusConfiguration = 6,
    PCMCIAConfiguration = 7,
    MPIConfiguration = 8,
    MPSAConfiguration = 9,
    PNPISAConfiguration = 10,
    SgiInternalConfiguration = 11,
    MaximumBusDataType = 12,
}}
pub type PBUS_DATA_TYPE = *mut BUS_DATA_TYPE;
pub const SYMLINK_FLAG_RELATIVE: u32 = 1;
STRUCT!{struct REPARSE_DATA_BUFFER_u_SymbolicLinkReparseBuffer {
    SubstituteNameOffset: USHORT,
    SubstituteNameLength: USHORT,
    PrintNameOffset: USHORT,
    PrintNameLength: USHORT,
    Flags: ULONG,
    PathBuffer: [WCHAR; 1],
}}
STRUCT!{struct REPARSE_DATA_BUFFER_u_MountPointReparseBuffer {
    SubstituteNameOffset: USHORT,
    SubstituteNameLength: USHORT,
    PrintNameOffset: USHORT,
    PrintNameLength: USHORT,
    PathBuffer: [WCHAR; 1],
}}
STRUCT!{struct REPARSE_DATA_BUFFER_u_GenericReparseBuffer {
    DataBuffer: [UCHAR; 1],
}}
UNION!{union REPARSE_DATA_BUFFER_u {
    SymbolicLinkReparseBuffer: REPARSE_DATA_BUFFER_u_SymbolicLinkReparseBuffer,
    MountPointReparseBuffer: REPARSE_DATA_BUFFER_u_MountPointReparseBuffer,
    GenericReparseBuffer: REPARSE_DATA_BUFFER_u_GenericReparseBuffer,
}}
STRUCT!{struct REPARSE_DATA_BUFFER {
    ReparseTag: ULONG,
    ReparseDataLength: USHORT,
    Reserved: USHORT,
    u: REPARSE_DATA_BUFFER_u,
}}
pub type PREPARSE_DATA_BUFFER = *mut REPARSE_DATA_BUFFER;
/// "\Device\NamedPipe\"
pub const DEVICE_NAMED_PIPE: UTF16Const = UTF16Const(&[
    0x005C, 0x0044, 0x0065, 0x0076, 0x0069, 0x0063, 0x0065, 0x005C, 0x004E, 0x0061, 0x006D, 0x0065,
    0x0064, 0x0050, 0x0069, 0x0070, 0x0065, 0x005C, 0u16,
]);
pub const FSCTL_PIPE_ASSIGN_EVENT: u32 =
    CTL_CODE(FILE_DEVICE_NAMED_PIPE, 0, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSTL_PIPE_DISCONNECT: u32 =
    CTL_CODE(FILE_DEVICE_NAMED_PIPE, 1, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSTL_PIPE_LISTEN: u32 =
    CTL_CODE(FILE_DEVICE_NAMED_PIPE, 2, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSTL_PIPE_PEEK: u32 =
    CTL_CODE(FILE_DEVICE_NAMED_PIPE, 3, METHOD_BUFFERED, FILE_READ_DATA);
pub const FSTL_PIPE_QUERY_EVENT: u32 =
    CTL_CODE(FILE_DEVICE_NAMED_PIPE, 4, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSTL_PIPE_TRANSCEIVE: u32 =
    CTL_CODE(FILE_DEVICE_NAMED_PIPE, 5, METHOD_NEITHER, FILE_READ_DATA | FILE_WRITE_DATA);
pub const FSTL_PIPE_WAIT: u32 =
    CTL_CODE(FILE_DEVICE_NAMED_PIPE, 6, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSTL_PIPE_IMPERSONATE: u32 =
    CTL_CODE(FILE_DEVICE_NAMED_PIPE, 7, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSTL_PIPE_SET_CLIENT_PROCESS: u32 =
    CTL_CODE(FILE_DEVICE_NAMED_PIPE, 8, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSTL_PIPE_QUERY_CLIENT_PROCESS: u32 =
    CTL_CODE(FILE_DEVICE_NAMED_PIPE, 9, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSTL_PIPE_GET_PIPE_ATTRIBUTE: u32 =
    CTL_CODE(FILE_DEVICE_NAMED_PIPE, 10, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSTL_PIPE_SET_PIPE_ATTRIBUTE: u32 =
    CTL_CODE(FILE_DEVICE_NAMED_PIPE, 11, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSTL_PIPE_GET_CONNECTION_ATTRIBUTE: u32 =
    CTL_CODE(FILE_DEVICE_NAMED_PIPE, 12, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSTL_PIPE_SET_CONNECTION_ATTRIBUTE: u32 =
    CTL_CODE(FILE_DEVICE_NAMED_PIPE, 13, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSTL_PIPE_GET_HANDLE_ATTRIBUTE: u32 =
    CTL_CODE(FILE_DEVICE_NAMED_PIPE, 14, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSTL_PIPE_SET_HANDLE_ATTRIBUTE: u32 =
    CTL_CODE(FILE_DEVICE_NAMED_PIPE, 15, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSTL_PIPE_FLUSH: u32 =
    CTL_CODE(FILE_DEVICE_NAMED_PIPE, 16, METHOD_BUFFERED, FILE_WRITE_DATA);
pub const FSTL_PIPE_INTERNAL_READ: u32 =
    CTL_CODE(FILE_DEVICE_NAMED_PIPE, 2045, METHOD_BUFFERED, FILE_READ_DATA);
pub const FSTL_PIPE_INTERNAL_WRITE: u32 =
    CTL_CODE(FILE_DEVICE_NAMED_PIPE, 2046, METHOD_BUFFERED, FILE_WRITE_DATA);
pub const FSTL_PIPE_INTERNAL_TRANSCEIVE: u32 =
    CTL_CODE(FILE_DEVICE_NAMED_PIPE, 2047, METHOD_NEITHER, FILE_READ_DATA | FILE_WRITE_DATA);
pub const FSTL_PIPE_INTERNAL_READ_OVFLOW: u32 =
    CTL_CODE(FILE_DEVICE_NAMED_PIPE, 2048, METHOD_BUFFERED, FILE_READ_DATA);
pub const FILE_PIPE_READ_DATA: u32 = 0x00000000;
pub const FILE_PIPE_WRITE_SPACE: u32 = 0x00000001;
STRUCT!{struct FILE_PIPE_ASSIGN_EVENT_BUFFER {
    EventHandle: HANDLE,
    KeyValue: ULONG,
}}
pub type PFILE_PIPE_ASSIGN_EVENT_BUFFER = *mut FILE_PIPE_ASSIGN_EVENT_BUFFER;
STRUCT!{struct FILE_PIPE_PEEK_BUFFER {
    NamedPipeState: ULONG,
    ReadDataAvailable: ULONG,
    NumberOfMessages: ULONG,
    MessageLength: ULONG,
    Data: [CHAR; 1],
}}
pub type PFILE_PIPE_PEEK_BUFFER = *mut FILE_PIPE_PEEK_BUFFER;
STRUCT!{struct FILE_PIPE_EVENT_BUFFER {
    NamedPipeState: ULONG,
    EntryType: ULONG,
    ByteCount: ULONG,
    KeyValue: ULONG,
    NumberRequests: ULONG,
}}
pub type PFILE_PIPE_EVENT_BUFFER = *mut FILE_PIPE_EVENT_BUFFER;
STRUCT!{struct FILE_PIPE_WAIT_FOR_BUFFER {
    Timeout: LARGE_INTEGER,
    NameLength: ULONG,
    TimeoutSpecified: BOOLEAN,
    Name: [WCHAR; 1],
}}
pub type PFILE_PIPE_WAIT_FOR_BUFFER = *mut FILE_PIPE_WAIT_FOR_BUFFER;
STRUCT!{struct FILE_PIPE_CLIENT_PROCESS_BUFFER {
    ClientSession: PVOID,
    ClientProcess: PVOID,
}}
pub type PFILE_PIPE_CLIENT_PROCESS_BUFFER = *mut FILE_PIPE_CLIENT_PROCESS_BUFFER;
pub const FILE_PIPE_COMPUTER_NAME_LENGTH: usize = 15;
STRUCT!{struct FILE_PIPE_CLIENT_PROCESS_BUFFER_EX {
    ClientSession: PVOID,
    ClientProcess: PVOID,
    ClientComputerNameLength: USHORT,
    ClientComputerBuffer: [WCHAR; FILE_PIPE_COMPUTER_NAME_LENGTH + 1],
}}
pub type PFILE_PIPE_CLIENT_PROCESS_BUFFER_EX = *mut FILE_PIPE_CLIENT_PROCESS_BUFFER_EX;
pub const MAILSLOT_CLASS_FIRSTCLASS: u32 = 1;
pub const MAILSLOT_CLASS_SECONDCLASS: u32 = 2;
pub const FSCTL_MAILSLOT_PEEK: u32 =
    CTL_CODE(FILE_DEVICE_MAILSLOT, 0, METHOD_NEITHER, FILE_READ_DATA);
STRUCT!{struct FILE_MAILSLOT_PEEK_BUFFER {
    ReadDataAvailable: ULONG,
    NumberOfMessages: ULONG,
    MessageLength: ULONG,
}}
pub type PFILE_MAILSLOT_PEEK_BUFFER = *mut FILE_MAILSLOT_PEEK_BUFFER;
