/* SPDX-License-Identifier: (GPL-2.0-only OR LGPL-2.1-only)
 *
 * wrapper/irqdesc.c
 *
 * wrapper around irq_to_desc. Using KALLSYMS to get its address when
 * available, else we need to have a kernel that exports this function to GPL
 * modules. This export was added to the 3.4 kernels and removed in 5.11.
 *
 * Copyright (C) 2011-2012 Mathieu Desnoyers <mathieu.desnoyers@efficios.com>
 */

#include <lttng/kernel-version.h>
#include <linux/module.h>

#if (defined(CONFIG_KALLSYMS) && \
	((LTTNG_LINUX_VERSION_CODE >= LTTNG_KERNEL_VERSION(5,11,0)) || \
	 (LTTNG_LINUX_VERSION_CODE < LTTNG_KERNEL_VERSION(3,4,0))))

#include <linux/kallsyms.h>
#include <linux/interrupt.h>
#include <linux/irqnr.h>
#include <wrapper/kallsyms.h>
#include <wrapper/irqdesc.h>

static
struct irq_desc *(*irq_to_desc_sym)(unsigned int irq);

struct irq_desc *wrapper_irq_to_desc(unsigned int irq)
{
	if (!irq_to_desc_sym)
		irq_to_desc_sym = (void *) kallsyms_lookup_funcptr("irq_to_desc");
	if (irq_to_desc_sym) {
		struct irq_ibt_state irq_ibt_state;
		struct irq_desc *ret;

		irq_ibt_state = wrapper_irq_ibt_save();
		ret = irq_to_desc_sym(irq);
		wrapper_irq_ibt_restore(irq_ibt_state);
		return ret;
	} else {
		printk_once(KERN_WARNING "LTTng: irq_to_desc symbol lookup failed.\n");
		return NULL;
	}
}
EXPORT_SYMBOL_GPL(wrapper_irq_to_desc);

#else

#include <linux/interrupt.h>
#include <linux/irqnr.h>

struct irq_desc *wrapper_irq_to_desc(unsigned int irq)
{
	return irq_to_desc(irq);
}
EXPORT_SYMBOL_GPL(wrapper_irq_to_desc);

#endif
