/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.ui.views;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCharset;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCollation;
import org.jkiss.dbeaver.ext.mysql.ui.internal.MySQLUIMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class MySQLCreateDatabaseDialog
extends BaseDialog {
    public static final String DEFAULT_CHARSET_NAME = "utf8";
    private final MySQLCatalog database;
    private String name;
    private MySQLCharset charset;
    private MySQLCollation collation;

    public MySQLCreateDatabaseDialog(Shell parentShell, MySQLCatalog database) {
        super(parentShell, MySQLUIMessages.dialog_create_database_title, null);
        this.database = database;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite group = UIUtils.createComposite((Composite)composite, (int)2);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Text nameText = UIUtils.createLabelText((Composite)group, (String)MySQLUIMessages.dialog_create_database_database_name, (String)"");
        nameText.addModifyListener(e -> {
            this.name = nameText.getText().trim();
            this.getButton(0).setEnabled(!this.name.isEmpty());
        });
        Combo charsetCombo = UIUtils.createLabelCombo((Composite)group, (String)MySQLUIMessages.dialog_create_database_charset, (int)2052);
        for (MySQLCharset cs : this.database.getDataSource().getCharsets()) {
            charsetCombo.add(cs.getName());
        }
        this.charset = this.database.getDataSource().getDefaultCharset();
        if (this.charset == null) {
            this.charset = this.database.getDataSource().getCharset(DEFAULT_CHARSET_NAME);
        }
        this.collation = this.database.getDataSource().getDefaultCollation();
        if (this.collation == null) {
            this.collation = this.charset.getDefaultCollation();
        }
        charsetCombo.setText(this.charset.getName());
        Combo collationCombo = UIUtils.createLabelCombo((Composite)group, (String)MySQLUIMessages.dialog_create_database_collation, (int)2052);
        for (MySQLCollation col : this.charset.getCollations()) {
            collationCombo.add(col.getName());
        }
        if (this.collation != null) {
            UIUtils.setComboSelection((Combo)collationCombo, (String)this.collation.getName());
        }
        charsetCombo.addModifyListener(e -> {
            this.charset = this.database.getDataSource().getCharset(charsetCombo.getText());
            assert (this.charset != null);
            collationCombo.removeAll();
            if (this.charset != null) {
                for (MySQLCollation col : this.charset.getCollations()) {
                    collationCombo.add(col.getName());
                }
                this.collation = this.charset.getDefaultCollation();
            }
            if (this.collation != null) {
                UIUtils.setComboSelection((Combo)collationCombo, (String)this.collation.getName());
            }
        });
        collationCombo.addModifyListener(e -> {
            MySQLCollation mySQLCollation = this.collation = this.charset == null ? null : this.charset.getCollation(collationCombo.getText());
        });
        return composite;
    }

    public String getName() {
        return this.name;
    }

    public MySQLCharset getCharset() {
        return this.charset;
    }

    public MySQLCollation getCollation() {
        return this.collation;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }
}

