from collections import OrderedDict

from .. import Provider as PersonProvider

# Data source
#
# Data for this provider comes from the following sources:
#
# Last name data: Swedish Tax Agency - top 500 name statistics data from 2025.
# https://skatteverket.se/privat/folkbokforing/namn/bytaefternamn/sokblanddevanligasteefternamnen.4.515a6be615c637b9aa48e09.html
#
# First name data: The Institute for Language and Folklore (Isof) - top 500 data from 2023.
# https://www.isof.se/namn/personnamn/namnstatistik
#


class Provider(PersonProvider):
    formats_female = (
        "{{first_name_female}} {{last_name}}",
        "{{first_name_female}} {{last_name}}",
        "{{first_name_female}} {{last_name}}",
        "{{first_name_female}} {{last_name}}",
        "{{first_name_female}} {{last_name}}",
        "{{first_name_female}} {{last_name}}",
        "{{first_name_female}} {{last_name}}",
        "{{first_name_female}} {{last_name}}",
        "{{first_name_female}} {{last_name}} {{last_name}}",
        "{{first_name_female}} {{last_name}}-{{last_name}}",
    )

    formats_male = (
        "{{first_name_male}} {{last_name}}",
        "{{first_name_male}} {{last_name}}",
        "{{first_name_male}} {{last_name}}",
        "{{first_name_male}} {{last_name}}",
        "{{first_name_male}} {{last_name}}",
        "{{first_name_male}} {{last_name}}",
        "{{first_name_male}} {{last_name}}",
        "{{first_name_male}} {{last_name}}",
        "{{first_name_male}} {{last_name}} {{last_name}}",
        "{{first_name_male}} {{last_name}}-{{last_name}}",
    )

    formats = formats_female + formats_male

    first_names_female = OrderedDict(
        (
            ("Abdi", 0.000288),
            ("Adele", 0.000343),
            ("Agnes", 0.003102),
            ("Agneta", 0.003776),
            ("Agnieszka", 0.000268),
            ("Ahmed", 0.000767),
            ("Aina", 0.001031),
            ("Aisha", 0.000292),
            ("Alba", 0.000281),
            ("Aleksandra", 0.000327),
            ("Alexandra", 0.003364),
            ("Ali", 0.000822),
            ("Alice", 0.005009),
            ("Alicia", 0.001859),
            ("Alina", 0.000500),
            ("Alma", 0.002266),
            ("Alva", 0.002389),
            ("Amalia", 0.000354),
            ("Amanda", 0.004428),
            ("Amelia", 0.000554),
            ("Amelie", 0.000405),
            ("Amina", 0.000493),
            ("Amira", 0.000276),
            ("Ana", 0.000458),
            ("Andrea", 0.001204),
            ("Anette", 0.003509),
            ("Angela", 0.000516),
            ("Angelica", 0.001502),
            ("Angelika", 0.000288),
            ("Angelina", 0.000421),
            ("Anita", 0.006239),
            ("Anja", 0.000580),
            ("Ann", 0.004046),
            ("Ann-Britt", 0.000647),
            ("Ann-Charlott", 0.000344),
            ("Ann-Charlotte", 0.001258),
            ("Ann-Christin", 0.001080),
            ("Ann-Christine", 0.000548),
            ("Ann-Kristin", 0.000744),
            ("Ann-Louise", 0.000565),
            ("Ann-Mari", 0.000613),
            ("Ann-Marie", 0.001147),
            ("Ann-Sofi", 0.000391),
            ("Ann-Sofie", 0.000803),
            ("Anna", 0.035051),
            ("Anna-Karin", 0.000969),
            ("Anna-Lena", 0.000910),
            ("Anna-Lisa", 0.000338),
            ("Anna-Maria", 0.000337),
            ("Anne", 0.002188),
            ("Anne-Marie", 0.000795),
            ("Anneli", 0.003006),
            ("Annelie", 0.001400),
            ("Annette", 0.001264),
            ("Annica", 0.000943),
            ("Annie", 0.001500),
            ("Annika", 0.004633),
            ("Annikki", 0.000339),
            ("Antonia", 0.000384),
            ("Asta", 0.000640),
            ("Astrid", 0.004994),
            ("Aurora", 0.000722),
            ("Barbara", 0.000462),
            ("Barbro", 0.004156),
            ("Beata", 0.000410),
            ("Beatrice", 0.001165),
            ("Bella", 0.000337),
            ("Berit", 0.002914),
            ("Betty", 0.000312),
            ("Bianca", 0.000529),
            ("Birgit", 0.002089),
            ("Birgitta", 0.018070),
            ("Bodil", 0.000870),
            ("Boel", 0.000296),
            ("Brita", 0.000825),
            ("Britt", 0.003536),
            ("Britt-Mari", 0.000313),
            ("Britt-Marie", 0.001744),
            ("Britta", 0.001336),
            ("Cajsa", 0.000267),
            ("Camilla", 0.004123),
            ("Carin", 0.001345),
            ("Carina", 0.005446),
            ("Carmen", 0.000457),
            ("Carola", 0.000953),
            ("Carolin", 0.000361),
            ("Carolina", 0.001906),
            ("Caroline", 0.003921),
            ("Cassandra", 0.000381),
            ("Catarina", 0.001099),
            ("Catharina", 0.001131),
            ("Cathrine", 0.000331),
            ("Catrin", 0.000450),
            ("Cecilia", 0.007656),
            ("Celine", 0.000379),
            ("Charlott", 0.000351),
            ("Charlotta", 0.003093),
            ("Charlotte", 0.003647),
            ("Christel", 0.000572),
            ("Christin", 0.000787),
            ("Christina", 0.012326),
            ("Christine", 0.001486),
            ("Clara", 0.001563),
            ("Claudia", 0.000363),
            ("Cornelia", 0.001234),
            ("Cristina", 0.000544),
            ("Dagmar", 0.000515),
            ("Dagny", 0.000477),
            ("Daniela", 0.000411),
            ("Daniella", 0.000390),
            ("Del", 0.000329),
            ("Denise", 0.000448),
            ("Desirée", 0.000548),
            ("Diana", 0.001097),
            ("Doris", 0.000941),
            ("Ebba", 0.003558),
            ("Edit", 0.000589),
            ("Edith", 0.001119),
            ("Eira", 0.000321),
            ("Eivor", 0.001063),
            ("Elena", 0.000738),
            ("Eleonor", 0.000601),
            ("Eleonora", 0.001382),
            ("Elin", 0.007281),
            ("Elina", 0.001308),
            ("Elinor", 0.000458),
            ("Elisa", 0.000389),
            ("Elisabet", 0.013796),
            ("Elisabeth", 0.024617),
            ("Elise", 0.001787),
            ("Elizabeth", 0.000896),
            ("Ella", 0.002845),
            ("Ellen", 0.003449),
            ("Ellie", 0.000778),
            ("Ellinor", 0.001547),
            ("Elly", 0.000454),
            ("Elma", 0.000294),
            ("Elna", 0.000606),
            ("Elsa", 0.005643),
            ("Else", 0.000294),
            ("Elsie", 0.000950),
            ("Elsy", 0.000405),
            ("Elvira", 0.002178),
            ("Elvy", 0.000392),
            ("Emelie", 0.003381),
            ("Emilia", 0.003444),
            ("Emilie", 0.000371),
            ("Emily", 0.000422),
            ("Emma", 0.008964),
            ("Emmy", 0.000853),
            ("Engla", 0.000378),
            ("Erica", 0.000977),
            ("Erika", 0.003152),
            ("Erna", 0.000286),
            ("Estelle", 0.000322),
            ("Ester", 0.001881),
            ("Esther", 0.000641),
            ("Ethel", 0.000330),
            ("Eva", 0.021862),
            ("Eva-Lena", 0.000401),
            ("Evelina", 0.002218),
            ("Evelyn", 0.000395),
            ("Evy", 0.000887),
            ("Ewa", 0.001347),
            ("Fanny", 0.001265),
            ("Fatima", 0.000796),
            ("Felicia", 0.002700),
            ("Filippa", 0.001352),
            ("Florence", 0.000303),
            ("Fredrika", 0.000796),
            ("Freja", 0.001180),
            ("Frida", 0.003599),
            ("Gabriella", 0.001446),
            ("Gerd", 0.002025),
            ("Gerda", 0.000402),
            ("Gertrud", 0.000928),
            ("Gisela", 0.000294),
            ("Greta", 0.001384),
            ("Gudrun", 0.001447),
            ("Gun", 0.003207),
            ("Gun-Britt", 0.000674),
            ("Gunborg", 0.000689),
            ("Gunhild", 0.000888),
            ("Gunilla", 0.005892),
            ("Gunnel", 0.002305),
            ("Gunvor", 0.001362),
            ("Hanna", 0.005986),
            ("Hannah", 0.000703),
            ("Hannele", 0.000478),
            ("Harriet", 0.000870),
            ("Hassan", 0.000370),
            ("Hedda", 0.000610),
            ("Hedvig", 0.000788),
            ("Heidi", 0.000409),
            ("Helen", 0.002414),
            ("Helena", 0.009521),
            ("Helene", 0.001824),
            ("Helga", 0.000465),
            ("Helén", 0.001026),
            ("Heléne", 0.000609),
            ("Henrietta", 0.000385),
            ("Hilda", 0.001025),
            ("Hillevi", 0.000766),
            ("Hilma", 0.000726),
            ("Hjördis", 0.000384),
            ("Hussein", 0.000306),
            ("Ibrahim", 0.000320),
            ("Ida", 0.006289),
            ("Idun", 0.000275),
            ("Ilona", 0.000318),
            ("Ilse", 0.000273),
            ("Ina", 0.000276),
            ("Ines", 0.000648),
            ("Inez", 0.000930),
            ("Ing-Britt", 0.000343),
            ("Ing-Marie", 0.000537),
            ("Inga", 0.002718),
            ("Inga-Britt", 0.000403),
            ("Inga-Lill", 0.001058),
            ("Ingalill", 0.000694),
            ("Ingeborg", 0.002308),
            ("Ingegerd", 0.003255),
            ("Ingegärd", 0.001608),
            ("Ingela", 0.002281),
            ("Inger", 0.007595),
            ("Ingrid", 0.012833),
            ("Irene", 0.004408),
            ("Iris", 0.001575),
            ("Irma", 0.000949),
            ("Iréne", 0.001284),
            ("Isa", 0.000325),
            ("Isabel", 0.000731),
            ("Isabell", 0.000854),
            ("Isabella", 0.001912),
            ("Isabelle", 0.001963),
            ("Jane", 0.000811),
            ("Janet", 0.000332),
            ("Jasmin", 0.000322),
            ("Jasmine", 0.000613),
            ("Jeanette", 0.001928),
            ("Jennie", 0.001346),
            ("Jennifer", 0.001465),
            ("Jenny", 0.005533),
            ("Jessica", 0.003136),
            ("Jill", 0.000286),
            ("Joanna", 0.000639),
            ("Johanna", 0.008600),
            ("Joline", 0.000384),
            ("Jonna", 0.000681),
            ("Josefin", 0.002565),
            ("Josefina", 0.000998),
            ("Josefine", 0.002224),
            ("Josephine", 0.000611),
            ("Judith", 0.000376),
            ("Julia", 0.004958),
            ("Julie", 0.000380),
            ("Juni", 0.000568),
            ("Kaarina", 0.000478),
            ("Kajsa", 0.001389),
            ("Karin", 0.017304),
            ("Karina", 0.000560),
            ("Karolina", 0.002517),
            ("Katarina", 0.005727),
            ("Katarzyna", 0.000329),
            ("Katharina", 0.000369),
            ("Katja", 0.000335),
            ("Katrin", 0.000593),
            ("Kerstin", 0.009177),
            ("Kim", 0.000576),
            ("Klara", 0.001911),
            ("Kristin", 0.001827),
            ("Kristina", 0.019218),
            ("Kristine", 0.000342),
            ("Laila", 0.001405),
            ("Lara", 0.000284),
            ("Laura", 0.000750),
            ("Lea", 0.000628),
            ("Leah", 0.000578),
            ("Leena", 0.000278),
            ("Leia", 0.000526),
            ("Leila", 0.000443),
            ("Lena", 0.009663),
            ("Leona", 0.000308),
            ("Li", 0.000418),
            ("Liisa", 0.000382),
            ("Lilian", 0.001693),
            ("Lillemor", 0.001130),
            ("Lilly", 0.001914),
            ("Lily", 0.000632),
            ("Lina", 0.002528),
            ("Linda", 0.006146),
            ("Linn", 0.001849),
            ("Linnea", 0.008769),
            ("Linnéa", 0.010510),
            ("Lisa", 0.003817),
            ("Lisbet", 0.000472),
            ("Lisbeth", 0.001988),
            ("Lise-Lott", 0.000275),
            ("Lise-Lotte", 0.000360),
            ("Liselott", 0.000490),
            ("Liselotte", 0.000523),
            ("Liv", 0.001159),
            ("Livia", 0.000579),
            ("Lo", 0.000534),
            ("Lotta", 0.000683),
            ("Louise", 0.006464),
            ("Lova", 0.000754),
            ("Lovis", 0.000328),
            ("Lovisa", 0.004157),
            ("Lucia", 0.000556),
            ("Luna", 0.000559),
            ("Lydia", 0.000486),
            ("Lykke", 0.000476),
            ("Maarit", 0.000296),
            ("Madeleine", 0.002729),
            ("Madelene", 0.000980),
            ("Magdalena", 0.002464),
            ("Maj", 0.001967),
            ("Maj-Britt", 0.000911),
            ("Maj-Lis", 0.000407),
            ("Maja", 0.003334),
            ("Majken", 0.000784),
            ("Majvor", 0.000287),
            ("Malgorzata", 0.000270),
            ("Malin", 0.005829),
            ("Malva", 0.000288),
            ("Margaret", 0.000275),
            ("Margareta", 0.024360),
            ("Margaretha", 0.003317),
            ("Margit", 0.001368),
            ("Margot", 0.000391),
            ("Margret", 0.000268),
            ("Mari", 0.001817),
            ("Maria", 0.051852),
            ("Mariam", 0.000506),
            ("Mariana", 0.000810),
            ("Mariann", 0.000616),
            ("Marianne", 0.008709),
            ("Marie", 0.015282),
            ("Marie-Louise", 0.001157),
            ("Marika", 0.000681),
            ("Marina", 0.001296),
            ("Marit", 0.000276),
            ("Marita", 0.001985),
            ("Marja", 0.000329),
            ("Marjatta", 0.000441),
            ("Marlene", 0.000522),
            ("Marta", 0.000568),
            ("Martina", 0.001555),
            ("Mary", 0.001158),
            ("Maryam", 0.000535),
            ("Mathilda", 0.001100),
            ("Matilda", 0.004321),
            ("Maud", 0.001278),
            ("May", 0.000501),
            ("Maya", 0.000691),
            ("Meja", 0.000527),
            ("Melina", 0.000462),
            ("Melissa", 0.000614),
            ("Mia", 0.001025),
            ("Michaela", 0.000744),
            ("Michelle", 0.000795),
            ("Mikaela", 0.001559),
            ("Mila", 0.000409),
            ("Milla", 0.000274),
            ("Mimmi", 0.000567),
            ("Mina", 0.000293),
            ("Minna", 0.000530),
            ("Mira", 0.000603),
            ("Miranda", 0.000535),
            ("Miriam", 0.000471),
            ("Mirjam", 0.000323),
            ("Moa", 0.002202),
            ("Mohamed", 0.000844),
            ("Mohammed", 0.000566),
            ("Molly", 0.001214),
            ("Mona", 0.002555),
            ("Monica", 0.004784),
            ("Monika", 0.002292),
            ("My", 0.001265),
            ("Märta", 0.002804),
            ("Märtha", 0.000319),
            ("Nadia", 0.000387),
            ("Nadja", 0.000349),
            ("Nancy", 0.000376),
            ("Nanna", 0.000296),
            ("Natalia", 0.000483),
            ("Natalie", 0.000928),
            ("Nathalie", 0.001592),
            ("Nellie", 0.001027),
            ("Nelly", 0.000578),
            ("Nicole", 0.000944),
            ("Nina", 0.001970),
            ("Nora", 0.001197),
            ("Nour", 0.000283),
            ("Nova", 0.001132),
            ("Olga", 0.000613),
            ("Olivia", 0.003357),
            ("Ottilia", 0.000387),
            ("Patricia", 0.000816),
            ("Paula", 0.000726),
            ("Paulina", 0.000964),
            ("Pauline", 0.000423),
            ("Pernilla", 0.002158),
            ("Petra", 0.001815),
            ("Pia", 0.002707),
            ("Ragnhild", 0.000651),
            ("Rebecca", 0.001856),
            ("Rebecka", 0.001777),
            ("Regina", 0.000526),
            ("Renée", 0.000277),
            ("Rigmor", 0.000366),
            ("Rita", 0.000533),
            ("Ronja", 0.000880),
            ("Rosa", 0.000482),
            ("Rose", 0.000418),
            ("Rose-Marie", 0.001020),
            ("Rosita", 0.000312),
            ("Rut", 0.001986),
            ("Ruth", 0.001790),
            ("Sabina", 0.000822),
            ("Saga", 0.002219),
            ("Sally", 0.000595),
            ("Samira", 0.000329),
            ("Sandra", 0.003644),
            ("Sanna", 0.001309),
            ("Sara", 0.007990),
            ("Sarah", 0.001064),
            ("Selma", 0.001525),
            ("Signe", 0.002671),
            ("Sigrid", 0.001842),
            ("Simone", 0.000416),
            ("Siri", 0.001162),
            ("Siv", 0.003702),
            ("Sofi", 0.000574),
            ("Sofia", 0.011084),
            ("Sofie", 0.003631),
            ("Solveig", 0.001808),
            ("Sonia", 0.000285),
            ("Sonja", 0.002359),
            ("Sophia", 0.000768),
            ("Sophie", 0.000926),
            ("Stella", 0.001372),
            ("Stephanie", 0.000404),
            ("Stina", 0.002429),
            ("Susan", 0.000331),
            ("Susann", 0.000470),
            ("Susanna", 0.001526),
            ("Susanne", 0.006000),
            ("Suzanne", 0.000359),
            ("Svea", 0.001409),
            ("Sylvia", 0.000960),
            ("Tanja", 0.000314),
            ("Teresa", 0.000537),
            ("Terese", 0.000712),
            ("Teresia", 0.000892),
            ("Thea", 0.000955),
            ("Theres", 0.000287),
            ("Therese", 0.004216),
            ("Theresia", 0.000469),
            ("Therése", 0.001111),
            ("Thi", 0.000634),
            ("Tilda", 0.000927),
            ("Tilde", 0.000869),
            ("Tina", 0.001056),
            ("Tindra", 0.000829),
            ("Tora", 0.000338),
            ("Tova", 0.000405),
            ("Tove", 0.000971),
            ("Tuulikki", 0.000300),
            ("Tuva", 0.000927),
            ("Tyra", 0.001099),
            ("Ulla", 0.005454),
            ("Ulla-Britt", 0.000882),
            ("Ulrica", 0.000479),
            ("Ulrika", 0.004778),
            ("Valborg", 0.000396),
            ("Valentina", 0.000481),
            ("Vanessa", 0.000515),
            ("Vanja", 0.000513),
            ("Vega", 0.000277),
            ("Vendela", 0.000493),
            ("Vera", 0.001994),
            ("Veronica", 0.001910),
            ("Veronika", 0.000473),
            ("Victoria", 0.003326),
            ("Viktoria", 0.004526),
            ("Vilhelmina", 0.000529),
            ("Vilma", 0.000648),
            ("Viola", 0.005577),
            ("Viveka", 0.000333),
            ("Vivianne", 0.000321),
            ("Wilhelmina", 0.000307),
            ("Wilma", 0.001918),
            ("Yasmin", 0.000286),
            ("Ylva", 0.001264),
            ("Yvonne", 0.003868),
            ("Zahra", 0.000491),
            ("Åsa", 0.004350),
            ("Åse", 0.000397),
        )
    )

    first_names_male = OrderedDict(
        (
            ("Aaron", 0.000273),
            ("Abbas", 0.000313),
            ("Abdi", 0.000412),
            ("Abdirahman", 0.000318),
            ("Abdul", 0.000418),
            ("Abdullah", 0.000462),
            ("Abdullahi", 0.000326),
            ("Adam", 0.003762),
            ("Adnan", 0.000349),
            ("Adrian", 0.001660),
            ("Agne", 0.000400),
            ("Ahmad", 0.001476),
            ("Ahmed", 0.001952),
            ("Alan", 0.000266),
            ("Albert", 0.001255),
            ("Alberto", 0.000235),
            ("Albin", 0.002744),
            ("Alejandro", 0.000267),
            ("Alex", 0.000990),
            ("Alexander", 0.009795),
            ("Alexis", 0.000252),
            ("Alf", 0.002320),
            ("Alfons", 0.000416),
            ("Alfred", 0.002058),
            ("Algot", 0.000653),
            ("Ali", 0.003231),
            ("Allan", 0.002085),
            ("Alvar", 0.000827),
            ("Alve", 0.000289),
            ("Alvin", 0.000773),
            ("Amadeus", 0.000243),
            ("Amin", 0.000282),
            ("Amir", 0.000693),
            ("Anas", 0.000220),
            ("Anders", 0.020522),
            ("Andreas", 0.008256),
            ("Andres", 0.000241),
            ("Andrew", 0.000280),
            ("Andrzej", 0.000287),
            ("André", 0.001527),
            ("Andréas", 0.000291),
            ("Antero", 0.000558),
            ("Anthony", 0.000378),
            ("Anton", 0.004343),
            ("Antonio", 0.000676),
            ("Arne", 0.005777),
            ("Arnold", 0.000498),
            ("Aron", 0.000688),
            ("Arthur", 0.000662),
            ("Artur", 0.000661),
            ("Arvid", 0.002871),
            ("Assar", 0.000265),
            ("Aston", 0.000221),
            ("August", 0.001489),
            ("Axel", 0.006717),
            ("Ben", 0.000319),
            ("Bengt", 0.009296),
            ("Benjamin", 0.001967),
            ("Benny", 0.001130),
            ("Berndt", 0.000338),
            ("Bernhard", 0.000524),
            ("Bernt", 0.001677),
            ("Bert", 0.000665),
            ("Bertil", 0.005907),
            ("Bill", 0.000339),
            ("Billy", 0.000371),
            ("Birger", 0.001644),
            ("Bjarne", 0.000277),
            ("Björn", 0.006852),
            ("Bo", 0.009425),
            ("Boris", 0.000264),
            ("Bror", 0.001796),
            ("Bruno", 0.000529),
            ("Börje", 0.002099),
            ("Carl", 0.015879),
            ("Carl-Johan", 0.000326),
            ("Carlos", 0.000403),
            ("Casper", 0.000797),
            ("Charles", 0.000719),
            ("Charlie", 0.001452),
            ("Christer", 0.006241),
            ("Christian", 0.004402),
            ("Christofer", 0.000343),
            ("Christoffer", 0.002262),
            ("Christopher", 0.001055),
            ("Claes", 0.002372),
            ("Clas", 0.000461),
            ("Colin", 0.000406),
            ("Conny", 0.001551),
            ("Curt", 0.000584),
            ("Dag", 0.000492),
            ("Dan", 0.002496),
            ("Daniel", 0.010147),
            ("Dante", 0.000422),
            ("David", 0.006344),
            ("Dennis", 0.001896),
            ("Dick", 0.000530),
            ("Douglas", 0.000572),
            ("Ebbe", 0.000915),
            ("Eddie", 0.000628),
            ("Edgar", 0.000220),
            ("Edvard", 0.000883),
            ("Edvin", 0.002110),
            ("Edward", 0.000769),
            ("Edwin", 0.000525),
            ("Egon", 0.000539),
            ("Einar", 0.001625),
            ("Elias", 0.003786),
            ("Elis", 0.000906),
            ("Elliot", 0.001271),
            ("Elmer", 0.000251),
            ("Elof", 0.000372),
            ("Elton", 0.000552),
            ("Elvin", 0.000317),
            ("Elvis", 0.000289),
            ("Emanuel", 0.003357),
            ("Emil", 0.006301),
            ("Emilio", 0.000320),
            ("Enar", 0.000278),
            ("Eric", 0.003986),
            ("Erik", 0.032401),
            ("Erland", 0.000832),
            ("Erling", 0.000723),
            ("Ernst", 0.001118),
            ("Eskil", 0.000583),
            ("Eugen", 0.000251),
            ("Evald", 0.000411),
            ("Evert", 0.001602),
            ("Fabian", 0.000729),
            ("Felix", 0.001707),
            ("Ferdinand", 0.000235),
            ("Filip", 0.003200),
            ("Folke", 0.001953),
            ("Frank", 0.001242),
            ("Frans", 0.001201),
            ("Fred", 0.000459),
            ("Fredric", 0.000263),
            ("Fredrik", 0.010720),
            ("Fritz", 0.000313),
            ("Gabriel", 0.002474),
            ("Georg", 0.001924),
            ("George", 0.000780),
            ("Gerhard", 0.000554),
            ("Gert", 0.000965),
            ("Gillis", 0.000220),
            ("Glenn", 0.000609),
            ("Gottfrid", 0.000288),
            ("Greger", 0.000317),
            ("Gunnar", 0.010797),
            ("Gustaf", 0.003906),
            ("Gustav", 0.009303),
            ("Göran", 0.008240),
            ("Gösta", 0.002634),
            ("Göte", 0.001058),
            ("Hamid", 0.000266),
            ("Hampus", 0.001492),
            ("Hamza", 0.000304),
            ("Hannes", 0.000804),
            ("Hans", 0.012544),
            ("Harald", 0.001547),
            ("Harry", 0.002438),
            ("Hasan", 0.000455),
            ("Hassan", 0.000984),
            ("Helge", 0.001028),
            ("Helmer", 0.000491),
            ("Henning", 0.000927),
            ("Henric", 0.000347),
            ("Henrik", 0.006764),
            ("Henry", 0.002499),
            ("Herbert", 0.000567),
            ("Herman", 0.000956),
            ("Hilding", 0.000578),
            ("Hjalmar", 0.001146),
            ("Holger", 0.000983),
            ("Hugo", 0.003867),
            ("Hussein", 0.000775),
            ("Håkan", 0.005705),
            ("Ian", 0.000321),
            ("Ibrahim", 0.001173),
            ("Inge", 0.001754),
            ("Ingemar", 0.005694),
            ("Ingmar", 0.000698),
            ("Ingvar", 0.003646),
            ("Isaac", 0.000248),
            ("Isac", 0.000588),
            ("Isak", 0.001921),
            ("Ismail", 0.000355),
            ("Ivan", 0.001344),
            ("Ivar", 0.002279),
            ("Jack", 0.001067),
            ("Jacob", 0.001663),
            ("Jakob", 0.001717),
            ("Jamal", 0.000253),
            ("James", 0.000901),
            ("Jan", 0.013697),
            ("Jan-Erik", 0.000724),
            ("Jan-Olof", 0.000383),
            ("Jan-Åke", 0.000251),
            ("Jari", 0.000267),
            ("Jarl", 0.000368),
            ("Jean", 0.000346),
            ("Jens", 0.002036),
            ("Jerker", 0.000292),
            ("Jerry", 0.000643),
            ("Jesper", 0.002373),
            ("Jim", 0.000697),
            ("Jimmie", 0.000238),
            ("Jimmy", 0.001978),
            ("Joachim", 0.000617),
            ("Joacim", 0.000407),
            ("Joakim", 0.004417),
            ("Joel", 0.002406),
            ("Johan", 0.019352),
            ("Johannes", 0.003621),
            ("John", 0.007684),
            ("Johnny", 0.001309),
            ("Jon", 0.000733),
            ("Jonas", 0.006796),
            ("Jonatan", 0.000895),
            ("Jonathan", 0.002685),
            ("Jonny", 0.001117),
            ("Jose", 0.000220),
            ("Josef", 0.001312),
            ("Joseph", 0.000486),
            ("José", 0.000261),
            ("Juan", 0.000311),
            ("Juhani", 0.000978),
            ("Julian", 0.000606),
            ("Julius", 0.000844),
            ("Junior", 0.000328),
            ("Jörgen", 0.003116),
            ("Kai", 0.000232),
            ("Kaj", 0.000627),
            ("Kalevi", 0.000331),
            ("Kalle", 0.000423),
            ("Kari", 0.000258),
            ("Karim", 0.000284),
            ("Karl", 0.022011),
            ("Karl-Erik", 0.000439),
            ("Kasper", 0.000380),
            ("Kennet", 0.000529),
            ("Kenneth", 0.002848),
            ("Kenny", 0.000345),
            ("Kent", 0.003337),
            ("Kenth", 0.000581),
            ("Kevin", 0.001685),
            ("Khaled", 0.000403),
            ("Khalid", 0.000250),
            ("Kian", 0.000309),
            ("Kim", 0.001372),
            ("Kjell", 0.005442),
            ("Klas", 0.001469),
            ("Knut", 0.001557),
            ("Konrad", 0.000325),
            ("Krister", 0.001868),
            ("Kristian", 0.001698),
            ("Kristofer", 0.000494),
            ("Kristoffer", 0.001512),
            ("Krzysztof", 0.000305),
            ("Kumar", 0.000238),
            ("Kurt", 0.002236),
            ("Lage", 0.000216),
            ("Lars", 0.024802),
            ("Lars-Erik", 0.000679),
            ("Lars-Göran", 0.000466),
            ("Lars-Olof", 0.000289),
            ("Lars-Åke", 0.000334),
            ("Lasse", 0.000278),
            ("Leif", 0.006716),
            ("Lennart", 0.011350),
            ("Leo", 0.002393),
            ("Leon", 0.001287),
            ("Leonard", 0.000800),
            ("Leonardo", 0.000234),
            ("Leopold", 0.000272),
            ("Levi", 0.000412),
            ("Liam", 0.002057),
            ("Linus", 0.002757),
            ("Loke", 0.000636),
            ("Loui", 0.000278),
            ("Louie", 0.000273),
            ("Louis", 0.000273),
            ("Love", 0.001194),
            ("Lowe", 0.000263),
            ("Lucas", 0.001952),
            ("Ludvig", 0.002036),
            ("Ludwig", 0.000874),
            ("Luis", 0.000371),
            ("Lukas", 0.001683),
            ("Magnus", 0.008230),
            ("Mahdi", 0.000281),
            ("Mahmoud", 0.000610),
            ("Malte", 0.001148),
            ("Manfred", 0.000345),
            ("Manuel", 0.000334),
            ("Marcin", 0.000236),
            ("Marco", 0.000257),
            ("Marcus", 0.004288),
            ("Marek", 0.000234),
            ("Mario", 0.000323),
            ("Mark", 0.000325),
            ("Marko", 0.000330),
            ("Markus", 0.002111),
            ("Martin", 0.008193),
            ("Matheo", 0.000250),
            ("Mathias", 0.001640),
            ("Matias", 0.000283),
            ("Mats", 0.007088),
            ("Matteo", 0.000330),
            ("Matti", 0.000405),
            ("Mattias", 0.005588),
            ("Matts", 0.000227),
            ("Mauritz", 0.000538),
            ("Max", 0.002422),
            ("Maximilian", 0.000624),
            ("Mehmet", 0.000221),
            ("Melker", 0.001059),
            ("Melvin", 0.000968),
            ("Melwin", 0.000310),
            ("Micael", 0.000587),
            ("Michael", 0.004774),
            ("Michal", 0.000231),
            ("Michel", 0.000323),
            ("Miguel", 0.000241),
            ("Mika", 0.000225),
            ("Mikael", 0.014597),
            ("Milan", 0.000280),
            ("Milo", 0.000576),
            ("Milton", 0.000566),
            ("Mio", 0.000365),
            ("Mohamad", 0.000995),
            ("Mohamed", 0.002142),
            ("Mohammad", 0.001974),
            ("Mohammed", 0.001743),
            ("Morgan", 0.001222),
            ("Muhammad", 0.000677),
            ("Mustafa", 0.000727),
            ("Måns", 0.000684),
            ("Mårten", 0.000645),
            ("Natanael", 0.000272),
            ("Neo", 0.000514),
            ("Nicholas", 0.000362),
            ("Nicklas", 0.001137),
            ("Niclas", 0.001543),
            ("Nicolas", 0.000375),
            ("Niklas", 0.003501),
            ("Nikola", 0.000227),
            ("Nils", 0.015519),
            ("Noa", 0.000217),
            ("Noah", 0.001539),
            ("Noel", 0.000890),
            ("Ola", 0.002294),
            ("Olav", 0.000218),
            ("Olavi", 0.000547),
            ("Ole", 0.000229),
            ("Oliver", 0.002808),
            ("Oliwer", 0.000253),
            ("Olle", 0.002717),
            ("Olof", 0.012025),
            ("Olov", 0.003594),
            ("Omar", 0.001037),
            ("Oscar", 0.004540),
            ("Oskar", 0.005082),
            ("Osman", 0.000339),
            ("Ossian", 0.000417),
            ("Otto", 0.001634),
            ("Ove", 0.003120),
            ("Owe", 0.000327),
            ("Patric", 0.000406),
            ("Patrick", 0.000791),
            ("Patrik", 0.004666),
            ("Paul", 0.002075),
            ("Pawel", 0.000308),
            ("Peder", 0.000659),
            ("Pekka", 0.000237),
            ("Pelle", 0.000364),
            ("Per", 0.018031),
            ("Per-Erik", 0.000378),
            ("Per-Olof", 0.000512),
            ("Peter", 0.012580),
            ("Petter", 0.001144),
            ("Philip", 0.002050),
            ("Pierre", 0.001002),
            ("Piotr", 0.000427),
            ("Pontus", 0.001825),
            ("Pär", 0.001882),
            ("Rafael", 0.000302),
            ("Ragnar", 0.001635),
            ("Ralf", 0.000402),
            ("Ralph", 0.000221),
            ("Rasmus", 0.002126),
            ("Raymond", 0.000253),
            ("Reine", 0.000234),
            ("Reinhold", 0.000458),
            ("Reza", 0.000473),
            ("Richard", 0.001983),
            ("Rickard", 0.002477),
            ("Rikard", 0.001124),
            ("Robert", 0.006260),
            ("Roberto", 0.000225),
            ("Robin", 0.003330),
            ("Roger", 0.004124),
            ("Roland", 0.004299),
            ("Rolf", 0.005100),
            ("Ronald", 0.000256),
            ("Ronnie", 0.000417),
            ("Ronny", 0.001230),
            ("Roy", 0.000512),
            ("Ruben", 0.000562),
            ("Rudolf", 0.000328),
            ("Rune", 0.002796),
            ("Said", 0.000453),
            ("Saleh", 0.000218),
            ("Sam", 0.001044),
            ("Sami", 0.000435),
            ("Samir", 0.000398),
            ("Samuel", 0.002443),
            ("Sebastian", 0.004364),
            ("Seth", 0.000312),
            ("Sigfrid", 0.000312),
            ("Sigge", 0.000602),
            ("Sigurd", 0.000471),
            ("Sigvard", 0.001041),
            ("Simon", 0.004479),
            ("Sivert", 0.000249),
            ("Sixten", 0.001457),
            ("Sonny", 0.000344),
            ("Staffan", 0.001302),
            ("Stefan", 0.008105),
            ("Stellan", 0.000453),
            ("Sten", 0.002342),
            ("Stig", 0.005104),
            ("Sture", 0.001358),
            ("Sune", 0.001284),
            ("Svante", 0.000955),
            ("Sven", 0.010617),
            ("Sven-Erik", 0.000376),
            ("Sven-Olof", 0.000221),
            ("Sören", 0.001636),
            ("Tage", 0.001640),
            ("Tapani", 0.000391),
            ("Tapio", 0.000312),
            ("Ted", 0.000719),
            ("Teodor", 0.000636),
            ("Theo", 0.001239),
            ("Theodor", 0.001268),
            ("Thomas", 0.006897),
            ("Thor", 0.000377),
            ("Thore", 0.000259),
            ("Thure", 0.000295),
            ("Tim", 0.001212),
            ("Timo", 0.000223),
            ("Tobias", 0.003625),
            ("Tom", 0.001059),
            ("Tomas", 0.003809),
            ("Tomasz", 0.000289),
            ("Tommy", 0.004554),
            ("Toni", 0.000220),
            ("Tony", 0.001667),
            ("Tor", 0.000617),
            ("Torbjörn", 0.002283),
            ("Tord", 0.000988),
            ("Tore", 0.001554),
            ("Torgny", 0.000499),
            ("Torsten", 0.001458),
            ("Tristan", 0.000221),
            ("Ture", 0.000873),
            ("Ulf", 0.006815),
            ("Ulrik", 0.000288),
            ("Uno", 0.001029),
            ("Urban", 0.001217),
            ("Valdemar", 0.001371),
            ("Valentin", 0.001042),
            ("Valter", 0.001241),
            ("Verner", 0.000523),
            ("Victor", 0.002379),
            ("Vidar", 0.000743),
            ("Vide", 0.000345),
            ("Viggo", 0.000988),
            ("Viking", 0.000532),
            ("Viktor", 0.003799),
            ("Vilgot", 0.000446),
            ("Vilhelm", 0.002303),
            ("Ville", 0.000433),
            ("Vilmer", 0.000330),
            ("Vincent", 0.001816),
            ("Waldemar", 0.000397),
            ("Walter", 0.000931),
            ("Werner", 0.000261),
            ("Wilhelm", 0.002871),
            ("Wille", 0.000275),
            ("William", 0.005564),
            ("Willy", 0.000434),
            ("Wilmer", 0.000534),
            ("Yngve", 0.001416),
            ("Yousef", 0.000308),
            ("Yusuf", 0.000321),
            ("Åke", 0.008156),
            ("Örjan", 0.000613),
            ("Östen", 0.000362),
        )
    )

    first_names = first_names_male.copy()
    first_names.update(first_names_female)

    last_names = OrderedDict(
        (
            ("Abbas", 0.000488),
            ("Abdi", 0.001225),
            ("Abdullah", 0.000551),
            ("Abrahamsson", 0.001998),
            ("Adolfsson", 0.001604),
            ("Ahlberg", 0.000872),
            ("Ahlgren", 0.000861),
            ("Ahlin", 0.000609),
            ("Ahlqvist", 0.000616),
            ("Ahlström", 0.001032),
            ("Ahmad", 0.001023),
            ("Ahmadi", 0.000921),
            ("Ahmed", 0.002943),
            ("Alexandersson", 0.000913),
            ("Alfredsson", 0.000935),
            ("Ali", 0.004060),
            ("Alm", 0.001399),
            ("Almgren", 0.000579),
            ("Almqvist", 0.000863),
            ("Anderberg", 0.000541),
            ("Andersen", 0.001066),
            ("Andersson", 0.050317),
            ("Andreasson", 0.001849),
            ("Andrén", 0.000787),
            ("Antonsson", 0.000764),
            ("Aronsson", 0.001422),
            ("Arvidsson", 0.002861),
            ("Asp", 0.000730),
            ("Asplund", 0.001103),
            ("Augustsson", 0.000979),
            ("Axelsson", 0.004888),
            ("Backlund", 0.000896),
            ("Backman", 0.000957),
            ("Bengtsson", 0.007000),
            ("Berg", 0.004777),
            ("Bergdahl", 0.000487),
            ("Berggren", 0.002593),
            ("Bergkvist", 0.000852),
            ("Berglund", 0.004363),
            ("Bergman", 0.003326),
            ("Bergqvist", 0.001890),
            ("Bergsten", 0.000582),
            ("Bergstrand", 0.000534),
            ("Bergström", 0.004867),
            ("Bergvall", 0.000548),
            ("Berntsson", 0.000984),
            ("Bertilsson", 0.000898),
            ("Björk", 0.003130),
            ("Björklund", 0.002640),
            ("Björkman", 0.001610),
            ("Blixt", 0.000709),
            ("Blom", 0.002153),
            ("Blomberg", 0.001388),
            ("Blomgren", 0.000722),
            ("Blomkvist", 0.000497),
            ("Blomqvist", 0.002051),
            ("Bodin", 0.000720),
            ("Bohlin", 0.000666),
            ("Bohman", 0.000503),
            ("Bolin", 0.000612),
            ("Boman", 0.001171),
            ("Borg", 0.001885),
            ("Borgström", 0.000631),
            ("Boström", 0.001687),
            ("Brandt", 0.001121),
            ("Brink", 0.000501),
            ("Broberg", 0.000794),
            ("Brodin", 0.000613),
            ("Brolin", 0.000551),
            ("Broman", 0.000737),
            ("Brännström", 0.000676),
            ("Burman", 0.000661),
            ("Bylund", 0.000601),
            ("Byström", 0.000924),
            ("Bäck", 0.000856),
            ("Bäckman", 0.000939),
            ("Bäckström", 0.001705),
            ("Börjesson", 0.001568),
            ("Carlberg", 0.000521),
            ("Carlson", 0.000583),
            ("Carlsson", 0.007093),
            ("Chen", 0.000555),
            ("Christensen", 0.000762),
            ("Claesson", 0.001471),
            ("Dahl", 0.002055),
            ("Dahlberg", 0.002239),
            ("Dahlgren", 0.001421),
            ("Dahlin", 0.001116),
            ("Dahlqvist", 0.000949),
            ("Dahlström", 0.001410),
            ("Dahlén", 0.000525),
            ("Danielsson", 0.003335),
            ("Davidsson", 0.001723),
            ("Edberg", 0.000550),
            ("Edin", 0.000618),
            ("Edlund", 0.001516),
            ("Edman", 0.000612),
            ("Edström", 0.001014),
            ("Edvardsson", 0.000862),
            ("Einarsson", 0.000618),
            ("Ek", 0.002203),
            ("Ekberg", 0.001172),
            ("Ekdahl", 0.000670),
            ("Ekelund", 0.000717),
            ("Ekholm", 0.000840),
            ("Eklund", 0.003541),
            ("Eklöf", 0.000727),
            ("Ekman", 0.001816),
            ("Ekstrand", 0.000766),
            ("Ekström", 0.002406),
            ("Eliasson", 0.002587),
            ("Elofsson", 0.000570),
            ("Emanuelsson", 0.000812),
            ("Emilsson", 0.000492),
            ("Engberg", 0.000727),
            ("Engdahl", 0.000748),
            ("Englund", 0.001828),
            ("Engman", 0.000809),
            ("Engström", 0.003639),
            ("Engvall", 0.000525),
            ("Ericson", 0.000845),
            ("Ericsson", 0.001421),
            ("Eriksson", 0.028017),
            ("Erlandsson", 0.001527),
            ("Fagerström", 0.000494),
            ("Falk", 0.002234),
            ("Farah", 0.000524),
            ("Ferm", 0.000527),
            ("Flink", 0.000517),
            ("Folkesson", 0.000563),
            ("Fors", 0.001060),
            ("Forsberg", 0.003822),
            ("Forsell", 0.000599),
            ("Forsgren", 0.000615),
            ("Forslund", 0.001029),
            ("Forsman", 0.000935),
            ("Frank", 0.000681),
            ("Fransson", 0.002975),
            ("Franzén", 0.001505),
            ("Fredriksson", 0.003919),
            ("Friberg", 0.001715),
            ("Frid", 0.000522),
            ("Frisk", 0.001002),
            ("Gabrielsson", 0.000704),
            ("Gashi", 0.000506),
            ("Grahn", 0.001012),
            ("Granath", 0.000674),
            ("Granberg", 0.000881),
            ("Granlund", 0.000621),
            ("Granström", 0.000658),
            ("Green", 0.000736),
            ("Gren", 0.000529),
            ("Grönlund", 0.000524),
            ("Gullberg", 0.000487),
            ("Gunnarsson", 0.003164),
            ("Gustafsson", 0.014569),
            ("Gustavsson", 0.005205),
            ("Göransson", 0.001786),
            ("Hagberg", 0.000925),
            ("Haglund", 0.001481),
            ("Hagman", 0.000901),
            ("Hagström", 0.001212),
            ("Hall", 0.001005),
            ("Hallberg", 0.001804),
            ("Hallgren", 0.000846),
            ("Hallin", 0.000720),
            ("Halvarsson", 0.000575),
            ("Hammar", 0.000854),
            ("Hammarström", 0.000719),
            ("Hanna", 0.000823),
            ("Hansen", 0.001914),
            ("Hansson", 0.008987),
            ("Haraldsson", 0.000638),
            ("Hasan", 0.000775),
            ("Hassan", 0.002012),
            ("Hedberg", 0.001695),
            ("Hedin", 0.001081),
            ("Hedlund", 0.002288),
            ("Hedman", 0.001284),
            ("Hedström", 0.001241),
            ("Helgesson", 0.000643),
            ("Hellberg", 0.001132),
            ("Hellgren", 0.000801),
            ("Hellman", 0.000875),
            ("Hellström", 0.002141),
            ("Henningsson", 0.000708),
            ("Henriksson", 0.003664),
            ("Hermansson", 0.002318),
            ("Hjalmarsson", 0.001038),
            ("Hjelm", 0.000947),
            ("Hjort", 0.000503),
            ("Holgersson", 0.000799),
            ("Holm", 0.003357),
            ("Holmberg", 0.003028),
            ("Holmgren", 0.002334),
            ("Holmqvist", 0.001361),
            ("Holmström", 0.001657),
            ("Holst", 0.000620),
            ("Hosseini", 0.000553),
            ("Hult", 0.000792),
            ("Hultgren", 0.000727),
            ("Hultman", 0.000744),
            ("Hussein", 0.001442),
            ("Hägg", 0.000790),
            ("Hägglund", 0.000984),
            ("Häggström", 0.000583),
            ("Håkansson", 0.003234),
            ("Högberg", 0.001341),
            ("Höglund", 0.001621),
            ("Ibrahim", 0.002039),
            ("Ingvarsson", 0.000503),
            ("Isaksson", 0.002827),
            ("Ismail", 0.000721),
            ("Israelsson", 0.000619),
            ("Issa", 0.000728),
            ("Ivarsson", 0.001875),
            ("Jacobsson", 0.001207),
            ("Jafari", 0.000493),
            ("Jakobsson", 0.004351),
            ("Jansson", 0.009964),
            ("Jarl", 0.000521),
            ("Jensen", 0.002004),
            ("Jeppsson", 0.000681),
            ("Johannesson", 0.001418),
            ("Johansen", 0.000525),
            ("Johansson", 0.049876),
            ("Johnson", 0.000664),
            ("Johnsson", 0.002873),
            ("Jonasson", 0.001889),
            ("Jonsson", 0.011662),
            ("Josefsson", 0.001719),
            ("Juhlin", 0.000531),
            ("Jönsson", 0.006349),
            ("Jörgensen", 0.000503),
            ("Karlberg", 0.000720),
            ("Karlsson", 0.037073),
            ("Karlström", 0.000885),
            ("Khalil", 0.000488),
            ("Khan", 0.001060),
            ("Kjellberg", 0.000847),
            ("Klasson", 0.000745),
            ("Kling", 0.000570),
            ("Knutsson", 0.001343),
            ("Krantz", 0.000853),
            ("Kristensson", 0.000617),
            ("Kristiansson", 0.000910),
            ("Kristoffersson", 0.000599),
            ("Kvist", 0.000666),
            ("Källström", 0.000578),
            ("Landin", 0.000604),
            ("Landström", 0.000559),
            ("Lantz", 0.000910),
            ("Larsen", 0.000930),
            ("Larsson", 0.025694),
            ("Lennartsson", 0.000886),
            ("Levin", 0.001025),
            ("Li", 0.000645),
            ("Lidström", 0.000539),
            ("Lidén", 0.000687),
            ("Lilja", 0.001697),
            ("Liljegren", 0.000592),
            ("Lind", 0.003811),
            ("Lindahl", 0.001756),
            ("Lindberg", 0.006391),
            ("Lindblad", 0.001218),
            ("Lindblom", 0.001817),
            ("Linde", 0.000681),
            ("Lindell", 0.001370),
            ("Linder", 0.001256),
            ("Lindfors", 0.000623),
            ("Lindgren", 0.005226),
            ("Lindh", 0.001269),
            ("Lindholm", 0.002064),
            ("Lindkvist", 0.001056),
            ("Lindmark", 0.000788),
            ("Lindquist", 0.000580),
            ("Lindqvist", 0.003660),
            ("Lindskog", 0.000662),
            ("Lindström", 0.005711),
            ("Lindvall", 0.000965),
            ("Lindén", 0.001586),
            ("Liu", 0.000484),
            ("Ljung", 0.001217),
            ("Ljungberg", 0.001216),
            ("Ljunggren", 0.000916),
            ("Ljungqvist", 0.000537),
            ("Lund", 0.001893),
            ("Lundberg", 0.004833),
            ("Lundblad", 0.000583),
            ("Lundell", 0.000826),
            ("Lundgren", 0.004680),
            ("Lundh", 0.000669),
            ("Lundholm", 0.000507),
            ("Lundin", 0.003530),
            ("Lundkvist", 0.001018),
            ("Lundmark", 0.001263),
            ("Lundquist", 0.000559),
            ("Lundqvist", 0.003025),
            ("Lundström", 0.002683),
            ("Löf", 0.000558),
            ("Löfgren", 0.002016),
            ("Lönn", 0.000524),
            ("Lövgren", 0.000931),
            ("Magnusson", 0.005757),
            ("Malm", 0.001591),
            ("Malmberg", 0.001160),
            ("Malmgren", 0.000739),
            ("Malmqvist", 0.000776),
            ("Malmström", 0.000903),
            ("Marklund", 0.000972),
            ("Martinsson", 0.002087),
            ("Mattsson", 0.003885),
            ("Melander", 0.000681),
            ("Melin", 0.001481),
            ("Moberg", 0.001491),
            ("Modig", 0.000512),
            ("Mohamed", 0.002454),
            ("Mohammad", 0.000748),
            ("Mohammadi", 0.000812),
            ("Mohammed", 0.001278),
            ("Mohamud", 0.000491),
            ("Molin", 0.001245),
            ("Mustafa", 0.000691),
            ("Månsson", 0.002053),
            ("Mårtensson", 0.002615),
            ("Möller", 0.001852),
            ("Nguyen", 0.001422),
            ("Nielsen", 0.001591),
            ("Niklasson", 0.000900),
            ("Nilsson", 0.034636),
            ("Norberg", 0.001997),
            ("Nord", 0.001297),
            ("Nordberg", 0.000693),
            ("Nordgren", 0.000773),
            ("Nordin", 0.002530),
            ("Nordlander", 0.000544),
            ("Nordlund", 0.000932),
            ("Nordqvist", 0.000946),
            ("Nordström", 0.002816),
            ("Norgren", 0.000581),
            ("Norlin", 0.000520),
            ("Norling", 0.000660),
            ("Norman", 0.001089),
            ("Norrman", 0.000596),
            ("Norén", 0.001486),
            ("Nyberg", 0.002917),
            ("Nygren", 0.001672),
            ("Nylander", 0.000742),
            ("Nylén", 0.000520),
            ("Nyman", 0.001940),
            ("Nyström", 0.003064),
            ("Näslund", 0.001094),
            ("Ohlsson", 0.001144),
            ("Olander", 0.000521),
            ("Olausson", 0.001225),
            ("Olofsson", 0.005180),
            ("Olsen", 0.000674),
            ("Olsson", 0.021540),
            ("Omar", 0.000946),
            ("Oskarsson", 0.001179),
            ("Osman", 0.000917),
            ("Ottosson", 0.001680),
            ("Palm", 0.001916),
            ("Palmgren", 0.000558),
            ("Palmqvist", 0.000823),
            ("Paulsson", 0.001123),
            ("Pedersen", 0.001150),
            ("Persson", 0.021497),
            ("Petersen", 0.000494),
            ("Petersson", 0.005904),
            ("Pettersson", 0.012948),
            ("Pihl", 0.000577),
            ("Pålsson", 0.001234),
            ("Rask", 0.000500),
            ("Rasmussen", 0.000557),
            ("Rehn", 0.000499),
            ("Robertsson", 0.000596),
            ("Roos", 0.001645),
            ("Rosenberg", 0.000571),
            ("Rosengren", 0.000868),
            ("Rosenqvist", 0.000598),
            ("Rosén", 0.001878),
            ("Roth", 0.000527),
            ("Rydberg", 0.000882),
            ("Rydén", 0.000806),
            ("Sahlin", 0.000815),
            ("Said", 0.000723),
            ("Saleh", 0.000658),
            ("Salomonsson", 0.000775),
            ("Samuelsson", 0.003083),
            ("Sandberg", 0.004135),
            ("Sandell", 0.000710),
            ("Sandgren", 0.000712),
            ("Sandin", 0.000826),
            ("Sandström", 0.002540),
            ("Schmidt", 0.000601),
            ("Selin", 0.000498),
            ("Simonsson", 0.000870),
            ("Singh", 0.000791),
            ("Sjöberg", 0.003817),
            ("Sjöblom", 0.000893),
            ("Sjödin", 0.001224),
            ("Sjögren", 0.002256),
            ("Sjöholm", 0.000877),
            ("Sjölander", 0.000611),
            ("Sjölin", 0.000600),
            ("Sjölund", 0.000733),
            ("Sjöstedt", 0.000663),
            ("Sjöstrand", 0.000940),
            ("Sjöström", 0.001764),
            ("Skog", 0.000847),
            ("Skoglund", 0.001678),
            ("Skoog", 0.000707),
            ("Sköld", 0.001275),
            ("Smith", 0.000623),
            ("Stark", 0.000727),
            ("Steen", 0.000537),
            ("Stenberg", 0.001733),
            ("Stenlund", 0.000496),
            ("Stenström", 0.000584),
            ("Storm", 0.000601),
            ("Strand", 0.001764),
            ("Strandberg", 0.001645),
            ("Strid", 0.000751),
            ("Ström", 0.002411),
            ("Strömberg", 0.002108),
            ("Ståhl", 0.001265),
            ("Sundberg", 0.002240),
            ("Sundell", 0.000562),
            ("Sundin", 0.001292),
            ("Sundqvist", 0.001352),
            ("Sundström", 0.001961),
            ("Svahn", 0.000771),
            ("Svanberg", 0.000802),
            ("Svantesson", 0.000524),
            ("Svedberg", 0.000831),
            ("Svensson", 0.020050),
            ("Svärd", 0.001241),
            ("Söderberg", 0.002920),
            ("Södergren", 0.000553),
            ("Söderholm", 0.000652),
            ("Söderlund", 0.001695),
            ("Söderman", 0.000563),
            ("Söderqvist", 0.000690),
            ("Söderström", 0.001939),
            ("Sörensen", 0.000589),
            ("Thor", 0.000493),
            ("Thorén", 0.000819),
            ("Thulin", 0.000594),
            ("Torstensson", 0.000915),
            ("Tran", 0.000748),
            ("Turesson", 0.000539),
            ("Törnqvist", 0.001096),
            ("Vallin", 0.000550),
            ("Vesterlund", 0.000608),
            ("Vestin", 0.000521),
            ("Viberg", 0.000564),
            ("Viklund", 0.001368),
            ("Vikström", 0.001310),
            ("Vilhelmsson", 0.000597),
            ("Wahlberg", 0.000829),
            ("Wahlgren", 0.000553),
            ("Wahlström", 0.001108),
            ("Wall", 0.000891),
            ("Wallgren", 0.000556),
            ("Wallin", 0.003219),
            ("Wallén", 0.000540),
            ("Wang", 0.000723),
            ("Wennberg", 0.000651),
            ("Werner", 0.000629),
            ("Westberg", 0.000822),
            ("Wester", 0.000667),
            ("Westerberg", 0.001035),
            ("Westerlund", 0.001071),
            ("Westin", 0.000927),
            ("Westlund", 0.000574),
            ("Westman", 0.001005),
            ("Wiberg", 0.001096),
            ("Widén", 0.000615),
            ("Wiklund", 0.001296),
            ("Wikström", 0.001628),
            ("Wilhelmsson", 0.000628),
            ("Winberg", 0.000511),
            ("Zetterberg", 0.000539),
            ("Zhang", 0.000593),
            ("Åberg", 0.002406),
            ("Ågren", 0.001078),
            ("Åkerlund", 0.000806),
            ("Åkerman", 0.000500),
            ("Åkesson", 0.001948),
            ("Åsberg", 0.000510),
            ("Åslund", 0.000555),
            ("Åström", 0.001978),
            ("Öberg", 0.002142),
            ("Öhman", 0.001348),
            ("Östberg", 0.000679),
            ("Österberg", 0.000994),
            ("Östling", 0.000563),
            ("Östlund", 0.001400),
            ("Östman", 0.000854),
        )
    )
