// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A filter that identifies the subset of objects to which the replication rule applies. A <code>Filter</code> must specify exactly one <code>Prefix</code>, <code>Tag</code>, or an <code>And</code> child element.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ReplicationRuleFilter {
    /// <p>An object key name prefix that identifies the subset of objects to which the rule applies.</p><important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub prefix: ::std::option::Option<::std::string::String>,
    /// <p>A container for specifying a tag key and value.</p>
    /// <p>The rule applies only to objects that have the tag in their tag set.</p>
    pub tag: ::std::option::Option<crate::types::Tag>,
    /// <p>A container for specifying rule filters. The filters determine the subset of objects to which the rule applies. This element is required only if you specify more than one filter. For example:</p>
    /// <ul>
    /// <li>
    /// <p>If you specify both a <code>Prefix</code> and a <code>Tag</code> filter, wrap these filters in an <code>And</code> tag.</p></li>
    /// <li>
    /// <p>If you specify a filter based on multiple tags, wrap the <code>Tag</code> elements in an <code>And</code> tag.</p></li>
    /// </ul>
    pub and: ::std::option::Option<crate::types::ReplicationRuleAndOperator>,
}
impl ReplicationRuleFilter {
    /// <p>An object key name prefix that identifies the subset of objects to which the rule applies.</p><important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub fn prefix(&self) -> ::std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>A container for specifying a tag key and value.</p>
    /// <p>The rule applies only to objects that have the tag in their tag set.</p>
    pub fn tag(&self) -> ::std::option::Option<&crate::types::Tag> {
        self.tag.as_ref()
    }
    /// <p>A container for specifying rule filters. The filters determine the subset of objects to which the rule applies. This element is required only if you specify more than one filter. For example:</p>
    /// <ul>
    /// <li>
    /// <p>If you specify both a <code>Prefix</code> and a <code>Tag</code> filter, wrap these filters in an <code>And</code> tag.</p></li>
    /// <li>
    /// <p>If you specify a filter based on multiple tags, wrap the <code>Tag</code> elements in an <code>And</code> tag.</p></li>
    /// </ul>
    pub fn and(&self) -> ::std::option::Option<&crate::types::ReplicationRuleAndOperator> {
        self.and.as_ref()
    }
}
impl ReplicationRuleFilter {
    /// Creates a new builder-style object to manufacture [`ReplicationRuleFilter`](crate::types::ReplicationRuleFilter).
    pub fn builder() -> crate::types::builders::ReplicationRuleFilterBuilder {
        crate::types::builders::ReplicationRuleFilterBuilder::default()
    }
}

/// A builder for [`ReplicationRuleFilter`](crate::types::ReplicationRuleFilter).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ReplicationRuleFilterBuilder {
    pub(crate) prefix: ::std::option::Option<::std::string::String>,
    pub(crate) tag: ::std::option::Option<crate::types::Tag>,
    pub(crate) and: ::std::option::Option<crate::types::ReplicationRuleAndOperator>,
}
impl ReplicationRuleFilterBuilder {
    /// <p>An object key name prefix that identifies the subset of objects to which the rule applies.</p><important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub fn prefix(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.prefix = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>An object key name prefix that identifies the subset of objects to which the rule applies.</p><important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub fn set_prefix(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.prefix = input;
        self
    }
    /// <p>An object key name prefix that identifies the subset of objects to which the rule applies.</p><important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub fn get_prefix(&self) -> &::std::option::Option<::std::string::String> {
        &self.prefix
    }
    /// <p>A container for specifying a tag key and value.</p>
    /// <p>The rule applies only to objects that have the tag in their tag set.</p>
    pub fn tag(mut self, input: crate::types::Tag) -> Self {
        self.tag = ::std::option::Option::Some(input);
        self
    }
    /// <p>A container for specifying a tag key and value.</p>
    /// <p>The rule applies only to objects that have the tag in their tag set.</p>
    pub fn set_tag(mut self, input: ::std::option::Option<crate::types::Tag>) -> Self {
        self.tag = input;
        self
    }
    /// <p>A container for specifying a tag key and value.</p>
    /// <p>The rule applies only to objects that have the tag in their tag set.</p>
    pub fn get_tag(&self) -> &::std::option::Option<crate::types::Tag> {
        &self.tag
    }
    /// <p>A container for specifying rule filters. The filters determine the subset of objects to which the rule applies. This element is required only if you specify more than one filter. For example:</p>
    /// <ul>
    /// <li>
    /// <p>If you specify both a <code>Prefix</code> and a <code>Tag</code> filter, wrap these filters in an <code>And</code> tag.</p></li>
    /// <li>
    /// <p>If you specify a filter based on multiple tags, wrap the <code>Tag</code> elements in an <code>And</code> tag.</p></li>
    /// </ul>
    pub fn and(mut self, input: crate::types::ReplicationRuleAndOperator) -> Self {
        self.and = ::std::option::Option::Some(input);
        self
    }
    /// <p>A container for specifying rule filters. The filters determine the subset of objects to which the rule applies. This element is required only if you specify more than one filter. For example:</p>
    /// <ul>
    /// <li>
    /// <p>If you specify both a <code>Prefix</code> and a <code>Tag</code> filter, wrap these filters in an <code>And</code> tag.</p></li>
    /// <li>
    /// <p>If you specify a filter based on multiple tags, wrap the <code>Tag</code> elements in an <code>And</code> tag.</p></li>
    /// </ul>
    pub fn set_and(mut self, input: ::std::option::Option<crate::types::ReplicationRuleAndOperator>) -> Self {
        self.and = input;
        self
    }
    /// <p>A container for specifying rule filters. The filters determine the subset of objects to which the rule applies. This element is required only if you specify more than one filter. For example:</p>
    /// <ul>
    /// <li>
    /// <p>If you specify both a <code>Prefix</code> and a <code>Tag</code> filter, wrap these filters in an <code>And</code> tag.</p></li>
    /// <li>
    /// <p>If you specify a filter based on multiple tags, wrap the <code>Tag</code> elements in an <code>And</code> tag.</p></li>
    /// </ul>
    pub fn get_and(&self) -> &::std::option::Option<crate::types::ReplicationRuleAndOperator> {
        &self.and
    }
    /// Consumes the builder and constructs a [`ReplicationRuleFilter`](crate::types::ReplicationRuleFilter).
    pub fn build(self) -> crate::types::ReplicationRuleFilter {
        crate::types::ReplicationRuleFilter {
            prefix: self.prefix,
            tag: self.tag,
            and: self.and,
        }
    }
}
