/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.stream.Collectors;
import net.sf.jsqlparser.statement.create.index.CreateIndex;
import net.sf.jsqlparser.statement.create.table.Index;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class CreateIndexDeParser
extends AbstractDeParser<CreateIndex> {
    public CreateIndexDeParser(StringBuilder buffer) {
        super(buffer);
    }

    @Override
    public void deParse(CreateIndex createIndex) {
        Index index = createIndex.getIndex();
        this.builder.append("CREATE ");
        if (index.getType() != null) {
            this.builder.append(index.getType());
            this.builder.append(" ");
        }
        this.builder.append("INDEX ");
        if (createIndex.isUsingIfNotExists()) {
            this.builder.append("IF NOT EXISTS ");
        }
        this.builder.append(index.getName());
        String using = index.getUsing();
        if (using != null && createIndex.isIndexTypeBeforeOn()) {
            this.builder.append(" USING ");
            this.builder.append(using);
        }
        this.builder.append(" ON ");
        this.builder.append(createIndex.getTable().getFullyQualifiedName());
        if (using != null && !createIndex.isIndexTypeBeforeOn()) {
            this.builder.append(" USING ");
            this.builder.append(using);
        }
        if (index.getColumnsNames() != null) {
            this.builder.append(" (");
            this.builder.append(index.getColumnWithParams().stream().map(cp -> cp.columnName + (String)(cp.getParams() != null ? " " + String.join((CharSequence)" ", cp.getParams()) : "")).collect(Collectors.joining(", ")));
            this.builder.append(")");
        }
        if (createIndex.getTailParameters() != null) {
            for (String param : createIndex.getTailParameters()) {
                this.builder.append(" ").append(param);
            }
        }
    }
}

