/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.file;

import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.file.FileTypeAction;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.editors.internal.EditorsMessages;

public class FileActionSelectorDialog
extends BaseDialog {
    private final List<FileTypeAction> actions;
    private FileTypeAction selectedAction;

    public FileActionSelectorDialog(@NotNull Shell shell, @NotNull List<FileTypeAction> actions) {
        super(shell, EditorsMessages.dialog_file_type_selector_title, null);
        this.actions = actions;
        this.selectedAction = actions.isEmpty() ? null : actions.getFirst();
    }

    @NotNull
    protected Composite createDialogArea(@NotNull Composite parent) {
        Composite composite = super.createDialogArea(parent);
        for (FileTypeAction action : this.actions) {
            Button radio = new Button(composite, 16);
            radio.setText(action.getLabel());
            radio.setSelection(action == this.selectedAction);
            radio.addSelectionListener(SelectionListener.widgetSelectedAdapter(selectionEvent -> {
                if (radio.getSelection()) {
                    this.selectedAction = action;
                }
            }));
        }
        return composite;
    }

    @Nullable
    public FileTypeAction getSelectedAction() {
        return this.selectedAction;
    }
}

