# Upgrading to 8.0.0

## AfterConfiguration hook

`AfterConfiguration` hook has been removed in 8.0.0.

Use the `InstallPlugin` hook if you need the `configuration` parameter.

```ruby
InstallPlugin do |configuration, registry|
  # configuration is an instance of Cucumber::Configuration defined in
  # lib/cucumber/configuration.rb
  #
  # registry is an instance of Cucumber::Glue::RegistryWrapper defined in
  # lib/cucumber/glue/registry_wrapper.rb
end
```

Use the `BeforeAll` hook if you don't need the `configuration` parameter.

```ruby
BeforeAll do
  # snip
end
```

More information about hooks can be found in [features/docs/writing_support_code/hooks/README.md](../features/docs/writing_support_code/hooks/README.md).

## The wire protocol

The built-in wire protocol has been removed.

The wire protocol is still available by explicitly using the `cucumber-wire` gem.

### Before cucumber 8.0.0

Before cucumber 8.0.0, the wire protocol was automatically installed with cucumber,
and automatically activated when it had detected a `.wire` file.

If you were using cucumber 7.1.0 and did not already migrate your code, you had a
deprecation message.

### With cucumber 8.0.0

If you are not using the wire protocol, you have nothing to do.

If you already have updated your code to remove the deprecation message shown when
using cucumber 7.1.0, you are already up-to-date. Nothing more has to be done.

If you are still using the built-in wire protocol here the step to migrate to cucumber 8.0.0:

- add the gem `cucumber-wire` to your Gemfile alongside the `cucumber` one, and install it:
  ```ruby
  # Gemfile

  # ...

  gem 'cucumber'
  gem 'cucumber-wire'

  # ...

  ```
  ```shell
  bundle install
  ```
- add `require 'cucumber/wire'` in your support code. If you do not have support
  code yet, create a new one. For example `features/support/wire.rb`.
  ```ruby
  # features/support/wire.rb
  require 'cucumber/wire'
  ```

## `Cucumber::Cli::Main` former `stdin` argument

The second argument of `Cucumber::Cli::Main` - which was formerly named `stdin` -
has been removed.

### Before cucumber 8.0.0

You would have used `Cucumber::Cli::Main` with a dummy parameter:

```ruby
Cucumber::Cli::Main.new(
  argument_list,
  nil, # <-- this is a former unused `stdin` parameter
  @stdout,
  @stderr,
  @kernel
).execute!
```

### With cucumber 8.0.0

The argument has been removed from the initializer so the dummy parameter is not
required anymore:

```ruby
Cucumber::Cli::Main.new(
  argument_list,
  @stdout,
  @stderr,
  @kernel
).execute!
```

## DataTable#map_column `strict` argument

The `strict` argument for the `map_column` method has changed to a keyword argument.

### Before 8.0.0

```ruby
table.map_column('column', false) do |value|
end
```

### With cucumber 8.0.0

```ruby
table.map_column('column', strict: false) do |value|
end
```

NB: Both the `#map_column!` variant method and `#map_headers!` sibling method have been removed (as per
the changelog), you should use the non-mutative alternative methods `#map_column` and `#map_headers` instead
