/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_am extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_CA = "ካናዳ";
        final String metaValue_NR = "ናኡሩ";
        final String metaValue_TV = "ቱቫሉ";
        final String metaValue_ar = "ዓረብኛ";
        final String metaValue_ccp = "ቻክማ";
        final String metaValue_cop = "ኮፕቲክ";
        final String metaValue_GR = "ግሪክ";
        final String metaValue_ja = "ጃፓንኛ";
        final String metaValue_ko = "ኮሪያኛ";
        final String metaValue_mn = "ሞንጎሊያኛ";
        final String metaValue_nqo = "ንኮ";
        final String metaValue_or = "ኦዲያ";
        final String metaValue_si = "ሲንሃላ";
        final String metaValue_su = "ሱዳንኛ";
        final String metaValue_syr = "ሲሪያክ";
        final String metaValue_ta = "ታሚል";
        final String metaValue_te = "ተሉጉ";
        final String metaValue_th = "ታይ";
        final String metaValue_vai = "ቫይ";
        final Object[][] data = new Object[][] {
            { "001", "ዓለም" },
            { "002", "አፍሪካ" },
            { "003", "ሰሜን አሜሪካ" },
            { "005", "ደቡብ አሜሪካ" },
            { "009", "ኦሺያንያ" },
            { "011", "ምዕራባዊ አፍሪካ" },
            { "013", "መካከለኛው አሜሪካ" },
            { "014", "ምስራቅ አፍሪካ" },
            { "015", "ሰሜናዊ አፍሪካ" },
            { "017", "መካከለኛው አፍሪካ" },
            { "018", "ደቡባዊ አፍሪካ" },
            { "019", "አሜሪካ" },
            { "021", "ሰሜናዊ አሜሪካ" },
            { "029", "ካሪቢያን" },
            { "030", "ምስራቃዊ እስያ" },
            { "034", "ደቡባዊ እስያ" },
            { "035", "ደቡብ ምስራቅ እስያ" },
            { "039", "ደቡባዊ አውሮፓ" },
            { "053", "አውስትራሌዥያ" },
            { "054", "ሜላኔዥያ" },
            { "057", "የማይክሮኔዥያን ክልል" },
            { "061", "ፖሊኔዥያ" },
            { "142", "እስያ" },
            { "143", "መካከለኛው እስያ" },
            { "145", "ምዕራባዊ እስያ" },
            { "150", "አውሮፓ" },
            { "151", "ምስራቅ አውሮፓ" },
            { "154", "ሰሜናዊ አውሮፓ" },
            { "155", "ምዕራብ አውሮፓ" },
            { "202", "ከሰሃራ በታች አፍሪካ" },
            { "419", "ላቲን አሜሪካ" },
            { "AC", "አሴንሽን ደሴት" },
            { "AD", "አንዶራ" },
            { "AE", "የተባበሩት ዓረብ ኤምሬትስ" },
            { "AF", "አፍጋኒስታን" },
            { "AG", "አንቲጓ እና ባርቡዳ" },
            { "AI", "አንጉይላ" },
            { "AL", "አልባኒያ" },
            { "AM", "አርሜኒያ" },
            { "AO", "አንጐላ" },
            { "AQ", "አንታርክቲካ" },
            { "AR", "አርጀንቲና" },
            { "AS", "የአሜሪካ ሳሞአ" },
            { "AT", "ኦስትሪያ" },
            { "AU", "አውስትራልያ" },
            { "AW", "አሩባ" },
            { "AX", "የአላንድ ደሴቶች" },
            { "AZ", "አዘርባጃን" },
            { "BA", "ቦስኒያ እና ሄርዞጎቪኒያ" },
            { "BB", "ባርቤዶስ" },
            { "BD", "ባንግላዲሽ" },
            { "BE", "ቤልጄም" },
            { "BF", "ቡርኪና ፋሶ" },
            { "BG", "ቡልጋሪያ" },
            { "BH", "ባህሬን" },
            { "BI", "ብሩንዲ" },
            { "BJ", "ቤኒን" },
            { "BL", "ሴንት ባርቴሌሚ" },
            { "BM", "ቤርሙዳ" },
            { "BN", "ብሩኒ" },
            { "BO", "ቦሊቪያ" },
            { "BQ", "የካሪቢያን ኔዘርላንድስ" },
            { "BR", "ብራዚል" },
            { "BS", "ባሃማስ" },
            { "BT", "ቡህታን" },
            { "BV", "ቡቬት ደሴት" },
            { "BW", "ቦትስዋና" },
            { "BY", "ቤላሩስ" },
            { "BZ", "በሊዝ" },
            { "CA", metaValue_CA },
            { "CC", "ኮኮስ(ኬሊንግ) ደሴቶች" },
            { "CD", "ኮንጎ-ኪንሻሳ" },
            { "CF", "ማዕከላዊ አፍሪካ ሪፑብሊክ" },
            { "CG", "ኮንጎ ብራዛቪል" },
            { "CH", "ስዊዘርላንድ" },
            { "CI", "ኮትዲቯር" },
            { "CK", "ኩክ ደሴቶች" },
            { "CL", "ቺሊ" },
            { "CM", "ካሜሩን" },
            { "CN", "ቻይና" },
            { "CO", "ኮሎምቢያ" },
            { "CP", "ክሊፐርቶን ደሴት" },
            { "CQ", "ሳርክ" },
            { "CR", "ኮስታሪካ" },
            { "CU", "ኩባ" },
            { "CV", "ኬፕቨርዴ" },
            { "CW", "ኩራሳዎ" },
            { "CX", "ክሪስማስ ደሴት" },
            { "CY", "ሳይፕረስ" },
            { "CZ", "ቼቺያ" },
            { "DE", "ጀርመን" },
            { "DG", "ዲዬጎ ጋርሲያ" },
            { "DJ", "ጂቡቲ" },
            { "DK", "ዴንማርክ" },
            { "DM", "ዶሚኒካ" },
            { "DO", "ዶመኒካን ሪፑብሊክ" },
            { "DZ", "አልጄሪያ" },
            { "EA", "ሴኡታና ሜሊላ" },
            { "EC", "ኢኳዶር" },
            { "EE", "ኤስቶኒያ" },
            { "EG", "ግብጽ" },
            { "EH", "ምዕራባዊ ሳህራ" },
            { "ER", "ኤርትራ" },
            { "ES", "ስፔን" },
            { "ET", "ኢትዮጵያ" },
            { "EU", "የአውሮፓ ህብረት" },
            { "EZ", "የዩሮ ዞን" },
            { "FI", "ፊንላንድ" },
            { "FJ", "ፊጂ" },
            { "FK", "የፎክላንድ ደሴቶች" },
            { "FM", "ማይክሮኔዢያ" },
            { "FO", "የፋሮ ደሴቶች" },
            { "FR", "ፈረንሳይ" },
            { "GA", "ጋቦን" },
            { "GB", "ዩናይትድ ኪንግደም" },
            { "GD", "ግሬናዳ" },
            { "GE", "ጆርጂያ" },
            { "GF", "የፈረንሳይ ጉዊአና" },
            { "GG", "ጉርነሲ" },
            { "GH", "ጋና" },
            { "GI", "ጂብራልተር" },
            { "GL", "ግሪንላንድ" },
            { "GM", "ጋምቢያ" },
            { "GN", "ጊኒ" },
            { "GP", "ጉዋደሉፕ" },
            { "GQ", "ኢኳቶሪያል ጊኒ" },
            { "GR", metaValue_GR },
            { "GS", "ደቡብ ጆርጂያ እና የደቡብ ሳንድዊች ደሴቶች" },
            { "GT", "ጉዋቲማላ" },
            { "GU", "ጉዋም" },
            { "GW", "ጊኒ-ቢሳው" },
            { "GY", "ጉያና" },
            { "HK", "ሆንግ ኮንግ ልዩ የአስተዳደር ክልል ቻይና" },
            { "HM", "ኽርድ ኣና ማክዶናልድ ደሴቶች" },
            { "HN", "ሆንዱራስ" },
            { "HR", "ክሮኤሽያ" },
            { "HT", "ሀይቲ" },
            { "HU", "ሀንጋሪ" },
            { "IC", "የካናሪ ደሴቶች" },
            { "ID", "ኢንዶኔዢያ" },
            { "IE", "አየርላንድ" },
            { "IL", "እስራኤል" },
            { "IM", "አይል ኦፍ ማን" },
            { "IN", "ህንድ" },
            { "IO", "የብሪታኒያ ህንድ ውቂያኖስ ግዛት" },
            { "IQ", "ኢራቅ" },
            { "IR", "ኢራን" },
            { "IS", "አይስላንድ" },
            { "IT", "ጣሊያን" },
            { "JE", "ጀርዚ" },
            { "JM", "ጃማይካ" },
            { "JO", "ጆርዳን" },
            { "JP", "ጃፓን" },
            { "KE", "ኬንያ" },
            { "KG", "ኪርጊስታን" },
            { "KH", "ካምቦዲያ" },
            { "KI", "ኪሪባቲ" },
            { "KM", "ኮሞሮስ" },
            { "KN", "ቅዱስ ኪትስ እና ኔቪስ" },
            { "KP", "ሰሜን ኮሪያ" },
            { "KR", "ደቡብ ኮሪያ" },
            { "KW", "ኩዌት" },
            { "KY", "ካይማን ደሴቶች" },
            { "KZ", "ካዛኪስታን" },
            { "LA", "ላኦስ" },
            { "LB", "ሊባኖስ" },
            { "LC", "ሴንት ሉቺያ" },
            { "LI", "ሊችተንስታይን" },
            { "LK", "ሲሪላንካ" },
            { "LR", "ላይቤሪያ" },
            { "LS", "ሌሶቶ" },
            { "LT", "ሊቱዌኒያ" },
            { "LU", "ሉክሰምበርግ" },
            { "LV", "ላትቪያ" },
            { "LY", "ሊቢያ" },
            { "MA", "ሞሮኮ" },
            { "MC", "ሞናኮ" },
            { "MD", "ሞልዶቫ" },
            { "ME", "ሞንተኔግሮ" },
            { "MF", "ሴንት ማርቲን" },
            { "MG", "ማዳጋስካር" },
            { "MH", "ማርሻል ደሴቶች" },
            { "MK", "ሰሜን መቄዶንያ" },
            { "ML", "ማሊ" },
            { "MM", "ማይናማር(በርማ)" },
            { "MN", "ሞንጎሊያ" },
            { "MO", "ማካኦ ልዩ የአስተዳደር ክልል ቻይና" },
            { "MP", "የሰሜናዊ ማሪያና ደሴቶች" },
            { "MQ", "ማርቲኒክ" },
            { "MR", "ሞሪቴኒያ" },
            { "MS", "ሞንትሴራት" },
            { "MT", "ማልታ" },
            { "MU", "ሞሪሸስ" },
            { "MV", "ማልዲቭስ" },
            { "MW", "ማላዊ" },
            { "MX", "ሜክሲኮ" },
            { "MY", "ማሌዢያ" },
            { "MZ", "ሞዛምቢክ" },
            { "NA", "ናሚቢያ" },
            { "NC", "ኒው ካሌዶኒያ" },
            { "NE", "ኒጀር" },
            { "NF", "ኖርፎልክ ደሴት" },
            { "NG", "ናይጄሪያ" },
            { "NI", "ኒካራጓ" },
            { "NL", "ኔዘርላንድ" },
            { "NO", "ኖርዌይ" },
            { "NP", "ኔፓል" },
            { "NR", metaValue_NR },
            { "NU", "ኒዌ" },
            { "NZ", "ኒው ዚላንድ" },
            { "OM", "ኦማን" },
            { "PA", "ፓናማ" },
            { "PE", "ፔሩ" },
            { "PF", "የፈረንሳይ ፖሊኔዢያ" },
            { "PG", "ፓፑዋ ኒው ጊኒ" },
            { "PH", "ፊሊፒንስ" },
            { "PK", "ፓኪስታን" },
            { "PL", "ፖላንድ" },
            { "PM", "ሴንት ፒዬር እና ሚኩኤሎን" },
            { "PN", "ፒትካኢርን ደሴቶች" },
            { "PR", "ፑዌርቶ ሪኮ" },
            { "PS", "የፍልስጤም ግዛት" },
            { "PT", "ፖርቱጋል" },
            { "PW", "ፓላው" },
            { "PY", "ፓራጓይ" },
            { "QA", "ኳታር" },
            { "QO", "የኦሺያንያ ዳርቻ" },
            { "RE", "ሪዩኒየን" },
            { "RO", "ሮሜኒያ" },
            { "RS", "ሰርብያ" },
            { "RU", "ሩስያ" },
            { "RW", "ሩዋንዳ" },
            { "SA", "ሳውድአረቢያ" },
            { "SB", "ሰለሞን ደሴቶች" },
            { "SC", "ሲሼልስ" },
            { "SD", "ሱዳን" },
            { "SE", "ስዊድን" },
            { "SG", "ሲንጋፖር" },
            { "SH", "ሴንት ሄለና" },
            { "SI", "ስሎቬኒያ" },
            { "SJ", "ስቫልባርድ እና ጃን ማየን" },
            { "SK", "ስሎቫኪያ" },
            { "SL", "ሴራሊዮን" },
            { "SM", "ሳን ማሪኖ" },
            { "SN", "ሴኔጋል" },
            { "SO", "ሶማሊያ" },
            { "SR", "ሱሪናም" },
            { "SS", "ደቡብ ሱዳን" },
            { "ST", "ሳኦ ቶሜ እና ፕሪንሲፔ" },
            { "SV", "ኤል ሳልቫዶር" },
            { "SX", "ሲንት ማርተን" },
            { "SY", "ሶሪያ" },
            { "SZ", "ኤስዋቲኒ" },
            { "TA", "ትሪስታን ዳ ኩንሃ" },
            { "TC", "የቱርኮችና የካኢኮስ ደሴቶች" },
            { "TD", "ቻድ" },
            { "TF", "የፈረንሳይ ደቡባዊ ግዛቶች" },
            { "TG", "ቶጐ" },
            { "TH", "ታይላንድ" },
            { "TJ", "ታጃኪስታን" },
            { "TK", "ቶክላው" },
            { "TL", "ቲሞር ሌስቴ" },
            { "TM", "ቱርክሜኒስታን" },
            { "TN", "ቱኒዚያ" },
            { "TO", "ቶንጋ" },
            { "TR", "ቱርክ" },
            { "TT", "ትሪናዳድ እና ቶቤጎ" },
            { "TV", metaValue_TV },
            { "TW", "ታይዋን" },
            { "TZ", "ታንዛኒያ" },
            { "UA", "ዩክሬን" },
            { "UG", "ዩጋንዳ" },
            { "UM", "የዩ ኤስ ጠረፍ ላይ ያሉ ደሴቶች" },
            { "UN", "የተባበሩት መንግስታት" },
            { "US", "ዩናይትድ ስቴትስ" },
            { "UY", "ኡራጓይ" },
            { "UZ", "ኡዝቤኪስታን" },
            { "VA", "ቫቲካን ከተማ" },
            { "VC", "ሴንት ቪንሴንት እና ግሬናዲንስ" },
            { "VE", "ቬንዙዌላ" },
            { "VG", "የእንግሊዝ ቨርጂን ደሴቶች" },
            { "VI", "የአሜሪካ ቨርጂን ደሴቶች" },
            { "VN", "ቬትናም" },
            { "VU", "ቫኑአቱ" },
            { "WF", "ዋሊስ እና ፉቱና ደሴቶች" },
            { "WS", "ሳሞአ" },
            { "XA", "የሀሰት ትእምርት" },
            { "XB", "የሀሰት ባለሁለት አቅጣጫ" },
            { "XK", "ኮሶቮ" },
            { "YE", "የመን" },
            { "YT", "ሜይኦቴ" },
            { "ZA", "ደቡብ አፍሪካ" },
            { "ZM", "ዛምቢያ" },
            { "ZW", "ዚምቧቤ" },
            { "ZZ", "ያልታወቀ ክልል" },
            { "aa", "አፋርኛ" },
            { "ab", "አብሐዚኛ" },
            { "ae", "አቬስታን" },
            { "af", "አፍሪካንኛ" },
            { "ak", "አካንኛ" },
            { "am", "አማርኛ" },
            { "an", "አራጎንስ" },
            { "ar", metaValue_ar },
            { "as", "አሳሜዝ" },
            { "av", "አቫሪክ" },
            { "ay", "አያማርኛ" },
            { "az", "አዘርባጃንኛ" },
            { "ba", "ባስኪርኛ" },
            { "be", "ቤላራሻኛ" },
            { "bg", "ቡልጋሪኛ" },
            { "bi", "ቢስላምኛ" },
            { "bm", "ባምባርኛ" },
            { "bn", "ቤንጋሊኛ" },
            { "bo", "ቲቤታንኛ" },
            { "br", "ብሬቶንኛ" },
            { "bs", "ቦስኒያንኛ" },
            { "ca", "ካታላንኛ" },
            { "ce", "ችችን" },
            { "ch", "ቻሞሮ" },
            { "co", "ኮርሲካኛ" },
            { "cr", "ክሪ" },
            { "cs", "ቼክኛ" },
            { "cu", "ቸርች ስላቪክ" },
            { "cv", "ቹቫሽኛ" },
            { "cy", "ዌልሽ" },
            { "da", "ዴኒሽ" },
            { "de", "ጀርመንኛ" },
            { "dv", "ዲቬሂ" },
            { "dz", "ድዞንግኻኛ" },
            { "ee", "ኢዊ" },
            { "el", "ግሪክኛ" },
            { "en", "እንግሊዝኛ" },
            { "eo", "ኤስፐራንቶ" },
            { "es", "ስፓኒሽ" },
            { "et", "ኢስቶኒያንኛ" },
            { "eu", "ባስክኛ" },
            { "fa", "ፐርሺያኛ" },
            { "ff", "ፉላኒኛ" },
            { "fi", "ፊንላንድኛ" },
            { "fj", "ፊጂኛ" },
            { "fo", "ፋሮኛ" },
            { "fr", "ፈረንሳይኛ" },
            { "fy", "ምዕራባዊ ፍሪሲኛ" },
            { "ga", "አየርላንድኛ" },
            { "gd", "የስኮትላንድ ጌይሊክ" },
            { "gl", "ጋሊሺያንኛ" },
            { "gn", "ጓራኒኛ" },
            { "gu", "ጉጃርቲኛ" },
            { "gv", "ማንክስ" },
            { "ha", "ሃውሳኛ" },
            { "he", "ዕብራይስጥ" },
            { "hi", "ሕንድኛ" },
            { "hr", "ክሮሽያንኛ" },
            { "ht", "ሃይትኛ ክሮሌ" },
            { "hu", "ሀንጋሪኛ" },
            { "hy", "አርሜንኛ" },
            { "hz", "ሄሬሮ" },
            { "ia", "ኢንቴርሊንጓ" },
            { "id", "ኢንዶኔዥያኛ" },
            { "ie", "እንተርሊንግወ" },
            { "ig", "ኢግቦኛ" },
            { "ii", "ሲቹዋን ዪ" },
            { "ik", "እኑፒያቅኛ" },
            { "io", "ኢዶ" },
            { "is", "አይስላንድኛ" },
            { "it", "ጣሊያንኛ" },
            { "iu", "እኑክቲቱትኛ" },
            { "ja", metaValue_ja },
            { "jv", "ጃቫኛ" },
            { "ka", "ጆርጂያንኛ" },
            { "kg", "ኮንጎኛ" },
            { "ki", "ኪኩዩ" },
            { "kj", "ኩዋንያማ" },
            { "kk", "ካዛክኛ" },
            { "kl", "ካላሊሱት" },
            { "km", "ክመር" },
            { "kn", metaValue_CA },
            { "ko", metaValue_ko },
            { "kr", "ካኑሪ" },
            { "ks", "ካሽሚርኛ" },
            { "ku", "ኩርድሽ" },
            { "kv", "ኮሚ" },
            { "kw", "ኮርኒሽ" },
            { "ky", "ክይርግይዝ" },
            { "la", "ላቲንኛ" },
            { "lb", "ሉክሰምበርግኛ" },
            { "lg", "ጋንዳኛ" },
            { "li", "ሊምቡርጊሽ" },
            { "ln", "ሊንጋላ" },
            { "lo", "ላኦኛ" },
            { "lt", "ሊቱዌንያኛ" },
            { "lu", "ሉባ-ካታንጋ" },
            { "lv", "ላትቪያኛ" },
            { "mg", "ማላጋስይ" },
            { "mh", "ማርሻሊዝ" },
            { "mi", "ማኦሪ" },
            { "mk", "ሜቄዶንኛ" },
            { "ml", "ማላያላም" },
            { "mn", metaValue_mn },
            { "mr", "ማራቲ" },
            { "ms", "ማላይ" },
            { "mt", "ማልቲዝኛ" },
            { "my", "ቡርማኛ" },
            { "na", metaValue_NR },
            { "nb", "የኖርዌይ ቦክማል" },
            { "nd", "ሰሜን ንዴብሌ" },
            { "ne", "ኔፓሊኛ" },
            { "ng", "ንዶንጋ" },
            { "nl", "ደች" },
            { "nn", "የኖርዌይ ናይኖርስክ" },
            { "no", "ኖርዌይኛ" },
            { "nr", "ደቡብ ንደቤሌ" },
            { "nv", "ናቫጆ" },
            { "ny", "ንያንጃ" },
            { "oc", "ኦሲታን" },
            { "om", "ኦሮሚኛ" },
            { "or", metaValue_or },
            { "os", "ኦሴቲክ" },
            { "pa", "ፑንጃብኛ" },
            { "pl", "ፖሊሽ" },
            { "ps", "ፓሽቶ" },
            { "pt", "ፖርቹጋልኛ" },
            { "qu", "ኩዌቹዋ" },
            { "rm", "ሮማንሽ" },
            { "rn", "ሩንዲ" },
            { "ro", "ሮማኒያኛ" },
            { "ru", "ራሽያኛ" },
            { "rw", "ኪንያርዋንዳ" },
            { "sa", "ሳንስክሪት" },
            { "sc", "ሳርዲንያን" },
            { "sd", "ሲንዲ" },
            { "se", "ሰሜናዊ ሳሚ" },
            { "sg", "ሳንጎ" },
            { "sh", "ሰርቦ-ክሮኤሽያኛ" },
            { "si", metaValue_si },
            { "sk", "ስሎቫክኛ" },
            { "sl", "ስሎቬንኛ" },
            { "sm", "ሳሞኣን" },
            { "sn", "ሾና" },
            { "so", "ሱማልኛ" },
            { "sq", "አልባንያንኛ" },
            { "sr", "ሰርብያኛ" },
            { "ss", "ስዋቲ" },
            { "st", "ደቡባዊ ሶቶ" },
            { "su", metaValue_su },
            { "sv", "ስዊድንኛ" },
            { "sw", "ስዋሂሊኛ" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "ታጂክ" },
            { "th", metaValue_th },
            { "ti", "ትግርኛ" },
            { "tk", "ቱርክሜን" },
            { "tl", "ታጋሎገኛ" },
            { "tn", "ጽዋና" },
            { "to", "ቶንጋን" },
            { "tr", "ቱርክኛ" },
            { "ts", "ጾንጋ" },
            { "tt", "ታታር" },
            { "tw", "ትዊኛ" },
            { "ty", "ታሂታንኛ" },
            { "ug", "ኡይግሁር" },
            { "uk", "ዩክሬንኛ" },
            { "ur", "ኡርዱኛ" },
            { "uz", "ኡዝቤክኛ" },
            { "ve", "ቬንዳ" },
            { "vi", "ቪየትናምኛ" },
            { "vo", "ቮላፑክኛ" },
            { "wa", "ዋሎን" },
            { "wo", "ዎሎፍኛ" },
            { "xh", "ዞሳኛ" },
            { "yi", "ይዲሽኛ" },
            { "yo", "ዮሩባዊኛ" },
            { "za", "ዡዋንግኛ" },
            { "zh", "ቻይንኛ" },
            { "zu", "ዙሉኛ" },
            { "ace", "አቻይንኛ" },
            { "ach", "አኮሊኛ" },
            { "ada", "አዳንግሜ" },
            { "ady", "አድይግሄ" },
            { "afh", "አፍሪሂሊ" },
            { "agq", "አገም" },
            { "ain", "አይኑ" },
            { "akk", "አካዲያን" },
            { "akz", "አላባማ" },
            { "ale", "አልዩት" },
            { "alt", "ደቡባዊ አልታይ" },
            { "ann", "ኦቦሎ" },
            { "anp", "አንጊካ" },
            { "arc", "አራማይክ" },
            { "arn", "ማፑቼ" },
            { "aro", "አራኦና" },
            { "arp", "አራፓሆ" },
            { "arq", "የአልጄሪያ ዓረብኛ" },
            { "ars", "ናጅዲ አረብኛ" },
            { "arw", "አራዋክ" },
            { "asa", "አሱ" },
            { "ase", "የአሜሪካ የምልክት ቋንቋ" },
            { "ast", "አስቱሪያንኛ" },
            { "atj", "አቲካምከው" },
            { "awa", "አዋድሂ" },
            { "bal", "ባሉቺ" },
            { "ban", "ባሊኔስ" },
            { "bar", "ባቫሪያን" },
            { "bas", "ባሳ" },
            { "bax", "ባሙን" },
            { "bbc", "ባታካ ቶባ" },
            { "bej", "ቤጃ" },
            { "bem", "ቤምባ" },
            { "bew", "ቤታዊ" },
            { "bez", "ቤና" },
            { "bfd", "ባፉት" },
            { "bfq", "ባዳጋ" },
            { "bgc", "ሃርያንቪኛ" },
            { "bgn", "የምዕራብ ባሎቺ" },
            { "bho", "ቦጅፑሪ" },
            { "bik", "ቢኮል" },
            { "bin", "ቢኒ" },
            { "bjn", "ባንጃር" },
            { "bla", "ሲክሲካ" },
            { "blo", "አኒኛ" },
            { "bpy", "ቢሹንፑሪያ" },
            { "bqi", "ባክህቲያሪ" },
            { "bra", "ብራጅ" },
            { "brh", "ብራሁዪ" },
            { "brx", "ቦዶ" },
            { "bss", "አኮስ" },
            { "bua", "ቡሪያት" },
            { "bug", "ቡጊኔዝ" },
            { "bum", "ቡሉ" },
            { "byn", "ብሊን" },
            { "cad", "ካዶ" },
            { "car", "ካሪብ" },
            { "cay", "ካዩጋ" },
            { "cch", "አትሳም" },
            { "ccp", metaValue_ccp },
            { "ceb", "ሴብዋኖ" },
            { "cgg", "ቺጋኛ" },
            { "chb", "ቺብቻ" },
            { "chg", "ቻጋታይ" },
            { "chk", "ቹክስ" },
            { "chm", "ማሪ" },
            { "chn", "ቺኑክ ጃርጎን" },
            { "cho", "ቾክታዋ" },
            { "chp", "ቺፔውያን" },
            { "chr", "ቼሮኬኛ" },
            { "chy", "ችዬኔ" },
            { "ckb", "የሶራኒ ኩርድኛ" },
            { "clc", "ቺልኮቲን" },
            { "cop", metaValue_cop },
            { "cps", "ካፒዝኖን" },
            { "crg", "ሚቺፍ" },
            { "crh", "ክሪሚያን ተርኪሽ" },
            { "crj", "ደቡብ ምዕራባዊ ክሪ" },
            { "crk", "ፕላይንስ ክሪ" },
            { "crl", "ሰሜን ምስራቃዊ ክሪ" },
            { "crm", "ሙዝ ክሪ" },
            { "crr", "ካሮሊና አልጎንክዊያን" },
            { "crs", "ሰሰላዊ ክሬኦሊ ፈረንሳይኛ" },
            { "csw", "ስዋምፒ ክሪ" },
            { "dak", "ዳኮታ" },
            { "dar", "ዳርግዋ" },
            { "dav", "ታይታ" },
            { "del", "ዳላዌር" },
            { "dgr", "ዶግሪብ" },
            { "din", "ዲንካ" },
            { "dje", "ዛርማኛ" },
            { "doi", "ዶግሪ" },
            { "dsb", "የታችኛው ሶርቢያኛ" },
            { "dtp", "ሴንተራል ዱሰን" },
            { "dua", "ዱዋላኛ" },
            { "dyo", "ጆላ-ፎንዪ" },
            { "dyu", "ድዩላ" },
            { "dzg", "ዳዛጋ" },
            { "ebu", "ኢምቡ" },
            { "efi", "ኤፊክ" },
            { "egy", "የጥንታዊ ግብጽኛ" },
            { "eka", "ኤካጁክ" },
            { "esu", "ሴንተራል ዩፒክ" },
            { "ewo", "ኤዎንዶ" },
            { "fil", "ፊሊፒንኛ" },
            { "fon", "ፎን" },
            { "frc", "ካጁን ፍሬንች" },
            { "frp", "አርፒታን" },
            { "frr", "ሰሜናዊ ፍሪስያን" },
            { "fur", "ፍሩሊያን" },
            { "gaa", "ጋ" },
            { "gag", "ጋጉዝኛ" },
            { "gan", "ጋን ቻይንኛ" },
            { "gez", "ግዕዝኛ" },
            { "gil", "ጅልበርትስ" },
            { "gor", "ጎሮንታሎ" },
            { "grc", "የጥንታዊ ግሪክ" },
            { "gsw", "ስዊዝ ጀርመንኛ" },
            { "guz", "ጉስሊኛ" },
            { "gwi", "ግዊቺን" },
            { "hai", "ሃይዳ" },
            { "hak", "ሃካ ቻይንኛ" },
            { "haw", "ሃዊያኛ" },
            { "hax", "ደቡባዊ ሃይዳ" },
            { "hil", "ሂሊጋይኖን" },
            { "hmn", "ህሞንግ" },
            { "hsb", "የላይኛው ሶርቢያንኛ" },
            { "hsn", "ዢያንግ ቻይንኛ" },
            { "hup", "ሁፓ" },
            { "hur", "ሃልኮመልም" },
            { "iba", "ኢባን" },
            { "ibb", "ኢቢብዮ" },
            { "ikt", "የምዕራባዊ ካናዳ ኢኑክቲቱት" },
            { "ilo", "ኢሎኮ" },
            { "inh", "ኢንጉሽ" },
            { "jbo", "ሎጅባን" },
            { "jgo", "ንጎምባ" },
            { "jmc", "ማቻሜኛ" },
            { "kab", "ካብይል" },
            { "kac", "ካቺን" },
            { "kaj", "ጅጁ" },
            { "kam", "ካምባ" },
            { "kbd", "ካባርዲያን" },
            { "kcg", "ታያፕ" },
            { "kde", "ማኮንዴ" },
            { "kea", "ካቡቨርዲያኑ" },
            { "kfo", "ኮሮ" },
            { "kgp", "ካይንጋንግ" },
            { "kha", "ካሲ" },
            { "khq", "ኮይራ ቺኒ" },
            { "kkj", "ካኮ" },
            { "kln", "ካለንጂን" },
            { "kmb", "ኪምቡንዱ" },
            { "koi", "ኮሚ ፔርምያክ" },
            { "kok", "ኮንካኒ" },
            { "kpe", "ክፔሌ" },
            { "krc", "ካራቻይ-ባልካር" },
            { "krl", "ካረሊያን" },
            { "kru", "ኩሩክ" },
            { "ksb", "ሻምባላ" },
            { "ksf", "ባፊያ" },
            { "ksh", "ኮሎኝኛ" },
            { "kum", "ኩማይክ" },
            { "kwk", "ክዋክዋላ" },
            { "kxv", "ኩቪኛ" },
            { "lad", "ላዲኖ" },
            { "lag", "ላንጊ" },
            { "lez", "ሌዝጊያን" },
            { "lij", "ሊጓሪያኛ" },
            { "lil", "ሊሎኤት" },
            { "lkt", "ላኮታ" },
            { "lmo", "ሎምባርድኛ" },
            { "lou", "ሉዊዚያና ክሬኦል" },
            { "loz", "ሎዚ" },
            { "lrc", "ሰሜናዊ ሉሪ" },
            { "lsm", "ሳሚያ" },
            { "lua", "ሉባ-ሉሏ" },
            { "lun", "ሉንዳ" },
            { "luo", "ሉኦ" },
            { "lus", "ሚዞ" },
            { "luy", "ሉያ" },
            { "mad", "ማዱረስ" },
            { "mag", "ማጋሂ" },
            { "mai", "ማይቲሊ" },
            { "mak", "ማካሳር" },
            { "mas", "ማሳይ" },
            { "mdf", "ሞክሻ" },
            { "men", "ሜንዴ" },
            { "mer", "ሜሩ" },
            { "mfe", "ሞሪስየን" },
            { "mgh", "ማኩዋ-ሜቶ" },
            { "mgo", "ሜታ" },
            { "mic", "ሚክማው" },
            { "min", "ሚናንግካባኡ" },
            { "mni", "ማኒፑሪ" },
            { "moe", "ኢኑ-አይመን" },
            { "moh", "ሞሃውክ" },
            { "mos", "ሞሲ" },
            { "mua", "ሙንዳንግ" },
            { "mul", "ባለብዙ ቋንቋዎች" },
            { "mus", "ሙስኮኪ" },
            { "mwl", "ሚራንዴዝ" },
            { "myv", "ኤርዝያ" },
            { "mzn", "ማዛንደራኒ" },
            { "nan", "ሚን ኛን ቻይንኛ" },
            { "nap", "ኒአፖሊታን" },
            { "naq", "ናማ" },
            { "nds", "የታችኛው ጀርመንኛ" },
            { "new", "ኒዋሪ(ኔፓል)" },
            { "nia", "ኒአስ" },
            { "niu", "ኒዩአንኛ" },
            { "njo", "ኦ ናጋ" },
            { "nmg", "ክዋሲዮ" },
            { "nnh", "ኒጊምቡን" },
            { "nog", "ኖጋይ" },
            { "nqo", metaValue_nqo },
            { "nso", "ሰሜናዊ ሶቶ" },
            { "nus", "ኑዌር" },
            { "nwc", "ክላሲክ ኔዋሪ" },
            { "nyn", "ኒያንኮል" },
            { "ojb", "ሰሜን ምዕራባዊ ኦጂብዋ" },
            { "ojc", "ማዕከላዊ ኦጂብዋ" },
            { "ojs", "ኦጂ-ክሪ" },
            { "ojw", "ምዕራባዊ ኦጂቡዋ" },
            { "oka", "ኦካናጋን" },
            { "pag", "ፓንጋሲናን" },
            { "pam", "ፓምፓንጋ" },
            { "pap", "ፓፒያሜንቶ" },
            { "pau", "ፓሉዋን" },
            { "pcm", "የናይጄሪያ ፒጂን" },
            { "pis", "ፒጂን" },
            { "pqm", "ማሊሴት-ፓሳማኩዎድይ" },
            { "prg", "ፐሩሳንኛ" },
            { "quc", "ኪቼ" },
            { "qug", "ቺምቦራዞ ሃይላንድ ኩቹዋ" },
            { "raj", "ራጃስታኒ" },
            { "rap", "ራፓኑኢ" },
            { "rar", "ራሮቶንጋን" },
            { "rhg", "ሮሂንግያ" },
            { "rof", "ሮምቦ" },
            { "rup", "አሮማንያን" },
            { "rwk", "ርዋ" },
            { "sad", "ሳንዳዌ" },
            { "sah", "ያኩት" },
            { "saq", "ሳምቡሩ" },
            { "sat", "ሳንታሊ" },
            { "sba", "ንጋምባይ" },
            { "sbp", "ሳንጉ" },
            { "scn", "ሲሲሊያንኛ" },
            { "sco", "ስኮትስ" },
            { "sdh", "ደቡባዊ ኩርዲሽ" },
            { "seh", "ሴና" },
            { "ses", "ኮይራቦሮ ሴኒ" },
            { "shi", "ታቼልሂት" },
            { "shn", "ሻን" },
            { "shu", "ቻዲያን ዓረብኛ" },
            { "sid", "ሲዳምኛ" },
            { "slh", "ደቡባዊ ሉሹትሲድ" },
            { "sma", "ደቡባዊ ሳሚ" },
            { "smj", "ሉሌ ሳሚ" },
            { "smn", "ኢናሪ ሳሚ" },
            { "sms", "ስኮልት ሳሚ" },
            { "snk", "ሶኒንኬ" },
            { "srn", "ስራናን ቶንጎ" },
            { "ssy", "ሳሆኛ" },
            { "str", "ስትሬይትስ ስታሊሽ" },
            { "suk", "ሱኩማ" },
            { "swb", "ኮሞሪያን" },
            { "syc", "ክላሲክ ኔይራ" },
            { "syr", metaValue_syr },
            { "szl", "ሲሌሲያኛ" },
            { "tce", "ደቡባዊ ቱትቾን" },
            { "tem", "ቲምኔ" },
            { "teo", "ቴሶ" },
            { "tet", "ቴተም" },
            { "tgx", "ታጊሽ" },
            { "tht", "ታህልታን" },
            { "tig", "ትግረ" },
            { "tlh", "ክሊንጎን" },
            { "tli", "ትሊንጊት" },
            { "tok", "ቶኪ ፖና" },
            { "tpi", "ቶክ ፒሲን" },
            { "trv", "ታሮኮ" },
            { "ttm", "ሰሜናዊ ቱትቾን" },
            { "tum", "ቱምቡካ" },
            { "tvl", metaValue_TV },
            { "twq", "ታሳዋክ" },
            { "tyv", "ቱቪንያንኛ" },
            { "tzm", "መካከለኛው አትላስ ታማዚኛ" },
            { "udm", "ኡድሙርት" },
            { "umb", "ኡምቡንዱ" },
            { "und", "ያልታወቀ ቋንቋ" },
            { "vai", metaValue_vai },
            { "vec", "ቬነቲያንኛ" },
            { "vmw", "ማክሁዋኛ" },
            { "vun", "ቩንጆ" },
            { "wae", "ዋልሰር" },
            { "wal", "ወላይትኛ" },
            { "war", "ዋራይ" },
            { "wbp", "ዋርልፒሪ" },
            { "wuu", "ዉ ቻይንኛ" },
            { "xal", "ካልማይክ" },
            { "xnr", "ካንጋሪ" },
            { "xog", "ሶጋ" },
            { "yav", "ያንግቤንኛ" },
            { "ybb", "የምባ" },
            { "yrl", "ንሄንጋቱ" },
            { "yue", "ካንቶኒዝ" },
            { "zbl", "ብሊስይምቦልስ" },
            { "zgh", "መደበኛ የሞሮኮ ታማዚግት" },
            { "zun", "ዙኒ" },
            { "zxx", "ቋንቋዊ ይዘት የለውም" },
            { "zza", "ዛዛ" },
            { "Adlm", "አድላም" },
            { "Arab", metaValue_ar },
            { "Aran", "ናስታሊክ" },
            { "Armn", "አርሜንያዊ" },
            { "Beng", "ቤንጋሊ" },
            { "Bopo", "ቦፖሞፎ" },
            { "Brai", "ብሬይል" },
            { "Buhd", "ቡሂድ" },
            { "Cakm", metaValue_ccp },
            { "Cans", "የተዋሐዱ የካናዳ አቦሪጂኖች ፊደላት" },
            { "Cher", "ቼሮኪ" },
            { "Copt", metaValue_cop },
            { "Cprt", "ሲፕሪኦት" },
            { "Cyrl", "ሲይሪልክ" },
            { "Deva", "ደቫንጋሪ" },
            { "Dsrt", "ዴዘረት" },
            { "Ethi", "ኢትዮፒክ" },
            { "Geor", "ጆርጂያኛ" },
            { "Goth", "ጐቲክ" },
            { "Grek", metaValue_GR },
            { "Gujr", "ጉጃራቲ" },
            { "Guru", "ጉርሙኪ" },
            { "Hanb", "ሃን ከቦፖሞፎ ጋር" },
            { "Hang", "ሐንጉል" },
            { "Hani", "ሃን" },
            { "Hano", "ሀኑኦ" },
            { "Hans", "ቀለል ያለ" },
            { "Hant", "ባህላዊ" },
            { "Hebr", "እብራይስጥ" },
            { "Hira", "ሂራጋና" },
            { "Hrkt", "ጃፓንኛ ፊደላት" },
            { "Jamo", "ጃሞ" },
            { "Jpan", metaValue_ja },
            { "Kana", "ካታካና" },
            { "Khmr", "ክህመር" },
            { "Knda", metaValue_CA },
            { "Kore", metaValue_ko },
            { "Laoo", "ላኦ" },
            { "Latn", "ላቲን" },
            { "Limb", "ሊምቡ" },
            { "Lina", "ሊኒያር ኤ" },
            { "Linb", "ሊኒያር ቢ" },
            { "Mlym", "ማላይላም" },
            { "Mong", metaValue_mn },
            { "Mtei", "ሜቴ ማይክ" },
            { "Mymr", "ምያንማር" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "ኦግሀም" },
            { "Olck", "ኦይ ቺኪ" },
            { "Orya", metaValue_or },
            { "Osma", "ኦስማኒያ" },
            { "Rohg", "ሃኒፊ" },
            { "Runr", "ሩኒክ" },
            { "Shaw", "የሻቪያ ፊደል" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Syrc", metaValue_syr },
            { "Tagb", "ትአግባንዋ" },
            { "Tale", "ታኢ ለ" },
            { "Talu", "አዲስ ታኢ ሉ" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "ቲፊናግህ" },
            { "Tglg", "ታጋሎግ" },
            { "Thaa", "ታና" },
            { "Thai", metaValue_th },
            { "Tibt", "ቲቤትኛ" },
            { "Ugar", "ኡጋሪቲክ" },
            { "Vaii", metaValue_vai },
            { "Yiii", "ዪ" },
            { "Zinh", "የተወረሰ" },
            { "Zmth", "የሂሳብ መግለጫ" },
            { "Zsye", "ኢሞጂ" },
            { "Zsym", "ምልክቶች" },
            { "Zxxx", "ያልተጻፈ" },
            { "Zyyy", "የጋራ" },
            { "Zzzz", "ያልታወቀ ፊደል" },
            { "de_AT", "የኦስትሪያ ጀርመንኛ" },
            { "de_CH", "የስዊዝ ከፍተኛ ጀርመንኛ" },
            { "en_AU", "የአውስትራሊያ እንግሊዝኛ" },
            { "en_CA", "የካናዳ እንግሊዝኛ" },
            { "en_GB", "የብሪቲሽ እንግሊዝኛ" },
            { "en_US", "የአሜሪካ እንግሊዝኛ" },
            { "es_ES", "የአውሮፓ ስፓኒሽ" },
            { "es_MX", "የሜክሲኮ ስፓኒሽ" },
            { "fa_AF", "ዳሪ" },
            { "fr_CA", "የካናዳ ፈረንሳይኛ" },
            { "fr_CH", "የስዊዝ ፈረንሳይኛ" },
            { "nl_BE", "ፍሌሚሽ" },
            { "pt_BR", "የብራዚል ፖርቹጋልኛ" },
            { "pt_PT", "የአውሮፓ ፖርቹጋልኛ" },
            { "ro_MD", "ሞልዳቪያንኛ" },
            { "sw_CD", "ኮንጎ ስዋሂሊ" },
            { "ar_001", "ዘመናዊ መደበኛ ዓረብኛ" },
            { "es_419", "የላቲን አሜሪካ ስፓኒሽ" },
            { "key.ca", "የቀን አቆጣጠር" },
            { "key.cf", "የምንዛሪ ቅርጸት" },
            { "key.co", "አቀማመጥ ደርድር" },
            { "key.cu", "ምንዛሪ" },
            { "key.em", "ስሜት ገላጭ ምስል አቀራረብ" },
            { "key.hc", "የሰዓት ዑደት (12 ወይም 24)" },
            { "key.lb", "መስመር መስበሪያ ቅጥ" },
            { "key.lw", "የመስመር መሰባበር በቃላት ውስጥ" },
            { "key.ms", "የመለኪያ ስርዓት" },
            { "key.nu", "ቁጥሮች" },
            { "key.ss", "ከአህጽሮተ ቃል በኋላ የዐረፍተ ነገር መቋረጥ" },
            { "key.tz", "የሰዓት ሰቅ" },
            { "key.va", "የአካባቢ አይነት" },
            { "nds_NL", "የታችኛው ሳክሰን" },
            { "zh_Hans", "ቀለል ያለ ቻይንኛ" },
            { "zh_Hant", "ባህላዊ ቻይንኛ" },
            { "type.ca.roc", "የሚንጉ የቀን አቆጣጠር" },
            { "type.hc.h11", "የ12 ሰዓት ስርዓት (0–11)" },
            { "type.hc.h12", "የ12 ሰዓት ስርዓት (1–12)" },
            { "type.hc.h23", "የ24 ሰዓት ስርዓት (0–23)" },
            { "type.hc.h24", "የ24 ሰዓት ስርዓት (1–24)" },
            { "type.m0.bgn", "ዩኤስ ቢጂኤን ትራንስሊትሬሽን" },
            { "type.nu.arab", "የአረቢክ-ኢንዲክ አሃዞች" },
            { "type.nu.armn", "የአርመንኛ ቁጥሮች" },
            { "type.nu.beng", "የቤንጋሊ አሃዞች" },
            { "type.nu.cakm", "የቻክማ አሃዞች" },
            { "type.nu.deva", "የዴቫንጋሪ አሃዞች" },
            { "type.nu.ethi", "የኢትዮጵያ ቁጥሮች" },
            { "type.nu.geor", "የጆርጂያ ቁጥሮች" },
            { "type.nu.grek", "የግሪክ ቁጥሮች" },
            { "type.nu.gujr", "የጉጃራቲ አሃዞች" },
            { "type.nu.guru", "የጉርሙኪ አሃዞች" },
            { "type.nu.hans", "ቀለል ያሉ የቻይንኛ ቁጥሮች" },
            { "type.nu.hant", "የባህላዊ ቻይንኛ ቁጥሮች" },
            { "type.nu.hebr", "የእብራይስጥ ቁጥሮች" },
            { "type.nu.java", "የጃቫ አሃዞች" },
            { "type.nu.jpan", "የጃፓንኛ ቁጥሮች" },
            { "type.nu.khmr", "የክህመር አሃዞች" },
            { "type.nu.knda", "የካንአዳ አሃዞች" },
            { "type.nu.laoo", "የላኦ አሃዞች" },
            { "type.nu.latn", "ምዕራባዊ አሃዞች" },
            { "type.nu.mlym", "የማላያላምኛ አሃዞች" },
            { "type.nu.mong", "የሞንጎልኛ አሃዞች" },
            { "type.nu.mtei", "ሜቲ ማየክ አሃዞች" },
            { "type.nu.mymr", "የማያንማር አሃዞች" },
            { "type.nu.olck", "ኦይ ቺኪ አሃዞች" },
            { "type.nu.orya", "የኦዲያ አሃዞች" },
            { "type.nu.taml", "ባህላዊ የታሚል ቁጥሮች" },
            { "type.nu.telu", "የተልጉ አሃዞች" },
            { "type.nu.thai", "የታይ አሃዞች" },
            { "type.nu.tibt", "የቲቤት አሃዞች" },
            { "type.nu.vaii", "የቫይ አሃዞች" },
            { "type.ca.dangi", "የዳንጊ የቀን አቆጣጠር" },
            { "type.co.ducet", "የነባሪ ዩኒኮድ የድርድር ቅደም ተከተል" },
            { "type.lb.loose", "ላላ ያለ መስመር መስበሪያ ቅጥ" },
            { "type.nu.roman", "የሮማን ቁጥሮች" },
            { "type.ca.coptic", "የኮፕቲክ የቀን አቆጣጠር" },
            { "type.ca.hebrew", "የእብራዊያን የቀን አቆጣጠር" },
            { "type.ca.indian", "የህንድ ብሔራዊ የቀን አቆጣጠር" },
            { "type.co.pinyin", "ፒንይን የድርድር ቅደም ተከተል" },
            { "type.co.search", "ለጠቅላላ ጉዳይ ፍለጋ" },
            { "type.co.stroke", "የበትር ድርድር ቅደም ተከተል" },
            { "type.co.unihan", "የመሰረታዊ በትር ድርድር ቅደም ተከተል" },
            { "type.d0.fwidth", "ሙሉ ወርድ" },
            { "type.d0.hwidth", "ግማሽ ወርድ" },
            { "type.lb.normal", "መደበኛ መስመር መስበሪያ ቅጥ" },
            { "type.lb.strict", "ጠበቅ ያለ መስመር መስበሪያ ቅጥ" },
            { "type.m0.ungegn", "ዩኤን ጂኢጂኤን ትራንስሊትሬሽን" },
            { "type.ms.metric", "ሜትሪክ ስርዓት" },
            { "type.nu.native", "ሀገር በቀል አሃዞች" },
            { "type.ca.chinese", "የቻይና የቀን አቆጣጠር" },
            { "type.ca.islamic", "የሂጅራ የቀን አቆጣጠር" },
            { "type.ca.iso8601", "ISO-8601 የቀን አቆጣጠር" },
            { "type.ca.persian", "የፐርሽያ የቀን አቆጣጠር" },
            { "type.cf.account", "የሂሳብ ምንዛሪ ቅርጸት" },
            { "type.d0.npinyin", "አሃዛዊ" },
            { "type.nu.arabext", "የተራዘሙ የአረቢክ-ኢንዲክ አሃዞች" },
            { "type.nu.armnlow", "የአሜሪካ ንዑስ ሆሄ አሃዞች" },
            { "type.nu.finance", "የፋይናንስ ቁጥሮች" },
            { "type.nu.greklow", "የግሪክ ንዑስ ሆሄ ቁጥሮች" },
            { "type.nu.hanidec", "የቻይንኛ አስርዮሽ ቁጥሮች" },
            { "type.nu.hansfin", "ቀለል ያሉ የቻይንኛ ገንዘብ ነክ ቁጥሮች" },
            { "type.nu.hantfin", "የባህላዊ ቻይንኛ የገንዘብ ነክ ቁጥሮች" },
            { "type.nu.jpanfin", "የጃፓንኛ የገንዘብ ነክ ቁጥሮች" },
            { "type.nu.tamldec", "የታሚል አሃዞች" },
            { "type.ca.buddhist", "የቡዲስት ቀን አቆጣጠር" },
            { "type.ca.ethiopic", "የኢትዮጵያ የቀን አቆጣጠር" },
            { "type.ca.japanese", "የጃፓን የቀን አቆጣጠር" },
            { "type.cf.standard", "መደበኛ የምንዛሪ ቅርጸት" },
            { "type.co.phonetic", "የፎነቲክ ድርደራ ቅደም ተከተል" },
            { "type.co.searchjl", "በሃንጉል የመጀመሪያ ተነባቢ ፈልግ" },
            { "type.co.standard", "መደበኛ የድርድር ቅደም ተከተል" },
            { "type.ms.uksystem", "ኢምፔሪያል የመለኪያ ስርዓት" },
            { "type.ms.ussystem", "የአሜሪካ መለኪያ ስርዓት" },
            { "type.nu.fullwide", "የሙሉ ወርድ አሃዞች" },
            { "type.nu.romanlow", "የሮማን ንዑስ ሆሄ ቁጥሮች" },
            { "type.ca.gregorian", "የግሪጎሪያን የቀን አቆጣጠር" },
            { "type.co.phonebook", "የስልክ ደብተር ድርድር ቅደም ተከተል" },
            { "ListKeyTypePattern", "{0}፦ {1}" },
            { "type.co.dictionary", "የመዝገበ ቃላት የድርድር ቅደም ተከተል" },
            { "type.co.traditional", "ባህላዊ የድርድር ቅደም ተከተል" },
            { "type.nu.traditional", "ተለምዷዊ ቁጥሮች" },
            { "type.ca.islamic-civil", "የሂጅራ የቀን አቆጣጠር (ታቡላር፣ ሲቪል አፖች)" },
            { "ListCompositionPattern", "{0}፣ {1}" },
            { "type.ca.islamic-umalqura", "የሂጅራ የቀን አቆጣጠር (ኡም አል-ቁራ)" },
            { "type.ca.ethiopic-amete-alem", "የኢትዮፒክ አመተ አለም የቀን አቆጣጠር" },
        };
        return data;
    }
}
