// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Configuration information for a guardrail that you use with the <code>ConverseStream</code> action.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GuardrailStreamConfiguration {
    /// <p>The identifier for the guardrail.</p>
    pub guardrail_identifier: ::std::string::String,
    /// <p>The version of the guardrail.</p>
    pub guardrail_version: ::std::string::String,
    /// <p>The trace behavior for the guardrail.</p>
    pub trace: crate::types::GuardrailTrace,
    /// <p>The processing mode.</p>
    /// <p>The processing mode. For more information, see <i>Configure streaming response behavior</i> in the <i>Amazon Bedrock User Guide</i>.</p>
    pub stream_processing_mode: crate::types::GuardrailStreamProcessingMode,
}
impl GuardrailStreamConfiguration {
    /// <p>The identifier for the guardrail.</p>
    pub fn guardrail_identifier(&self) -> &str {
        use std::ops::Deref;
        self.guardrail_identifier.deref()
    }
    /// <p>The version of the guardrail.</p>
    pub fn guardrail_version(&self) -> &str {
        use std::ops::Deref;
        self.guardrail_version.deref()
    }
    /// <p>The trace behavior for the guardrail.</p>
    pub fn trace(&self) -> &crate::types::GuardrailTrace {
        &self.trace
    }
    /// <p>The processing mode.</p>
    /// <p>The processing mode. For more information, see <i>Configure streaming response behavior</i> in the <i>Amazon Bedrock User Guide</i>.</p>
    pub fn stream_processing_mode(&self) -> &crate::types::GuardrailStreamProcessingMode {
        &self.stream_processing_mode
    }
}
impl GuardrailStreamConfiguration {
    /// Creates a new builder-style object to manufacture [`GuardrailStreamConfiguration`](crate::types::GuardrailStreamConfiguration).
    pub fn builder() -> crate::types::builders::GuardrailStreamConfigurationBuilder {
        crate::types::builders::GuardrailStreamConfigurationBuilder::default()
    }
}

/// A builder for [`GuardrailStreamConfiguration`](crate::types::GuardrailStreamConfiguration).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GuardrailStreamConfigurationBuilder {
    pub(crate) guardrail_identifier: ::std::option::Option<::std::string::String>,
    pub(crate) guardrail_version: ::std::option::Option<::std::string::String>,
    pub(crate) trace: ::std::option::Option<crate::types::GuardrailTrace>,
    pub(crate) stream_processing_mode: ::std::option::Option<crate::types::GuardrailStreamProcessingMode>,
}
impl GuardrailStreamConfigurationBuilder {
    /// <p>The identifier for the guardrail.</p>
    /// This field is required.
    pub fn guardrail_identifier(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.guardrail_identifier = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The identifier for the guardrail.</p>
    pub fn set_guardrail_identifier(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.guardrail_identifier = input;
        self
    }
    /// <p>The identifier for the guardrail.</p>
    pub fn get_guardrail_identifier(&self) -> &::std::option::Option<::std::string::String> {
        &self.guardrail_identifier
    }
    /// <p>The version of the guardrail.</p>
    /// This field is required.
    pub fn guardrail_version(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.guardrail_version = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The version of the guardrail.</p>
    pub fn set_guardrail_version(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.guardrail_version = input;
        self
    }
    /// <p>The version of the guardrail.</p>
    pub fn get_guardrail_version(&self) -> &::std::option::Option<::std::string::String> {
        &self.guardrail_version
    }
    /// <p>The trace behavior for the guardrail.</p>
    pub fn trace(mut self, input: crate::types::GuardrailTrace) -> Self {
        self.trace = ::std::option::Option::Some(input);
        self
    }
    /// <p>The trace behavior for the guardrail.</p>
    pub fn set_trace(mut self, input: ::std::option::Option<crate::types::GuardrailTrace>) -> Self {
        self.trace = input;
        self
    }
    /// <p>The trace behavior for the guardrail.</p>
    pub fn get_trace(&self) -> &::std::option::Option<crate::types::GuardrailTrace> {
        &self.trace
    }
    /// <p>The processing mode.</p>
    /// <p>The processing mode. For more information, see <i>Configure streaming response behavior</i> in the <i>Amazon Bedrock User Guide</i>.</p>
    pub fn stream_processing_mode(mut self, input: crate::types::GuardrailStreamProcessingMode) -> Self {
        self.stream_processing_mode = ::std::option::Option::Some(input);
        self
    }
    /// <p>The processing mode.</p>
    /// <p>The processing mode. For more information, see <i>Configure streaming response behavior</i> in the <i>Amazon Bedrock User Guide</i>.</p>
    pub fn set_stream_processing_mode(mut self, input: ::std::option::Option<crate::types::GuardrailStreamProcessingMode>) -> Self {
        self.stream_processing_mode = input;
        self
    }
    /// <p>The processing mode.</p>
    /// <p>The processing mode. For more information, see <i>Configure streaming response behavior</i> in the <i>Amazon Bedrock User Guide</i>.</p>
    pub fn get_stream_processing_mode(&self) -> &::std::option::Option<crate::types::GuardrailStreamProcessingMode> {
        &self.stream_processing_mode
    }
    /// Consumes the builder and constructs a [`GuardrailStreamConfiguration`](crate::types::GuardrailStreamConfiguration).
    /// This method will fail if any of the following fields are not set:
    /// - [`guardrail_identifier`](crate::types::builders::GuardrailStreamConfigurationBuilder::guardrail_identifier)
    /// - [`guardrail_version`](crate::types::builders::GuardrailStreamConfigurationBuilder::guardrail_version)
    pub fn build(self) -> ::std::result::Result<crate::types::GuardrailStreamConfiguration, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::GuardrailStreamConfiguration {
            guardrail_identifier: self.guardrail_identifier.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "guardrail_identifier",
                    "guardrail_identifier was not specified but it is required when building GuardrailStreamConfiguration",
                )
            })?,
            guardrail_version: self.guardrail_version.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "guardrail_version",
                    "guardrail_version was not specified but it is required when building GuardrailStreamConfiguration",
                )
            })?,
            trace: self.trace.unwrap_or(
                "disabled"
                    .parse::<crate::types::GuardrailTrace>()
                    .expect("static value validated to member"),
            ),
            stream_processing_mode: self.stream_processing_mode.unwrap_or(
                "sync"
                    .parse::<crate::types::GuardrailStreamProcessingMode>()
                    .expect("static value validated to member"),
            ),
        })
    }
}
