// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Indicates that the claims are logically false and contradictory to the established rules or premises.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GuardrailAutomatedReasoningInvalidFinding {
    /// <p>The logical translation of the input that this finding invalidates.</p>
    pub translation: ::std::option::Option<crate::types::GuardrailAutomatedReasoningTranslation>,
    /// <p>The automated reasoning policy rules that contradict the claims in the input.</p>
    pub contradicting_rules: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningRule>>,
    /// <p>Indication of a logic issue with the translation without needing to consider the automated reasoning policy rules.</p>
    pub logic_warning: ::std::option::Option<crate::types::GuardrailAutomatedReasoningLogicWarning>,
}
impl GuardrailAutomatedReasoningInvalidFinding {
    /// <p>The logical translation of the input that this finding invalidates.</p>
    pub fn translation(&self) -> ::std::option::Option<&crate::types::GuardrailAutomatedReasoningTranslation> {
        self.translation.as_ref()
    }
    /// <p>The automated reasoning policy rules that contradict the claims in the input.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.contradicting_rules.is_none()`.
    pub fn contradicting_rules(&self) -> &[crate::types::GuardrailAutomatedReasoningRule] {
        self.contradicting_rules.as_deref().unwrap_or_default()
    }
    /// <p>Indication of a logic issue with the translation without needing to consider the automated reasoning policy rules.</p>
    pub fn logic_warning(&self) -> ::std::option::Option<&crate::types::GuardrailAutomatedReasoningLogicWarning> {
        self.logic_warning.as_ref()
    }
}
impl GuardrailAutomatedReasoningInvalidFinding {
    /// Creates a new builder-style object to manufacture [`GuardrailAutomatedReasoningInvalidFinding`](crate::types::GuardrailAutomatedReasoningInvalidFinding).
    pub fn builder() -> crate::types::builders::GuardrailAutomatedReasoningInvalidFindingBuilder {
        crate::types::builders::GuardrailAutomatedReasoningInvalidFindingBuilder::default()
    }
}

/// A builder for [`GuardrailAutomatedReasoningInvalidFinding`](crate::types::GuardrailAutomatedReasoningInvalidFinding).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GuardrailAutomatedReasoningInvalidFindingBuilder {
    pub(crate) translation: ::std::option::Option<crate::types::GuardrailAutomatedReasoningTranslation>,
    pub(crate) contradicting_rules: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningRule>>,
    pub(crate) logic_warning: ::std::option::Option<crate::types::GuardrailAutomatedReasoningLogicWarning>,
}
impl GuardrailAutomatedReasoningInvalidFindingBuilder {
    /// <p>The logical translation of the input that this finding invalidates.</p>
    pub fn translation(mut self, input: crate::types::GuardrailAutomatedReasoningTranslation) -> Self {
        self.translation = ::std::option::Option::Some(input);
        self
    }
    /// <p>The logical translation of the input that this finding invalidates.</p>
    pub fn set_translation(mut self, input: ::std::option::Option<crate::types::GuardrailAutomatedReasoningTranslation>) -> Self {
        self.translation = input;
        self
    }
    /// <p>The logical translation of the input that this finding invalidates.</p>
    pub fn get_translation(&self) -> &::std::option::Option<crate::types::GuardrailAutomatedReasoningTranslation> {
        &self.translation
    }
    /// Appends an item to `contradicting_rules`.
    ///
    /// To override the contents of this collection use [`set_contradicting_rules`](Self::set_contradicting_rules).
    ///
    /// <p>The automated reasoning policy rules that contradict the claims in the input.</p>
    pub fn contradicting_rules(mut self, input: crate::types::GuardrailAutomatedReasoningRule) -> Self {
        let mut v = self.contradicting_rules.unwrap_or_default();
        v.push(input);
        self.contradicting_rules = ::std::option::Option::Some(v);
        self
    }
    /// <p>The automated reasoning policy rules that contradict the claims in the input.</p>
    pub fn set_contradicting_rules(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningRule>>) -> Self {
        self.contradicting_rules = input;
        self
    }
    /// <p>The automated reasoning policy rules that contradict the claims in the input.</p>
    pub fn get_contradicting_rules(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningRule>> {
        &self.contradicting_rules
    }
    /// <p>Indication of a logic issue with the translation without needing to consider the automated reasoning policy rules.</p>
    pub fn logic_warning(mut self, input: crate::types::GuardrailAutomatedReasoningLogicWarning) -> Self {
        self.logic_warning = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indication of a logic issue with the translation without needing to consider the automated reasoning policy rules.</p>
    pub fn set_logic_warning(mut self, input: ::std::option::Option<crate::types::GuardrailAutomatedReasoningLogicWarning>) -> Self {
        self.logic_warning = input;
        self
    }
    /// <p>Indication of a logic issue with the translation without needing to consider the automated reasoning policy rules.</p>
    pub fn get_logic_warning(&self) -> &::std::option::Option<crate::types::GuardrailAutomatedReasoningLogicWarning> {
        &self.logic_warning
    }
    /// Consumes the builder and constructs a [`GuardrailAutomatedReasoningInvalidFinding`](crate::types::GuardrailAutomatedReasoningInvalidFinding).
    pub fn build(self) -> crate::types::GuardrailAutomatedReasoningInvalidFinding {
        crate::types::GuardrailAutomatedReasoningInvalidFinding {
            translation: self.translation,
            contradicting_rules: self.contradicting_rules,
            logic_warning: self.logic_warning,
        }
    }
}
