//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package resourcegraph

import original "github.com/Azure/azure-sdk-for-go/services/preview/resourcegraph/mgmt/2021-06-01-preview/resourcegraph"

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AuthorizationScopeFilter = original.AuthorizationScopeFilter

const (
	AtScopeAboveAndBelow AuthorizationScopeFilter = original.AtScopeAboveAndBelow
	AtScopeAndAbove      AuthorizationScopeFilter = original.AtScopeAndAbove
	AtScopeAndBelow      AuthorizationScopeFilter = original.AtScopeAndBelow
	AtScopeExact         AuthorizationScopeFilter = original.AtScopeExact
)

type ColumnDataType = original.ColumnDataType

const (
	Boolean  ColumnDataType = original.Boolean
	Datetime ColumnDataType = original.Datetime
	Integer  ColumnDataType = original.Integer
	Number   ColumnDataType = original.Number
	Object   ColumnDataType = original.Object
	String   ColumnDataType = original.String
)

type FacetSortOrder = original.FacetSortOrder

const (
	Asc  FacetSortOrder = original.Asc
	Desc FacetSortOrder = original.Desc
)

type ResultFormat = original.ResultFormat

const (
	ResultFormatObjectArray ResultFormat = original.ResultFormatObjectArray
	ResultFormatTable       ResultFormat = original.ResultFormatTable
)

type ResultTruncated = original.ResultTruncated

const (
	False ResultTruncated = original.False
	True  ResultTruncated = original.True
)

type ResultType = original.ResultType

const (
	ResultTypeFacet       ResultType = original.ResultTypeFacet
	ResultTypeFacetError  ResultType = original.ResultTypeFacetError
	ResultTypeFacetResult ResultType = original.ResultTypeFacetResult
)

type BaseClient = original.BaseClient
type BasicFacet = original.BasicFacet
type Column = original.Column
type DateTimeInterval = original.DateTimeInterval
type Error = original.Error
type ErrorDetails = original.ErrorDetails
type ErrorResponse = original.ErrorResponse
type Facet = original.Facet
type FacetError = original.FacetError
type FacetRequest = original.FacetRequest
type FacetRequestOptions = original.FacetRequestOptions
type FacetResult = original.FacetResult
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationsClient = original.OperationsClient
type QueryRequest = original.QueryRequest
type QueryRequestOptions = original.QueryRequestOptions
type QueryResponse = original.QueryResponse
type ResourcesHistoryRequest = original.ResourcesHistoryRequest
type ResourcesHistoryRequestOptions = original.ResourcesHistoryRequestOptions
type SetObject = original.SetObject
type Table = original.Table

func New() BaseClient {
	return original.New()
}
func NewOperationsClient() OperationsClient {
	return original.NewOperationsClient()
}
func NewOperationsClientWithBaseURI(baseURI string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI)
}
func NewWithBaseURI(baseURI string) BaseClient {
	return original.NewWithBaseURI(baseURI)
}
func PossibleAuthorizationScopeFilterValues() []AuthorizationScopeFilter {
	return original.PossibleAuthorizationScopeFilterValues()
}
func PossibleColumnDataTypeValues() []ColumnDataType {
	return original.PossibleColumnDataTypeValues()
}
func PossibleFacetSortOrderValues() []FacetSortOrder {
	return original.PossibleFacetSortOrderValues()
}
func PossibleResultFormatValues() []ResultFormat {
	return original.PossibleResultFormatValues()
}
func PossibleResultTruncatedValues() []ResultTruncated {
	return original.PossibleResultTruncatedValues()
}
func PossibleResultTypeValues() []ResultType {
	return original.PossibleResultTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
