/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by mockery v2.53.3. DO NOT EDIT.

package rest

import (
	mock "github.com/stretchr/testify/mock"

	time "time"

	url "net/url"
)

// MockBackoffManager is an autogenerated mock type for the BackoffManager type
type MockBackoffManager struct {
	mock.Mock
}

type MockBackoffManager_Expecter struct {
	mock *mock.Mock
}

func (_m *MockBackoffManager) EXPECT() *MockBackoffManager_Expecter {
	return &MockBackoffManager_Expecter{mock: &_m.Mock}
}

// CalculateBackoff provides a mock function with given fields: actualURL
func (_m *MockBackoffManager) CalculateBackoff(actualURL *url.URL) time.Duration {
	ret := _m.Called(actualURL)

	if len(ret) == 0 {
		panic("no return value specified for CalculateBackoff")
	}

	var r0 time.Duration
	if rf, ok := ret.Get(0).(func(*url.URL) time.Duration); ok {
		r0 = rf(actualURL)
	} else {
		r0 = ret.Get(0).(time.Duration)
	}

	return r0
}

// MockBackoffManager_CalculateBackoff_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'CalculateBackoff'
type MockBackoffManager_CalculateBackoff_Call struct {
	*mock.Call
}

// CalculateBackoff is a helper method to define mock.On call
//   - actualURL *url.URL
func (_e *MockBackoffManager_Expecter) CalculateBackoff(actualURL interface{}) *MockBackoffManager_CalculateBackoff_Call {
	return &MockBackoffManager_CalculateBackoff_Call{Call: _e.mock.On("CalculateBackoff", actualURL)}
}

func (_c *MockBackoffManager_CalculateBackoff_Call) Run(run func(actualURL *url.URL)) *MockBackoffManager_CalculateBackoff_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(*url.URL))
	})
	return _c
}

func (_c *MockBackoffManager_CalculateBackoff_Call) Return(_a0 time.Duration) *MockBackoffManager_CalculateBackoff_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockBackoffManager_CalculateBackoff_Call) RunAndReturn(run func(*url.URL) time.Duration) *MockBackoffManager_CalculateBackoff_Call {
	_c.Call.Return(run)
	return _c
}

// Sleep provides a mock function with given fields: d
func (_m *MockBackoffManager) Sleep(d time.Duration) {
	_m.Called(d)
}

// MockBackoffManager_Sleep_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Sleep'
type MockBackoffManager_Sleep_Call struct {
	*mock.Call
}

// Sleep is a helper method to define mock.On call
//   - d time.Duration
func (_e *MockBackoffManager_Expecter) Sleep(d interface{}) *MockBackoffManager_Sleep_Call {
	return &MockBackoffManager_Sleep_Call{Call: _e.mock.On("Sleep", d)}
}

func (_c *MockBackoffManager_Sleep_Call) Run(run func(d time.Duration)) *MockBackoffManager_Sleep_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(time.Duration))
	})
	return _c
}

func (_c *MockBackoffManager_Sleep_Call) Return() *MockBackoffManager_Sleep_Call {
	_c.Call.Return()
	return _c
}

func (_c *MockBackoffManager_Sleep_Call) RunAndReturn(run func(time.Duration)) *MockBackoffManager_Sleep_Call {
	_c.Run(run)
	return _c
}

// UpdateBackoff provides a mock function with given fields: actualURL, err, responseCode
func (_m *MockBackoffManager) UpdateBackoff(actualURL *url.URL, err error, responseCode int) {
	_m.Called(actualURL, err, responseCode)
}

// MockBackoffManager_UpdateBackoff_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UpdateBackoff'
type MockBackoffManager_UpdateBackoff_Call struct {
	*mock.Call
}

// UpdateBackoff is a helper method to define mock.On call
//   - actualURL *url.URL
//   - err error
//   - responseCode int
func (_e *MockBackoffManager_Expecter) UpdateBackoff(actualURL interface{}, err interface{}, responseCode interface{}) *MockBackoffManager_UpdateBackoff_Call {
	return &MockBackoffManager_UpdateBackoff_Call{Call: _e.mock.On("UpdateBackoff", actualURL, err, responseCode)}
}

func (_c *MockBackoffManager_UpdateBackoff_Call) Run(run func(actualURL *url.URL, err error, responseCode int)) *MockBackoffManager_UpdateBackoff_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(*url.URL), args[1].(error), args[2].(int))
	})
	return _c
}

func (_c *MockBackoffManager_UpdateBackoff_Call) Return() *MockBackoffManager_UpdateBackoff_Call {
	_c.Call.Return()
	return _c
}

func (_c *MockBackoffManager_UpdateBackoff_Call) RunAndReturn(run func(*url.URL, error, int)) *MockBackoffManager_UpdateBackoff_Call {
	_c.Run(run)
	return _c
}

// NewMockBackoffManager creates a new instance of MockBackoffManager. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockBackoffManager(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockBackoffManager {
	mock := &MockBackoffManager{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
