/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resources;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resources.AbstractResourceLockRegistry;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockContainer;
import org.gradle.internal.resources.ResourceLockCoordinationService;

public class LockCache<K, T extends ResourceLock> {
    private final Cache<K, T> resourceLocks = CacheBuilder.newBuilder().weakValues().build();
    private final ResourceLockCoordinationService coordinationService;
    private final ResourceLockContainer owner;

    public LockCache(ResourceLockCoordinationService coordinationService, ResourceLockContainer owner) {
        this.coordinationService = coordinationService;
        this.owner = owner;
    }

    public T getOrRegisterResourceLock(final K key, final AbstractResourceLockRegistry.ResourceLockProducer<K, T> producer) {
        try {
            return (T)((ResourceLock)this.resourceLocks.get(key, new Callable<T>(){

                @Override
                public T call() {
                    return LockCache.this.createResourceLock(key, producer);
                }
            }));
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private T createResourceLock(K key, AbstractResourceLockRegistry.ResourceLockProducer<K, T> producer) {
        return producer.create(key, this.coordinationService, this.owner);
    }

    public Iterable<T> values() {
        return this.resourceLocks.asMap().values();
    }
}

