/*
 * This file is part of the Colobot: Gold Edition source code
 * Copyright (C) 2001-2014, Daniel Roux, EPSITEC SA & TerranovaTeam
 * http://epsitec.ch; http://colobot.info; http://github.com/colobot
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://gnu.org/licenses
 */

// FRAGMENT SHADER - SHADOW MODE
#version 330 core

uniform sampler2D uni_Texture;

uniform bool uni_TextureEnabled;

uniform bool uni_AlphaTestEnabled;
uniform float uni_AlphaReference;

in VertexData
{
    vec2 TexCoord;
} data;

out vec4 out_FragColor;

void main()
{
    float alpha = 1.0f;

    if (uni_TextureEnabled)
    {
        alpha *= texture(uni_Texture, data.TexCoord).a;
    }

    if (uni_AlphaTestEnabled)
    {
        if(alpha < uni_AlphaReference)
            discard;
    }

    out_FragColor = vec4(1.0f);
}
