/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.HashSet;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.ExploreJob;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;
import net.i2p.util.SystemVersion;

class StartExplorersJob
extends JobImpl {
    private final Log _log;
    private final KademliaNetworkDatabaseFacade _facade;
    private static final int MAX_PER_RUN = 1;
    private static final int MIN_RERUN_DELAY_MS = 55000;
    private static final int MAX_RERUN_DELAY_MS = 900000;
    private static final int STARTUP_TIME = 3600000;
    private static final int MIN_ROUTERS = 250;
    private static final int LOW_ROUTERS = 500;
    private static final int MAX_ROUTERS = 1000;
    private static final int LIMIT_ROUTERS = SystemVersion.isSlow() ? 800 : 3000;
    private static final int MIN_FFS = 100;
    static final int LOW_FFS = 200;
    private static final long MAX_LAG = 100L;
    private static final long MAX_MSG_DELAY = 1500L;
    private final long _msgIDBloomXor = RandomSource.getInstance().nextLong(0xFFFFFFFFL);

    public StartExplorersJob(RouterContext context, KademliaNetworkDatabaseFacade facade) {
        super(context);
        this._log = context.logManager().getLog(StartExplorersJob.class);
        this._facade = facade;
    }

    @Override
    public String getName() {
        return "Start Explorers Job";
    }

    @Override
    public void runJob() {
        int count = this._facade.getDataStore().size();
        if (!(this._facade.floodfillEnabled() || this._facade.isClientDb() || count > LIMIT_ROUTERS || this.getContext().jobQueue().getMaxLag() > 100L || this.getContext().throttle().getMessageDelay() > 1500L || this.getContext().router().gracefulShutdownInProgress())) {
            int num = 1;
            if (count < 250) {
                num *= 15;
            } else if (count < 500) {
                num *= 10;
            }
            if (this.getContext().router().getUptime() < 3600000L || this.getContext().router().isHidden()) {
                num *= 2;
            }
            Set<Hash> toExplore = this.selectKeysToExplore(num);
            if (this._log.shouldLog(10)) {
                this._log.debug("Keys to explore during this run: " + toExplore + ", wanted " + num + ", got " + toExplore.size());
            }
            this._facade.removeFromExploreKeys(toExplore);
            long delay = 0L;
            int ffs = this.getContext().peerManager().countPeersByCapability('f');
            boolean needffs = ffs < 100;
            boolean lowffs = ffs < 200;
            for (Hash key : toExplore) {
                boolean realexpl = needffs ? this.getContext().random().nextInt(2) != 0 : (lowffs ? this.getContext().random().nextInt(4) != 0 : this.getContext().random().nextInt(8) != 0);
                ExploreJob j = new ExploreJob(this.getContext(), this._facade, key, realexpl, this._msgIDBloomXor);
                if (delay > 0L) {
                    j.getTiming().setStartAfter(this.getContext().clock().now() + delay);
                }
                this.getContext().jobQueue().addJob(j);
                delay += (long)(1000 + this.getContext().random().nextInt(512));
            }
        }
        long delay = this.getNextRunDelay();
        if (this._log.shouldLog(10)) {
            this._log.debug("Reenqueueing the exploration with a delay of " + delay);
        }
        this.requeue(delay);
    }

    public void updateExploreSchedule() {
    }

    private long getNextRunDelay() {
        if (this._facade.floodfillEnabled()) {
            return 900000L;
        }
        if (this.getContext().router().getUptime() < 3600000L || this._facade.getDataStore().size() < 250 || this.getContext().router().isHidden()) {
            return 55000L;
        }
        RouterInfo ri = this.getContext().router().getRouterInfo();
        if (ri != null && ri.getCapabilities().contains("K")) {
            return 55000L;
        }
        if (this._facade.getDataStore().size() > 1000) {
            return 900000L;
        }
        long delay = this.getContext().clock().now() - this._facade.getLastExploreNewDate();
        if (delay < 55000L) {
            return 55000L;
        }
        if (delay > 900000L) {
            return 900000L;
        }
        return delay;
    }

    private Set<Hash> selectKeysToExplore(int num) {
        Set<Hash> queued = this._facade.getExploreKeys();
        if (this._log.shouldLog(10)) {
            this._log.debug("Keys waiting for exploration: " + queued.size());
        }
        HashSet<Hash> rv = new HashSet<Hash>(num);
        for (Hash key : queued) {
            rv.add(key);
            if (rv.size() < num) continue;
            break;
        }
        for (int i = rv.size(); i < num; ++i) {
            byte[] hash = new byte[32];
            this.getContext().random().nextBytes(hash);
            Hash key = new Hash(hash);
            rv.add(key);
        }
        return rv;
    }
}

