/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.websocket.server.internal;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.ee10.websocket.server.JettyServerUpgradeResponse;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.websocket.api.ExtensionConfig;
import org.eclipse.jetty.websocket.common.JettyExtensionConfig;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeResponse;

public class DelegatedServerUpgradeResponse
implements JettyServerUpgradeResponse {
    private final ServerUpgradeResponse _upgradeResponse;
    private final HttpServletResponse _httpServletResponse;
    private final HttpFields.Mutable _httpFields;

    public DelegatedServerUpgradeResponse(ServerUpgradeResponse response) {
        this._upgradeResponse = response;
        this._httpFields = this._upgradeResponse.getHeaders();
        this._httpServletResponse = (HttpServletResponse)response.getRequest().getAttribute("org.eclipse.jetty.websocket.wrappedResponse");
    }

    @Override
    public void addHeader(String name, String value) {
        this._httpFields.add(name, value);
    }

    @Override
    public void setHeader(String name, String value) {
        this._httpFields.put(name, List.of(value));
    }

    @Override
    public void setHeader(String name, List<String> values) {
        this._httpFields.put(name, values);
    }

    public String getAcceptedSubProtocol() {
        return this._upgradeResponse.getAcceptedSubProtocol();
    }

    public List<ExtensionConfig> getExtensions() {
        return this._upgradeResponse.getExtensions().stream().map(JettyExtensionConfig::new).collect(Collectors.toList());
    }

    public String getHeader(String name) {
        return this._httpFields.get(name);
    }

    public Set<String> getHeaderNames() {
        return this._httpFields.getFieldNamesCollection();
    }

    public Map<String, List<String>> getHeaders() {
        return HttpFields.asMap((HttpFields)this._httpFields);
    }

    public List<String> getHeaders(String name) {
        return this._httpFields.getValuesList(name);
    }

    public int getStatusCode() {
        return this._upgradeResponse.getStatus();
    }

    @Override
    public void sendForbidden(String message) throws IOException {
        this._httpServletResponse.sendError(403, message);
    }

    @Override
    public void setAcceptedSubProtocol(String protocol) {
        this._upgradeResponse.setAcceptedSubProtocol(protocol);
    }

    @Override
    public void setExtensions(List<ExtensionConfig> configs) {
        this._upgradeResponse.setExtensions(configs.stream().map(c -> new org.eclipse.jetty.websocket.core.ExtensionConfig(c.getName(), c.getParameters())).collect(Collectors.toList()));
    }

    @Override
    public void setStatusCode(int statusCode) {
        this._upgradeResponse.setStatus(statusCode);
    }

    @Override
    public boolean isCommitted() {
        return this._upgradeResponse.isCommitted();
    }

    @Override
    public void sendError(int statusCode, String message) throws IOException {
        this._httpServletResponse.sendError(statusCode, message);
    }
}

