/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.internal;

import com.google.api.client.util.Key;
import java.util.List;
import java.util.Map;

public final class TemplateResponse {
    @Key(value="parameters")
    private Map<String, ParameterResponse> parameters;
    @Key(value="conditions")
    private List<ConditionResponse> conditions;
    @Key(value="parameterGroups")
    private Map<String, ParameterGroupResponse> parameterGroups;
    @Key(value="version")
    private VersionResponse version;
    @Key(value="etag")
    private String etag;

    public Map<String, ParameterResponse> getParameters() {
        return this.parameters;
    }

    public List<ConditionResponse> getConditions() {
        return this.conditions;
    }

    public Map<String, ParameterGroupResponse> getParameterGroups() {
        return this.parameterGroups;
    }

    public VersionResponse getVersion() {
        return this.version;
    }

    public String getEtag() {
        return this.etag;
    }

    public TemplateResponse setParameters(Map<String, ParameterResponse> parameters) {
        this.parameters = parameters;
        return this;
    }

    public TemplateResponse setConditions(List<ConditionResponse> conditions) {
        this.conditions = conditions;
        return this;
    }

    public TemplateResponse setParameterGroups(Map<String, ParameterGroupResponse> parameterGroups) {
        this.parameterGroups = parameterGroups;
        return this;
    }

    public TemplateResponse setVersion(VersionResponse version) {
        this.version = version;
        return this;
    }

    public TemplateResponse setEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public static final class ListVersionsResponse {
        @Key(value="versions")
        private List<VersionResponse> versions;
        @Key(value="nextPageToken")
        private String nextPageToken;

        public List<VersionResponse> getVersions() {
            return this.versions;
        }

        public boolean hasVersions() {
            return this.versions != null && !this.versions.isEmpty();
        }

        public String getNextPageToken() {
            return this.nextPageToken;
        }

        public ListVersionsResponse setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public ListVersionsResponse setVersions(List<VersionResponse> versions) {
            this.versions = versions;
            return this;
        }
    }

    public static final class UserResponse {
        @Key(value="email")
        private String email;
        @Key(value="name")
        private String name;
        @Key(value="imageUrl")
        private String imageUrl;

        public String getEmail() {
            return this.email;
        }

        public String getName() {
            return this.name;
        }

        public String getImageUrl() {
            return this.imageUrl;
        }

        public UserResponse setEmail(String email) {
            this.email = email;
            return this;
        }

        public UserResponse setName(String name) {
            this.name = name;
            return this;
        }

        public UserResponse setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }
    }

    public static final class VersionResponse {
        @Key(value="versionNumber")
        private String versionNumber;
        @Key(value="updateTime")
        private String updateTime;
        @Key(value="updateOrigin")
        private String updateOrigin;
        @Key(value="updateType")
        private String updateType;
        @Key(value="updateUser")
        private UserResponse updateUser;
        @Key(value="description")
        private String description;
        @Key(value="rollbackSource")
        private String rollbackSource;
        @Key(value="legacy")
        private Boolean legacy;

        public String getVersionNumber() {
            return this.versionNumber;
        }

        public String getUpdateTime() {
            return this.updateTime;
        }

        public String getUpdateOrigin() {
            return this.updateOrigin;
        }

        public String getUpdateType() {
            return this.updateType;
        }

        public UserResponse getUpdateUser() {
            return this.updateUser;
        }

        public String getDescription() {
            return this.description;
        }

        public String getRollbackSource() {
            return this.rollbackSource;
        }

        public boolean isLegacy() {
            return Boolean.TRUE.equals(this.legacy);
        }

        public VersionResponse setDescription(String description) {
            this.description = description;
            return this;
        }

        public VersionResponse setVersionNumber(String versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public VersionResponse setUpdateTime(String updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public VersionResponse setUpdateOrigin(String updateOrigin) {
            this.updateOrigin = updateOrigin;
            return this;
        }

        public VersionResponse setUpdateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        public VersionResponse setUpdateUser(UserResponse updateUser) {
            this.updateUser = updateUser;
            return this;
        }

        public VersionResponse setRollbackSource(String rollbackSource) {
            this.rollbackSource = rollbackSource;
            return this;
        }

        public VersionResponse setLegacy(Boolean legacy) {
            this.legacy = legacy;
            return this;
        }
    }

    public static final class ParameterGroupResponse {
        @Key(value="description")
        private String description;
        @Key(value="parameters")
        private Map<String, ParameterResponse> parameters;

        public Map<String, ParameterResponse> getParameters() {
            return this.parameters;
        }

        public String getDescription() {
            return this.description;
        }

        public ParameterGroupResponse setParameters(Map<String, ParameterResponse> parameters) {
            this.parameters = parameters;
            return this;
        }

        public ParameterGroupResponse setDescription(String description) {
            this.description = description;
            return this;
        }
    }

    public static final class ConditionResponse {
        @Key(value="name")
        private String name;
        @Key(value="expression")
        private String expression;
        @Key(value="tagColor")
        private String tagColor;

        public String getName() {
            return this.name;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getTagColor() {
            return this.tagColor;
        }

        public ConditionResponse setName(String name) {
            this.name = name;
            return this;
        }

        public ConditionResponse setExpression(String expression) {
            this.expression = expression;
            return this;
        }

        public ConditionResponse setTagColor(String tagColor) {
            this.tagColor = tagColor;
            return this;
        }
    }

    public static final class ParameterValueResponse {
        @Key(value="value")
        private String value;
        @Key(value="useInAppDefault")
        private Boolean useInAppDefault;

        public String getValue() {
            return this.value;
        }

        public boolean isUseInAppDefault() {
            return Boolean.TRUE.equals(this.useInAppDefault);
        }

        public ParameterValueResponse setValue(String value) {
            this.value = value;
            return this;
        }

        public ParameterValueResponse setUseInAppDefault(boolean useInAppDefault) {
            this.useInAppDefault = useInAppDefault;
            return this;
        }
    }

    public static final class ParameterResponse {
        @Key(value="defaultValue")
        private ParameterValueResponse defaultValue;
        @Key(value="description")
        private String description;
        @Key(value="conditionalValues")
        private Map<String, ParameterValueResponse> conditionalValues;
        @Key(value="valueType")
        private String valueType;

        public ParameterValueResponse getDefaultValue() {
            return this.defaultValue;
        }

        public String getDescription() {
            return this.description;
        }

        public Map<String, ParameterValueResponse> getConditionalValues() {
            return this.conditionalValues;
        }

        public String getValueType() {
            return this.valueType;
        }

        public ParameterResponse setDefaultValue(ParameterValueResponse defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public ParameterResponse setDescription(String description) {
            this.description = description;
            return this;
        }

        public ParameterResponse setConditionalValues(Map<String, ParameterValueResponse> conditionalValues) {
            this.conditionalValues = conditionalValues;
            return this;
        }

        public ParameterResponse setValueType(String valueType) {
            this.valueType = valueType;
            return this;
        }
    }
}

