/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 - ivec2(38, 35)) => ivec2(-26, -23)
 * (12 - ivec2(64, -9)) => ivec2(-52, 21)
 * (12 - ivec2(64, 9)) => ivec2(-52, 3)
 * (-6 - ivec2(38, 35)) => ivec2(-44, -41)
 * (-6 - ivec2(64, -9)) => ivec2(-70, 3)
 * (-6 - ivec2(64, 9)) => ivec2(-70, -15)
 * (76 - ivec2(38, 35)) => ivec2(38, 41)
 * (76 - ivec2(64, -9)) => ivec2(12, 85)
 * (76 - ivec2(64, 9)) => ivec2(12, 67)
 * (-32 - ivec2(38, 35)) => ivec2(-70, -67)
 * (-32 - ivec2(64, -9)) => ivec2(-96, -23)
 * (-32 - ivec2(64, 9)) => ivec2(-96, -41)
 * (0 - ivec2(38, 35)) => ivec2(-38, -35)
 * (0 - ivec2(64, -9)) => ivec2(-64, 9)
 * (0 - ivec2(64, 9)) => ivec2(-64, -9)
 */
#version 120

void main()
{
  float[all(equal((12 - ivec2(38, 35)), ivec2(-26, -23))) ? 1 : -1] array0;
  float[all(equal((12 - ivec2(64, -9)), ivec2(-52, 21))) ? 1 : -1] array1;
  float[all(equal((12 - ivec2(64, 9)), ivec2(-52, 3))) ? 1 : -1] array2;
  float[all(equal((-6 - ivec2(38, 35)), ivec2(-44, -41))) ? 1 : -1] array3;
  float[all(equal((-6 - ivec2(64, -9)), ivec2(-70, 3))) ? 1 : -1] array4;
  float[all(equal((-6 - ivec2(64, 9)), ivec2(-70, -15))) ? 1 : -1] array5;
  float[all(equal((76 - ivec2(38, 35)), ivec2(38, 41))) ? 1 : -1] array6;
  float[all(equal((76 - ivec2(64, -9)), ivec2(12, 85))) ? 1 : -1] array7;
  float[all(equal((76 - ivec2(64, 9)), ivec2(12, 67))) ? 1 : -1] array8;
  float[all(equal((-32 - ivec2(38, 35)), ivec2(-70, -67))) ? 1 : -1] array9;
  float[all(equal((-32 - ivec2(64, -9)), ivec2(-96, -23))) ? 1 : -1] array10;
  float[all(equal((-32 - ivec2(64, 9)), ivec2(-96, -41))) ? 1 : -1] array11;
  float[all(equal((0 - ivec2(38, 35)), ivec2(-38, -35))) ? 1 : -1] array12;
  float[all(equal((0 - ivec2(64, -9)), ivec2(-64, 9))) ? 1 : -1] array13;
  float[all(equal((0 - ivec2(64, 9)), ivec2(-64, -9))) ? 1 : -1] array14;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length());
}
