/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.audio.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioManager;
import org.openhab.core.audio.AudioSink;
import org.openhab.core.audio.AudioSource;
import org.openhab.core.io.rest.JSONResponse;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.audio.internal.AudioMapper;
import org.openhab.core.io.rest.audio.internal.AudioSinkDTO;
import org.openhab.core.io.rest.audio.internal.AudioSourceDTO;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

@Path(value="audio")
@RolesAllowed(value={"user", "administrator"})
@Tag(name="audio")
@Component
@JaxrsResource
@JaxrsName(value="audio")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class AudioResource
implements RESTResource {
    public static final String PATH_AUDIO = "audio";
    private final AudioManager audioManager;
    private final LocaleService localeService;

    @Activate
    public AudioResource(@Reference AudioManager audioManager, @Reference LocaleService localeService) {
        this.audioManager = audioManager;
        this.localeService = localeService;
    }

    @GET
    @Path(value="/sources")
    @Produces(value={"application/json"})
    @Operation(operationId="getAudioSources", summary="Get the list of all sources.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=AudioSourceDTO.class)))})})
    public Response getSources(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language) {
        Locale locale = this.localeService.getLocale(language);
        Set sources = this.audioManager.getAllSources();
        ArrayList<AudioSourceDTO> dtos = new ArrayList<AudioSourceDTO>(sources.size());
        for (AudioSource source : sources) {
            dtos.add(AudioMapper.map(source, locale));
        }
        return Response.ok(dtos).build();
    }

    @GET
    @Path(value="/defaultsource")
    @Produces(value={"application/json"})
    @Operation(operationId="getAudioDefaultSource", summary="Get the default source if defined or the first available source.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AudioSourceDTO.class))}), @ApiResponse(responseCode="404", description="Source not found")})
    public Response getDefaultSource(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language) {
        Locale locale = this.localeService.getLocale(language);
        AudioSource source = this.audioManager.getSource();
        if (source != null) {
            return Response.ok((Object)AudioMapper.map(source, locale)).build();
        }
        return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Source not found");
    }

    @GET
    @Path(value="/sinks")
    @Produces(value={"application/json"})
    @Operation(operationId="getAudioSinks", summary="Get the list of all sinks.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=AudioSinkDTO.class)))})})
    public Response getSinks(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language) {
        Locale locale = this.localeService.getLocale(language);
        Set sinks = this.audioManager.getAllSinks();
        ArrayList<AudioSinkDTO> dtos = new ArrayList<AudioSinkDTO>(sinks.size());
        for (AudioSink sink : sinks) {
            dtos.add(AudioMapper.map(sink, locale));
        }
        return Response.ok(dtos).build();
    }

    @GET
    @Path(value="/defaultsink")
    @Produces(value={"application/json"})
    @Operation(operationId="getAudioDefaultSink", summary="Get the default sink if defined or the first available sink.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AudioSinkDTO.class))}), @ApiResponse(responseCode="404", description="Sink not found")})
    public Response getDefaultSink(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language) {
        Locale locale = this.localeService.getLocale(language);
        AudioSink sink = this.audioManager.getSink();
        if (sink != null) {
            return Response.ok((Object)AudioMapper.map(sink, locale)).build();
        }
        return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Sink not found");
    }
}

