/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import gnu.io.CommPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.msg.ModbusMessage;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.util.ModbusUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModbusSerialTransport
implements ModbusTransport {
    private static final Logger logger = LoggerFactory.getLogger(ModbusSerialTransport.class);
    protected CommPort m_CommPort;
    protected boolean m_Echo = false;

    public abstract void prepareStreams(InputStream var1, OutputStream var2) throws IOException;

    @Override
    public abstract ModbusResponse readResponse() throws ModbusIOException;

    @Override
    public abstract ModbusRequest readRequest() throws ModbusIOException;

    @Override
    public abstract void writeMessage(ModbusMessage var1) throws ModbusIOException;

    @Override
    public void close() throws IOException {
        if (this.m_CommPort != null) {
            this.m_CommPort.close();
        }
    }

    public void setCommPort(CommPort cp) throws IOException {
        this.close();
        this.m_CommPort = cp;
        if (cp != null) {
            this.prepareStreams(cp.getInputStream(), cp.getOutputStream());
        }
    }

    public boolean isEcho() {
        return this.m_Echo;
    }

    public void setEcho(boolean b) {
        this.m_Echo = b;
    }

    public void setReceiveThreshold(int th) {
        try {
            this.m_CommPort.enableReceiveThreshold(th);
        }
        catch (UnsupportedCommOperationException e) {
            logger.warn("Failed to setReceiveThreshold: {}", (Object)e.getMessage());
        }
    }

    public void setReceiveTimeout(int ms) {
        try {
            this.m_CommPort.enableReceiveTimeout(ms);
        }
        catch (UnsupportedCommOperationException e) {
            logger.warn("Failed to setReceiveTimeout: {}", (Object)e.getMessage());
        }
    }

    public void readEcho(int len) throws IOException {
        byte[] echoBuf = new byte[len];
        this.setReceiveThreshold(len);
        int echoLen = this.m_CommPort.getInputStream().read(echoBuf, 0, len);
        logger.debug("Echo: {}", (Object)ModbusUtil.toHex(echoBuf, 0, echoLen));
        this.m_CommPort.disableReceiveThreshold();
        if (echoLen != len) {
            String errMsg = "Echo not received";
            logger.debug("Transmit {}", (Object)"Echo not received");
            throw new IOException("Echo not received");
        }
    }
}

